/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.pa.DisplayPaTemplateTypeEnum;
import com.kingdee.eas.fi.gr.pa.PaTemplateTypeCollection;
import com.kingdee.eas.fi.gr.pa.PaTemplateTypeFactory;
import com.kingdee.eas.fi.gr.pa.PaTemplateTypeInfo;
import com.kingdee.eas.fi.gr.pa.app.AbstractPaTemplateTypeControllerBean;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PaTemplateTypeControllerBean
extends AbstractPaTemplateTypeControllerBean {
    private static final long serialVersionUID = 4818501030473909865L;
    private static final BOSUuid ROOT_ID = BOSUuid.read((String)"111111111111111111111111111=");

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
        PaTemplateTypeInfo info = PaTemplateTypeFactory.getLocalInstance(ctx).getPaTemplateTypeInfo((IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()));
        FilterInfo lNfilter = new FilterInfo();
        lNfilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)treeBaseInfo.getLongNumber()));
        lNfilter.getFilterItems().add(new FilterItemInfo("id", (Object)treeBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        StringBuffer maskString = new StringBuffer("#0 AND #1");
        int reportType = info.getPaTmpType().getValue();
        lNfilter.getFilterItems().add(new FilterItemInfo("paTmpType", (Object)new Integer(reportType)));
        maskString.append("and #2 ");
        lNfilter.setMaskString(maskString.toString());
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            lNfilter.mergeFilter(filterCU, "AND");
        }
        if (this.exists(ctx, lNfilter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeBaseInfo.getNumber()});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PaTemplateTypeInfo treeModel = (PaTemplateTypeInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        if (treeModel.innerGetParent() == null) {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
            StringBuffer maskString = new StringBuffer("#0 and #1 ");
            int reportType = treeModel.getPaTmpType().getValue();
            filter.getFilterItems().add(new FilterItemInfo("paTmpType", (Object)new Integer(reportType)));
            maskString.append("and #2 ");
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                maskString.append(" and #").append(filter.getFilterItems().size() - 1);
            }
            filter.setMaskString(maskString.toString());
        } else {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            if (treeModel.innerGetParent().getId() != null) {
                filterItem = new FilterItemInfo("parent", (Object)treeModel.innerGetParent().getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1");
            }
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                if (treeModel.innerGetParent().getId() != null) {
                    filter.setMaskString("#0 and #1 and #2");
                } else {
                    filter.setMaskString("#0 and #1");
                }
            }
            int reportType = treeModel.getPaTmpType().getValue();
            filter.getFilterItems().add(new FilterItemInfo("paTmpType", (Object)new Integer(reportType)));
            StringBuffer maskString = new StringBuffer(filter.getMaskString());
            int index = filter.getFilterItems().size() - 1;
            maskString.append(" and #").append(index++);
            filter.setMaskString(maskString.toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        PaTemplateTypeCollection results = this.getPaTemplateTypeCollection(ctx, view);
        if (results != null && results.size() > 0) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeModel.getNumber()});
        }
    }

    @Override
    protected void _updateDisplayType(Context ctx, String currentid, String parentId, DisplayPaTemplateTypeEnum type) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CSL_PaTemplate set FDisplayTemplateTypeID= ? \n").append(" where FDisplayTemplateTypeId = ? ");
        String sqlString = sql.toString();
        if (parentId == null) {
            sqlString = sqlString.replaceFirst("\\?", "NULL");
            Object[] params = new Object[]{currentid};
            DbUtil.execute((Context)ctx, (String)sqlString, (Object[])params);
        } else {
            Object[] params = new Object[]{parentId, currentid};
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        }
    }

    @Override
    protected void _moveDisplayTypeBatch(Context ctx, List templateIds, String targetType, DisplayPaTemplateTypeEnum type) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CSL_PaTemplate set FDisplayTemplateTypeId= ? \n").append(" where FID in  \n ");
        sql.append(this.createInCondition(templateIds.iterator()));
        String sqlString = sql.toString();
        if (targetType == null) {
            sqlString = sqlString.replaceFirst("\\?", "NULL");
            DbUtil.execute((Context)ctx, (String)sqlString);
        } else {
            Object[] params = new Object[]{targetType};
            DbUtil.execute((Context)ctx, (String)sqlString, (Object[])params);
        }
    }

    private String createInCondition(Iterator iterator) {
        boolean first = true;
        StringBuffer sql = new StringBuffer("(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" '").append(iterator.next()).append("' ");
                first = false;
                continue;
            }
            sql.append(" ,'").append(iterator.next()).append("' ");
        }
        sql.append(") ");
        return sql.toString();
    }

    @Override
    protected List _checkSubTypeNumber(Context ctx, List parentids, List subOrgGroupIds) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String parentIdSql = this.createInCondition(parentids.iterator());
        String subOrgIdSql = this.createInCondition(subOrgGroupIds.iterator());
        sql.append("select type.FID as id from T_CSL_PaTemplate type \n").append("where type.FLongNumber in (\n").append("select t2.FLongNumber from T_CSL_PaTemplate t2 \n").append("where t2.FId in ").append(parentIdSql).append(" \n").append(" )").append("and type.FOrgUnitId in ").append(subOrgIdSql);
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (row.next()) {
                result.add(row.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    @Override
    protected void _addTypeBySubOrgGroup(Context ctx, PaTemplateTypeCollection sourceTypes, List subOrgGroupIds) throws BOSException, EASBizException {
        ArrayList<String> parentIds = new ArrayList<String>();
        Iterator i = sourceTypes.iterator();
        while (i.hasNext()) {
            PaTemplateTypeInfo info = (PaTemplateTypeInfo)i.next();
            if (info.getParent() != null) continue;
            parentIds.add(info.getId().toString());
        }
        List existIds = this._checkSubTypeNumber(ctx, parentIds, subOrgGroupIds);
        ArrayList<String> deleteIds = new ArrayList<String>();
        if (existIds != null && existIds.size() > 0) {
            Iterator i2 = existIds.iterator();
            while (i2.hasNext()) {
                String id = i2.next().toString();
                deleteIds.add(id);
                deleteIds.addAll(this.getAllChildrenIds(ctx, id));
            }
            this.deleteAll(ctx, deleteIds);
        }
        Map indexedMap = this.indexByParent(sourceTypes);
        Iterator orgIterator = subOrgGroupIds.iterator();
        while (orgIterator.hasNext()) {
            FullOrgUnitInfo unit = new FullOrgUnitInfo();
            unit.setId(BOSUuid.read((String)orgIterator.next().toString()));
            List firstLevel = (List)indexedMap.get(ROOT_ID.toString());
            for (PaTemplateTypeInfo templateTypeInfo : firstLevel) {
                this.insert(ctx, templateTypeInfo, null, indexedMap, unit);
            }
        }
    }

    private void insert(Context ctx, PaTemplateTypeInfo sourceInfo, PaTemplateTypeInfo parent, Map infos, FullOrgUnitInfo unint) throws EASBizException, BOSException {
        List childreList = (List)infos.get(sourceInfo.getId().toString());
        BOSUuid newId = BOSUuid.create((BOSObjectType)sourceInfo.getBOSType());
        PaTemplateTypeInfo targetInfo = (PaTemplateTypeInfo)sourceInfo.clone();
        targetInfo.setId(newId);
        targetInfo.setOrgUnit(unint);
        if (targetInfo.getParent() != null) {
            targetInfo.setParent(parent);
        }
        if (childreList != null) {
            for (PaTemplateTypeInfo childType : childreList) {
                this.insert(ctx, childType, targetInfo, infos, unint);
            }
        }
    }

    private Map indexByParent(PaTemplateTypeCollection types) {
        Iterator iterator = types.iterator();
        HashMap result = new HashMap(types.size());
        ArrayList<PaTemplateTypeInfo> firstLevelList = new ArrayList<PaTemplateTypeInfo>();
        String firstLevel = ROOT_ID.toString();
        result.put(firstLevel, firstLevelList);
        while (iterator.hasNext()) {
            PaTemplateTypeInfo type = (PaTemplateTypeInfo)iterator.next();
            if (type.getParent() == null) {
                firstLevelList.add(type);
                continue;
            }
            String parentId = type.getParent().getId().toString();
            ArrayList<PaTemplateTypeInfo> childrenList = (ArrayList<PaTemplateTypeInfo>)result.get(parentId);
            if (childrenList == null) {
                childrenList = new ArrayList<PaTemplateTypeInfo>();
                childrenList.add(type);
                result.put(parentId, childrenList);
                continue;
            }
            childrenList.add(type);
        }
        return result;
    }

    private void deleteAll(Context ctx, List deleteIds) throws BOSException {
        String sql = "delete from T_CSL_PaTemplate where FID in " + this.createInCondition(deleteIds.iterator());
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private List getAllChildrenIds(Context ctx, String infoId) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        String selectInfo = "Select FLongNumber, FCONTROLUNITID, FPaTmpType, FOrgUnitId from T_CSL_PaTemplate where FID=?";
        Object[] param = new Object[]{infoId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectInfo, (Object[])param);
        try {
            if (!rowSet.next()) {
                return result;
            }
            String longNumber = rowSet.getString("FLongNumber");
            String cu = rowSet.getString("FCONTROLUNITID");
            int type = rowSet.getInt("FPaTmpType");
            String orgUnitId = rowSet.getString("FOrgUnitId");
            StringBuffer sql = new StringBuffer();
            ArrayList<Object> params = new ArrayList<Object>();
            sql.append("select Fid from T_CSL_PaTemplate \n");
            sql.append("where FLongNumber like ? \n");
            params.add(longNumber + "!%");
            sql.append("and FCONTROLUNITID = ? \n");
            params.add(cu);
            sql.append("and FPaTmpType = ? \n");
            params.add(new Integer(type));
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            while (row.next()) {
                result.add(row.getString("Fid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }
}

