/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.formula.zhRef;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.BookIOUtil;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.pa.IPaReport;
import com.kingdee.eas.fi.gr.pa.PaReportCollection;
import com.kingdee.eas.fi.gr.pa.PaReportFactory;
import com.kingdee.eas.fi.gr.pa.PaRptTmpTypeEnum;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.batch.ExceptionSeter;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ZhRefBatchCalculater {
    private ICalculateContextProvider context;
    private ChecFmlParamPermissionUtil pmc;
    private ReportVariables reportVariables;
    Context ServerCtx;
    HashMap map3;
    private boolean needCheck;
    private static final Logger logger = Logger.getLogger(ZhRefBatchCalculater.class);

    public ZhRefBatchCalculater(ICalculateContextProvider calContext, Context _serverCtx) {
        block2: {
            this.ServerCtx = null;
            this.map3 = new HashMap();
            this.needCheck = false;
            this.context = calContext;
            this.ServerCtx = _serverCtx;
            this.pmc = ChecFmlParamPermissionUtil.getInstance((ICalculateContextProvider)calContext);
            this.reportVariables = calContext.getReportVariables();
            try {
                boolean[] values = CSLParamUtil.batchGetParam(this.ServerCtx, new String[]{"GR_CSL_REPORT_CHECK"});
                this.needCheck = values[0];
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)e);
            }
        }
    }

    public void execute(SortedParameterArray params) {
        try {
            ZhRef ref;
            int i;
            ArrayList<ZhRef> refs = new ArrayList<ZhRef>(params.size());
            HashSet<String> allCheckFIOrgUnits = new HashSet<String>();
            HashSet<String> allCheckFIOrgUnitsByLongNumber = new HashSet<String>();
            HashSet<String> allCheckFIOrgTrees = new HashSet<String>();
            HashMap exceptHandlers = new HashMap();
            for (i = 0; i < params.size(); ++i) {
                ref = new ZhRef(params.getParameter(i));
                refs.add(ref);
                if (!StringUtils.isEmpty((String)ref.fiOrgTree)) {
                    allCheckFIOrgTrees.add(ref.fiOrgTree);
                }
                if (ref.fiOrgUnit.indexOf("!") >= 0) {
                    allCheckFIOrgUnitsByLongNumber.add(ref.fiOrgUnit);
                } else {
                    allCheckFIOrgUnits.add(ref.fiOrgUnit);
                }
                if (exceptHandlers.containsKey(ref.fiOrgUnit)) {
                    ((Collection)exceptHandlers.get(ref.fiOrgUnit)).add(ref);
                    continue;
                }
                ArrayList<ZhRef> handlers = new ArrayList<ZhRef>();
                handlers.add(ref);
                exceptHandlers.put(ref.fiOrgUnit, handlers);
            }
            if (this.pmc != null) {
                this.pmc.checkUnitCompPermision(allCheckFIOrgUnits, allCheckFIOrgTrees, exceptHandlers);
                this.pmc.checkUnitCompPermissionForLongNumber(allCheckFIOrgUnitsByLongNumber, allCheckFIOrgTrees, exceptHandlers);
            }
            for (i = 0; i < refs.size(); ++i) {
                block14: {
                    ref = (ZhRef)refs.get(i);
                    try {
                        if (ref.formulaValue._exception != null) {
                        }
                        break block14;
                    }
                    catch (Throwable a) {
                        ref.formulaValue.setException(a);
                        ref.formulaValue.submit();
                    }
                    continue;
                }
                if (ref.formulaValue._exception != null) continue;
                String key = ref.year + "|" + ref.period + "|" + ref.fiOrgTree + "|" + ref.fiOrgUnit + "|" + ref.currency + "|" + ref.tempCode + "|" + ref.PaTempType;
                ArrayList<ZhRef> list = (ArrayList<ZhRef>)this.map3.get(key);
                if (list == null) {
                    list = new ArrayList<ZhRef>();
                    this.map3.put(key, list);
                }
                list.add(ref);
            }
            this.execute();
        }
        catch (Exception e) {
            for (int i = 0; i < params.size(); ++i) {
                params.getParameter(i).setValue((Object)new SyntaxErrorException(128L, (Object)e));
            }
        }
    }

    private void execute() {
        if (this.map3.values().size() > 0) {
            for (ArrayList list : this.map3.values()) {
                int i;
                ZhRef ref = (ZhRef)list.get(0);
                IObjectCollection c = null;
                try {
                    c = this.getReportCollection(this.ServerCtx, ref.fiOrgTree, ref.fiOrgUnit, ref.year, ref.period, ref.currency, ref.tempCode, ref.PaTempType);
                }
                catch (Exception e) {
                    for (i = 0; i < list.size(); ++i) {
                        ZhRef obj = (ZhRef)list.get(i);
                        obj.formulaValue.setException(e);
                    }
                }
                if (c != null && c.size() > 0) {
                    for (int i2 = 0; i2 < 1; ++i2) {
                        ReportBaseInfo report = (ReportBaseInfo)c.iterator().next();
                        this.saveDataToFile(report);
                        this.loadData(list, report.getData());
                    }
                    continue;
                }
                boolean tableInnerCheck = new Boolean(this.reportVariables.getStringValue("tableInnerCheck", null));
                if (this.needCheck || !tableInnerCheck) continue;
                for (i = 0; i < list.size(); ++i) {
                    ZhRef refEX = (ZhRef)list.get(i);
                    refEX.formulaValue.setException(new EASBizException(new NumericExceptionSubItem("1", "REPORT IS NULL")));
                }
            }
            this.submit(this.map3);
        }
    }

    private void saveDataToFile(ReportBaseInfo reportInfo) {
        String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
        if (!StringUtils.isEmpty((String)easInstanceHome) && DebugLogger.isDebug) {
            try {
                IOHelper.saveDataToFile((byte[])reportInfo.getData(), (String)(easInstanceHome + "/ZhRefBatchCalculate.data"));
            }
            catch (Exception e) {
                logger.error((Object)"saveDataToFile", (Throwable)e);
            }
        }
    }

    private void loadData(ArrayList list, byte[] data) {
        if (list == null) {
            return;
        }
        HashMap map = this.createMap(list);
        try {
            BookIOUtil.loadSomeCellValues((byte[])data, (HashMap)map);
        }
        catch (Exception e) {
            for (int i = 0; i < list.size(); ++i) {
                ZhRef ref = (ZhRef)list.get(i);
                ref.formulaValue.setException(e);
            }
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ZhRef ref = (ZhRef)list.get(i);
            Object object = map.get(ref.getCellRefAddr());
            if (!(object instanceof Variant)) {
                object = new Variant(object);
            }
            ref.formulaValue.setValue(object);
        }
    }

    private HashMap createMap(ArrayList list) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < list.size(); ++i) {
            map.put(((ZhRef)list.get(i)).getCellRefAddr(), null);
        }
        return map;
    }

    private void submit(HashMap map) {
        for (ArrayList list : map.values()) {
            for (int i = 0; i < list.size(); ++i) {
                ((ZhRef)list.get((int)i)).formulaValue.submit();
            }
        }
    }

    private IObjectCollection getReportCollection(Context ctx, String treeNumber, String orgUnitNumber, int iYear, int iPeriod, String currencyNumber, String templateNumber, String paTempType) throws BOSException, EASBizException {
        String[] strs = orgUnitNumber.split("\\!");
        String orgTreeNumber = treeNumber;
        if (strs.length == 2) {
            orgTreeNumber = strs[0];
            orgUnitNumber = strs[1];
        } else if (!(this.context.getReportAdapter() instanceof RptReportPropertyAdapter) && StringUtils.isEmpty((String)orgTreeNumber)) {
            orgTreeNumber = this.getOrgTree_Number();
        }
        PaRptTmpTypeEnum tmpType = PaRptTmpTypeEnum.getEnum(paTempType);
        if (tmpType == null) {
            throw new BOSException(RptUtil.getReportResource((String)"Valide_SourceType"));
        }
        Integer rptTmpType = new Integer(tmpType.getValue());
        IPaReport paReport = PaReportFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)new Integer(iYear)));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(iPeriod)));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)orgUnitNumber));
        filter.getFilterItems().add(new FilterItemInfo("currency.number", (Object)currencyNumber));
        filter.getFilterItems().add(new FilterItemInfo("Patemplate.number", (Object)templateNumber));
        filter.getFilterItems().add(new FilterItemInfo("Patemplate.templateType", (Object)rptTmpType));
        filter.getFilterItems().add(new FilterItemInfo("orgTree.number", (Object)orgTreeNumber));
        String maskString = "#0 and #1 and #2 and #3 and #4 and #5 and #6";
        filter.setMaskString(maskString);
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("data"));
        PaReportCollection objCL = paReport.getPaReportCollection(view);
        return objCL;
    }

    private String getOrgTree_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("CSLReport_OrgTree_Number");
    }

    private int getReport_PeriodType() {
        Integer period = (Integer)this.context.getReportAdapter().getReportProperty("PeriodType");
        if (period == null) {
            return -1;
        }
        return period;
    }

    private String makeValidOrgcode(String orgCode) {
        if ((orgCode == null || orgCode.length() < 1) && StringUtils.isEmpty((String)(orgCode = this.getOrgUnit_Number()))) {
            orgCode = this.getCompany_Number();
        }
        return orgCode;
    }

    private String getOrgUnit_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("OrgUnit.Number");
    }

    private String getCompany_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("Company.Number");
    }

    public void checkUnitCompPermision(String unit) throws ReportException, BOSException {
        ChecFmlParamPermissionUtil perm = this.pmc;
        if (perm != null) {
            perm.checkUnitCompPermision(unit);
        }
    }

    class CalculateBackFiller {
        private Throwable _exception = null;
        private ArrayList vlist = new ArrayList();
        Parameter param;

        public CalculateBackFiller(Parameter _param) {
            this.param = _param;
        }

        public void setValue(Object value) {
            if (value == null) {
                return;
            }
            this.vlist.add(value);
        }

        public void setException(Throwable exception) {
            this._exception = exception;
            this.setException(this.param, exception);
        }

        public void setException(Parameter p, Throwable e) {
            IErrorProvider errorProvider = ReportCalculateErrorProvider.getErrorProvider(e.getClass());
            if (errorProvider != null && e instanceof Exception) {
                Object value = errorProvider.getProperValue((Exception)e).getValue();
                try {
                    value = new BigDecimal(value.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                p.setValue(value);
            } else {
                p.setValue((Object)("#BAD FUNCTION " + e.getMessage()));
            }
        }

        void submit() {
            if (this._exception != null) {
                IErrorProvider errorProvider = ReportCalculateErrorProvider.getErrorProvider(this._exception.getClass());
                if (errorProvider != null && this._exception instanceof Exception) {
                    Object value = errorProvider.getProperValue((Exception)this._exception).getValue();
                    try {
                        value = new BigDecimal(value.toString());
                        this.param.setValue(value);
                    }
                    catch (Exception e) {
                        FormulaValueBackfill backFill = new FormulaValueBackfill(this.param);
                        backFill.setException(this._exception);
                    }
                } else {
                    FormulaValueBackfill backFill = new FormulaValueBackfill(this.param);
                    backFill.setException(this._exception);
                }
            } else if (this.vlist.size() == 0) {
                this.param.setValue((Object)Variant.nullVariant);
            } else if (this.vlist.size() == 1) {
                this.param.setValue(this.vlist.get(0));
            } else {
                ArrayList<BigDecimal> bList = new ArrayList<BigDecimal>();
                boolean isAllNumber = true;
                for (int i = 0; i < this.vlist.size(); ++i) {
                    try {
                        bList.add(new BigDecimal(this.vlist.get(i).toString()));
                        continue;
                    }
                    catch (Exception e) {
                        isAllNumber = false;
                        break;
                    }
                }
                if (isAllNumber) {
                    BigDecimal r = new BigDecimal("0");
                    for (int i = 0; i < bList.size(); ++i) {
                        r = r.add((BigDecimal)bList.get(i));
                    }
                    this.param.setValue((Object)r);
                } else {
                    StringBuffer buf = new StringBuffer();
                    for (int j = 0; j < this.vlist.size(); ++j) {
                        Object temp = this.vlist.get(j);
                        if (temp == null) continue;
                        if (temp instanceof Calendar) {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                            buf.append(format.format(((Calendar)temp).getTime()));
                            continue;
                        }
                        buf.append(temp.toString());
                    }
                    this.param.setValue((Object)buf.toString());
                }
            }
        }
    }

    private class ZhRef
    implements ExceptionSeter {
        String fiOrgTree;
        String fiOrgUnit;
        int year;
        int period;
        String currency;
        String tempCode;
        String PaTempType;
        String sheetName;
        String cellName;
        CalculateBackFiller formulaValue;

        String getCellRefAddr() {
            return (this.sheetName + "!" + this.cellName).toUpperCase();
        }

        public ZhRef(Parameter param) {
            this.formulaValue = new CalculateBackFiller(param);
            Object[] params = param.getArgs();
            if (params[0] instanceof Object[]) {
                params = (Object[])params[0];
            }
            int index = 0;
            if (params.length >= 9) {
                this.fiOrgTree = ((Variant)params[index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
                ++index;
            }
            this.fiOrgUnit = ((Variant)params[index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            this.fiOrgUnit = ZhRefBatchCalculater.this.makeValidOrgcode(this.fiOrgUnit);
            ++index;
            try {
                ZhRefBatchCalculater.this.checkUnitCompPermision(this.fiOrgUnit);
            }
            catch (Exception ex) {
                this.formulaValue.setException(ex);
            }
            String string = this.tempCode = ((Variant)params[index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            if (StringUtils.isEmpty((String)this.tempCode)) {
                this.formulaValue.setException(new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"57_CsRefBatchCalculater", (Locale)ZhRefBatchCalculater.this.ServerCtx.getLocale())}));
                return;
            }
            this.PaTempType = ((Variant)params[++index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            ++index;
            try {
                this.year = Integer.parseInt(((Variant)params[index]).getValue().toString());
                ++index;
            }
            catch (Exception ex) {
                this.formulaValue.setException(new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"58_CsRefBatchCalculater", (Locale)ZhRefBatchCalculater.this.ServerCtx.getLocale())}));
                return;
            }
            try {
                this.period = Integer.parseInt(((Variant)params[index]).getValue().toString());
                ++index;
            }
            catch (Exception ex) {
                this.formulaValue.setException(new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"59_CsRefBatchCalculater", (Locale)ZhRefBatchCalculater.this.ServerCtx.getLocale())}));
                return;
            }
            int curYear = 0;
            int curPeriod = 0;
            int int_periodType = 0;
            curYear = (Integer)ZhRefBatchCalculater.this.context.getReportAdapter().getReportProperty("Report.Year");
            curPeriod = (Integer)ZhRefBatchCalculater.this.context.getReportAdapter().getReportProperty("Report.Period");
            int_periodType = ZhRefBatchCalculater.this.getReport_PeriodType();
            if (this.year == 0) {
                this.year = curYear;
            }
            if (this.period == 0) {
                this.period = curPeriod;
            }
            int[] arrYearAndPeriod = null;
            arrYearAndPeriod = RPTDateUtil.getRptYearAndPeriod(curYear, curPeriod, int_periodType, this.year, this.period);
            if (arrYearAndPeriod == null) {
                this.year = curYear;
                this.period = curPeriod;
            } else {
                this.year = arrYearAndPeriod[0];
                this.period = arrYearAndPeriod[1];
            }
            this.sheetName = ((Variant)params[index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            this.cellName = ((Variant)params[++index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            String string2 = this.currency = ((Variant)params[++index]).getValue() == null ? null : ((Variant)params[index]).getValue().toString();
            if (this.currency == null || this.currency.trim().length() == 0) {
                this.currency = (String)ZhRefBatchCalculater.this.context.getReportAdapter().getReportProperty("Currency.Number");
            }
        }

        public void toSetException(Exception e) {
            this.formulaValue.setException(e);
            this.formulaValue.submit();
        }
    }
}

