/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.rptintegration.SynLogFactory;
import com.kingdee.eas.fi.gr.rptintegration.SynLogInfo;
import com.kingdee.eas.fi.gr.rptintegration.app.AbstractRptIntegrationFacadeControllerBean;
import com.kingdee.eas.fi.gr.rptintegration.util.DataCenterUtil;
import com.kingdee.eas.fi.gr.rptintegration.util.RptIntegrationUtils;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeHandle;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class RptIntegrationFacadeControllerBean
extends AbstractRptIntegrationFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.rptintegration.app.RptIntegrationFacadeControllerBean");

    @Override
    protected void _updateFullOrgUnit(Context ctx, IObjectCollection fullOrgUnitCollection) throws BOSException, EASBizException {
        if (fullOrgUnitCollection != null && fullOrgUnitCollection.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("update t_org_baseunit set ");
            sql.append("Fnumber = ? ,");
            sql.append("FisOUSealUp = ? ,");
            sql.append("fparentid = ? ,");
            sql.append("fcode = ? ,");
            sql.append("fname_").append(ctx.getLocale()).append(" = ? ");
            sql.append(" where fid=?");
            ArrayList<String[]> params = new ArrayList<String[]>();
            FullOrgUnitInfo info = null;
            for (int i = 0; i < fullOrgUnitCollection.size(); ++i) {
                info = (FullOrgUnitInfo)fullOrgUnitCollection.getObject(i);
                params.add(new String[]{info.getNumber(), info.isIsOUSealUp() ? "1" : "0", info.getParent().getId().toString(), info.getCode(), info.getName(), info.getId().toString()});
            }
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
        }
    }

    @Override
    protected void _addNewFullOrgUnit(Context ctx, IObjectCollection fullOrgUnitCollection) throws BOSException, EASBizException {
        CoreBaseCollection baseCols = new CoreBaseCollection();
        baseCols.addObjectCollection(fullOrgUnitCollection);
        if (baseCols.size() > 0) {
            UserInfo userInfo = this.getUserInfo(ctx);
            for (int i = 0; i < baseCols.size(); ++i) {
                this.setCreator(userInfo, baseCols.get(i));
            }
            FullOrgUnitFactory.getLocalInstance((Context)ctx).addnewBatchData(baseCols);
            FullOrgUnitInfo info = null;
            StringBuffer sql = new StringBuffer();
            StringBuffer where = new StringBuffer();
            where.append(" fid  in(");
            sql.append("  fid  in(");
            for (int i = 0; i < baseCols.size(); ++i) {
                info = (FullOrgUnitInfo)baseCols.get(i);
                if (info.getParent() == null || info.getParent().getId() == null) continue;
                sql.append("'").append(info.getParent().getId().toString()).append("',");
                where.append("'").append(info.getId()).append("',");
            }
            if (sql.lastIndexOf(",") > 0) {
                sql.deleteCharAt(sql.lastIndexOf(","));
                sql.append(")");
                where.deleteCharAt(where.lastIndexOf(","));
                where.append(")");
                DbUtil.execute((Context)ctx, (String)("update t_org_baseunit set fisleaf=0 where " + where.toString()));
                try {
                    RptIntegrationUtils.updateOrgUnitId(ctx, "t_org_baseunit", "FCONTROLUNITID", where.toString());
                    RptIntegrationUtils.updateOrgUnitId(ctx, "t_org_baseunit", "fparentid", null);
                    RptIntegrationUtils.updateOrgUnitId(ctx, "t_org_company", "fparentid", null);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            baseCols.clear();
        }
    }

    @Override
    protected void _saveOrgTree(Context ctx, IObjectValue orgTreeInfo, IObjectCollection orgStructureCollection, int operType) throws BOSException, EASBizException {
        OrgTreeInfo treeInfo = (OrgTreeInfo)orgTreeInfo;
        IOrgStructure orgStructureInteface = OrgStructureFactory.getLocalInstance((Context)ctx);
        if (orgStructureCollection != null && orgStructureCollection.size() > 0) {
            orgStructureInteface.delete("where tree='" + treeInfo.getId().toString() + "'");
            CoreBaseCollection baseColl = new CoreBaseCollection();
            baseColl.addObjectCollection(orgStructureCollection);
            orgStructureInteface.addnewBatchData(baseColl);
            baseColl.clear();
            this.saveRelFullOrgUnit(ctx, orgStructureCollection);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (operType == 1 && treeInfo != null) {
            CoreBaseCollection baseColl = new CoreBaseCollection();
            baseColl.add(this.setCreator(this.getUserInfo(ctx), (CoreBaseInfo)treeInfo));
            OrgTreeFactory.getLocalInstance((Context)ctx).addnewBatchData(baseColl);
            try {
                RptIntegrationUtils.updateControlUnitId(ctx, "t_org_tree");
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
            baseColl.clear();
        } else {
            StringBuffer sql = new StringBuffer();
            sql.append("update t_org_tree ");
            sql.append(" set FisHide=?, ");
            sql.append("fname_").append(ctx.getLocale()).append(" = ?, ");
            sql.append(" FstartDate=to_date(?), ");
            sql.append(" FendDate= to_date(?), ");
            sql.append(" Fstatus = ? ");
            sql.append(" where fid='").append(treeInfo.getId().toString()).append("'");
            String startDate = treeInfo.getStartDate() != null ? format.format(treeInfo.getStartDate()) : null;
            String endDate = treeInfo.getEndDate() != null ? format.format(treeInfo.getEndDate()) : null;
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{treeInfo.isIsHide() ? "1" : "0", treeInfo.getName(), startDate, endDate, String.valueOf(treeInfo.getStatus().getValue())});
        }
    }

    private void saveRelFullOrgUnit(Context ctx, IObjectCollection orgStructureCollection) throws BOSException, EASBizException {
        OrgStructureInfo info = (OrgStructureInfo)orgStructureCollection.getObject(0);
        if (!StringUtils.isEmpty((String)info.getUnit().getNumber())) {
            String topId = null;
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            StringBuffer deleteIds = new StringBuffer();
            StringBuffer ids = new StringBuffer();
            StringBuffer updateIds = new StringBuffer();
            for (int i = 0; i < orgStructureCollection.size(); ++i) {
                info = (OrgStructureInfo)orgStructureCollection.getObject(i);
                if (info.getUnit().isIsUnion()) {
                    deleteIds.append("'").append(info.getUnit().getId().toString()).append("',");
                } else {
                    updateIds.append("'").append(info.getUnit().getId().toString()).append("',");
                }
                ids.append("'").append(info.getUnit().getId().toString()).append("',");
                if (info.getLevel() > 1) continue;
                topId = info.getUnit().getId().toString();
            }
            if (deleteIds.length() > 0) {
                deleteIds.deleteCharAt(deleteIds.lastIndexOf(","));
                iFullOrgUnit.delete("where id in(" + deleteIds.toString() + ")");
            }
            if (ids.length() > 0) {
                ids.deleteCharAt(ids.lastIndexOf(","));
                FullOrgUnitCollection orgColl = iFullOrgUnit.getFullOrgUnitCollection("select id where id in (" + ids.toString() + ")");
                HashSet<String> existIds = new HashSet<String>();
                for (int i = 0; i < orgColl.size(); ++i) {
                    existIds.add(orgColl.get(i).getId().toString());
                }
                CoreBaseCollection baseColl = new CoreBaseCollection();
                for (int i = 0; i < orgStructureCollection.size(); ++i) {
                    info = (OrgStructureInfo)orgStructureCollection.getObject(i);
                    if (info.getUnit().getMaintainCU() == null) {
                        info.getUnit().setMaintainCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                    }
                    if (info.getUnit().getCU() == null) {
                        info.getUnit().setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                    }
                    if (info.getUnit().isIsUnion()) {
                        baseColl.add((CoreBaseInfo)info.getUnit());
                        continue;
                    }
                    if (existIds.contains(info.getUnit().getId().toString())) continue;
                    baseColl.add((CoreBaseInfo)info.getUnit());
                }
                if (baseColl.size() > 0) {
                    iFullOrgUnit.addnewBatchData(baseColl);
                    baseColl.clear();
                }
                try {
                    if (updateIds.length() > 0) {
                        updateIds.deleteCharAt(updateIds.lastIndexOf(","));
                        RptIntegrationUtils.updateOrgUnitId(ctx, "T_ORG_baseunit", "fparentid", "fid in(" + updateIds.toString() + ")");
                        RptIntegrationUtils.updateOrgUnitLongNumber(ctx, "T_ORG_baseunit", "fid in(" + updateIds.toString() + ")", null);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"updateOrgUnitId error.", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected void _saveSynUpdate(Context ctx, BOSObjectType bosType, List addObjectList, List deletePkList, List updateObjectList, List synLogList, String extProperties) throws BOSException, EASBizException {
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        CoreBaseCollection coreBases = new CoreBaseCollection();
        UserInfo userInfo = this.getUserInfo(ctx);
        if (addObjectList != null && addObjectList.size() > 0) {
            for (Object info : addObjectList) {
                coreBases.add(this.setCreator(userInfo, (CoreBaseInfo)info));
            }
            try {
                RptIntegrationUtils.addnewBatchData(ctx, coreBases);
            }
            catch (Exception e) {
                logger.error((Object)"RptIntegrationUtils.addnewBatchData error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            coreBases.clear();
        }
        if (deletePkList != null && deletePkList.size() > 0) {
            iCoreBase.delete("where id in(" + CslRptUtil.list2String(deletePkList, ",", true) + ")");
        }
        if (updateObjectList != null && updateObjectList.size() > 0) {
            for (Object info : updateObjectList) {
                coreBases.add(this.setCreator(userInfo, (CoreBaseInfo)info));
            }
            iCoreBase.updateBatchData(coreBases);
            coreBases.clear();
        }
        String bosTypeNumber = bosType.toString();
        if (extProperties != null) {
            bosTypeNumber = bosTypeNumber + bosTypeNumber + extProperties;
        }
        if (synLogList != null && synLogList.size() > 0) {
            SynLogInfo synLog = null;
            for (Object curId : synLogList) {
                synLog = new SynLogInfo();
                synLog.setSynType(bosTypeNumber);
                synLog.setSynEntityId(curId.toString());
                coreBases.add((CoreBaseInfo)synLog);
            }
            if (coreBases.size() > 0) {
                SynLogFactory.getLocalInstance(ctx).delete("where synType='" + bosTypeNumber + "'");
                try {
                    RptIntegrationUtils.addnewBatchData(ctx, coreBases);
                }
                catch (Exception e) {
                    logger.error((Object)"RptIntegrationUtils.addnewBatchData error", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                coreBases.clear();
            }
        }
    }

    @Override
    protected boolean _synchronizeByType(Context ctx, List synchronizeTypeList, List dataCenterList) throws BOSException, EASBizException {
        boolean result = true;
        if (synchronizeTypeList != null && synchronizeTypeList.size() > 0) {
            try {
                List<WebServiceInfo> webServices = null;
                WebServiceClient webServiceClient = WebServiceClient.getInstance();
                if (dataCenterList == null || dataCenterList.size() <= 0) {
                    WebServiceInfo xbangServiceInfo = DataCenterUtil.getParentServiceInfo(ctx);
                    webServices = new ArrayList<WebServiceInfo>();
                    webServices.add(xbangServiceInfo);
                } else {
                    webServices = DataCenterUtil.getWebservicesById(ctx, dataCenterList);
                }
                for (WebServiceInfo webService : webServices) {
                    SynchronizeHandle synHandle = null;
                    for (String synType : synchronizeTypeList) {
                        synHandle = SynchronizeType.getSynType2HandleObject().get(synType);
                        if (synHandle == null) continue;
                        synHandle.sourceDataCenterHandle(ctx, null, webServiceClient, webService);
                    }
                }
            }
            catch (Exception ex) {
                result = false;
                logger.error((Object)("synchronizeByType:" + synchronizeTypeList.toString()), (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
        }
        return result;
    }

    private CoreBaseInfo setCreator(UserInfo userInfo, CoreBaseInfo info) {
        if (info instanceof ObjectBaseInfo) {
            ObjectBaseInfo objectInfo = (ObjectBaseInfo)info;
            objectInfo.setCreator(userInfo);
            objectInfo.setLastUpdateUser(userInfo);
            return objectInfo;
        }
        return info;
    }

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    @Override
    protected Object _callMethodServer(Context ctx, WebServiceInfo webServiceInfo) throws BOSException, EASBizException {
        WebServiceClient webServiceClient = WebServiceClient.getInstance();
        try {
            return webServiceClient.callMethodForWebService(webServiceInfo);
        }
        catch (Exception e) {
            logger.error((Object)"_callMethodServer error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

