/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.util.synchronize.download.orgTree;

import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.OrgRangeIncludeSubOrgInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTree;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.basedata.org.UnionVersionStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.VersionCheckFacadeFactory;
import com.kingdee.eas.fi.gr.rptintegration.ISynLog;
import com.kingdee.eas.fi.gr.rptintegration.OrgTreeExtInfo;
import com.kingdee.eas.fi.gr.rptintegration.RptIntegrationFacadeFactory;
import com.kingdee.eas.fi.gr.rptintegration.SynLogCollection;
import com.kingdee.eas.fi.gr.rptintegration.SynLogFactory;
import com.kingdee.eas.fi.gr.rptintegration.SynLogInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.GenerateIdInterface;
import com.kingdee.eas.fi.gr.rptintegration.util.NormalGenerateIdImpl;
import com.kingdee.eas.fi.gr.rptintegration.util.ResultInfo;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.download.CoverDeleteSynOperate;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.download.SynOperateByDownLoadUtils;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceClient;
import com.kingdee.eas.fi.gr.rptintegration.webservice.WebServiceInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgTreeChildWSUtil
extends SynOperateByDownLoadUtils {
    private static final Logger logger = CoreUIObject.getLogger(OrgTreeChildWSUtil.class);

    @Override
    public ResultInfo sourceDataCenterHandleByDownLoad(Context ctx, String[] args, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        ResultInfo result = new ResultInfo();
        String numberInstrs = null;
        if (args != null && args.length > 3) {
            numberInstrs = args[2];
        }
        HashMap<String, OrgTreeInfo> curOrgTreeMap = new HashMap<String, OrgTreeInfo>();
        try {
            StringBuffer oql = new StringBuffer();
            oql.append("select ").append(this.getSelectStr(ctx)).append(" where type=8 ");
            if (!StringUtils.isEmpty((String)numberInstrs)) {
                oql.append(" and number in(").append(numberInstrs).append(")");
            }
            oql.append(" order by createtime");
            OrgTreeCollection orgTreeCol = ((IOrgTree)this.getBizInterface(ctx)).getOrgTreeCollection(oql.toString());
            for (int i = 0; i < orgTreeCol.size(); ++i) {
                curOrgTreeMap.put(orgTreeCol.get(i).getId().toString(), orgTreeCol.get(i));
            }
            orgTreeCol.clear();
            String whereStr = this.getWhereStr();
            if (!StringUtils.isEmpty((String)numberInstrs)) {
                whereStr = whereStr + " and number in(" + numberInstrs + ")";
            }
            String jsonString = this.getTargetDataStr(SynchronizeType.getOrgTreeTask, this.getSelectStr(null), whereStr, this.getOrderStr(), webServiceClient, xbangServiceInfo);
            Map<String, List<OrgTreeExtInfo>> diffOrgTreeMap = this.getDiffOrgTreeByString(ctx, args, jsonString, curOrgTreeMap, xbangServiceInfo, webServiceClient);
            StringBuffer log = new StringBuffer();
            log.append(" diffOrgTreeMap:");
            for (List<OrgTreeExtInfo> infos : diffOrgTreeMap.values()) {
                for (OrgTreeExtInfo info : infos) {
                    log.append(info.getOrgTreeInfo() != null ? info.getOrgTreeInfo().getId() + (info.getOrgTreeInfo().getStartDate() != null ? info.getOrgTreeInfo().getStartDate().toString() : "") : "").append(",").append(info.getOper()).append(info.isStart()).append(info.isUnStart()).append("\n");
                }
            }
            logger.error((Object)log.toString());
            if (diffOrgTreeMap != null && diffOrgTreeMap.size() > 0) {
                this.checkNumberDup(ctx, diffOrgTreeMap, result);
                Iterator<String> itr = diffOrgTreeMap.keySet().iterator();
                List<OrgTreeExtInfo> curOrgTreeExtList = null;
                while (itr.hasNext()) {
                    curOrgTreeExtList = diffOrgTreeMap.get(itr.next());
                    OrgTreeExtInfo treeExt = null;
                    for (int i = 0; i < curOrgTreeExtList.size(); ++i) {
                        treeExt = curOrgTreeExtList.get(i);
                        CslRptUtil.invokeByManual(this, "handleSingOrgTree", new Class[]{Context.class, OrgTreeExtInfo.class, List.class, Integer.TYPE, Map.class, ResultInfo.class, WebServiceClient.class, WebServiceInfo.class}, new Object[]{ctx, treeExt, curOrgTreeExtList, i, curOrgTreeMap, result, webServiceClient, xbangServiceInfo}, 3);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"sourceDataCenterHandleByPush error", (Throwable)ex);
            throw ex;
        }
        finally {
            curOrgTreeMap.clear();
        }
        return result;
    }

    public void handleSingOrgTree(Context ctx, OrgTreeExtInfo treeExt, List<OrgTreeExtInfo> curOrgTreeExtList, int index, Map<String, OrgTreeInfo> curOrgTreeMap, ResultInfo result, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        OrgStructureCollection orgStrurecols = new OrgStructureCollection();
        if (treeExt.isStructureChange()) {
            this.getParentOrgStructureByTree(ctx, treeExt.getOrgTreeInfo().getId().toString(), orgStrurecols, webServiceClient, xbangServiceInfo);
        }
        if (index + 1 < curOrgTreeExtList.size()) {
            if (curOrgTreeExtList.get(index + 1).isStart()) {
                treeExt.getOrgTreeInfo().setStatus(UnionVersionStatusEnum.START);
                treeExt.getOrgTreeInfo().setEndDate(null);
            } else if (curOrgTreeExtList.get(index + 1).isUnStart()) {
                treeExt.getOrgTreeInfo().setStatus(curOrgTreeMap.get(treeExt.getOrgTreeInfo().getId().toString()).getStatus());
                treeExt.getOrgTreeInfo().setEndDate(this.setTimeToDate(curOrgTreeMap.get(treeExt.getOrgTreeInfo().getId().toString()).getEndDate()));
            }
        }
        Timestamp startDate = null;
        if (treeExt.isStart()) {
            treeExt.getOrgTreeInfo().setStatus(UnionVersionStatusEnum.UNSTART);
            startDate = treeExt.getOrgTreeInfo().getStartDate();
            if (!treeExt.isUnStart()) {
                treeExt.getOrgTreeInfo().setStartDate(null);
            }
        }
        if (treeExt.isUnStart()) {
            treeExt.getOrgTreeInfo().setStatus(UnionVersionStatusEnum.START);
        }
        (ctx == null ? RptIntegrationFacadeFactory.getRemoteInstance() : RptIntegrationFacadeFactory.getLocalInstance(ctx)).saveOrgTree(treeExt.getOrgTreeInfo(), orgStrurecols, treeExt.getOper());
        if (treeExt.getOper() == 1) {
            CoverDeleteSynOperate synOperateIntf = (CoverDeleteSynOperate)SynchronizeType.getSynType2HandleObject().get(SynchronizeType.coverDeleteSyn);
            StringBuffer whereSql = new StringBuffer();
            whereSql.append("forgid in (select unit.fid from t_org_structure str inner join t_org_baseunit unit on unit.fid=str.funitid");
            whereSql.append(" where unit.fisunion=1 and str.ftreeid='").append(treeExt.getOrgTreeInfo().getId()).append("')");
            NormalGenerateIdImpl normalIntf = new NormalGenerateIdImpl(true, new OrgRangeIncludeSubOrgInfo().getBOSType().toString());
            synOperateIntf.coverSynTableByWhere(ctx, "*", whereSql.toString(), "T_PM_OrgRangeIncludeSubOrg", new GenerateIdInterface[]{normalIntf}, webServiceClient, xbangServiceInfo);
        }
        if (treeExt.isUnStart()) {
            Map curReult = (ctx == null ? UnionVersionControllerFacadeFactory.getRemoteInstance() : UnionVersionControllerFacadeFactory.getLocalInstance((Context)ctx)).unstart(treeExt.getOrgTreeInfo().getId().toString());
            this.HandleResult(ctx, curReult, result, treeExt.getOrgTreeInfo().toString());
        }
        logger.error((Object)("orgTree start:" + treeExt.getOrgTreeInfo().getId() + ":" + treeExt.isStart() + "-------------------"));
        if (treeExt.isStart()) {
            logger.error((Object)("orgTree start date:" + treeExt.getOrgTreeInfo().getId() + ":" + startDate + "-------------------"));
            Map startResult = (ctx == null ? UnionVersionControllerFacadeFactory.getRemoteInstance() : UnionVersionControllerFacadeFactory.getLocalInstance((Context)ctx)).start(treeExt.getOrgTreeInfo().getId().toString(), startDate);
            if (startResult != null && !((Boolean)startResult.get("state")).booleanValue()) {
                if (result.getStatus() == 0) {
                    result.setStatus(1);
                }
                StringBuffer msg = new StringBuffer();
                msg.append("\u5408\u5e76\u8303\u56f4\uff1a").append(treeExt.getOrgTreeInfo().toString()).append("\u542f\u7528\u5931\u8d25\uff0c\u8bf7\u624b\u5de5\u542f\u7528\n");
                msg.append(result.getMsgInfo());
                result.setMsgInfo(msg.toString());
            }
        }
    }

    public String getNumberInstr(Context ctx, String[] args) throws Exception {
        if (args != null && args.length > 3) {
            String ids = args[2];
            OrgTreeCollection orgTreeCol = ((IOrgTree)this.getBizInterface(ctx)).getOrgTreeCollection("select number where id in(" + ids + ")");
            HashSet<String> numbers = new HashSet<String>();
            for (int i = 0; i < orgTreeCol.size(); ++i) {
                numbers.add(orgTreeCol.get(i).getNumber());
            }
            return CslRptUtil.collection2String(numbers, ",", true);
        }
        return null;
    }

    private void checkNumberDup(Context ctx, Map<String, List<OrgTreeExtInfo>> diffOrgTreeMap, ResultInfo result) throws Exception {
        StringBuffer oql = new StringBuffer();
        List<OrgTreeExtInfo> orgTreeExtList = null;
        OrgTreeExtInfo orgTreeExtInfo = null;
        boolean isFirst = true;
        for (String number : diffOrgTreeMap.keySet()) {
            orgTreeExtList = diffOrgTreeMap.get(number);
            if (orgTreeExtList == null || orgTreeExtList.isEmpty() || (orgTreeExtInfo = orgTreeExtList.get(0)) == null || !orgTreeExtInfo.isNumberChange() && orgTreeExtInfo.getOper() != 1) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                oql.append("or");
            }
            oql.append(" (number='").append(number);
            oql.append("' and CU.id!='").append(orgTreeExtInfo.getOrgTreeInfo().getCU().getId().toString()).append("') ");
        }
        if (!isFirst) {
            String kql = "select id,number where " + oql.toString();
            CoreBaseCollection coll = this.getBizInterface(ctx).getCollection(kql);
            if (coll != null) {
                StringBuffer dupNumbers = new StringBuffer();
                for (int i = 0; i < coll.size(); ++i) {
                    diffOrgTreeMap.remove(((OrgTreeInfo)coll.get(i)).getNumber());
                    dupNumbers.append(((OrgTreeInfo)coll.get(i)).getNumber()).append(",");
                }
                if (dupNumbers.lastIndexOf(",") > 0) {
                    dupNumbers.deleteCharAt(dupNumbers.lastIndexOf(","));
                    if (!StringUtils.isEmpty((String)result.getMsgInfo())) {
                        result.setMsgInfo(result.getMsgInfo() + "\n" + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.rptintegration.RptIntegrationUIMsg", (String)"SubDataCenterExist"), dupNumbers.toString()));
                    } else {
                        result.setMsgInfo(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.rptintegration.RptIntegrationUIMsg", (String)"SubDataCenterExist"), dupNumbers.toString()));
                    }
                }
            }
        }
    }

    private void HandleResult(Context ctx, Map curReult, ResultInfo result, String orgTreeInfo) throws Exception {
        if (curReult != null) {
            curReult.put("isStart", false);
            String str = (ctx == null ? VersionCheckFacadeFactory.getRemoteInstance() : VersionCheckFacadeFactory.getLocalInstance(ctx)).getVersionCheckLog(curReult);
            str = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.gr.rptintegration.RptIntegrationUIMsg", (String)"OrgTreeSynError"), orgTreeInfo) + "\n" + str;
            if (result.getMsgInfo() != null) {
                str = result.getMsgInfo() + "\n\n" + str;
            }
            result.setMsgInfo(str);
            result.setStatus(1);
            throw new Exception(str);
        }
    }

    private void getParentOrgStructureByTree(Context ctx, String orgTreeId, OrgStructureCollection orgStrurecols, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        String selects = "tree.id,id,longNumber,level,isLeaf,unit,parent,isValid,displayName,sortCode";
        xbangServiceInfo.setArgs(new Object[]{SynchronizeType.getOrgStructure, new String[]{"'" + orgTreeId + "'", selects, "level"}});
        String orgStructureStr = (String)webServiceClient.callMethod(xbangServiceInfo);
        JSONArray jsoArr = new JSONArray(orgStructureStr);
        for (int i = 0; i < jsoArr.length(); ++i) {
            orgStrurecols.add((OrgStructureInfo)this.jsonStringToObject(null, jsoArr.getString(i), null));
        }
        this.handleBaseUnit(ctx, orgStrurecols, webServiceClient, xbangServiceInfo);
    }

    public void handleBaseUnit(Context ctx, OrgStructureCollection orgStrurecols, WebServiceClient webServiceClient, WebServiceInfo xbangServiceInfo) throws Exception {
        HashMap<String, OrgStructureInfo> orgStructMap = new HashMap<String, OrgStructureInfo>();
        for (int i = 0; i < orgStrurecols.size(); ++i) {
            orgStructMap.put(orgStrurecols.get(i).getUnit().getId().toString(), orgStrurecols.get(i));
        }
        FullOrgUnitCollection orgColl = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select id where id in (" + CslRptUtil.collection2String(orgStructMap.keySet(), ",", true) + ")");
        HashSet<String> existIds = new HashSet<String>();
        for (int i = 0; i < orgColl.size(); ++i) {
            existIds.add(orgColl.get(i).getId().toString());
        }
        for (String id : existIds) {
            orgStructMap.remove(id);
        }
        if (!orgStructMap.isEmpty()) {
            String idStr = CslRptUtil.collection2String(orgStructMap.keySet(), ",", true);
            StringBuffer ids = new StringBuffer();
            ids.append(" id in ( ");
            ids.append(idStr);
            ids.append(")");
            xbangServiceInfo.setArgs(new Object[]{SynchronizeType.getFullOrgUnitInfo, new String[]{this.getInfoPropertiesStr(ctx, new FullOrgUnitInfo().getBOSType()), ids.toString(), "id"}});
            String orgBaseUnitStr = (String)webServiceClient.callMethod(xbangServiceInfo);
            JSONArray jsoArr = new JSONArray(orgBaseUnitStr);
            for (int i = 0; i < jsoArr.length(); ++i) {
                FullOrgUnitInfo info = (FullOrgUnitInfo)this.jsonStringToObject(null, jsoArr.getString(i), null);
                ((OrgStructureInfo)orgStructMap.get(info.getId().toString())).setUnit(info);
            }
            CoverDeleteSynOperate synOperateIntf = (CoverDeleteSynOperate)SynchronizeType.getSynType2HandleObject().get(SynchronizeType.coverDeleteSyn);
            synOperateIntf.coverSynTableByWhere(ctx, "*", "fid in(" + idStr + ")", "T_ORG_UnionGroup", null, webServiceClient, xbangServiceInfo);
            synOperateIntf.coverSynTableByWhere(ctx, "*", "funitid in(" + idStr + ")", "T_ORG_OUPARTUNIONGROUP", null, webServiceClient, xbangServiceInfo);
        }
    }

    public Map<String, List<OrgTreeExtInfo>> getDiffOrgTreeByString(Context ctx, String[] args, String parentStr, Map<String, OrgTreeInfo> curOrgTreeMap, WebServiceInfo xbangServiceInfo, WebServiceClient webServiceClient) throws Exception {
        HashMap<String, List<OrgTreeExtInfo>> orgTreeMap = new HashMap<String, List<OrgTreeExtInfo>>();
        OrgTreeInfo parentOrgTreeInfo = null;
        OrgTreeInfo curOrgTreeInfo = null;
        OrgTreeExtInfo orgTreeExtInfo = null;
        ArrayList<OrgTreeInfo> existParentTreeList = new ArrayList<OrgTreeInfo>();
        HashMap<String, Object> parentIdMap = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)parentStr)) {
            JSONArray jsonArr = new JSONArray(parentStr);
            for (int i = 0; i < jsonArr.length(); ++i) {
                parentOrgTreeInfo = (OrgTreeInfo)this.jsonStringToObject(ctx, jsonArr.get(i).toString(), null);
                if (parentOrgTreeInfo == null) continue;
                curOrgTreeInfo = curOrgTreeMap.get(parentOrgTreeInfo.getId().toString());
                if (curOrgTreeInfo == null) {
                    orgTreeExtInfo = new OrgTreeExtInfo();
                    orgTreeExtInfo.setOrgTreeInfo(parentOrgTreeInfo);
                    orgTreeExtInfo.setOper(1);
                    orgTreeExtInfo.setStructureChange(true);
                    this.setStartANDUnStart(orgTreeExtInfo, parentOrgTreeInfo, curOrgTreeInfo);
                    this.putOrgTree(orgTreeMap, parentOrgTreeInfo.getNumber(), orgTreeExtInfo);
                } else {
                    parentOrgTreeInfo.setStartDate(this.setTimeToDate(parentOrgTreeInfo.getStartDate()));
                    parentOrgTreeInfo.setEndDate(this.setTimeToDate(parentOrgTreeInfo.getEndDate()));
                    curOrgTreeInfo.setStartDate(this.setTimeToDate(curOrgTreeInfo.getStartDate()));
                    curOrgTreeInfo.setEndDate(this.setTimeToDate(curOrgTreeInfo.getEndDate()));
                    if (!(OrgTreeChildWSUtil.isEquals(parentOrgTreeInfo.getStartDate(), curOrgTreeInfo.getStartDate()) && OrgTreeChildWSUtil.isEquals(parentOrgTreeInfo.getEndDate(), curOrgTreeInfo.getEndDate()) && OrgTreeChildWSUtil.isEquals(parentOrgTreeInfo.getLastUpdateTime(), curOrgTreeInfo.getLastUpdateTime()))) {
                        existParentTreeList.add(parentOrgTreeInfo);
                    }
                }
                parentIdMap.put(parentOrgTreeInfo.getId().toString(), null);
            }
        }
        if (args != null && args.length > 3) {
            StringBuffer delInIds = new StringBuffer();
            for (String curOrgTreeId : curOrgTreeMap.keySet()) {
                if (parentIdMap.containsKey(curOrgTreeId)) continue;
                delInIds.append("'").append(curOrgTreeId).append("',");
            }
            if (delInIds.length() > 0) {
                delInIds.deleteCharAt(delInIds.lastIndexOf(","));
                this.deleteOrgData(ctx, delInIds);
            }
        } else {
            this.handleDeleteSynAll(ctx, parentIdMap);
        }
        if (existParentTreeList.size() > 0) {
            ArrayList<String> preList = new ArrayList<String>();
            HashMap<String, Object> structChangeMap = new HashMap<String, Object>();
            for (OrgTreeInfo curOrgTree : existParentTreeList) {
                if (preList.size() > 4) {
                    this.checkOrgStructureChanged(ctx, args, preList, xbangServiceInfo, webServiceClient, structChangeMap);
                    preList.clear();
                }
                preList.add(curOrgTree.getId().toString());
            }
            if (preList.size() > 0) {
                this.checkOrgStructureChanged(ctx, args, preList, xbangServiceInfo, webServiceClient, structChangeMap);
            }
            preList.clear();
            for (OrgTreeInfo parentOrgTree : existParentTreeList) {
                curOrgTreeInfo = curOrgTreeMap.get(parentOrgTree.getId().toString());
                orgTreeExtInfo = null;
                if (structChangeMap.containsKey(parentOrgTree.getId().toString())) {
                    orgTreeExtInfo = new OrgTreeExtInfo();
                    orgTreeExtInfo.setStructureChange(true);
                    orgTreeExtInfo.setOper(3);
                }
                if (!(parentOrgTree.isIsHide() == curOrgTreeInfo.isIsHide() && OrgTreeChildWSUtil.isEquals(parentOrgTree.getName(), curOrgTreeInfo.getName()) && OrgTreeChildWSUtil.isEquals(parentOrgTree.getNumber(), curOrgTreeInfo.getNumber()) && OrgTreeChildWSUtil.isEquals(parentOrgTree.getStartDate(), curOrgTreeInfo.getStartDate()) && OrgTreeChildWSUtil.isEquals(parentOrgTree.getEndDate(), curOrgTreeInfo.getEndDate()) && OrgTreeChildWSUtil.isEquals(parentOrgTree.getStatus(), curOrgTreeInfo.getStatus()))) {
                    orgTreeExtInfo = orgTreeExtInfo == null ? new OrgTreeExtInfo() : orgTreeExtInfo;
                    this.setStartANDUnStart(orgTreeExtInfo, parentOrgTree, curOrgTreeInfo);
                    orgTreeExtInfo.setOper(2);
                    if (!OrgTreeChildWSUtil.isEquals(parentOrgTree.getNumber(), curOrgTreeInfo.getNumber())) {
                        orgTreeExtInfo.setNumberChange(true);
                    }
                }
                if (orgTreeExtInfo == null) continue;
                if (parentOrgTree.getStartDate() == null && orgTreeExtInfo.isUnStart()) {
                    parentOrgTree.setStartDate(this.setTimeToDate(curOrgTreeInfo.getStartDate()));
                }
                orgTreeExtInfo.setOrgTreeInfo(parentOrgTree);
                this.putOrgTree(orgTreeMap, parentOrgTree.getNumber(), orgTreeExtInfo);
            }
            structChangeMap.clear();
        }
        existParentTreeList.clear();
        return orgTreeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeleteSynAll(Context ctx, Map<String, Object> parentIdMap) throws Exception {
        CoreBaseCollection coreBases = new CoreBaseCollection();
        try {
            ISynLog synLogInterface = ctx != null ? SynLogFactory.getLocalInstance(ctx) : SynLogFactory.getRemoteInstance();
            String bosType = this.getBOSObjectType().toString();
            SynLogCollection colls = synLogInterface.getSynLogCollection("select synEntityId where synType='" + bosType + "'");
            StringBuffer deleteIdInStr = new StringBuffer();
            String id = null;
            SynLogInfo synLog = null;
            for (int i = 0; i < colls.size(); ++i) {
                id = colls.get(i).getSynEntityId().toString();
                if (parentIdMap.containsKey(id)) continue;
                deleteIdInStr.append("'").append(id).append("',");
            }
            for (String curId : parentIdMap.keySet()) {
                synLog = new SynLogInfo();
                synLog.setSynType(bosType);
                synLog.setSynEntityId(curId);
                coreBases.add((CoreBaseInfo)synLog);
            }
            if (deleteIdInStr.lastIndexOf(",") > 0) {
                deleteIdInStr.deleteCharAt(deleteIdInStr.lastIndexOf(","));
            }
            this.deleteOrgData(ctx, deleteIdInStr);
            synLogInterface.delete("where synType='" + bosType + "'");
            if (coreBases.size() > 0) {
                synLogInterface.addnewBatchData(coreBases);
            }
        }
        finally {
            parentIdMap.clear();
            coreBases.clear();
        }
    }

    private void deleteOrgData(Context ctx, StringBuffer deleteIdInStr) throws Exception {
        if (deleteIdInStr.length() > 0) {
            if (ctx != null) {
                StringBuffer sql = new StringBuffer();
                sql.append("delete T_ORG_BaseUnit where fid in (select FUnitId from T_ORG_Structure where ");
                sql.append(" FTreeId in (").append(deleteIdInStr).append(")) and fisunion=1 ");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            (ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx)).delete("where tree in(" + deleteIdInStr + ")");
            this.getBizInterface(ctx).delete("where id in(" + deleteIdInStr + ")");
        }
    }

    private Timestamp setTimeToDate(Timestamp time) {
        if (time != null) {
            time.setHours(0);
            time.setMinutes(0);
            time.setSeconds(0);
            time.setNanos(0);
        }
        return time;
    }

    private void checkOrgStructureChanged(Context ctx, String[] args, List<String> orgTreeIds, WebServiceInfo xbangServiceInfo, WebServiceClient webServiceClient, Map<String, Object> resultMap) throws Exception {
        if (orgTreeIds != null && !orgTreeIds.isEmpty()) {
            String inStr = CslRptUtil.list2String(orgTreeIds, ",", true);
            Map<String, Map<String, Object>> parentOrgTreeMap = this.getParentOrgStructure(args, inStr, xbangServiceInfo, webServiceClient);
            OrgStructureCollection curOrgStrus = (ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx)).getOrgStructureCollection("select tree.id,id where tree.id in(" + inStr + ") order by tree.id asc");
            Map<Object, Object> curOrgTreeMap = null;
            curOrgTreeMap = curOrgStrus != null && curOrgStrus.size() > 0 ? this.getOrgStructure(null, curOrgStrus) : new HashMap();
            curOrgStrus.clear();
            Map<String, Object> parentOrgStruMap = null;
            Map curOrgStruMap = null;
            block0: for (String treeId : orgTreeIds) {
                parentOrgStruMap = parentOrgTreeMap.get(treeId);
                curOrgStruMap = (Map)curOrgTreeMap.get(treeId);
                if (parentOrgStruMap != null && curOrgStruMap != null) {
                    if (parentOrgStruMap.size() != curOrgStruMap.size()) {
                        resultMap.put(treeId, null);
                        continue;
                    }
                    Iterator iter = curOrgStruMap.keySet().iterator();
                    while (iter.hasNext()) {
                        if (parentOrgStruMap.containsKey(iter.next())) continue;
                        resultMap.put(treeId, null);
                        continue block0;
                    }
                    continue;
                }
                if (parentOrgStruMap == null && curOrgStruMap == null) continue;
                resultMap.put(treeId, null);
            }
            parentOrgTreeMap.clear();
            curOrgTreeMap.clear();
        }
    }

    private Map<String, Map<String, Object>> getParentOrgStructure(String[] args, String treeIdInStr, WebServiceInfo xbangServiceInfo, WebServiceClient webServiceClient) throws Exception {
        String[] params = null;
        params = args != null ? new String[]{treeIdInStr, "tree.id,id", "tree.id", args[0]} : new String[]{treeIdInStr, "tree.id,id", "tree.id"};
        xbangServiceInfo.setArgs(new Object[]{SynchronizeType.getOrgStructure, params});
        String orgStructureStr = (String)webServiceClient.callMethod(xbangServiceInfo);
        return this.getOrgStructure(orgStructureStr, null);
    }

    private Map<String, Map<String, Object>> getOrgStructure(String orgStructureStr, OrgStructureCollection orgStructureCol) throws Exception {
        HashMap<String, Map<String, Object>> orgStruMap = new HashMap<String, Map<String, Object>>();
        boolean isSubOrgStruct = false;
        if (orgStructureCol != null && orgStructureCol.size() > 0) {
            isSubOrgStruct = true;
        }
        JSONArray jsoArr = isSubOrgStruct ? null : new JSONArray(orgStructureStr);
        int count = isSubOrgStruct ? orgStructureCol.size() : jsoArr.length();
        OrgStructureInfo strucInfo = null;
        HashMap<String, Object> orgStruIds = null;
        for (int i = 0; i < count; ++i) {
            strucInfo = isSubOrgStruct ? orgStructureCol.get(i) : (OrgStructureInfo)this.jsonStringToObject(null, jsoArr.getString(i), null);
            orgStruIds = (HashMap<String, Object>)orgStruMap.get(strucInfo.getTree().getId().toString());
            if (orgStruIds == null) {
                orgStruIds = new HashMap<String, Object>();
            }
            orgStruIds.put(strucInfo.getId().toString(), null);
            orgStruMap.put(strucInfo.getTree().getId().toString(), orgStruIds);
        }
        return orgStruMap;
    }

    private void putOrgTree(Map<String, List<OrgTreeExtInfo>> orgTreeMap, String orgTreeNumber, OrgTreeExtInfo orgTreeExt) {
        List<OrgTreeExtInfo> orgTreeList = null;
        orgTreeList = orgTreeMap.get(orgTreeNumber);
        if (orgTreeList == null) {
            orgTreeList = new ArrayList<OrgTreeExtInfo>();
            orgTreeList.add(orgTreeExt);
        } else if (orgTreeList.get(0).getOrgTreeInfo().getCreateTime().compareTo(orgTreeExt.getOrgTreeInfo().getCreateTime()) > 0) {
            orgTreeList.add(0, orgTreeExt);
        } else if (orgTreeList.get(orgTreeList.size() - 1).getOrgTreeInfo().getCreateTime().compareTo(orgTreeExt.getOrgTreeInfo().getCreateTime()) < 0) {
            orgTreeList.add(orgTreeExt);
        } else {
            for (int i = 0; i < orgTreeList.size() - 1; ++i) {
                if (orgTreeList.get(i).getOrgTreeInfo().getCreateTime().compareTo(orgTreeExt.getOrgTreeInfo().getCreateTime()) >= 0 || orgTreeList.get(i + 1).getOrgTreeInfo().getCreateTime().compareTo(orgTreeExt.getOrgTreeInfo().getCreateTime()) <= 0) continue;
                orgTreeList.add(i + 1, orgTreeExt);
                break;
            }
        }
        orgTreeMap.put(orgTreeNumber, orgTreeList);
    }

    private void setStartANDUnStart(OrgTreeExtInfo orgTreeExt, OrgTreeInfo parentOrgTreeInfo, OrgTreeInfo curOrgTreeInfo) {
        if (curOrgTreeInfo == null) {
            if (parentOrgTreeInfo.getStartDate() != null) {
                orgTreeExt.setStart(true);
            }
        } else if (parentOrgTreeInfo.getStartDate() != null && curOrgTreeInfo.getStartDate() != null) {
            if (parentOrgTreeInfo.getStartDate().compareTo(curOrgTreeInfo.getStartDate()) != 0 && curOrgTreeInfo.getEndDate() == null) {
                orgTreeExt.setUnStart(true);
                orgTreeExt.setStart(true);
            }
        } else if (parentOrgTreeInfo.getStartDate() != null || curOrgTreeInfo.getStartDate() != null) {
            if (parentOrgTreeInfo.getStartDate() == null) {
                orgTreeExt.setUnStart(true);
            } else {
                orgTreeExt.setStart(true);
            }
        }
    }

    @Override
    public ICoreBase getBizInterface(Context ctx) throws Exception {
        return ctx == null ? OrgTreeFactory.getRemoteInstance() : OrgTreeFactory.getLocalInstance((Context)ctx);
    }

    @Override
    public CoreBaseInfo getCoreBaseInfo() throws Exception {
        return new OrgTreeInfo();
    }

    @Override
    public String getMethod() {
        return SynchronizeType.getOrgTreeTask;
    }

    @Override
    public String getSelectStr(Context ctx) {
        return super.getSelectStr(ctx);
    }

    @Override
    public String getWhereStr() {
        return "type=8";
    }

    @Override
    public String getOrderStr() {
        return "number,createtime";
    }
}

