/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.webservice;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.bos.webservice.WSConfig;
import com.kingdee.bos.webservice.WSInvokeException;
import com.kingdee.bos.webservice.login.EASLoginProxy;
import com.kingdee.bos.webservice.login.WSContext;
import com.kingdee.eas.base.uiframe.utils.XMLElement;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.webservice.IRptIntegrationWebServiceFacade;
import com.kingdee.eas.fi.gr.rptintegration.webservice.RptIntegrationWebServiceFacade;
import com.kingdee.eas.fi.gr.rptintegration.webservice.login.CslRptLoginEASProxy;
import com.kingdee.eas.fi.newrpt.extractrptdata.WSCalcFormulaErrorEnum;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RptIntegrationWebServiceFacadeSrvProxy {
    private static Logger logger = Logger.getLogger(RptIntegrationWebServiceFacadeSrvProxy.class);

    public String invoke(String methodName, String arg) throws WSInvokeException {
        try {
            return this.getController(null).invoke(methodName, arg);
        }
        catch (Throwable e) {
            throw new WSInvokeException(e);
        }
    }

    public String invoke(String methodName, String[] args) throws WSInvokeException {
        try {
            if (SynchronizeType.getDBList.equals(methodName)) {
                return this.getDBList();
            }
            if (args != null && args.length >= 6) {
                CslRptLoginEASProxy loginProxy = new CslRptLoginEASProxy();
                int argLength = args.length;
                String userName = args[argLength - 6];
                String passWd = args[argLength - 5];
                try {
                    passWd = CryptoTean.decrypt((String)userName, (String)passWd);
                    passWd = passWd != null && passWd.startsWith("isFrom860") ? passWd.substring("isFrom860".length()) : args[argLength - 5];
                }
                catch (Exception ex) {
                    logger.error((Object)"decrypt", (Throwable)ex);
                    passWd = args[argLength - 5];
                }
                if (passWd != null && passWd.startsWith("isFrom860")) {
                    passWd = passWd.substring("isFrom860".length());
                }
                WSContext wsContext = loginProxy.login(userName, passWd, args[argLength - 4], args[argLength - 3], args[argLength - 2], Integer.valueOf(args[argLength - 1]), "BaseDB", 1);
                if (SynchronizeType.login.equals(methodName)) {
                    if (wsContext != null && wsContext.getSessionId() != null) {
                        return wsContext.getSessionId().trim();
                    }
                    return null;
                }
                if (wsContext != null && wsContext.getSessionId() != null && wsContext.getSessionId().trim() != "") {
                    String[] curArgs;
                    String[] stringArray = curArgs = args.length - 6 > 0 ? new String[args.length - 6] : null;
                    if (curArgs != null) {
                        for (int i = 0; i < curArgs.length; ++i) {
                            curArgs[i] = args[i];
                        }
                    }
                    return this.getController(wsContext.getSessionId()).invoke(methodName, curArgs);
                }
                return "eas login error";
            }
            return "webservice args error";
        }
        catch (Throwable e) {
            logger.error((Object)"invoke error", e);
            throw new WSInvokeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDBList() throws Exception {
        JSONArray jsonArray = new JSONArray();
        String easHome = System.getProperty("EAS_HOME");
        String dcInfoFile = null;
        dcInfoFile = easHome == null || easHome.length() <= 0 ? "W:/eas/Server//server/properties/datacenters.xml" : System.getProperty("EAS_HOME") + "/server/properties/datacenters.xml";
        XMLElement xmlEle = new XMLElement();
        FileReader reader = null;
        try {
            reader = new FileReader(FilenameUtils.normalize((String)dcInfoFile));
            xmlEle.parseFromReader((Reader)reader);
            Vector dcList = xmlEle.getChildren();
            if (dcList != null) {
                for (int i = 0; i < dcList.size(); ++i) {
                    XMLElement dcEle = (XMLElement)dcList.get(i);
                    if (!"false".equals(dcEle.getStringAttribute("disable").toLowerCase())) continue;
                    jsonArray.put((Object)dcEle.getStringAttribute("id"));
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    logger.error((Object)"reader.close()_error", (Throwable)e);
                }
            }
        }
        return jsonArray.toString();
    }

    private IRptIntegrationWebServiceFacade getController(String sessionId) {
        try {
            if (!StringUtils.isEmpty((String)sessionId)) {
                return (IRptIntegrationWebServiceFacade)BOSObjectFactory.createBOSObject((String)sessionId, (String)"com.kingdee.eas.fi.gr.rptintegration.webservice.RptIntegrationWebServiceFacade");
            }
            return (IRptIntegrationWebServiceFacade)BOSObjectFactory.createRemoteBOSObject((String)WSConfig.getSrvURL(), (String)RptIntegrationWebServiceFacade.class.getName(), IRptIntegrationWebServiceFacade.class);
        }
        catch (Throwable e) {
            return (IRptIntegrationWebServiceFacade)ORMEngine.createRemoteObject((String)WSConfig.getSrvURL(), (String)"com.kingdee.eas.fi.gr.rptintegration.webservice.RptIntegrationWebServiceFacade", IRptIntegrationWebServiceFacade.class);
        }
    }

    private WSContext prelogin(Map loginParam, Map returnMap) {
        WSContext wsContext = this.login(loginParam, returnMap);
        for (int i = 0; i < 15 && (wsContext == null || wsContext.getSessionId() == null); ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
            wsContext = this.login(loginParam, returnMap);
        }
        if (wsContext == null || wsContext.getSessionId() == null) {
            returnMap.put("errorMsg", EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"977_RptIntegrationWebServiceFacadeSrvProxy"));
            logger.error((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"977_RptIntegrationWebServiceFacadeSrvProxy"));
        }
        return wsContext;
    }

    private WSContext login(Map loginParam, Map returnMap) {
        EASLoginProxy loginProxy = new EASLoginProxy();
        String userName = (String)loginParam.get("username");
        String password = (String)loginParam.get("password");
        String dcName = (String)loginParam.get("dcname");
        String language = (String)loginParam.get("language");
        if (language == null || language.length() == 0) {
            language = "l2";
        }
        WSContext wsContext = null;
        try {
            int dbType = RptUtil.getDBType((String)dcName);
            wsContext = loginProxy.login(userName, password, "eas", dcName, language, dbType, "BaseDB", 1);
            if (wsContext == null || wsContext.getSessionId() == null) {
                returnMap.put("error", WSCalcFormulaErrorEnum.failed.getAlias(new Locale(language)));
                returnMap.put("loginparam", loginParam);
                logger.error((Object)("calc web service Formula login null user:" + userName + " dc:" + dcName));
            }
        }
        catch (Exception e) {
            returnMap.put("error", WSCalcFormulaErrorEnum.failed.getAlias(new Locale(language)));
            returnMap.put("loginparam", loginParam);
            logger.error((Object)("calc web service Formula login null user:" + userName + " dc:" + dcName + " \n"), (Throwable)e);
        }
        return wsContext;
    }

    public Map calcFormulaValues(Map loginParam, List calcParams) throws WSInvokeException {
        try {
            HashMap returnMap = new HashMap();
            logger.error((Object)"calc web service Formula start");
            WSContext wsContext = this.prelogin(loginParam, returnMap);
            if (wsContext == null || wsContext.getSessionId() == null) {
                return returnMap;
            }
            return this.getController(wsContext.getSessionId()).calcFormulaValues(calcParams);
        }
        catch (Throwable e) {
            throw new WSInvokeException(e);
        }
    }

    public Map getDynItemData(Map loginParam, Map filter) throws WSInvokeException {
        try {
            HashMap returnMap = new HashMap();
            logger.error((Object)"get web service DynItemData start");
            WSContext wsContext = this.prelogin(loginParam, returnMap);
            if (wsContext == null || wsContext.getSessionId() == null) {
                return returnMap;
            }
            return this.getController(wsContext.getSessionId()).getDynItemData(filter);
        }
        catch (Throwable e) {
            throw new WSInvokeException(e);
        }
    }
}

