/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaCheckResultFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ReportNoticeAndCheckTool;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ReportStatusHandle {
    public String cslrptAduit(Context ctx, CslReportInfo editData) throws Exception {
        boolean isTopLevel = false;
        String result = null;
        if (editData.getAuditedStatus() == AuditedStatusEnum.UNAUDITED) {
            RptSrcTypeEnum srcType = editData.getSourceType();
            if ((srcType.equals((Object)RptSrcTypeEnum.CONSOLIDATION) || srcType.equals((Object)RptSrcTypeEnum.SUM) || srcType.equals((Object)RptSrcTypeEnum.DYNAMICSUMREPORT) || srcType.equals((Object)RptSrcTypeEnum.MANUSCRIPT) || srcType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || srcType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) || srcType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICCSLREPORT)) && CslRptUtil.isCslTopLevelAtServer(ctx, editData)) {
                isTopLevel = true;
            }
            Map map = this.checkReport(ctx, editData.getId().toString(), 2, editData.getBook());
            boolean passed = (Boolean)map.get("passed");
            String detail = (String)map.get("detail");
            String errMsg = CslRptUtil.getString("CslRptUCheckFail");
            String msg = CslRptUtil.getString("checkFailDetail");
            if (!StringUtils.isEmpty((String)detail) && !StringUtils.isEmpty((String)msg)) {
                result = errMsg + msg + "#" + detail;
            }
            if (!passed) {
                throw new RptWeaveException(result);
            }
            RptSrcTypeEnum rptSrcType = editData.getSourceType();
            if (RptUtil.isTrue((Object)ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_CheckNumber")) && (rptSrcType.equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) || rptSrcType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT))) {
                Book book = editData.getBook();
                FullOrgUnitInfo object = editData.getCompany();
                ArrayList result1 = new ArrayList();
                for (int i = 0; i < book.getSheetCount(); ++i) {
                    DynamicTemplateUtility.checkDynaAccountItem((Context)ctx, (Sheet)book.getSheet(i), (int)editData.getSourceType().getValue(), (boolean)true, (Object)object, result1);
                }
                if (result1 != null && result1.size() > 0) {
                    if (result1.size() > 50) {
                        throw new RptWeaveException(CslRptUtil.getString("CslRptUCheckFail") + "\n" + result1.subList(0, 30).toString());
                    }
                    throw new RptWeaveException(CslRptUtil.getString("CslRptUCheckFail") + "\n" + result1.toString());
                }
            }
        }
        CslReportFactory.getLocalInstance(ctx).audit((IObjectPK)new ObjectUuidPK(editData.getId()));
        editData.setAuditedStatus(AuditedStatusEnum.AUDITED);
        if (isTopLevel) {
            editData.setCommittedStatus(CommittedStatusEnum.GROUPCOMMITTED);
        }
        return result;
    }

    private Map checkReport(Context context, String id, int iCheckEntry, Book book) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ICslReport icr = null;
        icr = context == null ? CslReportFactory.getRemoteInstance() : CslReportFactory.getLocalInstance(context);
        ArrayList<String> list = new ArrayList<String>();
        list.add(id);
        List result = icr.reportCheck(list, iCheckEntry);
        String msg = null;
        boolean passed = true;
        if (result != null && result.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                Map data = (Map)result.get(i);
                if (data == null || data.get("KEY_CHECK_FLAG") == null) continue;
                passed = (Boolean)data.get("KEY_CHECK_FLAG");
                msg = (String)data.get("KEY_CHECK_MESSAGE");
                if (!passed) break;
            }
            if (!StringUtils.isEmpty(msg)) {
                ArrayList<String> unPassIdList = new ArrayList<String>();
                unPassIdList.add(id);
                ReportNoticeAndCheckTool.reportCommitNotice(context, unPassIdList, "checkAudit", msg);
                passed = passed;
                map.put("passed", passed);
                map.put("detail", msg);
            }
        }
        if (map.isEmpty()) {
            map.put("passed", passed);
            map.put("detail", msg);
            ArrayList<String> ReportIdList = new ArrayList<String>();
            ReportIdList.add(id);
            if (ReportIdList.size() > 0) {
                ItemFormulaCheckResultFactory.getLocalInstance(context).batchDelete(ReportIdList);
                RptAutoWeaveUtil.clearCurBookUserObject(book);
            }
        }
        return map;
    }

    public void cslrptCommit(Context ctx, CslReportInfo editData) throws Exception {
        String result;
        ArrayList<String> passedIdList = new ArrayList<String>();
        if (!CslRptUtil.isNewVersionStatus(ctx, editData, null)) {
            throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"8_BaseReportDesignerUI"));
        }
        if (!RptAutoWeaveUtil.checkReport(ctx, this, editData.getId().toString(), 3, editData.getBook())) {
            throw new RptWeaveException(CslRptUtil.getString("CslRptUCheckFail"));
        }
        ArrayList<String> ReportIdList = new ArrayList<String>();
        ReportIdList.add(editData.getId().toString());
        if (ReportIdList.size() > 0) {
            ItemFormulaCheckResultFactory.getLocalInstance(ctx).batchDelete(ReportIdList);
            RptAutoWeaveUtil.clearCurBookUserObject(editData.getBook());
        }
        passedIdList.add(editData.getId().toString());
        HashSet<String> companyidset = new HashSet<String>();
        if (editData.getReportSourceType() != null && !CslRptUtil.isCslRpt(editData.getReportSourceType().getValue())) {
            companyidset.add(editData.getCompany().getId().toString());
            HashMap isCheckOpenmap = new HashMap();
            if (companyidset.size() > 0) {
                isCheckOpenmap = CslRptUtil.getrptSysStatusCtrol(ctx, companyidset);
            }
            if (!CslRptUtil.checkGeneralLedgerIsCheckout(ctx, isCheckOpenmap, editData)) {
                throw new RptWeaveException(CslRptUtil.getStringWithFormat("General_Ledger_Not_Checkout", new Object[]{String.valueOf(editData.getYear()), String.valueOf(CslRptUIUtil.getPeriod((int)editData.getPeriodType().getValue(), (int)editData.getPeriod()))}));
            }
        }
        if ((result = CslReportFactory.getLocalInstance(ctx).commitReportLocal(editData.getId().toString())) == null) {
            editData.setCommittedStatus(CommittedStatusEnum.COMMITTED);
        }
        if (passedIdList != null && passedIdList.size() > 0) {
            ReportNoticeAndCheckTool.reportCommitNotice(ctx, passedIdList, "reportCommit", null);
        }
    }

    public String cslReceive(Context ctx, CslReportInfo editData, String userId) throws Exception {
        if (editData.getCommittedStatus() == CommittedStatusEnum.GROUPCOMMITTED) {
            return null;
        }
        if (CommittedStatusEnum.COMMITTED != editData.getCommittedStatus()) {
            throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"REPORT_NORECEIVE"));
        }
        ObjectStringPK userPK = new ObjectStringPK(userId);
        boolean isExecutPermission = true;
        if (ctx != null && ctx.get((Object)FastMergeUtil.isExecutPermissionKey) != null) {
            isExecutPermission = (Boolean)ctx.get((Object)FastMergeUtil.isExecutPermissionKey);
        }
        if (isExecutPermission && !RptAutoWeaveUtil.checkParentOrgPermissionByReport(ctx, editData, (IObjectPK)userPK)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"you")).append(1).append(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"596_ReceiveListUI")).append("\n");
            buffer.append(CslRptUtil.getString("NO_ReceivePermissio_Report"));
            buffer.append(editData.getOrgUnit().getName()).append("  ").append(editData.getNumber()).append("  ").append(editData.getName());
            throw new RptWeaveException(buffer.toString());
        }
        String rptId = editData.getId().toString();
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(rptId);
        List time = RPTDateUtil.getRptYearAndPeriodAndDate(editData.getYear(), editData.getPeriod(), editData.getPeriodType());
        OrgTreeCollection collection = RptAutoWeaveUtil.getOrgTreeCollect(ctx, false, time, userId);
        if (collection.size() == 0) {
            return null;
        }
        List checkResult = RPTDataServiceFactory.getLocalInstance(ctx).receive(list, userId, collection.get(0).getId().toString());
        String param = ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_RECEIVECHECK_001");
        StringBuffer error = new StringBuffer();
        if ("true".equalsIgnoreCase(param)) {
            ArrayList<String> unPassIds = new ArrayList<String>();
            String dataCollectName = null;
            for (int i = 0; i < checkResult.size(); ++i) {
                Map data = (Map)checkResult.get(i);
                if (data == null || data.get("KEY_ID") == null) continue;
                String id = (String)data.get("KEY_ID");
                String currency = editData.getCurrency().getName();
                boolean passed = (Boolean)data.get("KEY_CHECK_FLAG");
                String msg = (String)data.get("KEY_CHECK_MESSAGE");
                if (!StringUtils.isEmpty((String)msg)) {
                    if (dataCollectName == null) {
                        dataCollectName = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"736_DataCollectConstant", (Locale)ctx.getLocale());
                    }
                    error.append(CslRptUtil.getStringWithFormat("batchAuditCheckErrorMsg", new Object[]{editData.getName(), dataCollectName, currency}));
                    error.append(msg);
                    unPassIds.add(id);
                }
                if (passed) continue;
                ReportNoticeAndCheckTool.reportCommitNotice(unPassIds, "checkReceive", error.toString());
                throw new RptWeaveException(error.toString());
            }
        }
        ReportNoticeAndCheckTool.reportCommitNotice(ctx, list, "reportReceive", null);
        return error.toString().trim();
    }
}

