/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaCheckResultFactory;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptWeaveExecute;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.PermissionHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RptWeaveExecAduit
extends AbstractRptWeaveExecute {
    private String rptId = "";

    public RptWeaveExecAduit(RptWeaveParams schmParam, Context ctx) {
        super(schmParam, ctx);
    }

    @Override
    protected void beforeExecute() throws Exception {
        super.beforeExecute();
        this.rptId = this.getExistRptId();
    }

    @Override
    protected void executeRptWeave() throws Exception {
        RptWeaveExecParams execParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_weave_execparams");
        if (execParam.isCommitReport()) {
            ReportInfo rptInfo = ReportFactory.getLocalInstance((Context)this.ctx).getReportInfo((IObjectPK)new ObjectUuidPK(this.rptId), this.getRptSelectors());
            this.rptAduit(this.ctx, rptInfo);
        } else {
            CslReportInfo cslrptInfo = this.getCslReportInfo(this.ctx, this.rptId);
            this.cslrptAduit(this.ctx, cslrptInfo);
        }
    }

    private void rptAduit(Context ctx, ReportInfo reportInfo) throws Exception {
        if (reportInfo.getCommittedStatus() == CommittedStatusEnum.GROUPCOMMITTED) {
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"REPORTISAUDIT_CANNOTAUDIT", (Locale)ctx.getOriginLocale()));
        }
        if (reportInfo.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
            return;
        }
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.schmParam.getObject("KEY_COMPANY");
        if (!this.schmParam.getBoolean("rpt_web_isRptExec")) {
            this.checkOperatePermission(ctx, (IObjectPK)new ObjectUuidPK(this.userId), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), PermissionHelper.getAuditedPermNameByOrgType((OrgType)this.getTemplateOrgType()));
        }
        RptSrcTypeEnum rptSrcType = reportInfo.getReportSourceType();
        if (RptUtil.isTrue((Object)ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_CheckNumber")) && (rptSrcType.equals((Object)RptSrcTypeEnum.DYNAMICNORMALREPORT) || rptSrcType.equals((Object)RptSrcTypeEnum.DYNAMICCSLREPORT) || rptSrcType.equals((Object)RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT))) {
            Book book = reportInfo.getBook();
            FullOrgUnitInfo object = reportInfo.getCompany();
            ArrayList result1 = new ArrayList();
            for (int i = 0; i < book.getSheetCount(); ++i) {
                DynamicTemplateUtility.checkDynaAccountItem((Context)ctx, (Sheet)book.getSheet(i), (int)reportInfo.getSourceType().getValue(), (boolean)true, (Object)object, result1);
            }
            if (result1 != null && result1.size() > 0) {
                if (this.schmParam.getBoolean("rpt_web_isRptExec")) {
                    throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"DATACHECK_FAIL", (Locale)ctx.getOriginLocale()), result1.toString());
                }
                throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"DATACHECK_FAIL", (Locale)ctx.getOriginLocale()));
            }
        }
        boolean needCheck = RptUtil.isTrue((Object)ParamManager.getParamValue((Context)ctx, null, (String)"GR_CSL_RPTRECEIVE_001"));
        if (reportInfo.getAuditedStatus() != null && reportInfo.getAuditedStatus().equals((Object)AuditedStatusEnum.UNAUDITED) && needCheck && (reportInfo.getSourceType() == RptSrcTypeEnum.COMMITREPORT || reportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || reportInfo.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT) && reportInfo.getIsSupportGroup().equals((Object)IsSupportGroupReportEnum.SUPPORT)) {
            try {
                ArrayList<ReportInfo> reportList = new ArrayList<ReportInfo>();
                reportList.add(reportInfo);
                List rst = CslReportFactory.getLocalInstance(ctx).preCheckReport(reportList);
                String checkResult = null;
                boolean passed = true;
                if (rst != null && rst.size() > 0) {
                    for (int i = 0; i < rst.size(); ++i) {
                        Map data = (Map)rst.get(i);
                        if (data != null && data.get("KEY_CHECK_MESSAGE") != null) {
                            checkResult = (String)data.get("KEY_CHECK_MESSAGE");
                        }
                        if (data == null || data.get("KEY_CHECK_FLAG") == null) continue;
                        passed = (Boolean)data.get("KEY_CHECK_FLAG");
                    }
                }
                if (!StringUtils.isEmpty(checkResult) && !passed) {
                    if (this.schmParam.getBoolean("rpt_web_isRptExec")) {
                        throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"DATACHECK_FAIL", (Locale)ctx.getOriginLocale()), checkResult);
                    }
                    throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"DATACHECK_FAIL", (Locale)ctx.getOriginLocale()));
                }
                ArrayList<String> ReportIdList = new ArrayList<String>();
                ReportIdList.add(reportInfo.getId().toString());
                if (ReportIdList.size() > 0) {
                    ItemFormulaCheckResultFactory.getLocalInstance(ctx).batchDelete(ReportIdList);
                    Book book = reportInfo.getBook();
                    RptAutoWeaveUtil.clearCurBookUserObject(book);
                }
            }
            catch (Exception e2) {
                if (e2 instanceof RptWeaveException) {
                    throw e2;
                }
                logger.error((Object)"rptAduit ", (Throwable)e2);
                if (this.schmParam.getBoolean("rpt_web_isRptExec")) {
                    throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"175_ReportProcessUI", (Locale)ctx.getOriginLocale()));
                }
                throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"175_ReportProcessUI", (Locale)ctx.getOriginLocale()), e2.getLocalizedMessage());
            }
        }
        logger.info((Object)("rptAduit:" + reportInfo.getId()));
        this.resetContext(reportInfo);
        ReportFactory.getLocalInstance((Context)ctx).audit((IObjectPK)new ObjectUuidPK(reportInfo.getId()));
    }

    private void resetContext(ReportInfo reportInfo) throws BOSException, EASBizException {
        String companyid = reportInfo.getCompany().getId().toString();
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        this.ctx.put((Object)"CompanyInfo", (Object)fullOrgUnitInfo);
        this.ctx.put((Object)OrgType.Company, (Object)MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType((OrgUnitInfo)fullOrgUnitInfo, this.ctx));
    }

    @Override
    protected void cslrptAduit(Context ctx, CslReportInfo editData) throws Exception {
        super.cslrptAduit(ctx, editData);
    }
}

