/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcHelper;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcTypeEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptWeaveExecute;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveReportCalculate;
import com.kingdee.eas.fi.newrpt.PermissionHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class RptWeaveExecCalc
extends AbstractRptWeaveExecute {
    String rptId = "";

    public RptWeaveExecCalc(RptWeaveParams schmParam, Context ctx) {
        super(schmParam, ctx);
    }

    @Override
    protected void beforeExecute() throws Exception {
        try {
            super.beforeExecute();
            this.rptId = this.getExistRptId();
            if (this.schmParam.getBoolean("rptautoweave_isfromgeextractdataf")) {
                return;
            }
            if (this.schmParam.getBoolean("rpt_web_isRptExec")) {
                return;
            }
            FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.schmParam.getObject("KEY_COMPANY");
            RptWeaveExecParams execParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_weave_execparams");
            if (execParam.isCommitReport()) {
                this.checkOperatePermission(this.ctx, (IObjectPK)new ObjectUuidPK(this.userId), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), PermissionHelper.getCalculatePermNameByOrgType((OrgType)this.getTemplateOrgType()));
            }
        }
        catch (Exception e) {
            RptWeaveExecParams execParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_weave_execparams");
            execParam.setCalcException(e);
            throw e;
        }
    }

    @Override
    protected void executeRptWeave() throws Exception {
        try {
            RptWeaveExecParams execParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_weave_execparams");
            FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.schmParam.getObject("KEY_COMPANY");
            RptAutoWeaveSchmRptInfo schmRptInfo = (RptAutoWeaveSchmRptInfo)this.schmParam.getObject("rpt_weave_rptSchmObj");
            if (execParam.isCommitReport()) {
                if (!this.schmParam.getBoolean("rpt_web_isRptExec")) {
                    this.checkOperatePermission(this.ctx, (IObjectPK)new ObjectUuidPK(this.userId), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), PermissionHelper.getCalculatePermNameByOrgType((OrgType)this.getTemplateOrgType()));
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("auditedStatus"));
                IReport ireport = ReportFactory.getLocalInstance((Context)this.ctx);
                ReportInfo info = ireport.getReportInfo((IObjectPK)new ObjectUuidPK(this.rptId), sic);
                if (info.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
                    return;
                }
                if (schmRptInfo != null && schmRptInfo.getCalcType() == RptWeaveCalcTypeEnum.ONLYCALC) {
                    ireport.backCacl((IObjectPK)new ObjectUuidPK(this.rptId));
                } else {
                    ReportInfo rptInfo = ireport.getReportInfo((IObjectPK)new ObjectUuidPK(this.rptId), this.getRptSelectors());
                    Object obj = this.schmParam.getObject("rptautoweave_extractdatafid");
                    if (obj != null && obj instanceof FormulaCalcContextInfo) {
                        rptInfo.put("KEY_FORMULACALCID", (Object)((FormulaCalcContextInfo)obj).getId().toString());
                    }
                    this.fillAndCalculate(orgUnitInfo, (ReportBaseInfo)rptInfo, false);
                }
            } else {
                CslReportInfo cslrptInfo = this.getCslReportInfo(this.ctx, this.rptId);
                if (cslrptInfo.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
                    return;
                }
                if (cslrptInfo.getCommittedStatus() == CommittedStatusEnum.GROUPCOMMITTED) {
                    throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"224_RptReportProcessUI", (Locale)this.ctx.getOriginLocale()));
                }
                RptWeaveReportCalculate rptCalc = new RptWeaveReportCalculate(this.ctx, (OrgUnitInfo)orgUnitInfo);
                if (schmRptInfo.getCalcType() == RptWeaveCalcTypeEnum.ONLYCALC) {
                    rptCalc.cslRptCalculate(cslrptInfo);
                } else {
                    this.fillAndCalculate(orgUnitInfo, cslrptInfo, true);
                }
            }
        }
        catch (Exception e) {
            RptWeaveExecParams execParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_weave_execparams");
            execParam.setCalcException(e);
            if (this.schmParam.getBoolean("rpt_web_isRptExec")) {
                throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"310_CalculateError", (Locale)this.ctx.getOriginLocale()), e.getLocalizedMessage());
            }
            throw e;
        }
    }

    private void fillAndCalculate(FullOrgUnitInfo orgUnitInfo, ReportBaseInfo rptInfo, boolean isCslrpt) throws Exception {
        boolean isDynamicRpt = RptWeaveCalcHelper.isDynamicRpt(rptInfo);
        rptInfo.put("rpt_weave_schmParam", (Object)this.schmParam);
        if (isDynamicRpt) {
            RptWeaveReportCalculate rptCalc = new RptWeaveReportCalculate(this.ctx, (OrgUnitInfo)orgUnitInfo);
            rptCalc.fillDynamicItemsandCalc(rptInfo, isCslrpt);
        } else {
            RptWeaveReportCalculate calc = new RptWeaveReportCalculate(this.ctx, (OrgUnitInfo)orgUnitInfo);
            calc.interOrExchFillCompanyAndCalc(rptInfo, isCslrpt);
        }
    }
}

