/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveLinkEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptWeaveExecute;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExceCopyPre;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecAddNew;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecAduit;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecCalc;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecCheck;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecCommit;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecConvert;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecReceive;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecSendBack;
import com.kingdee.eas.fi.rpt.batch.log.LogService;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RptWeaveExecStrategy {
    protected static final Logger logger = Logger.getLogger(RptWeaveExecStrategy.class);
    private RptAutoWeaveSchmRptInfo schmRptInfo;
    private RptAutoWeaveLogInfo logInfo;
    private LogService logService;

    public RptWeaveExecStrategy(RptAutoWeaveSchmRptInfo schmInfo, RptAutoWeaveLogInfo logInfo) {
        this.schmRptInfo = schmInfo;
        this.logInfo = logInfo;
        this.logService = new LogService(logger);
    }

    public RptWeaveExecStrategy(RptAutoWeaveLogInfo logInfo) {
        this.logInfo = logInfo;
        this.logService = new LogService(logger);
    }

    public void rptWeaveExceute(RptWeaveParams schmParam, Context ctx) throws Exception {
        boolean isSendBack;
        boolean isCheck;
        boolean isCommit;
        boolean isAduit;
        boolean isCalc;
        boolean isCopyPre;
        ArrayList<AbstractRptWeaveExecute> execList = new ArrayList<AbstractRptWeaveExecute>();
        boolean isAddNew = this.isHandleByHandOrAuto(schmParam, "isAddNew", this.schmRptInfo != null ? this.schmRptInfo.isIsAddNew() : false);
        if (isAddNew) {
            execList.add(new RptWeaveExecAddNew(schmParam, ctx));
        }
        if (isCopyPre = this.isHandleByHandOrAuto(schmParam, "isCopyPre", this.schmRptInfo != null ? this.schmRptInfo.isIsCopyPre() : false)) {
            execList.add(new RptWeaveExceCopyPre(schmParam, ctx));
        }
        if (isCalc = this.isHandleByHandOrAuto(schmParam, "isCalc", this.schmRptInfo != null ? this.schmRptInfo.isIsCalc() : false)) {
            execList.add(new RptWeaveExecCalc(schmParam, ctx));
        }
        boolean isConvert = this.isHandleByHandOrAuto(schmParam, "isConvert", this.schmRptInfo != null ? this.schmRptInfo.getConvertSolution() != null : false);
        if (isConvert) {
            execList.add(new RptWeaveExecConvert(schmParam, ctx));
        }
        if (isAduit = this.isHandleByHandOrAuto(schmParam, "isAudit", this.schmRptInfo != null ? this.schmRptInfo.isIsAduit() : false)) {
            execList.add(new RptWeaveExecAduit(schmParam, ctx));
        }
        if (isCommit = this.isHandleByHandOrAuto(schmParam, "isCommit", this.schmRptInfo != null ? this.schmRptInfo.isIsCommit() : false)) {
            execList.add(new RptWeaveExecCommit(schmParam, ctx));
        }
        if (isCheck = this.isHandleByHandOrAuto(schmParam, "isCheck", false)) {
            execList.add(new RptWeaveExecCheck(schmParam, ctx));
        }
        if (this.schmRptInfo != null && this.schmRptInfo.isIsReceive()) {
            execList.add(new RptWeaveExecReceive(schmParam, ctx));
        }
        if (isSendBack = this.isHandleByHandOrAuto(schmParam, "isSendBack", this.schmRptInfo != null ? this.schmRptInfo.isIsSendBack() : false)) {
            execList.add(new RptWeaveExecSendBack(schmParam, ctx));
        }
        IMutexServiceControl mutexService = null;
        boolean isgetMutex = false;
        String cslrpt = null;
        try {
            mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < execList.size(); ++i) {
                if (this.logInfo != null) {
                    if (execList.get(i) instanceof RptWeaveExecAddNew || execList.get(i) instanceof RptWeaveExceCopyPre) {
                        this.logInfo.setLinkType(RptWeaveLinkEnum.ADDNEW);
                    } else if (execList.get(i) instanceof RptWeaveExecCalc) {
                        this.logInfo.setLinkType(RptWeaveLinkEnum.CALCULATE);
                    } else if (execList.get(i) instanceof RptWeaveExecAduit) {
                        this.logInfo.setLinkType(RptWeaveLinkEnum.ADUIT);
                    } else if (execList.get(i) instanceof RptWeaveExecCommit) {
                        this.logInfo.setLinkType(RptWeaveLinkEnum.COMMIT);
                    } else if (execList.get(i) instanceof RptWeaveExecReceive) {
                        this.logInfo.setLinkType(RptWeaveLinkEnum.RECEIVE);
                    } else if (execList.get(i) instanceof RptWeaveExecCheck) {
                        this.logInfo.setLinkType(RptWeaveLinkEnum.CHECK);
                    } else if (execList.get(i) instanceof RptWeaveExecConvert) {
                        this.logInfo.setLinkType(RptWeaveLinkEnum.CONVERT);
                    } else if (execList.get(i) instanceof RptWeaveExecSendBack) {
                        this.logInfo.setLinkType(RptWeaveLinkEnum.SENDBACK);
                    }
                }
                RptWeaveExecParams execParam = (RptWeaveExecParams)schmParam.getObject("rpt_weave_execparams");
                cslrpt = execParam.getCslrptId();
                if (!isAddNew && !isCopyPre && StringUtils.isEmpty((String)cslrpt)) {
                    cslrpt = ((AbstractRptWeaveExecute)execList.get(i)).getExistRptId();
                }
                if (!(StringUtils.isEmpty((String)cslrpt) || isgetMutex || (isgetMutex = mutexService.requestObjIDForUpdate(cslrpt)))) {
                    throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"OBJECT_IS_LOCKED", (Locale)ctx.getOriginLocale()));
                }
                AbstractRptWeaveExecute rptweaveExec = (AbstractRptWeaveExecute)execList.get(i);
                rptweaveExec.execute();
                if (this.logService == null) continue;
                this.logService.addLogItem("", rptweaveExec.buildLogMsg());
            }
        }
        catch (Exception e) {
            if (this.logInfo != null && this.logInfo.getLinkType() != null) {
                logger.info((Object)("rptWeaveExceute:::::" + this.logInfo.getLinkType().getValue()));
            }
            logger.error((Object)"rptWeaveExceute------", (Throwable)e);
            if (schmParam.getBoolean("rpt_web_isRptExec")) {
                if (e instanceof RptWeaveException) {
                    RptWeaveException ex = (RptWeaveException)((Object)e);
                    String code = ex.getCode();
                    if (!("10000".equals(code) || "10001".equals(code) || "10-10000".equals(code))) {
                        throw new RptWeaveException(code, this.logInfo.getLinkType().getValue() + "$" + e.getLocalizedMessage());
                    }
                    throw new RptWeaveException(this.logInfo.getLinkType().getValue() + "$" + e.getLocalizedMessage());
                }
                throw new RptWeaveException(this.logInfo.getLinkType().getValue() + "$" + e.getLocalizedMessage());
            }
            throw e;
        }
        finally {
            if (isgetMutex && !StringUtils.isEmpty(cslrpt)) {
                mutexService.releaseObjIDForUpdate(cslrpt);
            }
            if (this.logService != null) {
                this.logService.logIt();
            }
        }
    }

    private boolean isHandleByHandOrAuto(RptWeaveParams schmParam, String key, boolean isAutoHandle) {
        boolean isHandleByHand = false;
        isHandleByHand = schmParam.containsKey(key) ? schmParam.getBoolean(key) : isAutoHandle;
        return isHandleByHand;
    }
}

