/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.table.KdfToBook;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeForEntityEnum;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimInvestRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.InvestDataProviderFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.MaintainYearInitDataFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.fill.AsstActObject;
import com.kingdee.eas.fi.gr.dynamic.fill.ClearUpBook;
import com.kingdee.eas.fi.gr.dynamic.fill.DynaItemBeforeFill;
import com.kingdee.eas.fi.gr.dynamic.fill.GradeFillDynaItem;
import com.kingdee.eas.fi.gr.dynamic.fill.IFillDynaItem;
import com.kingdee.eas.fi.gr.dynamic.fill.MultiDynaItemFillHandle;
import com.kingdee.eas.fi.gr.dynamic.fill.NormalFillDynaItem;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcHelper;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.sqlGetData.FillSqlGetDataHelp;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.rptdata.RptDataFacade;
import com.kingdee.eas.fi.rpt.sqlUtil.SqlResultFillter;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.FillSheetAssistant;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgActualRecordPropertyAdapter;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptWeaveReportCalculate {
    protected static final Logger logger = Logger.getLogger(RptWeaveReportCalculate.class);
    Context ctx;
    private OrgUnitInfo company = null;
    private boolean isFillOwnCompany = true;
    private boolean isFillByCol = false;

    public RptWeaveReportCalculate(Context ctx, OrgUnitInfo company) {
        this.ctx = ctx;
        this.company = company;
        boolean[] paramValue = CSLParamUtil.batchGetBooleanCslParam(ctx, new String[]{"KEY_CSLPARAM_IsFillSheetByCol", "FillIncludeReportOrganizationItself"});
        this.isFillByCol = paramValue[0];
        this.isFillOwnCompany = paramValue[1];
    }

    public void interOrExchFillCompanyAndCalc(ReportBaseInfo reportInfo, boolean isCslrpt) throws Exception {
        int i;
        Object info;
        Book book = this.prepareCalculate(reportInfo, isCslrpt);
        Sheet sheet = null;
        boolean isAutoCalculate = book.isAutoCalculate();
        book.getUndoManager().enable(false);
        book.setAutoCalculate(false);
        String currCompanyId = reportInfo.getCompany().getId().toString();
        OrgType orgType = OrgType.Company;
        if (reportInfo instanceof ReportInfo) {
            info = (ReportInfo)reportInfo;
            orgType = info.getOrgType();
        } else if (reportInfo instanceof CslReportInfo) {
            info = (CslReportInfo)reportInfo;
            orgType = info.getOrgType();
        }
        logger.info((Object)("start fill company:" + reportInfo.getId()));
        for (i = 0; i < book.getSheetCount(); ++i) {
            sheet = book.getSheet(i);
            this.autoFillCompany(book, sheet, currCompanyId, reportInfo, orgType);
        }
        if (book.getUndoManager().isEnable()) {
            book.getUndoManager().enable(false);
        }
        logger.info((Object)"start report Calculate!");
        book = this.calcCslrptOrRpt(reportInfo, isCslrpt, book);
        logger.info((Object)"start remove ZeroRow!");
        book.getUndoManager().startGroup();
        for (i = 0; i < book.getSheetCount(); ++i) {
            ClearUpBook clearupbook;
            sheet = book.getSheet(i);
            int reportClass = CslRptUtil.getReportClass(book, sheet);
            if (CslRptUtil.isInterOrExchSheet(reportClass)) {
                clearupbook = new ClearUpBook(book, true);
                clearupbook.removeZeroRowAndFillDigit(sheet);
                continue;
            }
            if (!this.isInvestSheet(reportClass)) continue;
            clearupbook = new ClearUpBook(book, true);
            clearupbook.removeZeroRow(sheet);
        }
        book.getUndoManager().endGroup();
        book.setAutoCalculate(isAutoCalculate);
        book.getUndoManager().enable(true);
        reportInfo.setBook(book);
        this.updateCslRptOrRpt(reportInfo, isCslrpt);
        sheet = null;
        book = null;
        reportInfo = null;
    }

    private Book calcCslrptOrRpt(ReportBaseInfo reportInfo, boolean isCslrpt, Book book) throws Exception {
        ReportInfo info;
        if (!isCslrpt && (info = (ReportInfo)reportInfo).getCslReport() != null) {
            String cslrptid = info.getCslReport().getId().toString();
            reportInfo = CslReportFactory.getLocalInstance(this.ctx).getCslReportInfo((IObjectPK)new ObjectUuidPK(cslrptid));
            isCslrpt = true;
        }
        if (isCslrpt && (reportInfo.getSourceType() == RptSrcTypeEnum.NORMAL || reportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || reportInfo.getSourceType() == RptSrcTypeEnum.COMMITREPORT) && ((CslReportInfo)reportInfo).getAdjustStatus().getValue() != 1) {
            this.fillYearInitData(this.ctx, reportInfo.getId().toString(), book);
        }
        this.calcBook(book, reportInfo);
        return book;
    }

    public Book prepareCalculate(ReportBaseInfo reportInfo, boolean isCslrpt) throws Exception {
        Book book = null;
        book = isCslrpt ? this.prepareCalculate(this.ctx, (CslReportInfo)reportInfo) : this.prepareCalculate(this.ctx, (IObjectValue)reportInfo, null, reportInfo.getBook(), null);
        return book;
    }

    public void fillDynamicItemsandCalc(ReportBaseInfo reportInfo, boolean isCslrpt) throws Exception {
        Book book = this.prepareCalculate(reportInfo, isCslrpt);
        Sheet sheet = null;
        boolean isDynamicRpt = this.isDynamicReport(reportInfo);
        book.getUndoManager().enable(false);
        boolean isAutoCalculate = book.isAutoCalculate();
        book.setAutoCalculate(false);
        if (isDynamicRpt) {
            logger.info((Object)("start autoFillDynamic:" + reportInfo.getId()));
            IReportPropertyAdapter adapter = this.getAdapter(reportInfo);
            for (int i = 0; i < book.getSheetCount(); ++i) {
                sheet = book.getSheet(i);
                if (reportInfo.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT || reportInfo.getSourceType() == RptSrcTypeEnum.MULTIDYNAMICSUMREPORT) {
                    this.autoFillMultiDyna(sheet, adapter, reportInfo.getCompany(), this.ctx);
                    continue;
                }
                ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
                this.autoFillDynamicItems(sheet, basePointList, adapter);
            }
        }
        logger.info((Object)"start report Calculate!");
        book = this.calcCslrptOrRpt(reportInfo, isCslrpt, book);
        logger.info((Object)"start removeZeroAndSort!");
        if (isDynamicRpt) {
            ClearUpBook clearupbook = new ClearUpBook(book, true);
            clearupbook.removeZeroAndSortDynaItem(reportInfo.getSourceType(), true);
        }
        book.setAutoCalculate(isAutoCalculate);
        book.getUndoManager().enable(true);
        reportInfo.setBook(book);
        this.updateCslRptOrRpt(reportInfo, isCslrpt);
        sheet = null;
        book = null;
        reportInfo = null;
    }

    private boolean isDynamicReport(ReportBaseInfo reportInfo) {
        boolean isDynamicRpt = RptWeaveCalcHelper.isDynamicRpt(reportInfo);
        return isDynamicRpt;
    }

    protected void autoFillMultiDyna(Sheet sheet, IReportPropertyAdapter adapter, FullOrgUnitInfo company, Context ctx) throws Exception {
        MultiDynaItemFillHandle handle = new MultiDynaItemFillHandle(sheet, null, true, null, ctx);
        handle.initVar(adapter, (OrgUnitInfo)company);
        handle.autoFillSheet();
    }

    private void updateCslRptOrRpt(ReportBaseInfo reportInfo, boolean isCslrpt) throws BOSException, EASBizException {
        this.setContext(reportInfo);
        if (isCslrpt) {
            CslReportFactory.getLocalInstance(this.ctx).update((IObjectPK)new ObjectUuidPK(reportInfo.getId()), (CoreBaseInfo)reportInfo);
        } else {
            ReportFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(reportInfo.getId()), (CoreBaseInfo)reportInfo);
        }
    }

    private synchronized void setContext(ReportBaseInfo reportInfo) throws BOSException, EASBizException {
        String companyid = null;
        if (reportInfo instanceof CslReportInfo) {
            CslReportInfo cslreport = (CslReportInfo)reportInfo;
            companyid = cslreport.getOrgUnit().getId().toString();
        } else if (reportInfo instanceof ReportInfo) {
            ReportInfo report = (ReportInfo)reportInfo;
            companyid = report.getCompany().getId().toString();
        }
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        this.ctx.put((Object)"CompanyInfo", (Object)fullOrgUnitInfo);
        this.ctx.put((Object)OrgType.Company, (Object)MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType((OrgUnitInfo)fullOrgUnitInfo, this.ctx));
    }

    private Book prepareCalculate(Context ctx, IObjectValue reportInfo, KDF kdf, Book book, int[] index) throws Exception {
        if (book == null) {
            book = Book.Manager.getNewBook(null, (int)0);
        }
        BookProperties p = BookProperties.loadFromBook((Book)book);
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        calcContext.setPermission(new ChecFmlParamPermissionUtil(ctx));
        if (reportInfo instanceof BgFormInfo) {
            calcContext.setErrorProvider((IErrorProvider)p.getErrorProvider());
            calcContext.setReportVariables(p.getVariables());
            calcContext.setReportAdapter((IReportPropertyAdapter)new BgRptReportPropertyAdapter((BgFormInfo)reportInfo));
        } else if (reportInfo instanceof ReportInfo) {
            ReportInfo report = (ReportInfo)reportInfo;
            if (report.getPeriodType() == null) {
                report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
            }
            ReportCalculateErrorProvider errorhandler = null;
            errorhandler = (ReportCalculateErrorProvider)reportInfo.get("RPT_ERRORHANDLER");
            if (errorhandler != null) {
                calcContext.setErrorProvider((IErrorProvider)errorhandler);
            } else {
                calcContext.setErrorProvider((IErrorProvider)p.getErrorProvider());
            }
            BookProperties bookProperties = BookProperties.loadFromBook((Book)book);
            calcContext.setReportVariables(bookProperties.getVariables());
            calcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
        } else if (reportInfo instanceof BgActualRecordInfo) {
            calcContext.setErrorProvider((IErrorProvider)p.getErrorProvider());
            calcContext.setReportVariables(p.getVariables());
            calcContext.setReportAdapter((IReportPropertyAdapter)new BgActualRecordPropertyAdapter((BgActualRecordInfo)reportInfo));
        }
        FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)calcContext);
        book.getUndoManager().enable(false);
        book.setCalculate(false);
        int ii = 0;
        if (kdf != null) {
            int size = kdf.getAllTable().size();
            this.getBookFromKDF(kdf, book);
            if (index != null) {
                for (ii = 0; ii < size; ++ii) {
                    if (index[ii] >= 0) continue;
                }
            }
        } else {
            List tbls = (List)reportInfo.get("FORMULA_DATA");
            if (tbls != null) {
                List sheetKeys = (List)reportInfo.get("keys");
                List names = (List)tbls.remove(0);
                int size = tbls.size();
                for (ii = 0; kdf == null && ii < size; ++ii) {
                    List tbl;
                    Sheet sheet = book.getSheet((String)names.get(ii));
                    if (sheet == null) {
                        sheet = new Sheet(book, (String)names.get(ii));
                        book.insertSheet(ii, sheet);
                    }
                    if (sheetKeys != null) {
                        sheet.setUserObject("keys", sheetKeys.get(ii));
                    }
                    if (index != null && index[ii] < 0) {
                        sheet.setEnableCalculation(false);
                    }
                    if ((tbl = (List)tbls.get(ii)) == null) continue;
                    for (int j = 0; j < tbl.size(); ++j) {
                        List row = (List)tbl.get(j);
                        Row row2 = sheet.getRow(j, true);
                        if (row == null) continue;
                        for (int k = 0; k < row.size(); ++k) {
                            Cell cell = row2.getCell(k, true);
                            Object obj = row.get(k);
                            if (obj instanceof String) {
                                String s = (String)obj;
                                if (StringUtils.isEmpty((String)s)) continue;
                                cell.setFormula(s);
                                continue;
                            }
                            cell.setValue(new Variant(obj));
                        }
                    }
                }
            }
        }
        book.getUndoManager().enable(false);
        return book;
    }

    private void getBookFromKDF(KDF kdf, Book book) {
        int ii = 0;
        Iterator iter = kdf.getAllTable().iterator();
        int size = kdf.getAllTable().size();
        KDTable[] tbls = new KDTable[size];
        while (iter.hasNext()) {
            KDTable table = (KDTable)iter.next();
            table.getScriptManager().setAutoRun(false);
            table.setFormulaMode(1);
            tbls[ii] = table;
            ++ii;
        }
        new KdfToBook().getBook(book, tbls);
    }

    public OrgUnitInfo getCurrentCU(OrgUnitInfo company) {
        if (company.isIsCU()) {
            return company;
        }
        return company.getCU();
    }

    private void autoFillCompany(Book book, Sheet sheet, String currCompanyId, ReportBaseInfo reportInfo, OrgType orgType) throws Exception {
        int reportClass = CslRptUtil.getReportClass(book, sheet);
        boolean isInterExch = CslRptUtil.isInterOrExchSheet(reportClass);
        if (isInterExch) {
            this.fillCompanyForInterAndExch(book, sheet, currCompanyId, reportInfo, orgType);
        } else if (this.isInvestSheet(reportClass)) {
            this.fillCompanyForInvest(book, sheet, reportInfo, currCompanyId, orgType);
        }
    }

    private void fillCompanyForInvest(Book book, Sheet sheet, ReportBaseInfo reportInfo, String currCompanyId, OrgType orgType) throws Exception {
        HashMap<String, Object> userObject = new HashMap<String, Object>();
        if (sheet.getUserObject("orgBound_number") != null) {
            String treeid;
            OrgUnitInfo orgUnit;
            int year = reportInfo.getYear();
            short period = reportInfo.getPeriod();
            RptPeriodTypeEnum periodType = reportInfo.getPeriodType();
            Date date = RPTDateUtil.getPeriodLastDate(year, period, periodType);
            String treeNumber = (String)sheet.getUserObject("orgBound_number").getValue();
            String unitNumber = (String)sheet.getUserObject("orgUnit_number").getValue();
            String isIncludeAllTargCom = sheet.getUserObject("isIncludeAllTargCom") == null ? "false" : (String)sheet.getUserObject("isIncludeAllTargCom").getValue();
            OrgTreeInfo treeInfo = CslRptUtil.getOrgTreeByNumber(this.ctx, treeNumber, date);
            if (treeInfo != null && (orgUnit = this.getTheNewestOrgUnitInfo(treeid = treeInfo.getId().toString(), unitNumber)) != null) {
                String unitid = orgUnit.getId().toString();
                userObject.put("orgBoundId", treeid);
                userObject.put("orgUnitId", unitid);
                userObject.put("orgBound", treeInfo);
                userObject.put("orgUnit", orgUnit);
                userObject.put("isIncludeAllTargCom", isIncludeAllTargCom);
                userObject.put("companyId", currCompanyId);
                userObject.put("rptDate", date);
                userObject.put("effectDate", date);
                userObject.put("rptYear", year);
                userObject.put("rptPeriod", Integer.valueOf(period));
                userObject.put("rptPeriodType", periodType);
                if (periodType.equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                    HashMap<String, Comparable<Integer>> params = new HashMap<String, Comparable<Integer>>(7);
                    params.put("rptYear", Integer.valueOf(year));
                    params.put("rptPeriod", Integer.valueOf(period));
                    params.put("rptPeriodType", (Comparable<Integer>)periodType);
                    params.put("reportDate", date);
                    params.put("orgBound", (Comparable<Integer>)userObject.get("orgBound"));
                    params.put("orgUnit", (Comparable<Integer>)userObject.get("orgUnit"));
                    try {
                        ElimInvestRateFactory.getLocalInstance(this.ctx).autoCopyElimInvestRatePrePeriod(params);
                    }
                    catch (Exception e) {
                        logger.error((Object)"autoCopyElimInvestRatePrePeriod error.", (Throwable)e);
                    }
                }
                List companyList = InvestDataProviderFactory.getLocalInstance(this.ctx).getInvestCompanyList(userObject);
                FillSheetAssistant fillAssistant = new FillSheetAssistant();
                fillAssistant.fillSheetByOverlay(sheet, 0, 0, true, companyList, true);
            }
        }
    }

    private OrgUnitInfo getTheNewestOrgUnitInfo(String treeid, String unitNumber) throws EASBizException, BOSException {
        OrgStructureInfo structure = OrgStructureFactory.getLocalInstance((Context)this.ctx).getOrgStructureInfo("select unit.id,unit.number,unit.name,unit.longnumber where unit.number = '" + unitNumber + "' and tree.id = '" + treeid + "'");
        OrgUnitInfo orgUnit = null;
        if (structure != null && structure.getUnit() != null) {
            orgUnit = new OrgUnitInfo();
            orgUnit.setId(structure.getUnit().getId());
            orgUnit.setNumber(structure.getUnit().getNumber());
            orgUnit.setName(structure.getUnit().getName());
            orgUnit.setLongNumber(structure.getUnit().getLongNumber());
        }
        return orgUnit;
    }

    private void fillCompanyForInterAndExch(Book book, Sheet sheet, String currCompanyId, ReportBaseInfo reportInfo, OrgType orgType) throws BOSException, EASBizException {
        Set filledCompanyIds;
        Object[] res = null;
        FillSheetAssistant fillsheet = new FillSheetAssistant();
        try {
            CslRptUtil.setOrgTreeInfo(this.ctx, (VirtualSheetParamInfo)reportInfo, sheet);
        }
        catch (Exception e) {
            logger.error((Object)"RptWeaveReportCalculate_fillCompanyForInterAndExch_error", (Throwable)e);
        }
        UserObject userObject = sheet.getUserObject("orgBound");
        boolean isProfitCenter = orgType.getValue() != 1;
        res = fillsheet.getCompanysByFormulas(this.ctx, sheet, reportInfo, this.getAdapter(reportInfo), (OrgUnitInfo)reportInfo.getCompany(), userObject != null ? (String)userObject.getValue() : null, isProfitCenter);
        if (res == null) {
            if (userObject != null) {
                res = CslRptUtil.getAllCompanyByOrgTree((String)userObject.getValue(), this.ctx);
            } else {
                boolean isIncludeGroupUnit = this.getBookProperties(book).isIncludeGroupUnit();
                res = isProfitCenter ? CslRptUtil.getAllProfitCenterOrgUnit(null, isIncludeGroupUnit, this.ctx) : CslRptUtil.getAllCompanyOrgUnit(null, isIncludeGroupUnit, this.ctx);
            }
        }
        if ((filledCompanyIds = CslRptUtil.getFilledCompanyIds(sheet, 0, 0, true)) != null && !filledCompanyIds.isEmpty()) {
            ClearUpBook clearupbook = new ClearUpBook(book, true);
            try {
                clearupbook.insertDigitCol(sheet);
            }
            catch (Exception e1) {
                logger.error((Object)"insertDigitCol error.", (Throwable)e1);
            }
        }
        List companyList = fillsheet.clipCompanyByFilledComp(false, filledCompanyIds, res, currCompanyId, this.isFillOwnCompany);
        if (this.isFillByCol) {
            fillsheet.fillSheetByCol(sheet, 0, 0, true, companyList, true);
        } else {
            fillsheet.fillSheetWithAllDataInList(sheet, 0, 0, true, companyList, true);
        }
    }

    private IReportPropertyAdapter getAdapter(ReportBaseInfo reportInfo) {
        Object adapter = null;
        if (reportInfo instanceof ReportInfo) {
            adapter = new RptReportPropertyAdapter((ReportInfo)reportInfo);
        } else if (reportInfo instanceof CslReportInfo) {
            adapter = new CSLPropertyAdapter((CslReportInfo)reportInfo, this.ctx);
        }
        return adapter;
    }

    private void autoFillDynamicItems(Sheet sheet, ArrayList basePointList, IReportPropertyAdapter adapter) throws UIException, Exception {
        DynaItemBeforeFill dynaItemBeforeFill = null;
        OrgUnitInfo cu = this.getCurrentCU(this.company);
        boolean paramIsTrue = RptUtil.isTrue((Object)ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(cu.getId()), (String)"fi_rp_004"));
        boolean isIncludeFreezedParam = RptUtil.isTrue((Object)ParamManager.getParamValue((Context)this.ctx, (IObjectPK)new ObjectUuidPK(cu.getId()), (String)"GR_CSL_IsIncludeFreezedbyAsstAct"));
        NormalFillDynaItem fillDynaItem = null;
        if (basePointList != null && basePointList.size() > 0) {
            for (int i = basePointList.size() - 1; i >= 0; --i) {
                Point basepoint = (Point)basePointList.get(i);
                DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)sheet, (Point)basepoint);
                boolean isSqlFillData = false;
                try {
                    Range sqlRang = sheet.getRange(basepoint.y, basepoint.x);
                    boolean bl = isSqlFillData = sqlRang.getUserObject("sqlText") != null;
                    if (!isSqlFillData) {
                        sqlRang = sheet.getRange(basepoint.y + 1, basepoint.x);
                        isSqlFillData = sqlRang.getUserObject("sqlText") != null;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"autoFillDynamicItems get sqlRang error:", (Throwable)e);
                }
                if (isSqlFillData) {
                    try {
                        this.fillDataFromSql(sheet, basepoint, param, adapter);
                    }
                    catch (Exception e) {
                        logger.error((Object)"RptWeaveReportCalculate fillDataFromSql error ", (Throwable)e);
                    }
                    continue;
                }
                if (param.getDynaItemSource() == 0) {
                    DItemGradeEntryInfo entry;
                    ItemFormula item;
                    Sheet.RowsIterator it;
                    if (!param.isGrade()) continue;
                    DItemGradeInfo gradeInfo = DynamicTemplateUtility.getGradeInfo((Range)sheet.getRange(basepoint.y, basepoint.x));
                    ArrayList<Point> pos_array = new ArrayList<Point>();
                    if (param.getSpreadStyle() == 0) {
                        it = sheet.getRowsIterator(basepoint.y + 1, basepoint.y + param.getDefaultCounter(), false);
                        while (it.hasNext()) {
                            Row r = it.next();
                            item = UserObjectHelper.getItemFormula((Cell)r.getCell(basepoint.x, false));
                            if (item == null || (entry = gradeInfo.find(item.getExt("GRADE_NUMBER"))) == null || entry.isLeaf() || !entry.isIncludeUnknowDetail() || entry != null && entry.getDetailSource() == 0) continue;
                            pos_array.add(new Point(basepoint.x, r.getRow()));
                        }
                    } else {
                        it = sheet.getColsIterator(basepoint.x + 1, basepoint.x + param.getDefaultCounter(), false);
                        while (it.hasNext()) {
                            Column col = it.next();
                            item = UserObjectHelper.getItemFormula((Cell)sheet.getCell(basepoint.y, col.getCol(), false));
                            if (item == null || (entry = gradeInfo.find(item.getExt("GRADE_NUMBER"))) == null || entry.isLeaf() || !entry.isIncludeUnknowDetail() || entry != null && entry.getDetailSource() == 0) continue;
                            pos_array.add(new Point(col.getCol(), basepoint.y));
                        }
                    }
                    for (int x = pos_array.size() - 1; x > -1; --x) {
                        dynaItemBeforeFill = new DynaItemBeforeFill(paramIsTrue, sheet, true, (Point)pos_array.get(x), true, this.company, this.getCurrentCU(this.company), this.ctx);
                        dynaItemBeforeFill.setReportPropertyAdapter(adapter);
                        fillDynaItem = new GradeFillDynaItem(dynaItemBeforeFill);
                        this.autoFill((IFillDynaItem)fillDynaItem, dynaItemBeforeFill, sheet, isIncludeFreezedParam);
                    }
                    continue;
                }
                if (param.getDynaItemSource() == 0) continue;
                dynaItemBeforeFill = new DynaItemBeforeFill(paramIsTrue, sheet, true, basepoint, true, this.company, this.getCurrentCU(this.company), this.ctx);
                dynaItemBeforeFill.setReportPropertyAdapter(adapter);
                String curView = "0";
                String rptDataCollectNumber = "ACTUALDATA";
                fillDynaItem = new NormalFillDynaItem(dynaItemBeforeFill, false, curView, rptDataCollectNumber);
                this.autoFill((IFillDynaItem)fillDynaItem, dynaItemBeforeFill, sheet, isIncludeFreezedParam);
            }
        }
    }

    private boolean fillDataFromSql(Sheet sheet, Point basePoint, DynaParameters param, IReportPropertyAdapter adapt) throws BOSException {
        ReportVariables vars = ReportVariables.loadFromBook((Book)sheet.getBook());
        return FillSqlGetDataHelp.getInstance((Context)this.ctx, (Sheet)sheet, (Point)basePoint, (DynaParameters)param, (ReportVariables)vars, (IReportPropertyAdapter)adapt, (Book)sheet.getBook()).fillDataFormSql();
    }

    private void autoFill(IFillDynaItem fillDynaItem, DynaItemBeforeFill dynaItemBeforeFill, Sheet sheet, boolean isIncludeFreezedParam) throws Exception {
        if (dynaItemBeforeFill.getAssistantType() == null) {
            return;
        }
        if (dynaItemBeforeFill.getAsstActTypeInfo() == null) {
            return;
        }
        IMetaDataPK queryPK = dynaItemBeforeFill.getQueryPK(false, isIncludeFreezedParam);
        IQueryExecutor exec = dynaItemBeforeFill.getQueryExecutor(queryPK, OrgTypeForEntityEnum.NULL, isIncludeFreezedParam);
        this.setAssitantSubTypeFilterForByParam(exec, dynaItemBeforeFill);
        List fillData = dynaItemBeforeFill.getFillData(exec, queryPK);
        this.fill(fillDynaItem, dynaItemBeforeFill, fillData, sheet);
    }

    private void setAssitantSubTypeFilterForByParam(IQueryExecutor exec, DynaItemBeforeFill dynaItemBeforeFill) throws Exception {
        DynaParameters param = dynaItemBeforeFill.getParam();
        if (param.isGrade() && param.getDynaItemSource() == 0) {
            this.setAssistantSubTypeFilterForGradeSum(exec, dynaItemBeforeFill);
        } else if (param.getDynaItemSource() != 0) {
            this.setAssistantSubTypeFilterForFillGard(exec, dynaItemBeforeFill);
        }
    }

    private void setAssistantSubTypeFilterForGradeSum(IQueryExecutor exec, DynaItemBeforeFill dynaItemBeforeFill) throws Exception {
        String asstHGAttribute;
        if (dynaItemBeforeFill != null && dynaItemBeforeFill.getGradeEntryInfo() != null && dynaItemBeforeFill.getGradeEntryInfo().getDetailSource() != 0 && DynamicTemplateUtility.isBaseAsstActType((String)(asstHGAttribute = dynaItemBeforeFill.getAsstActTypeInfo().getAsstHGAttribute()))) {
            String groups = dynaItemBeforeFill.getGradeEntryInfo().getAsstActSubTypeString();
            this.setFilterByNumber(exec, asstHGAttribute, groups);
        }
    }

    private void setAssistantSubTypeFilterForFillGard(IQueryExecutor exec, DynaItemBeforeFill dynaItemBeforeFill) throws Exception {
        String asstHGAttribute;
        DynaParameters param = dynaItemBeforeFill.getParam();
        if (param.getDynaItemSource() != 0 && DynamicTemplateUtility.isBaseAsstActType((String)(asstHGAttribute = param.getAssistantType().getAsstHGAttribute())) && param != null && param.getAssistantTypeSubType() != null) {
            String groups = param.getAssistantTypeSubType();
            this.setFilterByNumber(exec, asstHGAttribute, groups);
        }
    }

    private void setFilterByNumber(IQueryExecutor exec, String asstHGAttribute, String groups) throws Exception {
        EntityViewInfo viewInfo = exec.getObjectView();
        FilterInfo filter = this.getAssistantSubTypeFilterByNumber(asstHGAttribute, groups);
        if (filter != null && filter.getFilterItems() != null && filter.getFilterItems().size() > 0) {
            if (viewInfo.getFilter() == null) {
                viewInfo.setFilter(new FilterInfo());
            }
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
    }

    private FilterInfo getAssistantSubTypeFilterByNumber(String asstHGAttribute, String groups) throws Exception {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (groups.equals("all")) {
            return filter;
        }
        AcctountAsstItemParser.AccountAsstItem item = TableToolkit.parseAcctItem((String)("1002|001|" + groups + "#"));
        if (item == null) {
            return filter;
        }
        AcctountAsstItemParser.Group[] group = item.asstItems[0].group;
        String mask = null;
        int maskIndex = 0;
        for (int i = 0; group != null && i < group.length; ++i) {
            String endLongNumber;
            String startLongNumber;
            String std = group[i].standardNumber;
            mask = i == 0 ? "(#" + maskIndex++ : mask + " or (#" + maskIndex++;
            if (asstHGAttribute.equals("customer")) {
                fic.add(new FilterItemInfo("customerGroupDetails.CustomerGroupStandard.number", (Object)std));
                if (!StringUtils.isEmpty((String)group[i].startNumber) && !StringUtils.isEmpty((String)group[i].endNumber)) {
                    if (group[i].startNumber.equals(group[i].endNumber)) {
                        TreeBaseInfo customerGroup = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Customer");
                        if (customerGroup != null && !StringUtils.isEmpty((String)customerGroup.getLongNumber())) {
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)customerGroup.getLongNumber()));
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)(customerGroup.getLongNumber() + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.number", (Object)group[i].startNumber));
                            mask = mask + " and #" + maskIndex++;
                        }
                    } else {
                        TreeBaseInfo customerGroupStart = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Customer");
                        TreeBaseInfo customerGroupEnd = this.getTreeBaseNodeByNumber(group[i].endNumber, "T_BD_Customer");
                        if (customerGroupStart != null && customerGroupEnd != null && !StringUtils.isEmpty((String)customerGroupStart.getLongNumber()) && !StringUtils.isEmpty((String)customerGroupEnd.getLongNumber())) {
                            startLongNumber = customerGroupStart.getLongNumber();
                            endLongNumber = customerGroupEnd.getLongNumber();
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)startLongNumber, CompareType.GREATER_EQUALS));
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)endLongNumber, CompareType.LESS_EQUALS));
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.longNumber", (Object)(endLongNumber + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.number", (Object)group[i].startNumber));
                            fic.add(new FilterItemInfo("customerGroupDetails.customerGroup.number", (Object)group[i].endNumber));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + ")";
                        }
                    }
                }
            } else if (asstHGAttribute.equals("provider")) {
                fic.add(new FilterItemInfo("supplierGroupDetails.SupplierGroupStandard.number", (Object)std));
                if (!StringUtils.isEmpty((String)group[i].startNumber) && !StringUtils.isEmpty((String)group[i].endNumber)) {
                    if (group[i].startNumber.equals(group[i].endNumber)) {
                        TreeBaseInfo supplierGroup = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Supplier");
                        if (supplierGroup != null && !StringUtils.isEmpty((String)supplierGroup.getLongNumber())) {
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)supplierGroup.getLongNumber()));
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)(supplierGroup.getLongNumber() + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.number", (Object)group[i].startNumber));
                            mask = mask + " and #" + maskIndex++;
                        }
                    } else {
                        TreeBaseInfo supplierGroupStart = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Supplier");
                        TreeBaseInfo supplierGroupEnd = this.getTreeBaseNodeByNumber(group[i].endNumber, "T_BD_Supplier");
                        if (supplierGroupStart != null && supplierGroupEnd != null && !StringUtils.isEmpty((String)supplierGroupStart.getLongNumber()) && !StringUtils.isEmpty((String)supplierGroupEnd.getLongNumber())) {
                            startLongNumber = supplierGroupStart.getLongNumber();
                            endLongNumber = supplierGroupEnd.getLongNumber();
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)startLongNumber, CompareType.GREATER_EQUALS));
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)endLongNumber, CompareType.LESS_EQUALS));
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.longNumber", (Object)(endLongNumber + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.number", (Object)group[i].startNumber, CompareType.GREATER_EQUALS));
                            fic.add(new FilterItemInfo("supplierGroupDetails.supplierGroup.number", (Object)group[i].endNumber, CompareType.LESS_EQUALS));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + ")";
                        }
                    }
                }
            } else if (asstHGAttribute.equals("material")) {
                fic.add(new FilterItemInfo("materialGroupDetails.MaterialGroupStandard.number", (Object)std));
                if (!StringUtils.isEmpty((String)group[i].startNumber) && !StringUtils.isEmpty((String)group[i].endNumber)) {
                    if (group[i].startNumber.equals(group[i].endNumber)) {
                        TreeBaseInfo materialGroup = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Material");
                        if (materialGroup != null && !StringUtils.isEmpty((String)materialGroup.getLongNumber())) {
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)materialGroup.getLongNumber()));
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)(materialGroup.getLongNumber() + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.number", (Object)group[i].startNumber));
                            mask = mask + " and #" + maskIndex++;
                        }
                    } else {
                        TreeBaseInfo materialGroupStart = this.getTreeBaseNodeByNumber(group[i].startNumber, "T_BD_Material");
                        TreeBaseInfo materialGroupEnd = this.getTreeBaseNodeByNumber(group[i].endNumber, "T_BD_Material");
                        if (materialGroupStart != null && materialGroupEnd != null && !StringUtils.isEmpty((String)materialGroupStart.getLongNumber()) && !StringUtils.isEmpty((String)materialGroupEnd.getLongNumber())) {
                            startLongNumber = materialGroupStart.getLongNumber();
                            endLongNumber = materialGroupEnd.getLongNumber();
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)startLongNumber, CompareType.GREATER_EQUALS));
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)endLongNumber, CompareType.LESS_EQUALS));
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.longNumber", (Object)(endLongNumber + "!%"), CompareType.LIKE));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + " or #" + maskIndex++ + ")";
                        } else {
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.number", (Object)group[i].startNumber, CompareType.GREATER_EQUALS));
                            fic.add(new FilterItemInfo("materialGroupDetails.materialGroup.number", (Object)group[i].endNumber, CompareType.LESS_EQUALS));
                            mask = mask + " and (#" + maskIndex++ + " and #" + maskIndex++ + ")";
                        }
                    }
                }
            }
            mask = mask + ")";
        }
        filter.setMaskString(mask);
        return filter;
    }

    protected TreeBaseInfo getTreeBaseNodeByNumber(String number, String groupTableName) throws Exception {
        ICSSPGroup treeBase = null;
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        String string = "Select Number, LongNumber, Name Where number = '" + number + "' ";
        if (groupTableName.equalsIgnoreCase("T_BD_Customer")) {
            treeBase = CSSPGroupFactory.getLocalInstance((Context)this.ctx);
            string = string + " AND (groupStandard.type=1 or groupStandard.type=0)";
        } else if (groupTableName.equalsIgnoreCase("T_BD_Supplier")) {
            treeBase = CSSPGroupFactory.getLocalInstance((Context)this.ctx);
            string = string + " AND (groupStandard.type=2 or groupStandard.type=0)";
        } else if (groupTableName.equalsIgnoreCase("T_BD_Material")) {
            treeBase = MaterialGroupFactory.getLocalInstance((Context)this.ctx);
        } else {
            throw new Exception("No supported group.");
        }
        CoreBaseCollection colls = treeBase.getCollection(string);
        if (colls == null || colls.size() < 1) {
            return null;
        }
        return (TreeBaseInfo)colls.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill(IFillDynaItem fillDynaItem, DynaItemBeforeFill dynaItemBeforeFill, List fillData, Sheet curSheet) throws Exception {
        if (fillData == null || fillData.isEmpty()) {
            return;
        }
        AsstActTypeInfo asstActTypeInfo = dynaItemBeforeFill.getAsstActTypeInfo();
        DynaParameters param = dynaItemBeforeFill.getParam();
        if (asstActTypeInfo.isIsMultilevel() && (param.getDynaItemSource() != 1 || !param.isGrade())) {
            ArrayList<AsstActObject> newList = new ArrayList<AsstActObject>();
            AsstActObject ditemInfo = null;
            for (int j = 0; j < fillData.size(); ++j) {
                ditemInfo = (AsstActObject)fillData.get(j);
                if (ditemInfo.isSelfAsstActaiatem() && CslRptUtil.isLeaf(fillData, ditemInfo)) {
                    ditemInfo.setLeaf(true);
                }
                if (!ditemInfo.isLeaf()) continue;
                newList.add(ditemInfo);
            }
            fillData.clear();
            fillData.addAll(newList);
        }
        Map tempStyle = null;
        Point basePoint = new Point(dynaItemBeforeFill.getLeft(), dynaItemBeforeFill.getTop());
        tempStyle = new HashMap();
        tempStyle = DynamicTemplateUtility.getCurBasePointFirstLineStyle(tempStyle, (Sheet)curSheet, (Point)basePoint);
        boolean autoCalculate = curSheet.getBook().isAutoCalculate();
        curSheet.getBook().setCalculate(false);
        try {
            curSheet.getBook().getUndoManager().enable(false);
            curSheet.getBook().setSkipListeners(true);
            curSheet.getBook().getUndoManager().startGroup();
            DynaItemListener.setListener((boolean)false);
            fillDynaItem.setFillData(fillData);
            fillDynaItem.setCoverRecord(true);
            fillDynaItem.prepare();
            fillDynaItem.fill();
        }
        finally {
            curSheet.getBook().setSkipListeners(false);
            curSheet.getBook().getUndoManager().enable(true);
            curSheet.getBook().setCalculate(autoCalculate);
            curSheet.getBook().getUndoManager().endGroup();
        }
        if (tempStyle == null) {
            return;
        }
        DynamicTemplateUtility.setCurBasePointFirstLineStyle(tempStyle, (Sheet)curSheet, (Point)basePoint);
        DynamicTemplateUtility.reAdjustSheetCurBasePointAlign((Point)basePoint, (Sheet)curSheet);
        tempStyle = null;
    }

    public boolean cslRptCalculate(CslReportInfo cslReportInfo) throws Exception {
        ICslReport iReport = CslReportFactory.getLocalInstance(this.ctx);
        Book book = this.prepareCalculate(this.ctx, cslReportInfo);
        if ((cslReportInfo.getSourceType() == RptSrcTypeEnum.NORMAL || cslReportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || cslReportInfo.getSourceType() == RptSrcTypeEnum.COMMITREPORT) && cslReportInfo.getAdjustStatus().getValue() != 1) {
            this.fillYearInitData(this.ctx, cslReportInfo.getId().toString(), book);
        }
        this.calcBook(book, cslReportInfo);
        cslReportInfo.setBook(book);
        iReport.submit((CoreBaseInfo)cslReportInfo);
        return true;
    }

    protected void calcBook(Book book, ReportBaseInfo reportInfo) {
        RptDataFacade rptDataRecorder = new RptDataFacade();
        rptDataRecorder.startRecordRptData(this.ctx, reportInfo, book);
        boolean isAutoCalculate = book.isAutoCalculate();
        book.setCalculate(false);
        this.calcSqlGetData(book, reportInfo);
        book.calc();
        book.setCalculate(isAutoCalculate);
        NewRptUtil.fillDItem((Context)this.ctx, (ReportBaseInfo)reportInfo, (Book)book);
        rptDataRecorder.endRecordRptData();
    }

    private Book prepareCalculate(Context ctx, CslReportInfo reportInfo) throws Exception {
        Book book = null;
        book = reportInfo.getData() != null ? reportInfo.getBook() : Book.Manager.getNewBook((String)"Sheet1", (int)1);
        book.setCalculate(false);
        BookProperties p = BookProperties.loadFromBook((Book)book);
        CSLPropertyAdapter adapter = new CSLPropertyAdapter();
        adapter.initReportProperties((IObjectValue)reportInfo, ctx);
        ReportCalculateContext context = new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, p.getVariables(), (IErrorProvider)p.getErrorProvider(), null);
        context.setPermission(new ChecFmlParamPermissionUtil(ctx));
        FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)context);
        return book;
    }

    private void fillYearInitData(Context ctx, String reportId, Book book) throws Exception {
        List valueList = MaintainYearInitDataFacadeFactory.getLocalInstance(ctx).getCellValueFromYearInitDataByReportID(reportId);
        boolean needGetCellItemFormula = true;
        Map cellItemFormula = new HashMap();
        if (valueList != null) {
            Iterator valueIt = valueList.iterator();
            HashMap valueMap = null;
            BigDecimal zero = new BigDecimal("0");
            while (valueIt.hasNext()) {
                String itemFormula;
                valueMap = (HashMap)valueIt.next();
                BigDecimal value = null;
                int dc = (Integer)valueMap.get("RptItemDC");
                if (valueMap.get("Debit") != null && ((BigDecimal)valueMap.get("Debit")).compareTo(zero) != 0) {
                    value = ((BigDecimal)valueMap.get("Debit")).multiply(new BigDecimal(dc == 1 ? "1" : "-1"));
                }
                if (valueMap.get("Credit") != null && ((BigDecimal)valueMap.get("Credit")).compareTo(zero) != 0) {
                    value = ((BigDecimal)valueMap.get("Credit")).multiply(new BigDecimal(dc == 1 ? "-1" : "1"));
                }
                if (value == null) continue;
                String string = itemFormula = valueMap.get("itemFormula") == null ? null : (String)valueMap.get("itemFormula");
                if (needGetCellItemFormula) {
                    cellItemFormula = RptUtil.getBookCellItemFormula((Book)book, (boolean)false, (boolean)false);
                    needGetCellItemFormula = false;
                }
                if (itemFormula == null || cellItemFormula.get(itemFormula) == null) continue;
                Cell cell = (Cell)cellItemFormula.get(itemFormula);
                int currencyScale = (Integer)valueMap.get("CurrencyPrecision");
                value = value.setScale(currencyScale, 4);
                cell.setValue(new Variant((Object)value));
            }
        }
    }

    protected boolean isInvestSheet(int reportClass) throws Exception {
        return reportClass == 30 || reportClass == 40;
    }

    protected BookProperties getBookProperties(Book book) {
        BookProperties p = BookProperties.loadFromBook((Book)book);
        if (p == null) {
            p = new BookProperties();
            p.restoreToBook(book);
        }
        return p;
    }

    private void calcSqlGetData(Book book, ReportBaseInfo reportInfo) {
        SqlResultFillter fillter = new SqlResultFillter(this.ctx, book, false, reportInfo);
        fillter.fillResult();
    }
}

