/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.weaverpt.ExistNoReceRptSelectCalcEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveLinkEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumUnitEntryInfo;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptWeaveExecute;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class RptWeaveSumRptExec
extends AbstractRptWeaveExecute {
    private CslReportInfo cslRptInfo = null;
    RptWeaveSchmSumInfo schmSumInfo = null;
    RptAutoWeaveLogInfo logInfo = null;

    public RptWeaveSumRptExec(RptWeaveParams schmParam, Context ctx, RptAutoWeaveLogInfo logInfo) {
        super(schmParam, ctx);
        this.logInfo = logInfo;
    }

    public RptWeaveSumRptExec(RptWeaveParams schmParam, Context ctx) {
        super(schmParam, ctx);
    }

    @Override
    protected void executeRptWeave() throws Exception {
        IMutexServiceControl mutexService = null;
        boolean isgetMutex = false;
        try {
            mutexService = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
            this.initData();
            this.logInfo.setLinkType(RptWeaveLinkEnum.ADDNEW);
            this.addNew();
            isgetMutex = this.addLockRpt(mutexService);
            this.logInfo.setLinkType(RptWeaveLinkEnum.CALCULATE);
            boolean isContinue = this.calc();
            if (!isContinue) {
                return;
            }
            this.logInfo.setLinkType(RptWeaveLinkEnum.ADUIT);
            this.cslrptAduit(this.ctx, this.cslRptInfo);
            this.logInfo.setLinkType(RptWeaveLinkEnum.COMMIT);
            this.cslrptCommit(this.ctx, this.cslRptInfo);
            this.logInfo.setLinkType(RptWeaveLinkEnum.RECEIVE);
            this.cslReceive(this.ctx, this.cslRptInfo);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (isgetMutex) {
                mutexService.releaseObjIDForUpdate(this.cslRptInfo.getId().toString());
            }
        }
    }

    private boolean addLockRpt(IMutexServiceControl mutexService) throws Exception {
        boolean isgetMutex = mutexService.requestObjIDForUpdate(this.cslRptInfo.getId().toString());
        if (!isgetMutex) {
            throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"OBJECT_IS_LOCKED"));
        }
        return isgetMutex;
    }

    private void initData() {
        this.schmSumInfo = (RptWeaveSchmSumInfo)this.schmParam.getObject("rpt_weave_rptSchmObj");
    }

    public void addNew() throws Exception {
        TemplateInfo templateInfo = (TemplateInfo)this.schmParam.getObject("KEY_TEMPLATE");
        OrgTreeInfo unitTree = (OrgTreeInfo)this.schmParam.getObject("KEY_ORGTREE_INFO");
        OrgUnitInfo company = (OrgUnitInfo)this.schmParam.getObject("KEY_COMPANY");
        templateInfo = TemplateFactory.getLocalInstance((Context)this.ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)templateInfo.getId().toString())), RptAutoWeaveUtil.getTemplateSelectorForWeaveRpt());
        RptAutoWeaveUtil rptUtil = new RptAutoWeaveUtil();
        this.cslRptInfo = new CslReportInfo();
        ArrayList allKeyRow = new ArrayList();
        Object isSupportOtherDS = CslRptUtil.getParamValue(this.ctx, null, "GR_CSL_SupportOtherDS");
        DataCollectInfo dataCollect = RptAutoWeaveUtil.getDataColl();
        Date rptDate = (Date)this.schmParam.getObject("Day");
        CurrencyInfo currency = this.schmSumInfo.getCurrency();
        this.ctx.put((Object)"UserInfo", this.schmParam.getObject("UserInfo"));
        int ret = rptUtil.addNewEditData(this.ctx, this.cslRptInfo, templateInfo, currency, unitTree, company, allKeyRow, isSupportOtherDS, dataCollect, rptDate, true, null, null);
        if (2 == ret) {
            String error_msg = templateInfo.getString("ERROR_MSG");
            String msg = error_msg != null ? error_msg : EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"372_CslRptUIUtil");
            throw new RptWeaveException(msg);
        }
        if (1 == ret) {
            int year = this.schmParam.getInt("Year");
            int period = this.schmParam.getInt("Period");
            int periodType = templateInfo.getPeriodType().getValue();
            String templateGroupNumber = templateInfo.getGroup();
            int templateType = templateInfo.getTemplateType().getValue();
            int reportType = RptAutoWeaveUtil.getReportTypeByTempType(templateType);
            String sumRptId = this.getExistSumRptId(this.ctx, unitTree.getId().toString(), company.getId().toString(), periodType, year, period, currency.getId().toString(), templateGroupNumber, reportType);
            if (StringUtils.isEmpty((String)sumRptId)) {
                throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"REPORT_ISNOTEXISTED"));
            }
            ICslReport iReport = CslReportFactory.getLocalInstance(this.ctx);
            this.cslRptInfo = iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sumRptId)), RptAutoWeaveUtil.getCslRptSelectors());
        }
    }

    private boolean calc() throws Exception {
        boolean isShowTotal = this.schmSumInfo.isIsShowTotal();
        int displayNumber = this.schmSumInfo.getDisplayNumber();
        boolean isGradeList = this.schmSumInfo.isIsGradeOnlyList();
        boolean isOrderList = this.schmSumInfo.isIsOrderListCompany();
        ExistNoReceRptSelectCalcEnum selectCalcType = this.schmSumInfo.getExistNoReceRptCalcType();
        Vector needSumCompanys = new Vector();
        if (this.schmParam.getObject("needSumCompanys") == null) {
            for (int i = 0; i < this.schmSumInfo.getOrgUnitEntries().size(); ++i) {
                RptWeaveSchmSumUnitEntryInfo unitEntryInfo = this.schmSumInfo.getOrgUnitEntries().get(i);
                if (unitEntryInfo.getCompany().isIsUnion()) continue;
                needSumCompanys.add(unitEntryInfo.getCompany());
            }
        } else {
            needSumCompanys = (Vector)this.schmParam.getObject("needSumCompanys");
            if (needSumCompanys == null || needSumCompanys.size() == 0) {
                throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"UnitSUM_CompanyNull"));
            }
        }
        DynaSumMethodEnum sumMethod = this.schmSumInfo.getSumMethodType();
        boolean isByTemplate = sumMethod.equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE);
        Boolean isBySumReport = Boolean.TRUE;
        return true;
    }

    private boolean isTemplateDispense(Context ctx, String companyId, String templateId, String treeId, int FPeriodType) throws BOSException {
        StringBuffer sqlBuff = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        sqlBuff.append(" select 1 from  T_RPT_Template  TEMPLATE \t\n");
        sqlBuff.append(" inner  join T_CSL_TempletDispense d on TEMPLATE.fid = d.FDispenseSrcID  ");
        sqlBuff.append(" INNER JOIN T_ORG_Tree ORGBOUND ON d.FOrgBoundID = ORGBOUND.FID  ");
        sqlBuff.append(" INNER JOIN T_ORG_BaseUnit COMPANY ON d.FCompanyID = COMPANY.FID ");
        sqlBuff.append("   where d.FSourceType = 1  \n");
        sqlBuff.append("       and (TEMPLATE.FTemplateType = 3 OR TEMPLATE.FTemplateType = 11 OR TEMPLATE.FTemplateType = 17) \n");
        sqlBuff.append("      and ORGBOUND.FID=?  \n");
        sqlBuff.append("     and COMPANY.FID=?  \n");
        sqlBuff.append("   AND TEMPLATE.fid = ? \n");
        sqlBuff.append("    AND TEMPLATE.FPeriodType = ? ");
        params.add(treeId);
        params.add(companyId);
        params.add(templateId);
        params.add(new Integer(FPeriodType));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params.toArray());
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    private String getExistSumRptId(Context ctx, String treeID, String companyID, int periodType, int year, int period, String currencyID, String templateGroupNumber, int reportType) throws BOSException, EASBizException {
        String dataCollectNumber = "ACTUALDATA";
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        params.put("treeID", treeID);
        params.put("companyID", companyID);
        params.put("periodType", new Integer(periodType));
        params.put("year", new Integer(year));
        params.put("period", new Integer(period));
        params.put("currencyID", currencyID);
        params.put("templateGroupNumber", templateGroupNumber);
        params.put("reportType", new Integer(reportType));
        params.put("dataCollectNumber", dataCollectNumber);
        return RptAutoWeaveUtil.getSumRptid(ctx, params);
    }

    @Override
    protected void cslrptAduit(Context ctx, CslReportInfo editData) throws Exception {
        super.cslrptAduit(ctx, editData);
    }

    @Override
    protected void cslrptCommit(Context ctx, CslReportInfo editData) throws Exception {
        if (editData.getCommittedStatus() != null && !CommittedStatusEnum.UNCOMMITTED.equals((Object)editData.getCommittedStatus())) {
            return;
        }
        super.cslrptCommit(ctx, editData);
    }

    @Override
    protected void cslReceive(Context ctx, CslReportInfo editData) throws Exception {
        super.cslReceive(ctx, editData);
    }
}

