/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.MergeModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.fast.util.FastMergeUtil;
import com.kingdee.eas.fi.gr.weaverpt.IRptAutoWeaveLog;
import com.kingdee.eas.fi.gr.weaverpt.IRptWeaveSchmSum;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveLogSuccEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmSumInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTempEntryCollection;
import com.kingdee.eas.fi.gr.weaverpt.app.RptCalcSchemeHandle;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveSumRptExec;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SumCalcSchemeHandle
implements IJobHandler {
    protected static final Logger logger = Logger.getLogger(RptCalcSchemeHandle.class);

    public Object execute(Job job) throws Exception {
        Context ctx = job.getContext();
        RptWeaveParams schmParam = (RptWeaveParams)job.getParameters();
        RptWeaveSchmSumInfo schmRptInfo = (RptWeaveSchmSumInfo)schmParam.getObject("rpt_weave_rptSchmObj");
        String orgBound = schmRptInfo.getOrgBound().getId().toString();
        OrgTreeInfo treeInfo = (OrgTreeInfo)schmParam.getObject("KEY_ORGTREE_INFO");
        String forwardSchm = schmRptInfo.getDependSchm();
        boolean isHaveforwardSchm = !StringUtils.isEmpty((String)forwardSchm);
        boolean isSuccessForwardSchm = true;
        if (isHaveforwardSchm) {
            int year = schmParam.getInt("Year");
            int period = schmParam.getInt("Period");
            int periodType = schmRptInfo.getTemplateEtries().get(0).getTemplate().getTemplateType().getValue();
            isSuccessForwardSchm = this.isSuccessExecSchm(ctx, schmRptInfo.getDependSchm(), year, period, periodType);
        }
        if (MergeModeEnum.DIRECT == RptAutoWeaveUtil.getMergeMode(ctx, treeInfo.getId().toString())) {
            FullOrgUnitInfo unitInfo = RptAutoWeaveUtil.getTopOrgUnitInTree(ctx, treeInfo.getId().toString());
            if (unitInfo == null) {
                throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"DIRECT_ISNOTTOPUNIT"));
            }
            this.weaveSumRpt(ctx, schmParam, orgBound, unitInfo, isSuccessForwardSchm);
        } else {
            OrgTreeInfo unitTree = (OrgTreeInfo)schmParam.getObject("KEY_ORGTREE_INFO");
            UserInfo userInfo = (UserInfo)schmParam.getObject("UserInfo");
            Map compRelaMap = this.getLowestLevelCompRela(ctx, schmRptInfo.getId().toString(), unitTree.getId().toString(), userInfo.getId().toString());
            List needWeaveUnitList = this.getNeedWeaveSumUnit(ctx, schmRptInfo.getId().toString(), unitTree.getId().toString());
            FullOrgUnitInfo unitInfo = null;
            for (int i = 0; i < needWeaveUnitList.size(); ++i) {
                String fristCompKey = (String)needWeaveUnitList.get(i);
                ArrayList listValue = (ArrayList)compRelaMap.remove(fristCompKey);
                if (listValue == null) {
                    listValue = new ArrayList(1);
                }
                schmParam.setObject("needSumCompanys", new Vector(listValue));
                unitInfo = new FullOrgUnitInfo();
                unitInfo.setId(BOSUuid.read((String)fristCompKey));
                this.weaveSumRpt(ctx, schmParam, orgBound, unitInfo, isSuccessForwardSchm);
            }
        }
        RptWeaveExecParams execParam = (RptWeaveExecParams)schmParam.getObject("rpt_weave_execparams");
        if (execParam.isException()) {
            throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"RPTWEAVE_ERROR_SCHED"));
        }
        return null;
    }

    private List getNeedWeaveSumUnit(Context ctx, String schemeId, String treeId) throws BOSException {
        ArrayList<String> needWeaveUnitList = new ArrayList<String>();
        StringBuffer sqlBuff = new StringBuffer("");
        sqlBuff.append(" select schmUnit.fcompanyid funitid from  T_CSL_RptWeaveSchmSumUnitEntry schmUnit   \n ");
        sqlBuff.append("  INNER JOIN T_ORG_BaseUnit  BaseUnit on schmUnit.fcompanyid=BaseUnit.FID  \n ");
        sqlBuff.append("  INNER JOIN T_ORG_Structure Struct  on BaseUnit.FID =Struct.funitid  \n ");
        sqlBuff.append("  where schmUnit.fschemesumid=? and  Struct.FTreeId =?  \n ");
        sqlBuff.append("  and fisUnion=1 and FIsFreeze=0 order by Struct.flevel desc  \n ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(schemeId);
        params.add(treeId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                needWeaveUnitList.add(rs.getString("funitid"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return needWeaveUnitList;
    }

    private void setOrgMapAndWeaveSumUnit(Context ctx, String schemeId, String treeId, String userId, Map companyParentMap, Set needWeaveSumUnitSet) throws BOSException {
        StringBuffer sqlBuff = new StringBuffer("");
        sqlBuff.append("  SELECT  StructParent.funitid fparentUnitId,Struct.flevel,BaseUnit.fid fid,BaseUnit.fnumber fnumber,  \n ");
        sqlBuff.append("  BaseUnit.fisUnion isUnion  from   T_ORG_BaseUnit BaseUnit      \n ");
        sqlBuff.append("  INNER JOIN T_ORG_Structure Struct ON Struct.FUnitId =BaseUnit.fID        \n ");
        sqlBuff.append("  inner join  T_CSL_RptWeaveSchmSumUnitEntry schmUnit on schmUnit.fcompanyid=BaseUnit.FID       \n ");
        sqlBuff.append("  inner join   T_PM_OrgRange OrgRange  ON BaseUnit.FID = OrgRange.FOrgID       \n ");
        sqlBuff.append("  left join T_ORG_Structure  StructParent on Struct.fparentid=StructParent.fid       \n ");
        sqlBuff.append("  WHERE schmUnit.fschemesumid=?      \n ");
        sqlBuff.append("  and Struct.FTreeId =?      \n ");
        sqlBuff.append("  and OrgRange.FUserID =?    AND OrgRange.FType = 10      \n ");
        sqlBuff.append("  order by Struct.flevel desc      \n ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(schemeId);
        params.add(treeId);
        params.add(userId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params.toArray());
        this.constructOrgRela(companyParentMap, needWeaveSumUnitSet, rs);
    }

    private void constructOrgRela(Map companyParentMap, Set needWeaveSumUnitSet, IRowSet rs) throws SQLDataException {
        try {
            while (rs.next()) {
                String parentIdKey;
                boolean isUnit = rs.getBoolean("isUnion");
                if (isUnit) {
                    needWeaveSumUnitSet.add(rs.getString("fid"));
                }
                if (StringUtils.isEmpty((String)(parentIdKey = rs.getString("fparentUnitId")))) continue;
                FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                orgUnitInfo.setNumber(rs.getString("fnumber"));
                if (companyParentMap.containsKey(parentIdKey)) {
                    ((List)companyParentMap.get(parentIdKey)).add(orgUnitInfo);
                    continue;
                }
                ArrayList<FullOrgUnitInfo> companyList = new ArrayList<FullOrgUnitInfo>();
                companyList.add(orgUnitInfo);
                companyParentMap.put(parentIdKey, companyList);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void weaveSumRpt(Context ctx, RptWeaveParams schmParam, String orgBound, FullOrgUnitInfo unitInfo, boolean isSuccessForwardSchm) throws BOSException, EASBizException {
        int year = schmParam.getInt("Year");
        int period = schmParam.getInt("Period");
        schmParam.setObject("KEY_COMPANY", unitInfo);
        String companyId = unitInfo.getId().toString();
        RptWeaveExecParams execParam = (RptWeaveExecParams)schmParam.getObject("rpt_weave_execparams");
        RptWeaveSchmSumInfo schmRptInfo = (RptWeaveSchmSumInfo)schmParam.getObject("rpt_weave_rptSchmObj");
        String userId = execParam.getUserId();
        RptWeaveSchmTempEntryCollection tempateEnties = schmRptInfo.getTemplateEtries();
        RptPeriodTypeEnum periodType = tempateEnties.get(0).getTemplate().getPeriodType();
        this.deleteSchmLog(ctx, companyId, schmRptInfo.getId().toString(), periodType.getValue(), year, period);
        OrgTreeInfo unitTree = (OrgTreeInfo)schmParam.getObject("KEY_ORGTREE_INFO");
        RptAutoWeaveLogInfo log = null;
        boolean currencyExist = CurrencyFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(schmRptInfo.getCurrency().getId()));
        for (int j = 0; j < tempateEnties.size(); ++j) {
            try {
                String schemTempId = tempateEnties.get(j).getTemplate().getId().toString();
                log = this.initLogInfo(ctx, companyId, schemTempId, schmRptInfo.getId().toString(), periodType, year, period, orgBound, userId);
                if (!currencyExist) {
                    throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"CURRENCY_IS_ERROR"));
                }
                TemplateInfo tempInfo = this.getLastestByTemapIdAndComp(ctx, orgBound, companyId, tempateEnties.get(j).getTemplate().getId().toString(), tempateEnties.get(j).getTemplate().getPeriodType().getValue());
                if (!schemTempId.equals(tempInfo.getId().toString())) {
                    log.setTemplateId(tempInfo.getId().toString());
                }
                int templateType = tempInfo.getTemplateType().getValue();
                int reportType = RptAutoWeaveUtil.getReportTypeByTempType(templateType);
                String cslrptTemaplateId = this.getCurrentPeriodRptTempalteId(ctx, unitTree.getId().toString(), companyId, periodType.getValue(), year, period, schmRptInfo.getCurrency().getId().toString(), tempInfo.getGroup(), reportType);
                if (!StringUtils.isEmpty((String)cslrptTemaplateId)) {
                    log.setTemplateId(cslrptTemaplateId);
                } else {
                    log.setTemplateId(tempInfo.getId().toString());
                }
                if (!isSuccessForwardSchm) {
                    log.setDetails(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"ForwardSchmNoRunOrFail"));
                    log.setResultType(RptWeaveLogSuccEnum.FAILED);
                    this.addInitLog(ctx, log);
                    continue;
                }
                schmParam.setObject("KEY_TEMPLATE", tempInfo);
                this.addInitLog(ctx, log);
                RptWeaveSumRptExec rptExec = new RptWeaveSumRptExec(schmParam, ctx, log);
                rptExec.execute();
                this.writeLog(ctx, log, "", RptWeaveLogSuccEnum.SUCCESS);
                continue;
            }
            catch (Exception e) {
                if (log != null) {
                    this.writeLog(ctx, log, e.getLocalizedMessage(), RptWeaveLogSuccEnum.FAILED);
                }
                execParam.setException(true);
                if (e instanceof RptWeaveException) continue;
                logger.error((Object)"SumCalcSchemeHandle.weaveSumRpt", (Throwable)e);
            }
        }
    }

    private String getCurrentPeriodRptTempalteId(Context ctx, String treeID, String companyID, int periodType, int year, int period, String currencyID, String templateGroupNumber, int reportType) throws BOSException, EASBizException {
        return FastMergeUtil.getCurrentPeriodRptTempalteId(ctx, treeID, companyID, periodType, year, period, currencyID, templateGroupNumber, reportType);
    }

    private void deleteSchmLog(Context ctx, String companyId, String schmId, int periodType, int year, int period) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CompanyID", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("RptWeaveSchmId", (Object)schmId));
        filter.getFilterItems().add(new FilterItemInfo("PeriodType", (Object)new Integer(periodType)));
        filter.getFilterItems().add(new FilterItemInfo("Year", (Object)new Integer(year)));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(period)));
        IRptAutoWeaveLog iLog = RptAutoWeaveLogFactory.getLocalInstance(ctx);
        iLog.delete(filter);
    }

    private void writeLog(Context ctx, RptAutoWeaveLogInfo logInfo, String detailMsg, RptWeaveLogSuccEnum logSuccType) throws BOSException, EASBizException {
        if (detailMsg == null) {
            detailMsg = "java.lang.NullPointerException";
        }
        if (detailMsg.length() > 2000) {
            detailMsg = detailMsg.substring(0, 2000);
        }
        logInfo.setDetails(detailMsg);
        logInfo.setResultType(logSuccType);
        if (logInfo.getId() == null) {
            RptAutoWeaveLogFactory.getLocalInstance(ctx).addnew(logInfo);
        } else {
            RptAutoWeaveLogFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(logInfo.getId()), logInfo);
        }
    }

    private void addInitLog(Context ctx, RptAutoWeaveLogInfo logInfo) throws BOSException, EASBizException {
        IObjectPK pk = RptAutoWeaveLogFactory.getLocalInstance(ctx).addnew(logInfo);
        logInfo.setId(BOSUuid.read((String)pk.toString()));
    }

    private RptAutoWeaveLogInfo initLogInfo(Context ctx, String companyId, String tempId, String schemeId, RptPeriodTypeEnum item, int year, int peroid, String boundId, String userId) throws BOSException, EASBizException {
        RptAutoWeaveLogInfo log = new RptAutoWeaveLogInfo();
        log.setCompanyID(companyId);
        log.setTemplateId(tempId);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userId));
        log.setCreator(userInfo);
        log.setPeriodType(item);
        log.setYear(year);
        log.setPeriod(peroid);
        log.setResultType(RptWeaveLogSuccEnum.NOSTART);
        log.setBoundId(boundId);
        log.setRptWeaveSchmId(schemeId);
        return log;
    }

    private TemplateInfo getLastestByTemapIdAndComp(Context ctx, String orgBound, String companyId, String templateId, int periodType) throws BOSException, EASBizException {
        return FastMergeUtil.getLastestByTemapIdAndComp(ctx, orgBound, companyId, templateId, periodType);
    }

    private Map getLowestLevelCompRela(Context ctx, String schemeId, String treeId, String userId) throws BOSException {
        StringBuffer sqlBuff = new StringBuffer("");
        sqlBuff.append("  SELECT  StructParent.funitid fparentUnitId,Struct.flevel,     \n ");
        sqlBuff.append(" BaseUnit.fid fid,BaseUnit.fisGrouping isGrouping,BaseUnit.fnumber fnumber FROM T_PM_OrgRange OrgRange \n");
        sqlBuff.append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = OrgRange.FOrgID \n");
        sqlBuff.append(" INNER JOIN T_ORG_Structure Struct ON Struct.FUnitId = OrgRange.FOrgID  \n");
        sqlBuff.append(" inner join  T_CSL_RptWeaveSchmSumUnitEntry schmUnit on schmUnit.fcompanyid=BaseUnit.FID \n");
        sqlBuff.append("  inner join T_ORG_Structure  StructParent on Struct.fparentid=StructParent.fid ");
        sqlBuff.append(" WHERE schmUnit.fschemesumid=? \n");
        sqlBuff.append("  and Struct.FTreeId =?  \n");
        sqlBuff.append(" AND OrgRange.FType = 10 and OrgRange.FUserID =?   \n");
        sqlBuff.append(" order by Struct.flevel desc ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(schemeId);
        params.add(treeId);
        params.add(userId);
        TreeMap companyParentMap = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return String.valueOf(o2).compareTo(String.valueOf(o1));
            }
        });
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params.toArray());
        this.ConstructCompRela(companyParentMap, rs);
        return companyParentMap;
    }

    private void ConstructCompRela(Map companyParentMap, IRowSet rs) throws SQLDataException {
        try {
            while (rs.next()) {
                String parentIdKey = rs.getString("fparentUnitId");
                if (StringUtils.isEmpty((String)parentIdKey)) continue;
                String mapKey = parentIdKey;
                FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                orgUnitInfo.setNumber(rs.getString("fnumber"));
                if (companyParentMap.containsKey(mapKey)) {
                    ((List)companyParentMap.get(mapKey)).add(orgUnitInfo);
                    continue;
                }
                ArrayList<FullOrgUnitInfo> companyList = new ArrayList<FullOrgUnitInfo>();
                companyList.add(orgUnitInfo);
                companyParentMap.put(mapKey, companyList);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public void reBuildCompRelaMap(Context ctx, String treeId, String orgUnitId, Map compRelaMap) throws BOSException {
        StringBuffer sqlBuff = new StringBuffer("");
        sqlBuff.append("  select  StructParent.funitid fparentUnitId,BaseUnit.fid,BaseUnit.fnumber,Struct.flevel from    \n");
        sqlBuff.append("T_ORG_BaseUnit BaseUnit INNER JOIN T_ORG_Structure Struct ON Struct.FUnitId =baseUnit.fid  \n");
        sqlBuff.append("  inner join T_ORG_Structure  StructParent on Struct.fparentid=StructParent.fid ");
        sqlBuff.append(" WHERE  Struct.FTreeId =?   and BaseUnit.fid=?    \n");
        ArrayList<String> params = new ArrayList<String>();
        params.add(treeId);
        params.add(orgUnitId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params.toArray());
        this.ConstructCompRela(compRelaMap, rs);
    }

    public boolean isSuccessExecSchm(Context ctx, String schemeId, int year, int period, int periodType) throws BOSException {
        StringBuffer sql = new StringBuffer("select fstate  from T_CSL_RptWeaveSchmTask task");
        sql.append(" inner join T_JOB_INST  job on task.FJobinstid=job.fjobinstid ");
        sql.append(" where task.frptWeaveSchmId=? and  fyear= ? and fperiod=? and fperiodType=?");
        Object[] params = new Object[]{schemeId, new Integer(year), new Integer(period), new Integer(periodType)};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (!rowSet.next()) {
                return false;
            }
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (JobState.Complete.toString().equals(rowSet.getString("fstate"))) continue;
                return false;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public boolean isRunSuccessForDependSchm(Context ctx, String schemeId) throws BOSException, EASBizException {
        IRptWeaveSchmSum schmSum = RptWeaveSchmSumFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("dependSchm"));
        sic.add(new SelectorItemInfo("templateEtries.template.periodtype"));
        RptWeaveSchmSumInfo schmSumInfo = schmSum.getRptWeaveSchmSumInfo((IObjectPK)new ObjectUuidPK(schemeId), sic);
        String forwardSchm = schmSumInfo.getDependSchm();
        if (StringUtils.isEmpty((String)forwardSchm)) {
            return true;
        }
        RptWeaveSchmTempEntryCollection tempEnties = schmSumInfo.getTemplateEtries();
        if (tempEnties.size() == 0) {
            return false;
        }
        RptPeriodTypeEnum periodType = tempEnties.get(0).getTemplate().getPeriodType();
        Calendar calendar = Calendar.getInstance();
        List times = RPTDateUtil.getRptPeriod(calendar.getTime(), periodType);
        Integer year = (Integer)times.get(0);
        Integer period = (Integer)times.get(1);
        times = RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType.getValue(), schmSumInfo.getYear(), schmSumInfo.getPeriod());
        Integer weaveYear = (Integer)times.get(0);
        Integer weavePeriod = (Integer)times.get(1);
        return this.isSuccessExecSchm(ctx, schemeId, weaveYear, weavePeriod, periodType.getValue());
    }
}

