/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.dynamic.CslRptAsstAccountInfo;
import com.kingdee.eas.fi.gr.dynamic.CslRptAsstActGroupDetailInfo;
import com.kingdee.eas.fi.gr.dynamic.DynamicEnumException;
import com.kingdee.eas.fi.gr.dynamic.app.AbstractCslRptAsstAccountControllerBean;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeInfoExt;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CslRptAsstAccountControllerBean
extends AbstractCslRptAsstAccountControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.dynamic.app.CslRptAsstAccountControllerBean");

    @Override
    protected boolean _exists(Context ctx, List attributeList) throws BOSException, EASBizException {
        if (attributeList == null || attributeList.size() == 0) {
            return false;
        }
        IRowSet rowSet = this.queryAsstAccount(ctx, attributeList);
        try {
            return rowSet.next();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private IRowSet queryAsstAccount(Context ctx, List attributeList) throws SQLDataException, BOSException {
        int i;
        StringBuffer sql = new StringBuffer();
        ArrayList params = new ArrayList();
        int dimCount = attributeList.size();
        sql.append(" select  ReturnAsstAccount.FID AsstAccountID,count( ReturnAsstDetail.FID) from T_CSL_CslRptAsstAccount AsstAccount ");
        for (i = 0; i < dimCount; ++i) {
            sql.append(" inner join T_CSL_CslRptAsstActGroupDetail AsstDetail").append(i).append(" on AsstDetail").append(i).append(".FAsstAccountID = AsstAccount.FID  ");
            sql.append(" inner join T_BD_AsstActType AsstActType").append(i).append(" on AsstActType").append(i).append(".FID = AsstDetail").append(i).append(".FAsstActTypeID ");
        }
        sql.append(" inner join T_CSL_CslRptAsstAccount ReturnAsstAccount on ReturnAsstAccount.FID = AsstAccount.FID ");
        sql.append(" inner join T_CSL_CslRptAsstActGroupDetail ReturnAsstDetail on ReturnAsstAccount.FID = ReturnAsstDetail.FAsstAccountID ");
        sql.append(" where ");
        for (i = 0; i < dimCount; ++i) {
            if (i != 0) {
                sql.append(" and ");
            }
            sql.append("  AsstActType").append(i).append(".FAsstHGAttribute = ? ");
            params.add(attributeList.get(i));
        }
        sql.append(" group by ReturnAsstAccount.FID ,ReturnAsstAccount.FCreateTime");
        sql.append(" having count( ReturnAsstDetail.FID) = ? ");
        sql.append(" order by  ReturnAsstAccount.FCreateTime ");
        params.add(new Integer(dimCount));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        return rowSet;
    }

    @Override
    protected String _getIdByAsstActTypes(Context ctx, List attributeList) throws BOSException, EASBizException {
        IRowSet rowSet = this.queryAsstAccount(ctx, attributeList);
        try {
            if (rowSet.size() > 0) {
                rowSet.next();
                String id = rowSet.getString("AsstAccountID");
                this.deleteByRowSet(ctx, rowSet);
                return id;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("asstHGAttribute", new HashSet(attributeList), CompareType.INCLUDE));
            HashMap<String, AsstActTypeInfo> asstActTypeMap = new HashMap<String, AsstActTypeInfo>();
            AsstActTypeCollection asstActTypeCollection = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
            for (int i = 0; i < asstActTypeCollection.size(); ++i) {
                asstActTypeMap.put(asstActTypeCollection.get(i).getAsstHGAttribute(), asstActTypeCollection.get(i));
            }
            CslRptAsstAccountInfo info = new CslRptAsstAccountInfo();
            int index = 0;
            for (String attribute : attributeList) {
                CslRptAsstActGroupDetailInfo detailInfo = new CslRptAsstActGroupDetailInfo();
                detailInfo.setAsstAccount(info);
                detailInfo.setSeq(index++);
                AsstActTypeInfo asstActType = (AsstActTypeInfo)asstActTypeMap.get(attribute);
                if (asstActType == null) {
                    throw new DynamicEnumException(DynamicEnumException.ASSTACTTYPENOTEXIST, new Object[]{attribute});
                }
                detailInfo.setAsstActType(asstActType);
                info.getAsstAccountDetail().add(detailInfo);
            }
            this._addnew(ctx, (IObjectValue)info);
            IRowSet rowSet2 = this.queryAsstAccount(ctx, attributeList);
            if (rowSet2.size() > 0) {
                rowSet2.next();
                String id = rowSet2.getString("AsstAccountID");
                this.deleteByRowSet(ctx, rowSet2);
                return id;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    private void deleteByRowSet(Context ctx, IRowSet rowSet) throws SQLException, BOSException, EASBizException {
        ArrayList<ObjectStringPK> deletepkList = new ArrayList<ObjectStringPK>();
        while (rowSet.next()) {
            deletepkList.add(new ObjectStringPK(rowSet.getString("AsstAccountID")));
        }
        IObjectPK[] pks = new IObjectPK[deletepkList.size()];
        deletepkList.toArray(pks);
        this._delete(ctx, pks);
    }

    @Override
    protected Map _getItemCollections(Context ctx, List attributeList) throws BOSException, EASBizException {
        return this._getItemCollections(ctx, attributeList, null);
    }

    @Override
    protected Map _getItemCollections(Context ctx, List attributeList, Map uiContext) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("asstHGAttribute", new HashSet(attributeList), CompareType.INCLUDE));
        AsstActTypeCollection asstActTypeCollection = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
        HashMap<AsstActTypeInfoExt, IObjectCollection> result = new HashMap<AsstActTypeInfoExt, IObjectCollection>();
        if (uiContext == null) {
            uiContext = new HashMap<String, Serializable>();
        }
        String currentFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        boolean paramIsTrue = RptUtil.isTrue((Object)ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(currentFIUnit), (String)"fi_rp_004"));
        uiContext.put("fi_rp_004", Boolean.valueOf(paramIsTrue));
        HashMap subTypeFilterMap = new HashMap();
        uiContext.put("subTypeFilterMap", subTypeFilterMap);
        for (AsstActTypeInfo asstActTypeInfo : asstActTypeCollection) {
            if ("companyOrg".equals(asstActTypeInfo.getDefaultQueryName())) {
                asstActTypeInfo.setDefaultQueryName("com.kingdee.eas.fi.gr.dynamic.app.CompanyOrgUnit4AsstAcctQuery");
            } else if ("person".equals(asstActTypeInfo.getAsstHGAttribute())) {
                asstActTypeInfo.setDefaultQueryName("com.kingdee.eas.fi.gr.dynamic.app.AllPositionPersonQuery");
            }
            IObjectCollection allAsstItemCollection = this.getAllAsstItemCollection(ctx, asstActTypeInfo, uiContext);
            result.put(new AsstActTypeInfoExt(asstActTypeInfo), allAsstItemCollection);
        }
        return result;
    }

    private IObjectCollection getAllAsstItemCollection(Context ctx, AsstActTypeInfo asstActTypeInfo, Map uiContext) throws EASBizException, BOSException {
        String mappingFieldName = asstActTypeInfo.getAsstHGAttribute();
        EntityViewInfo view = DynamicTemplateUtility.createAsstItemFilter(ctx, asstActTypeInfo, uiContext);
        String defaultQueryName = asstActTypeInfo.getDefaultQueryName();
        MetaDataPK queryPK = new MetaDataPK(defaultQueryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(view);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        if (mappingFieldName.equals("adminOrg") || mappingFieldName.equals("companyOrg") || mappingFieldName.equals("costOrg") || mappingFieldName.equals("saleOrg") || mappingFieldName.equals("profitOrg") || mappingFieldName.equals("purchaseOrg") || mappingFieldName.equals("storeageOrg")) {
            exec.option().isIgnorePermissionCheck = true;
        }
        IRowSet rowSet = exec.executeQuery();
        QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getQuery((IMetaDataPK)queryPK);
        SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
        SubEntityInfo mainEntityInfo = null;
        BOSUuid id = null;
        if (mainObjectInfo instanceof SubEntityInfo) {
            mainEntityInfo = (SubEntityInfo)mainObjectInfo;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider")) {
            sic.add(new SelectorItemInfo("browseGroup"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
        } else if (mappingFieldName.equals("material")) {
            sic.add(new SelectorItemInfo("materialGroup"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
        } else {
            sic.add(new SelectorItemInfo("longNumber"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
        }
        if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
            IDynamicObject idynaObj = DynamicObjectFactory.getLocalInstance((Context)ctx);
            BOSObjectType type = mainEntityInfo.getEntityRef().getType();
            ParamTempTblService tblService = null;
            try {
                String tblName = null;
                ArrayList<String> idList = new ArrayList<String>();
                StringBuffer sb = new StringBuffer();
                while (rowSet.next()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    id = BOSUuid.read((String)rowSet.getString("id"));
                    sb.append(id);
                    idList.add(rowSet.getString("id"));
                }
                if (idList.size() > 100) {
                    tblService = this.getTempTblService(ctx, idList);
                    tblName = tblService.getTmpTableName();
                }
                if (idList.size() > 0) {
                    EntityViewInfo ev = new EntityViewInfo();
                    ev.getSelector().addObjectCollection((IObjectCollection)sic);
                    FilterInfo filter = new FilterInfo();
                    if (tblName != null) {
                        filter.getFilterItems().add(new FilterItemInfo("id in(select fid from " + tblName + ")"));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INCLUDE));
                    }
                    ev.setFilter(filter);
                    String numberOrLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo) ? "longnumber" : "number";
                    ev.getSorter().add(new SorterItemInfo(numberOrLongNumber));
                    IObjectCollection iObjectCollection = idynaObj.getCollection(type, ev);
                    return iObjectCollection;
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                if (tblService != null) {
                    tblService.release();
                }
            }
        }
        return null;
    }

    private ParamTempTblService getTempTblService(Context ctx, List idList) throws BOSException {
        TableInfo table = new TableInfo("t_tmp_dynamicobject");
        table.addColumn(new ColumnInfo("Fid", "nvarchar(80)"));
        ParamTempTblService service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)idList, null);
        return service;
    }
}

