/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.MultiInterItemDataCollection;
import com.kingdee.eas.fi.gr.dynamic.MultiInterItemDataInfo;
import com.kingdee.eas.fi.gr.dynamic.app.AbstractMultiInterItemDataControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiInterItemDataControllerBean
extends AbstractMultiInterItemDataControllerBean {
    private static final long serialVersionUID = -9037769259003250783L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.dynamic.app.MultiInterItemDataControllerBean");
    private static final int HASCHECKED = 1;
    private static final int BASEDATA = 2;
    private static final int CANDELETE = 0;
    private static final int NOTCURGROUP = 3;

    @Override
    protected Map _getImportData(Context ctx, Map params) throws BOSException, EASBizException {
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        int periodType = (Integer)params.get("PeriodType");
        int mergeMode = (Integer)params.get("MERGETYPE");
        String currencyId = (String)params.get("KEY_CURRENCY_ID");
        List reportIds = CslRptUtil.getMultiReports((Context)ctx, (OrgTreeInfo)orgTree, (OrgUnitInfo)orgUnit, (String)currencyId, (int)mergeMode, (int)year, (int)period, (int)periodType);
        StringBuffer sql = new StringBuffer();
        sql.append("select to_char(b.FItemId) as FItemId, b.FKeyNumber, b.FKeyName, b.FDataElement,");
        sql.append(" b.FValueType, a.FYear, a.FPeriod, b.FValue, b.FDynaItemType,");
        sql.append(" b.FCslRptAssistantHGId");
        sql.append(" from t_csl_multidynaItemData a");
        sql.append(" inner join t_csl_multidynaItemDataEntry b");
        sql.append(" on a.FId = b.FItemDataId");
        sql.append(" inner join t_csl_rptItem i");
        sql.append(" on b.FItemId = i.FNumber");
        sql.append(" where a.FReportId = ?");
        sql.append(" and b.FDynaItemType in (0,1, 2, 3)");
        sql.append(" and b.FDataElement in (select  FInterSEQ from t_csl_Dataelement where FISUSEDELIM=1)");
        sql.append(" and b.FValueType = ").append(1);
        sql.append(" and i.fid in (select distinct tempEntry.FItemID from T_CSL_ElimTempletEntry tempEntry ");
        sql.append("left outer join T_CSL_ElimTemplet templet on templet.FID = tempEntry.FTempletID ");
        sql.append("left outer join T_CSL_TempletDispense disp on disp.FDispenseSrcID = templet.FElimGroupID where disp.FOrgBoundID = ?)");
        sql.append(" and b.FValue !=0 and b.FValue is not null ");
        String orgTreeID = orgTree.getId().toString();
        HashMap result = new HashMap();
        for (int i = 0; i < reportIds.size(); ++i) {
            String reportId = (String)reportIds.get(i);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{reportId, orgTreeID});
            try {
                ArrayList itemData = new ArrayList();
                while (rowSet.next()) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    String itemId = rowSet.getString("FItemId");
                    data.put("itemNumber", itemId);
                    String keyNumber = rowSet.getString("FkeyNumber");
                    data.put("ditemNumber", keyNumber);
                    String keyName = rowSet.getString("FKeyName");
                    data.put("ditemName", keyName);
                    int dataElement = rowSet.getInt("FDataElement");
                    data.put("dataElement", new Integer(dataElement));
                    int valueType = rowSet.getInt("FValueType");
                    data.put("valueType", new Integer(valueType));
                    int fyear = rowSet.getInt("Fyear");
                    data.put("year", new Integer(fyear));
                    int fperiod = rowSet.getInt("FPeriod");
                    data.put("period", new Integer(fperiod));
                    BigDecimal value = rowSet.getBigDecimal("FValue");
                    data.put("value", value);
                    int dynaItemType = rowSet.getInt("FDynaItemType");
                    data.put("dynaItemType", (Object)DynaItemTypeEnum.getEnum(dynaItemType));
                    String cslRptAsstHGID = rowSet.getString("FCslRptAssistantHGId");
                    data.put("cslRptAsstID", cslRptAsstHGID);
                    itemData.add(data);
                }
                if (itemData.isEmpty()) continue;
                result.put(reportId, itemData);
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return result;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk, OrgTreeInfo tree, OrgUnitInfo orgUnit) throws BOSException, EASBizException {
        int b;
        int mergeType = 100;
        if (tree != null && tree.getId() != null) {
            mergeType = CslRptUtil.getMergeMode((Context)ctx, (String)tree.getId().toString()).getValue();
        }
        if ((b = this.tryToDelete(ctx, pk, mergeType, tree, orgUnit)) == 0) {
            this.innerDelete(ctx, pk);
        } else {
            if (b == 2) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"SelectedData_NotImported", (Locale)ctx.getOriginLocale())));
            }
            if (b == 1) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CheckedData_CantDelete", (Locale)ctx.getOriginLocale())));
            }
            if (b == 3) {
                throw new EASBizException(new NumericExceptionSubItem("1", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"4_MultiInterItemDataControllerBean", (Locale)ctx.getOriginLocale())));
            }
        }
    }

    @Override
    protected String _removeBatch(Context ctx, List list, OrgTreeInfo tree, OrgUnitInfo orgUnit) throws BOSException, EASBizException {
        int mergeType = 0;
        mergeType = tree == null ? 100 : CslRptUtil.getMergeMode((Context)ctx, (String)tree.getId().toString()).getValue();
        StringBuffer error = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            String id = (String)list.get(i);
            ObjectStringPK pk = new ObjectStringPK(id);
            int b = this.tryToDelete(ctx, (IObjectPK)pk, mergeType, tree, orgUnit);
            if (b == 0) {
                this.innerDelete(ctx, (IObjectPK)pk);
                continue;
            }
            String l = ctx.getLocale().toString();
            String sql = "select b1.FName_" + l + " as FCompany, b2.FName_" + l + " as FTargetCompany, FItemNumber from t_csl_MultiInterItemData i join t_org_baseunit b1 on i.FCompanyId = b1.FId join t_org_baseunit b2 on i.FTargetCompanyId = b2.FId where i.FId = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            try {
                if (!rowSet.next()) continue;
                error.append(rowSet.getString("FCompany")).append(" ");
                error.append(rowSet.getString("FTargetCompany")).append(" ");
                error.append(rowSet.getString("FItemNumber")).append(" ");
                if (b == 2) {
                    error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"5_MultiInterItemDataControllerBean", (Locale)ctx.getOriginLocale()));
                    error.append("\n");
                    continue;
                }
                if (b == 1) {
                    error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"6_MultiInterItemDataControllerBean", (Locale)ctx.getOriginLocale()));
                    error.append("\n");
                    continue;
                }
                if (b != 3) continue;
                error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"7_MultiInterItemDataControllerBean", (Locale)ctx.getOriginLocale()));
                error.append("\n");
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return error.toString();
    }

    private int tryToDelete(Context ctx, IObjectPK pk, int mergeType, OrgTreeInfo tree, OrgUnitInfo orgUnit) throws BOSException {
        logger.info((Object)("mergeType:" + mergeType));
        logger.info((Object)("tree:" + tree));
        logger.info((Object)("orgUnit:" + orgUnit));
        String sql = "select itemData.FSourceType, checkage.FCheckedStatus, itemData.FImportedGroup from T_CSL_MultiInterItemData itemData  left outer join T_CSL_MultiInterCheckage checkage on itemData.FCheckageRecord = checkage.fid  where itemData.FId = ?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        try {
            if (rowSet.next()) {
                int type = rowSet.getInt("FSourceType");
                int status = rowSet.getInt("FCheckedStatus");
                String group = rowSet.getString("FImportedGroup");
                logger.info((Object)("group:" + group));
                if (type != 2) {
                    return 2;
                }
                if (status == 2) {
                    return 1;
                }
                if (mergeType == 1 && !StringUtils.equals((String)group, (String)orgUnit.getId().toString())) {
                    return 3;
                }
                if (!StringUtils.equals((String)group, (String)orgUnit.getId().toString())) {
                    return 3;
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return 0;
    }

    @Override
    protected String _importInterItemData(Context ctx, boolean isCovert, Map reportDatas, Map params) throws BOSException, EASBizException {
        if (reportDatas == null || reportDatas.size() <= 0) {
            return null;
        }
        OrgTreeInfo orgTree = (OrgTreeInfo)params.get("KeyOrgTree");
        OrgUnitInfo orgUnit = (OrgUnitInfo)params.get("KeyOrgUnit");
        int year = (Integer)params.get("Year");
        int period = (Integer)params.get("Period");
        Date day = (Date)params.get("Day");
        int periodType = (Integer)params.get("PeriodType");
        String longNumber = null;
        IRowSet rsTemp = DbUtil.executeQuery((Context)ctx, (String)" select FLongNumber From t_org_structure where ftreeid = ? and funitid = ?", (Object[])new Object[]{orgTree.getId().toString(), orgUnit.getId().toString()});
        try {
            while (rsTemp.next()) {
                longNumber = rsTemp.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        Connection conn = null;
        Statement st = null;
        StringBuffer error = new StringBuffer();
        try {
            conn = super.getConnection(ctx);
            st = conn.createStatement();
            for (String reportId : reportDatas.keySet()) {
                if (isCovert) {
                    StringBuffer oql = new StringBuffer();
                    oql.append("delete T_Csl_MultiInterItemData ");
                    oql.append(" where FReport = '").append(reportId);
                    oql.append("' and FSourceType = ").append(2);
                    oql.append(" and FImportedGroup = '").append(orgUnit.getId().toString()).append("' ");
                    st.addBatch(oql.toString());
                }
                List itemDatas = (List)reportDatas.get(reportId);
                CslReportInfo report = CslReportFactory.getLocalInstance((Context)ctx).getCslReportInfo((IObjectPK)new ObjectStringPK(reportId));
                this.importDatas(ctx, isCovert, itemDatas, orgTree.getId().toString(), orgUnit.getId().toString(), report, year, period, periodType, day, st, longNumber);
            }
            st.executeBatch();
            st.clearBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : When import dyna item data", (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)conn);
        if (error.length() > 0) {
            error.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"8_MultiInterItemDataControllerBean", (Locale)ctx.getOriginLocale()));
            error.append("\n");
        }
        return error.toString();
    }

    private void importDatas(Context ctx, boolean isCovert, List itemDatas, String orgTreeId, String orgUnitId, CslReportInfo report, int year, int period, int periodType, Date day, Statement st, String longNumber) throws EASBizException, BOSException {
        String companyId = report.getOrgUnit().getId().toString();
        String currencyId = report.getCurrency().getId().toString();
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < itemDatas.size(); ++i) {
            Map itemData = (Map)itemDatas.get(i);
            String targetCompanyId = this.getTargetCompany(ctx, (String)itemData.get("ditemNumber"), (DynaItemTypeEnum)((Object)itemData.get("dynaItemType")), (String)itemData.get("cslRptAsstID"));
            if (targetCompanyId == null || targetCompanyId.equals(companyId)) continue;
            String longNumberT = null;
            String com = "select FLongNumber from t_org_structure where FTreeId = ? and FUnitId = ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)com, (Object[])new Object[]{orgTreeId, targetCompanyId});
            if (rowSet.size() <= 0) continue;
            try {
                while (rowSet.next()) {
                    longNumberT = rowSet.getString("FLongNumber");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (longNumberT != null && longNumber != null && longNumberT.indexOf(longNumber) < 0) continue;
            String itemNumber = (String)itemData.get("itemNumber");
            int dataElement = (Integer)itemData.get("dataElement");
            String cslRptAsstHGID = (String)itemData.get("cslRptAsstID");
            if (!isCovert) {
                StringBuffer oql = new StringBuffer();
                oql.append("select FSourceType from T_Csl_MultiInterItemData ");
                oql.append(" where FOrgBoundID = ? and FCompanyID = ?");
                oql.append(" and FTargetCompanyID = ? and FItemNumber = ?");
                oql.append(" and FYear = ? and FPeriod = ? and FPeriodType = ?");
                oql.append(" and FTargetCurrencyID = ?");
                oql.append(" and FDataElement = ?");
                oql.append(" and FCslRptAssistantHGID = ?");
                oql.append(" and FImportedGroup = ? ");
                Object[] param = new Object[]{orgTreeId, companyId, targetCompanyId, itemNumber, new Integer(year), new Integer(period), new Integer(periodType), currencyId, new Integer(dataElement), cslRptAsstHGID, orgUnitId};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])param);
                try {
                    if (rowSet.next()) {
                        int sourceType = rowSet.getInt("FSourceType");
                        if (sourceType == 1) continue;
                        StringBuffer delete = new StringBuffer();
                        delete.append("delete t_csl_multiInterItemData ");
                        delete.append(" where FOrgBoundID = '").append(orgTreeId);
                        delete.append("' and FCompanyID = '").append(companyId);
                        delete.append("' and FTargetCompanyID = '").append(targetCompanyId);
                        delete.append("' and FItemNumber = '").append(itemNumber);
                        delete.append("' and FYear = ").append(year);
                        delete.append(" and FPeriod = ").append(period);
                        delete.append(" and FPeriodType = ").append(periodType);
                        delete.append(" and FTargetCurrencyId = '").append(currencyId).append("'");
                        delete.append(" and FSourceType = ").append(2);
                        delete.append(" and FDataElement = ").append(dataElement);
                        delete.append(" and FImportedGroup = '").append(orgUnitId).append("' \r\n");
                        delete.append(" and FCslRptAssistantHGID = '").append(cslRptAsstHGID).append("'");
                        st.addBatch(delete.toString());
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append("insert into T_CSL_MultiInterItemData");
            sql.append(" (FID, FOrgBoundID, FCompanyID, FTargetCompanyID, FCurrencyID,");
            sql.append(" FTargetCurrencyID, FReport, FItemNumber, FYear, FPeriod,");
            sql.append(" FDay, FMoney, FPeriodType, FCheckageStatus, FCommitStatus,");
            sql.append(" FCommitDate, FSourceType, FImportedGroup,FDATAELEMENT,FCslRptAssistantHGID) ");
            BOSUuid id = BOSUuid.create((BOSObjectType)new MultiInterItemDataInfo().getBOSType());
            idList.add(id.toString());
            sql.append(" values('").append(id.toString());
            sql.append("', '").append(orgTreeId);
            sql.append("', '").append(companyId);
            sql.append("', '").append(targetCompanyId);
            sql.append("', '").append(report.getSourceCurrency().getId().toString());
            sql.append("', '").append(report.getCurrency().getId().toString());
            sql.append("', '").append(report.getId().toString());
            sql.append("', '").append(itemNumber);
            sql.append("', ").append(report.getYear());
            sql.append(", ").append(report.getPeriod());
            sql.append(", ").append(CslRptUtil.formatDateForSql((Date)day));
            if (itemData.get("value") == null) {
                sql.append(", 0");
            } else {
                String value = Util.bigDecimalToPlainString((BigDecimal)((BigDecimal)itemData.get("value")));
                sql.append(", ").append(value);
            }
            sql.append(", ").append(report.getPeriodType().getValue());
            sql.append(", ").append(1);
            sql.append(", ").append(report.getCommittedStatus().getValue());
            sql.append(", ").append(CslRptUtil.formatDateForSql((Date)report.getAuditTime()));
            sql.append(", ").append(2);
            sql.append(", '").append(orgUnitId);
            sql.append("', ").append(dataElement);
            sql.append(", '").append(cslRptAsstHGID).append("')");
            try {
                st.addBatch(sql.toString());
                continue;
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        if (idList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer(1024);
        sql.append(" UPDATE ");
        sql.append(" T_CSL_MultiInterItemData ");
        sql.append(" SET ");
        sql.append(" FCheckageRecord = ( SELECT top 1 b.FID ");
        sql.append(" FROM T_CSL_MultiInterCheckage b \r\n");
        sql.append(" INNER JOIN T_CSL_MultiInterCheckageEntry c \r\n");
        sql.append(" ON b.FID = c.FCheckageID \r\n");
        sql.append(" INNER JOIN T_CSL_RptItem d \r\n");
        sql.append(" ON d.FId = c.FItemId \r\n");
        sql.append(" where \r\n");
        sql.append(" b.FOrgUnitId = '").append(orgUnitId).append("' \r\n");
        sql.append(" and T_CSL_MultiInterItemData.FOrgBoundId = b.FOrgBoundID \r\n");
        sql.append(" and T_CSL_MultiInterItemData.FPeriodType = b.FPeriodType \r\n");
        sql.append(" and T_CSL_MultiInterItemData.FYear = b.FYear \r\n");
        sql.append(" and T_CSL_MultiInterItemData.FPeriod = b.FPeriod \r\n");
        sql.append(" and T_CSL_MultiInterItemData.FTargetCurrencyId = b.FCurrencyID \r\n");
        sql.append(" and T_CSL_MultiInterItemData.FCompanyId = c.FCompanyID \r\n");
        sql.append(" and T_CSL_MultiInterItemData.FTargetCompanyId = c.FTargetCompanyID \r\n");
        sql.append(" and T_CSL_MultiInterItemData.FItemNumber = d.FNumber \r\n");
        sql.append(" and T_CSL_MultiInterItemData.FCslRptAssistantHGID = c.FCslAsstHGID \r\n");
        sql.append(" and T_CSL_MultiInterItemData.FDataElement = c.FDataElement \r\n");
        sql.append(" )");
        sql.append(" WHERE  1 = 1 \r\n");
        sql.append(" and FOrgBoundId ='").append(orgTreeId).append("' \r\n");
        sql.append(" and FYear = ").append(report.getYear());
        sql.append(" and FPeriod = ").append(report.getPeriod());
        sql.append(" and FPeriodtype = ").append(report.getPeriodType().getValue());
        sql.append(" and FID in (");
        for (int i = 0; i < idList.size(); ++i) {
            sql.append("'").append(idList.get(i).toString()).append("',");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")");
        try {
            st.addBatch(sql.toString());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private String getTargetCompany(Context ctx, String number, DynaItemTypeEnum type, String cslRptAsstID) throws EASBizException, BOSException {
        block22: {
            if (type.equals((Object)DynaItemTypeEnum.Company)) {
                String oql = "select fid from t_org_company where FNumber = ?";
                String[] subs = number.split("!");
                if (subs.length > 1) {
                    number = subs[subs.length - 1];
                }
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql, (Object[])new Object[]{number});
                try {
                    if (rowSet.next()) {
                        String id = rowSet.getString("fid");
                        return id;
                    }
                    break block22;
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            if (type.equals((Object)DynaItemTypeEnum.Custom)) {
                String oql = "select FIsInternalCompany, FInternalCompanyID from T_BD_Customer where fnumber = ?";
                String[] subs = number.split("!");
                if (subs.length > 1) {
                    number = subs[subs.length - 1];
                }
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql, (Object[])new Object[]{number});
                try {
                    int isInterCompany;
                    if (rowSet.next() && (isInterCompany = rowSet.getInt("FIsInternalCompany")) == 1) {
                        return rowSet.getString("FInternalCompanyID");
                    }
                    break block22;
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            if (type.equals((Object)DynaItemTypeEnum.Provider)) {
                String oql = "select FIsInternalCompany, FInternalCompanyID from T_BD_Supplier where fnumber = ?";
                String[] subs = number.split("!");
                if (subs.length > 1) {
                    number = subs[subs.length - 1];
                }
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql, (Object[])new Object[]{number});
                try {
                    int isInterCompany;
                    if (rowSet.next() && (isInterCompany = rowSet.getInt("FIsInternalCompany")) == 1) {
                        return rowSet.getString("FInternalCompanyID");
                    }
                    break block22;
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
            if (type.equals((Object)DynaItemTypeEnum.ManualImport) && cslRptAsstID != null) {
                String oql = "select FCompanyOrgID,FCustomerID,FProviderID from T_CSL_CslRptAssistantHG where FID = ?";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)oql, (Object[])new Object[]{cslRptAsstID});
                try {
                    if (rowSet.next()) {
                        int isInterCompany;
                        String oql2;
                        IRowSet rowSet2;
                        int isInterCompany2;
                        String oql1;
                        IRowSet rowSet1;
                        String companyid = rowSet.getString("FCompanyOrgID");
                        if (companyid != null && companyid.length() > 0) {
                            return companyid;
                        }
                        String customerid = rowSet.getString("FCustomerID");
                        if (customerid != null && customerid.length() > 0 && (rowSet1 = DbUtil.executeQuery((Context)ctx, (String)(oql1 = "select FIsInternalCompany, FInternalCompanyID from T_BD_Customer where fid = ?"), (Object[])new Object[]{customerid})).next() && (isInterCompany2 = rowSet1.getInt("FIsInternalCompany")) == 1) {
                            return rowSet1.getString("FInternalCompanyID");
                        }
                        String providerid = rowSet.getString("FProviderID");
                        if (providerid != null && providerid.length() > 0 && (rowSet2 = DbUtil.executeQuery((Context)ctx, (String)(oql2 = "select FIsInternalCompany, FInternalCompanyID from T_BD_Supplier where fid = ?"), (Object[])new Object[]{providerid})).next() && (isInterCompany = rowSet2.getInt("FIsInternalCompany")) == 1) {
                            return rowSet2.getString("FInternalCompanyID");
                        }
                        return null;
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
            }
        }
        return null;
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        this.tryToDelete(ctx, oql);
        return super._delete(ctx, oql);
    }

    private void tryToDelete(Context ctx, String oql) throws BOSException, EASBizException {
        MultiInterItemDataCollection coll = this.getCollection(ctx, oql);
        if (coll == null || coll.size() == 0) {
            return;
        }
        StringBuffer inSql = new StringBuffer("(");
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            inSql.append("?,");
            idSet.add(coll.get(i).get("id").toString());
        }
        inSql.delete(inSql.length() - 1, inSql.length());
        inSql.append(")");
        String sql = "select checkage.FCheckedStatus, itemData.FReport from T_CSL_MultiInterItemData itemData  left outer join T_CSL_MultiInterCheckage checkage on itemData.FCheckageRecord = checkage.fid  where itemData.FId in " + inSql.toString();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])idSet.toArray());
        try {
            while (rowSet.next()) {
                int status = rowSet.getInt("FCheckedStatus");
                if (status != 2) continue;
                String reportID = rowSet.getString("FReport");
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("name");
                sic.add("orgUnit.name");
                CslReportInfo report = CslReportFactory.getLocalInstance((Context)ctx).getCslReportInfo((IObjectPK)new ObjectUuidPK(reportID), sic);
                throw new EASBizException(new NumericExceptionSubItem("1", report.getOrgUnit().getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"85_MultiInterItemDataControllerBean", (Locale)ctx.getOriginLocale()) + report.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"9_MultiInterItemDataControllerBean", (Locale)ctx.getOriginLocale())));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }
}

