/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.fill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupDetialInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTypeForEntityEnum;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportServiceFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.fill.AsstActObject;
import com.kingdee.eas.fi.gr.dynamic.fill.DyaItemFormulaParse;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateCoverUtil;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DynaItemBeforeFill
implements Serializable {
    private static Logger LOGGER = Logger.getLogger((String)"com.kingdee.eas.fi.gr.dynamic.fill.DynaItemBeforeFill");
    private static final long serialVersionUID = 2012384678891074964L;
    private final String GENERAL_ASST_ACT_TYPE = "T_BD_GeneralAsstActType";
    private int maxFillSize = 2000;
    private boolean paramIsTrue = true;
    private Sheet curSheet = null;
    private boolean isReport = false;
    private Point activePoint = null;
    private boolean isAutoExe = false;
    private ArrayList basePointList = null;
    private int spreadStyle;
    private DynaParameters param;
    private AsstActTypeUtils assistantType;
    private int top;
    private int left;
    private DItemGradeInfo gradeInfo;
    private DItemGradeEntryInfo gradeEntryInfo;
    private AsstActTypeInfo asstActTypeInfo;
    private OrgUnitInfo company = null;
    private Context _ctx = null;
    private List listSelectedItem = null;
    private OrgUnitInfo cu = null;
    private String grade = "";
    private IReportPropertyAdapter reportPropertyAdapter = null;
    private Point newBasePoint = null;
    private boolean isRptCover = false;
    private Sheet oldSheet = null;
    private boolean isBaseGroupStandard = true;
    private Map<String, FilterInfo> subTypeFilterMap = new HashMap<String, FilterInfo>();

    public IReportPropertyAdapter getReportPropertyAdapter() {
        return this.reportPropertyAdapter;
    }

    public void setReportPropertyAdapter(IReportPropertyAdapter reportPropertyAdapter) {
        this.reportPropertyAdapter = reportPropertyAdapter;
    }

    public void setParam(DynaParameters param) {
        this.param = param;
    }

    public DynaItemBeforeFill(boolean paramIsTrue, Sheet curSheet, boolean isReport, Point activePoint, boolean isAutoExe, OrgUnitInfo company, OrgUnitInfo cu, Context ctx) throws EASBizException, BOSException {
        this(paramIsTrue, curSheet, isReport, activePoint, isAutoExe, company, ctx);
        this.cu = cu;
        if (this.cu == null) {
            this.cu = ctx == null ? SysContext.getSysContext().getCurrentFIUnit() : ContextUtil.getCurrentCtrlUnit((Context)this._ctx);
        }
    }

    public DynaItemBeforeFill(boolean isReport, boolean paramIsTrue, OrgUnitInfo company, Context ctx) {
        this.paramIsTrue = paramIsTrue;
        this.isReport = isReport;
        this.company = this.isReport && company != null ? company : SysContext.getSysContext().getCurrentFIUnit();
        this._ctx = ctx;
        this.isAutoExe = false;
    }

    public DynaItemBeforeFill(boolean paramIsTrue, Sheet newSheet, Sheet oldSheet, boolean isReport, Point activePoint, boolean isAutoExe, OrgUnitInfo company, Context ctx) throws EASBizException, BOSException {
        this.paramIsTrue = paramIsTrue;
        this.curSheet = newSheet;
        this.oldSheet = oldSheet;
        this.isReport = isReport;
        this.activePoint = new Point(activePoint);
        this.isAutoExe = isAutoExe;
        this.company = company != null ? company : SysContext.getSysContext().getCurrentFIUnit();
        this._ctx = ctx;
        this.initRptCoverParams();
    }

    private void initRptCoverParams() throws EASBizException, BOSException {
        this.basePointList = DynamicTemplateUtility.getBasePointList(this.curSheet);
        if (this.basePointList.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Dyna_BasePointIsNull")));
        }
        this.newBasePoint = DynamicTemplateCoverUtil.findBasePoint(this.curSheet, this.oldSheet, this.basePointList, this.activePoint);
        if (this.newBasePoint == null) {
            return;
        }
        this.activePoint = this.newBasePoint;
        this.left = this.newBasePoint.x;
        this.top = this.newBasePoint.y;
        this.param = DynamicTemplateUtility.getDynaParametersFromCell(this.curSheet, this.top, this.left);
        this.assistantType = this.param.getAssistantType();
        this.spreadStyle = this.param.getSpreadStyle();
        this.gradeInfo = DynamicTemplateUtility.getGradeInfo(this.curSheet.getRange(this.top, this.left));
        int dynaItemSource = this.param.getDynaItemSource();
        if (dynaItemSource == 0 && !this.param.isGrade() && !this.isAutoExe) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Manual_NotUseWizard")));
        }
        if (dynaItemSource == 0 && this.param.isGrade()) {
            this.assistantType = null;
            Range activeCell = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getActiveCellRange());
            if (activeCell != null && this.assistantType == null) {
                this.assistantType = this.locateTextGradeSite();
            }
        }
        if (this.assistantType != null) {
            this.asstActTypeInfo = this.getAsstActType();
        }
    }

    public DynaItemBeforeFill(boolean paramIsTrue, Sheet curSheet, boolean isReport, Point activePoint, boolean isAutoExe, OrgUnitInfo company, Context ctx) throws EASBizException, BOSException {
        this.paramIsTrue = paramIsTrue;
        this.curSheet = curSheet;
        this.isReport = isReport;
        this.activePoint = activePoint;
        this.isAutoExe = isAutoExe;
        this.company = company != null ? company : SysContext.getSysContext().getCurrentFIUnit();
        this._ctx = ctx;
        this.initParams();
    }

    private void initParams() throws EASBizException, BOSException {
        this.basePointList = DynamicTemplateUtility.getBasePointList(this.curSheet);
        if (this.basePointList.isEmpty()) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Dyna_BasePointIsNull")));
        }
        Point basePoint = this.initBasePoint(this.curSheet, this.basePointList, this.activePoint);
        this.left = basePoint.x;
        this.top = basePoint.y;
        this.param = DynamicTemplateUtility.getDynaParametersFromCell(this.curSheet, this.top, this.left);
        this.assistantType = this.param.getAssistantType();
        this.spreadStyle = this.param.getSpreadStyle();
        this.gradeInfo = DynamicTemplateUtility.getGradeInfo(this.curSheet.getRange(this.top, this.left));
        int dynaItemSource = this.param.getDynaItemSource();
        if (!this.param.isGrade() && dynaItemSource == 0 && !this.isAutoExe) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Manual_NotUseWizard")));
        }
        if (dynaItemSource == 0 && this.param.isGrade()) {
            this.assistantType = null;
            Range activeCell = UserObjectHelper.getUnprotectedRange((Range)this.curSheet.getActiveCellRange());
            if (activeCell != null) {
                if (this.assistantType == null) {
                    this.assistantType = this.locateTextGradeSite();
                }
                if (this.assistantType == null) {
                    throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Manual_NotUseWizard")));
                }
            }
        }
        if (this.assistantType != null) {
            this.asstActTypeInfo = this.getAsstActType();
        }
    }

    public IMetaDataPK getQueryPK(boolean isShowAssistant) throws EASBizException, BOSException {
        return this.getQueryPK(isShowAssistant, false);
    }

    public IMetaDataPK getQueryPK(boolean isShowAssistant, boolean isIncludeFreezed) throws EASBizException, BOSException {
        MetaDataPK queryPK = MetaDataPK.create((String)this.getQueryQueryName(isShowAssistant, isIncludeFreezed));
        return queryPK;
    }

    public String getQueryQueryName(boolean isShowAssistant, boolean isIncludeFreezed) throws EASBizException, BOSException {
        String mappingFieldName = this.asstActTypeInfo.getAsstHGAttribute();
        String defaultQueryName = this.asstActTypeInfo.getDefaultQueryName();
        if ("companyOrg".equals(mappingFieldName) && isShowAssistant) {
            defaultQueryName = "com.kingdee.eas.fi.gr.dynamic.app.CompanyOrgUnit4AsstAcctQuery";
        }
        defaultQueryName = this.getQueryName(mappingFieldName, isIncludeFreezed, defaultQueryName);
        if (mappingFieldName.equals("person")) {
            defaultQueryName = "com.kingdee.eas.fi.gr.dynamic.app.AllPositionPersonQuery";
        }
        return defaultQueryName;
    }

    private String getQueryName(String mappingFieldName, boolean isIncludeFreezed, String defaultQueryName) {
        if (isIncludeFreezed) {
            if (mappingFieldName.equals("customer") && !this.paramIsTrue) {
                defaultQueryName = "com.kingdee.eas.fi.rpt.app.F7CustomerNOFilterQuery";
            } else if (mappingFieldName.equals("provider") && !this.paramIsTrue) {
                defaultQueryName = "com.kingdee.eas.fi.rpt.app.F7SupplierNOFilterQuery";
            } else if (mappingFieldName.equals("material")) {
                defaultQueryName = "com.kingdee.eas.fi.rpt.app.F7MaterialNOFilterQuery";
            }
        } else if (mappingFieldName.equals("customer") && !this.paramIsTrue) {
            defaultQueryName = "com.kingdee.eas.fi.rpt.app.F7CustomerQuery";
        } else if (mappingFieldName.equals("provider") && !this.paramIsTrue) {
            defaultQueryName = "com.kingdee.eas.fi.rpt.app.F7SupplierQuery";
        } else if (mappingFieldName.equals("material")) {
            defaultQueryName = "com.kingdee.eas.fi.rpt.app.F7MaterialQuery";
        }
        return defaultQueryName;
    }

    public IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, OrgTypeForEntityEnum currentOrgType, boolean isIncludeFreezed) throws EASBizException, BOSException {
        String mappingFieldName = this.asstActTypeInfo.getAsstHGAttribute();
        boolean isSelfAsstActaiatem = this.asstActTypeInfo.isIsSelfAsstActaiatem();
        EntityViewInfo view = this.buildSearchView(this.asstActTypeInfo, isIncludeFreezed);
        if ("companyOrg".equals(mappingFieldName)) {
            if (null == view.getFilter()) {
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
            }
            this.addOrgFilter(view, currentOrgType);
        }
        if (mappingFieldName.equals("provider") && !this.isBaseGroupStandard) {
            queryPK = MetaDataPK.create((String)(isIncludeFreezed ? "com.kingdee.eas.fi.rpt.app.F7SupplierNOFilterQuery" : "com.kingdee.eas.fi.rpt.app.F7SupplierQuery"));
        }
        IQueryExecutor exec = null;
        exec = this._ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK) : QueryExecutorFactory.getLocalInstance((Context)this._ctx, (IMetaDataPK)queryPK);
        SelectorItemCollection scoll = new SelectorItemCollection();
        scoll.add(new SelectorItemInfo("id"));
        view.setSelector(scoll);
        exec.setObjectView(view);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        if (mappingFieldName.equals("adminOrg") || mappingFieldName.equals("companyOrg") || mappingFieldName.equals("costOrg") || mappingFieldName.equals("saleOrg") || mappingFieldName.equals("profitOrg") || mappingFieldName.equals("purchaseOrg") || mappingFieldName.equals("storeageOrg") || isSelfAsstActaiatem) {
            exec.option().isIgnorePermissionCheck = true;
        }
        return exec;
    }

    private void handAsstActType(Set asstActSet, AsstActTypeInfo info, IDynamicObject idynaObj, BOSObjectType type, EntityViewInfo ev, IQueryExecutor exec) throws BOSException, EASBizException {
        try {
            if (this.param.isGrade() && ("T_BD_GeneralAsstActType".equals(info.getRealtionDataObject()) || "T_ORG_CostCenter".equalsIgnoreCase(info.getRealtionDataObject()) || "T_ORG_ProfitCenter".equalsIgnoreCase(info.getRealtionDataObject()) || "T_ORG_Admin".equalsIgnoreCase(info.getRealtionDataObject()) || "T_ORG_Purchase".equalsIgnoreCase(info.getRealtionDataObject()) || "T_ORG_Sale".equalsIgnoreCase(info.getRealtionDataObject()) || "T_ORG_Storage".equalsIgnoreCase(info.getRealtionDataObject()))) {
                HashSet parentLongNumbers = new HashSet();
                String longNubmer = null;
                for (Object obj : asstActSet) {
                    longNubmer = ((AsstActObject)obj).getLongNumber();
                    if (StringUtils.isEmpty((String)longNubmer)) continue;
                    this.setParentLongNumber(parentLongNumbers, longNubmer);
                }
                if (!parentLongNumbers.isEmpty()) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("longNumber", parentLongNumbers, CompareType.INCLUDE));
                    filter.mergeFilter(new FilterInfo("id in(select id from (" + exec.getSQL() + ") asstType)"), "and");
                    ev.setFilter(filter);
                    IObjectCollection cl = idynaObj.getCollection(type, ev);
                    this.addArrayToList(asstActSet, cl.toArray(), this.asstActTypeInfo);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException("", (Throwable)e);
        }
    }

    private void setParentLongNumber(Set asstActSet, String longNubmer) {
        int index = longNubmer.lastIndexOf("!");
        if (index > 0) {
            String curLongNumber = longNubmer.substring(0, index);
            asstActSet.add(curLongNumber);
            this.setParentLongNumber(asstActSet, curLongNumber);
        }
    }

    public List getFillData(IQueryExecutor exec, IMetaDataPK queryPK) throws Exception {
        ArrayList list = null;
        HashSet asstActSet = null;
        QueryInfo queryInfo = this._ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(queryPK) : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this._ctx).getQuery(queryPK);
        SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
        SubEntityInfo mainEntityInfo = null;
        if (mainObjectInfo instanceof SubEntityInfo) {
            mainEntityInfo = (SubEntityInfo)mainObjectInfo;
        }
        if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
            IDynamicObject idynaObj = null;
            idynaObj = this._ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)this._ctx);
            BOSObjectType type = mainEntityInfo.getEntityRef().getType();
            String mappingFieldName = this.asstActTypeInfo.getAsstHGAttribute();
            SelectorItemCollection sic = this.getSelectorItemCollection(mappingFieldName);
            EntityViewInfo ev = new EntityViewInfo();
            ev.getSelector().addObjectCollection((IObjectCollection)sic);
            exec.option().isIgnoreOrder = true;
            boolean isOnlyFillHavingDataItem = NewRptUtil.getDyRptFillParamValue((Context)this._ctx, (Sheet)this.curSheet, (DynaParameters)this.param, null);
            List<String> formulaList = new ArrayList<String>();
            if (this.isAutoExe && !this.checkFormulas(formulaList = this.param.getDynaItemSource() == 0 && this.param.isGrade() ? this.getFormulasFillRowOrcolumnInGrade() : DynamicTemplateUtility.getFormulasFormFillRowOrColumn(this.curSheet, new Point(this.left, this.top), this.isReport))) {
                return null;
            }
            if (this.isAutoExe && isOnlyFillHavingDataItem) {
                try {
                    DynamicTemplateUtility.resumSheetFormulas(this.curSheet, formulaList);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"resumSheetFormulas error.", (Throwable)e);
                }
                String formulaUpper = null;
                for (int k = 0; k < formulaList.size(); ++k) {
                    String formula = formulaList.get(k);
                    formulaUpper = formula.toUpperCase();
                    if (formulaUpper.indexOf("AGE") >= 0 || formulaUpper.indexOf("ACCT") >= 0 || formulaUpper.indexOf("ACCTCASH") >= 0) continue;
                    formulaList.remove(formula);
                    --k;
                }
                DynamicTemplateUtility.getRelatedExcelFormula(this.curSheet, formulaList);
                ReportVariables vars = ReportVariables.loadFromBook((Book)this.curSheet.getBook());
                DyaItemFormulaParse formulaPars = new DyaItemFormulaParse(this._ctx, formulaList, vars, this.reportPropertyAdapter, this.curSheet.getSheetName(), this.company, true);
                formulaPars.formulaParse(this.curSheet);
                Set<String> asstTypeNumbers = formulaPars.getAsstActTypeNumberSet();
                LOGGER.info((Object)("isAccordFillItem:" + formulaPars.isAccordFillItem()));
                if (!(!formulaPars.isAccordFillItem() || formulaPars.getAcctFormulasGroupMap().isEmpty() && formulaPars.getAcctCashFormulasGroupMap().isEmpty())) {
                    Map paramMap = this.createParamMap(formulaPars, vars, exec);
                    Map dataMap = (this._ctx == null ? CslReportServiceFacadeFactory.getRemoteInstance() : CslReportServiceFacadeFactory.getLocalInstance((Context)this._ctx)).getDynItemData(paramMap);
                    Set idSet = new HashSet();
                    if (dataMap.get("isExecuteError") == null || !((Boolean)dataMap.get("isExecuteError")).booleanValue()) {
                        idSet = (Set)dataMap.get("fillItemSet");
                        if (idSet != null && !idSet.isEmpty()) {
                            LOGGER.info((Object)("newmethodFillItemData:" + idSet.size()));
                            FilterInfo filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                            ev.setFilter(filter);
                            IObjectCollection cl = idynaObj.getCollection(type, ev);
                            asstActSet = new HashSet(idSet.size());
                            this.addArrayToList(asstActSet, cl.toArray(), this.asstActTypeInfo);
                            this.handAsstActType(asstActSet, this.asstActTypeInfo, idynaObj, type, ev, exec);
                            if (asstActSet != null && !asstActSet.isEmpty()) {
                                list = new ArrayList(asstActSet);
                                this.sortList(list);
                            } else {
                                list = new ArrayList(0);
                            }
                            return list;
                        }
                        list = new ArrayList(0);
                        return list;
                    }
                    if (dataMap.get("isExecuteError") != null && ((Boolean)dataMap.get("isExecuteError")).booleanValue()) {
                        if (dataMap.containsKey("Exception") && dataMap.get("Exception") != null) {
                            Exception exception = (Exception)dataMap.get("Exception");
                            throw exception;
                        }
                        list = new ArrayList(0);
                        return list;
                    }
                }
            }
            try {
                HashSet<String> idSet = new HashSet<String>();
                IRowSet rowSet = null;
                int start = 0;
                int length = this.maxFillSize;
                boolean hasNext = false;
                if (exec.getRowCount() > this.maxFillSize && exec.getSQL().toLowerCase().indexOf("order by") < 0) {
                    if (exec.getObjectView() == null || exec.getObjectView().isNull()) {
                        exec.setObjectView(new EntityViewInfo());
                    }
                    SorterItemCollection sorters = new SorterItemCollection();
                    sorters.add(new SorterItemInfo("id"));
                    exec.getObjectView().setSorter(sorters);
                }
                while (start >= 0) {
                    hasNext = false;
                    rowSet = exec.executeQuery(start, length);
                    while (rowSet.next()) {
                        hasNext = true;
                        idSet.add(rowSet.getString("id"));
                    }
                    start = hasNext ? (start += length) : -1;
                    if (!idSet.isEmpty()) {
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                        ev.setFilter(filter);
                        IObjectCollection cl = idynaObj.getCollection(type, ev);
                        if (asstActSet == null) {
                            asstActSet = new HashSet(length * 4);
                        }
                        this.addArrayToList(asstActSet, cl.toArray(), this.asstActTypeInfo);
                    }
                    idSet.clear();
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        if (asstActSet != null && !asstActSet.isEmpty()) {
            list = new ArrayList(asstActSet);
            this.sortList(list);
        } else {
            list = new ArrayList(0);
        }
        return list;
    }

    private boolean checkFormulas(List formulaList) {
        for (Object formula : formulaList) {
            if (((String)formula).indexOf("@") <= -1) continue;
            return true;
        }
        return false;
    }

    private List getFormulasFillRowOrcolumnInGrade() {
        ArrayList<String> formulaList = new ArrayList<String>();
        if (this.gradeInfo != null && !StringUtils.isEmpty((String)this.grade)) {
            int end;
            int start;
            boolean isHorizon;
            boolean bl = isHorizon = this.spreadStyle == 1;
            if (isHorizon) {
                start = this.top + 1;
                end = this.curSheet.getRows().getMaxIntMark() + 1;
            } else {
                start = this.left + 1;
                end = this.curSheet.getCols().getMaxIntMark() + 1;
            }
            for (int i = start; i < end; ++i) {
                String formula = this.gradeInfo.getTempFormuma(this.grade + "---" + i);
                if (StringUtils.isEmpty((String)formula)) continue;
                formulaList.add(formula);
            }
        }
        return formulaList;
    }

    private Map createParamMap(DyaItemFormulaParse formulaPars, ReportVariables vars, IQueryExecutor exec) throws EASBizException, BOSException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formulaFilter", formulaPars.getAcctFormulasGroupMap());
        paramMap.put("acctCashFormulaFilter", formulaPars.getAcctCashFormulasGroupMap());
        String asstActTypeNumber = this.asstActTypeInfo.getNumber();
        if (!StringUtils.isEmpty((String)asstActTypeNumber)) {
            asstActTypeNumber = this.getAsstActType().getNumber();
        }
        paramMap.put("basePointAsstActNumber", asstActTypeNumber);
        if (this.asstActTypeInfo.getMappingFieldName() == null) {
            paramMap.put("fieldHg", "F" + this.asstActTypeInfo.getAsstHGAttribute() + "ID");
        } else {
            paramMap.put("fieldHg", this.asstActTypeInfo.getMappingFieldName());
        }
        paramMap.put("dynItemSql", exec.getSQL());
        if (this.company == null) {
            this.company = SysContext.getSysContext().getCurrentFIUnit();
            this.company = FullOrgUnitFactory.getLocalInstance((Context)this._ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.company.getId().toString()));
        }
        paramMap.put("currentUnit", this.company);
        RptSheetParamInfo rptSheetParamInfo = null;
        rptSheetParamInfo = this._ctx != null ? VariablesHelper.variables2SheetParams((ReportVariables)vars, (String)this.curSheet.getSheetName(), (boolean)true, (Context)this._ctx) : VariablesHelper.variables2SheetParams((ReportVariables)vars, (String)this.curSheet.getSheetName(), (boolean)true, null);
        paramMap.put("isIncludingUnposted", rptSheetParamInfo.isIsIncludingUnposted());
        paramMap.put("orgType", this.reportPropertyAdapter.getReportProperty("orgType"));
        return paramMap;
    }

    public List getFillData(Object[] objects, AsstActTypeInfo info, List listSelectedItem) throws EASBizException, BOSException {
        if (objects == null) {
            return null;
        }
        ArrayList list = null;
        HashSet asstActSet = new HashSet(objects.length * 4);
        this.listSelectedItem = listSelectedItem;
        this.addArrayToList(asstActSet, objects, info);
        this.asstActTypeInfo = info;
        if (asstActSet != null && !asstActSet.isEmpty()) {
            list = new ArrayList(asstActSet);
            this.sortList(list);
        } else {
            list = new ArrayList(0);
        }
        return list;
    }

    private void sortList(List list) {
        if (this.asstActTypeInfo.getAsstHGAttribute().equalsIgnoreCase("project")) {
            Collections.sort(list, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    AsstActObject actObject1 = (AsstActObject)arg0;
                    AsstActObject actObject2 = (AsstActObject)arg1;
                    String number1 = actObject1.getNumber();
                    String number2 = actObject2.getNumber();
                    if (number1 == null || number2 == null) {
                        return 0;
                    }
                    return number1.toLowerCase(Locale.ENGLISH).compareTo(number2.toLowerCase(Locale.ENGLISH));
                }
            });
        } else {
            Collections.sort(list);
        }
    }

    private boolean isBaseGroupStandard(String mappingFieldName) throws BOSException, EASBizException {
        if (this.isBaseGroupStandard && (mappingFieldName.equals("customer") || mappingFieldName.equals("provider") || mappingFieldName.equals("material"))) {
            String groupStandarNum = this.getGroupFilter(true);
            this.isBaseGroupStandard = this.isBaseGroupStandardType(this._ctx, mappingFieldName, groupStandarNum);
        }
        return this.isBaseGroupStandard;
    }

    public SelectorItemCollection getSelectorItemCollection(String mappingFieldName) throws BOSException, EASBizException {
        this.isBaseGroupStandard = this.isBaseGroupStandard(mappingFieldName);
        String groupIdSelector = null;
        if (!this.isBaseGroupStandard) {
            if (mappingFieldName.equals("customer")) {
                groupIdSelector = "customerGroupDetails.customerGroup.id";
            } else if (mappingFieldName.equals("provider")) {
                groupIdSelector = "supplierGroupDetails.supplierGroup.id";
            } else if (mappingFieldName.equals("material")) {
                groupIdSelector = "materialGroupDetails.materialGroup.id";
            }
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider")) {
            sic.add(new SelectorItemInfo("browseGroup"));
        } else if (mappingFieldName.equals("material")) {
            sic.add(new SelectorItemInfo("materialGroup"));
        } else {
            sic.add(new SelectorItemInfo("longNumber"));
            sic.add(new SelectorItemInfo("isLeaf"));
        }
        if (groupIdSelector != null) {
            sic.add(new SelectorItemInfo(groupIdSelector));
        }
        if (mappingFieldName.equals("costOrg")) {
            sic.add(new SelectorItemInfo("isBizUnit"));
        }
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    private IObjectCollection getGroupDetails(DataBaseInfo obj, String mappingFieldName) {
        CustomerGroupDetailCollection coll = null;
        if (mappingFieldName.equals("customer")) {
            coll = ((CustomerInfo)obj).getCustomerGroupDetails();
        } else if (mappingFieldName.equals("material")) {
            coll = ((MaterialInfo)obj).getMaterialGroupDetails();
        } else if (mappingFieldName.equals("provider")) {
            coll = ((SupplierInfo)obj).getSupplierGroupDetails();
        }
        return coll;
    }

    private DataBaseInfo getGroupInfo(String mappingFieldName, IObjectValue obj) {
        CSSPGroupInfo group = null;
        if (mappingFieldName.equals("customer")) {
            group = ((CustomerGroupDetailInfo)obj).getCustomerGroup();
        } else if (mappingFieldName.equals("material")) {
            group = ((MaterialGroupDetialInfo)obj).getMaterialGroup();
        } else if (mappingFieldName.equals("provider")) {
            group = ((SupplierGroupDetailInfo)obj).getSupplierGroup();
        }
        return group;
    }

    private void addArrayToList2(Set asstActSet, Object[] objects, AsstActTypeInfo info) throws EASBizException, BOSException {
        String mappingFieldName = info.getAsstHGAttribute();
        DataBaseCollection col = null;
        boolean isMulti = false;
        col = this.getBaseDataGroup(this._ctx, mappingFieldName);
        if (col == null) {
            return;
        }
        if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider") || mappingFieldName.equals("material")) {
            isMulti = true;
        }
        HashMap<String, DataBaseInfo> csspCache = new HashMap<String, DataBaseInfo>(col.size());
        DataBaseInfo group = null;
        for (int i = 0; i < col.size(); ++i) {
            group = col.get(i);
            csspCache.put(group.getId().toString(), group);
        }
        HashSet<BOSUuid> csspGroup = new HashSet<BOSUuid>(objects.length);
        DataBaseInfo obj = null;
        String id = null;
        String number = null;
        String longNumber = null;
        String name = null;
        AsstActObject asstActObj = null;
        int index = 0;
        String firstLongNumber = null;
        IObjectCollection coll = null;
        boolean isLeaf = false;
        for (int i = 0; i < objects.length; ++i) {
            obj = (DataBaseInfo)objects[i];
            if (this.isBaseGroupStandard) {
                group = (DataBaseInfo)obj.get(mappingFieldName.equals("material") ? "materialGroup" : "browseGroup");
            } else {
                coll = this.getGroupDetails(obj, mappingFieldName);
                if (coll != null) {
                    for (int j = 0; !(j >= coll.size() || (group = this.getGroupInfo(mappingFieldName, coll.getObject(j))) != null && csspCache.containsKey(group.getId().toString())); ++j) {
                    }
                }
            }
            if (group != null && !csspCache.containsKey(group.getId().toString())) continue;
            index = 0;
            firstLongNumber = null;
            while (group != null && !csspGroup.contains(group.getId().toString())) {
                if ((group = (DataBaseInfo)csspCache.get(group.getId().toString())) == null) continue;
                id = group.getId().toString();
                asstActObj = new AsstActObject(id, number = group.getNumber(), longNumber = (String)group.get("longNumber"), name = group.getName(), isMulti, isLeaf = false);
                if (this.canAdd(asstActObj)) {
                    asstActSet.add(asstActObj);
                    csspGroup.add(group.getId());
                }
                group = (DataBaseInfo)group.get("parent");
                if (index == 0) {
                    firstLongNumber = longNumber;
                }
                ++index;
            }
            id = obj.getId().toString();
            number = obj.getNumber();
            longNumber = null;
            longNumber = firstLongNumber != null ? firstLongNumber + "!" + number : number;
            asstActObj = new AsstActObject(id, number, longNumber, name = obj.getName(), isMulti, isLeaf = true);
            if (!this.canAdd(asstActObj)) continue;
            asstActSet.add(asstActObj);
        }
    }

    private boolean isBaseGroupStandardType(Context ctx, String mappingFieldName, String GroupStandardNum) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)GroupStandardNum)) {
            StringBuffer oql = new StringBuffer();
            if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider")) {
                oql.append("select isBasic where number='").append(GroupStandardNum).append("' ");
                if (mappingFieldName.equals("customer")) {
                    oql.append(" and type in(0,1) ");
                } else {
                    oql.append(" and type in(0,2) ");
                }
                ICSSPGroupStandard iDataBase = ctx == null ? CSSPGroupStandardFactory.getRemoteInstance() : CSSPGroupStandardFactory.getLocalInstance((Context)ctx);
                CSSPGroupStandardInfo info = iDataBase.getCSSPGroupStandardInfo(oql.toString());
                if (info != null && !info.getIsBasic().equals((Object)StandardTypeEnum.basicStandard)) {
                    return false;
                }
            } else if (mappingFieldName.equals("material")) {
                oql.append("select standardType where number='").append(GroupStandardNum).append("' ");
                IMaterialGroupStandard iDataBase = ctx == null ? MaterialGroupStandardFactory.getRemoteInstance() : MaterialGroupStandardFactory.getLocalInstance((Context)ctx);
                MaterialGroupStandardInfo info = iDataBase.getMaterialGroupStandardInfo(oql.toString());
                if (info != null && !info.getStandardType().equals((Object)StandardTypeEnum.basicStandard)) {
                    return false;
                }
            }
        }
        return true;
    }

    public DataBaseCollection getBaseDataGroup(Context ctx, String mappingFieldName) throws EASBizException, BOSException {
        DataBaseCollection col = null;
        String groupFilter = this.getGroupFilter(false);
        StringBuffer oql = new StringBuffer();
        if (mappingFieldName.equals("customer")) {
            oql.append("select id, number, name, longNumber, parent");
            oql.append(" where deletedStatus = 1 and groupStandard.type in (0, 1)");
            if (!StringUtils.isEmpty((String)groupFilter)) {
                oql.append(" and (").append(groupFilter).append(")");
            }
            col = ctx == null ? CSSPGroupFactory.getRemoteInstance().getDataBaseCollection(oql.toString()) : CSSPGroupFactory.getLocalInstance((Context)ctx).getDataBaseCollection(oql.toString());
        } else if (mappingFieldName.equals("provider")) {
            oql.append("select id, number, name, longNumber, parent");
            oql.append(" where deletedStatus = 1 and groupStandard.type in (0, 2)");
            if (!StringUtils.isEmpty((String)groupFilter)) {
                oql.append(" and (").append(groupFilter).append(")");
            }
            col = ctx == null ? CSSPGroupFactory.getRemoteInstance().getDataBaseCollection(oql.toString()) : CSSPGroupFactory.getLocalInstance((Context)ctx).getDataBaseCollection(oql.toString());
        } else if (mappingFieldName.equals("material")) {
            oql.append("select id, number, name, longNumber, parent ");
            oql.append(" where deletedStatus = 1");
            if (!StringUtils.isEmpty((String)groupFilter)) {
                oql.append(" and (").append(groupFilter).append(")");
            }
            col = ctx == null ? MaterialGroupFactory.getRemoteInstance().getDataBaseCollection(oql.toString()) : MaterialGroupFactory.getLocalInstance((Context)ctx).getDataBaseCollection(oql.toString());
        }
        return col;
    }

    private FilterInfo getGroupFilter() throws BOSException {
        try {
            FilterInfo groupFilter;
            String[] hGAttAndGroup = this.getHGAttAndGroup();
            String asstHGAttribute = hGAttAndGroup[0];
            String groups = hGAttAndGroup[1];
            if (asstHGAttribute != null && DynamicTemplateUtility.isBaseAsstActType(asstHGAttribute) && groups != null && (groupFilter = this.getAssistantSubTypeFilterByNumber(asstHGAttribute, groups, true)) != null && groupFilter.getFilterItems() != null && groupFilter.getFilterItems().size() > 0) {
                return groupFilter;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"getGroupFilter error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private String[] getHGAttAndGroup() throws BOSException {
        String asstHGAttribute = null;
        String groups = null;
        if (this.param == null) {
            return new String[2];
        }
        if (this.param.isGrade() && this.param.getDynaItemSource() == 0) {
            if (this.getGradeEntryInfo() != null && this.getGradeEntryInfo().getDetailSource() != 0) {
                asstHGAttribute = this.getAsstActTypeInfo().getAsstHGAttribute();
                groups = this.getGradeEntryInfo().getAsstActSubTypeString();
            }
        } else if (this.param.getDynaItemSource() != 0) {
            asstHGAttribute = this.param.getAssistantType().getAsstHGAttribute();
            if (this.param.getAssistantTypeSubType() != null) {
                groups = this.param.getAssistantTypeSubType();
            }
        }
        return new String[]{asstHGAttribute, groups};
    }

    private String getGroupFilter(boolean isGetGroupStandar) throws BOSException {
        block4: {
            try {
                String[] hGAttAndGroup = this.getHGAttAndGroup();
                String asstHGAttribute = hGAttAndGroup[0];
                String groups = hGAttAndGroup[1];
                if (asstHGAttribute == null || !DynamicTemplateUtility.isBaseAsstActType(asstHGAttribute) || groups == null) break block4;
                if (!isGetGroupStandar) {
                    FilterInfo groupFilter = this.getAssistantSubTypeFilterByNumber(asstHGAttribute, groups, false);
                    if (groupFilter != null && groupFilter.getFilterItems() != null && groupFilter.getFilterItems().size() > 0) {
                        return groupFilter.toSql();
                    }
                    break block4;
                }
                return this.getGroupStandardNumber(asstHGAttribute, groups);
            }
            catch (Exception e) {
                LOGGER.error((Object)"getGroupFilter error.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    public String getGroupStandardNumber(String asstHGAttribute, String groups) throws Exception {
        if (groups.equals("all")) {
            return null;
        }
        AcctountAsstItemParser.AccountAsstItem item = TableToolkit.parseAcctItem((String)("1002|001|" + groups + "#"));
        if (item == null) {
            return null;
        }
        AcctountAsstItemParser.Group[] group = item.asstItems[0].group;
        for (int i = 0; group != null && i < group.length; ++i) {
            String std = group[i].standardNumber;
            if (StringUtils.isEmpty((String)std)) continue;
            return std;
        }
        return null;
    }

    public FilterInfo getAssistantSubTypeFilterByNumber(String asstHGAttribute, String groups, boolean isForQuery) throws Exception {
        return DynamicTemplateUtility.getAssistantSubTypeFilterByNumber(asstHGAttribute, groups, isForQuery, this.subTypeFilterMap, this._ctx);
    }

    protected TreeBaseInfo getTreeBaseNodeByNumber(String number, String groupTableName) throws Exception {
        return DynamicTemplateUtility.getTreeBaseNodeByNumber(number, groupTableName, this._ctx);
    }

    private void addArrayToList(Set asstActSet, Object[] objects, AsstActTypeInfo info) throws EASBizException, BOSException {
        boolean isSelfAsstActaiatem;
        String mappingFieldName = info.getAsstHGAttribute();
        if (mappingFieldName.equals("customer") || mappingFieldName.equals("provider") || mappingFieldName.equals("material")) {
            this.addArrayToList2(asstActSet, objects, info);
            return;
        }
        boolean isMulti = info.isIsMultilevel();
        String realType = info.getRealtionDataObject();
        boolean bl = isSelfAsstActaiatem = realType != null && (realType.equalsIgnoreCase("T_BD_GeneralAsstActType") || realType.equalsIgnoreCase("T_FDC_CurProject"));
        if (!StringUtils.isEmpty((String)info.getGroupTableName())) {
            isMulti = false;
        }
        boolean isLeaf = true;
        for (int i = 0; i < objects.length; ++i) {
            DataBaseInfo obj = (DataBaseInfo)objects[i];
            String id = obj.getId().toString();
            String number = obj.getNumber();
            String longNumber = null;
            if (isMulti) {
                TreeBaseInfo treeObj = (TreeBaseInfo)obj;
                longNumber = treeObj.getLongNumber();
                isLeaf = treeObj.isIsLeaf();
            }
            if (isMulti && isSelfAsstActaiatem) {
                number = number == null || number.trim().equals("") ? number : (longNumber != null ? longNumber.replaceAll("!", ".") : "");
            }
            String name = obj.getName();
            AsstActObject asstActObj = new AsstActObject(id, number, longNumber, name, isMulti, isLeaf);
            asstActObj.setSelfAsstActaiatem(isSelfAsstActaiatem);
            if (mappingFieldName.equals("costOrg")) {
                asstActObj.setBizUnit(obj.getBoolean("isBizUnit"));
            }
            if (!this.canAdd(asstActObj)) continue;
            asstActSet.add(asstActObj);
        }
    }

    private boolean canAdd(AsstActObject asstActObj) {
        if (this.isAutoExe) {
            return true;
        }
        return this.getListSelectedItem().isEmpty() || !this.getListSelectedItem().contains(asstActObj);
    }

    public List getListSelectedItem() {
        if (this.listSelectedItem == null) {
            this.listSelectedItem = new ArrayList(0);
        }
        return this.listSelectedItem;
    }

    public void setListSelectedItem(List listSelectedItem) {
        this.listSelectedItem = listSelectedItem;
    }

    private void addOrgFilter(EntityViewInfo view, OrgTypeForEntityEnum currentOrgType) {
        Integer isTrue = new Integer(1);
        if (currentOrgType.getValue() == 1) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isCompanyOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 5) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isCostOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 7) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isHROrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 6) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isProfitOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 3) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isPurchaseOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 2) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isSaleOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 4) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isStorageOrgUnit", (Object)isTrue));
        } else if (currentOrgType.getValue() == 8) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isTransportOrgUnit", (Object)isTrue));
        }
    }

    public EntityViewInfo buildSearchView(AsstActTypeInfo info, boolean isIncludeFreezed) throws EASBizException, BOSException {
        String mappingFieldName = info.getAsstHGAttribute();
        boolean isSelfAsstActaiatem = info.isIsSelfAsstActaiatem();
        if (mappingFieldName.equals("customer")) {
            return this.buildCustomerView(info, isIncludeFreezed);
        }
        if (mappingFieldName.equals("provider")) {
            return this.buildProviderView(isIncludeFreezed);
        }
        if (mappingFieldName.equals("bankAccount")) {
            return this.buildAccountBankView();
        }
        if (mappingFieldName.equals("companyOrg") || mappingFieldName.equals("costOrg") || mappingFieldName.equals("saleOrg") || mappingFieldName.equals("profitOrg") || mappingFieldName.equals("purchaseOrg") || mappingFieldName.equals("storeageOrg")) {
            EntityViewInfo view = new EntityViewInfo();
            if (mappingFieldName.equalsIgnoreCase("costOrg")) {
                this.buildCostOrgView(view);
            }
            return view;
        }
        if (mappingFieldName.equals("adminOrg")) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
            fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
            return view;
        }
        if (mappingFieldName.equals("person")) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            if (this.paramIsTrue) {
                String adminOrgFilterSql;
                OrgUnitInfo orgUnitInfo = this.company;
                if (orgUnitInfo == null) {
                    orgUnitInfo = this._ctx == null ? SysContext.getSysContext().getCurrentOrgUnit() : ContextUtil.getCurrentOrgUnit((Context)this._ctx);
                }
                if (orgUnitInfo != null && !StringUtils.isEmpty((String)(adminOrgFilterSql = CslRptUtil.getAdminOrgUnitFilterSql((Context)this._ctx, (String)orgUnitInfo.getId().toString())))) {
                    filter.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.id", (Object)adminOrgFilterSql, CompareType.INNER));
                    filter.getFilterItems().add(new FilterItemInfo("PM2.id", null, CompareType.IS));
                    filter.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT2.id", (Object)adminOrgFilterSql, CompareType.INNER));
                    filter.setMaskString("( (#0 and #1) or #2 )");
                }
            }
            return view;
        }
        if (isSelfAsstActaiatem) {
            EntityViewInfo view = new EntityViewInfo();
            if (this.cu == null) {
                this.cu = this._ctx == null ? SysContext.getSysContext().getCurrentFIUnit() : ContextUtil.getCurrentCtrlUnit((Context)this._ctx);
            }
            if (this.paramIsTrue && !"00000000-0000-0000-0000-000000000000CCE7AED4".equals(this.cu.getId().toString())) {
                this.addCUConditions(mappingFieldName, view, "CurProject");
            }
            return view;
        }
        if (mappingFieldName.equalsIgnoreCase("costObject")) {
            EntityViewInfo view = new EntityViewInfo();
            if (this.paramIsTrue) {
                this.addCUConditions(mappingFieldName, view, "costObject");
            }
            return view;
        }
        if (mappingFieldName.equals("material")) {
            return this.buildMateralView(isIncludeFreezed);
        }
        if (mappingFieldName.equals("project")) {
            EntityViewInfo view = new EntityViewInfo();
            OrgUnitInfo currentBizOrg = this.company;
            CtrlUnitInfo cu = this.company.getCU();
            if (currentBizOrg != null && cu != null && this.paramIsTrue) {
                String longNumber = null;
                longNumber = this._ctx == null ? CtrlUnitFactory.getRemoteInstance().getOrgUnitInfo("select longNumber where id = '" + cu.getId().toString() + "'").getLongNumber() : CtrlUnitFactory.getLocalInstance((Context)this._ctx).getOrgUnitInfo("select longNumber where id = '" + cu.getId().toString() + "'").getLongNumber();
                String[] numbers = longNumber.split("!");
                HashSet<String> lnUps = new HashSet<String>();
                for (int i = 0; i < numbers.length; ++i) {
                    lnUps.add(numbers[i]);
                }
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("cu.number", lnUps, CompareType.INCLUDE));
                filter.setMaskString("#0");
                view.setFilter(filter);
            }
            return view;
        }
        String groupId = info.getGlAsstActTypeGrp() != null ? info.getGlAsstActTypeGrp().getId().toString() : null;
        EntityViewInfo view = new EntityViewInfo();
        String maskString = "";
        FilterInfo filter = null;
        if (info.isIsSelfAsstActaiatem() || !StringUtils.isEmpty((String)groupId)) {
            CompanyOrgUnitInfo orgUnitInfo = MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType(this.company, this._ctx);
            filter = DynamicTemplateUtility.getFilterForGeneral(this._ctx, groupId, orgUnitInfo);
        } else {
            filter = this.getCommonFilter();
        }
        if ("T_BD_GeneralAsstActType".equalsIgnoreCase(info.getRealtionDataObject())) {
            this.setIncludeFreezedFiilter(isIncludeFreezed, filter);
        }
        view.setFilter(filter);
        return view;
    }

    private void setIncludeFreezedFiilter(boolean isIncludeFreezed, FilterInfo filter) {
        FilterInfo newFilter = new FilterInfo();
        newFilter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)new Integer(1)));
        if (isIncludeFreezed) {
            newFilter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)new Integer(0)));
            newFilter.setMaskString("(#0 or #1)");
        } else {
            newFilter.setMaskString("#0");
        }
        try {
            filter.mergeFilter(newFilter, "AND");
        }
        catch (BOSException e) {
            LOGGER.error((Object)e.toString());
        }
    }

    private FilterInfo getCommonFilter() {
        FilterInfo filter = new FilterInfo();
        if (this.paramIsTrue) {
            this.cu = this.company != null ? this.company.getCU() : SysContext.getSysContext().getCurrentFIUnit().getCU();
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)this.cu.getId().toString(), CompareType.EQUALS));
            filter.setMaskString(" #0 or #1 or #2 ");
        }
        return filter;
    }

    private EntityViewInfo buildProviderView(boolean isIncludeFreezed) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        if (!this.paramIsTrue) {
            FilterInfo filter = new FilterInfo();
            String maskString = "";
            if (isIncludeFreezed) {
                filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                maskString = "(#" + (filter.getFilterItems().size() - 1);
                filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(2)));
                maskString = maskString + " or #" + (filter.getFilterItems().size() - 1);
                filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(3)));
                maskString = maskString + " or #" + (filter.getFilterItems().size() - 1) + ")";
                filter.setMaskString(maskString);
            } else {
                filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                maskString = "(" + maskString + ") and #" + (filter.getFilterItems().size() - 1);
            }
            view.setFilter(filter);
            return view;
        }
        ObjectUuidPK cuPK = new ObjectUuidPK(this.company.getCU().getId());
        FilterInfo filter = null;
        filter = this._ctx == null ? SupplierFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id") : SupplierFactory.getLocalInstance((Context)this._ctx).getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        String maskString = filter.getMaskString();
        if (StringUtils.isEmpty((String)maskString)) {
            maskString = "";
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                if (i != 0) {
                    maskString = maskString + " and ";
                }
                maskString = maskString + "#" + i;
            }
        }
        if (isIncludeFreezed) {
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
            maskString = "(" + maskString + ") and (#" + (filter.getFilterItems().size() - 1);
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(2)));
            maskString = maskString + " or #" + (filter.getFilterItems().size() - 1);
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(3)));
            maskString = maskString + " or #" + (filter.getFilterItems().size() - 1) + ")";
            filter.setMaskString(maskString);
        } else {
            filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
            maskString = "(" + maskString + ") and #" + (filter.getFilterItems().size() - 1);
        }
        filter.getFilterItems().add(new FilterItemInfo("supplierGroupDetails.supplierGroupStandard.type", (Object)0));
        maskString = "(" + maskString + ") and (#" + (filter.getFilterItems().size() - 1);
        filter.getFilterItems().add(new FilterItemInfo("supplierGroupDetails.supplierGroupStandard.type", (Object)2));
        maskString = maskString + " or #" + (filter.getFilterItems().size() - 1) + ")";
        this.isBaseGroupStandard = this.isBaseGroupStandard("provider");
        if (this.isBaseGroupStandard) {
            filter.getFilterItems().add(new FilterItemInfo("supplierGroupDetails.supplierGroupStandard.isBasic", (Object)1));
            maskString = "(" + maskString + ") and #" + (filter.getFilterItems().size() - 1);
        }
        filter.setMaskString(maskString);
        if (filter != null && filter.getFilterItems().size() > 0) {
            view.setFilter(filter);
        }
        return view;
    }

    private EntityViewInfo buildCustomerView(AsstActTypeInfo info, boolean includeFreezed) throws EASBizException, BOSException {
        FilterInfo orgFilter;
        EntityViewInfo view = new EntityViewInfo();
        if (!this.paramIsTrue) {
            FilterInfo filter = new FilterInfo();
            String maskString = "";
            if (includeFreezed) {
                filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
                maskString = " (#" + (filter.getFilterItems().size() - 1);
                filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(2)));
                maskString = maskString + " or #" + (filter.getFilterItems().size() - 1);
                filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(3)));
                maskString = maskString + " or #" + (filter.getFilterItems().size() - 1) + ")";
                filter.setMaskString(maskString);
            } else {
                filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
            }
            view.setFilter(filter);
            return view;
        }
        OrgUnitInfo currentBizOrg = this.company;
        CtrlUnitInfo cu = this.company.getCU();
        if (currentBizOrg != null && cu != null && (orgFilter = RptUtil.buildCustomerFilter((Context)this._ctx, (OrgUnitInfo)currentBizOrg, (boolean)includeFreezed)) != null && orgFilter.getFilterItems().size() > 0) {
            view.setFilter(orgFilter);
        }
        return view;
    }

    private EntityViewInfo buildAccountBankView() {
        EntityViewInfo view = new EntityViewInfo();
        if (!this.paramIsTrue) {
            return view;
        }
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        String companyid = this.company.getId().toString();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)companyid));
        fic.add(new FilterItemInfo("company.id", null));
        filter.setMaskString("#0 OR #1  ");
        return view;
    }

    private void buildCostOrgView(EntityViewInfo view) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        if (this.paramIsTrue) {
            CompanyOrgUnitInfo orgUnitInfo = MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType(this.company, this._ctx);
            String curOrgCU = null;
            String longNumber = null;
            if (orgUnitInfo == null || orgUnitInfo.getCU() == null) {
                orgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
                curOrgCU = this.getCurOrgCU(orgUnitInfo);
            } else {
                curOrgCU = this.getCurOrgCU(orgUnitInfo);
            }
            boolean isBizUnit = orgUnitInfo.isIsBizUnit();
            longNumber = isBizUnit ? orgUnitInfo.getLongNumber() : orgUnitInfo.getCU().getLongNumber();
            HashSet<String> CostOrgIds = new HashSet<String>();
            if (orgUnitInfo.isIsBizUnit()) {
                CostOrgIds.add(curOrgCU);
            } else {
                this.getCurCUCostOrgs(curOrgCU, CostOrgIds);
            }
            this.getFromCostOrgs(curOrgCU, CostOrgIds);
            if (CostOrgIds.size() <= 0) {
                CostOrgIds.add(orgUnitInfo.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", CostOrgIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
            filter.setMaskString("( #0 OR #1 ) AND #2");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        }
        view.setFilter(filter);
    }

    private void addCUConditions(String mappingFieldName, EntityViewInfo view, String specialItem) {
        if (specialItem.equalsIgnoreCase(mappingFieldName)) {
            FilterInfo filter = view.getFilter();
            if (filter == null) {
                filter = new FilterInfo();
            }
            view.setFilter(filter);
            String currentBizOrgID = this.company.getId().toString();
            if (!specialItem.equalsIgnoreCase("costObject")) {
                filter.getFilterItems().add(new FilterItemInfo("Fullorgunit.id", (Object)currentBizOrgID));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentBizOrgID));
            }
        }
    }

    private EntityViewInfo buildMateralView(boolean includeFreezed) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (includeFreezed) {
            HashSet<Integer> set = new HashSet<Integer>();
            set.add(new Integer(1));
            set.add(new Integer(2));
            set.add(new Integer(3));
            filter.getFilterItems().add(new FilterItemInfo("status", set, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        }
        if (!this.paramIsTrue) {
            view.setFilter(filter);
            return view;
        }
        CtrlUnitInfo currentBizOrg = this.company.getCU();
        ObjectUuidPK cuPK = new ObjectUuidPK(currentBizOrg.getId());
        FilterItemCollection filterItems = filter.getFilterItems();
        FilterInfo endFilter = null;
        endFilter = this._ctx == null ? MaterialFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id") : MaterialFactory.getLocalInstance((Context)this._ctx).getDatabaseDFilter((IObjectPK)cuPK, "id", "adminCU.id");
        if (endFilter != null && endFilter.getFilterItems().size() > 0) {
            endFilter.getFilterItems().addObjectCollection((IObjectCollection)filterItems);
            view.setFilter(endFilter);
        } else {
            view.setFilter(filter);
        }
        return view;
    }

    private String getCurOrgCU(CompanyOrgUnitInfo orgUnitInfo) {
        String curOrgCU = null;
        boolean isBizUnit = orgUnitInfo.isIsBizUnit();
        curOrgCU = isBizUnit ? orgUnitInfo.getId().toString() : orgUnitInfo.getCU().getId().toString();
        return curOrgCU;
    }

    private void getCurCUCostOrgs(String curOrgCU, Set CostOrgIds) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer("#0");
        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)curOrgCU));
        filter.getFilterItems().add(new FilterItemInfo("iscostOrgUnit", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isAssistantOrg", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("partCostCenter.isSealUp", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isAdminOrgUnit", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("partAdmin.isVirtual", (Object)0));
        maskString.append(" and #1 and #2 and #3 and #4 and (#5 or #6)");
        filter.setMaskString(maskString.toString());
        ev.setSelector(sic);
        ev.setFilter(filter);
        FullOrgUnitCollection fullOrgUnitIds = this._ctx == null ? FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(ev) : FullOrgUnitFactory.getLocalInstance((Context)this._ctx).getFullOrgUnitCollection(ev);
        String orgUnitId = null;
        for (int i = 0; i < fullOrgUnitIds.size(); ++i) {
            orgUnitId = fullOrgUnitIds.get(i).getId().toString();
            if (CostOrgIds.contains(orgUnitId)) continue;
            CostOrgIds.add(orgUnitId);
        }
    }

    private void getFromCostOrgs(String curOrgCU, Set CostOrgIds) throws EASBizException, BOSException {
        OrgUnitCollection orgUnitRelationCollection = this._ctx == null ? OrgUnitRelationFactory.getRemoteInstance().getFromUnit(curOrgCU, 1, 5) : OrgUnitRelationFactory.getLocalInstance((Context)this._ctx).getFromUnit(curOrgCU, 1, 5);
        if (orgUnitRelationCollection != null && orgUnitRelationCollection.size() > 0) {
            String orgUnitId = null;
            for (int i = 0; i < orgUnitRelationCollection.size(); ++i) {
                orgUnitId = orgUnitRelationCollection.get(i).getId().toString();
                if (CostOrgIds.contains(orgUnitId)) continue;
                CostOrgIds.add(orgUnitId);
            }
        }
    }

    private AsstActTypeInfo getAsstActType() throws EASBizException, BOSException {
        String number = this.getAssistantType().properityName;
        IAsstActType iType = this._ctx == null ? AsstActTypeFactory.getRemoteInstance() : AsstActTypeFactory.getLocalInstance((Context)this._ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("asstHGAttribute"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("isSelfAsstActaiatem"));
        view.getSelector().add(new SelectorItemInfo("defaultQueryName"));
        view.getSelector().add(new SelectorItemInfo("glAsstActTypeGrp.id"));
        view.getSelector().add(new SelectorItemInfo("realtionDataObject"));
        view.getSelector().add(new SelectorItemInfo("isMultilevel"));
        view.getSelector().add(new SelectorItemInfo("groupTableName"));
        view.getSelector().add(new SelectorItemInfo("mappingfieldname"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        AsstActTypeCollection actTypeColl = iType.getAsstActTypeCollection(view);
        if (actTypeColl != null && actTypeColl.size() > 0) {
            return actTypeColl.get(0);
        }
        String hgAttri = this.getAssistantType().asstHGAttribute;
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("asstHGAttribute", (Object)hgAttri, CompareType.EQUALS));
        view.setFilter(filter);
        actTypeColl = iType.getAsstActTypeCollection(view);
        if (actTypeColl != null && actTypeColl.size() > 0) {
            return actTypeColl.get(0);
        }
        String alias = this.getAssistantType().properityAlias;
        if (!this.isAutoExe) {
            throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"DynaWizard_AsstActTypeNotExist")), new Object[]{alias});
        }
        return null;
    }

    private AsstActTypeUtils locateTextGradeSite() {
        boolean isRightDown;
        DItemGradeEntryInfo entry = null;
        AsstActTypeUtils type = null;
        boolean bl = isRightDown = this.param.getPosition() == 2;
        if (!isRightDown) {
            if (this.spreadStyle == 0) {
                for (int i = this.activePoint.y; i > this.top; --i) {
                    ItemFormula item = UserObjectHelper.getItemFormula((Cell)this.curSheet.getCell(i, this.left, false));
                    if (item == null) continue;
                    String grade = item.getExt("GRADE_NUMBER");
                    entry = this.gradeInfo.find(grade);
                    if (entry != null) {
                        type = entry.getDetailAsstType();
                        this.gradeEntryInfo = entry;
                        if (type == null) break;
                    }
                    if (type == null) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = this.activePoint.x; i > this.left; --i) {
                    ItemFormula item = UserObjectHelper.getItemFormula((Cell)this.curSheet.getCell(this.top, i, false));
                    if (item == null) continue;
                    String grade = item.getExt("GRADE_NUMBER");
                    entry = this.gradeInfo.find(grade);
                    if (entry != null) {
                        type = entry.getDetailAsstType();
                        this.gradeEntryInfo = entry;
                        if (type == null) break;
                    }
                    if (type == null) {
                        continue;
                    }
                    break;
                }
            }
        } else if (this.spreadStyle == 0) {
            if (this.activePoint.y <= this.top) {
                return type;
            }
            for (int i = this.activePoint.y; i <= this.top + this.param.getDefaultCounter(); ++i) {
                ItemFormula item = UserObjectHelper.getItemFormula((Cell)this.curSheet.getCell(i, this.left, false));
                if (item == null) continue;
                String grade = item.getExt("GRADE_NUMBER");
                entry = this.gradeInfo.find(grade);
                if (entry != null) {
                    type = entry.getDetailAsstType();
                    this.gradeEntryInfo = entry;
                    if (type == null) break;
                }
                if (type == null) {
                    continue;
                }
                break;
            }
        } else {
            if (this.activePoint.x <= this.left) {
                return type;
            }
            for (int i = this.activePoint.x; i <= this.left + this.param.getDefaultCounter(); ++i) {
                ItemFormula item = UserObjectHelper.getItemFormula((Cell)this.curSheet.getCell(this.top, i, false));
                if (item == null) continue;
                String grade = item.getExt("GRADE_NUMBER");
                entry = this.gradeInfo.find(grade);
                if (entry != null) {
                    type = entry.getDetailAsstType();
                    this.gradeEntryInfo = entry;
                    if (type == null) break;
                }
                if (type == null) {
                    continue;
                }
                break;
            }
        }
        if (entry != null && entry.getDetailSource() == 0) {
            return null;
        }
        return type;
    }

    public AsstActTypeUtils getAssistantType() {
        return this.assistantType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Point initBasePoint(Sheet table, ArrayList list, Point activePoint) throws EASBizException, BOSException {
        Point point = new Point(2, 2);
        int col = activePoint.x;
        int row = activePoint.y;
        if (col >= 0 && row >= 0) {
            point.x = col < 0 ? 0 : col;
            point.y = row < 0 ? 0 : row;
            if (list.size() <= 0) return point;
            if ((point = DynamicTemplateUtility.getBasePoint(table, point, list)) != null) return point;
            if (list.size() != 1) throw new EASBizException(new NumericExceptionSubItem("1", EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Dyna_NotInRange")));
            return (Point)list.get(0);
        }
        if (list.size() <= 0) return point;
        return (Point)list.get(0);
    }

    public int getMaxFillSize() {
        return this.maxFillSize;
    }

    public void setMaxFillSize(int maxFillSize) {
        this.maxFillSize = maxFillSize;
    }

    public ArrayList getBasePointList() {
        return this.basePointList;
    }

    public int getSpreadStyle() {
        return this.spreadStyle;
    }

    public DynaParameters getParam() {
        return this.param;
    }

    public DItemGradeInfo getGradeInfo() {
        return this.gradeInfo;
    }

    public AsstActTypeInfo getAsstActTypeInfo() {
        return this.asstActTypeInfo;
    }

    public boolean isParamIsTrue() {
        return this.paramIsTrue;
    }

    public Sheet getCurSheet() {
        return this.curSheet;
    }

    public boolean isReport() {
        return this.isReport;
    }

    public Point getActivePoint() {
        return this.activePoint;
    }

    public boolean isAutoExe() {
        return this.isAutoExe;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public DItemGradeEntryInfo getGradeEntryInfo() {
        return this.gradeEntryInfo;
    }

    public Point getNewBasePoint() {
        return this.newBasePoint;
    }

    public void setNewBasePoint(Point newBasePoint) {
        this.newBasePoint = newBasePoint;
    }

    public boolean getIsRptCover() {
        return this.isRptCover;
    }

    public void setRptCover(boolean isRptCover) {
        this.isRptCover = isRptCover;
    }
}

