/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.util;

import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import java.awt.Point;
import java.util.List;

public class DynamicTemplateCoverUtil {
    public static Point findBasePoint(Sheet newSheet, Sheet oldSheet, List newPointList, Point activePoint) {
        if (newPointList == null || newPointList.size() == 0) {
            return null;
        }
        DynaParameters oldParam = DynamicTemplateCoverUtil.getParameters(oldSheet, activePoint);
        boolean oldIsHorizon = DynamicTemplateCoverUtil.isHorizon(oldParam);
        if (oldParam == null || oldParam.getDefaultCounter() == 0) {
            return null;
        }
        for (int i = 0; i < newPointList.size(); ++i) {
            Point newPoint = (Point)newPointList.get(i);
            DynaParameters newParam = DynamicTemplateCoverUtil.getParameters(newSheet, newPoint);
            boolean newIsHorizon = DynamicTemplateCoverUtil.isHorizon(newParam);
            boolean isSamePoint = DynamicTemplateCoverUtil.compareBasePoints(oldParam, newParam);
            if (!isSamePoint) continue;
            int oldItemCount = DynamicTemplateUtility.getDynaHeadItemCount(oldSheet, activePoint);
            int newItemCount = DynamicTemplateUtility.getDynaHeadItemCount(newSheet, newPoint);
            for (int j = 1; j <= oldItemCount; ++j) {
                String curFormula = null;
                curFormula = oldIsHorizon ? DynamicTemplateCoverUtil.getFormula(oldSheet, activePoint.y + j, activePoint.x) : DynamicTemplateCoverUtil.getFormula(oldSheet, activePoint.y, activePoint.x + j);
                if (curFormula == null) continue;
                for (int k = 1; k <= newItemCount; ++k) {
                    String tempFormula = null;
                    tempFormula = newIsHorizon ? DynamicTemplateCoverUtil.getFormula(newSheet, newPoint.y + k, newPoint.x) : DynamicTemplateCoverUtil.getFormula(newSheet, newPoint.y, newPoint.x + k);
                    if (!curFormula.equals(tempFormula)) continue;
                    newParam.setFilled(true);
                    DynamicTemplateUtility.saveParametersToCell(newSheet.getRange(newPoint.y, newPoint.x), newParam);
                    return newPoint;
                }
            }
        }
        return null;
    }

    private static boolean compareBasePoints(DynaParameters oldParam, DynaParameters newParam) {
        if (newParam.getIsFilled()) {
            return false;
        }
        if (oldParam.getDynaItemSource() != newParam.getDynaItemSource()) {
            return false;
        }
        if (!(oldParam.getDynaItemSource() != 1 || oldParam.getAssistantType().getProperityName().equals(newParam.getAssistantType().getProperityName()) && oldParam.getAssistantTypeSubType().equals(newParam.getAssistantTypeSubType()))) {
            return false;
        }
        return oldParam.isGrade() == newParam.isGrade();
    }

    public static DynaParameters getParameters(Sheet sheet, Point basePoint) {
        return DynamicTemplateUtility.getDynaParametersFromCell(sheet, basePoint.y, basePoint.x);
    }

    public static boolean isHorizon(DynaParameters parameters) {
        return parameters.getSpreadStyle() == 1;
    }

    private static String getFormula(Sheet curSheet, int row, int col) {
        Range curCell = UserObjectHelper.getUnprotectedRange((Range)curSheet.getRange(row, col));
        if (curCell == null) {
            return null;
        }
        Object itemCellObj = curCell.getUserObject("ITEM");
        if (itemCellObj == null || !(itemCellObj instanceof ItemFormula)) {
            return null;
        }
        ItemFormula itemFormula = (ItemFormula)itemCellObj;
        return itemFormula.getFormula();
    }
}

