/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslBaseConditionUI;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.CompanyCfgUI;
import com.kingdee.eas.rptclient.gr.rptclient.CslReportDesigner;
import com.kingdee.eas.rptclient.gr.rptclient.ReportDefaultVariableProvider;
import com.kingdee.eas.rptclient.gr.rptclient.ReportEditUI;
import com.kingdee.eas.rptclient.gr.rptclient.ReportFilterUI;
import com.kingdee.eas.rptclient.gr.rptclient.ReportVO;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslListUI;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslReportDataProvider;
import com.kingdee.eas.rptclient.gr.rptclient.query.BaseQueryPanel;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.DynamicTemplateUtility;
import com.kingdee.eas.rptclient.gr.rptclient.util.ReportDAO;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.gr.rptclient.util.UPFFile;
import com.kingdee.eas.rptclient.newrpt.designer.check.ReportCheckHelper;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class ReportListUI
extends CslListUI {
    private ActionOutput actionOutput = null;
    private ActionFtpOutput actionFtpOutput = null;
    protected KDWorkButton btnOutput;
    protected KDMenuItem menuOutput;
    protected KDWorkButton btnFtpOutput;
    protected KDMenuItem menuFtpOutput;
    private ActionAudit actionAudit = null;
    protected KDWorkButton btnAudit;
    protected KDMenuItem menuAudit;
    private ActionUnAudit actionUnAudit = null;
    protected KDWorkButton btnUnAudit;
    protected KDMenuItem menuUnAudit;

    public ReportListUI() throws Exception {
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.actionOutput = new ActionOutput((IUIObject)this);
        this.getActionManager().registerAction("actionOutput", (ItemAction)this.actionOutput);
        this.actionFtpOutput = new ActionFtpOutput((IUIObject)this);
        this.getActionManager().registerAction("actionOutput", (ItemAction)this.actionFtpOutput);
        this.actionAudit = new ActionAudit((IUIObject)this);
        this.getActionManager().registerAction("actionAudit", (ItemAction)this.actionAudit);
        this.actionUnAudit = new ActionUnAudit((IUIObject)this);
        this.getActionManager().registerAction("actionUnAudit", (ItemAction)this.actionUnAudit);
        this.btnOutput = new KDWorkButton();
        this.btnOutput.setName("btnOutput");
        this.btnOutput.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionOutput), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnOutput.setText(this.resHelper.getString("ReportListUI.CommitReport"));
        this.btnOutput.setToolTipText(this.resHelper.getString("ReportListUI.CommitReport"));
        this.btnFtpOutput = new KDWorkButton();
        this.btnFtpOutput.setName("btnOutput");
        this.btnFtpOutput.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionFtpOutput), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnFtpOutput.setText(this.resHelper.getString("ReportListUI.CommitReport_FTP"));
        this.btnFtpOutput.setToolTipText(this.resHelper.getString("ReportListUI.CommitReport_FTP"));
        this.btnAudit = new KDWorkButton();
        this.btnAudit.setName("btnAudit");
        this.btnAudit.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionAudit), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnAudit.setText(this.resHelper.getString("ReportListUI.Audit"));
        this.btnAudit.setToolTipText(this.resHelper.getString("ReportListUI.Audit"));
        this.btnUnAudit = new KDWorkButton();
        this.btnUnAudit.setName("btnUnAudit");
        this.btnUnAudit.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionUnAudit), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnUnAudit.setText(this.resHelper.getString("ReportListUI.UnAudit"));
        this.btnUnAudit.setToolTipText(this.resHelper.getString("ReportListUI.UnAudit"));
        this.menuOutput = new KDMenuItem();
        this.menuOutput.setName("menuOutput");
        this.menuOutput.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionOutput), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.menuOutput.setText(this.resHelper.getString("ReportListUI.CommitReport") + "(O)");
        this.menuOutput.setToolTipText(this.resHelper.getString("ReportListUI.CommitReport") + "(O)");
        this.menuOutput.setMnemonic('O');
        this.menuFtpOutput = new KDMenuItem();
        this.menuFtpOutput.setName("menuFtpOutput");
        this.menuFtpOutput.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionFtpOutput), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.menuFtpOutput.setText(this.resHelper.getString("ReportListUI.CommitReport_FTP"));
        this.menuFtpOutput.setToolTipText(this.resHelper.getString("ReportListUI.CommitReport_FTP"));
        this.menuFtpOutput.setMnemonic('F');
        this.menuAudit = new KDMenuItem();
        this.menuAudit.setName("menuAudit");
        this.menuAudit.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionAudit), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.menuAudit.setText(this.resHelper.getString("ReportListUI.Audit") + "(A)");
        this.menuAudit.setToolTipText(this.resHelper.getString("ReportListUI.Audit") + "(A)");
        this.menuAudit.setMnemonic('A');
        this.menuUnAudit = new KDMenuItem();
        this.menuUnAudit.setName("menuUnAudit");
        this.menuUnAudit.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionUnAudit), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.menuUnAudit.setText(this.resHelper.getString("ReportListUI.UnAudit") + "(U)");
        this.menuUnAudit.setToolTipText(this.resHelper.getString("ReportListUI.UnAudit") + "(U)");
        this.menuUnAudit.setMnemonic('U');
        KDTableHeaderModel tableHeader = this.createHeader();
        KDTableUtil.setHeader((KDTableHeaderModel)tableHeader, (KDTable)this.tblMain);
        String[] keys = new String[]{"id", "reportName", "currencyId", "reportType", "year", "period", "isAudited", "cslReportType", "dynaType", "isCommitted", "auditor", "auditTime", "creator", "updateUser", "updateTime", "versionNumber", "companyId"};
        for (int i = 0; i < 17; ++i) {
            this.tblMain.getColumn(i).setKey(keys[i]);
        }
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        JToolBar.Separator s = new JToolBar.Separator();
        s.setOrientation(1);
        this.toolBar.add((Component)s);
        this.toolBar.add((Component)this.btnAudit);
        this.toolBar.add((Component)this.btnUnAudit);
        this.toolBar.add((Component)this.btnOutput);
        this.toolBar.add((Component)this.btnFtpOutput);
    }

    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuTool.add((JMenuItem)this.menuAudit);
        this.menuTool.add((JMenuItem)this.menuUnAudit);
        this.menuTool.add((JMenuItem)this.menuOutput);
        this.menuTool.add((JMenuItem)this.menuFtpOutput);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnFtpOutput.setIcon(EASResource.getIcon((String)"imgTbtn_inceptreport"));
        this.menuOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuFtpOutput.setIcon(EASResource.getIcon((String)"imgTbtn_inceptreport"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.menuUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
    }

    private KDTableHeaderModel createHeader() {
        int size = 17;
        String[][] hd = new String[1][size];
        int[] align = new int[size];
        int[] width = new int[size];
        String[] format = new String[size];
        hd[0][0] = "id";
        align[0] = 0;
        width[0] = 0;
        format[0] = "";
        this.setBinder("id", "r.FId");
        hd[0][1] = this.resHelper.getString("ReportListUI.reportName");
        align[1] = 0;
        width[1] = 100;
        format[1] = "";
        this.setBinder("reportName", "r.FName");
        hd[0][2] = this.resHelper.getString("ReportListUI.currencyId");
        align[2] = 0;
        width[2] = 80;
        format[2] = "";
        this.setBinder("currencyId", "c.FName");
        hd[0][3] = EASResource.getString((String)"com.kingdee.eas.rptclient.gr.rptclient.PeriodTypeResource", (String)"periodType");
        align[3] = 0;
        width[3] = 80;
        format[3] = "";
        this.setBinder("reportType", "r.FPeriodType");
        hd[0][4] = this.resHelper.getString("ReportListUI.year");
        align[4] = 0;
        width[4] = 80;
        format[4] = "";
        this.setBinder("year", "r.FYear");
        hd[0][5] = this.resHelper.getString("ReportListUI.period");
        align[5] = 0;
        width[5] = 80;
        format[5] = "";
        this.setBinder("period", "r.FPeriod");
        hd[0][6] = this.resHelper.getString("ReportListUI.isAudited");
        align[6] = 0;
        width[6] = 80;
        format[6] = "";
        this.setBinder("isAudited", "r.FAuditedStatus");
        hd[0][7] = this.resHelper.getString("ReportListUI.periodType");
        align[7] = 0;
        width[7] = 100;
        format[7] = "";
        this.setBinder("cslReportType", "r.FSourceType");
        hd[0][8] = this.resHelper.getString("TemplateListUI.dynaType");
        align[8] = 0;
        width[8] = 100;
        format[8] = "";
        this.setBinder("dynaType", "r.FDynaRptType");
        hd[0][9] = this.resHelper.getString("ReportListUI.isCommitted");
        align[9] = 0;
        width[9] = 80;
        format[9] = "";
        this.setBinder("isCommitted", "r.FCheckedStatus");
        hd[0][10] = this.resHelper.getString("ReportListUI.auditor");
        align[10] = 0;
        width[10] = 100;
        format[10] = "";
        this.setBinder("auditor", "r.FAuditorID");
        hd[0][11] = this.resHelper.getString("ReportListUI.auditTime");
        align[11] = 0;
        width[11] = 100;
        format[11] = "%{yyyy-MM-dd}t";
        this.setBinder("auditTime", "r.FAuditedTime");
        hd[0][12] = this.resHelper.getString("ReportListUI.creator");
        align[12] = 0;
        width[12] = 100;
        format[12] = "";
        this.setBinder("creator", "r.FCreatorID");
        hd[0][13] = this.resHelper.getString("ReportListUI.updateUser");
        align[13] = 0;
        width[13] = 100;
        format[13] = "";
        this.setBinder("updateUser", "r.FLastUpdateUserID");
        hd[0][14] = this.resHelper.getString("ReportListUI.udpateTime");
        align[14] = 0;
        width[14] = 100;
        format[14] = "%{yyyy-MM-dd}t";
        this.setBinder("updateTime", "r.FLastUpdateTime");
        hd[0][15] = this.resHelper.getString("ReportListUI.versionNumber");
        align[15] = 0;
        width[15] = 100;
        format[15] = "";
        this.setBinder("versionNumber", "r.FVersionNumber");
        hd[0][16] = this.resHelper.getString("ReportListUI.companyId");
        align[16] = 0;
        width[16] = 100;
        format[16] = "";
        KDTableHeaderModel mm = new KDTableHeaderModel();
        mm.setHiddenColumnIndexices(new int[]{0});
        mm.setData(hd);
        mm.setAlignColumns(align);
        mm.setColumnsFormat(format);
        mm.setColumnWidths(width);
        return mm;
    }

    public void query(Object condition) {
        super.doLayout();
        this.tblMain.removeRows();
    }

    protected boolean objectExists(String id) throws BOSException {
        String sql = "select fid from t_eas_report where fid = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id});
        return rowSet.size() == 1;
    }

    public void showEditUI(String key, String status) throws Exception {
        int state;
        String sql;
        IRowSet rowSet;
        if (status.equals("EDIT") && (rowSet = DbUtil.executeQuery(sql = "select FId, FAuditedStatus from t_eas_report where FId = ?", new Object[]{key})).next() && (state = rowSet.getInt("FAuditedStatus")) == 2) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("AuditedReportCanEdit")));
        }
        CslReportDesigner designer = new CslReportDesigner(key, (CoreUIObject)this);
        designer.setOperState(status);
        ReportVO vo = ReportDAO.getReportVO(key);
        if (vo != null) {
            CslReportDataProvider dataProvider = new CslReportDataProvider(vo);
            designer.setVarialbeProvider(new ReportDefaultVariableProvider(dataProvider));
            designer.setDataProvider(dataProvider);
        }
        designer.initApplication();
        designer.setExtendedState(6);
        designer.setVisible(true);
        designer.requestFocus();
    }

    protected void runRemove(String id) throws Exception {
        int status;
        String sql = "select FId, FAuditedStatus from t_eas_report where FId = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id});
        if (rowSet.next() && (status = rowSet.getInt("FAuditedStatus")) == 2) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("Report_Has_Audited")));
        }
        sql = "delete T_Eas_Report where FId = ?";
        DbUtil.execute(sql, new Object[]{id});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableDataRequest(KDTDataRequestEvent e) {
        String order;
        ResourceBundleHelper res = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.ExportResource");
        StringBuffer sql = new StringBuffer();
        sql.append("select r.FId, r.FName, c.FName, ");
        sql.append("case r.FPeriodType when 1 then '").append(RptPeriodTypeEnum.DAILY.getAlias());
        sql.append("' when 2 then '").append(RptPeriodTypeEnum.WEEKLY.getAlias());
        sql.append("' when 3 then '").append(RptPeriodTypeEnum.MONTHLY.getAlias());
        sql.append("' when 4 then '").append(RptPeriodTypeEnum.QUARTERLY.getAlias());
        sql.append("' when 5 then '").append(RptPeriodTypeEnum.SEMIYEARLY.getAlias());
        sql.append("' when 6 then '").append(RptPeriodTypeEnum.YEARLY.getAlias());
        sql.append("' end as FPeriodType, r.FYear, r.FPeriod, ");
        sql.append(" case r.FAuditedStatus when 1 then '");
        sql.append(AuditedStatusEnum.UNAUDITED.getAlias());
        sql.append("' when 2 then '").append(AuditedStatusEnum.AUDITED.getAlias());
        sql.append("' end as FAuditedStatus, ");
        sql.append(" case r.FSourceType when 1 then '").append(RptSrcTypeEnum.NORMAL.getAlias()).append("'");
        sql.append(" when 10 then '").append(RptSrcTypeEnum.DYNAMICNORMALREPORT.getAlias()).append("'");
        sql.append(" end as cslReportType ,");
        sql.append(" case r.FDynaRpttype when 1 then '").append(DynaEnumRptTypeEnum.FIXED.getAlias()).append("'");
        sql.append(" when 2 then '").append(DynaEnumRptTypeEnum.DYNAMIC.getAlias()).append("'");
        sql.append(" end as dynaType,");
        sql.append("  case r.FCheckedStatus when 1 then '");
        sql.append(res.getString("UNCOMMITTED"));
        sql.append("' when 2 then '").append(res.getString("COMMITTED"));
        sql.append("' when 3 then '").append(res.getString("GROUPCOMMITTED"));
        sql.append("' end as FCheckedStatus, r.FAuditorID, ");
        sql.append("r.FAuditedTime, r.FCreatorID, r.FLastUpdateUserID, r.FLastUpdateTime, ");
        sql.append("r.FVersionNumber, '");
        sql.append(UIConfig.getCurCompanyName()).append("' as FCompanyId ");
        sql.append(" from t_eas_report r ");
        sql.append(" inner join t_eas_currency c on r.FCurrencyId = c.FId");
        sql.append(" inner join t_eas_Template t3 on r.FTemplateID = t3.FId");
        sql.append(" where 1=1");
        if (this.queryPanel != null) {
            Map conditions = this.queryPanel.getConditions();
            if (conditions.containsKey("periodType")) {
                RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)conditions.get("periodType");
                sql.append(" and r.FPeriodType = ").append(periodType.getValue());
            }
            if (conditions.containsKey("sourceType")) {
                RptSrcTypeEnum sourceType = (RptSrcTypeEnum)conditions.get("sourceType");
                sql.append(" and r.FSourceType = ").append(sourceType.getValue());
            }
            if (conditions.containsKey("currency")) {
                CurrencyInfo currency = (CurrencyInfo)conditions.get("currency");
                sql.append(" and r.FCurrencyId = '").append(currency.getId()).append("'");
            }
            if (conditions.containsKey("template")) {
                TemplateInfo template = (TemplateInfo)conditions.get("template");
                sql.append(" and r.FTemplateNumber = '").append(template.getNumber()).append("'");
            }
            boolean isContainHis = false;
            if (conditions.containsKey("isIncludeRptByHisTmp")) {
                isContainHis = (Boolean)conditions.get("isIncludeRptByHisTmp");
            }
            if (!isContainHis) {
                sql.append(" and t3.FVersionStatus=1");
            }
        } else {
            sql.append(" and t3.FVersionStatus=1");
        }
        if (this.isCanOrderTable() && !StringUtils.isEmpty((String)(order = this.getOrderSql()))) {
            sql.append(" order by ").append(order);
        }
        try {
            RptRowSet rst;
            this.setCursorOfWair();
            int from = e.getFirstRow();
            int length = e.getLastRow() - e.getFirstRow() + 1;
            try {
                rst = DbUtil.executeQuery(sql.toString(), from, length);
            }
            catch (SQLException ex) {
                throw new SQLDataException(ex);
            }
            if (from == 0) {
                this.tblMain.setRowCount(rst.getVirtualRowCount());
            }
            KDTableUtil.insertRows((Object[][])rst.toArray(), null, (int)from, (KDTable)this.tblMain);
            if (rst.getRowCount() > 0) {
                int countRowIndex = from + rst.getRowCount() - 1;
                rst.moveTo(rst.getRowCount() - 1);
            }
        }
        catch (BOSException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    public void actionOutput_actionPerformed(ActionEvent e) throws Exception {
        String[] values = CompanyCfgUI.getCompany();
        if (values[0] == null || values[0].trim().length() == 0) {
            MsgBox.showInfo((String)this.resHelper.getString("setCurrencyCompany"));
            return;
        }
        UPFFile.exportReport((Object)this);
    }

    public void actionFtpOutput_actionPerformed(ActionEvent e) throws Exception {
        String[] values = CompanyCfgUI.getCompany();
        if (values[0] == null || values[0].trim().length() == 0) {
            MsgBox.showInfo((String)this.resHelper.getString("setCurrencyCompany"));
            return;
        }
        String ip = UIConfig.getFTPIP();
        if (StringUtils.isEmpty((String)ip)) {
            MsgBox.showInfo((String)this.resHelper.getString("SettingIPFirst"));
            return;
        }
        UPFFile.exportReportToFtp((Object)this);
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            int auditedStatus;
            String id = (String)ids.get(i);
            ReportVO reportVO = ReportDAO.getReportVO(id);
            if (reportVO == null || (auditedStatus = reportVO.getAuditedStatus()) == 2) continue;
            byte[] data = reportVO.getData();
            Book book = IOHelper.unpackBook((byte[])data);
            if (!DynamicTemplateUtility.checkItem(book)) {
                msg.append("\n").append(reportVO.getName()).append("  ");
                msg.append(reportVO.getYear()).append(this.resHelper.getString("ReportEditUI.lblYear"));
                msg.append(reportVO.getPeriod()).append(this.resHelper.getString("ReportEditUI.lblPeriod"));
                msg.append("\n").append(this.resHelper.getString("ItemFormulaDup")).append("\n");
                continue;
            }
            String string = ReportCheckHelper.checkReport(book, new CslReportDataProvider(reportVO));
            if (string != null) {
                msg.append("\n").append(reportVO.getName()).append("  ");
                msg.append(reportVO.getYear()).append(this.resHelper.getString("ReportEditUI.lblYear"));
                msg.append(reportVO.getPeriod()).append(this.resHelper.getString("ReportEditUI.lblPeriod"));
                msg.append("\n").append(this.resHelper.getString("CheckReport_fail")).append("\n");
                continue;
            }
            StringBuffer oql = new StringBuffer();
            oql.append("update t_eas_report set FAuditedStatus = 2, ");
            oql.append("FAuditorID = '").append(UIConfig.getUserName());
            oql.append("', FAuditedTime = ");
            oql.append(CslRptUtil.formatDateForSql((Date)new Date()));
            oql.append(" where fid = ?");
            DbUtil.execute(oql.toString(), new Object[]{id});
        }
        if (msg.length() > 0) {
            AdvMsgBox box = AdvMsgBox.createAdvMsgBox((Component)((Object)this), (String)this.resHelper.getString("ReportAudit_fail"), (String)this.resHelper.getString("ReportAudit_fail"), (String)msg.toString(), (int)1, (int)8188);
            box.show();
        } else {
            MsgBox.showInfo((String)this.resHelper.getString("HasAudited"));
        }
        this.refresh(null);
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        String sql = "select FId, FData, FAuditorId, FAuditedTime, FAuditedStatus, FCheckedStatus, FName, FYear, FPeriod from t_eas_report where fid = ?";
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            int auditedStatus;
            String id = (String)ids.get(i);
            IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id});
            if (!rowSet.next() || (auditedStatus = rowSet.getInt("FAuditedStatus")) == 1) continue;
            StringBuffer oql = new StringBuffer();
            oql.append("update t_eas_report set FAuditedStatus = 1, ");
            oql.append("FAuditorID = '', FAuditedTime = null");
            oql.append(" where fid = ?");
            DbUtil.execute(oql.toString(), new Object[]{id});
        }
        if (msg.length() > 0) {
            AdvMsgBox box = AdvMsgBox.createAdvMsgBox((Component)((Object)this), (String)this.resHelper.getString("ReportUnAudit_fail"), (String)this.resHelper.getString("ReportUnAudit_fail"), (String)msg.toString(), (int)1, (int)8188);
            box.show();
        } else {
            MsgBox.showInfo((String)this.resHelper.getString("HasUnAudited"));
        }
        this.refresh(null);
    }

    protected String getEditUIName() {
        return ReportEditUI.class.getName();
    }

    public CslBaseConditionUI getQueryDialogUserPanel() {
        return null;
    }

    protected String[] getNotOrderColumns() {
        String[] cols = new String[]{"companyId"};
        return cols;
    }

    public BaseQueryPanel getQueryPanel() {
        if (this.queryPanel == null) {
            UIContext uiContext = new UIContext((Object)this);
            IUIFactory factory = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory");
            try {
                this.queryPanel = (BaseQueryPanel)factory.create((Component)((Object)this), ReportFilterUI.class.getName(), (Map)uiContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.queryPanel;
    }

    protected class ActionUnAudit
    extends ItemAction {
        public ActionUnAudit() {
            this(null);
        }

        public ActionUnAudit(IUIObject uiObject) {
            super(uiObject);
            String _tempStr = ReportListUI.this.resHelper.getString("ReportListUI.UnAudit");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift F11"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            ReportListUI.this.getUIContext().put("ORG.PK", ReportListUI.this.getOrgPK(this));
            this.innerActionPerformed("eas", (CoreUIObject)ReportListUI.this, "ActionUnAudit", "actionUnAudit_actionPerformed", e);
        }
    }

    protected class ActionAudit
    extends ItemAction {
        public ActionAudit() {
            this(null);
        }

        public ActionAudit(IUIObject uiObject) {
            super(uiObject);
            String _tempStr = ReportListUI.this.resHelper.getString("ReportListUI.Audit");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift F10"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            ReportListUI.this.getUIContext().put("ORG.PK", ReportListUI.this.getOrgPK(this));
            this.innerActionPerformed("eas", (CoreUIObject)ReportListUI.this, "ActionAudit", "actionAudit_actionPerformed", e);
        }
    }

    protected class ActionFtpOutput
    extends ItemAction {
        public ActionFtpOutput() {
            this(null);
        }

        public ActionFtpOutput(IUIObject uiObject) {
            super(uiObject);
            String _tempStr = ReportListUI.this.resHelper.getString("ReportListUI.CommitReport_FTP");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift O"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            ReportListUI.this.getUIContext().put("ORG.PK", ReportListUI.this.getOrgPK(this));
            this.innerActionPerformed("eas", (CoreUIObject)ReportListUI.this, "ActionFtpOutput", "actionFtpOutput_actionPerformed", e);
        }
    }

    protected class ActionOutput
    extends ItemAction {
        public ActionOutput() {
            this(null);
        }

        public ActionOutput(IUIObject uiObject) {
            super(uiObject);
            String _tempStr = ReportListUI.this.resHelper.getString("ReportListUI.CommitReport");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl O"));
            this.putValue("ShortDescription", _tempStr);
            this.putValue("LongDescription", _tempStr);
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            ReportListUI.this.getUIContext().put("ORG.PK", ReportListUI.this.getOrgPK(this));
            this.innerActionPerformed("eas", (CoreUIObject)ReportListUI.this, "ActionOutput", "actionOutput_actionPerformed", e);
        }
    }
}

