/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.rptclient.gr.rptclient.query.CommonQueryPanel;
import com.kingdee.eas.rptclient.gr.rptclient.query.CommonQueryUI;
import com.kingdee.eas.rptclient.gr.rptclient.query.IQueryInfoPanel;
import com.kingdee.eas.rptclient.gr.rptclient.query.QuerySolutionVO;
import com.kingdee.eas.rptclient.gr.rptclient.query.SolutionPromptUI;
import com.kingdee.eas.rptclient.gr.rptclient.query.Util;
import com.kingdee.eas.rptclient.gr.rptclient.util.QuerySolutionDAO;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QueryToolBar
extends KDPanel {
    private KDWorkButton newButton;
    private KDWorkButton saveButton;
    private KDWorkButton saveAsButton;
    private KDWorkButton delButton;
    private static final String commonQueryRes = CommonQueryPanel.class.getName();
    private String currentSolutionName;
    private QuerySolutionVO currentQuerySolution;
    private QuerySolutionVO querySolutionTemp;
    private static final String toolBarRes = QueryToolBar.class.getName();

    protected void disEditButton() {
        this.saveButton.setEnabled(false);
        this.delButton.setEnabled(false);
    }

    protected void enEditButton() {
        this.saveButton.setEnabled(true);
        this.delButton.setEnabled(true);
    }

    public QueryToolBar() {
        this.initUI();
        this.initOther();
    }

    private void initUI() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(180, 20));
        this.newButton = new KDWorkButton();
        this.newButton.setSize(22, 19);
        this.saveButton = new KDWorkButton();
        this.saveButton.setSize(22, 19);
        this.saveAsButton = new KDWorkButton();
        this.saveAsButton.setSize(22, 19);
        this.delButton = new KDWorkButton();
        this.delButton.setSize(22, 19);
        this.newButton.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.newButton.setToolTipText(EASResource.getString((String)toolBarRes, (String)"new"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryToolBar.this.newButton_actionPerformed(e);
            }
        });
        this.saveButton.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.saveButton.setToolTipText(EASResource.getString((String)toolBarRes, (String)"save"));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryToolBar.this.saveButton_actionPerformed(e);
            }
        });
        this.saveAsButton.setIcon(EASResource.getIcon((String)"imgTbtn_saveas"));
        this.saveAsButton.setToolTipText(EASResource.getString((String)toolBarRes, (String)"saveAs"));
        this.saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryToolBar.this.saveAsButton_actionPerformed(e);
            }
        });
        this.delButton.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.delButton.setToolTipText(EASResource.getString((String)toolBarRes, (String)"del"));
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QueryToolBar.this.delButton_actionPerformed(e);
            }
        });
        this.add((Component)this.newButton);
        this.newButton.setBounds(0, 0, 22, 19);
        this.add((Component)this.saveButton);
        this.saveButton.setBounds(25, 0, 22, 19);
        this.add((Component)this.saveAsButton);
        this.saveAsButton.setBounds(50, 0, 22, 19);
        this.add((Component)this.delButton);
        this.delButton.setBounds(75, 0, 22, 19);
    }

    private void initOther() {
        this.currentSolutionName = null;
    }

    private void newButton_actionPerformed(ActionEvent e) {
        this.resetToolBar();
        this.resetUserPanels();
        this.setCurrentSolution(null);
    }

    protected void newDefaultSolution() {
        this.resetToolBar();
        this.resetUserPanels();
        this.setCurrentSolution(null);
    }

    private void resetToolBar() {
    }

    private void resetUserPanels() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        Collection panels = commonQueryPanel.getPanels().values();
        Iterator itePanel = panels.iterator();
        while (itePanel.hasNext()) {
            KDPanel tempPanel = (KDPanel)itePanel.next();
            if (!(tempPanel instanceof IQueryInfoPanel)) continue;
            ((IQueryInfoPanel)tempPanel).clear();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveButton_actionPerformed(ActionEvent e) {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        String parentUI = commonQueryPanel.getParentUIClassName();
        if (!commonQueryPanel.verify()) return;
        if (this.currentQuerySolution == null) {
            if (!this.showSolutionDialog()) return;
            String sameNameSolutionID = null;
            try {
                sameNameSolutionID = QuerySolutionDAO.getSameNameSolutionID(this.currentSolutionName, parentUI);
            }
            catch (BOSException e1) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
            if (sameNameSolutionID != null) {
                int flag = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"solutionNameExist"));
                if (flag != 0) return;
                if (!this.editSolution(sameNameSolutionID)) return;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"overwriteSolutionSucceed"));
                commonQueryPanel.getSolutionListPanel().refreshSolutionList();
                commonQueryPanel.getSolutionListPanel().setSelected(this.currentQuerySolution);
                return;
            }
            if (!this.addSolution()) return;
            MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"saveSolutionSucceed"));
            commonQueryPanel.getSolutionListPanel().refreshSolutionList();
            commonQueryPanel.getSolutionListPanel().setSelected(this.currentQuerySolution);
            return;
        }
        if (!this.editSolution(this.currentQuerySolution.getId())) return;
        MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"saveSolutionSucceed"));
        commonQueryPanel.getSolutionListPanel().refreshSolutionList();
        commonQueryPanel.getSolutionListPanel().setSelected(this.currentQuerySolution);
    }

    private void saveAsButton_actionPerformed(ActionEvent e) {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        String parentUI = commonQueryPanel.getParentUIClassName();
        if (commonQueryPanel.verify() && this.showSolutionDialog()) {
            String sameNameSolutionID = null;
            String sameNameSolutionName = null;
            QuerySolutionVO asdf = null;
            try {
                asdf = QuerySolutionDAO.getSameNameSolution(this.currentSolutionName, parentUI);
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
            if (asdf != null) {
                sameNameSolutionID = asdf.getId();
                sameNameSolutionName = asdf.getName();
            }
            if (sameNameSolutionID != null && sameNameSolutionName != null) {
                int flag;
                if (asdf.getSolutionType().equals((Object)SolutionTypeEnum.SYSTEM_SOLUTION)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)commonQueryRes, (String)"CanNotOverDefaultSolution"));
                    SysUtil.abort();
                }
                if ((flag = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"solutionNameExist"))) == 0 && this.editSolution(sameNameSolutionID)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"overwriteSolutionSucceed"));
                    commonQueryPanel.getSolutionListPanel().refreshSolutionList();
                    commonQueryPanel.getSolutionListPanel().setSelected(this.currentQuerySolution);
                    return;
                }
            } else {
                if (this.addSolution()) {
                    MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"saveAsSolutionSucceed"));
                    commonQueryPanel.getSolutionListPanel().refreshSolutionList();
                    commonQueryPanel.getSolutionListPanel().setSelected(this.currentQuerySolution);
                    this.getCommonQueryPanel().cbDefaultView.setSelected(false);
                    return;
                }
                commonQueryPanel.getSolutionListPanel().refreshSolutionList();
                return;
            }
        }
    }

    private void delButton_actionPerformed(ActionEvent e) {
        QuerySolutionVO vo = (QuerySolutionVO)this.getCommonQueryPanel().getSolutionListPanel().getSolutionList().getSelectedValue();
        if (vo == null) {
            MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"chooseSolutionWarning"));
        } else {
            int flag = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"delWarning"));
            if (flag == 0) {
                CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
                if (this.delSolution(vo.getId())) {
                    MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"delSolutionSucceed"));
                    commonQueryPanel.getSolutionListPanel().refreshSolutionList();
                } else {
                    MsgBox.showWarning((String)EASResource.getString((String)toolBarRes, (String)"delSolutionWarning"));
                    commonQueryPanel.getSolutionListPanel().refreshSolutionList();
                    commonQueryPanel.getSolutionListPanel().setSelected(vo);
                }
            }
        }
    }

    protected List getQuerySolutions() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        String parentUI = commonQueryPanel.getParentUIClassName();
        try {
            return QuerySolutionDAO.getQuerySolutionByType(parentUI);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return new ArrayList();
        }
    }

    protected QuerySolutionVO getDefaultSolution() {
        List querySolutions = this.getQuerySolutions();
        QuerySolutionVO querySolutionInfo = null;
        try {
            if (!querySolutions.isEmpty()) {
                for (int i = 0; i < querySolutions.size(); ++i) {
                    QuerySolutionVO vo = (QuerySolutionVO)querySolutions.get(i);
                    if (!vo.getSolutionType().equals((Object)SolutionTypeEnum.SYSTEM_SOLUTION)) continue;
                    querySolutionInfo = vo;
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return querySolutionInfo;
    }

    protected boolean addSolution() {
        try {
            CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
            QuerySolutionVO vo = this.querySolutionTemp;
            String parentUIName = commonQueryPanel.getParentUIClassName();
            vo.setEntityView(commonQueryPanel.getEntityViewInfo().toString());
            vo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
            vo.setParentUIName(parentUIName);
            vo.setName(this.currentSolutionName);
            QuerySolutionDAO.addNew(vo);
            this.setCurrentSolution(vo);
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionFail"), (Throwable)e);
            return false;
        }
    }

    protected boolean editSolution(String solutionID) {
        try {
            CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
            QuerySolutionVO vo = QuerySolutionDAO.getQuerySolutionVO(solutionID);
            vo.setEntityView(commonQueryPanel.getEntityViewInfo().toString());
            vo.setName(this.currentSolutionName);
            QuerySolutionDAO.store(vo);
            this.setCurrentSolution(vo);
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)toolBarRes, (String)"saveSolutionFail"), (Throwable)e);
            return false;
        }
    }

    private boolean delSolution(String solutionID) {
        try {
            QuerySolutionDAO.delete(solutionID);
            this.setCurrentSolution(null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private CommonQueryPanel getCommonQueryPanel() {
        return (CommonQueryPanel)((Object)Util.getComponent((Component)((Object)this), CommonQueryPanel.class.getName()));
    }

    protected CommonQueryUI getCommonQueryUI() {
        return (CommonQueryUI)((Object)Util.getComponent((Component)((Object)this), CommonQueryUI.class.getName()));
    }

    protected QuerySolutionVO getCurrentQuerySolutionVO() {
        return this.currentQuerySolution;
    }

    protected void setCurrentSolution(QuerySolutionVO info) {
        this.currentQuerySolution = info;
    }

    protected void setSolutionName(String solutionName) {
        this.currentSolutionName = solutionName;
    }

    private boolean showSolutionDialog() {
        boolean isConfirm = false;
        UIContext uiContext = new UIContext((Object)this.getCommonQueryPanel().getParentUI());
        uiContext.put((Object)"TOOLBAR", (Object)this);
        IUIWindow window = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)UIFactoryName.MODEL);
            window = uiFactory.create(SolutionPromptUI.class.getName(), (Map)uiContext, null, "");
            window.show();
            isConfirm = 0 == ((SolutionPromptUI)window.getUIObject()).getCloseWindowType();
            return isConfirm;
        }
        catch (UIException e) {
            return isConfirm;
        }
    }

    public void setQuerySolution(QuerySolutionVO qsi) {
        this.querySolutionTemp = qsi;
    }
}

