/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.query;

import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.rptclient.gr.rptclient.query.CommonQueryPanel;
import com.kingdee.eas.rptclient.gr.rptclient.query.IQueryInfoPanel;
import com.kingdee.eas.rptclient.gr.rptclient.query.QuerySolutionVO;
import com.kingdee.eas.rptclient.gr.rptclient.query.Util;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListModel;

public class SolutionListPanel
extends KDPanel {
    private KDList solutionList;

    public SolutionListPanel() {
        this.init();
    }

    private void init() {
        KDScrollPane pane = new KDScrollPane();
        this.solutionList = new KDList();
        pane.getViewport().add((Component)this.solutionList, null);
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
        this.solutionList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                try {
                    SolutionListPanel.this.solutionListClicked(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void solutionListClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            QuerySolutionVO vo = (QuerySolutionVO)this.solutionList.getSelectedValue();
            if (vo != null) {
                if (vo.getSolutionType().equals((Object)SolutionTypeEnum.SYSTEM_SOLUTION)) {
                    this.resetToolBar();
                    this.resetUserPanels();
                    this.getCommonQueryPanel().getDefaultToolBar().disEditButton();
                } else {
                    this.getCommonQueryPanel().getDefaultToolBar().enEditButton();
                }
            }
            this.loadSolution(e);
        }
    }

    private void resetToolBar() {
    }

    private void resetUserPanels() {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        Collection panels = commonQueryPanel.getPanels().values();
        Iterator itePanel = panels.iterator();
        while (itePanel.hasNext()) {
            KDPanel tempPanel = (KDPanel)itePanel.next();
            if (!(tempPanel instanceof IQueryInfoPanel)) continue;
            ((IQueryInfoPanel)tempPanel).clear();
        }
    }

    private void loadSolution(MouseEvent e) throws Exception {
        CommonQueryPanel commonQueryPanel = this.getCommonQueryPanel();
        QuerySolutionVO querySolutionVO = (QuerySolutionVO)this.solutionList.getSelectedValue();
        if (querySolutionVO != null) {
            if (commonQueryPanel.getPanels().size() > 0) {
                commonQueryPanel.setUserPanelDisplay(querySolutionVO);
            }
            commonQueryPanel.getDefaultToolBar().setCurrentSolution(querySolutionVO);
            commonQueryPanel.getDefaultToolBar().setSolutionName(querySolutionVO.getName());
            if (querySolutionVO.getIsUserDefaultSolu()) {
                this.getCommonQueryPanel().cbDefaultView.setSelected(true);
            } else {
                this.getCommonQueryPanel().cbDefaultView.setSelected(false);
            }
        }
    }

    protected void setSelected(QuerySolutionVO vo) {
        if (vo != null) {
            ListModel model = this.solutionList.getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                QuerySolutionVO solution = (QuerySolutionVO)model.getElementAt(i);
                if (!solution.getId().equals(vo.getId())) continue;
                this.solutionList.setSelectedIndex(i);
            }
        }
    }

    protected void refreshSolutionList() {
        this.solutionList.removeAllElements();
        Icon icon = EASResource.getIcon((String)"imgTree_public");
        int i = 0;
        List querySolutions = this.getCommonQueryPanel().getDefaultToolBar().getQuerySolutions();
        QuerySolutionVO defaultSolution = this.getCommonQueryPanel().getDefaultToolBar().getDefaultSolution();
        int size = querySolutions.size();
        if (defaultSolution != null) {
            querySolutions.remove(defaultSolution);
            this.solutionList.addElement((Object)defaultSolution);
            this.solutionList.setElementIcon(icon, 0);
            i = 1;
            --size;
        }
        int j = i;
        for (int k = 0; k < size; ++k) {
            this.solutionList.addElement(querySolutions.get(k));
            this.solutionList.setElementIcon(icon, j);
            ++j;
        }
    }

    protected void refreshSolutionList(List querySolutionCollection) {
        this.solutionList.removeAllElements();
        Icon icon = EASResource.getIcon((String)"imgTree_public");
        Iterator it = querySolutionCollection.iterator();
        QuerySolutionVO vo = null;
        int j = 0;
        while (it.hasNext()) {
            vo = (QuerySolutionVO)it.next();
            if (vo.getSolutionType().equals((Object)SolutionTypeEnum.SYSTEM_SOLUTION)) {
                this.solutionList.insertElement((Object)vo, 0);
                this.solutionList.setElementIcon(icon, 0);
            } else {
                this.solutionList.addElement((Object)vo);
                this.solutionList.setElementIcon(icon, j);
            }
            ++j;
        }
    }

    private CommonQueryPanel getCommonQueryPanel() {
        return (CommonQueryPanel)((Object)Util.getComponent((Component)((Object)this), CommonQueryPanel.class.getName()));
    }

    protected KDList getSolutionList() {
        return this.solutionList;
    }
}

