/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.batch;

import java.io.InputStream;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class FormulaCalcInstaller
extends DefaultHandler {
    private static FormulaCalcInstaller instaler = null;
    private static HashMap map = new HashMap();

    private void load() throws Exception {
        XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        reader.setContentHandler(this);
        reader.setErrorHandler(this);
        InputStream in = this.getClass().getResource("FormulaCalculatorProvider.properties").openStream();
        reader.parse(new InputSource(in));
    }

    private FormulaCalcInstaller() throws Exception {
        this.load();
    }

    private void installFormulaCalculator(String[] formula) {
        map.put(formula[0].trim().toUpperCase(), formula);
    }

    public HashMap install() {
        return map;
    }

    public void startElement(String namespaceURI, String localName, String fullName, Attributes attributes) throws SAXException {
        if (fullName.trim().toLowerCase().equals("calculator")) {
            String[] calcConfig = new String[3];
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getLocalName(i).toLowerCase().trim().equals("fouction_name")) {
                    calcConfig[0] = attributes.getValue(i);
                    continue;
                }
                if (attributes.getLocalName(i).toLowerCase().trim().equals("provider")) {
                    calcConfig[1] = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getLocalName(i).toLowerCase().trim().equals("batch_listener")) continue;
                calcConfig[2] = attributes.getValue(i);
            }
            this.installFormulaCalculator(calcConfig);
        }
    }

    public static FormulaCalcInstaller getInstance() throws Exception {
        if (instaler == null) {
            instaler = new FormulaCalcInstaller();
        }
        return instaler;
    }
}

