/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.check;

import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.check.ReportCheck;
import com.kingdee.eas.rptclient.newrpt.client.designer.IDataProvider;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.functionimpl.CalculateContext;
import com.kingdee.eas.rptclient.newrpt.functionimpl.FunctionProviderImpl;
import com.kingdee.eas.rptclient.newrpt.functionimpl.ICalculateContext;
import java.util.Locale;

public class ReportCheckHelper {
    public static String checkReport(Book book, IDataProvider data) throws Exception {
        return ReportCheckHelper.checkReport(book, data, Locale.getDefault());
    }

    public static String checkReport(Book book, IDataProvider data, Locale locale) throws Exception {
        return ReportCheckHelper.checkReport(book, data, null, locale);
    }

    public static String checkReport(final Book book, IDataProvider data, RptCheckExpTank expTank, Locale locale) throws Exception {
        BookProperties bookProperties = BookProperties.loadFromSpread(book);
        ReportCalculateErrorProvider ee = bookProperties.getErrorProvider();
        CalculateContext.getInstance().setErrorProvider((IErrorProvider)ee);
        FunctionProviderImpl functionProviderImpl = new FunctionProviderImpl();
        book.getDeps().getFunctionManager().addFunctionProvider((Object)functionProviderImpl, true);
        functionProviderImpl.setContext(new ICalculateContext(){

            public Book getBook() {
                return book;
            }
        });
        book.getDeps().getFunctionManager().setErrorProvider(Exception.class, (IErrorProvider)ee);
        book.setUserObject("CTX", (Object)data);
        bookProperties.restoreToSpread(book);
        if (expTank == null) {
            expTank = bookProperties.getOperationSchema().getExpTank();
        }
        ReportCheck ck = new ReportCheck(book, expTank, locale);
        String string = ck.check();
        return string;
    }
}

