/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.util;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.rptclient.newrpt.util.SheetHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SpreadHelper {
    public static Sheet copySheet(Sheet res) throws Exception {
        Book book = Book.Manager.getNewBook(null, (int)1);
        book.setCalculate(false);
        Sheet sheet = book.getSheet(0);
        sheet.copySheetFrom(res);
        sheet.setName(res.getSheetName());
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            cell.setUserObject("ITEM", null);
        }
        return sheet;
    }

    public static KDSpread copySpread(KDSpread spread) throws Exception {
        Book result = Book.Manager.getNewBook(null, (int)0);
        int sheetCount = spread.getBook().getSheetCount();
        result.setCalculate(false);
        for (int i = 0; i < sheetCount; ++i) {
            Sheet res = spread.getBook().getSheet(i);
            Sheet copy = new Sheet(result, res.getSheetName());
            Sheet.ICellsIterator it = res.getCellsIterator(null, false, true);
            while (it.hasNext()) {
                Cell cell = it.next();
                copy.getCell(cell.getRow(), cell.getCol(), true).setValue(cell.getValue());
            }
            result.addSheet(copy);
        }
        return new KDSpread(result);
    }

    public static Sheet sumSpreadSheet(KDSpread spread, List sheetNames, String templateSheetName) throws Exception {
        if (sheetNames == null || sheetNames.size() < 1) {
            return null;
        }
        Sheet sheet = spread.getBook().getSheet(templateSheetName);
        sheetNames.remove(templateSheetName);
        if (sheet == null) {
            throw new Exception("Choose one sheet at least");
        }
        Sheet template = SpreadHelper.copySheet(sheet);
        String appropriateSheetName = SpreadHelper.getAppropriateSheetName("Sum", SpreadHelper.getAllSheetsName(spread));
        template.setName(appropriateSheetName);
        for (int i = 0; i < sheetNames.size(); ++i) {
            Sheet work = spread.getBook().getSheet((String)sheetNames.get(i));
            SumcalcRange sumRange = SheetHelper.getHelper(work).getSumRange();
            if (sumRange == null || sumRange.size() < 1) {
                throw new Exception("\u8868\u9875 " + work.getSheetName() + " \u6ca1\u6709\u8bbe\u7f6e\u6c47\u603b\u533a\u57df, \u4e0d\u80fd\u6c47\u603b");
            }
            for (int j = 0; j < sumRange.size(); ++j) {
                CellBlock site = sumRange.getCellBlock(j);
                Cell workCell = work.getCell(site.getRow(), site.getCol(), false);
                if (workCell == null) continue;
                Cell templateCell = template.getCell(site.getRow(), site.getCol(), true);
                try {
                    BigDecimal addend = workCell.getValue().toBigDecimal();
                    BigDecimal augend = templateCell.getValue().toBigDecimal();
                    templateCell.setValue(new Variant((Object)addend.add(augend)));
                    continue;
                }
                catch (SyntaxErrorException e) {
                    // empty catch block
                }
            }
        }
        return template;
    }

    public static String getAppropriateSheetName(String base, List sheetNames) {
        String result = base;
        int count = 1;
        while (sheetNames.contains(result)) {
            result = base + count;
            ++count;
        }
        return result;
    }

    public static List getAllSheetsName(KDSpread spread) {
        ArrayList<String> result = new ArrayList<String>();
        Book book = spread.getBook();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            result.add(book.getSheet(i).getSheetName());
        }
        return result;
    }
}

