/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.dbclean.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.app.CodeJZTask;
import com.kingdee.eas.fi.lcm.dbclean.app.LcmUtils;
import com.kingdee.eas.fi.lcm.dbclean.app.ResultSetProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class LcmMonCardTask
extends CodeJZTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doTask(JZContext context) throws JZTaskException {
        KDConnection dbConn = context.getDbConn();
        String orgId = context.getOrgFId();
        String periodId = context.getPeriodFId();
        int periodNumber = context.getPeriodNumber();
        Timestamp endTime = context.getEndTime();
        try {
            dbConn.setAutoCommit(false);
            if (!LcmUtils.checkBeforeTask(context, dbConn)) {
                String msg = "\u7ec4\u7ec7" + context.getOrgNumber() + "\u672a\u542f\u7528\u4f4e\u503c\u6613\u8017\u54c1\u6a21\u5757\uff0c\u76f4\u63a5\u8bbe\u7f6e\u7ed3\u8f6c\u4efb\u52a1\u6210\u529f\uff01";
                throw new JZTaskException(msg, 4);
            }
            LcmUtils.getLoggerOnTaskBegin(context, "\u521d\u59cb\u5316\u5361\u7247");
            StringBuffer prePeriodSql = new StringBuffer();
            prePeriodSql.append(" select top 1 FID,FNumber from t_bd_period where ftypeid in ( ");
            prePeriodSql.append(" select ftypeid from t_bd_period where fid = ? ) ");
            prePeriodSql.append(" and fnumber < ? order by fnumber desc ");
            Object[] prePeriodParams = new Object[]{periodId, periodNumber};
            String prePeriodId = "";
            Map prePeriodMap = (Map)LcmUtils.executeQueryAndProcess(prePeriodSql.toString(), prePeriodParams, dbConn, new ResultSetProcessor(){

                @Override
                public Object process(ResultSet rs) throws SQLException {
                    HashMap<String, Object> prePeriodMap = null;
                    if (rs.next()) {
                        prePeriodMap = new HashMap<String, Object>();
                        prePeriodMap.put("FNumber", rs.getInt("FNumber"));
                        prePeriodMap.put("FID", rs.getString("FID"));
                    }
                    return prePeriodMap;
                }
            });
            if (prePeriodMap == null) {
                String msg = "\u65e0\u6cd5\u83b7\u53d6\u7ed3\u8f6c\u671f\u95f4\u7684\u524d\u4e00\u671f\u95f4\uff0c\u65e0\u6cd5\u8fdb\u884c\u56fa\u5b9a\u8d44\u4ea7\u5e10\u5957\u7ed3\u8d26\uff01\u8bf7\u68c0\u67e5\u7ec4\u7ec7" + orgId + "\u7684\u7ed3\u8f6c\u671f\u95f4\u3002";
                throw new JZTaskException(msg, 5);
            }
            int prePdNumber = (Integer)prePeriodMap.get("FNumber");
            prePeriodId = (String)prePeriodMap.get("FID");
            LcmUtils.getLoggerOnTaskPrint(context, "\u7ed3\u8f6c\u671f\u95f4\u7684\u524d\u4e00\u671f\u95f4\u4e3a" + prePdNumber);
            StringBuffer CheckSql = new StringBuffer();
            CheckSql.append(" select pd.FNumber from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta,T_BD_PERIOD pd ");
            CheckSql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
            CheckSql.append(" and sysStaCtr.FCurrentPeriodID=pd.FID ");
            CheckSql.append(" and sysStaCtr.FCompanyID = ? ");
            CheckSql.append(" and pd.FNumber >= ? ");
            CheckSql.append(" and sysSta.FName = 32");
            Object[] CheckParams = new Object[]{orgId, periodNumber};
            boolean isPeriodOutOfRange = (Boolean)LcmUtils.executeQueryAndProcess(CheckSql.toString(), CheckParams, dbConn, new ResultSetProcessor(){

                @Override
                public Object process(ResultSet rs) throws SQLException {
                    return !rs.next();
                }
            });
            if (isPeriodOutOfRange) {
                String msg = "\u7ec4\u7ec7" + orgId + "\u7ed3\u8f6c\u671f\u95f4\u5927\u4e8e\u4f4e\u503c\u6613\u8017\u54c1\u5f53\u524d\u671f\u95f4\uff0c\u9519\u8bef\uff0c\u8bf7\u6838\u5bf9!";
                throw new JZTaskException(msg, 5);
            }
            if (prePeriodId == null || "".equals(prePeriodId)) {
                context.getLogger().println("monCard-\u7ed3\u8f6c\u671f\u95f4\u7684\u524d\u4e00\u671f\u95f4\u4e3a" + prePeriodId);
                throw new JZTaskException("\u7ed3\u8f6c\u524d\u4e00\u671f\u95f4\u6709\u95ee\u9898\uff0c\u8bf7\u6838\u5bf9\u540e\u518d\u7ee7\u7eed\u7ed3\u8f6c\uff01", 5);
            }
            String dltInitConsumeDetail = "delete from t_lcm_lcmconsumedetail where fmoncardid in (select fid from t_lcm_lcmmoncard  where fcompanyid = ? and fperiodid is null) ";
            Object[] dltInitConsumeDetailParams = new Object[]{orgId};
            LcmUtils.execute(dltInitConsumeDetail, dltInitConsumeDetailParams, dbConn);
            String dltInitData = "delete from t_lcm_lcmmoncard where fcompanyid = ? and fperiodid is null ";
            Object[] dltInitDataParams = new Object[]{orgId};
            LcmUtils.execute(dltInitData, dltInitDataParams, dbConn);
            StringBuffer dltBeforePrePeriodDataSql = new StringBuffer();
            dltBeforePrePeriodDataSql.append(" delete from t_lcm_lcmmoncard where fid in (");
            dltBeforePrePeriodDataSql.append(" select bill.fid from t_lcm_lcmmoncard bill ");
            dltBeforePrePeriodDataSql.append(" inner join t_bd_period pd on pd.fid = bill.fperiodid ");
            dltBeforePrePeriodDataSql.append(" where bill.fcompanyid = ? ");
            dltBeforePrePeriodDataSql.append(" and pd.fnumber < ? ");
            dltBeforePrePeriodDataSql.append(" )");
            Object[] dltBeforePrePeriodDataParams = new Object[]{orgId, prePdNumber};
            LcmUtils.execute(dltBeforePrePeriodDataSql.toString(), dltBeforePrePeriodDataParams, dbConn);
            String createIndexSql = "IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_LCMMON_CURCARDID') CREATE INDEX IX_LCMMON_CURCARDID ON t_lcm_lcmmoncard(fcurcardid) ";
            LcmUtils.processIndex(createIndexSql, dbConn);
            StringBuffer sltLcmReturnConsumeCardId = new StringBuffer();
            sltLcmReturnConsumeCardId.append(" select returnen.freturncurcardid from t_lcm_lcmreturnconsumeentry returnen ");
            sltLcmReturnConsumeCardId.append(" inner join t_lcm_lcmreturnconsumebill renturn on renturn.fid = returnen.fentryid ");
            sltLcmReturnConsumeCardId.append(" inner join t_bd_period pd on pd.fid = renturn.fperiodid ");
            sltLcmReturnConsumeCardId.append(" left outer join t_lcm_lcmconsumebill bill on bill.fid = returnen.fconsumebillid ");
            sltLcmReturnConsumeCardId.append(" inner join t_lcm_lcmconsumebillentry en on en.fbillid = bill. fid ");
            sltLcmReturnConsumeCardId.append(" inner join t_lcm_lcmcurcard cur on cur.fid = en.fcurcardid ");
            sltLcmReturnConsumeCardId.append(" where returnen.freturnunitprice <> cur.funitprice ");
            sltLcmReturnConsumeCardId.append(" and renturn.fcompanyid = ? ");
            sltLcmReturnConsumeCardId.append(" and pd.fnumber < ? ");
            StringBuffer dltedCardSql = new StringBuffer();
            dltedCardSql.append(" select fcurcardid from t_lcm_lcmmoncard ");
            dltedCardSql.append(" where fcompanyid = ? and fperiodid = ? and FUseStatus = 2 ");
            dltedCardSql.append(" and fcurcardid not in (");
            dltedCardSql.append(sltLcmReturnConsumeCardId.toString());
            dltedCardSql.append(") ");
            Object[] dltedCardParams = new Object[]{orgId, prePeriodId, orgId, periodNumber};
            this.dltDeletedStatusCards(context, dbConn, dltedCardParams, dltedCardSql.toString());
            StringBuffer InsertZeroCardSql = new StringBuffer();
            SimpleDateFormat dateFm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateTime = dateFm.format(endTime);
            InsertZeroCardSql.append("select cur.fid into T_LCM_LCMCURCARDID from t_lcm_lcmcurcard cur ").append("inner join t_bd_period pd on pd.fid = cur.flcmperiodid ").append("left outer join (").append("select en.fcurcardid as fcurcardid,sum(en.fleftquantity) as fleftquantity from t_lcm_lcmconsumebill bill ").append("inner join t_lcm_lcmconsumebillentry en on en.fbillid = bill.fid ").append("where bill.fcompanyid = '").append(orgId).append("' ").append("and fusedate < {ts'" + dateTime + "'} group by en.fcurcardid").append(") consumetry on consumetry.fcurcardid = cur.fid ").append("left outer join t_lcm_lcmreturnconsumeentry returnen on returnen.fcurcardid = cur.fid ").append("where (consumetry.fleftquantity = 0 or consumetry.fleftquantity is null) ").append("and (returnen.fid is null or returnen.freturnunitprice = cur.funitprice) ").append("and cur.fusableamt = 0 and cur.fusestatus <> 2 ").append("and cur.fcompanyid = '").append(orgId).append("' ").append("and pd.fnumber < ").append(periodNumber);
            String dltTableSql = "If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_LCM_LCMCURCARDID')  drop table T_LCM_LCMCURCARDID";
            LcmUtils.processIndex(dltTableSql, dbConn);
            Statement stmt = null;
            try {
                stmt = dbConn.createStatement();
                stmt.execute(InsertZeroCardSql.toString());
            }
            catch (SQLException e) {
                LcmUtils.getLoggerOnTaskError(context, "\u521d\u59cb\u5316\u5361\u7247");
            }
            finally {
                JZContext.closeStatment((Statement)stmt);
            }
            String cardsSql = "select fid from T_LCM_LCMCURCARDID";
            Object[] cardsParams = new Object[]{};
            this.dltDeletedStatusCards(context, dbConn, cardsParams, cardsSql);
            String dltMonCardsSql = "delete from t_lcm_lcmmoncard where fcurcardid in (select fid from T_LCM_LCMCURCARDID) and fcompanyid = ? ";
            Object[] dltMonCardsParams = new Object[]{orgId};
            LcmUtils.execute(dltMonCardsSql.toString(), dltMonCardsParams, dbConn);
            String dltCurCardsSql = "delete from t_lcm_lcmcurcard where fid in (select fid from T_LCM_LCMCURCARDID) and fcompanyid = ? ";
            Object[] dltCurCardsParams = new Object[]{orgId};
            LcmUtils.execute(dltCurCardsSql.toString(), dltCurCardsParams, dbConn);
            StringBuffer dltMonCardSql = new StringBuffer();
            dltMonCardSql.append(" delete from t_lcm_lcmmoncard where fcurcardid in (");
            dltMonCardSql.append(" select fcurcardid from t_lcm_lcmmoncard ");
            dltMonCardSql.append(" where fcompanyid = ? ");
            dltMonCardSql.append(" and fperiodid = ? ");
            dltMonCardSql.append(" and FUseStatus = 2) and fcurcardid not in (");
            dltMonCardSql.append(sltLcmReturnConsumeCardId.toString());
            dltMonCardSql.append(") and fperiodid <> ?  ");
            Object[] dltMonCardParams = new Object[]{orgId, prePeriodId, orgId, periodNumber, prePeriodId};
            LcmUtils.execute(dltMonCardSql.toString(), dltMonCardParams, dbConn);
            String dltIndexSql = "IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_LCMMON_CURCARDID') DROP INDEX t_lcm_lcmmoncard.IX_LCMMON_CURCARDID ";
            LcmUtils.processIndex(dltIndexSql, dbConn);
            StringBuffer dltCurCardSql = new StringBuffer();
            dltCurCardSql.append(" delete from t_lcm_lcmcurcard where fid in (");
            dltCurCardSql.append(" select fcurcardid from t_lcm_lcmmoncard ");
            dltCurCardSql.append(" where fcompanyid = ? ");
            dltCurCardSql.append(" and fperiodid = ? ");
            dltCurCardSql.append(" and FUseStatus = 2) and fid not in (");
            dltCurCardSql.append(sltLcmReturnConsumeCardId.toString());
            dltCurCardSql.append(") ");
            Object[] dltCurCardParams = new Object[]{orgId, prePeriodId, orgId, periodNumber};
            LcmUtils.execute(dltCurCardSql.toString(), dltCurCardParams, dbConn);
            String dltDeletedStatusSql = "delete from t_lcm_lcmmoncard where fcompanyid = ? and fperiodid = ? and FUseStatus = 2";
            Object[] dltDeletedStatusParams = new Object[]{orgId, prePeriodId};
            LcmUtils.execute(dltDeletedStatusSql, dltDeletedStatusParams, dbConn);
            String updateInitDataSql = "update t_lcm_lcmmoncard set fsourcebillid = null, flcmperiodid = null, fsourcetype = 1, fperiodid = null where fcompanyid = ? and fperiodid = ? ";
            Object[] updateInitDataParams = new Object[]{orgId, prePeriodId};
            LcmUtils.executeUpdate(updateInitDataSql, updateInitDataParams, dbConn);
            dbConn.commit();
            StringBuffer insertConsumeDetailSql = new StringBuffer();
            insertConsumeDetailSql.append("insert into t_lcm_lcmconsumedetail(fid,fseq,fusedate,fuseamt,fusedepartmentid,fusepersonid,fuseamount,famortizedamount,famortizeamount,");
            insertConsumeDetailSql.append("fdeletednum,fdeleteddate,fremark,faddress,fnumber,fmoncardid,fstoreadress,faccountid)");
            insertConsumeDetailSql.append("select newbosid('A7B2A702') as fid,1 as fseq,bill.fusedate as fusedate,en.fquantity as fuseamt,bill.fusedepartmentid as fusedepartmentid,");
            insertConsumeDetailSql.append("bill.fusepersonid as fusepersonid,en.fuseamount as fuseamount,en.famortizedamount as famortizedamount,en.famortizeamount as famortizeamount,");
            insertConsumeDetailSql.append("en.fquantity-en.fleftquantity as fdeletednum,null as fdeleteddate,en.fremark as fremark,en.faddress as faddress,bill.fnumber as fnumber,");
            insertConsumeDetailSql.append("mon.fid as fmoncardid,en.fstoreadress as fstoreadress,bill.faccountid as faccountid ");
            insertConsumeDetailSql.append("from t_lcm_lcmconsumebillentry en ");
            insertConsumeDetailSql.append("inner join t_lcm_lcmconsumebill bill on bill.fid = en.fbillid ");
            insertConsumeDetailSql.append("inner join t_bd_period pd on pd.fid = bill.fperiodid ");
            insertConsumeDetailSql.append("inner join t_lcm_lcmmoncard mon on mon.fcurcardid = en.fcurcardid ");
            insertConsumeDetailSql.append("where mon.fcompanyid = ? ");
            insertConsumeDetailSql.append("and mon.fperiodid is null ");
            insertConsumeDetailSql.append("and pd.fnumber < ? ");
            Object[] insertConsumeDetailParams = new Object[]{orgId, periodNumber};
            LcmUtils.execute(insertConsumeDetailSql.toString(), insertConsumeDetailParams, dbConn);
            StringBuffer updateCurCardPeriod = new StringBuffer();
            updateCurCardPeriod.append("update t_lcm_lcmcurcard set fsourcetype = 3, flcmperiodid = null ").append("where fid in (").append("select fcurcardid from t_lcm_lcmmoncard ").append("where fcompanyid = ? ").append("and fperiodid is null)");
            Object[] updateCurCardPeriodParams = new Object[]{orgId};
            LcmUtils.executeUpdate(updateCurCardPeriod.toString(), updateCurCardPeriodParams, dbConn);
            StringBuffer updateMonCardPeriod = new StringBuffer();
            updateMonCardPeriod.append("update t_lcm_lcmmoncard set fsourcetype = 3, flcmperiodid = null ").append("where fcurcardid in (").append("select fcurcardid from t_lcm_lcmmoncard ").append("where fcompanyid = ? ").append("and fperiodid is null) and fperiodid is not null ");
            Object[] updateMonCardPeriodParams = new Object[]{orgId};
            LcmUtils.executeUpdate(updateMonCardPeriod.toString(), updateMonCardPeriodParams, dbConn);
            dbConn.commit();
            LcmUtils.getLoggerOnTaskEnd(context, "\u521d\u59cb\u5316\u5361\u7247");
        }
        catch (SQLException e) {
            LcmUtils.getLoggerOnTaskError(context, "\u521d\u59cb\u5316\u5361\u7247");
            throw new JZTaskException(e.getMessage(), 5);
        }
        return true;
    }

    private void dltDeletedStatusCards(JZContext context, KDConnection dbConn, Object[] params, String dltedCardSql) throws JZTaskException {
        String orgId = context.getOrgFId();
        Object[] orgParams = new Object[]{orgId};
        Object[] orgBeginParams = new Object[params.length + 1];
        for (int i = 0; i < params.length; ++i) {
            orgBeginParams[i + 1] = params[i];
        }
        orgBeginParams[0] = orgId;
        StringBuffer dltReturnConsumebillEntry = new StringBuffer();
        dltReturnConsumebillEntry.append("delete from t_lcm_discardbillentry where fconsumeentryid in (").append("select fid from t_lcm_lcmconsumebillentry where fcurcardid in (").append(dltedCardSql).append(")) ");
        StringBuffer dltConsumebillEntry = new StringBuffer();
        dltConsumebillEntry.append("delete from t_lcm_lcmconsumebillentry where fcurcardid in (").append(dltedCardSql).append(") ");
        StringBuffer dltConsumebill = new StringBuffer();
        dltConsumebill.append("delete from t_lcm_lcmconsumebill where fid in (").append("select bill.fid from t_lcm_lcmconsumebill bill ").append("left outer join t_lcm_lcmconsumebillentry en on bill.fid = en.fbillid ").append("where bill.fcompanyid = ? ").append("and en.fid is null) ");
        StringBuffer dltReturnbillEntry = new StringBuffer();
        dltReturnbillEntry.append("delete from t_lcm_lcmreturnconsumeentry where fcurcardid in (").append(dltedCardSql).append(") ");
        StringBuffer dltReturnbill = new StringBuffer();
        dltReturnbill.append("delete from t_lcm_lcmreturnconsumebill where fid in (").append("select bill.fid from t_lcm_lcmreturnconsumebill bill ").append("left outer join t_lcm_lcmreturnconsumeentry en on bill.fid = en.fentryid ").append("where bill.fcompanyid = ? ").append("and en.fid is null) ");
        StringBuffer dltDiscardbillEntry = new StringBuffer();
        dltDiscardbillEntry.append("delete from t_lcm_discardbillentry where fcurcardid in (").append(dltedCardSql).append(") ");
        StringBuffer dltDiscardbill = new StringBuffer();
        dltDiscardbill.append("delete from t_lcm_discardbill where fid in (").append("select bill.fid from t_lcm_discardbill bill ").append("left outer join t_lcm_discardbillentry en on bill.fid = en.fbillid ").append("where bill.fcompanyid = ? ").append("and en.fid is null) ");
        StringBuffer dltDispatchbillEntry = new StringBuffer();
        dltDispatchbillEntry.append("delete from t_lcm_lcmdispatchbillentry where fid in (").append("select en.fid from t_lcm_lcmdispatchbillentry en ").append("inner join t_lcm_lcmdispatchbill bill on bill.fid = en.flcmdispatchbillid ").append("where bill.fcompanyid = ? ").append("and en.flcmcurcardid in (").append(dltedCardSql).append(")) ");
        StringBuffer dltDispatchbill = new StringBuffer();
        dltDispatchbill.append("delete from t_lcm_lcmdispatchbill where fid in (").append("select bill.fid from t_lcm_lcmdispatchbill bill ").append("left outer join t_lcm_lcmdispatchbillentry en on bill.fid = en.flcmdispatchbillid ").append("where bill.fcompanyid = ? ").append("and en.fid is null) ");
        try {
            LcmUtils.execute(dltReturnConsumebillEntry.toString(), params, dbConn);
            dbConn.commit();
            LcmUtils.execute(dltConsumebillEntry.toString(), params, dbConn);
            LcmUtils.execute(dltReturnbillEntry.toString(), params, dbConn);
            LcmUtils.execute(dltDiscardbillEntry.toString(), params, dbConn);
            LcmUtils.execute(dltDispatchbillEntry.toString(), orgBeginParams, dbConn);
            dbConn.commit();
            LcmUtils.execute(dltConsumebill.toString(), orgParams, dbConn);
            LcmUtils.execute(dltReturnbill.toString(), orgParams, dbConn);
            LcmUtils.execute(dltDiscardbill.toString(), orgParams, dbConn);
            LcmUtils.execute(dltDispatchbill.toString(), orgParams, dbConn);
            dbConn.commit();
        }
        catch (SQLException e) {
            LcmUtils.getLoggerOnTaskError(context, "\u5df2\u62a5\u5e9f\u7684\u5361\u7247\u5bf9\u5e94\u7684\u9886\u7528\u3001\u9000\u5e93\u3001\u62a5\u5e9f\u3001\u8c03\u62e8\u5355");
            throw new JZTaskException(e.getMessage(), 5);
        }
    }
}

