/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AbstractCheckageBillHeadInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckWorkeFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckWorkeInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillHeadFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillHeadInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyStatusCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyStatusFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyStatusInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageOrgPackInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CompanyStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CompareCharEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ConfirmStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.DataSourceEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageBill;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageBillCompany;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageBillHead;
import com.kingdee.eas.fi.newrpt.accountcheck.ImportFromRptParamInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.SubmitFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.app.AbstractAccountCheckFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.accountcheck.app.GLUnClosePeriodCheck;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckParams;
import com.kingdee.eas.fi.newrpt.accountcheck.app.importFromRpt.ImportFromRptUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountCheckFacadeControllerBean
extends AbstractAccountCheckFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.AccountCheckFacadeControllerBean");
    private static String reourcePath = "com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource";

    @Override
    protected List _getBillCompanyInfoList(Context ctx, Map infoMap) throws BOSException, EASBizException {
        ArrayList billCompanyInfoList = new ArrayList();
        Set billHeadIdSet = (Set)infoMap.get("billHeadSet");
        try {
            String language = ctx.getLocale().getLanguage();
            SQLBuilder sql = new SQLBuilder();
            sql.append("select billHeadId,billNumber,isUnilateral,companyId,companyName,tarCompanyId,tarCompanyName,max(confirmSt) confirmSt,max(diffRemark) diffRemark,itemType \n");
            sql.append("from ( \n");
            sql.append("select bill.FBillHeadId billHeadId,billHead.Fnumber billNumber,acctMap.FIsUnilateralReconciliation isUnilateral, \n");
            sql.append("case when company.fnumber<tarcompany.fnumber then bill.FCompanyId else bill.FTargetCompanyId end companyId, \n");
            sql.append("case when company.fnumber<tarcompany.fnumber then company.Fname_").append(language).append(" else tarcompany.Fname_").append(language).append(" end companyName, \n");
            sql.append("case when company.fnumber<tarcompany.fnumber then bill.FTargetCompanyId else bill.FCompanyId end tarCompanyId, \n");
            sql.append("case when company.fnumber<tarcompany.fnumber then tarcompany.Fname_").append(language).append(" else company.Fname_").append(language).append(" end tarCompanyName, \n");
            sql.append("billCompany.FConfirmStatus confirmSt,billCompany.fdiffRemark diffRemark,bill.FItemType itemType \n");
            sql.append("from T_Csl_CheckageBill bill  \n");
            sql.append("inner join T_Csl_CheckageBillHead billHead on billHead.Fid=bill.FBillHeadId \n");
            sql.append("inner join T_Csl_AccountMap acctMap on acctMap.fid=billHead.FAccountMapId \n");
            sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.fid=bill.FBillCompanyId \n");
            sql.append("inner join T_ORG_Company company on company.Fid=bill.FCompanyId \n");
            sql.append("inner join T_ORG_Company tarcompany on tarcompany.Fid=bill.FTargetCompanyId \n");
            sql.append("where bill.FBillHeadId in \n", billHeadIdSet);
            sql.append(" ) group by billHeadId,billNumber,isUnilateral,companyId,companyName,tarCompanyId,tarCompanyName,itemType");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("billheadId", rowSet.getString("billHeadId"));
                    map.put("number", rowSet.getString("billNumber"));
                    map.put("itemType", ItemTypeEnum.getEnum(rowSet.getInt("itemType")).getAlias());
                    map.put("companyID", rowSet.getString("companyId"));
                    map.put("companyName", rowSet.getString("companyName"));
                    map.put("tarCompanyID", rowSet.getString("tarCompanyId"));
                    map.put("tarCompanyName", rowSet.getString("tarCompanyName"));
                    map.put("confirmSt", ConfirmStatusEnum.getEnum(rowSet.getInt("confirmSt")).getAlias());
                    map.put("diffRemark", rowSet.getString("diffRemark"));
                    map.put("isUnilateral", rowSet.getBoolean("isUnilateral") ? "true" : "false");
                    billCompanyInfoList.add(map);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return billCompanyInfoList;
    }

    @Override
    public FullOrgUnitCollection _getAuthorizedOrg(Context ctx, IObjectPK userPK) throws BOSException, EASBizException {
        if (userPK == null) {
            throw new IllegalArgumentException("RptNewUIHandleFacadeControllerBean's arguments is Illegal!");
        }
        String treeID = PermissionCacheFactory.getOrgCache((Context)ctx).getBasicTreeID(ctx, OrgType.Company);
        PermItemInfo permItemInfos = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, "csl_checkwork_view");
        Object[] params = new Object[]{treeID};
        String nameField = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT BaseUnit.FID id, BaseUnit.FNumber number, Structure.FLongNumber longNumber, \n").append(" BaseUnit.").append(nameField).append(" Fname, ").append(" CASE perm.FPermItemID WHEN '").append(permItemInfos.getId().toString()).append("' THEN 'csl_checkwork_view'  ELSE 'NONE' END as FPermItemName \n").append(" FROM T_ORG_BaseUnit BaseUnit \n").append(" INNER JOIN T_ORG_Company company ON company.fid = BaseUnit.FID \n").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID \n").append(" INNER JOIN (").append(this.combineHasPermSQL(userPK, permItemInfos.getId().toString())).append(") perm \n").append(" on BaseUnit.FID = perm.FOrgID \n").append(" WHERE Structure.FTreeId = ? \n").append(" and company.fisbizunit=1 \n").append(" order by Structure.FLongNumber asc \n");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params);
        FullOrgUnitCollection result = new FullOrgUnitCollection();
        if (rowSet != null && rowSet.size() > 0) {
            try {
                while (rowSet.next()) {
                    FullOrgUnitInfo fullOrgUnitInfo = new FullOrgUnitInfo();
                    fullOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
                    fullOrgUnitInfo.setNumber(rowSet.getString("number"));
                    fullOrgUnitInfo.setName(rowSet.getString("FName"));
                    result.add(fullOrgUnitInfo);
                }
            }
            catch (Exception e) {
                logger.error((Object)"_getAuthorizedOrg_error:", (Throwable)e);
            }
        }
        return result;
    }

    private String combineHasPermSQL(IObjectPK userPK, String permItemID) {
        StringBuffer sql = new StringBuffer(1000);
        String userID = userPK == null ? "userid " : userPK.toString();
        sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID,UserOrgPerm.FPermItemID as FPermItemID \n").append(" FROM T_PM_UserOrgPerm UserOrgPerm \n").append(" WHERE UserOrgPerm.FOwner = '").append(userID).append("' AND UserOrgPerm.FPermItemID \n").append(" ='").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(10).append(" AND NOT EXISTS ( \n").append(" SELECT 'X' FROM T_PM_UserOrgPerm UserOrgPerm2 \n").append(" WHERE UserOrgPerm2.FOwner = '").append(userID).append("' AND UserOrgPerm2.FPermItemID \n").append(" ='").append(permItemID).append("' AND UserOrgPerm2.FPermType = ").append(20).append("\n").append(" AND UserOrgPerm.FPermItemID = UserOrgPerm2.FPermItemID \n").append(" AND UserOrgPerm.FOrgID = UserOrgPerm2.FOrgID) \n").append(" Union  \n").append(" SELECT UserRoleOrg.FOrgID AS FOrgID,RolePerm.FPermItemID as FPermItemID FROM T_PM_RolePerm RolePerm \n").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID \n").append(" WHERE UserRoleOrg.FUserID = '").append(userID).append("' AND RolePerm.FPermItemID ='").append(permItemID).append("'").append("  AND RolePerm.FPermType = ").append(10).append(" AND NOT EXISTS( \n").append(" SELECT 'X' FROM T_PM_RolePerm RolePerm2 \n").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg2 ON  RolePerm2.FRoleID = UserRoleOrg2.FRoleID \n").append(" WHERE UserRoleOrg2.FUserID = '").append(userID).append("' AND RolePerm2.FPermItemID ='").append(permItemID).append("'").append(" AND RolePerm2.FPermType = ").append(20).append(" \n").append(" AND RolePerm.FPermItemID = RolePerm2.FPermItemID \n").append(" AND UserRoleOrg.FOrgID = UserRoleOrg2.FOrgID) \n");
        return sql.toString();
    }

    private Map fetchAccountData(Context ctx, AccountCheckWorkeFilterInfo filterInfo, AutoCheckParams autoCheckParams) throws BOSException, EASBizException {
        HashMap<String, AccountCheckWorkeFilterInfo> resultMap = new HashMap<String, AccountCheckWorkeFilterInfo>();
        TempTablePool tmpTablePool = null;
        String srcBillDataTmep = null;
        ParamTempTblService service = null;
        String allCompanyTmpTblName = null;
        try {
            HashMap<String, AccountCheckWorkeFilterInfo> hashMap;
            tmpTablePool = TempTablePool.getInstance((Context)ctx);
            Boolean hasAccountMap = null;
            ItemTypeEnum itemTypeEnum = filterInfo.getItemTypeEnum();
            if (itemTypeEnum == null) {
                itemTypeEnum = ItemTypeEnum.account;
            }
            int year = filterInfo.getYear();
            int period = filterInfo.getPeriod();
            String currencyId = filterInfo.getCurrencyId();
            int tempCriticalNum = filterInfo.getTempCriticalNum();
            boolean queryAllData = filterInfo.isQueryAllData();
            Set<String> allCompanyOrgIdSet = filterInfo.getAllCompanyOrgIdSet();
            HashSet<String> hasPermissionCompanyOrgIdSet = new HashSet<String>(filterInfo.getHasOrgPermissionCompanyIdSet());
            if (hasPermissionCompanyOrgIdSet.isEmpty()) {
                hasPermissionCompanyOrgIdSet.add("00000000000000000000000000000000000000000000");
                filterInfo.setHasOrgPermissionCompanyIdSet(hasPermissionCompanyOrgIdSet);
            }
            if (!queryAllData) {
                allCompanyOrgIdSet.clear();
                allCompanyOrgIdSet.add(filterInfo.getAccountCheckCompanyId());
            }
            HashSet<String> hasDataOrgSet = new HashSet<String>();
            SQLBuilder sql = new SQLBuilder();
            HashMap<String, Timestamp> createCompanyAndTimeMap = new HashMap<String, Timestamp>();
            HashSet<String> companyIdSet = new HashSet<String>();
            Map companyAndPackInfoMap = new HashMap();
            if (!allCompanyOrgIdSet.isEmpty()) {
                if (allCompanyOrgIdSet.size() >= tempCriticalNum) {
                    service = ParamTempTblService.getDefaultInstance((Context)ctx, allCompanyOrgIdSet, null);
                    allCompanyTmpTblName = service.getTmpTableName();
                }
                sql.append("select distinct flastupdatetime,FCreateCompanyId,FCompanyId,FTargetCompanyId from T_CSL_CheckageBillData \n");
                sql.append("where FYear=?    \n", year);
                sql.append("and FPeriod=?    \n", period);
                sql.append("and FCurrencyId=?  \n", currencyId);
                sql.append("and FItemType=?  \n", itemTypeEnum.getValue());
                if (!StringUtils.isEmpty((String)allCompanyTmpTblName)) {
                    sql.append("and (FCompanyId in (select id from ").append(allCompanyTmpTblName).append(" )");
                    sql.append(" or FTargetCompanyId in (select id from ").append(allCompanyTmpTblName).append(" ))");
                } else {
                    sql.append("and (FCompanyId in ", allCompanyOrgIdSet);
                    sql.append(" or FTargetCompanyId in ", allCompanyOrgIdSet).append(")");
                }
                sql.append("order by flastupdatetime desc");
                IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (row != null && row.size() > 0) {
                    while (row.next()) {
                        String createCompanyId = row.getString("FCreateCompanyId");
                        String companyId = row.getString("FCompanyId");
                        String tarCompanyId = row.getString("FTargetCompanyId");
                        if (allCompanyOrgIdSet.contains(createCompanyId) && !createCompanyAndTimeMap.containsKey(createCompanyId)) {
                            createCompanyAndTimeMap.put(createCompanyId, row.getTimestamp("flastupdatetime"));
                        }
                        if (allCompanyOrgIdSet.contains(companyId)) {
                            companyIdSet.add(companyId);
                        }
                        if (!allCompanyOrgIdSet.contains(tarCompanyId)) continue;
                        companyIdSet.add(tarCompanyId);
                    }
                }
                companyAndPackInfoMap = this.getLastPackInfo(ctx, year, period, currencyId, allCompanyOrgIdSet, allCompanyTmpTblName, itemTypeEnum);
            }
            Set createCompanyIdSet = createCompanyAndTimeMap.keySet();
            HashSet<String> noDataCompanyIdSet = new HashSet<String>(allCompanyOrgIdSet);
            noDataCompanyIdSet.removeAll(createCompanyIdSet);
            HashSet<String> noCreateCompanySet = new HashSet<String>(noDataCompanyIdSet);
            noDataCompanyIdSet.removeAll(companyIdSet);
            if (!noDataCompanyIdSet.isEmpty()) {
                this.removeUnConfirmBill(ctx, year, period, currencyId, noDataCompanyIdSet, itemTypeEnum);
            }
            Set haveDataCompanySet = new HashSet();
            HashSet<String> haveDeleteRecordCompanySet = new HashSet<String>();
            if (!noCreateCompanySet.isEmpty()) {
                haveDataCompanySet = this.haveDataCompanySet(ctx, year, period, currencyId, noCreateCompanySet, itemTypeEnum);
                sql.reset();
                sql.append("select FDeleteCompany from T_CSL_BillDeleteRecord \n");
                sql.append("where FYear=?    \n", year);
                sql.append("and FPeriod=?    \n", period);
                sql.append("and FCurrencyId=?  \n", currencyId);
                sql.append("and FDeleteCompany in  \n", noCreateCompanySet);
                sql.append("and FItemType=?  \n", itemTypeEnum.getValue());
                IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (row != null && row.size() > 0) {
                    while (row.next()) {
                        haveDeleteRecordCompanySet.add(row.getString("FDeleteCompany"));
                    }
                }
            }
            HashSet<String> needUpdateDiffItemHeadIdSet = new HashSet<String>();
            HashMap<String, Map<Integer, Set<String>>> mapIdInfoMap = new HashMap<String, Map<Integer, Set<String>>>();
            for (String accountCheckCompanyId : allCompanyOrgIdSet) {
                CheckageOrgPackInfo packInfo = null;
                if (!createCompanyIdSet.contains(accountCheckCompanyId)) {
                    boolean hasSrcData = false;
                    if (companyIdSet.contains(accountCheckCompanyId)) {
                        hasSrcData = true;
                    }
                    boolean isEmpty = false;
                    if (!haveDataCompanySet.contains(accountCheckCompanyId)) {
                        if (!hasSrcData) {
                            isEmpty = true;
                        } else {
                            companyAndPackInfoMap.get(accountCheckCompanyId);
                            packInfo = (CheckageOrgPackInfo)companyAndPackInfoMap.get(accountCheckCompanyId);
                            if (packInfo == null) {
                                isEmpty = true;
                            }
                        }
                    } else if (!haveDeleteRecordCompanySet.contains(accountCheckCompanyId) && (packInfo = (CheckageOrgPackInfo)companyAndPackInfoMap.get(accountCheckCompanyId)) == null) {
                        isEmpty = true;
                    }
                    if (isEmpty) continue;
                }
                boolean needUpdateBill = false;
                if (packInfo == null) {
                    packInfo = (CheckageOrgPackInfo)companyAndPackInfoMap.get(accountCheckCompanyId);
                }
                Timestamp packTime = null;
                String packId = null;
                if (packInfo != null) {
                    packTime = packInfo.getPackTime();
                    packId = packInfo.getId().toString();
                }
                if (packTime == null) {
                    needUpdateBill = true;
                } else {
                    Timestamp billDateTime = (Timestamp)createCompanyAndTimeMap.get(accountCheckCompanyId);
                    if (billDateTime != null && billDateTime.getTime() - packTime.getTime() > 0L) {
                        needUpdateBill = true;
                    }
                }
                if (hasAccountMap == null) {
                    sql.reset();
                    sql.append("select top 1 fid from T_Csl_AccountMap where FItemType=?", itemTypeEnum.getValue());
                    IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                    if (row == null || row.size() < 1) {
                        hasAccountMap = false;
                        continue;
                    }
                    hasAccountMap = true;
                }
                if (!hasAccountMap.booleanValue()) continue;
                if (needUpdateBill) {
                    long currentTimeMillis = System.currentTimeMillis();
                    logger.error((Object)("packData_startTime:" + currentTimeMillis));
                    Date nowTime = new Date();
                    Timestamp nowTimest = new Timestamp(nowTime.getTime());
                    sql.reset();
                    if (packId == null) {
                        sql.append("insert into T_Csl_CheckageOrgPack(FYear,FPeriod,FCurrencyId,FCompanyId,FPackTime,FItemType,Fid,FLastGetDataTime) values(?,?,?,?,?,?,?,?)");
                        DbUtil.execute(ctx, sql.getSQL(), new Object[]{year, period, currencyId, accountCheckCompanyId, nowTimest, itemTypeEnum.getValue(), BOSUuid.create((BOSObjectType)new CheckageOrgPackInfo().getBOSType()).toString(), nowTimest});
                    } else {
                        sql.append("update T_Csl_CheckageOrgPack set FPackTime=? ", nowTimest);
                        sql.append("where fid=?", packId);
                        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                    }
                    boolean needCreateTempTable = true;
                    if (!StringUtils.isEmpty(srcBillDataTmep) && !DebugLogger.isDebug) {
                        sql.reset();
                        sql.append("delete from ").append(srcBillDataTmep);
                        DbUtil.execute(ctx, sql.getSQL());
                        needCreateTempTable = false;
                    }
                    if (ItemTypeEnum.account == itemTypeEnum) {
                        if (needCreateTempTable) {
                            sql.reset();
                            sql.append("create table t_csl_tempAcMap(FCompanyId varchar(44),companyNumber nvarchar(80),FTargetCompanyId varchar(44),tarCompanyNumber nvarchar(80), FAccountId varchar(44),");
                            sql.append("FCkAccountId varchar(44),FAccountTableid varchar(44),FItemNumber nvarchar(80),FItemName nvarchar(255),FBalType int, FDebit NUMERIC(21,6),");
                            sql.append("FCredit NUMERIC(21,6),FConfirmDebit NUMERIC(21,6),FConfirmCredit NUMERIC(21,6),FAuditDebit NUMERIC(21,6),FAuditCredit NUMERIC(21,6), FisIncludeUnPosted int,");
                            sql.append("FCreatorID varchar(44),FCreateTime DateTime,FLastUpdateUserID varchar(44),FLastUpdateTime DateTime,FControlUnitID varchar(44),mapId varchar(44), companyKey varchar(88),");
                            sql.append("seq int,acSeq int, mapIsFreezed int, FSrcBillId varchar(44), billItemType int, dataSource int,remark nvarchar(2000),fimportReportId varchar(44),fimportSheetName nvarchar(200),");
                            sql.append("acMapDataSource int)");
                            srcBillDataTmep = tmpTablePool.createTempTable(sql.getSQL());
                        }
                        this.UpdateBillData(ctx, packId, srcBillDataTmep, filterInfo, autoCheckParams, itemTypeEnum, accountCheckCompanyId, mapIdInfoMap, needUpdateDiffItemHeadIdSet);
                    } else {
                        if (needCreateTempTable) {
                            sql.reset();
                            sql.append("create table t_csl_tempAcMap2(FCompanyId varchar(44),companyNumber nvarchar(80),FTargetCompanyId varchar(44),tarCompanyNumber nvarchar(80),");
                            sql.append("FCkAccountId varchar(44),FItemNumber nvarchar(80),FItemName nvarchar(255),FDataElement int, FDebit NUMERIC(21,6),");
                            sql.append("FCredit NUMERIC(21,6),FConfirmDebit NUMERIC(21,6),FConfirmCredit NUMERIC(21,6),FAuditDebit NUMERIC(21,6),FAuditCredit NUMERIC(21,6), FisIncludeUnPosted int,");
                            sql.append("FCreatorID varchar(44),FCreateTime DateTime,FLastUpdateUserID varchar(44),FLastUpdateTime DateTime,FControlUnitID varchar(44),mapId varchar(44), companyKey varchar(88),");
                            sql.append("seq int,acSeq int, mapIsFreezed int, FSrcBillId varchar(44), billItemType int, dataSource int,remark nvarchar(2000),fimportReportId varchar(44),fimportSheetName nvarchar(200),");
                            sql.append("acMapDataSource int)");
                            srcBillDataTmep = tmpTablePool.createTempTable(sql.getSQL());
                        }
                        this.UpdateRptItemTypeBillData(ctx, packId, srcBillDataTmep, filterInfo, autoCheckParams, itemTypeEnum, accountCheckCompanyId, mapIdInfoMap, needUpdateDiffItemHeadIdSet);
                    }
                    logger.error((Object)("packData_endTime:" + (System.currentTimeMillis() - currentTimeMillis)));
                }
                hasDataOrgSet.add(accountCheckCompanyId);
            }
            if (hasDataOrgSet.isEmpty()) {
                filterInfo.clear();
                filterInfo.setHavaData(false);
                resultMap.put("filterInfo", filterInfo);
                hashMap = resultMap;
                return hashMap;
            }
            if (hasAccountMap != null && !hasAccountMap.booleanValue()) {
                filterInfo.setHavaData(false);
                resultMap.put("filterInfo", filterInfo);
                hashMap = resultMap;
                return hashMap;
            }
            filterInfo.setHasDataOrgSet(hasDataOrgSet);
            resultMap.put("filterInfo", filterInfo);
        }
        catch (Exception e) {
            logger.error((Object)"_fetchAccountCheckageBill error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!DebugLogger.isDebug && tmpTablePool != null && srcBillDataTmep != null) {
                tmpTablePool.releaseTable(srcBillDataTmep);
            }
            if (service != null && !DebugLogger.isDebug) {
                service.release();
            }
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDiffBillData(Context ctx, Set<String> needUpdateDiffItemHeadIdSet, Set<String> updateHeadBillDiffSet, ItemTypeEnum itemTypeEnum) throws BOSException, SQLException, EASBizException {
        boolean isAccount = 0 == itemTypeEnum.getValue();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select distinct bill1.FBillHeadId headId, billCompany1.Fid billCompanyId,billCompany1.FPackSchmId schmId,  \n");
        sql.append("billCompany1.FConfirmStatus confirmStatus, acMapAccount1.FIsMapAccount billIsMapAccount,  \n");
        sql.append("ckCompany.FISINCLUDINGUNPOSTED FISINCLUDINGUNPOSTED, bill1.FYEAR year, bill1.FPERIOD period,  \n");
        sql.append("bill1.FCURRENCYID currencyId, bill1.FCOMPANYID companyId,bill1.FTARGETCOMPANYID tarCompanyId,  \n");
        sql.append("rs.accountId accountId, rs.isMapAccount isMapAccount, rs.sumbillCrebit sumbillCrebit,   \n");
        if (isAccount) {
            sql.append("rs.accountViewId accountViewId, rs.tarAccountViewId tarAccountViewId,   \n");
        }
        sql.append("rs.itemNumber itemNumber, rs.balType balType, rs.dataElement dataElement, rs.itemName itemName  \n");
        sql.append("from T_Csl_CheckageBill bill1 \n");
        sql.append("inner join T_Csl_CheckageCompany ckCompany on ckCompany.FCompanyId=bill1.FCOMPANYID \n");
        sql.append("inner join T_Csl_CheckageBillHead billHead1 on billHead1.Fid=bill1.FBillHeadId  \n");
        sql.append("inner join T_Csl_CheckageBillCompany billCompany1 on billCompany1.Fid=bill1.FBillCompanyId  \n");
        sql.append("inner join T_Csl_CheckageAccount account1 on account1.Fid=bill1.FCheckAccountId  \n");
        sql.append("inner join T_Csl_AccountAndMapAccount acMapAccount1 on acMapAccount1.FCheckAccountId=account1.Fid  \n");
        sql.append("inner join T_Csl_AccountMap acMap1 on acMap1.Fid=billHead1.FAccountMapId  \n");
        sql.append("inner join (  \n");
        sql.append("select billHead.Fid headId, account.Fid accountId,acMapAccount.FIsMapAccount isMapAccount,groupHead.sumbillCrebit sumbillCrebit, \n");
        if (isAccount) {
            sql.append("accountView1.Fid accountViewId, accountView2.Fid tarAccountViewId, \n");
        }
        sql.append("account.FItemNumber itemNumber, account.FBalType balType, account.FDataElement dataElement, \n");
        sql.append("account.FItemName itemName \n");
        sql.append("from T_Csl_CheckageAccount account \n");
        sql.append("inner join T_Csl_AccountAndMapAccount acMapAccount on acMapAccount.FCheckAccountId=account.Fid \n");
        sql.append("inner join T_Csl_AccountMap acMap on acMap.Fid=acMapAccount.FAccountMapId \n");
        sql.append("inner join T_Csl_CheckageBillHead billHead on billHead.FAccountMapId=acMap.Fid \n");
        if (isAccount) {
            sql.append("inner join T_Csl_CheckageBill bill on bill.FBillHeadId=billHead.Fid \n");
            sql.append("left join T_BD_AccountView accountView1 on bill.FCompanyId=accountView1.FCompanyID and account.FAccountTableid=accountView1.FAccountTableID ");
            sql.append(" and account.FItemNumber=accountView1.Fnumber \n");
            sql.append("left join T_BD_AccountView accountView2 on bill.FTargetCompanyId=accountView2.FCompanyID and account.FAccountTableid=accountView2.FAccountTableID \n");
            sql.append(" and account.FItemNumber=accountView2.Fnumber \n");
        }
        sql.append("inner join (select isnull(sum(rsBill.FDebit),0)-isnull(sum(rsBill.FCredit),0) sumbillCrebit,rsBill.FbillHeadId rsHeadId from T_CSL_CheckageBill rsBill \n");
        sql.append("where rsBill.FbillHeadId in \n", needUpdateDiffItemHeadIdSet);
        sql.append("group by rsBill.FbillHeadId) groupHead on groupHead.rsHeadId=billHead.Fid and groupHead.sumbillCrebit<>0 \n");
        sql.append("where acMapAccount.FDataSource=? \n", 2);
        sql.append("and billHead.Fid in \n", needUpdateDiffItemHeadIdSet);
        sql.append(") rs on rs.headId=bill1.FBillHeadId \n");
        sql.append("where bill1.FBillHeadId in \n", needUpdateDiffItemHeadIdSet);
        sql.append("order by bill1.FBillHeadId, billCompany1.FConfirmStatus desc");
        IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (row != null && row.size() > 0) {
            CoreBaseCollection addNewBillCol = new CoreBaseCollection();
            CoreBaseCollection addNewBillCompanyCol = new CoreBaseCollection();
            String preHeadId = "";
            String preCompanyId = "";
            String preTarCompanyId = "";
            String preBillCompanyId = "";
            String preAccountViewId = "";
            String preTarAccountViewId = "";
            String preItemNumber = "";
            String preItemName = "";
            String preAccountId = "";
            String preSchmId = "";
            String preCurrencyId = "";
            int preBalType = 0;
            int preYear = 0;
            int prePeriod = 0;
            int preDataElement = 0;
            BigDecimal preValue = null;
            boolean preIsIncludingUnposted = false;
            boolean preIsSameDirect = false;
            int preConfirmStatus = -1;
            String headId = "";
            String companyId = "";
            String tarCompanyId = "";
            String billCompanyId = "";
            String accountViewId = "";
            String tarAccountViewId = "";
            String itemNumber = "";
            String itemName = "";
            String accountId = "";
            String schmId = "";
            int confirmStatus = -1;
            String currencyId = "";
            boolean isAdd = false;
            UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
            Timestamp nowTimest = new Timestamp(new Date().getTime());
            CtrlUnitInfo cu = new CtrlUnitInfo();
            cu.setId(BOSUuid.read((String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
            CheckageBillCompanyInfo billCompanyInfo = new CheckageBillCompanyInfo();
            while (row.next()) {
                boolean isSameDirect;
                headId = row.getString("headId");
                companyId = row.getString("companyId");
                tarCompanyId = row.getString("tarCompanyId");
                billCompanyId = row.getString("billCompanyId");
                confirmStatus = row.getInt("confirmStatus");
                if (isAccount) {
                    accountViewId = row.getString("accountViewId");
                    tarAccountViewId = row.getString("tarAccountViewId");
                }
                itemNumber = row.getString("itemNumber");
                itemName = row.getString("itemName");
                accountId = row.getString("accountId");
                schmId = row.getString("schmId");
                currencyId = row.getString("currencyId");
                int balType = row.getInt("balType");
                int year = row.getInt("year");
                int period = row.getInt("period");
                int dataElement = row.getInt("dataElement");
                BigDecimal value = row.getBigDecimal("sumbillCrebit");
                boolean isIncludingUnposted = row.getBoolean("FISINCLUDINGUNPOSTED");
                boolean billIsMapAccount = row.getBoolean("billIsMapAccount");
                boolean isMapAccount = row.getBoolean("isMapAccount");
                boolean bl = isSameDirect = billIsMapAccount && isMapAccount || !billIsMapAccount && !isMapAccount;
                if (!preHeadId.equals(headId)) {
                    if (!"".equals(preHeadId) && !isAdd && (preIsSameDirect && 1 != preConfirmStatus || !preIsSameDirect)) {
                        String company = preIsSameDirect ? preCompanyId : preTarCompanyId;
                        String tarCompany = preIsSameDirect ? preTarCompanyId : preCompanyId;
                        String billCompany = preIsSameDirect ? preBillCompanyId : BOSUuid.create((BOSObjectType)billCompanyInfo.getBOSType()).toString();
                        String accountView = preIsSameDirect ? preAccountViewId : preTarAccountViewId;
                        this.addNewBill(updateHeadBillDiffSet, addNewBillCompanyCol, addNewBillCol, isAccount, preValue, company, tarCompany, currencyId, billCompany, preSchmId, preAccountId, preHeadId, accountView, preItemNumber, preYear, prePeriod, preBalType, preDataElement, preIsIncludingUnposted, itemTypeEnum, preItemName, user, nowTimest, cu);
                    }
                    isAdd = false;
                }
                try {
                    if (isAdd) continue;
                    if (1 == confirmStatus) {
                        if (!isSameDirect) continue;
                        isAdd = true;
                        continue;
                    }
                    if (!isSameDirect) {
                        if (!preHeadId.equals(headId) || preBillCompanyId.equals(billCompanyId)) continue;
                        isAdd = true;
                        continue;
                    }
                    this.addNewBill(updateHeadBillDiffSet, addNewBillCompanyCol, addNewBillCol, isAccount, value, companyId, tarCompanyId, currencyId, billCompanyId, schmId, accountId, headId, accountViewId, itemNumber, year, period, balType, dataElement, isIncludingUnposted, itemTypeEnum, itemName, user, nowTimest, cu);
                    isAdd = true;
                }
                finally {
                    preHeadId = headId;
                    preCompanyId = companyId;
                    preTarCompanyId = tarCompanyId;
                    preBillCompanyId = billCompanyId;
                    preAccountViewId = accountViewId;
                    preTarAccountViewId = tarAccountViewId;
                    preItemNumber = itemNumber;
                    preItemName = itemName;
                    preAccountId = accountId;
                    preSchmId = schmId;
                    preCurrencyId = currencyId;
                    preBalType = balType;
                    preYear = year;
                    prePeriod = period;
                    preDataElement = dataElement;
                    preValue = value;
                    preIsIncludingUnposted = isIncludingUnposted;
                    preIsSameDirect = isSameDirect;
                    preConfirmStatus = confirmStatus;
                }
            }
            if (!"".equals(preHeadId) && !isAdd && (preIsSameDirect && 1 != preConfirmStatus || !preIsSameDirect)) {
                String company = preIsSameDirect ? preCompanyId : preTarCompanyId;
                String tarCompany = preIsSameDirect ? preTarCompanyId : preCompanyId;
                String billCompany = preIsSameDirect ? preBillCompanyId : BOSUuid.create((BOSObjectType)billCompanyInfo.getBOSType()).toString();
                String accountView = preIsSameDirect ? preAccountViewId : preTarAccountViewId;
                this.addNewBill(updateHeadBillDiffSet, addNewBillCompanyCol, addNewBillCol, isAccount, preValue, company, tarCompany, currencyId, billCompany, preSchmId, preAccountId, preHeadId, accountView, preItemNumber, preYear, prePeriod, preBalType, preDataElement, preIsIncludingUnposted, itemTypeEnum, preItemName, user, nowTimest, cu);
            }
            if (!addNewBillCompanyCol.isEmpty()) {
                CheckageBillCompanyFactory.getLocalInstance(ctx).saveBatchData(addNewBillCompanyCol);
            }
            if (!addNewBillCol.isEmpty()) {
                CheckageBillFactory.getLocalInstance(ctx).saveBatchData(addNewBillCol);
            }
        }
    }

    private void addNewBill(Set<String> updateHeadBillDiffSet, CoreBaseCollection addNewBillCompanyCol, CoreBaseCollection addNewBillCol, boolean isAccount, BigDecimal value, String companyId, String tarCompanyId, String currencyId, String billCompanyId, String schmId, String accountId, String headId, String accountViewId, String itemNumber, int year, int period, int balType, int dataElement, boolean isIncludingUnposted, ItemTypeEnum itemTypeEnum, String itemName, UserInfo user, Timestamp nowTimest, CtrlUnitInfo cu) throws UuidException, SQLException {
        BigDecimal credit;
        BigDecimal debit;
        if (isAccount && StringUtils.isEmpty((String)accountViewId)) {
            return;
        }
        updateHeadBillDiffSet.add(headId);
        CheckageBillCompanyInfo billCompanyInfo = new CheckageBillCompanyInfo();
        billCompanyInfo.setId(BOSUuid.read((String)billCompanyId));
        billCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
        if (!StringUtils.isEmpty((String)schmId)) {
            billCompanyInfo.setPackSchmId(schmId);
        }
        CheckageAccountInfo cAccountInfo = new CheckageAccountInfo();
        cAccountInfo.setId(BOSUuid.read((String)accountId));
        CheckageBillHeadInfo billheadInfo = new CheckageBillHeadInfo();
        billheadInfo.setId(BOSUuid.read((String)headId));
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setId(BOSUuid.read((String)currencyId));
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        CompanyOrgUnitInfo tarCompany = new CompanyOrgUnitInfo();
        tarCompany.setId(BOSUuid.read((String)tarCompanyId));
        CheckageBillInfo checkageBillInfo = new CheckageBillInfo();
        checkageBillInfo.setId(BOSUuid.create((BOSObjectType)checkageBillInfo.getBOSType()));
        checkageBillInfo.setYear(year);
        checkageBillInfo.setPeriod(period);
        checkageBillInfo.setCurrency(currencyInfo);
        checkageBillInfo.setCompany(company);
        checkageBillInfo.setTargetCompany(tarCompany);
        if (isAccount) {
            AccountViewInfo accountView = new AccountViewInfo();
            accountView.setId(BOSUuid.read((String)accountViewId));
            accountView.setNumber(itemNumber);
            checkageBillInfo.setAccount(accountView);
            checkageBillInfo.setBalType(BalTypeEnum.getEnum(balType));
            checkageBillInfo.setDataElement(balType);
        } else {
            checkageBillInfo.setDataElement(dataElement);
        }
        if (value.compareTo(BigDecimal.ZERO) > 0) {
            debit = null;
            credit = value.abs();
        } else {
            debit = value.abs();
            credit = null;
        }
        checkageBillInfo.setDebit(debit);
        checkageBillInfo.setCredit(credit);
        checkageBillInfo.setConfirmDebit(debit);
        checkageBillInfo.setConfirmCredit(credit);
        checkageBillInfo.setAuditDebit(debit);
        checkageBillInfo.setAuditCredit(credit);
        checkageBillInfo.setBillCompany(billCompanyInfo);
        checkageBillInfo.setBillHead(billheadInfo);
        checkageBillInfo.setIsIncludingUnPosted(isIncludingUnposted);
        checkageBillInfo.setItemType(itemTypeEnum);
        checkageBillInfo.setItemNumber(itemNumber);
        checkageBillInfo.setItemName(itemName);
        checkageBillInfo.setDataSource(DataSourceEnum.diff);
        checkageBillInfo.setCheckAccount(cAccountInfo);
        checkageBillInfo.setSrcBillId("z");
        checkageBillInfo.setCreator(user);
        checkageBillInfo.setCreateTime(nowTimest);
        checkageBillInfo.setLastUpdateUser(user);
        checkageBillInfo.setLastUpdateTime(nowTimest);
        checkageBillInfo.setCU(cu);
        addNewBillCol.add((CoreBaseInfo)checkageBillInfo);
        addNewBillCompanyCol.add((CoreBaseInfo)billCompanyInfo);
    }

    private String queryCompanyTemTable(Context ctx, TempTablePool tmpTablePool, int tempCriticalNum, Set<String> hasPermissionCompanyOrgIdSet, Set<String> hasDataOrgSet, Set tarAccountCheckCompanyIdSet, Set<String> orgUnitRangeIdSet, Set<String> ownOrgUnitRangeIdSet, Set<String> tarOrgUnitRangeIdSet) throws BOSException {
        String string;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            SQLBuilder sql = new SQLBuilder();
            sql.append("create table t_csl_tempCheckBill2(fid varchar(44), ftype int)");
            String companyOrgTempTable = tmpTablePool.createTempTable(sql.getSQL());
            tmpTablePool.createIndex(companyOrgTempTable, "type", false, false);
            String insetSql = "insert into " + companyOrgTempTable + " values(?,?)";
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(insetSql);
            if (hasPermissionCompanyOrgIdSet != null && hasPermissionCompanyOrgIdSet.size() >= tempCriticalNum) {
                this.insertTempData(ps, hasPermissionCompanyOrgIdSet, 1);
            }
            if (hasDataOrgSet != null && hasDataOrgSet.size() >= tempCriticalNum) {
                this.insertTempData(ps, hasDataOrgSet, 2);
            }
            if (tarAccountCheckCompanyIdSet != null && tarAccountCheckCompanyIdSet.size() >= tempCriticalNum) {
                this.insertTempData(ps, tarAccountCheckCompanyIdSet, 3);
            }
            if (orgUnitRangeIdSet != null && orgUnitRangeIdSet.size() >= tempCriticalNum) {
                this.insertTempData(ps, orgUnitRangeIdSet, 4);
            }
            if (ownOrgUnitRangeIdSet != null && ownOrgUnitRangeIdSet.size() >= tempCriticalNum) {
                this.insertTempData(ps, ownOrgUnitRangeIdSet, 5);
            }
            if (tarOrgUnitRangeIdSet != null && tarOrgUnitRangeIdSet.size() >= tempCriticalNum) {
                this.insertTempData(ps, tarOrgUnitRangeIdSet, 6);
            }
            string = companyOrgTempTable;
        }
        catch (Exception e) {
            try {
                logger.error((Object)"queryCompanyTemTable_error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return string;
    }

    private void insertTempData(PreparedStatement ps, Set<String> orgIdSet, int type) throws SQLException {
        for (String orgId : orgIdSet) {
            ps.setObject(1, orgId);
            ps.setObject(2, type);
            ps.addBatch();
        }
        ps.executeBatch();
        ps.clearBatch();
    }

    private Map getLastPackInfo(Context ctx, int year, int period, String currencyId, Set comapnySet, String companyTempTable, ItemTypeEnum itemTypeEnum) throws BOSException, SQLException {
        HashMap<String, CheckageOrgPackInfo> companyAndPackInfoMap = new HashMap<String, CheckageOrgPackInfo>();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select Fid,FPackTime,FCompanyId from T_Csl_CheckageOrgPack \n");
        sql.append("where FYear=?    \n", year);
        sql.append("and FPeriod=?    \n", period);
        sql.append("and FCurrencyId=?  \n", currencyId);
        if (!StringUtils.isEmpty((String)companyTempTable)) {
            sql.append("and FCompanyId in (select id from ").append(companyTempTable).append(" ) \n");
        } else {
            sql.append("and FCompanyId in  \n", comapnySet);
        }
        sql.append("and FItemType=?  \n", itemTypeEnum.getValue());
        sql.append("order by FPackTime desc");
        IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (row != null && row.size() > 0) {
            while (row.next()) {
                CheckageOrgPackInfo packInfo = new CheckageOrgPackInfo();
                packInfo.setPackTime(row.getTimestamp("FPackTime"));
                packInfo.setId(BOSUuid.read((String)row.getString("Fid")));
                companyAndPackInfoMap.put(row.getString("FCompanyId"), packInfo);
            }
        }
        return companyAndPackInfoMap;
    }

    @Override
    protected AccountCheckWorkeFilterInfo _fetchAccountCheckageBill(Context ctx, AccountCheckWorkeFilterInfo filterInfo) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        Map fetchAccountData = this.fetchAccountData(ctx, filterInfo, null);
        AccountCheckWorkeFilterInfo resultFilterInfo = (AccountCheckWorkeFilterInfo)fetchAccountData.get("filterInfo");
        logger.error((Object)("fetchDataCostTime:" + (System.currentTimeMillis() - startTime)));
        return resultFilterInfo;
    }

    @Override
    protected AccountCheckWorkeFilterInfo _queryAccountCheckageBill(Context ctx, AccountCheckWorkeFilterInfo filterInfo) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        AccountCheckWorkeFilterInfo resultFilterInfo = this.queryAccountData(ctx, filterInfo);
        logger.error((Object)("queryAccountCheckageBillCostTime:" + (System.currentTimeMillis() - startTime)));
        return resultFilterInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AccountCheckWorkeFilterInfo queryAccountData(Context ctx, AccountCheckWorkeFilterInfo filterInfo) throws BOSException {
        String companyOrgTempTable;
        String billTmpTable;
        TempTablePool tmpTablePool;
        block58: {
            Object updateStSql;
            block56: {
                block57: {
                    tmpTablePool = null;
                    billTmpTable = null;
                    String fetchTmpTable = null;
                    companyOrgTempTable = null;
                    try {
                        ItemTypeEnum itemTypeEnum;
                        tmpTablePool = TempTablePool.getInstance((Context)ctx);
                        if (!StringUtils.isEmpty((String)filterInfo.getTmpTable())) {
                            tmpTablePool.releaseTable(filterInfo.getTmpTable());
                        }
                        if ((itemTypeEnum = filterInfo.getItemTypeEnum()) == null) {
                            itemTypeEnum = ItemTypeEnum.account;
                        }
                        boolean isAccountType = ItemTypeEnum.account == itemTypeEnum;
                        int year = filterInfo.getYear();
                        int period = filterInfo.getPeriod();
                        String currencyId = filterInfo.getCurrencyId();
                        Set tarAccountCheckCompanyIdSet = filterInfo.getTarAccountCheckCompanyIdSet();
                        boolean queryAllData = filterInfo.isQueryAllData();
                        String accountCheckCompanyId = filterInfo.getAccountCheckCompanyId();
                        HashSet<String> hasPermissionCompanyOrgIdSet = new HashSet<String>(filterInfo.getHasOrgPermissionCompanyIdSet());
                        Set<String> hasDataOrgSet = filterInfo.getHasDataOrgSet();
                        Set haveDataCompanySet = this.haveDataCompanySet(ctx, year, period, currencyId, hasDataOrgSet, itemTypeEnum);
                        if (haveDataCompanySet.isEmpty()) {
                            filterInfo.clear();
                            filterInfo.setHavaData(false);
                            AccountCheckWorkeFilterInfo accountCheckWorkeFilterInfo = filterInfo;
                            return accountCheckWorkeFilterInfo;
                        }
                        String lang = ctx.getLocale().getLanguage();
                        SQLBuilder sql = new SQLBuilder();
                        sql.reset();
                        if (isAccountType) {
                            sql.append("create table t_csl_tempCheckBill(seq int, billId varchar(44), billBillCompanyId varchar(44), accountMapId varchar(44),accountMapNumber nvarchar(80), billHeadId varchar(44), ");
                            sql.append("billHeadNumber nvarchar(80), billCompanyId varchar(44), companyName nvarchar(255),companyNumber nvarchar(80), tarBillCompanyId varchar(44), ");
                            sql.append("tarCompanyName nvarchar(255), tarcompanyNumber nvarchar(80),accountViewId varchar(44),accountViewNumber nvarchar(80), ");
                            sql.append("accountViewName nvarchar(255), billBalType int, billCurrencyId varchar(44), billCurrencyName nvarchar(255),currencyNumber nvarchar(80),companyKey varchar(88),");
                            sql.append("billDebit NUMERIC(21,6), billCredit NUMERIC(21,6), billConfirmDebit NUMERIC(21,6), billConfirmCredit NUMERIC(21,6),  ");
                            sql.append("billAuditDebit NUMERIC(21,6), billAuditCredit NUMERIC(21,6), billHeadCompanyDiff NUMERIC(21,6),  ");
                            sql.append("billCompanyDiffRemark nvarchar(2000), billCompanyConfirmorId varchar(44), confirmorName nvarchar(255),billCompanyConfirmTime DateTime, dataChange int, tarDataChange int,");
                            sql.append("billCompanyConfirmSt int,tarbillCompanyConfirmSt int, billHeadAuditedStatus int, accountDirectSeq int,isIncludingUnPosted int, billItemType int, dataSource int, remark nvarchar(2000), companySeq int)");
                        } else {
                            sql.append("create table t_csl_tempCheckBill2(seq int, billId varchar(44), billBillCompanyId varchar(44), accountMapId varchar(44),accountMapNumber nvarchar(80), billHeadId varchar(44), ");
                            sql.append("billHeadNumber nvarchar(80), billCompanyId varchar(44), companyName nvarchar(255),companyNumber nvarchar(80), tarBillCompanyId varchar(44), ");
                            sql.append("tarCompanyName nvarchar(255), tarcompanyNumber nvarchar(80),itemNumber nvarchar(80),itemName nvarchar(255), ");
                            sql.append("billDataElement int, billCurrencyId varchar(44), billCurrencyName nvarchar(255),currencyNumber nvarchar(80),companyKey varchar(88),");
                            sql.append("billDebit NUMERIC(21,6), billCredit NUMERIC(21,6), billConfirmDebit NUMERIC(21,6), billConfirmCredit NUMERIC(21,6),  ");
                            sql.append("billAuditDebit NUMERIC(21,6), billAuditCredit NUMERIC(21,6), billHeadCompanyDiff NUMERIC(21,6),  ");
                            sql.append("billCompanyDiffRemark nvarchar(2000), billCompanyConfirmorId varchar(44), confirmorName nvarchar(255),billCompanyConfirmTime DateTime, dataChange int, tarDataChange int,");
                            sql.append("billCompanyConfirmSt int,tarbillCompanyConfirmSt int, billHeadAuditedStatus int, accountDirectSeq int,isIncludingUnPosted int, billItemType int, dataSource int, remark nvarchar(2000), companySeq int)");
                        }
                        billTmpTable = tmpTablePool.createTempTable(sql.getSQL());
                        Set<String> orgUnitRangeIdSet = filterInfo.getOrgUnitRangeIdSet();
                        Set<String> ownOrgUnitRangeIdSet = filterInfo.getOwnOrgUnitRangeIdSet();
                        Set<String> tarOrgUnitRangeIdSet = filterInfo.getTarOrgUnitRangeIdSet();
                        int tempCriticalNum = filterInfo.getTempCriticalNum();
                        if (hasPermissionCompanyOrgIdSet != null && hasPermissionCompanyOrgIdSet.size() >= tempCriticalNum || hasDataOrgSet != null && hasDataOrgSet.size() >= tempCriticalNum || tarAccountCheckCompanyIdSet != null && tarAccountCheckCompanyIdSet.size() >= tempCriticalNum || orgUnitRangeIdSet != null && orgUnitRangeIdSet.size() >= tempCriticalNum || ownOrgUnitRangeIdSet != null && ownOrgUnitRangeIdSet.size() >= tempCriticalNum || tarOrgUnitRangeIdSet != null && tarOrgUnitRangeIdSet.size() >= tempCriticalNum) {
                            companyOrgTempTable = this.queryCompanyTemTable(ctx, tmpTablePool, tempCriticalNum, hasPermissionCompanyOrgIdSet, hasDataOrgSet, tarAccountCheckCompanyIdSet, orgUnitRangeIdSet, ownOrgUnitRangeIdSet, tarOrgUnitRangeIdSet);
                        }
                        sql.reset();
                        if (isAccountType) {
                            sql.append("insert into ").append(billTmpTable).append("(seq, billId, billBillCompanyId, accountMapId,accountMapNumber, billHeadId, billHeadNumber, billCompanyId, companyName, companyNumber, \n");
                            sql.append("tarBillCompanyId,tarCompanyName,tarcompanyNumber, accountViewId, accountViewNumber, accountViewName, billBalType, billCurrencyId,billCurrencyName,currencyNumber, companyKey, \n");
                            sql.append("billDebit, billCredit, billConfirmDebit, billConfirmCredit, billAuditDebit, billAuditCredit,billHeadCompanyDiff, billCompanyDiffRemark, billCompanyConfirmorId,  \n");
                            sql.append("confirmorName, billCompanyConfirmTime,dataChange,tarDataChange, billCompanyConfirmSt, tarbillCompanyConfirmSt, billHeadAuditedStatus ,accountDirectSeq,isIncludingUnPosted, billItemType, dataSource, remark, companySeq)  \n");
                            if (companyOrgTempTable != null && hasPermissionCompanyOrgIdSet != null && hasPermissionCompanyOrgIdSet.size() >= tempCriticalNum) {
                                sql.append("select case when bill.FCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=1) \n");
                            } else {
                                sql.append("select case when bill.FCompanyId in ", hasPermissionCompanyOrgIdSet);
                            }
                            sql.append(" then 0 else 1 end seq, bill.Fid billId, bill.FBillCompanyId billBillCompanyId,billhead.FAccountMapId accountMapId,acMap.Fnumber accountMapNumber, \n");
                            sql.append("bill.FBillHeadId billHeadId,billhead.Fnumber billHeadNumber,bill.FCompanyId billCompanyId,company.fname_").append(lang).append(" companyName,  \n");
                            sql.append("company.Fnumber companyNumber,bill.FTargetCompanyId tarBillCompanyId,tarcompany.fname_").append(lang).append(" tarCompanyName ,tarcompany.Fnumber tarcompanyNumber,\n");
                            sql.append("bill.FAccountId accountViewId,accountView.Fnumber accountViewNumber,accountView.Fname_").append(lang).append(" accountViewName,  \n");
                            sql.append("bill.FBalType billBalType,bill.FCurrencyId billCurrencyId, currency.Fname_").append(lang).append(" billCurrencyName ,currency.Fnumber currencyNumber,  \n");
                            sql.append("case when bill.FCompanyId>bill.FTargetCompanyId then concat(bill.FCompanyId, bill.FTargetCompanyId) else concat(bill.FTargetCompanyId,bill.FCompanyId) end companyKey,   \n");
                            sql.append("bill.FDebit billDebit,bill.FCredit billCredit,bill.FConfirmDebit billConfirmDebit,bill.FConfirmCredit billConfirmCredit,bill.FAuditDebit billAuditDebit,bill.FAuditCredit billAuditCredit, \n");
                            sql.append("billhead.FCompanyDiff billHeadCompanyDiff, checkageBillCompany.FDiffRemark billCompanyDiffRemark,checkageBillCompany.FConfirmorId billCompanyConfirmorId, \n");
                            sql.append("confirmUser.FNAME_").append(lang).append(" confirmorName,checkageBillCompany.FConfirmTime billCompanyConfirmTime,checkageBillCompany.FTag dataChange,0 tarDataChange,   \n");
                            sql.append("checkageBillCompany.FConfirmStatus billCompanyConfirmSt,-1 tarbillCompanyConfirmSt,billhead.FAuditedStatus billHeadAuditedStatus,   \n");
                            sql.append("accountDirect.fseq accountDirectSeq,bill.FIsIncludingUnPosted isIncludingUnPosted,bill.FItemType,bill.FDataSource,bill.FRemark,   \n");
                            if (!queryAllData && !StringUtils.isEmpty((String)accountCheckCompanyId)) {
                                sql.append("case when bill.FCompanyId=? ", accountCheckCompanyId);
                                sql.append(" then 0 else 1 end companySeq \n");
                            } else {
                                sql.append(" 0 companySeq  \n");
                            }
                            sql.append("from T_Csl_CheckageBill bill   \n");
                            sql.append("inner join T_ORG_Company company on company.fid=bill.FCompanyId   \n");
                            sql.append("inner join T_ORG_Company tarcompany on tarcompany.fid=bill.FTargetCompanyId   \n");
                            sql.append("inner join T_BD_Currency currency on currency.fid=bill.FCurrencyId   \n");
                            sql.append("inner join T_BD_AccountView accountView on accountView.Fid=bill.FAccountId   \n");
                            sql.append("inner join T_Csl_CheckageBillHead billhead on billhead.fid=bill.FBillHeadId   \n");
                            sql.append("inner join T_Csl_AccountMap acMap on acMap.fid=billhead.FAccountMapId   \n");
                            sql.append("inner join T_Csl_CheckageBillCompany checkageBillCompany on checkageBillCompany.fid=bill.FBillCompanyId   \n");
                            sql.append("inner join T_Csl_AccountAndMapAccount accountDirect on accountDirect.FAccountMapId=billhead.FAccountMapId   \n");
                            sql.append("inner join T_Csl_CheckageAccount checkageAccount on accountDirect.FCheckAccountId=checkageAccount.Fid and checkageAccount.FItemNumber=accountView.Fnumber and checkageAccount.FBalType=bill.FBalType \n");
                            sql.append("left join T_PM_User confirmUser on confirmUser.FId=checkageBillCompany.FConfirmorId   \n");
                        } else {
                            sql.append("insert into ").append(billTmpTable).append("(seq, billId, billBillCompanyId, accountMapId, accountMapNumber,billHeadId, billHeadNumber, billCompanyId, companyName, companyNumber, \n");
                            sql.append("tarBillCompanyId,tarCompanyName,tarcompanyNumber, itemNumber,itemName, billDataElement, billCurrencyId,billCurrencyName,currencyNumber, companyKey, \n");
                            sql.append("billDebit, billCredit, billConfirmDebit, billConfirmCredit, billAuditDebit, billAuditCredit,billHeadCompanyDiff, billCompanyDiffRemark, billCompanyConfirmorId,  \n");
                            sql.append("confirmorName, billCompanyConfirmTime,dataChange,tarDataChange , billCompanyConfirmSt, tarbillCompanyConfirmSt, billHeadAuditedStatus ,accountDirectSeq,isIncludingUnPosted, billItemType, dataSource, remark, companySeq)  \n");
                            if (companyOrgTempTable != null && hasPermissionCompanyOrgIdSet != null && hasPermissionCompanyOrgIdSet.size() >= tempCriticalNum) {
                                sql.append("select case when bill.FCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=1) \n");
                            } else {
                                sql.append("select case when bill.FCompanyId in ", hasPermissionCompanyOrgIdSet);
                            }
                            sql.append("then 0 else 1 end seq, bill.Fid billId, bill.FBillCompanyId billBillCompanyId,billhead.FAccountMapId accountMapId, acMap.Fnumber accountMapNumber, \n");
                            sql.append("bill.FBillHeadId billHeadId,billhead.Fnumber billHeadNumber,bill.FCompanyId billCompanyId,company.fname_").append(lang).append(" companyName,  \n");
                            sql.append("company.Fnumber companyNumber,bill.FTargetCompanyId tarBillCompanyId,tarcompany.fname_").append(lang).append(" tarCompanyName ,tarcompany.Fnumber tarcompanyNumber,\n");
                            sql.append("bill.FItemNumber itemNumber,bill.FItemName itemName,bill.FDataElement billDataElement,bill.FCurrencyId billCurrencyId,  \n");
                            sql.append("currency.Fname_").append(lang).append(" billCurrencyName ,currency.Fnumber currencyNumber,  \n");
                            sql.append("case when bill.FCompanyId>bill.FTargetCompanyId then concat(bill.FCompanyId, bill.FTargetCompanyId) else concat(bill.FTargetCompanyId,bill.FCompanyId) end companyKey,   \n");
                            sql.append("bill.FDebit billDebit,bill.FCredit billCredit,bill.FConfirmDebit billConfirmDebit,bill.FConfirmCredit billConfirmCredit,bill.FAuditDebit billAuditDebit,bill.FAuditCredit billAuditCredit, \n");
                            sql.append("billhead.FCompanyDiff billHeadCompanyDiff, checkageBillCompany.FDiffRemark billCompanyDiffRemark,checkageBillCompany.FConfirmorId billCompanyConfirmorId, \n");
                            sql.append("confirmUser.FNAME_").append(lang).append(" confirmorName,checkageBillCompany.FConfirmTime billCompanyConfirmTime,checkageBillCompany.FTag dataChange,0 tarDataChange ,   \n");
                            sql.append("checkageBillCompany.FConfirmStatus billCompanyConfirmSt,-1 tarbillCompanyConfirmSt,billhead.FAuditedStatus billHeadAuditedStatus,   \n");
                            sql.append("accountDirect.fseq accountDirectSeq,bill.FIsIncludingUnPosted isIncludingUnPosted,bill.FItemType,bill.FDataSource,bill.FRemark,   \n");
                            if (!queryAllData && !StringUtils.isEmpty((String)accountCheckCompanyId)) {
                                sql.append("case when bill.FCompanyId=? ", accountCheckCompanyId);
                                sql.append(" then 0 else 1 end companySeq \n");
                            } else {
                                sql.append(" 0 companySeq  \n");
                            }
                            sql.append("from T_Csl_CheckageBill bill   \n");
                            sql.append("inner join T_ORG_Company company on company.fid=bill.FCompanyId   \n");
                            sql.append("inner join T_ORG_Company tarcompany on tarcompany.fid=bill.FTargetCompanyId   \n");
                            sql.append("inner join T_BD_Currency currency on currency.fid=bill.FCurrencyId   \n");
                            sql.append("inner join T_Csl_CheckageBillHead billhead on billhead.fid=bill.FBillHeadId   \n");
                            sql.append("inner join T_Csl_AccountMap acMap on acMap.fid=billhead.FAccountMapId   \n");
                            sql.append("inner join T_Csl_CheckageBillCompany checkageBillCompany on checkageBillCompany.fid=bill.FBillCompanyId   \n");
                            sql.append("inner join T_Csl_AccountAndMapAccount accountDirect on accountDirect.FAccountMapId=billhead.FAccountMapId   \n");
                            sql.append("inner join T_Csl_CheckageAccount checkageAccount on accountDirect.FCheckAccountId=checkageAccount.Fid and checkageAccount.FItemNumber=bill.FItemNumber and checkageAccount.FDataElement=bill.FDataElement \n");
                            sql.append("left join T_PM_User confirmUser on confirmUser.FId=checkageBillCompany.FConfirmorId   \n");
                        }
                        sql.append("where bill.FYear=?  \n", year);
                        sql.append("and bill.FPeriod=?  \n", period);
                        sql.append("and bill.FCurrencyId=?  \n", currencyId);
                        if (tarAccountCheckCompanyIdSet != null && tarAccountCheckCompanyIdSet.size() > 0) {
                            if (companyOrgTempTable != null && hasDataOrgSet != null && hasDataOrgSet.size() >= tempCriticalNum) {
                                sql.append("and ((bill.FCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=2) \n");
                            } else {
                                sql.append("and ((bill.FCompanyId in\t\t\n", hasDataOrgSet);
                            }
                            if (companyOrgTempTable != null && tarAccountCheckCompanyIdSet.size() >= tempCriticalNum) {
                                sql.append("and bill.FTargetCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=3) \n");
                                sql.append(") or (bill.FCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=3) \n");
                            } else {
                                sql.append("and bill.FTargetCompanyId in\t\n", tarAccountCheckCompanyIdSet);
                                sql.append(") or (bill.FCompanyId in\t\t\n", tarAccountCheckCompanyIdSet);
                            }
                            if (companyOrgTempTable != null && hasDataOrgSet != null && hasDataOrgSet.size() >= tempCriticalNum) {
                                sql.append("and bill.FTargetCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=2) \n");
                            } else {
                                sql.append("and bill.FTargetCompanyId in\t\n", hasDataOrgSet);
                            }
                            sql.append("))  \n");
                        } else {
                            if (companyOrgTempTable != null && hasDataOrgSet != null && hasDataOrgSet.size() >= tempCriticalNum) {
                                sql.append("and (bill.FCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=2) \n");
                                sql.append("or bill.FTargetCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=2) \n");
                            } else {
                                sql.append("and (bill.FCompanyId in\t\t\n", hasDataOrgSet);
                                sql.append("or bill.FTargetCompanyId in\t", hasDataOrgSet);
                            }
                            sql.append(")  \n");
                        }
                        if (orgUnitRangeIdSet != null && !orgUnitRangeIdSet.isEmpty()) {
                            if (companyOrgTempTable != null && orgUnitRangeIdSet.size() >= tempCriticalNum) {
                                sql.append("and bill.FCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=4) \n");
                                sql.append("and bill.FTargetCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=4) \n");
                            } else {
                                sql.append("and bill.FCompanyId in\t\t\n", orgUnitRangeIdSet);
                                sql.append("and bill.FTargetCompanyId in\t\t\n", orgUnitRangeIdSet);
                            }
                        } else if (ownOrgUnitRangeIdSet != null && !ownOrgUnitRangeIdSet.isEmpty() && tarOrgUnitRangeIdSet != null && !tarOrgUnitRangeIdSet.isEmpty()) {
                            if (companyOrgTempTable != null && ownOrgUnitRangeIdSet.size() >= tempCriticalNum) {
                                sql.append("and ((bill.FCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=5) \n");
                            } else {
                                sql.append("and ((bill.FCompanyId in\t\t\n", ownOrgUnitRangeIdSet);
                            }
                            if (companyOrgTempTable != null && tarOrgUnitRangeIdSet.size() >= tempCriticalNum) {
                                sql.append("and bill.FTargetCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=6) \n");
                                sql.append(") or (bill.FCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=6) \n");
                            } else {
                                sql.append("and bill.FTargetCompanyId in\t\n", tarOrgUnitRangeIdSet);
                                sql.append(") or (bill.FCompanyId in\t\t\n", tarOrgUnitRangeIdSet);
                            }
                            if (companyOrgTempTable != null && ownOrgUnitRangeIdSet.size() >= tempCriticalNum) {
                                sql.append("and bill.FTargetCompanyId in (select temp.FID from ").append(companyOrgTempTable).append(" temp where temp.ftype=5) \n");
                            } else {
                                sql.append("and bill.FTargetCompanyId in\t\n", ownOrgUnitRangeIdSet);
                            }
                            sql.append("))  \n");
                        }
                        sql.append("and bill.FItemType=?  \n", itemTypeEnum.getValue());
                        sql.append("order by accountMapId,companyKey,companySeq,billHeadId,accountDirectSeq");
                        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                        sql.reset();
                        sql.append("select rs1.BILLID,rs2.BILLCOMPANYCONFIRMST tarBILLCOMPANYCONFIRMST,rs2.dataChange tarDataChange from ").append(billTmpTable).append("  rs1  \n");
                        sql.append("inner join  ").append(billTmpTable).append(" rs2 on rs1.billHeadId=rs2.billHeadId and rs1.accountMapId=rs2.accountMapId and rs1.companyKey=rs2.companyKey \n");
                        sql.append("where rs1.BILLCOMPANYID<>rs2.BILLCOMPANYID \n");
                        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
                        if (rowSet != null && rowSet.size() > 0) {
                            updateStSql = "update " + billTmpTable + " set tarbillCompanyConfirmSt=?,tarDataChange=? where BILLID=?";
                            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                            while (rowSet.next()) {
                                Object[] params = new Object[]{rowSet.getInt("tarBILLCOMPANYCONFIRMST"), rowSet.getInt("tarDataChange"), rowSet.getString("BILLID")};
                                paramsList.add(params);
                                if (paramsList.size() <= 999) continue;
                                DbUtil.executeBatch(ctx, (String)updateStSql, paramsList);
                                paramsList.clear();
                            }
                            if (paramsList.size() > 0) {
                                DbUtil.executeBatch(ctx, (String)updateStSql, paramsList);
                            }
                        }
                        sql.reset();
                        sql.append("create table t_csl_tempFetchCheckBill2(sumbillConfirmCrebit NUMERIC(21,6), seq int, billId varchar(44), billBillCompanyId varchar(44), accountMapId varchar(44),accountMapNumber nvarchar(80), billHeadId varchar(44), ");
                        sql.append("billHeadNumber nvarchar(80), billCompanyId varchar(44), companyName nvarchar(255),companyNumber nvarchar(80), tarBillCompanyId varchar(44), tarCompanyName nvarchar(255), tarcompanyNumber nvarchar(80),");
                        if (isAccountType) {
                            sql.append("accountViewId varchar(44),accountViewNumber nvarchar(80), accountViewName nvarchar(255), billBalType int, billCurrencyId varchar(44), billCurrencyName nvarchar(255),");
                        } else {
                            sql.append("itemNumber nvarchar(80),itemName nvarchar(255),billDataElement int, billDataElementName nvarchar(255), billCurrencyId varchar(44), billCurrencyName nvarchar(255), ");
                        }
                        sql.append("billDebit NUMERIC(21,6), billCredit NUMERIC(21,6), billConfirmDebit NUMERIC(21,6), billConfirmCredit NUMERIC(21,6),  ");
                        sql.append("billAuditDebit NUMERIC(21,6), billAuditCredit NUMERIC(21,6), billHeadCompanyDiff NUMERIC(21,6), companyKey varchar(88), ");
                        sql.append("billCompanyDiffRemark nvarchar(2000), billCompanyConfirmorId varchar(44), confirmorName nvarchar(255),billCompanyConfirmTime DateTime, dataChange int, tarDataChange int,");
                        sql.append("billCompanyConfirmSt int,tarbillCompanyConfirmSt int, billHeadAuditedStatus int, accountDirectSeq int,isIncludingUnPosted int, itemTypeEnum int, dataSource int, remark nvarchar(2000), companySeq int)");
                        fetchTmpTable = tmpTablePool.createTempTable(sql.getSQL());
                        if (StringUtils.isEmpty((String)fetchTmpTable)) {
                            filterInfo.clear();
                            updateStSql = filterInfo;
                            if (DebugLogger.isDebug) return updateStSql;
                            if (tmpTablePool == null) return updateStSql;
                            if (billTmpTable == null) break block56;
                            break block57;
                        }
                        this.fetchTempData(ctx, filterInfo, billTmpTable, fetchTmpTable, itemTypeEnum);
                        sql.reset();
                        sql.append(" select count(*) from ").append(fetchTmpTable);
                        sql.append(" union all select count(distinct billHeadId) from ").append(fetchTmpTable);
                        rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
                        int maxRow = 0;
                        while (rowSet.next()) {
                            maxRow += rowSet.getInt(1);
                        }
                        filterInfo.setMaxRow(maxRow + 1);
                        filterInfo.setTmpTable(fetchTmpTable);
                        if (DebugLogger.isDebug) return filterInfo;
                        break block58;
                    }
                    catch (Exception e) {
                        logger.error((Object)"_fetchAccountCheckageBill error", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                }
                tmpTablePool.releaseTable(billTmpTable);
            }
            if (companyOrgTempTable == null) return updateStSql;
            tmpTablePool.releaseTable(companyOrgTempTable);
            return updateStSql;
        }
        if (tmpTablePool == null) return filterInfo;
        if (billTmpTable != null) {
            tmpTablePool.releaseTable(billTmpTable);
        }
        if (companyOrgTempTable == null) return filterInfo;
        tmpTablePool.releaseTable(companyOrgTempTable);
        return filterInfo;
        finally {
            if (!DebugLogger.isDebug && tmpTablePool != null) {
                if (billTmpTable != null) {
                    tmpTablePool.releaseTable(billTmpTable);
                }
                if (companyOrgTempTable != null) {
                    tmpTablePool.releaseTable(companyOrgTempTable);
                }
            }
        }
    }

    private void UpdateRptItemTypeBillData(Context ctx, String packId, String srcBillDataTmep, AccountCheckWorkeFilterInfo filterInfo, AutoCheckParams autoCheckParams, ItemTypeEnum itemTypeEnum, String accountCheckCompanyId, Map<String, Map<Integer, Set<String>>> mapIdInfoMap, Set<String> needUpdateDiffItemHeadIdSet) throws Exception {
        HashSet<String> diffItemIdSet = new HashSet<String>();
        int year = filterInfo.getYear();
        int period = filterInfo.getPeriod();
        String currencyId = filterInfo.getCurrencyId();
        String currencyNumber = filterInfo.getCurrencyNumber();
        SQLBuilder sql = new SQLBuilder();
        sql.append("insert into ").append(srcBillDataTmep).append(" (FCompanyId,companyNumber,FTargetCompanyId,tarCompanyNumber,FCkAccountId,FItemNumber,FItemName,FDataElement,FDebit,FCredit,");
        sql.append("FConfirmDebit,FConfirmCredit,FAuditDebit,FAuditCredit,FisIncludeUnPosted,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,mapId,companyKey, ");
        sql.append("seq,acSeq,mapIsFreezed,FSrcBillId,billItemType,dataSource,remark,fimportreportid,fimportsheetname,acMapDataSource) \n");
        sql.append("select src.FCompanyId,src.companyNumber companyNumber,src.FTargetCompanyId,src.tarCompanyNumber tarCompanyNumber,src.ckAccountId ,src.itemNumber,src.itemName,      \n");
        sql.append("src.dataElement,src.FDebit,src.FCredit,src.FConfirmDebit,src.FConfirmCredit,src.FAuditDebit,src.FAuditCredit,      \n");
        sql.append("src.FisIncludeUnPosted,src.FCreatorID,src.FCreateTime FCreateTime,src.FLastUpdateUserID,src.FLastUpdateTime,src.FControlUnitID,      \n");
        sql.append("src.mapId,case when src.FCompanyId<src.FTargetCompanyId then concat(src.FCompanyId, src.FTargetCompanyId) else concat(src.FTargetCompanyId, src.FCompanyId) end companyKey,   \n");
        sql.append("src.seq,src.acSeq,src.isFree isFree,src.srcBillId,src.FItemType,src.dataSource,src.remark,src.fimportreportId,src.fimportsheetname,src.FDataSource  \n");
        sql.append("from    \n");
        sql.append("(select distinct accountMap.Fid mapId,accountMap.FIsFree isFree,case when company.FId=? then 0 else 1 end seq,     \n", accountCheckCompanyId);
        sql.append("accountDirect.Fseq acSeq,accountDirect.FIsMapAccount,billdata.FCompanyId,accountDirect.FDataSource,      \n");
        sql.append("company.Fnumber companyNumber,billdata.FTargetCompanyId,tarcompany.Fnumber tarCompanyNumber,checkageAccount.Fid ckAccountId,      \n");
        sql.append("billdata.FDataElement dataElement,billdata.Fid srcBillId,billdata.FItemType,billdata.FDataSource dataSource,     \n");
        sql.append("billdata.FDebit,billdata.FCredit,billdata.FConfirmDebit,billdata.FConfirmCredit,billdata.FAuditDebit,billdata.FAuditCredit,       \n");
        sql.append("billdata.FisIncludeUnPosted,billdata.FCreatorID,billdata.FCreateTime,billdata.FLastUpdateUserID,billdata.FLastUpdateTime,billdata.FControlUnitID,     \n");
        sql.append("billdata.FItemNumber itemNumber,billdata.FItemName itemName,billdata.FRemarks remark,billdata.fimportreportId,billdata.fimportsheetname     \n");
        sql.append("from T_Csl_CheckageBilldata billdata       \n");
        sql.append("inner join T_ORG_Company company on company.fid=billdata.FCompanyId        \n");
        sql.append("inner join T_ORG_Company tarcompany on tarcompany.fid=billdata.FTargetCompanyId            \n");
        sql.append("inner join T_Csl_CheckageAccount checkageAccount on checkageAccount.FItemNumber=billdata.FItemNumber       \n");
        sql.append("\t\t\t\t\t\t\t\t\t\t\t\tand checkageAccount.FDataElement=billdata.FDataElement       \n");
        sql.append("\t\t\t\t\t\t\t\t\t\t\t\tand checkageAccount.FItemType=?        \n", itemTypeEnum.getValue());
        sql.append("inner join T_Csl_AccountAndMapAccount accountDirect on accountDirect.FCheckAccountId=checkageAccount.Fid \n");
        sql.append("inner join T_Csl_AccountMap accountMap on accountMap.Fid=accountDirect.FAccountMapId and  accountMap.FItemType=?     \n", itemTypeEnum.getValue());
        sql.append("inner join T_Csl_CheckageCompany ckCompany on ckCompany.FCompanyId=billdata.FCompanyId   \n");
        sql.append("inner join T_Csl_AccountMapDispense acMapDis on acMapDis.FAccountMapId=accountMap.fid and acMapDis.FCheckageCompanyId=ckCompany.fid   \n");
        sql.append("inner join T_Csl_CheckageCompany tarCkCompany on tarCkCompany.FCompanyId=billdata.FTargetCompanyId   \n");
        sql.append("inner join T_Csl_AccountMapDispense tarAcMapDis on tarAcMapDis.FAccountMapId=accountMap.fid and tarAcMapDis.FCheckageCompanyId=tarCkCompany.fid   \n");
        sql.append("where billdata.FYear=?      \n", year);
        sql.append("and billdata.FPeriod=?     \n", period);
        sql.append("and billdata.FCurrencyId=?      \n", currencyId);
        sql.append("and (billdata.FCompanyId=?      \n", accountCheckCompanyId);
        sql.append("or billdata.FTargetCompanyId=?)     \n", accountCheckCompanyId);
        sql.append("and billdata.FItemType=?      \n", itemTypeEnum.getValue());
        sql.append(") src       \n");
        sql.append("order by isFree desc,companyKey,mapId,seq,acSeq,FCreateTime desc     \n");
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        this.removeUnConfirmBill(ctx, year, period, currencyId, accountCheckCompanyId, itemTypeEnum);
        sql.reset();
        sql.append("select FCompanyId,companyNumber,FTargetCompanyId,tarCompanyNumber,FItemNumber,FItemName,FDataElement,FDebit,FCredit,FConfirmDebit,FConfirmCredit,FAuditDebit,FAuditCredit,        \n");
        sql.append("FisIncludeUnPosted,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,mapId,companyKey,mapIsFreezed,FSrcBillId,billItemType,dataSource,srcbilldata.FCkAccountId ckAccountId,  \n");
        sql.append(" t1.billId,t1.billHeadId,t1.billCompanyId,t1.companyId,t1.targetCompanyId,t1.confirmStatus,t1.lastUpdateTime,srcbilldata.remark,srcbilldata.fimportReportId,srcbilldata.fimportSheetName,srcbilldata.acMapDataSource  \n");
        sql.append("from ").append(srcBillDataTmep).append(" srcbilldata \n");
        sql.append("left join (     \t     \n");
        sql.append("select bill.Fid billId,bill.FBillHeadId billHeadId,bill.FBillCompanyId billCompanyId,bill.FCompanyId companyId,bill.FTargetCompanyId targetCompanyId,     \t     \n");
        sql.append("bill.FItemNumber itemNumber,bill.FItemName itemName,bill.FDataElement dataElement,bill.FLastUpdateTime lastUpdateTime,checkageBillCompany.FConfirmStatus confirmStatus,checkageBillHead.FAccountMapId billMapId    \t     \n");
        sql.append("from T_CSL_CheckageBill bill   \t     \n");
        sql.append("inner join T_Csl_CheckageBillCompany checkageBillCompany on checkageBillCompany.fid=bill.FBillCompanyId  \t     \n");
        sql.append("inner join T_Csl_CheckageBillHead checkageBillHead on checkageBillHead.fid=bill.FBillHeadId  \t     \n");
        sql.append("where bill.FYear=?         \n", year);
        sql.append("and bill.FPeriod=?         \n", period);
        sql.append("and bill.FCurrencyId=?       \n", currencyId);
        sql.append("and (bill.FCompanyId=?       \n", accountCheckCompanyId);
        sql.append("or bill.FTargetCompanyId=?)       \n", accountCheckCompanyId);
        sql.append("and bill.FItemType=?       \n", itemTypeEnum.getValue());
        sql.append(") t1 on t1.billMapId=srcbilldata.mapId and t1.companyId=srcbilldata.FCompanyId and t1.targetCompanyId=srcbilldata.FTargetCompanyId      \n");
        sql.append("\t\t\t\t\t\t\t\t\t\tand t1.itemNumber=srcbilldata.FItemNumber and t1.dataElement=srcbilldata.FDataElement     \n");
        sql.append("order by mapIsFreezed desc,mapId,companyKey,seq,acSeq     \n");
        CoreBaseCollection addNewDataCol = new CoreBaseCollection();
        CoreBaseCollection sameMapNewSelfDataCol = new CoreBaseCollection();
        CoreBaseCollection sameMapNewTarDataCol = new CoreBaseCollection();
        boolean needAddSelf = false;
        boolean needAddTar = false;
        boolean mapIsFreezed = false;
        String preSameMapCompanyKey = "";
        String currentSameMapCompanyKey = "";
        String preCompany = "";
        HashSet addNewBillSet = new HashSet();
        HashSet<String> selfBillKeySet = new HashSet<String>();
        HashSet<String> tarBillKeySet = new HashSet<String>();
        IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (row != null && row.size() > 0) {
            CurrencyInfo currencyInfo = new CurrencyInfo();
            currencyInfo.setId(BOSUuid.read((String)currencyId));
            currencyInfo.setNumber(currencyNumber);
            String company = "";
            boolean isAddFreezedData = false;
            while (row.next()) {
                CheckageBillInfo info;
                String billId = row.getString("billId");
                mapIsFreezed = row.getBoolean("mapIsFreezed");
                int acMapDataSource = row.getInt("acMapDataSource");
                String srcBillId = row.getString("FSrcBillId");
                if (StringUtils.isEmpty((String)billId) && 2 == acMapDataSource) {
                    diffItemIdSet.add(srcBillId);
                    continue;
                }
                String sameBillKey = row.getString("FCompanyId") + row.getString("FTargetCompanyId") + row.getString("FItemNumber") + row.getInt("FDataElement");
                if (mapIsFreezed) {
                    currentSameMapCompanyKey = row.getString("mapId") + row.getString("companyKey");
                    company = row.getString("FCompanyId");
                    if (!preSameMapCompanyKey.equals(currentSameMapCompanyKey)) {
                        if (needAddSelf && sameMapNewSelfDataCol.size() > 0) {
                            addNewDataCol.addCollection(sameMapNewSelfDataCol);
                            addNewBillSet.addAll(selfBillKeySet);
                        } else if (needAddTar && sameMapNewTarDataCol.size() > 0) {
                            addNewDataCol.addCollection(sameMapNewTarDataCol);
                            addNewBillSet.addAll(tarBillKeySet);
                        }
                        sameMapNewSelfDataCol.clear();
                        sameMapNewTarDataCol.clear();
                        selfBillKeySet.clear();
                        tarBillKeySet.clear();
                        needAddSelf = false;
                        needAddTar = false;
                        preCompany = company;
                    }
                    if (!StringUtils.isEmpty((String)billId)) {
                        if ("".equals(preSameMapCompanyKey) || preSameMapCompanyKey.equals(currentSameMapCompanyKey)) {
                            if ("".equals(preCompany) || preCompany.equals(company)) {
                                needAddTar = true;
                                sameMapNewSelfDataCol.clear();
                                selfBillKeySet.clear();
                            } else {
                                needAddSelf = true;
                                sameMapNewTarDataCol.clear();
                                tarBillKeySet.clear();
                            }
                        }
                        preSameMapCompanyKey = currentSameMapCompanyKey;
                        addNewBillSet.add(sameBillKey);
                        continue;
                    }
                    info = new CheckageBillInfo();
                    if ("".equals(preCompany) || preCompany.equals(company)) {
                        if (!needAddTar) {
                            selfBillKeySet.add(sameBillKey);
                            this.addNewInfo(sameMapNewSelfDataCol, info, row, year, period, currencyInfo, itemTypeEnum);
                        }
                    } else if (!needAddSelf) {
                        tarBillKeySet.add(sameBillKey);
                        this.addNewInfo(sameMapNewTarDataCol, info, row, year, period, currencyInfo, itemTypeEnum);
                    }
                    preSameMapCompanyKey = currentSameMapCompanyKey;
                    continue;
                }
                if (!isAddFreezedData) {
                    if (needAddSelf && sameMapNewSelfDataCol.size() > 0) {
                        addNewDataCol.addCollection(sameMapNewSelfDataCol);
                        addNewBillSet.addAll(selfBillKeySet);
                    } else if (needAddTar && sameMapNewTarDataCol.size() > 0) {
                        addNewDataCol.addCollection(sameMapNewTarDataCol);
                        addNewBillSet.addAll(tarBillKeySet);
                    }
                    isAddFreezedData = true;
                    sameMapNewSelfDataCol.clear();
                    sameMapNewTarDataCol.clear();
                }
                if (!StringUtils.isEmpty((String)billId) || addNewBillSet.contains(sameBillKey)) continue;
                info = new CheckageBillInfo();
                this.addNewInfo(addNewDataCol, info, row, year, period, currencyInfo, itemTypeEnum);
                addNewBillSet.add(sameBillKey);
            }
            if (!isAddFreezedData) {
                if (needAddSelf && sameMapNewSelfDataCol.size() > 0) {
                    addNewDataCol.addCollection(sameMapNewSelfDataCol);
                    addNewBillSet.addAll(selfBillKeySet);
                } else if (needAddTar && sameMapNewTarDataCol.size() > 0) {
                    addNewDataCol.addCollection(sameMapNewTarDataCol);
                    addNewBillSet.addAll(tarBillKeySet);
                }
            }
        }
        ICheckageBill iCheckageBill = CheckageBillFactory.getLocalInstance(ctx);
        if (addNewDataCol.size() > 0) {
            String schmId = null;
            if (autoCheckParams != null) {
                AutoCheckSchmInfo schmInfo = autoCheckParams.getSchmInfo();
                schmId = schmInfo.getId().toString();
            }
            HashSet<String> updateHeadBillDiffSet = new HashSet<String>();
            this.appendToSameHead_rptItemType(ctx, addNewDataCol, filterInfo, updateHeadBillDiffSet, schmId, itemTypeEnum, mapIdInfoMap, needUpdateDiffItemHeadIdSet);
            iCheckageBill.addnewBatchData(addNewDataCol);
            if (!needUpdateDiffItemHeadIdSet.isEmpty()) {
                this.updateDiffBillData(ctx, needUpdateDiffItemHeadIdSet, updateHeadBillDiffSet, itemTypeEnum);
                needUpdateDiffItemHeadIdSet.clear();
            }
            if (updateHeadBillDiffSet.size() > 0) {
                this._updateBilHeadDiff(ctx, updateHeadBillDiffSet);
            }
        }
        if (!diffItemIdSet.isEmpty()) {
            sql.reset();
            sql.append("delete from T_Csl_CheckageBillData where fid in ", diffItemIdSet);
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
    }

    private void UpdateBillData(Context ctx, String packId, String srcBillDataTmep, AccountCheckWorkeFilterInfo filterInfo, AutoCheckParams autoCheckParams, ItemTypeEnum itemTypeEnum, String accountCheckCompanyId, Map<String, Map<Integer, Set<String>>> mapIdInfoMap, Set<String> needUpdateDiffItemHeadIdSet) throws Exception {
        HashSet<String> diffItemIdSet = new HashSet<String>();
        int year = filterInfo.getYear();
        int period = filterInfo.getPeriod();
        String currencyId = filterInfo.getCurrencyId();
        String currencyNumber = filterInfo.getCurrencyNumber();
        SQLBuilder sql = new SQLBuilder();
        sql.reset();
        sql.append("select src.FIsFree isFree,src.mapId mapId,case when src.FCompanyId<src.FTargetCompanyId then concat(src.FCompanyId, src.FTargetCompanyId) else concat(src.FTargetCompanyId, src.FCompanyId) end companyKey, \n");
        sql.append("src.mapSelfAccountTableId mapSelfAccountTableId,src.mapTarAccountTableId mapTarAccountTableId,src.seq seq,src.acSeq acSeq,src.FIsMapAccount,  \n");
        sql.append("src.FCompanyId,src.companyNumber companyNumber,src.FTargetCompanyId,src.tarCompanyNumber tarCompanyNumber,src.ckAccountId ckAccountId,src.accountTableId accountTableId,src.tarAccountTableId,src.FAccountId,src.accountNumber,src.accountName,src.FBalType,  \n");
        sql.append("src.FDebit,src.FCredit,src.FConfirmDebit,src.FConfirmCredit,src.FAuditDebit,src.FAuditCredit,src.FisIncludeUnPosted,src.FCreatorID,src.FCreateTime FCreateTime,src.FLastUpdateUserID,  \n");
        sql.append("src.FLastUpdateTime,src.FControlUnitID,src.srcBillId srcBillId,src.dataSource dataSource,src.remark remark,src.importReportId importReportId,src.importSheetName importSheetName,src.acMapDataSource acMapDataSource from   \n");
        sql.append("(select distinct accountMap.Fid mapId,accountMap.FIsFree,case when company.FId=? then 0 else 1 end seq,accountDirect.Fseq acSeq,accountDirect.FIsMapAccount,billdata.FCompanyId,  \n", accountCheckCompanyId);
        sql.append("company.Fnumber companyNumber,billdata.FTargetCompanyId,tarcompany.Fnumber tarCompanyNumber,checkageAccount.Fid ckAccountId ,checkageAccount.FAccountTableid accountTableId,tarcompany.FAccountTableID tarAccountTableId,billdata.FAccountId,  \n");
        sql.append("accountView.fnumber accountNumber,accountView.fname_").append(ctx.getLocale().getLanguage()).append(" accountName,billdata.FBalType,billdata.Fid srcBillId,billdata.FDataSource dataSource, \n");
        sql.append("billdata.FRemarks remark,billdata.FImportReportId importReportId,billdata.FImportSheetName importSheetName,billdata.FDebit,billdata.FCredit,billdata.FConfirmDebit,billdata.FConfirmCredit,billdata.FAuditDebit,billdata.FAuditCredit,  \n");
        sql.append("billdata.FisIncludeUnPosted,billdata.FCreatorID,billdata.FCreateTime,billdata.FLastUpdateUserID,billdata.FLastUpdateTime,billdata.FControlUnitID,   \n");
        sql.append("accountMap.FOurAccountTableid mapSelfAccountTableId,accountMap.FOppositeAccountTableid mapTarAccountTableId,accountDirect.FDataSource acMapDataSource  \n");
        sql.append("from T_Csl_CheckageBilldata billdata  \n");
        sql.append("inner join T_ORG_Company company on company.fid=billdata.FCompanyId   \n");
        sql.append("inner join T_ORG_Company tarcompany on tarcompany.fid=billdata.FTargetCompanyId      \n");
        sql.append("inner join T_BD_AccountView accountView on accountView.Fid=billdata.FAccountId   \n");
        sql.append("inner join T_Csl_CheckageAccount checkageAccount on checkageAccount.FAccountTableid=company.FAccountTableID and checkageAccount.FItemNumber=accountView.Fnumber  \n");
        sql.append(" \tand checkageAccount.FBalType=billdata.FBalType  and checkageAccount.FItemType=?   \n", itemTypeEnum.getValue());
        sql.append("inner join T_Csl_AccountAndMapAccount accountDirect on accountDirect.FCheckAccountId=checkageAccount.Fid \n");
        sql.append("inner join T_Csl_AccountMap accountMap on accountMap.Fid=accountDirect.FAccountMapId and  accountMap.FItemType=?   \n", itemTypeEnum.getValue());
        sql.append("inner join T_Csl_CheckageCompany ckCompany on ckCompany.FCompanyId=billdata.FCompanyId   \n");
        sql.append("inner join T_Csl_AccountMapDispense acMapDis on acMapDis.FAccountMapId=accountMap.fid and acMapDis.FCheckageCompanyId=ckCompany.fid   \n");
        sql.append("inner join T_Csl_CheckageCompany tarCkCompany on tarCkCompany.FCompanyId=billdata.FTargetCompanyId   \n");
        sql.append("inner join T_Csl_AccountMapDispense tarAcMapDis on tarAcMapDis.FAccountMapId=accountMap.fid and tarAcMapDis.FCheckageCompanyId=tarCkCompany.fid   \n");
        sql.append("where billdata.FYear=?    \n", year);
        sql.append("and billdata.FPeriod=?    \n", period);
        sql.append("and billdata.FCurrencyId=?  \n", currencyId);
        sql.append("and (billdata.FCompanyId=?  \n", accountCheckCompanyId);
        sql.append("or billdata.FTargetCompanyId=?)  \n", accountCheckCompanyId);
        sql.append("and billdata.FItemType=?  \n", itemTypeEnum.getValue());
        sql.append(") src  \n");
        sql.append("order by isFree desc,companyKey,mapId,seq,acSeq,FCreateTime desc");
        IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        HashSet<String> exsitBillSet = new HashSet<String>();
        if (row != null && row.size() > 0) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            Object[] parmas = null;
            StringBuilder insertSqlSb = new StringBuilder();
            insertSqlSb.append("insert into ").append(srcBillDataTmep).append(" (FCompanyId,companyNumber,FTargetCompanyId,tarCompanyNumber,FAccountId,FCkAccountId,FAccountTableid,FItemNumber,FItemName,FBalType,FDebit,FCredit,");
            insertSqlSb.append("FConfirmDebit,FConfirmCredit,FAuditDebit,FAuditCredit,FisIncludeUnPosted,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,mapId,companyKey, ");
            insertSqlSb.append("seq,acSeq,mapIsFreezed,FSrcBillId,billItemType,dataSource,remark,fimportReportId,fimportSheetName,acMapDataSource) ");
            insertSqlSb.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            String infoKey = "";
            boolean isBilateralReconciliation = false;
            while (row.next()) {
                String mapSelfAccountTableId = row.getString("mapSelfAccountTableId");
                String mapTarAccountTableId = row.getString("mapTarAccountTableId");
                isBilateralReconciliation = !StringUtils.isEmpty((String)mapSelfAccountTableId) && !StringUtils.isEmpty((String)mapTarAccountTableId);
                String tarAccountTableId = row.getString("tarAccountTableId");
                String accountTableId = row.getString("accountTableId");
                if (isBilateralReconciliation) {
                    String accountIdKey;
                    String mapAccountIdKey = mapSelfAccountTableId.compareTo(mapTarAccountTableId) > 0 ? mapSelfAccountTableId + mapTarAccountTableId : mapTarAccountTableId + mapSelfAccountTableId;
                    String string = accountIdKey = accountTableId.compareTo(tarAccountTableId) > 0 ? accountTableId + tarAccountTableId : tarAccountTableId + accountTableId;
                    if (!mapAccountIdKey.equals(accountIdKey)) {
                        continue;
                    }
                } else if (!accountTableId.equals(mapSelfAccountTableId) && !accountTableId.equals(mapTarAccountTableId)) continue;
                if (exsitBillSet.contains(infoKey = row.getString("mapId") + row.getString("FCompanyId") + row.getString("FTargetCompanyId") + row.getString("accountNumber") + row.getInt("FBalType"))) continue;
                exsitBillSet.add(infoKey);
                parmas = new Object[]{row.getString("FCompanyId"), row.getString("companyNumber"), row.getString("FTargetCompanyId"), row.getString("tarCompanyNumber"), row.getString("FAccountId"), row.getString("ckAccountId"), row.getString("accountTableId"), row.getString("accountNumber"), row.getString("accountName"), row.getInt("FBalType"), row.getBigDecimal("FDebit"), row.getBigDecimal("FCredit"), row.getBigDecimal("FConfirmDebit"), row.getBigDecimal("FConfirmCredit"), row.getBigDecimal("FAuditDebit"), row.getBigDecimal("FAuditCredit"), row.getInt("FisIncludeUnPosted"), row.getString("FCreatorID"), row.getTimestamp("FCreateTime"), row.getString("FLastUpdateUserID"), row.getTimestamp("FLastUpdateTime"), row.getString("FControlUnitID"), row.getString("mapId"), row.getString("companyKey"), row.getInt("seq"), row.getInt("acSeq"), row.getInt("isFree"), row.getString("srcBillId"), itemTypeEnum.getValue(), row.getInt("dataSource"), row.getString("remark"), row.getString("importReportId"), row.getString("importSheetName"), row.getInt("acMapDataSource")};
                paramsList.add(parmas);
            }
            if (paramsList.size() > 0) {
                DbUtil.executeBatch(ctx, insertSqlSb.toString(), paramsList);
            }
        }
        exsitBillSet = null;
        this.removeUnConfirmBill(ctx, year, period, currencyId, accountCheckCompanyId, itemTypeEnum);
        sql.reset();
        sql.append("select FCompanyId,companyNumber,FTargetCompanyId,tarCompanyNumber,FAccountId,FItemNumber,FItemName,FBalType,FDebit,FCredit,FConfirmDebit,FConfirmCredit,FAuditDebit,FAuditCredit,FisIncludeUnPosted,   \n");
        sql.append("FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,mapId,companyKey,mapIsFreezed,FSrcBillId,billItemType,dataSource,srcbilldata.FCkAccountId ckAccountId, \n");
        sql.append("srcbilldata.remark remark,srcbilldata.fimportReportId fimportReportId,srcbilldata.fimportSheetName fimportSheetName,srcbilldata.acMapDataSource, \n");
        sql.append("t1.billId,t1.billHeadId,t1.billCompanyId,t1.companyId,t1.targetCompanyId,t1.accountId,t1.balType,t1.confirmStatus,t1.lastUpdateTime from ").append(srcBillDataTmep).append(" srcbilldata    \n");
        sql.append("left join (     \t\n");
        sql.append("select bill.Fid billId,bill.FBillHeadId billHeadId,bill.FBillCompanyId billCompanyId,bill.FCompanyId companyId,bill.FTargetCompanyId targetCompanyId,     \t\n");
        sql.append("bill.FAccountId accountId,bill.FBalType balType,bill.FLastUpdateTime lastUpdateTime,checkageBillCompany.FConfirmStatus confirmStatus,checkageBillHead.FAccountMapId billMapId    \t\n");
        sql.append("from T_CSL_CheckageBill bill   \t\n");
        sql.append("inner join T_Csl_CheckageBillCompany checkageBillCompany on checkageBillCompany.fid=bill.FBillCompanyId  \t\n");
        sql.append("inner join T_Csl_CheckageBillHead checkageBillHead on checkageBillHead.fid=bill.FBillHeadId  \t\n");
        sql.append("where bill.FYear=?    \n", year);
        sql.append("and bill.FPeriod=?    \n", period);
        sql.append("and bill.FCurrencyId=?  \n", currencyId);
        sql.append("and (bill.FCompanyId=?  \n", accountCheckCompanyId);
        sql.append("or bill.FTargetCompanyId=?)  \n", accountCheckCompanyId);
        sql.append("and bill.FItemType=?  \n", itemTypeEnum.getValue());
        sql.append(") t1 on t1.billMapId=srcbilldata.mapId and t1.companyId=srcbilldata.FCompanyId and t1.targetCompanyId=srcbilldata.FTargetCompanyId and t1.accountId=srcbilldata.FAccountId and t1.balType=srcbilldata.FBalType ");
        sql.append("order by mapIsFreezed desc,mapId,companyKey,seq,acSeq");
        CoreBaseCollection addNewDataCol = new CoreBaseCollection();
        CoreBaseCollection sameMapNewSelfDataCol = new CoreBaseCollection();
        CoreBaseCollection sameMapNewTarDataCol = new CoreBaseCollection();
        boolean needAddSelf = false;
        boolean needAddTar = false;
        boolean mapIsFreezed = false;
        String preSameMapCompanyKey = "";
        String currentSameMapCompanyKey = "";
        String preCompany = "";
        HashSet addNewBillSet = new HashSet();
        HashSet<String> selfBillKeySet = new HashSet<String>();
        HashSet<String> tarBillKeySet = new HashSet<String>();
        row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (row != null && row.size() > 0) {
            CurrencyInfo currencyInfo = new CurrencyInfo();
            currencyInfo.setId(BOSUuid.read((String)currencyId));
            currencyInfo.setNumber(currencyNumber);
            String company = "";
            boolean isAddFreezedData = false;
            while (row.next()) {
                CheckageBillInfo info;
                String billId = row.getString("billId");
                mapIsFreezed = row.getBoolean("mapIsFreezed");
                int acMapDataSource = row.getInt("acMapDataSource");
                String srcBillId = row.getString("FSrcBillId");
                if (StringUtils.isEmpty((String)billId) && 2 == acMapDataSource) {
                    diffItemIdSet.add(srcBillId);
                    continue;
                }
                String sameBillKey = row.getString("FCompanyId") + row.getString("FTargetCompanyId") + row.getString("FItemNumber") + row.getInt("FBalType");
                if (mapIsFreezed) {
                    currentSameMapCompanyKey = row.getString("mapId") + row.getString("companyKey");
                    company = row.getString("FCompanyId");
                    if (!preSameMapCompanyKey.equals(currentSameMapCompanyKey)) {
                        if (needAddSelf && sameMapNewSelfDataCol.size() > 0) {
                            addNewDataCol.addCollection(sameMapNewSelfDataCol);
                            addNewBillSet.addAll(selfBillKeySet);
                        } else if (needAddTar && sameMapNewTarDataCol.size() > 0) {
                            addNewDataCol.addCollection(sameMapNewTarDataCol);
                            addNewBillSet.addAll(tarBillKeySet);
                        }
                        sameMapNewSelfDataCol.clear();
                        sameMapNewTarDataCol.clear();
                        selfBillKeySet.clear();
                        tarBillKeySet.clear();
                        needAddSelf = false;
                        needAddTar = false;
                        preCompany = company;
                    }
                    if (!StringUtils.isEmpty((String)billId)) {
                        if ("".equals(preSameMapCompanyKey) || preSameMapCompanyKey.equals(currentSameMapCompanyKey)) {
                            if ("".equals(preCompany) || preCompany.equals(company)) {
                                needAddTar = true;
                                sameMapNewSelfDataCol.clear();
                                selfBillKeySet.clear();
                            } else {
                                needAddSelf = true;
                                sameMapNewTarDataCol.clear();
                                tarBillKeySet.clear();
                            }
                        }
                        preSameMapCompanyKey = currentSameMapCompanyKey;
                        addNewBillSet.add(sameBillKey);
                        continue;
                    }
                    info = new CheckageBillInfo();
                    if ("".equals(preCompany) || preCompany.equals(company)) {
                        if (!needAddTar) {
                            selfBillKeySet.add(sameBillKey);
                            this.addNewInfo(sameMapNewSelfDataCol, info, row, year, period, currencyInfo, itemTypeEnum);
                        }
                    } else if (!needAddSelf) {
                        tarBillKeySet.add(sameBillKey);
                        this.addNewInfo(sameMapNewTarDataCol, info, row, year, period, currencyInfo, itemTypeEnum);
                    }
                    preSameMapCompanyKey = currentSameMapCompanyKey;
                    continue;
                }
                if (!isAddFreezedData) {
                    if (needAddSelf && sameMapNewSelfDataCol.size() > 0) {
                        addNewDataCol.addCollection(sameMapNewSelfDataCol);
                        addNewBillSet.addAll(selfBillKeySet);
                    } else if (needAddTar && sameMapNewTarDataCol.size() > 0) {
                        addNewDataCol.addCollection(sameMapNewTarDataCol);
                        addNewBillSet.addAll(tarBillKeySet);
                    }
                    isAddFreezedData = true;
                    sameMapNewSelfDataCol.clear();
                    sameMapNewTarDataCol.clear();
                }
                if (!StringUtils.isEmpty((String)billId) || addNewBillSet.contains(sameBillKey)) continue;
                info = new CheckageBillInfo();
                this.addNewInfo(addNewDataCol, info, row, year, period, currencyInfo, itemTypeEnum);
                addNewBillSet.add(sameBillKey);
            }
            if (!isAddFreezedData) {
                if (needAddSelf && sameMapNewSelfDataCol.size() > 0) {
                    addNewDataCol.addCollection(sameMapNewSelfDataCol);
                    addNewBillSet.addAll(selfBillKeySet);
                } else if (needAddTar && sameMapNewTarDataCol.size() > 0) {
                    addNewDataCol.addCollection(sameMapNewTarDataCol);
                    addNewBillSet.addAll(tarBillKeySet);
                }
            }
        }
        ICheckageBill iCheckageBill = CheckageBillFactory.getLocalInstance(ctx);
        if (addNewDataCol.size() > 0) {
            String schmId = null;
            if (autoCheckParams != null) {
                AutoCheckSchmInfo schmInfo = autoCheckParams.getSchmInfo();
                schmId = schmInfo.getId().toString();
            }
            HashSet<String> updateHeadBillDiffSet = new HashSet<String>();
            this.appendToSameHead(ctx, addNewDataCol, filterInfo, updateHeadBillDiffSet, schmId, itemTypeEnum, mapIdInfoMap, needUpdateDiffItemHeadIdSet);
            iCheckageBill.addnewBatchData(addNewDataCol);
            if (!needUpdateDiffItemHeadIdSet.isEmpty()) {
                this.updateDiffBillData(ctx, needUpdateDiffItemHeadIdSet, updateHeadBillDiffSet, itemTypeEnum);
                needUpdateDiffItemHeadIdSet.clear();
            }
            if (updateHeadBillDiffSet.size() > 0) {
                this._updateBilHeadDiff(ctx, updateHeadBillDiffSet);
            }
        }
        if (!diffItemIdSet.isEmpty()) {
            sql.reset();
            sql.append("delete from T_Csl_CheckageBillData where fid in ", diffItemIdSet);
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
    }

    private Set haveDataCompanySet(Context ctx, int year, int period, String currencyId, Object accountCheckCompanyId, ItemTypeEnum itemTypeEnum) throws BOSException {
        HashSet<String> haveDataCompanySet = new HashSet<String>();
        HashSet<String> accountCheckCompanySet = new HashSet<String>();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select distinct FCompanyId,FTargetCompanyId from T_Csl_CheckageBill \n");
        sql.append("where FYear=?  \n", year);
        sql.append("and FPeriod=?  \n", period);
        sql.append("and FCurrencyId=?  \n", currencyId);
        if (accountCheckCompanyId instanceof Set) {
            Set companyIdSet = (Set)accountCheckCompanyId;
            sql.append("and (FCompanyId in  \n", companyIdSet);
            sql.append("or FTargetCompanyId in ", companyIdSet);
            sql.append(") \n");
            accountCheckCompanySet = new HashSet((Set)accountCheckCompanyId);
        } else {
            String companyId = (String)accountCheckCompanyId;
            sql.append("and (FCompanyId=?  \n", companyId);
            sql.append("or FTargetCompanyId=? ) \n", companyId);
            accountCheckCompanySet.add(companyId);
        }
        sql.append("and FItemType=?  \n", itemTypeEnum.getValue());
        try {
            IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (row != null && row.size() > 0) {
                while (row.next()) {
                    String companyId = row.getString("FCompanyId");
                    String tarCompanyId = row.getString("FTargetCompanyId");
                    if (accountCheckCompanySet.contains(companyId)) {
                        haveDataCompanySet.add(companyId);
                    }
                    if (!accountCheckCompanySet.contains(tarCompanyId)) continue;
                    haveDataCompanySet.add(tarCompanyId);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return haveDataCompanySet;
    }

    private void removeUnConfirmBill(Context ctx, int year, int period, String currencyId, Object company, ItemTypeEnum itemTypeEnum) throws BOSException, SQLException {
        HashSet<String> deleteBillIdSet = new HashSet<String>();
        HashSet<String> deleteBillCompanySet = new HashSet<String>();
        HashSet<String> deleteBillHeadSet = new HashSet<String>();
        HashSet<String> notDeleteBillHeadSet = new HashSet<String>();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select bill.Fid billId,bill.FBillHeadId billHeadId,bill.FBillCompanyId billCompanyId,checkageBillCompany.FConfirmStatus confirmStatus   \n");
        sql.append("from T_CSL_CheckageBill bill     \n");
        sql.append("inner join T_Csl_CheckageBillCompany checkageBillCompany on checkageBillCompany.fid=bill.FBillCompanyId  \n");
        sql.append("where bill.FYear=?    \n", year);
        sql.append("and bill.FPeriod=?    \n", period);
        sql.append("and bill.FCurrencyId=?  \n", currencyId);
        if (company instanceof Set) {
            sql.append("and (bill.FCompanyId in  \n", (Set)company);
            sql.append(" or bill.FTargetCompanyId in   \n", (Set)company).append(")");
        } else {
            sql.append("and (bill.FCompanyId=?  \n", company);
            sql.append("or bill.FTargetCompanyId=? )  \n", company);
        }
        sql.append("and bill.FItemType=?  \n", itemTypeEnum.getValue());
        IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (row != null && row.size() > 0) {
            while (row.next()) {
                int confirmStatus = row.getInt("confirmStatus");
                String billId = row.getString("billId");
                String billCompanyId = row.getString("billCompanyId");
                String billHeadId = row.getString("billHeadId");
                if (1 == confirmStatus) {
                    notDeleteBillHeadSet.add(billHeadId);
                    continue;
                }
                if (0 != confirmStatus) continue;
                deleteBillIdSet.add(billId);
                deleteBillCompanySet.add(billCompanyId);
                deleteBillHeadSet.add(billHeadId);
            }
            deleteBillHeadSet.removeAll(notDeleteBillHeadSet);
        }
        if (deleteBillCompanySet.size() > 0) {
            sql.reset();
            sql.append("delete from T_Csl_CheckageBillCompany where fid in ", deleteBillCompanySet);
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
        if (deleteBillHeadSet.size() > 0) {
            sql.reset();
            sql.append("delete from T_Csl_CheckageBillHead where fid in ", deleteBillHeadSet);
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
        if (deleteBillIdSet.size() > 0) {
            sql.reset();
            sql.append("delete from T_Csl_CheckageBill where fid in ", deleteBillIdSet);
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
    }

    private void addNewInfo(CoreBaseCollection addNewDataCol, CheckageBillInfo info, IRowSet row, int year, int period, CurrencyInfo currencyInfo, ItemTypeEnum itemTypeEnum) throws UuidException, SQLException {
        String remark;
        String importReportId;
        UserInfo updateUser = new UserInfo();
        updateUser.setId(BOSUuid.read((String)row.getString("FLASTUPDATEUSERID")));
        info.setDebit(row.getBigDecimal("FDEBIT"));
        info.setCredit(row.getBigDecimal("FCREDIT"));
        info.setConfirmDebit(row.getBigDecimal("FCONFIRMDEBIT"));
        info.setConfirmCredit(row.getBigDecimal("FCONFIRMCREDIT"));
        info.setAuditDebit(row.getBigDecimal("FAUDITDEBIT"));
        info.setAuditCredit(row.getBigDecimal("FAUDITCREDIT"));
        info.setLastUpdateTime(row.getTimestamp("FLastUpdateTime"));
        info.setIsIncludingUnPosted(row.getBoolean("FisIncludeUnPosted"));
        info.setLastUpdateUser(updateUser);
        info.put("mapId", row.getString("mapId"));
        info.put("companyKey", row.getString("companyKey"));
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)row.getString("FCOMPANYID")));
        company.setNumber(row.getString("companyNumber"));
        CompanyOrgUnitInfo tarCompany = new CompanyOrgUnitInfo();
        tarCompany.setId(BOSUuid.read((String)row.getString("FTARGETCOMPANYID")));
        tarCompany.setNumber(row.getString("tarCompanyNumber"));
        if (ItemTypeEnum.account == itemTypeEnum) {
            AccountViewInfo accountView = new AccountViewInfo();
            accountView.setId(BOSUuid.read((String)row.getString("FACCOUNTID")));
            accountView.setNumber(row.getString("FItemNumber"));
            info.setAccount(accountView);
            info.setBalType(BalTypeEnum.getEnum(row.getInt("FBalType")));
            info.setDataElement(row.getInt("FBalType"));
        } else {
            info.setDataElement(row.getInt("FDataElement"));
        }
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)row.getString("FCREATORID")));
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)row.getString("FCONTROLUNITID")));
        info.setYear(year);
        info.setPeriod(period);
        info.setCurrency(currencyInfo);
        info.setCompany(company);
        info.setTargetCompany(tarCompany);
        info.setIsIncludingUnPosted(row.getBoolean("FisIncludeUnPosted"));
        info.setCreator(user);
        info.setCreateTime(row.getTimestamp("FCREATETIME"));
        info.setCU(cu);
        info.setItemType(itemTypeEnum);
        info.setDataSource(DataSourceEnum.getEnum(row.getInt("dataSource")));
        info.setItemNumber(row.getString("FItemNumber"));
        info.setItemName(row.getString("FItemName"));
        CheckageAccountInfo cAccountInfo = new CheckageAccountInfo();
        cAccountInfo.setId(BOSUuid.read((String)row.getString("ckAccountId")));
        info.setCheckAccount(cAccountInfo);
        info.setSrcBillId(row.getString("FSrcBillId"));
        String importSheetName = row.getString("fimportSheetName");
        if (!StringUtils.isEmpty((String)importSheetName)) {
            info.setImportSheetName(importSheetName);
        }
        if (!StringUtils.isEmpty((String)(importReportId = row.getString("fimportReportId")))) {
            info.setImportReportId(importReportId);
        }
        if (!StringUtils.isEmpty((String)(remark = row.getString("remark")))) {
            info.setRemark(remark);
        }
        addNewDataCol.add((CoreBaseInfo)info);
    }

    private void creatHeadAndBillCompany(Context ctx, CoreBaseCollection dataCol, AccountCheckWorkeFilterInfo filterInfo, Map<String, Map<Integer, Set<String>>> mapIdInfoMap, Set<String> updateHeadBillDiffSet, String schmId, ItemTypeEnum itemTypeEnum, Set<String> needUpdateDiffItemHeadIdSet) throws BOSException, EASBizException, SQLException {
        if (dataCol == null || dataCol.isEmpty()) {
            return;
        }
        boolean isAccountType = ItemTypeEnum.account == itemTypeEnum;
        int year = filterInfo.getYear();
        int period = filterInfo.getPeriod();
        String currencyId = filterInfo.getCurrencyId();
        String currencyNumber = filterInfo.getCurrencyNumber();
        String companyNumber = "";
        String tarcompanyNumber = "";
        String number = null;
        String preKey = "";
        String billHeadKey = "";
        String preCompanyKey = "";
        String selfCompanyKey = "";
        ICheckageBillHead iCheckageBillHead = CheckageBillHeadFactory.getLocalInstance(ctx);
        ICheckageBillCompany iCheckageBillCompany = CheckageBillCompanyFactory.getLocalInstance(ctx);
        CoreBaseCollection addNewHeadCol = new CoreBaseCollection();
        CoreBaseCollection addNewBillCompanyCol = new CoreBaseCollection();
        BigDecimal billConfirmDebit = null;
        BigDecimal billConfirmCredit = null;
        AbstractCheckageBillHeadInfo billheadInfo = null;
        BOSUuid billheadId = null;
        CheckageBillCompanyInfo billCompanyInfo = null;
        BOSUuid billBillCompanyID = null;
        HashMap<String, Set<String>> maxbillHeadCompanyKeyNumberMap = new HashMap<String, Set<String>>();
        SQLBuilder sql = new SQLBuilder();
        CoreBaseCollection newDataCol = new CoreBaseCollection();
        CoreBaseCollection newHeadDataCol = new CoreBaseCollection();
        HashMap<String, Boolean> userMapIsSelfMap = new HashMap<String, Boolean>();
        for (int i = 0; i < dataCol.size(); ++i) {
            CheckageBillInfo info = (CheckageBillInfo)dataCol.get(i);
            if (info.getBillHead() != null) {
                newDataCol.add((CoreBaseInfo)info);
                if (info.getBillHead().getId() == null) continue;
                updateHeadBillDiffSet.add(info.getBillHead().getId().toString());
                continue;
            }
            String mapId = info.getString("mapId");
            if (!mapIdInfoMap.containsKey(mapId)) {
                this.findAccountInSameMap(ctx, mapIdInfoMap, mapId, itemTypeEnum);
            }
            String companyKey = info.getString("companyKey");
            companyNumber = info.getCompany().getNumber();
            tarcompanyNumber = info.getTargetCompany().getNumber();
            String companyId = info.getCompany().getId().toString();
            String tarCompanyId = info.getTargetCompany().getId().toString();
            billHeadKey = mapId + companyKey;
            selfCompanyKey = billHeadKey + companyId;
            String itemKey = isAccountType ? info.getAccount().getNumber() + info.getBalType().getValue() : info.getItemNumber() + info.getDataElement();
            Map<Integer, Set<String>> mapAccountMap = mapIdInfoMap.get(mapId);
            Set<String> selfAccountKey = mapAccountMap.get(1);
            Set<String> tarAccountKey = mapAccountMap.get(0);
            boolean needCreatBillCompany = false;
            boolean needCreatNewHead = false;
            if (companyId.equals(tarCompanyId)) {
                if (!billHeadKey.equals(preKey)) {
                    needCreatBillCompany = true;
                    needCreatNewHead = true;
                }
                newDataCol.add((CoreBaseInfo)info);
            } else if (selfAccountKey.isEmpty() || tarAccountKey.isEmpty()) {
                if (!selfCompanyKey.equals(preCompanyKey)) {
                    needCreatBillCompany = true;
                    needCreatNewHead = true;
                    if (newHeadDataCol.size() > 0) {
                        this.creatNewHeadAndBillCompany(ctx, newHeadDataCol, maxbillHeadCompanyKeyNumberMap, addNewHeadCol, addNewBillCompanyCol, filterInfo, schmId);
                        newDataCol.addCollection(newHeadDataCol);
                        newHeadDataCol = new CoreBaseCollection();
                    }
                }
                newDataCol.add((CoreBaseInfo)info);
            } else {
                if (!selfCompanyKey.equals(preCompanyKey)) {
                    needCreatBillCompany = true;
                    if (!billHeadKey.equals(preKey)) {
                        needCreatNewHead = true;
                        if (newHeadDataCol.size() > 0) {
                            this.creatNewHeadAndBillCompany(ctx, newHeadDataCol, maxbillHeadCompanyKeyNumberMap, addNewHeadCol, addNewBillCompanyCol, filterInfo, schmId);
                            newDataCol.addCollection(newHeadDataCol);
                            newHeadDataCol = new CoreBaseCollection();
                        }
                    }
                }
                Boolean isSelf = (Boolean)userMapIsSelfMap.get(selfCompanyKey);
                if (billHeadKey.equals(preKey) && isSelf == null && (isSelf = (Boolean)userMapIsSelfMap.get(preCompanyKey)) != null) {
                    isSelf = isSelf == false;
                    userMapIsSelfMap.put(selfCompanyKey, isSelf);
                }
                if (selfAccountKey.contains(itemKey)) {
                    if (isSelf == null) {
                        userMapIsSelfMap.put(selfCompanyKey, true);
                    } else if (!isSelf.booleanValue()) {
                        newHeadDataCol.add((CoreBaseInfo)info);
                        continue;
                    }
                } else if (isSelf == null) {
                    userMapIsSelfMap.put(selfCompanyKey, false);
                } else if (isSelf.booleanValue()) {
                    newHeadDataCol.add((CoreBaseInfo)info);
                    continue;
                }
                newDataCol.add((CoreBaseInfo)info);
            }
            if (!maxbillHeadCompanyKeyNumberMap.containsKey(companyKey)) {
                this.mainTainHeadNumber(ctx, info, maxbillHeadCompanyKeyNumberMap, filterInfo);
            }
            if (needCreatBillCompany) {
                billCompanyInfo = new CheckageBillCompanyInfo();
                billBillCompanyID = BOSUuid.create((BOSObjectType)billCompanyInfo.getBOSType());
                billCompanyInfo.setId(billBillCompanyID);
                billCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                if (schmId != null) {
                    billCompanyInfo.setPackSchmId(schmId);
                }
                addNewBillCompanyCol.add((CoreBaseInfo)billCompanyInfo);
            }
            info.setBillCompany(billCompanyInfo);
            if (needCreatNewHead) {
                String headNumber = (companyNumber.compareTo(tarcompanyNumber) < 0 ? companyNumber + "-" + tarcompanyNumber : tarcompanyNumber + "-" + companyNumber) + "-" + currencyNumber + "-" + year + (period < 10 ? "0" + period : Integer.valueOf(period)) + "-";
                NumberFormat nf = NumberFormat.getInstance();
                nf.setGroupingUsed(false);
                nf.setMaximumFractionDigits(4);
                nf.setMinimumIntegerDigits(4);
                number = this.getHeadNumber((Set)maxbillHeadCompanyKeyNumberMap.get(companyKey), nf, headNumber, "0001");
                billConfirmDebit = null;
                billConfirmCredit = null;
                billheadInfo = new CheckageBillHeadInfo();
                billheadId = BOSUuid.create((BOSObjectType)billheadInfo.getBOSType());
                billheadInfo.setId(billheadId);
                billheadInfo.setNumber(number);
                AccountMapInfo accountMapInfo = new AccountMapInfo();
                accountMapInfo.setId(BOSUuid.read((String)mapId));
                billheadInfo.setAccountMap(accountMapInfo);
                billheadInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
                addNewHeadCol.add((CoreBaseInfo)billheadInfo);
            }
            info.setBillHead((CheckageBillHeadInfo)billheadInfo);
            if (info.getConfirmDebit() != null) {
                BigDecimal bigDecimal = billConfirmDebit = billConfirmDebit == null ? BigDecimal.ZERO.add(info.getConfirmDebit()) : billConfirmDebit.add(info.getConfirmDebit());
            }
            if (info.getConfirmCredit() != null) {
                BigDecimal bigDecimal = billConfirmCredit = billConfirmCredit == null ? BigDecimal.ZERO.add(info.getConfirmCredit()) : billConfirmCredit.add(info.getConfirmCredit());
            }
            if ((billConfirmDebit != null || billConfirmCredit != null) && billheadInfo != null) {
                billheadInfo.setCompanyDiff((billConfirmDebit != null ? billConfirmDebit : BigDecimal.ZERO).subtract(billConfirmCredit != null ? billConfirmCredit : BigDecimal.ZERO));
            }
            preKey = billHeadKey;
            preCompanyKey = selfCompanyKey;
        }
        if (newHeadDataCol.size() > 0) {
            this.creatNewHeadAndBillCompany(ctx, newHeadDataCol, maxbillHeadCompanyKeyNumberMap, addNewHeadCol, addNewBillCompanyCol, filterInfo, schmId);
            newDataCol.addCollection(newHeadDataCol);
            newHeadDataCol = new CoreBaseCollection();
        }
        dataCol.clear();
        dataCol.addCollection(newDataCol);
        for (int i = 0; i < dataCol.size(); ++i) {
            CheckageBillInfo cbInfo = (CheckageBillInfo)dataCol.get(i);
            if (cbInfo.getBillHead() == null || cbInfo.getBillHead().getId() == null) continue;
            needUpdateDiffItemHeadIdSet.add(cbInfo.getBillHead().getId().toString());
        }
        if (addNewHeadCol.size() > 0) {
            iCheckageBillHead.addnewBatchData(addNewHeadCol);
        }
        if (addNewBillCompanyCol.size() > 0) {
            iCheckageBillCompany.addnewBatchData(addNewBillCompanyCol);
        }
    }

    private void findAccountInSameMap(Context ctx, Map<String, Map<Integer, Set<String>>> mapIdInfoMap, String mapId, ItemTypeEnum itemTypeEnum) throws BOSException, SQLException {
        SQLBuilder sql = new SQLBuilder();
        HashMap mapAccountMap = new HashMap();
        HashSet selfKeySet = new HashSet();
        mapAccountMap.put(1, selfKeySet);
        HashSet tarKeySet = new HashSet();
        mapAccountMap.put(0, tarKeySet);
        String filedName = ItemTypeEnum.account == itemTypeEnum ? "FBalType" : "FDataElement";
        sql.reset();
        sql.append("select ").append(filedName);
        sql.append(",FItemNumber,acMapAc.FIsMapAccount from T_Csl_CheckageAccount ckAccount   \n");
        sql.append("inner join T_Csl_AccountAndMapAccount acMapAc on acMapAc.FCheckAccountId=ckAccount.FId \n");
        sql.append("where acMapAc.FAccountMapId=?", mapId);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (rowSet != null && rowSet.size() > 0) {
            while (rowSet.next()) {
                Set keySet;
                int dataElement = rowSet.getInt(filedName);
                String accountNumber = rowSet.getString("FItemNumber");
                int isMapAccount = rowSet.getInt("FIsMapAccount");
                if (isMapAccount == 1) {
                    keySet = (Set)mapAccountMap.get(1);
                    keySet.add(accountNumber + dataElement);
                    continue;
                }
                keySet = (Set)mapAccountMap.get(0);
                keySet.add(accountNumber + dataElement);
            }
        }
        mapIdInfoMap.put(mapId, mapAccountMap);
    }

    private void creatNewHeadAndBillCompany(Context ctx, CoreBaseCollection newCol, Map<String, Set<String>> maxbillHeadCompanyKeyNumberMap, CoreBaseCollection addNewHeadCol, CoreBaseCollection addNewBillCompanyCol, AccountCheckWorkeFilterInfo filterInfo, String schmId) throws BOSException, EASBizException, SQLException {
        String number = null;
        String preCompanyId = "";
        CheckageBillCompanyInfo billCompanyInfo = null;
        AbstractCheckageBillHeadInfo billheadInfo = null;
        boolean needCreatNewHead = true;
        BigDecimal billConfirmDebit = null;
        BigDecimal billConfirmCredit = null;
        for (int i = 0; i < newCol.size(); ++i) {
            CheckageBillInfo info = (CheckageBillInfo)newCol.get(i);
            String companyKey = info.getString("companyKey");
            String companyId = info.getCompany().getId().toString();
            if (!maxbillHeadCompanyKeyNumberMap.containsKey(companyKey)) {
                this.mainTainHeadNumber(ctx, info, maxbillHeadCompanyKeyNumberMap, filterInfo);
            }
            if (!preCompanyId.equals(companyId)) {
                billCompanyInfo = new CheckageBillCompanyInfo();
                billCompanyInfo.setId(BOSUuid.create((BOSObjectType)billCompanyInfo.getBOSType()));
                billCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                if (schmId != null) {
                    billCompanyInfo.setPackSchmId(schmId);
                }
                addNewBillCompanyCol.add((CoreBaseInfo)billCompanyInfo);
            }
            if (billCompanyInfo != null) {
                info.setBillCompany(billCompanyInfo);
            }
            if (needCreatNewHead) {
                int year = filterInfo.getYear();
                int period = filterInfo.getPeriod();
                String currencyNumber = filterInfo.getCurrencyNumber();
                String companyNumber = info.getCompany().getNumber();
                String tarcompanyNumber = info.getTargetCompany().getNumber();
                String headNumber = (companyNumber.compareTo(tarcompanyNumber) < 0 ? companyNumber + "-" + tarcompanyNumber : tarcompanyNumber + "-" + companyNumber) + "-" + currencyNumber + "-" + year + (period < 10 ? "0" + period : Integer.valueOf(period)) + "-";
                NumberFormat nf = NumberFormat.getInstance();
                nf.setGroupingUsed(false);
                nf.setMaximumFractionDigits(4);
                nf.setMinimumIntegerDigits(4);
                number = this.getHeadNumber(maxbillHeadCompanyKeyNumberMap.get(companyKey), nf, headNumber, "0001");
                billConfirmDebit = null;
                billConfirmCredit = null;
                billheadInfo = new CheckageBillHeadInfo();
                billheadInfo.setId(BOSUuid.create((BOSObjectType)billheadInfo.getBOSType()));
                billheadInfo.setNumber(number);
                AccountMapInfo accountMapInfo = new AccountMapInfo();
                accountMapInfo.setId(BOSUuid.read((String)info.getString("mapId")));
                billheadInfo.setAccountMap(accountMapInfo);
                billheadInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
                addNewHeadCol.add((CoreBaseInfo)billheadInfo);
                needCreatNewHead = false;
            }
            info.setBillHead((CheckageBillHeadInfo)billheadInfo);
            if (info.getConfirmDebit() != null) {
                BigDecimal bigDecimal = billConfirmDebit = billConfirmDebit == null ? BigDecimal.ZERO.add(info.getConfirmDebit()) : billConfirmDebit.add(info.getConfirmDebit());
            }
            if (info.getConfirmCredit() != null) {
                BigDecimal bigDecimal = billConfirmCredit = billConfirmCredit == null ? BigDecimal.ZERO.add(info.getConfirmCredit()) : billConfirmCredit.add(info.getConfirmCredit());
            }
            if ((billConfirmDebit != null || billConfirmCredit != null) && billheadInfo != null) {
                billheadInfo.setCompanyDiff((billConfirmDebit != null ? billConfirmDebit : BigDecimal.ZERO).subtract(billConfirmCredit != null ? billConfirmCredit : BigDecimal.ZERO));
            }
            preCompanyId = companyId;
        }
    }

    private void mainTainHeadNumber(Context ctx, CheckageBillInfo info, Map<String, Set<String>> maxbillHeadCompanyKeyNumberMap, AccountCheckWorkeFilterInfo filterInfo) throws BOSException, SQLException {
        String companyKey = info.getString("companyKey");
        if (maxbillHeadCompanyKeyNumberMap.containsKey(companyKey)) {
            return;
        }
        int year = filterInfo.getYear();
        int period = filterInfo.getPeriod();
        String currencyId = filterInfo.getCurrencyId();
        String companyId = info.getCompany().getId().toString();
        String tarCompanyId = info.getTargetCompany().getId().toString();
        Set<String> sameCompanyKeySet = maxbillHeadCompanyKeyNumberMap.get(companyKey);
        if (sameCompanyKeySet == null) {
            sameCompanyKeySet = new HashSet<String>();
            maxbillHeadCompanyKeyNumberMap.put(companyKey, sameCompanyKeySet);
        }
        SQLBuilder sql = new SQLBuilder();
        sql.reset();
        sql.append("select distinct billHead.Fnumber headNumber from T_Csl_CheckageBill bill inner join T_Csl_CheckageBillHead billHead on billHead.Fid=bill.FBillHeadId   \n");
        sql.append("where bill.FYear=?    \n", year);
        sql.append("and bill.FPeriod=?    \n", period);
        sql.append("and bill.FCurrencyId=?  \n", currencyId);
        sql.append("and ((bill.FCompanyId=?  \n", companyId);
        sql.append("and bill.FTargetCompanyId=?)  \n", tarCompanyId);
        sql.append("or (bill.FCompanyId=?  \n", tarCompanyId);
        sql.append("and bill.FTargetCompanyId=?)) \n", companyId);
        IRowSet dataRow = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (dataRow != null && dataRow.size() > 0) {
            while (dataRow.next()) {
                sameCompanyKeySet.add(dataRow.getString("headNumber"));
            }
        }
    }

    private String getHeadNumber(Set<String> sameCompanyKeyNumberSet, NumberFormat nf, String headNumber, String tailNumber) {
        String number;
        if (sameCompanyKeyNumberSet.contains(headNumber + tailNumber)) {
            number = this.getHeadNumber(sameCompanyKeyNumberSet, nf, headNumber, nf.format(Integer.parseInt(tailNumber) + 1));
        } else {
            number = headNumber + tailNumber;
            sameCompanyKeyNumberSet.add(number);
        }
        return number;
    }

    private void appendToSameHead(Context ctx, CoreBaseCollection addNewDataCol, AccountCheckWorkeFilterInfo filterInfo, Set<String> updateHeadBillDiffSet, String schmId, ItemTypeEnum itemTypeEnum, Map<String, Map<Integer, Set<String>>> mapIdInfoMap, Set<String> needUpdateDiffItemHeadIdSet) throws BOSException, SQLException, EASBizException {
        if (addNewDataCol == null || addNewDataCol.isEmpty()) {
            return;
        }
        SQLBuilder sql = new SQLBuilder();
        int year = filterInfo.getYear();
        int period = filterInfo.getPeriod();
        String currencyId = filterInfo.getCurrencyId();
        HashMap headToMapMap = new HashMap();
        HashMap<String, Set<String>> keyMap = new HashMap<String, Set<String>>();
        HashMap headDirectMap = new HashMap();
        HashMap billCompanyDirectMap = new HashMap();
        HashMap<String, Integer> billCompanyConfirmStMap = new HashMap<String, Integer>();
        CoreBaseCollection addNewBillCompanyCol = new CoreBaseCollection();
        CoreBaseCollection needUpdateSchmBillCompanyCol = new CoreBaseCollection();
        HashSet existBillCompanyId = new HashSet();
        block0: for (int i = 0; i < addNewDataCol.size(); ++i) {
            Set<String> billheadSet;
            CheckageBillInfo info = (CheckageBillInfo)addNewDataCol.get(i);
            String mapId = (String)info.get("mapId");
            if (!mapIdInfoMap.containsKey(mapId)) {
                this.findAccountInSameMap(ctx, mapIdInfoMap, mapId, itemTypeEnum);
            }
            String accountAndBalTypeKey = info.getAccount().getNumber() + info.getBalType().getValue();
            Map<Integer, Set<String>> mapAccountMap = mapIdInfoMap.get(mapId);
            Set<String> selfKeySet = mapAccountMap.get(1);
            Set<String> tarKeySet = mapAccountMap.get(0);
            boolean isSelf = selfKeySet.contains(accountAndBalTypeKey);
            String companyId = info.getCompany().getId().toString();
            String tarCompanyId = info.getTargetCompany().getId().toString();
            String outCompanyKey = companyId + tarCompanyId;
            String companyKey = (String)info.get("companyKey");
            String key = mapId + companyKey;
            if (!keyMap.containsKey(key)) {
                billheadSet = new HashSet();
                keyMap.put(key, billheadSet);
                sql.reset();
                sql.append("select bill.FCompanyId,bill.FTargetCompanyId,bill.FBillHeadId,bill.FBillCompanyId,billCompany.FConfirmStatus,billHead.FAccountMapId,acMapac.FIsMapAccount,  \n");
                sql.append("ckAccount.FItemNumber,ckAccount.FBalType   \n");
                sql.append("from T_Csl_CheckageBill bill  \n");
                sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.fid=bill.FBillCompanyId  \n");
                sql.append("inner join T_BD_AccountView accountView on accountView.Fid=bill.FAccountId  \n");
                sql.append("inner join T_Csl_CheckageBillHead billHead on billHead.Fid=bill.FBillHeadId  \n");
                sql.append("inner join T_Csl_AccountAndMapAccount acMapac on acMapac.FAccountMapId=billHead.FAccountMapId  \n");
                sql.append("inner join T_Csl_CheckageAccount ckAccount on ckAccount.Fid=acMapac.FCheckAccountId and ckAccount.FItemNumber=accountView.fnumber and ckAccount.FBalType=bill.FBalType \n");
                sql.append("where bill.FYear=?  \n", year);
                sql.append("and bill.FPeriod=?  \n", period);
                sql.append("and bill.FCurrencyId=?  \n", currencyId);
                sql.append("and billHead.FAccountMapId=?  \n", mapId);
                sql.append("and ((bill.FCompanyId=?  \n", companyId);
                sql.append("and bill.FTargetCompanyId=?)  \n", tarCompanyId);
                sql.append("or (bill.FCompanyId=?  \n", tarCompanyId);
                sql.append("and bill.FTargetCompanyId=?))  \n", companyId);
                sql.append("order by billHead.FAccountMapId,bill.FBillHeadId ");
                IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (rowSet != null && rowSet.size() > 0) {
                    while (rowSet.next()) {
                        HashMap<Integer, String> billCompanyMap;
                        HashMap<Integer, String> companyDirectMap;
                        String bllHeadId = rowSet.getString("FBillHeadId");
                        billheadSet.add(bllHeadId);
                        String inCompanyId = rowSet.getString("FCompanyId");
                        String inTarCompanyId = rowSet.getString("FTargetCompanyId");
                        String inCompanyKey = inCompanyId + inTarCompanyId;
                        int isMapAccount = rowSet.getInt("FIsMapAccount");
                        String billCompanyId = rowSet.getString("FBillCompanyId");
                        if (!billCompanyConfirmStMap.containsKey(billCompanyId)) {
                            billCompanyConfirmStMap.put(billCompanyId, rowSet.getInt("FConfirmStatus"));
                        }
                        if ((companyDirectMap = (HashMap<Integer, String>)headDirectMap.get(bllHeadId)) == null) {
                            companyDirectMap = new HashMap<Integer, String>();
                            headDirectMap.put(bllHeadId, companyDirectMap);
                        }
                        if ((billCompanyMap = (HashMap<Integer, String>)billCompanyDirectMap.get(bllHeadId)) == null) {
                            billCompanyMap = new HashMap<Integer, String>();
                            billCompanyDirectMap.put(bllHeadId, billCompanyMap);
                        }
                        if (isMapAccount == 1) {
                            if (!companyDirectMap.containsKey(1)) {
                                companyDirectMap.put(1, inCompanyKey);
                            }
                            if (billCompanyMap.containsKey(1)) continue;
                            billCompanyMap.put(1, billCompanyId);
                            continue;
                        }
                        if (!companyDirectMap.containsKey(0)) {
                            companyDirectMap.put(0, inCompanyKey);
                        }
                        if (billCompanyMap.containsKey(0)) continue;
                        billCompanyMap.put(0, billCompanyId);
                    }
                }
            }
            billheadSet = (Set)keyMap.get(key);
            for (String bllHeadId : billheadSet) {
                CheckageBillHeadInfo headInfo;
                CheckageBillCompanyInfo ckBillCompanyInfo;
                Map companyDirectMap = (Map)headDirectMap.get(bllHeadId);
                Map billCompanyMap = (Map)billCompanyDirectMap.get(bllHeadId);
                if (companyDirectMap.containsKey(1) && !companyDirectMap.containsKey(0)) {
                    if (isSelf) {
                        if (!((String)companyDirectMap.get(1)).equals(outCompanyKey) || billCompanyConfirmStMap.containsKey(billCompanyMap.get(1)) && (Integer)billCompanyConfirmStMap.get(billCompanyMap.get(1)) == 1) continue;
                        ckBillCompanyInfo = new CheckageBillCompanyInfo();
                        ckBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                        ckBillCompanyInfo.setId(BOSUuid.read((String)((String)billCompanyMap.get(1))));
                        if (schmId != null && !existBillCompanyId.contains(billCompanyMap.get(1))) {
                            ckBillCompanyInfo.setPackSchmId(schmId);
                            needUpdateSchmBillCompanyCol.add((CoreBaseInfo)ckBillCompanyInfo);
                            existBillCompanyId.add(billCompanyMap.get(1));
                        }
                        info.setBillCompany(ckBillCompanyInfo);
                        headInfo = new CheckageBillHeadInfo();
                        headInfo.setId(BOSUuid.read((String)bllHeadId));
                        info.setBillHead(headInfo);
                        continue block0;
                    }
                    if (((String)companyDirectMap.get(1)).equals(outCompanyKey)) continue;
                    this.creatNewBillCompany(info, addNewBillCompanyCol, bllHeadId, schmId);
                    companyDirectMap.put(0, outCompanyKey);
                    billCompanyMap.put(0, info.getBillCompany().getId().toString());
                    continue block0;
                }
                if (companyDirectMap.containsKey(0) && !companyDirectMap.containsKey(1)) {
                    if (!isSelf) {
                        if (!((String)companyDirectMap.get(0)).equals(outCompanyKey) || billCompanyConfirmStMap.containsKey(billCompanyMap.get(0)) && (Integer)billCompanyConfirmStMap.get(billCompanyMap.get(0)) == 1) continue;
                        ckBillCompanyInfo = new CheckageBillCompanyInfo();
                        ckBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                        ckBillCompanyInfo.setId(BOSUuid.read((String)((String)billCompanyMap.get(0))));
                        if (schmId != null && !existBillCompanyId.contains(billCompanyMap.get(0))) {
                            ckBillCompanyInfo.setPackSchmId(schmId);
                            needUpdateSchmBillCompanyCol.add((CoreBaseInfo)ckBillCompanyInfo);
                            existBillCompanyId.add(billCompanyMap.get(0));
                        }
                        info.setBillCompany(ckBillCompanyInfo);
                        headInfo = new CheckageBillHeadInfo();
                        headInfo.setId(BOSUuid.read((String)bllHeadId));
                        info.setBillHead(headInfo);
                        continue block0;
                    }
                    if (((String)companyDirectMap.get(0)).equals(outCompanyKey)) continue;
                    this.creatNewBillCompany(info, addNewBillCompanyCol, bllHeadId, schmId);
                    companyDirectMap.put(1, outCompanyKey);
                    billCompanyMap.put(1, info.getBillCompany().getId().toString());
                    continue block0;
                }
                if (isSelf) {
                    if (!((String)companyDirectMap.get(1)).equals(outCompanyKey) || billCompanyConfirmStMap.containsKey(billCompanyMap.get(1)) && (Integer)billCompanyConfirmStMap.get(billCompanyMap.get(1)) == 1) continue;
                    ckBillCompanyInfo = new CheckageBillCompanyInfo();
                    ckBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                    ckBillCompanyInfo.setId(BOSUuid.read((String)((String)billCompanyMap.get(1))));
                    if (schmId != null && !existBillCompanyId.contains(billCompanyMap.get(1))) {
                        ckBillCompanyInfo.setPackSchmId(schmId);
                        needUpdateSchmBillCompanyCol.add((CoreBaseInfo)ckBillCompanyInfo);
                        existBillCompanyId.add(billCompanyMap.get(1));
                    }
                    info.setBillCompany(ckBillCompanyInfo);
                    headInfo = new CheckageBillHeadInfo();
                    headInfo.setId(BOSUuid.read((String)bllHeadId));
                    info.setBillHead(headInfo);
                    continue block0;
                }
                if (!((String)companyDirectMap.get(0)).equals(outCompanyKey) || billCompanyConfirmStMap.containsKey(billCompanyMap.get(0)) && (Integer)billCompanyConfirmStMap.get(billCompanyMap.get(0)) == 1) continue;
                ckBillCompanyInfo = new CheckageBillCompanyInfo();
                ckBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                ckBillCompanyInfo.setId(BOSUuid.read((String)((String)billCompanyMap.get(0))));
                if (schmId != null && !existBillCompanyId.contains(billCompanyMap.get(0))) {
                    ckBillCompanyInfo.setPackSchmId(schmId);
                    needUpdateSchmBillCompanyCol.add((CoreBaseInfo)ckBillCompanyInfo);
                    existBillCompanyId.add(billCompanyMap.get(0));
                }
                info.setBillCompany(ckBillCompanyInfo);
                headInfo = new CheckageBillHeadInfo();
                headInfo.setId(BOSUuid.read((String)bllHeadId));
                info.setBillHead(headInfo);
                continue block0;
            }
        }
        if (needUpdateSchmBillCompanyCol.size() > 0) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("packSchmId"));
            CheckageBillCompanyFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)needUpdateSchmBillCompanyCol, selector);
        }
        if (addNewBillCompanyCol.size() > 0) {
            CheckageBillCompanyFactory.getLocalInstance(ctx).addnewBatchData(addNewBillCompanyCol);
        }
        this.creatHeadAndBillCompany(ctx, addNewDataCol, filterInfo, mapIdInfoMap, updateHeadBillDiffSet, schmId, itemTypeEnum, needUpdateDiffItemHeadIdSet);
    }

    private void appendToSameHead_rptItemType(Context ctx, CoreBaseCollection addNewDataCol, AccountCheckWorkeFilterInfo filterInfo, Set<String> updateHeadBillDiffSet, String schmId, ItemTypeEnum itemTypeEnum, Map<String, Map<Integer, Set<String>>> mapIdInfoMap, Set<String> needUpdateDiffItemHeadIdSet) throws BOSException, SQLException, EASBizException {
        if (addNewDataCol == null || addNewDataCol.isEmpty()) {
            return;
        }
        SQLBuilder sql = new SQLBuilder();
        int year = filterInfo.getYear();
        int period = filterInfo.getPeriod();
        String currencyId = filterInfo.getCurrencyId();
        HashMap headToMapMap = new HashMap();
        HashMap<String, Set<String>> keyMap = new HashMap<String, Set<String>>();
        HashMap headDirectMap = new HashMap();
        HashMap billCompanyDirectMap = new HashMap();
        HashMap<String, Integer> billCompanyConfirmStMap = new HashMap<String, Integer>();
        CoreBaseCollection addNewBillCompanyCol = new CoreBaseCollection();
        CoreBaseCollection needUpdateSchmBillCompanyCol = new CoreBaseCollection();
        HashSet existBillCompanyId = new HashSet();
        block0: for (int i = 0; i < addNewDataCol.size(); ++i) {
            Set<String> billheadSet;
            CheckageBillInfo info = (CheckageBillInfo)addNewDataCol.get(i);
            String mapId = (String)info.get("mapId");
            if (!mapIdInfoMap.containsKey(mapId)) {
                this.findAccountInSameMap(ctx, mapIdInfoMap, mapId, itemTypeEnum);
            }
            String itemAndDataElementKey = info.getItemNumber() + info.getDataElement();
            Map<Integer, Set<String>> mapAccountMap = mapIdInfoMap.get(mapId);
            Set<String> selfKeySet = mapAccountMap.get(1);
            Set<String> tarKeySet = mapAccountMap.get(0);
            boolean isSelf = selfKeySet.contains(itemAndDataElementKey);
            String companyId = info.getCompany().getId().toString();
            String tarCompanyId = info.getTargetCompany().getId().toString();
            String outCompanyKey = companyId + tarCompanyId;
            String companyKey = (String)info.get("companyKey");
            String key = mapId + companyKey;
            if (!keyMap.containsKey(key)) {
                billheadSet = new HashSet();
                keyMap.put(key, billheadSet);
                sql.reset();
                sql.append("select bill.FCompanyId,bill.FTargetCompanyId,bill.FBillHeadId,bill.FBillCompanyId,billCompany.FConfirmStatus,billHead.FAccountMapId,acMapac.FIsMapAccount,  \n");
                sql.append("ckAccount.FItemNumber,ckAccount.FDataElement   \n");
                sql.append("from T_Csl_CheckageBill bill  \n");
                sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.fid=bill.FBillCompanyId  \n");
                sql.append("inner join T_Csl_CheckageBillHead billHead on billHead.Fid=bill.FBillHeadId  \n");
                sql.append("inner join T_Csl_AccountAndMapAccount acMapac on acMapac.FAccountMapId=billHead.FAccountMapId  \n");
                sql.append("inner join T_Csl_CheckageAccount ckAccount on ckAccount.Fid=acMapac.FCheckAccountId and ckAccount.FItemNumber=bill.FItemNumber and ckAccount.FDataElement=bill.FDataElement \n");
                sql.append("where bill.FYear=?  \n", year);
                sql.append("and bill.FPeriod=?  \n", period);
                sql.append("and bill.FCurrencyId=?  \n", currencyId);
                sql.append("and billHead.FAccountMapId=?  \n", mapId);
                sql.append("and ((bill.FCompanyId=?  \n", companyId);
                sql.append("and bill.FTargetCompanyId=?)  \n", tarCompanyId);
                sql.append("or (bill.FCompanyId=?  \n", tarCompanyId);
                sql.append("and bill.FTargetCompanyId=?))  \n", companyId);
                sql.append("order by billHead.FAccountMapId,bill.FBillHeadId ");
                IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (rowSet != null && rowSet.size() > 0) {
                    while (rowSet.next()) {
                        HashMap<Integer, String> billCompanyMap;
                        HashMap<Integer, String> companyDirectMap;
                        String bllHeadId = rowSet.getString("FBillHeadId");
                        billheadSet.add(bllHeadId);
                        String inCompanyId = rowSet.getString("FCompanyId");
                        String inTarCompanyId = rowSet.getString("FTargetCompanyId");
                        String inCompanyKey = inCompanyId + inTarCompanyId;
                        int isMapAccount = rowSet.getInt("FIsMapAccount");
                        String billCompanyId = rowSet.getString("FBillCompanyId");
                        if (!billCompanyConfirmStMap.containsKey(billCompanyId)) {
                            billCompanyConfirmStMap.put(billCompanyId, rowSet.getInt("FConfirmStatus"));
                        }
                        if ((companyDirectMap = (HashMap<Integer, String>)headDirectMap.get(bllHeadId)) == null) {
                            companyDirectMap = new HashMap<Integer, String>();
                            headDirectMap.put(bllHeadId, companyDirectMap);
                        }
                        if ((billCompanyMap = (HashMap<Integer, String>)billCompanyDirectMap.get(bllHeadId)) == null) {
                            billCompanyMap = new HashMap<Integer, String>();
                            billCompanyDirectMap.put(bllHeadId, billCompanyMap);
                        }
                        if (isMapAccount == 1) {
                            if (!companyDirectMap.containsKey(1)) {
                                companyDirectMap.put(1, inCompanyKey);
                            }
                            if (billCompanyMap.containsKey(1)) continue;
                            billCompanyMap.put(1, billCompanyId);
                            continue;
                        }
                        if (!companyDirectMap.containsKey(0)) {
                            companyDirectMap.put(0, inCompanyKey);
                        }
                        if (billCompanyMap.containsKey(0)) continue;
                        billCompanyMap.put(0, billCompanyId);
                    }
                }
            }
            billheadSet = (Set)keyMap.get(key);
            for (String bllHeadId : billheadSet) {
                CheckageBillHeadInfo headInfo;
                CheckageBillCompanyInfo ckBillCompanyInfo;
                Map companyDirectMap = (Map)headDirectMap.get(bllHeadId);
                Map billCompanyMap = (Map)billCompanyDirectMap.get(bllHeadId);
                if (companyDirectMap.containsKey(1) && !companyDirectMap.containsKey(0)) {
                    if (isSelf) {
                        if (!((String)companyDirectMap.get(1)).equals(outCompanyKey) || billCompanyConfirmStMap.containsKey(billCompanyMap.get(1)) && (Integer)billCompanyConfirmStMap.get(billCompanyMap.get(1)) == 1) continue;
                        ckBillCompanyInfo = new CheckageBillCompanyInfo();
                        ckBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                        ckBillCompanyInfo.setId(BOSUuid.read((String)((String)billCompanyMap.get(1))));
                        if (schmId != null && !existBillCompanyId.contains(billCompanyMap.get(1))) {
                            ckBillCompanyInfo.setPackSchmId(schmId);
                            needUpdateSchmBillCompanyCol.add((CoreBaseInfo)ckBillCompanyInfo);
                            existBillCompanyId.add(billCompanyMap.get(1));
                        }
                        info.setBillCompany(ckBillCompanyInfo);
                        headInfo = new CheckageBillHeadInfo();
                        headInfo.setId(BOSUuid.read((String)bllHeadId));
                        info.setBillHead(headInfo);
                        continue block0;
                    }
                    if (((String)companyDirectMap.get(1)).equals(outCompanyKey)) continue;
                    this.creatNewBillCompany(info, addNewBillCompanyCol, bllHeadId, schmId);
                    companyDirectMap.put(0, outCompanyKey);
                    billCompanyMap.put(0, info.getBillCompany().getId().toString());
                    continue block0;
                }
                if (companyDirectMap.containsKey(0) && !companyDirectMap.containsKey(1)) {
                    if (!isSelf) {
                        if (!((String)companyDirectMap.get(0)).equals(outCompanyKey) || billCompanyConfirmStMap.containsKey(billCompanyMap.get(0)) && (Integer)billCompanyConfirmStMap.get(billCompanyMap.get(0)) == 1) continue;
                        ckBillCompanyInfo = new CheckageBillCompanyInfo();
                        ckBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                        ckBillCompanyInfo.setId(BOSUuid.read((String)((String)billCompanyMap.get(0))));
                        if (schmId != null && !existBillCompanyId.contains(billCompanyMap.get(0))) {
                            ckBillCompanyInfo.setPackSchmId(schmId);
                            needUpdateSchmBillCompanyCol.add((CoreBaseInfo)ckBillCompanyInfo);
                            existBillCompanyId.add(billCompanyMap.get(0));
                        }
                        info.setBillCompany(ckBillCompanyInfo);
                        headInfo = new CheckageBillHeadInfo();
                        headInfo.setId(BOSUuid.read((String)bllHeadId));
                        info.setBillHead(headInfo);
                        continue block0;
                    }
                    if (((String)companyDirectMap.get(0)).equals(outCompanyKey)) continue;
                    this.creatNewBillCompany(info, addNewBillCompanyCol, bllHeadId, schmId);
                    companyDirectMap.put(1, outCompanyKey);
                    billCompanyMap.put(1, info.getBillCompany().getId().toString());
                    continue block0;
                }
                if (isSelf) {
                    if (!((String)companyDirectMap.get(1)).equals(outCompanyKey) || billCompanyConfirmStMap.containsKey(billCompanyMap.get(1)) && (Integer)billCompanyConfirmStMap.get(billCompanyMap.get(1)) == 1) continue;
                    ckBillCompanyInfo = new CheckageBillCompanyInfo();
                    ckBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                    ckBillCompanyInfo.setId(BOSUuid.read((String)((String)billCompanyMap.get(1))));
                    if (schmId != null && !existBillCompanyId.contains(billCompanyMap.get(1))) {
                        ckBillCompanyInfo.setPackSchmId(schmId);
                        needUpdateSchmBillCompanyCol.add((CoreBaseInfo)ckBillCompanyInfo);
                        existBillCompanyId.add(billCompanyMap.get(1));
                    }
                    info.setBillCompany(ckBillCompanyInfo);
                    headInfo = new CheckageBillHeadInfo();
                    headInfo.setId(BOSUuid.read((String)bllHeadId));
                    info.setBillHead(headInfo);
                    continue block0;
                }
                if (!((String)companyDirectMap.get(0)).equals(outCompanyKey) || billCompanyConfirmStMap.containsKey(billCompanyMap.get(0)) && (Integer)billCompanyConfirmStMap.get(billCompanyMap.get(0)) == 1) continue;
                ckBillCompanyInfo = new CheckageBillCompanyInfo();
                ckBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                ckBillCompanyInfo.setId(BOSUuid.read((String)((String)billCompanyMap.get(0))));
                if (schmId != null && !existBillCompanyId.contains(billCompanyMap.get(0))) {
                    ckBillCompanyInfo.setPackSchmId(schmId);
                    needUpdateSchmBillCompanyCol.add((CoreBaseInfo)ckBillCompanyInfo);
                    existBillCompanyId.add(billCompanyMap.get(0));
                }
                info.setBillCompany(ckBillCompanyInfo);
                headInfo = new CheckageBillHeadInfo();
                headInfo.setId(BOSUuid.read((String)bllHeadId));
                info.setBillHead(headInfo);
                continue block0;
            }
        }
        if (needUpdateSchmBillCompanyCol.size() > 0) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("packSchmId"));
            CheckageBillCompanyFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)needUpdateSchmBillCompanyCol, selector);
        }
        if (addNewBillCompanyCol.size() > 0) {
            CheckageBillCompanyFactory.getLocalInstance(ctx).addnewBatchData(addNewBillCompanyCol);
        }
        this.creatHeadAndBillCompany(ctx, addNewDataCol, filterInfo, mapIdInfoMap, updateHeadBillDiffSet, schmId, itemTypeEnum, needUpdateDiffItemHeadIdSet);
    }

    private void fetchTempData(Context ctx, AccountCheckWorkeFilterInfo filterInfo, String billTmpTable, String fetchTmpTable, ItemTypeEnum itemTypeEnum) throws BOSException {
        boolean isAccountType = ItemTypeEnum.account == itemTypeEnum;
        boolean isOnlyDiffShow = filterInfo.isOnlyDiffShow();
        ConfirmStatusEnum confirmStatus = filterInfo.getConfirmStatus();
        AuditedStatusEnum auditStatus = filterInfo.getAuditStatus();
        DataSourceEnum dataSource = filterInfo.getDataSource();
        CompareCharEnum diffType = filterInfo.getDiffType();
        BigDecimal diffAmount = filterInfo.getDiffAmount();
        boolean dataChange = filterInfo.isDataChange();
        Set<String> headNumberSet = filterInfo.getHeadNumberSet();
        SQLBuilder sql = new SQLBuilder();
        sql.append("insert into ").append(fetchTmpTable);
        sql.append("(sumbillConfirmCrebit,seq,billId,billBillCompanyId,accountMapId,accountMapNumber,billHeadId,billHeadNumber,billCompanyId,companyName,companyNumber,tarBillCompanyId,tarCompanyName, \n");
        if (isAccountType) {
            sql.append("tarcompanyNumber,accountViewId,accountViewNumber,accountViewName,billBalType,billCurrencyId,billCurrencyName,billDebit,billCredit,billConfirmDebit,billConfirmCredit, \n");
        } else {
            sql.append("tarcompanyNumber,itemNumber,itemName,billDataElement,billDataElementName,billCurrencyId,billCurrencyName,billDebit,billCredit,billConfirmDebit,billConfirmCredit, \n");
        }
        sql.append("billAuditDebit,billAuditCredit,billHeadCompanyDiff,companyKey,billCompanyDiffRemark,billCompanyConfirmorId,confirmorName,billCompanyConfirmTime,dataChange,tarDataChange,billCompanyConfirmSt, \n");
        sql.append("tarbillCompanyConfirmSt,billHeadAuditedStatus,accountDirectSeq,isIncludingUnPosted, itemTypeEnum, dataSource, remark, companySeq) \n");
        sql.append("(select rs.t1SumbillConfirmCrebit,rs.seq,rs.billId,rs.billBillCompanyId,rs.accountMapId,rs.accountMapNumber,rs.billHeadId,rs.billHeadNumber,rs.billCompanyId,rs.companyName,rs.companyNumber, \t\t \n");
        sql.append("rs.tarBillCompanyId,rs.tarCompanyName,rs.tarcompanyNumber, \t\t \n");
        if (isAccountType) {
            sql.append("rs.accountViewId,rs.accountViewNumber,rs.accountViewName,rs.billBalType,rs.billCurrencyId,rs.billCurrencyName,rs.billDebit,rs.billCredit,  \n");
        } else {
            sql.append("rs.itemNumber,rs.itemName,rs.billDataElement,dataEl.fname_").append(ctx.getLocale().getLanguage()).append(",rs.billCurrencyId,rs.billCurrencyName,rs.billDebit,rs.billCredit,  \n");
        }
        sql.append("rs.billConfirmDebit,rs.billConfirmCredit,rs.billAuditDebit,rs.billAuditCredit,rs.billHeadCompanyDiff, rs.companyKey,rs.billCompanyDiffRemark,rs.billCompanyConfirmorId, rs.confirmorName,rs.billCompanyConfirmTime,\n");
        sql.append("rs.dataChange,rs.tarDataChange,rs.billCompanyConfirmSt,rs.TARBILLCOMPANYCONFIRMST,rs.billHeadAuditedStatus,rs.accountDirectSeq,rs.isIncludingUnPosted,rs.itemTypeEnum itemTypeEnum,rs.dataSource dataSource,rs.remark remark, rs.companySeq companySeq from  \n");
        sql.append("(select t2.companyKey companyKey,t2.isIncludingUnPosted isIncludingUnPosted, t2.billItemType itemTypeEnum, t2.dataSource dataSource,t2.remark remark, \n");
        sql.append("t2.seq seq,t2.billId billId,t2.billBillCompanyId billBillCompanyId,t2.accountMapId accountMapId,t2.accountMapNumber accountMapNumber,t2.billHeadId billHeadId,t2.billHeadNumber billHeadNumber,t2.companyNumber, \n");
        sql.append("t2.billCompanyId billCompanyId,t2.companyName companyName,t2.tarBillCompanyId tarBillCompanyId,t2.tarCompanyName tarCompanyName,t2.tarcompanyNumber tarcompanyNumber,  \n");
        if (isAccountType) {
            sql.append("t2.accountViewId accountViewId,t2.accountViewNumber accountViewNumber,t2.accountViewName accountViewName,t2.billBalType billBalType,t2.billCurrencyId billCurrencyId,  \n");
        } else {
            sql.append("t2.itemNumber itemNumber,t2.itemName itemName,t2.billDataElement billDataElement,t2.billCurrencyId billCurrencyId,  \n");
        }
        sql.append("t2.billCurrencyName billCurrencyName, t2.billDebit billDebit,t2.billCredit billCredit,t2.billConfirmDebit billConfirmDebit,t2.billConfirmCredit billConfirmCredit,  \n");
        sql.append("t2.billAuditDebit billAuditDebit,t2.billAuditCredit billAuditCredit,t2.billHeadCompanyDiff billHeadCompanyDiff,t2.billCompanyDiffRemark billCompanyDiffRemark,  \n");
        sql.append("t2.billCompanyConfirmorId billCompanyConfirmorId,t2.confirmorName confirmorName,t2.billCompanyConfirmTime billCompanyConfirmTime,t2.dataChange dataChange,t2.tarDataChange tarDataChange, \n");
        sql.append("t2.billCompanyConfirmSt billCompanyConfirmSt,t2.TARBILLCOMPANYCONFIRMST TARBILLCOMPANYCONFIRMST,t2.billHeadAuditedStatus billHeadAuditedStatus, \n");
        sql.append("t2.accountDirectSeq accountDirectSeq,abs(t1.sumbillConfirmCrebit) t1SumbillConfirmCrebit,t2.companySeq companySeq from   \n");
        sql.append("(select billHeadId,accountMapId,companyKey,isnull(sum(billConfirmDebit),0)-isnull(sum(billConfirmCredit),0) sumbillConfirmCrebit from     \n");
        sql.append(billTmpTable);
        sql.append(" group by billHeadId,accountMapId,companyKey) t1  \n");
        sql.append("inner join  \n");
        sql.append(billTmpTable);
        sql.append(" t2 on t2.accountMapId=t1.accountMapId and t2.billHeadId=t1.billHeadId and t2.companyKey=t1.companyKey \n");
        sql.append(")  rs \n");
        if (!isAccountType) {
            sql.append("inner join T_CSL_DataElement dataEl on dataEl.fInterseq=rs.billDataElement \n");
        }
        boolean hasFilter = false;
        if (isOnlyDiffShow) {
            sql.append("where t1SumbillConfirmCrebit <> 0 \n");
            hasFilter = true;
        }
        if (diffAmount != null && diffType != null) {
            if (hasFilter) {
                sql.append(" and ");
            } else {
                sql.append(" where ");
            }
            sql.append(" t1SumbillConfirmCrebit ").append((Object)diffType).append(" ").append(diffAmount).append(" \n");
            hasFilter = true;
        }
        if (dataSource != null) {
            if (hasFilter) {
                sql.append(" and ");
            } else {
                sql.append(" where ");
            }
            sql.append(" dataSource=").append(dataSource.getValue());
            hasFilter = true;
        }
        if (confirmStatus != null) {
            if (confirmStatus.getValue() == 1) {
                if (hasFilter) {
                    sql.append(" and ");
                } else {
                    sql.append(" where ");
                }
                sql.append(" (billCompanyConfirmSt=1 or TARBILLCOMPANYCONFIRMST=1) \n");
                hasFilter = true;
            } else if (confirmStatus.getValue() == 0) {
                if (hasFilter) {
                    sql.append(" and ");
                } else {
                    sql.append(" where ");
                }
                sql.append(" (billCompanyConfirmSt=0 or TARBILLCOMPANYCONFIRMST=0) \n");
                hasFilter = true;
            }
        }
        if (auditStatus != null) {
            if (auditStatus.getValue() == 2) {
                if (hasFilter) {
                    sql.append(" and ");
                } else {
                    sql.append(" where ");
                }
                sql.append(" billHeadAuditedStatus=2 \n");
                hasFilter = true;
            } else if (auditStatus.getValue() == 1) {
                if (hasFilter) {
                    sql.append(" and ");
                } else {
                    sql.append(" where ");
                }
                sql.append(" billHeadAuditedStatus=1 \n");
                hasFilter = true;
            }
        }
        if (dataChange) {
            if (hasFilter) {
                sql.append(" and ");
            } else {
                sql.append(" where ");
            }
            sql.append(" (dataChange=1 or tarDataChange=1)");
            hasFilter = true;
        }
        if (!headNumberSet.isEmpty()) {
            if (hasFilter) {
                sql.append(" and ");
            } else {
                sql.append(" where ");
            }
            sql.append(" billHeadNumber in ", headNumberSet);
            hasFilter = true;
        }
        sql.append(" order by billHeadNumber,accountMapId,companyKey,companySeq,accountDirectSeq) \n");
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    private void creatNewBillCompany(CheckageBillInfo info, CoreBaseCollection addNewBillCompanyCol, String bllHeadId, String schmId) {
        CheckageBillCompanyInfo ckBillCompanyInfo = new CheckageBillCompanyInfo();
        BOSUuid billCompanyId = BOSUuid.create((BOSObjectType)ckBillCompanyInfo.getBOSType());
        ckBillCompanyInfo.setId(billCompanyId);
        ckBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
        if (schmId != null) {
            ckBillCompanyInfo.setPackSchmId(schmId);
        }
        info.setBillCompany(ckBillCompanyInfo);
        addNewBillCompanyCol.add((CoreBaseInfo)ckBillCompanyInfo);
        CheckageBillHeadInfo headInfo = new CheckageBillHeadInfo();
        headInfo.setId(BOSUuid.read((String)bllHeadId));
        info.setBillHead(headInfo);
    }

    @Override
    protected ArrayList _getAccountCheckageBill(Context ctx, AccountCheckWorkeFilterInfo filterInfo) throws BOSException, EASBizException {
        String fetchTmpTable = filterInfo.getTmpTable();
        if (StringUtils.isEmpty((String)fetchTmpTable)) {
            return null;
        }
        ItemTypeEnum itemTypeEnum = filterInfo.getItemTypeEnum();
        if (itemTypeEnum == null) {
            itemTypeEnum = ItemTypeEnum.account;
        }
        boolean isAccountType = ItemTypeEnum.account == itemTypeEnum;
        DataSourceEnum dataSource = filterInfo.getDataSource();
        ArrayList<AccountCheckWorkeInfo> resultList = new ArrayList<AccountCheckWorkeInfo>();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select rs.sumbillConfirmCrebit,rs.seq,rs.billId,rs.billBillCompanyId,rs.accountMapId,rs.accountMapNumber,rs.billHeadId,rs.billHeadNumber,rs.billCompanyId,rs.companyName,rs.companyNumber,rs.tarBillCompanyId,rs.tarCompanyName, \n");
        if (isAccountType) {
            sql.append("rs.tarcompanyNumber,rs.accountViewId,rs.accountViewNumber,rs.accountViewName,rs.billBalType,rs.billCurrencyId,rs.billCurrencyName,rs.billDebit,rs.billCredit,rs.billConfirmDebit,rs.billConfirmCredit, \n");
        } else {
            sql.append("rs.tarcompanyNumber,rs.itemNumber,rs.itemName,rs.billDataElement,rs.billDataElementName,rs.billCurrencyId,rs.billCurrencyName,rs.billDebit,rs.billCredit,rs.billConfirmDebit,rs.billConfirmCredit, \n");
        }
        sql.append("rs.billAuditDebit,rs.billAuditCredit,rs.billHeadCompanyDiff,rs.companyKey,rs.billCompanyDiffRemark,rs.billCompanyConfirmorId,rs.confirmorName,rs.billCompanyConfirmTime,rs.billCompanyConfirmSt, \n");
        sql.append("rs.tarbillCompanyConfirmSt,rs.billHeadAuditedStatus,rs.accountDirectSeq,rs.isIncludingUnPosted,rs.itemTypeEnum,rs.dataSource dataSource,rs.remark remark, rs.companySeq companySeq from \n");
        sql.append("(select sumbillConfirmCrebit,seq,billId,billBillCompanyId,accountMapId,accountMapNumber,billHeadId,billHeadNumber,billCompanyId,companyName,companyNumber,tarBillCompanyId,tarCompanyName,  \n");
        if (isAccountType) {
            sql.append("tarcompanyNumber,accountViewId,accountViewNumber,accountViewName,billBalType,billCurrencyId,billCurrencyName,billDebit,billCredit,billConfirmDebit,billConfirmCredit,  \n");
        } else {
            sql.append("tarcompanyNumber,itemNumber,itemName,billDataElement,billDataElementName,billCurrencyId,billCurrencyName,billDebit,billCredit,billConfirmDebit,billConfirmCredit,  \n");
        }
        sql.append("billAuditDebit,billAuditCredit,billHeadCompanyDiff,companyKey,billCompanyDiffRemark,billCompanyConfirmorId,confirmorName,billCompanyConfirmTime,billCompanyConfirmSt,  \n");
        sql.append("tarbillCompanyConfirmSt,billHeadAuditedStatus,accountDirectSeq,isIncludingUnPosted,itemTypeEnum,dataSource,remark,companySeq from ").append(fetchTmpTable).append("  \n");
        sql.append("union  \n");
        sql.append("select null sumbillConfirmCrebit,2 seq,null billId,null billBillCompanyId,'zzzzzzzzz9' accountMapId, null accountMapNumber,'0000000000000000' billHeadId, \n");
        sql.append("case when billHeadNumber is null then N'zzzzzzzzz9' else billHeadNumber end billHeadNumber,null billCompanyId,null companyName,null companyNumber,null tarBillCompanyId, \n");
        if (isAccountType) {
            sql.append("null tarCompanyName,null tarcompanyNumber,null accountViewId,null accountViewNumber,null accountViewName, null billBalType, \n");
        } else {
            sql.append("null tarCompanyName,null tarcompanyNumber,null itemNumber,null itemName, null billDataElement, null billDataElementName, \n");
        }
        sql.append("null billCurrencyId,null billCurrencyName,isnull(sum(billDebit),0) billDebit,isnull(sum(billCredit),0) billCredit,isnull(sum(billConfirmDebit),0) billConfirmDebit, \n");
        sql.append("isnull(sum(billConfirmCredit),0) billConfirmCredit, isnull(sum(billAuditDebit),0) billAuditDebit,isnull(sum(billAuditCredit),0) billAuditCredit, \n");
        sql.append("null billHeadCompanyDiff,'zzzzzzzzz9' companyKey,null billCompanyDiffRemark,null billCompanyConfirmorId,null confirmorName,null billCompanyConfirmTime,null billCompanyConfirmSt, \n");
        sql.append("null tarbillCompanyConfirmSt,null billHeadAuditedStatus,null accountDirectSeq,null isIncludingUnPosted,null itemTypeEnum,null dataSource,null remark, 2 companySeq from ").append(fetchTmpTable).append("  \n");
        sql.append("group by billHeadNumber with rollup ) rs \n");
        sql.append("order by rs.billHeadNumber,rs.accountMapId,rs.companyKey,rs.companySeq,rs.billCompanyId,rs.accountDirectSeq");
        try {
            int from = filterInfo.getFrom();
            int lenth = filterInfo.getLenth();
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), from, lenth);
            if (rowSet != null && rowSet.size() > 0) {
                int index = -1;
                while (rowSet.next()) {
                    String headId = rowSet.getString("billHeadId");
                    String headNumber = rowSet.getString("billHeadNumber");
                    String companyNumber = rowSet.getString("companyNumber");
                    String tarcompanyNumber = rowSet.getString("tarcompanyNumber");
                    String companyName = rowSet.getString("companyName");
                    String tarcompanyName = rowSet.getString("tarCompanyName");
                    AccountCheckWorkeInfo info = new AccountCheckWorkeInfo();
                    info.billHeadId = headId;
                    info.billDebit = rowSet.getBigDecimal("billDebit");
                    info.billCredit = rowSet.getBigDecimal("billCredit");
                    info.billConfirmDebit = rowSet.getBigDecimal("billConfirmDebit");
                    info.billConfirmCredit = rowSet.getBigDecimal("billConfirmCredit");
                    info.billHeadCompanyDiff = rowSet.getBigDecimal("sumbillConfirmCrebit");
                    if ("0000000000000000".equals(headId)) {
                        if ("zzzzzzzzz9".equals(headNumber)) {
                            info.billHeadId = null;
                            info.billCompanyName = ResourceBase.getString((String)reourcePath, (String)"total", (Locale)ctx.getOriginLocale());
                        } else if (!StringUtils.isEmpty((String)headNumber)) {
                            info.billCompanyName = ResourceBase.getString((String)reourcePath, (String)"subTotal", (Locale)ctx.getOriginLocale());
                        }
                        resultList.add(info);
                        continue;
                    }
                    info.isSelf = rowSet.getInt("companySeq") == 0;
                    info.id = rowSet.getString("billId");
                    info.checkCompany = companyNumber.compareTo(tarcompanyNumber) <= 0 ? companyName + "-" + tarcompanyName : tarcompanyName + "-" + companyName;
                    info.billHeadNumber = headNumber;
                    info.accountMapId = rowSet.getString("accountMapId");
                    info.accountMapNumber = rowSet.getString("accountMapNumber");
                    info.billCompanyId = rowSet.getString("billCompanyId");
                    info.billCompanyName = companyName;
                    info.billTarCompanyName = tarcompanyName;
                    info.billTargetCompanyId = rowSet.getString("tarBillCompanyId");
                    if (isAccountType) {
                        info.billItemId = rowSet.getString("accountViewId");
                        info.billItemNumber = rowSet.getString("accountViewNumber");
                        info.billItemName = rowSet.getString("accountViewName");
                        info.billBalType = rowSet.getInt("billBalType");
                    } else {
                        info.billItemNumber = rowSet.getString("itemNumber");
                        info.billItemName = rowSet.getString("itemName");
                        info.billDataElementIntSeq = rowSet.getInt("billDataElement");
                        info.billDataElementName = rowSet.getString("billDataElementName");
                    }
                    info.billCurrencyId = rowSet.getString("billCurrencyId");
                    info.billCurrencyName = rowSet.getString("billCurrencyName");
                    info.billAuditDebit = rowSet.getBigDecimal("billAuditDebit");
                    info.billAuditCredit = rowSet.getBigDecimal("billAuditCredit");
                    info.billCompanyDiffRemark = rowSet.getString("billCompanyDiffRemark");
                    info.billCompanyConfirmorId = rowSet.getString("billCompanyConfirmorId");
                    info.billCompanyConfirmorName = rowSet.getString("confirmorName");
                    info.billCompanyConfirmTime = (Timestamp)rowSet.getObject("billCompanyConfirmTime");
                    info.billCompanyConfirmStatus = rowSet.getInt("billCompanyConfirmSt");
                    info.billHeadAuditedStatus = rowSet.getInt("billHeadAuditedStatus");
                    info.isIncludeUnPosted = rowSet.getBoolean("isIncludingUnPosted");
                    info.billItemType = ItemTypeEnum.getEnum(rowSet.getInt("itemTypeEnum"));
                    info.billDataSource = DataSourceEnum.getEnum(rowSet.getInt("dataSource"));
                    info.billRemark = rowSet.getString("remark");
                    info.billSeq = ++index;
                    resultList.add(info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"_getAccountCheckageBill error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return resultList;
    }

    @Override
    protected Map _confirm(Context ctx, Map infoMap, boolean isConfirm) throws BOSException, EASBizException {
        return this.confirm(ctx, infoMap, isConfirm, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map confirm(Context ctx, Map infoMap, boolean isConfirm, AutoCheckParams autoCheckParams) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean dataConfirmIsReview = CSLParamUtil.getParamBooleanValue((Context)ctx, (String)"GR_CSL_DZPT_DataConfirmIsReview");
        Map billHeadIdMap = (Map)infoMap.get("billHeadMap");
        Map unHandleDataMap = (Map)infoMap.get("unHandleDataMap");
        if (billHeadIdMap == null || billHeadIdMap.isEmpty()) {
            return null;
        }
        HashSet<String> lockHeadIdSet = new HashSet<String>();
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            boolean canNotConfirmWhenDataDifference;
            boolean bl = canNotConfirmWhenDataDifference = isConfirm && CSLParamUtil.getParamBooleanValue((Context)ctx, (String)"GR_CSL_DZPT_CannotConfirmWhenDataDifference");
            if (canNotConfirmWhenDataDifference) {
                this.batchRequestMutex(ctx, mutexService, lockHeadIdSet, billHeadIdMap.values().iterator());
            }
            HashMap bilateralHeadMap = new HashMap();
            Set auditHeadSet = (Set)infoMap.get("auditHeadSet");
            HashMap<String, Object[]> createdEliminationHeadMap = new HashMap<String, Object[]>();
            SQLBuilder sql = new SQLBuilder();
            if (!isConfirm && dataConfirmIsReview && auditHeadSet != null && !auditHeadSet.isEmpty()) {
                try {
                    sql.reset();
                    String name = "fname_" + ctx.getLocale();
                    sql.append("select bill.FBillHeadId headId, elimi.FPeriodType periodType,tree.").append(name).append(" treeName \n");
                    sql.append("from T_Csl_CheckageBillRelatElim relaElim \n");
                    sql.append("inner join T_Csl_CheckageBill bill on bill.Fid=relaElim.FCheckageBillId \n");
                    sql.append("inner join T_CSL_EliminationEntry elimiEntry on elimiEntry.fid=relaElim.FElimEntryId \n");
                    sql.append("inner join T_CSL_Elimination elimi on elimi.fid=elimiEntry.FEliminationID \n");
                    sql.append("inner join t_org_tree tree on tree.fid=elimi.forgboundid \n");
                    sql.append("where bill.FBillHeadId in  \n", auditHeadSet);
                    IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                    if (rowSet != null && rowSet.size() > 0) {
                        while (rowSet.next()) {
                            String headId = rowSet.getString("headId");
                            if (createdEliminationHeadMap.containsKey(headId)) continue;
                            createdEliminationHeadMap.put(headId, new Object[]{rowSet.getString("treeName"), RptPeriodTypeEnum.getEnum((int)rowSet.getInt("periodType")).getAlias()});
                        }
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"_confirm_queryAuditHeadInfo .", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            String fetchTmpTable = null;
            if (infoMap.containsKey("selectAll")) {
                fetchTmpTable = (String)infoMap.remove("selectAll");
            }
            String schmInfoId = null;
            if (autoCheckParams != null) {
                AutoCheckSchmInfo schmInfo = autoCheckParams.getSchmInfo();
                schmInfoId = schmInfo.getId().toString();
            }
            Set companySet = billHeadIdMap.keySet();
            Iterator it = companySet.iterator();
            Date nowTime = new Date();
            Timestamp nowTimest = new Timestamp(nowTime.getTime());
            UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
            String userId = user.getId().toString();
            HashSet<String> allBillheadIDSet = new HashSet<String>();
            HashMap<String, String> canNotUnAuditHeadIdMap = new HashMap<String, String>();
            HashSet<String> needUnAuditHeadIdSet = new HashSet<String>();
            HashSet<String> needAuditHeadSet = new HashSet<String>();
            while (it.hasNext()) {
                String company = (String)it.next();
                Set billheadIDSet = (Set)billHeadIdMap.get(company);
                if (billheadIDSet.size() <= 0) continue;
                sql.reset();
                sql.append("select distinct bill.FCompanyId, bill.FBillCompanyId FBillCompanyId, bill.FBillHeadId FBillHeadId, billHead.FNumber FNumber from T_Csl_CheckageBill bill \n");
                sql.append("inner join T_Csl_CheckageBillHead billHead on billHead.Fid=bill.FBillHeadId \n");
                sql.append("where bill.FCompanyId=? ", company);
                sql.append("and bill.FBillHeadId in ", billheadIDSet);
                IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (rowSet == null || rowSet.size() <= 0) continue;
                try {
                    SQLBuilder updateTmeSql;
                    Set createdEliminationHeadIdSet = createdEliminationHeadMap.keySet();
                    HashSet<String> billCompanyIdSet = new HashSet<String>();
                    String headId = null;
                    while (rowSet.next()) {
                        if (dataConfirmIsReview) {
                            headId = rowSet.getString("FBillHeadId");
                            if (isConfirm) {
                                needAuditHeadSet.add(headId);
                            }
                            if (createdEliminationHeadIdSet != null && createdEliminationHeadIdSet.contains(headId)) {
                                canNotUnAuditHeadIdMap.put(headId, rowSet.getString("FNumber"));
                                continue;
                            }
                            if (auditHeadSet != null && auditHeadSet.contains(headId)) {
                                needUnAuditHeadIdSet.add(headId);
                            }
                        }
                        if (!isConfirm && unHandleDataMap != null && headId != null && unHandleDataMap.containsKey(headId)) {
                            Map map = (Map)unHandleDataMap.get(headId);
                            String companyId = rowSet.getString("FCompanyId");
                            if (map != null && map.containsKey(companyId)) {
                                map.remove(companyId);
                            }
                        }
                        billCompanyIdSet.add(rowSet.getString("FBillCompanyId"));
                    }
                    sql.reset();
                    if (isConfirm) {
                        if (!billCompanyIdSet.isEmpty()) {
                            sql.append("update T_Csl_CheckageBillCompany set FConfirmStatus=1,FConfirmorId=?", userId);
                            sql.append(",FConfirmTime=? ", nowTimest);
                            if (schmInfoId != null) {
                                sql.append(",FConfirmSchmId=? ", schmInfoId);
                            }
                            sql.append(" where fid in \n", billCompanyIdSet);
                            sql.append(" and FConfirmStatus<>1");
                            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                        }
                        if (StringUtils.isEmpty((String)fetchTmpTable) || billCompanyIdSet.isEmpty()) continue;
                        updateTmeSql = new SQLBuilder();
                        updateTmeSql.append("update ").append(fetchTmpTable).append(" set billCompanyConfirmSt=1,billCompanyConfirmorId=?,", userId);
                        updateTmeSql.append("confirmorName=?,", user.getName());
                        updateTmeSql.append("billCompanyConfirmTime=? \n", nowTimest);
                        updateTmeSql.append("where billBillCompanyId in \n", billCompanyIdSet);
                        updateTmeSql.append(" and billCompanyConfirmSt<>1");
                        DbUtil.execute(ctx, updateTmeSql.getSQL(), updateTmeSql.getParams());
                        continue;
                    }
                    billheadIDSet.removeAll(canNotUnAuditHeadIdMap.keySet());
                    allBillheadIDSet.addAll(billheadIDSet);
                    if (!billCompanyIdSet.isEmpty()) {
                        sql.append("update T_Csl_CheckageBillCompany set FConfirmStatus=0,FConfirmorId=null,FConfirmTime=null where fid in", billCompanyIdSet);
                        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                    }
                    if (StringUtils.isEmpty((String)fetchTmpTable) || billCompanyIdSet.isEmpty()) continue;
                    updateTmeSql = new SQLBuilder();
                    updateTmeSql.append("update ").append(fetchTmpTable).append(" set billCompanyConfirmSt=0,billCompanyConfirmorId=null,confirmorName=null,billCompanyConfirmTime=null \n");
                    updateTmeSql.append("where billBillCompanyId in ", billCompanyIdSet);
                    DbUtil.execute(ctx, updateTmeSql.getSQL(), updateTmeSql.getParams());
                }
                catch (SQLException e) {
                    logger.error((Object)"_confirm", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            if (!needAuditHeadSet.isEmpty()) {
                HashSet<String> auditHeadIdSet = new HashSet<String>();
                this.confirmIsReview(ctx, needAuditHeadSet, auditHeadIdSet, user, nowTimest);
                if (!StringUtils.isEmpty((String)fetchTmpTable) && auditHeadIdSet != null && !auditHeadIdSet.isEmpty()) {
                    SQLBuilder updateAuditSql = new SQLBuilder();
                    updateAuditSql.append("update ").append(fetchTmpTable).append(" set billHeadAuditedStatus=? ", 2);
                    updateAuditSql.append(",billAuditDebit=billConfirmDebit,billAuditCredit=billConfirmCredit ");
                    updateAuditSql.append("where billHeadId in ", auditHeadIdSet);
                    DbUtil.execute(ctx, updateAuditSql.getSQL(), updateAuditSql.getParams());
                }
                if (auditHeadIdSet != null && !auditHeadIdSet.isEmpty()) {
                    resultMap.put("needAuditHeadIdSet", auditHeadIdSet);
                }
            }
            if (!allBillheadIDSet.isEmpty()) {
                sql.reset();
                sql.append("update T_Csl_CheckageBillHead set FDiffMode=null where fid in ", allBillheadIDSet);
                DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                this._updateBilHeadDiff(ctx, allBillheadIDSet);
                this.updateBillConfirmData(ctx, allBillheadIDSet);
                resultMap.put("unConfrim", "true");
            }
            if (!needUnAuditHeadIdSet.isEmpty()) {
                sql.reset();
                sql.append("update T_Csl_CheckageBillHead set FAuditedStatus=?,FAuditorId=null,FAuditedTime=null \n", 1);
                sql.append("where fid in ", needUnAuditHeadIdSet);
                DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
            }
            if (!canNotUnAuditHeadIdMap.isEmpty()) {
                StringBuilder canNotUnAuditSb = new StringBuilder();
                Set canNotUnAuditHeadIdSet = canNotUnAuditHeadIdMap.keySet();
                for (String head : canNotUnAuditHeadIdSet) {
                    Object[] params = (Object[])createdEliminationHeadMap.get(head);
                    if (params == null || params.length < 2) continue;
                    canNotUnAuditSb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"117linkElimCantUnAudit", (Locale)ctx.getLocale()), canNotUnAuditHeadIdMap.get(head), params[0], params[1]));
                    canNotUnAuditSb.append("\n");
                }
                if (canNotUnAuditSb.length() > 0) {
                    resultMap.put("canNotUnAuditSb", canNotUnAuditSb.toString());
                }
                resultMap.put("canNotUnAuditHeadIdSet", new HashSet(canNotUnAuditHeadIdSet));
            }
            resultMap.put("nowTime", nowTimest);
            resultMap.put("unHandleDataMap", unHandleDataMap);
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        finally {
            this.batchReleaseMutex(mutexService, lockHeadIdSet);
        }
    }

    private void batchReleaseMutex(IMutexServiceControl mutexService, Set<String> lockHeadIdSet) {
        for (String headIdStr : lockHeadIdSet) {
            mutexService.releaseObjIDForUpdate(headIdStr);
        }
    }

    private void batchRequestMutex(Context ctx, IMutexServiceControl mutexService, Set<String> lockHeadIdSet, Iterator<Object> headIdItr) throws BOSException {
        boolean tag = true;
        while (headIdItr.hasNext()) {
            Set companyHeadIdSet = (Set)headIdItr.next();
            for (String headIdStr : companyHeadIdSet) {
                tag = mutexService.requestObjIDForUpdate(headIdStr);
                if (!tag) {
                    logger.error((Object)("lockFail:{" + headIdStr + "}"));
                    throw new BOSException("lockFail");
                }
                lockHeadIdSet.add(headIdStr);
            }
        }
    }

    private void updateBillConfirmData(Context ctx, Set<String> billheadIDSet) {
        if (billheadIDSet == null || billheadIDSet.isEmpty()) {
            return;
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append("update T_Csl_CheckageBill set FAUDITDEBIT=FCONFIRMDEBIT, FAUDITCREDIT=FCONFIRMCREDIT where FbillHeadId in ", billheadIDSet);
        try {
            DbUtil.execute(ctx, sql.toString(), sql.getParams());
        }
        catch (BOSException e) {
            logger.error((Object)"updateBillConfirmData_error", (Throwable)e);
        }
    }

    @Override
    protected Map _getCheckageBills(Context ctx, List billHeadIds, String companyId) throws BOSException, EASBizException {
        try {
            return AccountCheckUtil.getCheckageBills(ctx, billHeadIds, companyId, false);
        }
        catch (Exception e) {
            logger.error((Object)"_getCheckageBills_diffHandle error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _saveDiff(Context ctx, List detailBills, Map infoMap) throws BOSException, EASBizException {
        HashMap<String, Cloneable> resultMap = new HashMap<String, Cloneable>();
        String billheadId = (String)infoMap.get("billheadId");
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            boolean tag = mutexService.requestObjIDForUpdate(billheadId);
            if (!tag) {
                logger.error((Object)("lockFail:{" + billheadId + "}"));
                billheadId = null;
                throw new BOSException("lockFail");
            }
            try {
                Collection billCompanyInfoCol;
                int i;
                CheckageBillCompanyInfo checkageBillCompanyInfo;
                String company;
                String diffRemark = (String)infoMap.get("diffRemark");
                Set canNotConfirmCompanyIdSet = (Set)infoMap.get("canNotConfirmCompanyIdSet");
                Date nowTime = new Date();
                Timestamp nowTimest = new Timestamp(nowTime.getTime());
                UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
                ArrayList<CheckageBillInfo> list = detailBills;
                HashMap<String, CheckageBillCompanyInfo> companyAndBillCompanyMap = new HashMap<String, CheckageBillCompanyInfo>();
                HashSet<String> companySet = new HashSet<String>();
                HashMap<String, String> checkBillCompanyAndCompanyMap = new HashMap<String, String>();
                HashSet confirmedCompanySet = new HashSet();
                for (CheckageBillInfo billDetail : list) {
                    company = billDetail.getCompany().getId().toString();
                    companySet.add(company);
                    checkageBillCompanyInfo = (CheckageBillCompanyInfo)companyAndBillCompanyMap.get(company);
                    if (checkageBillCompanyInfo != null || (checkageBillCompanyInfo = billDetail.getBillCompany()) == null || checkageBillCompanyInfo.getId() == null) continue;
                    if (canNotConfirmCompanyIdSet == null || !canNotConfirmCompanyIdSet.contains(company)) {
                        checkageBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.confirm);
                        checkageBillCompanyInfo.setConfirmor(user);
                        checkageBillCompanyInfo.setConfirmTime(nowTimest);
                        checkageBillCompanyInfo.setDiffRemark(diffRemark);
                    }
                    companyAndBillCompanyMap.put(company, checkageBillCompanyInfo);
                    checkBillCompanyAndCompanyMap.put(checkageBillCompanyInfo.getId().toString(), company);
                }
                if (!checkBillCompanyAndCompanyMap.isEmpty()) {
                    Set billCompanySet = checkBillCompanyAndCompanyMap.keySet();
                    EntityViewInfo view = new EntityViewInfo();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    view.setSelector(sic);
                    sic.add(new SelectorItemInfo("id"));
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", billCompanySet, CompareType.INCLUDE));
                    filter.getFilterItems().add(new FilterItemInfo("confirmStatus", (Object)1));
                    view.setFilter(filter);
                    CheckageBillCompanyCollection checkageBillCompanyCollection = CheckageBillCompanyFactory.getLocalInstance(ctx).getCheckageBillCompanyCollection(view);
                    if (checkageBillCompanyCollection != null && !checkageBillCompanyCollection.isEmpty()) {
                        for (i = 0; i < checkageBillCompanyCollection.size(); ++i) {
                            CheckageBillCompanyInfo checkageBillCompanyInfo2 = checkageBillCompanyCollection.get(i);
                            confirmedCompanySet.add(checkBillCompanyAndCompanyMap.get(checkageBillCompanyInfo2.getId().toString()));
                        }
                    }
                }
                companySet.removeAll(companyAndBillCompanyMap.keySet());
                HashMap<String, CheckageBillCompanyInfo> noBillCompanyCompanyAndBillCompanyMap = new HashMap<String, CheckageBillCompanyInfo>();
                if (!companySet.isEmpty()) {
                    for (String companyId : companySet) {
                        CheckageBillCompanyInfo ckBillCompanyInfo = new CheckageBillCompanyInfo();
                        ckBillCompanyInfo.setId(BOSUuid.create((BOSObjectType)ckBillCompanyInfo.getBOSType()));
                        ckBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                        if (canNotConfirmCompanyIdSet == null || !canNotConfirmCompanyIdSet.contains(companyId)) {
                            ckBillCompanyInfo.setConfirmStatus(ConfirmStatusEnum.confirm);
                            ckBillCompanyInfo.setConfirmor(user);
                            ckBillCompanyInfo.setConfirmTime(nowTimest);
                            ckBillCompanyInfo.setDiffRemark(diffRemark);
                        }
                        noBillCompanyCompanyAndBillCompanyMap.put(companyId, ckBillCompanyInfo);
                    }
                }
                HashMap<String, String> confirmedInfoMap = new HashMap<String, String>();
                ArrayList<CheckageBillInfo> newlist = new ArrayList<CheckageBillInfo>();
                HashSet<String> confirmCompanySet = new HashSet<String>();
                for (CheckageBillInfo checkageBillInfo : list) {
                    company = checkageBillInfo.getCompany().getId().toString();
                    if (confirmedCompanySet.contains(company)) {
                        confirmedInfoMap.put(company, AccountCheckUtil.getResourceString(ctx, "diffFail_dataConfirmed", new Object[]{checkageBillInfo.getCompany().getName()}));
                        continue;
                    }
                    checkageBillCompanyInfo = checkageBillInfo.getBillCompany();
                    if (checkageBillCompanyInfo == null || checkageBillCompanyInfo.getId() == null) {
                        if (companyAndBillCompanyMap.containsKey(company)) {
                            checkageBillCompanyInfo = (CheckageBillCompanyInfo)companyAndBillCompanyMap.get(company);
                        } else {
                            checkageBillCompanyInfo = (CheckageBillCompanyInfo)noBillCompanyCompanyAndBillCompanyMap.get(company);
                            checkageBillInfo.put("billCompanyIsNull", "true");
                        }
                        checkageBillInfo.setBillCompany(checkageBillCompanyInfo);
                    }
                    if (checkageBillCompanyInfo != null && checkageBillCompanyInfo.getConfirmStatus().getValue() == 1) {
                        confirmCompanySet.add(company);
                    }
                    newlist.add(checkageBillInfo);
                }
                list = newlist;
                resultMap.put("confirmedInfoMap", confirmedInfoMap);
                resultMap.put("confirmCompanySet", confirmCompanySet);
                AccountCheckUtil.addNewDetailBillsForDiff(ctx, list, false);
                AccountCheckUtil.updataBillConfirmMoney(ctx, list);
                if (!noBillCompanyCompanyAndBillCompanyMap.isEmpty()) {
                    billCompanyInfoCol = noBillCompanyCompanyAndBillCompanyMap.values();
                    for (CheckageBillCompanyInfo billCompanyInfo : billCompanyInfoCol) {
                        CheckageBillCompanyFactory.getLocalInstance(ctx).save(billCompanyInfo);
                    }
                }
                if (!companyAndBillCompanyMap.isEmpty()) {
                    billCompanyInfoCol = companyAndBillCompanyMap.values();
                    for (CheckageBillCompanyInfo billCompanyInfo : billCompanyInfoCol) {
                        CheckageBillCompanyFactory.getLocalInstance(ctx).save(billCompanyInfo);
                    }
                }
                HashSet<String> billheadIdSet = new HashSet<String>();
                for (i = 0; i < list.size(); ++i) {
                    CheckageBillInfo checkageBillInfo = (CheckageBillInfo)list.get(i);
                    if (checkageBillInfo.getBillHead() == null || checkageBillInfo.getBillHead().getId() == null) continue;
                    billheadIdSet.add(checkageBillInfo.getBillHead().getId().toString());
                    break;
                }
                if (billheadIdSet.size() > 0) {
                    this._updateBilHeadDiff(ctx, billheadIdSet);
                    boolean dataConfirmIsReview = CSLParamUtil.getParamBooleanValue((Context)ctx, (String)"GR_CSL_DZPT_DataConfirmIsReview");
                    if (dataConfirmIsReview) {
                        this.confirmIsReview(ctx, billheadIdSet, null, user, nowTimest);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"_saveDiff error.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        finally {
            if (billheadId != null) {
                mutexService.releaseObjIDForUpdate(billheadId);
            }
        }
        return resultMap;
    }

    private void confirmIsReview(Context ctx, Set<String> billheadIdSet, Set<String> auditHeadSet, UserInfo user, Timestamp nowTimest) throws BOSException {
        try {
            HashSet<String> needAuditHeadSet = new HashSet<String>();
            HashMap<String, HashSet<String>> headAndCompanyMap = new HashMap<String, HashSet<String>>();
            SQLBuilder sql = new SQLBuilder();
            sql.append("select bill.fbillheadid headId, bill.fcompanyId company, acctMap.FIsUnilateralReconciliation isUnilateral, billCompany.FConfirmStatus confirmSt  \n");
            sql.append("from T_Csl_CheckageBill bill \n");
            sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.Fid=bill.FBillCompanyId \n");
            sql.append("inner join T_Csl_CheckageBillHead billHead on bill.FBillHeadId=billHead.Fid \n");
            sql.append("inner join T_Csl_AccountMap acctMap on acctMap.fid=billHead.FAccountMapId \n");
            sql.append("where bill.fbillheadid in \n", billheadIdSet);
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    if (1 != rowSet.getInt("confirmSt")) continue;
                    String headId = rowSet.getString("headId");
                    String companyId = rowSet.getString("company");
                    boolean isUnilateral = rowSet.getBoolean("isUnilateral");
                    if (isUnilateral) {
                        needAuditHeadSet.add(headId);
                        continue;
                    }
                    HashSet<String> companyIdSet = (HashSet<String>)headAndCompanyMap.get(headId);
                    if (companyIdSet == null) {
                        companyIdSet = new HashSet<String>();
                        headAndCompanyMap.put(headId, companyIdSet);
                    }
                    companyIdSet.add(companyId);
                }
                if (!headAndCompanyMap.isEmpty()) {
                    Set headIdSet = headAndCompanyMap.keySet();
                    for (String head : headIdSet) {
                        Set companyIdSet = (Set)headAndCompanyMap.get(head);
                        if (companyIdSet == null || companyIdSet.size() != 2) continue;
                        needAuditHeadSet.add(head);
                    }
                }
            }
            if (!needAuditHeadSet.isEmpty()) {
                SQLBuilder updateAuditSql = new SQLBuilder();
                updateAuditSql.append("update T_Csl_CheckageBillHead set FAuditedStatus=?,", 2);
                updateAuditSql.append("FAuditorId=?,", user.getId().toString());
                updateAuditSql.append("FAuditedTime=? \n", nowTimest);
                updateAuditSql.append("where Fid in ", needAuditHeadSet);
                updateAuditSql.append(" and FAuditedStatus=?", 1);
                DbUtil.execute(ctx, updateAuditSql.getSQL(), updateAuditSql.getParams());
            }
            if (auditHeadSet != null) {
                auditHeadSet.addAll(needAuditHeadSet);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getBillInfoMap(Context ctx, boolean isConfirm, Set billIdSet, Set hasPermissionOrgIDSet) throws BOSException, EASBizException {
        if (billIdSet == null || billIdSet.isEmpty()) {
            return null;
        }
        HashMap<String, Object> billInfoMap = new HashMap<String, Object>();
        try {
            boolean isSelectOneHead;
            HashMap<Object, HashMap<String, String>> companyForHeadAndNumberMap = new HashMap<Object, HashMap<String, String>>();
            Locale locale = ctx.getLocale();
            HashSet<String> companySet = new HashSet<String>();
            int headIdCount = 0;
            SQLBuilder sql = new SQLBuilder();
            sql.append("select distinct bill.FCompanyId company, bill.FBillHeadId headId, billHead.Fnumber headNumber  \n");
            sql.append("from T_Csl_CheckageBill bill \n");
            sql.append("inner join T_Csl_CheckageBillHead billHead on bill.FBillHeadId=billHead.Fid \n");
            sql.append("where bill.fid in ", billIdSet);
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                String preHeadId = "";
                while (rowSet.next()) {
                    String company = rowSet.getString("company");
                    companySet.add(company);
                    String headId = rowSet.getString("headId");
                    String headNumber = rowSet.getString("headNumber");
                    if (!preHeadId.equals(headId)) {
                        ++headIdCount;
                    }
                    preHeadId = headId;
                    HashMap<String, String> headAndNumberMap = (HashMap<String, String>)companyForHeadAndNumberMap.get(company);
                    if (headAndNumberMap == null) {
                        headAndNumberMap = new HashMap<String, String>();
                        companyForHeadAndNumberMap.put(company, headAndNumberMap);
                    }
                    headAndNumberMap.put(headId, headNumber);
                }
            }
            HashSet haveNoPermissionOrgSet = new HashSet(companySet);
            haveNoPermissionOrgSet.removeAll(hasPermissionOrgIDSet);
            IObjectPK[] pkArray = new IObjectPK[companySet.size()];
            int i = 0;
            for (String companyIdStr : companySet) {
                pkArray[i++] = new ObjectUuidPK(companyIdStr);
            }
            ObjectUuidPK userPK = new ObjectUuidPK(ctx.getCaller().toString());
            Set havePermissionOrgSet = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)userPK, pkArray, isConfirm ? "csl_checkwork_confirm" : "csl_checkwork_unconfirm");
            HashSet haveNoConfirmPermissionOrgSet = new HashSet(companySet);
            haveNoConfirmPermissionOrgSet.removeAll(havePermissionOrgSet);
            HashSet allHaveNoPermissionOrgSet = new HashSet();
            if (haveNoConfirmPermissionOrgSet != null && !haveNoConfirmPermissionOrgSet.isEmpty()) {
                allHaveNoPermissionOrgSet.addAll(haveNoConfirmPermissionOrgSet);
            }
            if (haveNoPermissionOrgSet != null && !haveNoPermissionOrgSet.isEmpty()) {
                allHaveNoPermissionOrgSet.addAll(haveNoPermissionOrgSet);
            }
            StringBuilder noPermission_detailSbInfo = new StringBuilder();
            StringBuilder noOrgPermission_detailSbInfo = new StringBuilder();
            boolean bl = isSelectOneHead = headIdCount == 1;
            if (!allHaveNoPermissionOrgSet.isEmpty()) {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                view.setSelector(sic);
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", allHaveNoPermissionOrgSet, CompareType.INCLUDE));
                view.setFilter(filter);
                CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                if (companyOrgUnitCollection != null && !companyOrgUnitCollection.isEmpty()) {
                    StringBuilder detailHeadNumberSbInfo = new StringBuilder();
                    for (int x = 0; x < companyOrgUnitCollection.size(); ++x) {
                        detailHeadNumberSbInfo.setLength(0);
                        CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(x);
                        String companyName = companyOrgUnitInfo.getName();
                        String companyId = companyOrgUnitInfo.getId().toString();
                        if (!isSelectOneHead && companyForHeadAndNumberMap.containsKey(companyId)) {
                            Collection numberCol = ((Map)companyForHeadAndNumberMap.get(companyId)).values();
                            for (String noPermissonHeadNumber : numberCol) {
                                detailHeadNumberSbInfo.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"detailHeadNumber", (Locale)locale)).append(noPermissonHeadNumber).append("\n");
                            }
                        }
                        if (haveNoPermissionOrgSet != null && haveNoPermissionOrgSet.contains(companyId)) {
                            if (isSelectOneHead) {
                                noOrgPermission_detailSbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"hasNoAccountCheckPermission", (Locale)locale), companyName)).append("\n");
                                continue;
                            }
                            noOrgPermission_detailSbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"hasNoAccountCheckPermission", (Locale)locale), companyName, isConfirm ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"confirm_Permission", (Locale)locale) : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"unconfirm_Permission", (Locale)locale))).append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)(isConfirm ? "failConfirmDetailData" : "failUnConfirmDetailData"), (Locale)locale)).append("\n");
                            noOrgPermission_detailSbInfo.append((CharSequence)detailHeadNumberSbInfo);
                            continue;
                        }
                        if (haveNoConfirmPermissionOrgSet == null || !haveNoConfirmPermissionOrgSet.contains(companyId)) continue;
                        if (isSelectOneHead) {
                            noPermission_detailSbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"hasNoPermission", (Locale)locale), companyName, isConfirm ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"confirm_Permission", (Locale)locale) : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"unconfirm_Permission", (Locale)locale))).append("\n");
                            continue;
                        }
                        noPermission_detailSbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"hasNoPermission", (Locale)locale), companyName, isConfirm ? EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"confirm_Permission", (Locale)locale) : EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"unconfirm_Permission", (Locale)locale))).append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)(isConfirm ? "failConfirmDetailData" : "failUnConfirmDetailData"), (Locale)locale)).append("\n");
                        noPermission_detailSbInfo.append((CharSequence)detailHeadNumberSbInfo);
                    }
                }
            }
            HashMap<String, Map<String, Map<String, CheckageBillInfo>>> unHandleDataMap = new HashMap<String, Map<String, Map<String, CheckageBillInfo>>>();
            HashMap companyAndIsCheckOutMap = new HashMap();
            HashSet<String> unCheckOutCompanyIdSet = new HashSet<String>();
            StringBuilder unCheckOutCompanySbInfo = new StringBuilder();
            HashMap<String, HashSet<String>> toleranceInfoMap = new HashMap<String, HashSet<String>>();
            boolean canNotConfirmWhenDataDifference = isConfirm && CSLParamUtil.getParamBooleanValue((Context)ctx, (String)"GR_CSL_DZPT_CannotConfirmWhenDataDifference");
            HashMap billHeadIdMap = new HashMap();
            StringBuilder auditSbInfo = new StringBuilder();
            StringBuilder comfimSbInfo = new StringBuilder();
            StringBuilder diffDataInfo = new StringBuilder();
            StringBuilder submitCompanyInfo = new StringBuilder();
            HashSet<String> isUnilateralHeadIdSet = new HashSet<String>();
            HashSet<String> diffDataHeadIdSet = new HashSet<String>();
            HashMap<String, HashSet<String>> diffDataConConfirmCompanyMap = new HashMap<String, HashSet<String>>();
            HashSet<String> auditHeadSet = new HashSet<String>();
            sql.reset();
            sql.append("select bill.fid,bill.FCompanyId,billHead.Fid headId,billHead.Fnumber,billHead.FCompanyDiff,acctMap.FIsUnilateralReconciliation isUnilateral,bill.Fyear year,bill.Fperiod period, \n");
            sql.append("company.Fnumber companyNumber, company.fname_").append(locale.getLanguage()).append(" companyName, companySt.FStatus companyStatus,  ");
            sql.append("tarCompany.fname_").append(locale.getLanguage()).append(" tarCompanyName,  ");
            if (canNotConfirmWhenDataDifference) {
                sql.append("\n case when ownAndTarTolerance.FValue is not null then ownAndTarTolerance.FValue else tolerance.FValue end toleranceVal, \n");
                sql.append("case when ownAndTarTolerance.FValue is not null then ownAndTarTolerance.FValue else tarTolerance.FValue end tarToleranceVal, \n");
                sql.append("case when ownAndTarTolerance.FValue is not null then ownUnit.fname_").append(locale.getLanguage()).append(" else ownBaseUnit.fname_").append(locale.getLanguage()).append(" end toleranceOwnUnitName, \n");
                sql.append("case when ownAndTarTolerance.FValue is not null then tarUnit.fname_").append(locale.getLanguage()).append(" else null end toleranceTarUnitName, \n");
                sql.append("tarBillCompany.FConfirmStatus tarConfirmStatus,bill.FTargetCompanyId tarCompanyId, \n");
            }
            sql.append("billHead.FAuditedStatus,billCompany.FConfirmStatus,billCompany.Fid billCompanyId,billCompany.FConfirmTime confirmTime, \n");
            sql.append("confirmor.fname_").append(locale.getLanguage()).append(" confirmorName,confirmor.Fid confirmorId,   \n");
            sql.append("bill.FConfirmDebit confirmDebit,bill.FConfirmCredit confirmCredit,bill.FAuditDebit auditDebit,bill.FAuditCredit auditCredit   \n");
            sql.append("from T_Csl_CheckageBill bill \n");
            sql.append("inner join T_ORG_Company company on company.Fid=bill.FCompanyId \n");
            sql.append("inner join T_ORG_Company tarCompany on tarCompany.Fid=bill.FTargetCompanyId \n");
            sql.append("inner join T_Csl_CheckageBillHead billHead on bill.FBillHeadId=billHead.Fid \n");
            sql.append("inner join T_Csl_AccountMap acctMap on acctMap.fid=billHead.FAccountMapId \n");
            sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.Fid=bill.FBillCompanyId \n");
            sql.append("left join T_PM_User confirmor on confirmor.Fid=billCompany.FConfirmorId \n");
            sql.append("left join T_Csl_CheckageCompanyStatus companySt on companySt.FYear=bill.FYear and companySt.FPeriod=bill.FPeriod and companySt.FCurrencyId=bill.FCurrencyId and companySt.FCompanyId=bill.FCompanyId \n");
            if (canNotConfirmWhenDataDifference) {
                sql.append("left join T_Csl_CheckageBill tarBill on tarBill.FCompanyId=bill.FTargetCompanyId and tarBill.FBillHeadId=bill.FBillHeadId \n");
                sql.append("left join T_Csl_CheckageBillCompany tarBillCompany on tarBillCompany.Fid=tarBill.FBillCompanyId \n");
                sql.append("left join T_Csl_Tolerance ownAndTarTolerance on ownAndTarTolerance.FAccountMapId=billHead.FAccountMapId  \n");
                sql.append("and ((ownAndTarTolerance.FOrgUnitId=bill.FCompanyId and ownAndTarTolerance.FTarOrgUnitId=bill.FTargetCompanyId) or (ownAndTarTolerance.FOrgUnitId=bill.FTargetCompanyId and ownAndTarTolerance.FTarOrgUnitId=bill.FCompanyId)) \n");
                sql.append("and ownAndTarTolerance.FToleranceType=").append(0).append(" \n");
                sql.append("left join T_ORG_BaseUnit ownUnit on ownUnit.fid=ownAndTarTolerance.FOrgUnitId \n");
                sql.append("left join T_ORG_BaseUnit tarUnit on tarUnit.fid=ownAndTarTolerance.FTarOrgUnitId \n");
                sql.append("left join T_Csl_Tolerance tolerance on tolerance.FAccountMapId=billHead.FAccountMapId and tolerance.FOrgUnitId=bill.FCompanyId and tolerance.FTarOrgUnitId is null and tolerance.FToleranceType=").append(0).append(" \n");
                sql.append("left join T_ORG_BaseUnit ownBaseUnit on ownBaseUnit.fid=tolerance.FOrgUnitId \n");
                sql.append("left join T_Csl_Tolerance tarTolerance on tarTolerance.FAccountMapId=billHead.FAccountMapId and tarTolerance.FOrgUnitId=bill.FTargetCompanyId and tarTolerance.FTarOrgUnitId is null and tarTolerance.FToleranceType=").append(0).append(" \n");
            }
            sql.append("where bill.fid in ", billIdSet);
            if (!canNotConfirmWhenDataDifference && !allHaveNoPermissionOrgSet.isEmpty()) {
                sql.append(" and bill.FCompanyId not in ", allHaveNoPermissionOrgSet);
            }
            sql.append("order by billHead.Fid");
            rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                boolean dataConfirmIsReview = CSLParamUtil.getParamBooleanValue((Context)ctx, (String)"GR_CSL_DZPT_DataConfirmIsReview");
                HashSet<String> auditeFailbillHeadSet = new HashSet<String>();
                HashSet<String> comfirmFailbillHeadAndCompanySet = new HashSet<String>();
                HashSet<String> sameBillHeadNumberSet = new HashSet<String>();
                HashSet<String> submitCompanyIdSet = new HashSet<String>();
                String headNumber = null;
                while (rowSet.next()) {
                    HashMap<String, String> billHeadIdAndNumberMap;
                    String headId = rowSet.getString("headId");
                    String billId = rowSet.getString("fid");
                    String companyId = rowSet.getString("FCompanyId");
                    if (canNotConfirmWhenDataDifference && allHaveNoPermissionOrgSet.contains(companyId)) continue;
                    String orgName = rowSet.getString("companyName");
                    String tarOrgName = rowSet.getString("tarCompanyName");
                    int companyStatus = rowSet.getInt("companyStatus");
                    if (0 != companyStatus) {
                        if (!submitCompanyIdSet.contains(companyId)) {
                            if (submitCompanyIdSet.isEmpty()) {
                                submitCompanyInfo.append(AccountCheckUtil.getResourceString(ctx, isConfirm ? "confimFail_dataSubmited" : "unConfimFail_dataSubmited", null)).append("\n");
                            }
                            submitCompanyInfo.append(orgName).append("\n");
                        }
                        submitCompanyIdSet.add(companyId);
                        continue;
                    }
                    headNumber = rowSet.getString("Fnumber");
                    BigDecimal companyDiff = rowSet.getBigDecimal("FCompanyDiff");
                    int auditedStatus = rowSet.getInt("FAuditedStatus");
                    int confirmStatus = rowSet.getInt("FConfirmStatus");
                    Timestamp confirmTime = rowSet.getTimestamp("confirmTime");
                    String confirmorName = rowSet.getString("confirmorName");
                    String confirmorId = rowSet.getString("confirmorId");
                    BigDecimal confirmDebit = rowSet.getBigDecimal("confirmDebit");
                    BigDecimal confirmCredit = rowSet.getBigDecimal("confirmCredit");
                    BigDecimal auditDebit = rowSet.getBigDecimal("auditDebit");
                    BigDecimal auditCredit = rowSet.getBigDecimal("auditCredit");
                    if (2 == auditedStatus) {
                        this.setUnHandleData(unHandleDataMap, headId, companyId, confirmorId, confirmorName, confirmStatus, confirmTime, confirmDebit, confirmCredit, auditDebit, auditCredit, auditedStatus, billId);
                        if (!dataConfirmIsReview || isConfirm) {
                            if (auditeFailbillHeadSet.contains(headId)) continue;
                            auditeFailbillHeadSet.add(headId);
                            auditSbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)(isConfirm ? "canNotConfirmAuditedData" : "canNotUnConfirmAuditedData"), (Locale)locale), headNumber)).append("\n");
                            continue;
                        }
                        if (dataConfirmIsReview && !isConfirm) {
                            auditHeadSet.add(headId);
                        }
                    }
                    String headAndCompanyKey = headId + companyId;
                    if (isConfirm && 1 == confirmStatus) {
                        this.setUnHandleData(unHandleDataMap, headId, companyId, confirmorId, confirmorName, confirmStatus, confirmTime, confirmDebit, confirmCredit, auditDebit, auditCredit, auditedStatus, billId);
                        if (comfirmFailbillHeadAndCompanySet.contains(headAndCompanyKey)) continue;
                        comfirmFailbillHeadAndCompanySet.add(headAndCompanyKey);
                        comfimSbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"canNotDupConfirmCompanyData", (Locale)locale), headNumber, orgName)).append("\n");
                        continue;
                    }
                    if (!isConfirm && 0 == confirmStatus) {
                        this.setUnHandleData(unHandleDataMap, headId, companyId, confirmorId, confirmorName, confirmStatus, confirmTime, confirmDebit, confirmCredit, auditDebit, auditCredit, auditedStatus, billId);
                        if (comfirmFailbillHeadAndCompanySet.contains(headAndCompanyKey)) continue;
                        comfirmFailbillHeadAndCompanySet.add(headAndCompanyKey);
                        comfimSbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"canNotDupUnConfirmCompanyData", (Locale)locale), headNumber, orgName)).append("\n");
                        continue;
                    }
                    if (isConfirm && BigDecimal.ZERO.compareTo(companyDiff) != 0 && !sameBillHeadNumberSet.contains(headNumber)) {
                        diffDataInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"dataHasDiffForNumber", (Locale)locale), headNumber)).append("\n");
                        sameBillHeadNumberSet.add(headNumber);
                    }
                    if (isConfirm) {
                        boolean isCheckOut = true;
                        ArrayList<Comparable<Boolean>> paramList = (ArrayList<Comparable<Boolean>>)companyAndIsCheckOutMap.get(companyId);
                        if (paramList == null) {
                            paramList = new ArrayList<Comparable<Boolean>>(3);
                            boolean canConfirmUnCheckOutData = CSLParamUtil.getParamBooleanValue((Context)ctx, (String)companyId, (String)"GR_CSL_DZPT_CanConfirmUnCheckOutData");
                            if (!canConfirmUnCheckOutData) {
                                paramList.add(Boolean.valueOf(true));
                                PeriodInfo currentPeriod = GlUtils.getCurrentPeriod((Context)ctx, (String)companyId);
                                if (currentPeriod != null) {
                                    paramList.add(Integer.valueOf(currentPeriod.getPeriodYear()));
                                    paramList.add(Integer.valueOf(currentPeriod.getPeriodNumber()));
                                }
                            } else {
                                paramList.add(Boolean.valueOf(false));
                            }
                            companyAndIsCheckOutMap.put(companyId, paramList);
                        }
                        if (isCheckOut = ((Boolean)paramList.get(0)).booleanValue()) {
                            Integer curYear = (Integer)paramList.get(1);
                            Integer curPeriod = (Integer)paramList.get(2);
                            int year = rowSet.getInt("year");
                            int period = rowSet.getInt("period");
                            if (curYear == null || curPeriod == null || year > curYear || year == curYear && period >= curPeriod) {
                                if (unCheckOutCompanyIdSet.contains(companyId)) continue;
                                if (unCheckOutCompanySbInfo.length() == 0) {
                                    unCheckOutCompanySbInfo.append(AccountCheckUtil.getResourceString(ctx, "conNotConfrimUnCheckOutCompany", null)).append("\n");
                                }
                                unCheckOutCompanySbInfo.append(rowSet.getString("companyNumber")).append("-").append(orgName).append("\n");
                                unCheckOutCompanyIdSet.add(companyId);
                                continue;
                            }
                        }
                    }
                    boolean isInToleranceRange = false;
                    if (canNotConfirmWhenDataDifference) {
                        String toleranceOwnUnitName = rowSet.getString("toleranceOwnUnitName");
                        String toleranceTarUnitName = rowSet.getString("toleranceTarUnitName");
                        String unitStr = toleranceOwnUnitName;
                        if (StringUtils.isEmpty((String)unitStr)) {
                            unitStr = toleranceTarUnitName;
                        } else if (!StringUtils.isEmpty((String)toleranceTarUnitName)) {
                            unitStr = unitStr + "-" + toleranceTarUnitName;
                        }
                        if (rowSet.getBoolean("isUnilateral") || !rowSet.getBoolean("isUnilateral") && 1 != rowSet.getInt("tarConfirmStatus")) {
                            BigDecimal toleranceVal = rowSet.getBigDecimal("toleranceVal");
                            if (toleranceVal != null) {
                                if (companyDiff.abs().compareTo(toleranceVal.abs()) > 0) {
                                    HashSet<String> toleranceInfoSet = (HashSet<String>)toleranceInfoMap.get(unitStr);
                                    if (toleranceInfoSet == null) {
                                        toleranceInfoSet = new HashSet<String>();
                                        toleranceInfoMap.put(unitStr, toleranceInfoSet);
                                    }
                                    toleranceInfoSet.add(headNumber);
                                    continue;
                                }
                                isInToleranceRange = true;
                            }
                        } else if (!rowSet.getBoolean("isUnilateral") && 1 == rowSet.getInt("tarConfirmStatus")) {
                            BigDecimal toleranceVal = rowSet.getBigDecimal("toleranceVal");
                            BigDecimal tarToleranceVal = rowSet.getBigDecimal("tarToleranceVal");
                            if (toleranceVal != null || BigDecimal.ZERO.compareTo(companyDiff) == 0) {
                                if (toleranceVal != null && companyDiff.abs().compareTo(toleranceVal.abs()) > 0 || tarToleranceVal != null && companyDiff.abs().compareTo(tarToleranceVal.abs()) > 0) {
                                    HashSet<String> toleranceInfoSet = (HashSet<String>)toleranceInfoMap.get(unitStr);
                                    if (toleranceInfoSet == null) {
                                        toleranceInfoSet = new HashSet<String>();
                                        toleranceInfoMap.put(unitStr, toleranceInfoSet);
                                    }
                                    toleranceInfoSet.add(headNumber);
                                    continue;
                                }
                                if (toleranceVal != null || tarToleranceVal != null) {
                                    isInToleranceRange = true;
                                }
                            }
                        }
                    }
                    if (isConfirm && BigDecimal.ZERO.compareTo(companyDiff) != 0) {
                        if (!isInToleranceRange) {
                            diffDataHeadIdSet.add(headId);
                        } else {
                            HashSet<String> diffDataConConfirmCompanySet = (HashSet<String>)diffDataConConfirmCompanyMap.get(headId);
                            if (diffDataConConfirmCompanySet == null) {
                                diffDataConConfirmCompanySet = new HashSet<String>();
                                diffDataConConfirmCompanyMap.put(headId, diffDataConConfirmCompanySet);
                            }
                            diffDataConConfirmCompanySet.add(companyId);
                        }
                    }
                    if ((billHeadIdAndNumberMap = (HashMap<String, String>)billHeadIdMap.get(companyId)) == null) {
                        billHeadIdAndNumberMap = new HashMap<String, String>();
                        billHeadIdMap.put(companyId, billHeadIdAndNumberMap);
                    }
                    if (!billHeadIdAndNumberMap.containsKey(headId)) {
                        billHeadIdAndNumberMap.put(headId, headNumber);
                    }
                    if (!isConfirm || !rowSet.getBoolean("isUnilateral")) continue;
                    isUnilateralHeadIdSet.add(headId);
                }
            }
            if (!unHandleDataMap.isEmpty()) {
                billInfoMap.put("unHandleDataMap", unHandleDataMap);
            }
            if (!toleranceInfoMap.isEmpty()) {
                StringBuilder toleranceSbInfo = new StringBuilder();
                Set companyNameSet = toleranceInfoMap.keySet();
                for (String companyName : companyNameSet) {
                    toleranceSbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"orgOutOneTolerance_unConfirm", (Locale)locale), companyName)).append("\n");
                    Set headNumberSet = (Set)toleranceInfoMap.get(companyName);
                    for (String headNumber : headNumberSet) {
                        toleranceSbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"detail_number", (Locale)locale), headNumber)).append("\n");
                    }
                }
                toleranceInfoMap.clear();
                toleranceInfoMap = null;
                billInfoMap.put("toleranceSbInfo", toleranceSbInfo.toString());
            }
            StringBuilder noPermissionDetailSbInfo = new StringBuilder();
            noPermissionDetailSbInfo.append((CharSequence)noPermission_detailSbInfo);
            noPermissionDetailSbInfo.append((CharSequence)noOrgPermission_detailSbInfo);
            if (noPermissionDetailSbInfo.length() > 0) {
                billInfoMap.put("noPermissionDetailSbInfo", noPermissionDetailSbInfo.toString());
            }
            if (auditSbInfo.length() > 0) {
                billInfoMap.put("auditSbInfo", auditSbInfo.toString());
            }
            if (comfimSbInfo.length() > 0) {
                billInfoMap.put("comfimSbInfo", comfimSbInfo.toString());
            }
            if (diffDataInfo.length() > 0) {
                billInfoMap.put("diffDataInfo", diffDataInfo.toString());
            }
            if (unCheckOutCompanySbInfo.length() > 0) {
                billInfoMap.put("unCheckOutCompanySbInfo", unCheckOutCompanySbInfo.toString());
            }
            if (submitCompanyInfo.length() > 0) {
                billInfoMap.put("submitCompanyInfo", submitCompanyInfo.toString());
            }
            if (billHeadIdMap.size() > 0) {
                billInfoMap.put("billHeadIdMap", billHeadIdMap);
            }
            if (haveNoPermissionOrgSet != null && haveNoPermissionOrgSet.size() > 0) {
                billInfoMap.put("haveNoPermissionOrgSet", haveNoPermissionOrgSet);
            }
            if (!isUnilateralHeadIdSet.isEmpty()) {
                billInfoMap.put("isUnilateralHeadIdSet", isUnilateralHeadIdSet);
            }
            if (!diffDataHeadIdSet.isEmpty()) {
                billInfoMap.put("diffDataHeadIdSet", diffDataHeadIdSet);
            }
            if (!diffDataConConfirmCompanyMap.isEmpty()) {
                billInfoMap.put("diffDataConConfirmCompanyMap", diffDataConConfirmCompanyMap);
            }
            if (!auditHeadSet.isEmpty()) {
                billInfoMap.put("auditHeadSet", auditHeadSet);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_getBillInfoMap_error", (Throwable)e);
        }
        return billInfoMap;
    }

    private void setUnHandleData(Map<String, Map<String, Map<String, CheckageBillInfo>>> unHandleDataMap, String headId, String companyId, String confirmorId, String confirmorName, int confirmStatus, Timestamp confirmTime, BigDecimal confirmDebit, BigDecimal confirmCredit, BigDecimal auditDebit, BigDecimal auditCredit, int auditedStatus, String billId) {
        Map<String, CheckageBillInfo> billInfoMap;
        Map<String, Map<String, CheckageBillInfo>> unHandleDataCompabyMap = unHandleDataMap.get(headId);
        if (unHandleDataCompabyMap == null) {
            unHandleDataCompabyMap = new HashMap<String, Map<String, CheckageBillInfo>>();
            unHandleDataMap.put(headId, unHandleDataCompabyMap);
        }
        if ((billInfoMap = unHandleDataCompabyMap.get(companyId)) == null) {
            billInfoMap = new HashMap<String, CheckageBillInfo>();
            unHandleDataCompabyMap.put(companyId, billInfoMap);
        }
        CheckageBillInfo unHandleInfo = new CheckageBillInfo();
        UserInfo user = null;
        if (!StringUtils.isEmpty((String)confirmorId)) {
            user = new UserInfo();
            user.setId(BOSUuid.read((String)confirmorId));
            user.setName(confirmorName);
        }
        if (!StringUtils.isEmpty((String)billId)) {
            unHandleInfo.setId(BOSUuid.read((String)billId));
        }
        unHandleInfo.put("confirm", (Object)ConfirmStatusEnum.getEnum(confirmStatus));
        unHandleInfo.put("confirmTime", confirmTime);
        unHandleInfo.put("confirmor", user);
        unHandleInfo.setConfirmDebit(confirmDebit);
        unHandleInfo.setConfirmCredit(confirmCredit);
        unHandleInfo.put("Audited", AuditedStatusEnum.getEnum((int)auditedStatus));
        unHandleInfo.setAuditDebit(auditDebit);
        unHandleInfo.setAuditCredit(auditCredit);
        billInfoMap.put(billId, unHandleInfo);
    }

    @Override
    protected Map _removeData(Context ctx, Map infoMap) throws BOSException, EASBizException {
        HashMap<String, Object> hashMap;
        block45: {
            String deleteTmpTable = null;
            TempTablePool tmpTablePool = null;
            HashMap<String, Object> reusltMap = new HashMap<String, Object>();
            boolean isRemoveAll = TypeConversionUtils.objToBoolean(infoMap.get("removeAll"));
            Set hasPermissionOrgIDSet = (Set)infoMap.get("hasPermissionOrgIDSet");
            HashSet<String> billheadIdSet = (HashSet<String>)infoMap.get("billheadIdSet");
            HashSet<String> companyIdSet = (HashSet<String>)infoMap.get("companyIdSet");
            try {
                AccountCheckWorkeFilterInfo filterInfo;
                if (isRemoveAll) {
                    filterInfo = (AccountCheckWorkeFilterInfo)infoMap.get("filterInfo");
                    String fetchTmpTable = filterInfo.getTmpTable();
                    if (StringUtils.isEmpty((String)fetchTmpTable)) {
                        Map map = null;
                        return map;
                    }
                    billheadIdSet = new HashSet<String>();
                    companyIdSet = new HashSet<String>();
                    SQLBuilder sql = new SQLBuilder();
                    sql.append("select distinct billHeadId,billCompanyId,tarBillCompanyId from ").append(fetchTmpTable);
                    IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
                    if (rowSet != null && rowSet.size() > 0) {
                        while (rowSet.next()) {
                            billheadIdSet.add(rowSet.getString("billHeadId"));
                            companyIdSet.add(rowSet.getString("billCompanyId"));
                            companyIdSet.add(rowSet.getString("tarBillCompanyId"));
                        }
                    }
                }
                if (billheadIdSet == null || billheadIdSet.isEmpty() || companyIdSet == null || companyIdSet.isEmpty()) {
                    filterInfo = null;
                    return filterInfo;
                }
                IObjectPK[] pkArray = new IObjectPK[companyIdSet.size()];
                int i = 0;
                for (String companyId : companyIdSet) {
                    pkArray[i++] = new ObjectUuidPK(companyId);
                }
                ObjectUuidPK userPK = new ObjectUuidPK(ctx.getCaller().toString());
                Set haveDeletePermissionOrgSet = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)userPK, pkArray, "csl_checkwork_delete");
                HashSet noDeletePermissionOrgSet = new HashSet(companyIdSet);
                noDeletePermissionOrgSet.removeAll(haveDeletePermissionOrgSet);
                ItemTypeEnum itemTypeEnum = null;
                Locale locale = ctx.getLocale();
                HashMap<String, String> deleteBillIdMap = new HashMap<String, String>();
                HashSet<String> deleteBillCompanyIdSet = new HashSet<String>();
                HashSet<String> deleteBillHeadIdSet = new HashSet<String>();
                StringBuilder resultInfoSb = new StringBuilder();
                StringBuilder noConfirmSb = new StringBuilder();
                StringBuilder noDeletePermissionSb = new StringBuilder();
                StringBuilder noCompanyPermissonSb = new StringBuilder();
                HashSet<String> connotDeleteBillHeadSet = new HashSet<String>();
                HashSet<String> connotDeleteBillCompanySet = new HashSet<String>();
                HashSet<String> confirmBillHeadAndCompanySet = new HashSet<String>();
                HashMap noPermissionOrgHeadMap = new HashMap();
                HashMap<String, String> companyAndNameMap = new HashMap<String, String>();
                SQLBuilder sql = new SQLBuilder();
                sql.append("select bill.fid,bill.FBillHeadId,bill.FBillCompanyId,billHead.Fnumber,billCompany.FConfirmStatus,bill.FItemType,bill.FCompanyId companyId,company.fname_").append(locale).append(" companyName  \n");
                sql.append("from T_Csl_CheckageBill bill \n");
                sql.append("inner join T_ORG_Company company on company.Fid=bill.FCompanyId \n");
                sql.append("inner join T_Csl_CheckageBillHead billHead on bill.FBillHeadId=billHead.Fid \n");
                sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.Fid=bill.FBillCompanyId \n");
                sql.append("where bill.FBillHeadId in \n", billheadIdSet);
                IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (rowSet != null && rowSet.size() > 0) {
                    while (rowSet.next()) {
                        if (itemTypeEnum == null) {
                            itemTypeEnum = ItemTypeEnum.getEnum(rowSet.getInt("FItemType"));
                        }
                        String id = rowSet.getString("fid");
                        int confirmStatus = rowSet.getInt("FConfirmStatus");
                        String billHeadId = rowSet.getString("FBillHeadId");
                        String companyId = rowSet.getString("companyId");
                        String billCompanyId = rowSet.getString("FBillCompanyId");
                        String companyName = rowSet.getString("companyName");
                        String headNumber = rowSet.getString("Fnumber");
                        String headAndCompanyKey = billHeadId + companyId;
                        if (1 == confirmStatus) {
                            connotDeleteBillHeadSet.add(billHeadId);
                            connotDeleteBillCompanySet.add(billCompanyId);
                            if (confirmBillHeadAndCompanySet.contains(headAndCompanyKey)) continue;
                            noConfirmSb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"removeBill_dataConfirm", (Locale)locale), headNumber, companyName));
                            noConfirmSb.append("\n");
                            confirmBillHeadAndCompanySet.add(headAndCompanyKey);
                            continue;
                        }
                        if (noDeletePermissionOrgSet.contains(companyId) || !hasPermissionOrgIDSet.contains(companyId)) {
                            HashSet<String> headNumberSet = (HashSet<String>)noPermissionOrgHeadMap.get(companyId);
                            if (headNumberSet == null) {
                                headNumberSet = new HashSet<String>();
                                noPermissionOrgHeadMap.put(companyId, headNumberSet);
                            }
                            if (!headNumberSet.contains(headNumber)) {
                                headNumberSet.add(headNumber);
                            }
                            if (!companyAndNameMap.containsKey(companyId)) {
                                companyAndNameMap.put(companyId, companyName);
                            }
                            connotDeleteBillHeadSet.add(billHeadId);
                            connotDeleteBillCompanySet.add(billCompanyId);
                            continue;
                        }
                        deleteBillIdMap.put(id, billHeadId);
                        deleteBillCompanyIdSet.add(billCompanyId);
                        deleteBillHeadIdSet.add(billHeadId);
                    }
                } else {
                    Map headNumberSet = null;
                    return headNumberSet;
                }
                Set noPermissionCompanySet = noPermissionOrgHeadMap.keySet();
                boolean hasNoPermissionOrg = false;
                if (noPermissionCompanySet != null && !noPermissionCompanySet.isEmpty()) {
                    hasNoPermissionOrg = true;
                    for (String noPermissionCompanyId : noPermissionCompanySet) {
                        boolean noDeletePermissionOrg = false;
                        boolean noPermissionOrg = false;
                        if (noDeletePermissionOrgSet.contains(noPermissionCompanyId)) {
                            noDeletePermissionSb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"hasNoPermission", (Locale)locale), companyAndNameMap.get(noPermissionCompanyId), EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"delete_Permission", (Locale)locale))).append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"deleteFailData", (Locale)locale));
                            noDeletePermissionSb.append("\n");
                            noDeletePermissionOrg = true;
                        }
                        if (!hasPermissionOrgIDSet.contains(noPermissionCompanyId)) {
                            noCompanyPermissonSb.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"hasNoAccountCheckPermission", (Locale)locale), companyAndNameMap.get(noPermissionCompanyId))).append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"deleteFailData", (Locale)locale));
                            noCompanyPermissonSb.append("\n");
                            noPermissionOrg = true;
                        }
                        Set headNumberSet = (Set)noPermissionOrgHeadMap.get(noPermissionCompanyId);
                        for (String number : headNumberSet) {
                            if (noDeletePermissionOrg) {
                                noDeletePermissionSb.append(number);
                                noDeletePermissionSb.append("\n");
                            }
                            if (!noPermissionOrg) continue;
                            noCompanyPermissonSb.append(number);
                            noCompanyPermissonSb.append("\n");
                        }
                    }
                }
                if (noConfirmSb.length() > 0) {
                    resultInfoSb.append((CharSequence)noConfirmSb);
                    resultInfoSb.append("\n");
                }
                if (noDeletePermissionSb.length() > 0) {
                    resultInfoSb.append((CharSequence)noDeletePermissionSb);
                    resultInfoSb.append("\n");
                }
                if (noCompanyPermissonSb.length() > 0) {
                    resultInfoSb.append((CharSequence)noCompanyPermissonSb);
                    resultInfoSb.append("\n");
                }
                if (deleteBillIdMap.isEmpty()) {
                    reusltMap.put("resultInfo", resultInfoSb.toString());
                    reusltMap.put("allSuccess", false);
                    reusltMap.put("someSuccess", false);
                    hashMap = reusltMap;
                    return hashMap;
                }
                deleteBillHeadIdSet.removeAll(connotDeleteBillHeadSet);
                deleteBillCompanyIdSet.removeAll(connotDeleteBillCompanySet);
                if (deleteBillHeadIdSet.size() > 0) {
                    sql.reset();
                    sql.append("delete from T_Csl_CheckageBillHead where fid in ", deleteBillHeadIdSet);
                    DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                }
                if (deleteBillCompanyIdSet.size() > 0) {
                    sql.reset();
                    sql.append("delete from T_Csl_CheckageBillCompany where fid in ", deleteBillCompanyIdSet);
                    DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                }
                if (deleteBillIdMap.size() > 0) {
                    String deletor = ctx.getCaller().toString();
                    tmpTablePool = TempTablePool.getInstance((Context)ctx);
                    sql.reset();
                    sql.append("create table t_csl_tempBillDelRc(FYear int, FPeriod int, FCurrencyId varchar(44), FCompanyId varchar(44), FTargetCompanyId varchar(44), FAccountId varchar(44), ");
                    sql.append("FBalType int, FBillHeadID varchar(44), FDeletorID varchar(44), FDeleteTime DateTime, FID varchar(44), FItemType int, FDataSource int, FDataElement int,");
                    sql.append("FItemNumber nvarchar(80), FItemName nvarchar(255), FDeleteCompany varchar(44))");
                    deleteTmpTable = tmpTablePool.createTempTable(sql.getSQL());
                    sql.reset();
                    sql.append("insert into \n").append(deleteTmpTable);
                    sql.append("(FYear,FPeriod,FCurrencyId,FCompanyId,FTargetCompanyId,FAccountId,FBalType,FBillHeadID,FDeletorID,FDeleteTime,FID,FItemType,FDataSource,FDataElement,FItemNumber,FItemName,FDeleteCompany) \n");
                    if (ItemTypeEnum.account == itemTypeEnum) {
                        sql.append("select bill.FYear,bill.FPeriod,bill.FCurrencyId,bill.FCompanyId,bill.FTargetCompanyId,bill.FAccountId,bill.FBalType,bill.FBillHeadID,'").append(deletor).append("',getDate(),newBosid('CB6A80C8'),bill.FItemType,bill.FDataSource,bill.FDataElement,bill.FItemNumber,null,orgPack.FCompanyId \n");
                    } else {
                        sql.append("select bill.FYear,bill.FPeriod,bill.FCurrencyId,bill.FCompanyId,bill.FTargetCompanyId,null,null,bill.FBillHeadID,'").append(deletor).append("',getDate(),newBosid('CB6A80C8'),bill.FItemType,bill.FDataSource,bill.FDataElement,bill.FItemNumber,bill.FItemName,orgPack.FCompanyId \n");
                    }
                    sql.append("from T_Csl_CheckageBill bill \n");
                    sql.append(" left join T_Csl_CheckageOrgPack orgPack on orgPack.FYear=bill.FYear and orgPack.FPeriod=bill.FPeriod and orgPack.FCurrencyId=bill.FCurrencyId and orgPack.FCompanyId=bill.FCompanyId and orgPack.FItemType=bill.FItemType \n");
                    sql.append(" where bill.fid in \n", deleteBillIdMap.keySet());
                    sql.append(" and bill.FCompanyId in ", hasPermissionOrgIDSet);
                    DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                    sql.reset();
                    sql.append("select top 1 * from ").append(deleteTmpTable);
                    rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                    if (rowSet != null && rowSet.size() > 0) {
                        sql.reset();
                        sql.append("delete From T_CSL_BillDeleteRecord delDataRc where delDataRc.fid in  \n");
                        sql.append("(select delRc.fid From T_CSL_BillDeleteRecord delRc \n");
                        sql.append("inner join ").append(deleteTmpTable).append(" delRcTmep on delRcTmep.FYear=delRc.FYear and delRcTmep.FPeriod=delRc.FPeriod and delRcTmep.FCurrencyId=delRc.FCurrencyId and delRcTmep.FItemType=delRc.FItemType and delRcTmep.FDeleteCompany=delRc.FDeleteCompany)");
                        DbUtil.execute(ctx, sql.getSQL());
                        sql.reset();
                        sql.append("insert into T_CSL_BillDeleteRecord \n");
                        sql.append("(FYear,FPeriod,FCurrencyId,FCompanyId,FTargetCompanyId,FAccountId,FBalType,FBillHeadID,FDeletorID,FDeleteTime,FID,FItemType,FDataSource,FDataElement,FItemNumber,FItemName,FDeleteCompany) \n");
                        sql.append("select FYear,FPeriod,FCurrencyId,FCompanyId,FTargetCompanyId,FAccountId,FBalType,FBillHeadID,FDeletorID,FDeleteTime,FID,FItemType,FDataSource,FDataElement,FItemNumber,FItemName,FDeleteCompany \n");
                        sql.append("from ").append(deleteTmpTable);
                        DbUtil.execute(ctx, sql.getSQL());
                    }
                    sql.reset();
                    sql.append("delete from T_CSL_CheckageBillData where fid in \n");
                    sql.append("(select FSrcBillId from T_CSL_CheckageBill where fid in ", deleteBillIdMap.keySet()).append(" )");
                    DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                    sql.reset();
                    sql.append("delete from T_Csl_CheckageBill where fid in ", deleteBillIdMap.keySet());
                    DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                    HashSet<String> updateDiffHeadIds = new HashSet<String>();
                    for (String headId : deleteBillIdMap.values()) {
                        if (deleteBillHeadIdSet.contains(headId)) continue;
                        updateDiffHeadIds.add(headId);
                    }
                    if (!updateDiffHeadIds.isEmpty()) {
                        AccountCheckUtil.updateDiff(ctx, updateDiffHeadIds, null);
                    }
                }
                if (resultInfoSb.length() <= 0) {
                    reusltMap.put("allSuccess", true);
                    hashMap = reusltMap;
                    return hashMap;
                }
                reusltMap.put("resultInfo", resultInfoSb.toString());
                reusltMap.put("allSuccess", false);
                reusltMap.put("someSuccess", true);
                hashMap = reusltMap;
                if (DebugLogger.isDebug || tmpTablePool == null || deleteTmpTable == null) break block45;
            }
            catch (Exception e) {
                logger.error((Object)"_removeData_error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (!DebugLogger.isDebug && tmpTablePool != null && deleteTmpTable != null) {
                    tmpTablePool.releaseTable(deleteTmpTable);
                }
            }
            tmpTablePool.releaseTable(deleteTmpTable);
        }
        return hashMap;
    }

    @Override
    protected Map _getFiscal(Context ctx, Set companyIdSet) throws BOSException, EASBizException {
        if (companyIdSet == null || companyIdSet.isEmpty()) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int minYear = -1;
        int maxYear = -1;
        int minPeriod = -1;
        int maxPeriod = -1;
        Object companyid = null;
        SQLBuilder sql = new SQLBuilder();
        sql.append("select min(period.FPeriodYear) minYear, max(period.FPeriodYear) maxYear, min(period.FPeriodNumber) minPeriod, max(period.FPeriodNumber) maxPeriod from T_BD_Period period \n");
        sql.append("inner join T_ORG_Company company on company.FAccountPeriodID=period.FTypeID \n");
        sql.append("where company.fid in ", companyIdSet);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (rowSet != null && rowSet.size() > 0) {
            try {
                rowSet.next();
                minYear = rowSet.getInt("minYear");
                maxYear = rowSet.getInt("maxYear");
                minPeriod = rowSet.getInt("minPeriod");
                maxPeriod = rowSet.getInt("maxPeriod");
                map.put("minYear", minYear);
                map.put("maxYear", maxYear);
                map.put("minPeriod", minPeriod);
                map.put("maxPeriod", maxPeriod);
                return map;
            }
            catch (SQLException e) {
                logger.error((Object)"_getFiscal_error", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    protected void _updateBilHeadDiff(Context ctx, Set billHeadIdSet) throws BOSException, EASBizException {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select isnull(sum(FConfirmDebit),0)-isnull(sum(FConfirmCredit),0) sumbillConfirmCrebit,FbillHeadId from T_CSL_CheckageBill where FbillHeadId in \n", billHeadIdSet);
        sql.append(" group by FbillHeadId");
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                Object[] parmas = null;
                StringBuilder updateSqlSb = new StringBuilder();
                updateSqlSb.append("update T_Csl_CheckageBillHead set FCompanyDiff=? where Fid=?");
                while (rowSet.next()) {
                    parmas = new Object[]{rowSet.getBigDecimal("sumbillConfirmCrebit"), rowSet.getString("FbillHeadId")};
                    paramsList.add(parmas);
                }
                if (paramsList.size() > 0) {
                    DbUtil.executeBatch(ctx, updateSqlSb.toString(), paramsList);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_updateBilHeadDiff_error", (Throwable)e);
        }
    }

    @Override
    protected Map _fetchDataBySchm(Context ctx, Map params) throws BOSException, EASBizException {
        AccountCheckWorkeFilterInfo filterInfo = (AccountCheckWorkeFilterInfo)params.get("filterInfo");
        AutoCheckParams autoCheckParams = (AutoCheckParams)params.get("autoCheckParams");
        this.fetchAccountData(ctx, filterInfo, autoCheckParams);
        return null;
    }

    @Override
    protected Map _confirmDataBySchm(Context ctx, Map params) throws BOSException, EASBizException {
        AccountCheckWorkeFilterInfo filterInfo = (AccountCheckWorkeFilterInfo)params.get("filterInfo");
        AutoCheckParams autoCheckParams = (AutoCheckParams)params.get("autoCheckParams");
        Map billHeadIdMap = this.getBillHeadIdMapConfirmByShcm(ctx, filterInfo, autoCheckParams);
        HashMap<String, Map> infoMap = new HashMap<String, Map>();
        infoMap.put("billHeadMap", billHeadIdMap);
        this.confirm(ctx, infoMap, true, autoCheckParams);
        return null;
    }

    private Map getBillHeadIdMapConfirmByShcm(Context ctx, AccountCheckWorkeFilterInfo filterInfo, AutoCheckParams autoCheckParams) throws BOSException {
        Set companySet;
        IRowSet rowSet;
        HashMap billHeadIdMap = new HashMap();
        HashMap<String, HashSet<String>> billAndHeadIdSetMap = new HashMap<String, HashSet<String>>();
        HashSet<String> billHeadIdSet = new HashSet<String>();
        String accountCheckCompanyId = filterInfo.getAccountCheckCompanyId();
        int year = filterInfo.getYear();
        int period = filterInfo.getPeriod();
        String currencyId = filterInfo.getCurrencyId();
        HashSet<String> allBillHeadIdSet = new HashSet<String>();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select distinct bill.fbillheadid headId from T_Csl_CheckageBill bill where bill.fyear=? \n", year);
        sql.append("and bill.fperiod=? \n", period);
        sql.append("and bill.fcurrencyid=? \n", currencyId);
        sql.append("and bill.fcompanyId=? \n", accountCheckCompanyId);
        sql.append("and bill.FItemType=?", 0);
        try {
            rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    allBillHeadIdSet.add(rowSet.getString("headId"));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getBillHeadIdMapConfirmByShcm_error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (allBillHeadIdSet.size() > 0) {
            AutoCheckSchmInfo schmInfo = autoCheckParams.getSchmInfo();
            CompareCharEnum confirmSDiffCmpChar = schmInfo.getConfirmSDiffCmpChar();
            BigDecimal confirmSDffCmpValue = schmInfo.getConfirmSDffCmpValue();
            this.queryBillHeadIdSetBySchm(ctx, accountCheckCompanyId, year, period, currencyId, confirmSDiffCmpChar, confirmSDffCmpValue, billHeadIdSet, allBillHeadIdSet, true);
            CompareCharEnum confirmDDiffCmpChar = schmInfo.getConfirmDDiffCmpChar();
            BigDecimal confirmDDiffCmpValue = schmInfo.getConfirmDDiffCmpValue();
            this.queryBillHeadIdSetBySchm(ctx, accountCheckCompanyId, year, period, currencyId, confirmDDiffCmpChar, confirmDDiffCmpValue, billHeadIdSet, allBillHeadIdSet, false);
        }
        if (!billHeadIdSet.isEmpty()) {
            try {
                sql.reset();
                sql.append("select distinct bill.fbillheadid headId, bill.FCompanyId companyId, acctMap.FIsUnilateralReconciliation isUnilateral \n");
                sql.append("from T_Csl_CheckageBill bill \n");
                sql.append("inner join T_Csl_CheckageBillHead billHead on billHead.Fid=bill.FBillHeadId \n");
                sql.append("inner join T_Csl_AccountMap acctMap on acctMap.fid=billHead.FAccountMapId \n");
                sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.fid=bill.FBillCompanyId \n");
                sql.append("where bill.fbillheadid in \n", billHeadIdSet);
                sql.append("and billCompany.FConfirmStatus=?", 0);
                rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (rowSet != null && rowSet.size() > 0) {
                    while (rowSet.next()) {
                        String headId = rowSet.getString("headId");
                        String companyId = rowSet.getString("companyId");
                        HashSet<String> headIdSet = (HashSet<String>)billAndHeadIdSetMap.get(companyId);
                        if (headIdSet == null) {
                            headIdSet = new HashSet<String>();
                            billAndHeadIdSetMap.put(companyId, headIdSet);
                        }
                        headIdSet.add(headId);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"getBillHeadIdMapConfirmByShcm_error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if ((companySet = billAndHeadIdSetMap.keySet()) != null && !companySet.isEmpty()) {
            try {
                IObjectPK[] pkArray = new IObjectPK[companySet.size()];
                int i = 0;
                for (String companyIdStr : companySet) {
                    pkArray[i++] = new ObjectUuidPK(companyIdStr);
                }
                ObjectUuidPK userPK = new ObjectUuidPK(ctx.getCaller().toString());
                Set haveViewPermissionOrgSet = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)userPK, pkArray, "csl_checkwork_view");
                HashSet<String> haveOrgPermissionOrgSet = new HashSet<String>();
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                view.setSelector(sic);
                sic.add(new SelectorItemInfo("company"));
                sic.add(new SelectorItemInfo("isfree"));
                sic.add(new SelectorItemInfo("freeTime"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company", companySet, CompareType.INCLUDE));
                view.setFilter(filter);
                CheckageCompanyCollection checkageCompanyCollection = CheckageCompanyFactory.getLocalInstance(ctx).getCheckageCompanyCollection(view);
                if (checkageCompanyCollection == null || checkageCompanyCollection.isEmpty()) {
                    return billHeadIdMap;
                }
                String yearPeriodStr = RptUtil.getYearPeriod((int)year, (int)period, (int)year, (int)period);
                for (int x = 0; x < checkageCompanyCollection.size(); ++x) {
                    CheckageCompanyInfo chInfo = checkageCompanyCollection.get(x);
                    CompanyOrgUnitInfo company = chInfo.getCompany();
                    if (company == null || company.getId() == null) continue;
                    boolean isfree = chInfo.isIsfree();
                    String companyId = company.getId().toString();
                    if (isfree) {
                        int freeTime = chInfo.getFreeTime();
                        String freezeStr = freeTime + "";
                        if (freezeStr.compareTo(yearPeriodStr) <= 0 || haveViewPermissionOrgSet == null || !haveViewPermissionOrgSet.contains(companyId)) continue;
                        haveOrgPermissionOrgSet.add(companyId);
                        continue;
                    }
                    if (haveViewPermissionOrgSet == null || !haveViewPermissionOrgSet.contains(companyId)) continue;
                    haveOrgPermissionOrgSet.add(companyId);
                }
                pkArray = new IObjectPK[haveOrgPermissionOrgSet.size()];
                int y = 0;
                for (String companyIdStr : haveOrgPermissionOrgSet) {
                    pkArray[y++] = new ObjectUuidPK(companyIdStr);
                }
                Set haveConfirmPermissionOrgSet = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)userPK, pkArray, "csl_checkwork_confirm");
                for (String companyIdStr : haveConfirmPermissionOrgSet) {
                    boolean canConfirmUnCheckOutData = CSLParamUtil.getParamBooleanValue((Context)ctx, (String)companyIdStr, (String)"GR_CSL_DZPT_CanConfirmUnCheckOutData");
                    if (!canConfirmUnCheckOutData) {
                        PeriodInfo currentPeriod = GlUtils.getCurrentPeriod((Context)ctx, (String)companyIdStr);
                        if (currentPeriod == null) continue;
                        int curYear = currentPeriod.getPeriodYear();
                        int curPeriod = currentPeriod.getPeriodNumber();
                        if (year > curYear || year == curYear && period >= curPeriod) continue;
                    }
                    billHeadIdMap.put(companyIdStr, billAndHeadIdSetMap.get(companyIdStr));
                }
            }
            catch (Exception e) {
                logger.error((Object)"getBillHeadIdMapConfirmByShcm_error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return billHeadIdMap;
    }

    private void queryBillHeadIdSetBySchm(Context ctx, String accountCheckCompanyId, int year, int period, String currencyId, CompareCharEnum confirmCmpChar, BigDecimal confirmCmpValue, Set<String> billHeadIdSet, Set<String> allBillHeadIdSet, boolean isSingle) throws BOSException {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select distinct billHead.fid headId from T_Csl_CheckageBillHead billHead \n");
        sql.append("inner join T_Csl_AccountMap acctMap on acctMap.fid=billHead.FAccountMapId \n");
        sql.append("where billHead.fid in \n", allBillHeadIdSet);
        sql.append("and acctMap.FIsUnilateralReconciliation=").append(isSingle ? 1 : 0).append(" \n");
        sql.append("and billHead.FCompanyDiff").append(confirmCmpChar.getValue()).append(confirmCmpValue).append(" \n");
        sql.append("and billHead.FAuditedStatus=? ", 1);
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    billHeadIdSet.add(rowSet.getString("headId"));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"queryBillHeadIdSetBySchm_error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getTmpTableInfo(Context ctx, String fetchTmpTable) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)fetchTmpTable)) {
            return null;
        }
        HashMap resultMap = new HashMap();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select billId,billHeadId,billCompanyId,billHeadNumber,seq from ").append(fetchTmpTable);
        sql.append(" order by billHeadId");
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
            if (rowSet != null && rowSet.size() > 0) {
                LinkedList<AccountCheckWorkeInfo> resultList = new LinkedList<AccountCheckWorkeInfo>();
                while (rowSet.next()) {
                    AccountCheckWorkeInfo info = new AccountCheckWorkeInfo();
                    info.id = rowSet.getString("billId");
                    info.billHeadId = rowSet.getString("billHeadId");
                    info.billCompanyId = rowSet.getString("billCompanyId");
                    info.billHeadNumber = rowSet.getString("billHeadNumber");
                    info.isSelf = rowSet.getInt("seq") == 0;
                    resultList.add(info);
                }
                resultMap.put("result", resultList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getTmpTableInfo_error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    @Override
    protected Map _getCheckImportForReportTemplate(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        HashSet<String> templateIdSet = new HashSet<String>();
        SQLBuilder sql = new SQLBuilder();
        boolean isGroupCommreport = 6 == (Integer)params.get("templateType");
        try {
            if (isGroupCommreport) {
                HashSet<Integer> reportClassSet = new HashSet<Integer>();
                reportClassSet.add(51);
                reportClassSet.add(10);
                reportClassSet.add(20);
                sql.append("select distinct tmp.fid templateId from T_RPT_Template tmp \n");
                sql.append("inner join T_RPT_RptSheetPara sheetParam on sheetParam.FReportID=tmp.fid \n");
                sql.append("where tmp.FTemplateType=? \n", 6);
                sql.append("and tmp.FAuditedStatus=? \n", 2);
                sql.append("and tmp.FIsFreezed=0 \n");
                sql.append("and tmp.FIsK3Tpl=0 \n");
                sql.append("and tmp.FVersionStatus=? \n", 1);
                sql.append("and tmp.FPublishedStatus=? \n", 1);
                sql.append("and sheetParam.FRelaType=? \n", 1);
                sql.append("and sheetParam.FReportClass in ", reportClassSet);
                IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (rowSet != null && rowSet.size() > 0) {
                    while (rowSet.next()) {
                        templateIdSet.add(rowSet.getString("templateId"));
                    }
                }
            } else {
                sql.append("select distinct tmp.fid templateId from T_RPT_Template tmp \n");
                sql.append(" inner join t_csl_templetitemlist itemList on itemList.ftemplateid=tmp.fid \n");
                sql.append(" where itemList.fasstacttypenumber in (select fnumber from t_bd_asstacttype where fassthgattribute in('customer','provider','companyOrg')) \n ");
                sql.append(" and tmp.ftemplateType=? ", 10);
                sql.append(" and tmp.fauditedStatus=? ", 2);
                sql.append(" and tmp.fisFreezed=? ", 0);
                sql.append(" and tmp.fisK3Tpl=? ", 0);
                sql.append(" and tmp.fversionStatus=? ", 1);
                sql.append(" and tmp.fpublishedStatus=? ", 1);
                IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (rowSet != null && rowSet.size() > 0) {
                    while (rowSet.next()) {
                        templateIdSet.add(rowSet.getString("templateId"));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"_getCheckImportForReportTemplate", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        resultMap.put("ids", templateIdSet);
        return resultMap;
    }

    @Override
    protected Map _getImportForReportSheetInfo(Context ctx, Set sheetIdSet) throws BOSException, EASBizException {
        if (sheetIdSet == null || sheetIdSet.isEmpty()) {
            return null;
        }
        HashMap resultMap = new HashMap();
        SQLBuilder sql = new SQLBuilder();
        try {
            String la = ctx.getLocale().getLanguage();
            sql.append("select distinct tmp.fid templateId,tmp.fname tmpName,tmp.fnumber tmpNumber, \n");
            sql.append("sheetParam.fsheetname sheetParamName,sheetParam.fid sheetParamId from T_RPT_Template tmp \n");
            sql.append("inner join T_RPT_RptSheetPara sheetParam on sheetParam.FReportID=tmp.fid \n");
            sql.append("where sheetParam.fid in \n", sheetIdSet);
            sql.append("order by tmp.fid");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                ArrayList<Object[]> rowInfoList = new ArrayList<Object[]>();
                while (rowSet.next()) {
                    Object[] infoObj = new Object[]{rowSet.getString("tmpNumber"), rowSet.getString("tmpName"), rowSet.getString("sheetParamName"), rowSet.getString("templateId"), rowSet.getString("sheetParamId")};
                    rowInfoList.add(infoObj);
                }
                resultMap.put("result", rowInfoList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getImportForReportSheetInfo_error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    @Override
    protected String _importCheckDataFromRpt(Context ctx, ImportFromRptParamInfo importParamInfo) throws BOSException, EASBizException {
        try {
            StringBuffer msg = new StringBuffer();
            Map<String, List<String>> templates = importParamInfo.templates;
            if (templates != null && !templates.isEmpty()) {
                String curmsg;
                ImportFromRptUtil importFromRptUtil = ImportFromRptUtil.getInstance();
                Map<String, List<String>>[] curTmplates = importFromRptUtil.getTemplateByGroup(ctx, templates);
                Map<String, List<String>> interExchDyTemplates = curTmplates[0];
                Map<String, List<String>> checkDataRptTemplates = curTmplates[1];
                if (interExchDyTemplates != null && !interExchDyTemplates.isEmpty() && !StringUtils.isEmpty((String)(curmsg = importFromRptUtil.importItemDatasFromInterExchDyRpt(ctx, interExchDyTemplates, importParamInfo.orgUnitIds, importParamInfo.year, importParamInfo.period, importParamInfo.periodType, importParamInfo.currencyId, importParamInfo.rptAuditStatus, importParamInfo.rptCommitStatus, importParamInfo.importMode)))) {
                    msg.append(curmsg);
                }
                if (checkDataRptTemplates != null && !checkDataRptTemplates.isEmpty() && !StringUtils.isEmpty((String)(curmsg = importFromRptUtil.importItemDatasFromCheckAgeBillRpt(ctx, checkDataRptTemplates, importParamInfo.orgUnitIds, importParamInfo.year, importParamInfo.period, importParamInfo.periodType, importParamInfo.currencyId, importParamInfo.rptAuditStatus, importParamInfo.rptCommitStatus, importParamInfo.importMode)))) {
                    msg.append(curmsg);
                }
            }
            return msg.toString();
        }
        catch (Exception ex) {
            logger.error((Object)"_importCheckDataFromRpt error.", (Throwable)ex);
            throw new BOSException("_importCheckDataFromRpt error.", (Throwable)ex);
        }
    }

    @Override
    protected List _getDyTemplateSheets(Context ctx, Set templateIds) throws BOSException, EASBizException {
        try {
            SQLBuilder sql = new SQLBuilder();
            sql.append("select distinct items.ftemplateid,items.FSheetName,tmp.fnumber,tmp.fname,para.fid paraId from t_csl_templetitemlist items  \n");
            sql.append(" inner join t_rpt_template tmp on tmp.fid=items.ftemplateId \n");
            sql.append(" inner join t_rpt_rptsheetpara para on para.freportid=tmp.fid and para.fsheetid=items.fsheetid ");
            sql.append(" where items.fasstacttypenumber in (select fnumber from t_bd_asstacttype where fassthgattribute in('customer','provider','companyOrg')) \n ");
            sql.append(" and items.ftemplateid in ", templateIds);
            sql.append(" order by items.ftemplateid,items.FSheetName ");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                ArrayList<String[]> result = new ArrayList<String[]>();
                while (rowSet.next()) {
                    String[] data = new String[]{rowSet.getString("fnumber"), rowSet.getString("fname"), rowSet.getString("FSheetName"), rowSet.getString("ftemplateid"), rowSet.getString("paraId")};
                    result.add(data);
                }
                return result;
            }
        }
        catch (Exception e) {
            logger.error((Object)"_getDyTemplateSheets error", (Throwable)e);
            throw new BOSException("_getDyTemplateSheets error", (Throwable)e);
        }
        return null;
    }

    @Override
    protected void _removeBillData(Context ctx, Map infoMap) throws BOSException, EASBizException {
        Set dataSourceSet = (Set)infoMap.get("dataSourceSet");
        int year = (Integer)infoMap.get("year");
        int period = (Integer)infoMap.get("period");
        String currencyId = (String)infoMap.get("currencyId");
        String companyTempTable = (String)infoMap.get("companyTempTable");
        int itemType = (Integer)infoMap.get("itemTypeEnum");
        try {
            IRowSet rowSet;
            HashSet<String> companySet = new HashSet<String>();
            HashSet<String> deleteBillIdSet = new HashSet<String>();
            HashSet<String> deleteBillHeadIdSet = new HashSet<String>();
            HashSet<String> deleteBillCompanyIdSet = new HashSet<String>();
            SQLBuilder sql = new SQLBuilder();
            if (!StringUtils.isEmpty((String)companyTempTable)) {
                sql.append("select FCompanyId from ").append(companyTempTable);
                rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
                if (rowSet != null && rowSet.size() > 0) {
                    while (rowSet.next()) {
                        companySet.add(rowSet.getString("FCompanyId"));
                    }
                }
            }
            sql.reset();
            sql.append("select bill.fid billId,bill.FBillHeadId headId,bill.FBillCompanyId billCompanyId from T_Csl_CheckageBill bill \n");
            sql.append("inner join T_Csl_CheckageBillHead billHead on bill.FBillHeadId=billHead.Fid \n");
            sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.Fid=bill.FBillCompanyId \n");
            sql.append("left join T_CSL_CheckageBillData billData on billData.Fid=bill.FSrcBillId \n");
            sql.append("where bill.fyear=? \n", year);
            sql.append("and bill.fperiod=? \n", period);
            sql.append("and bill.fcurrencyId=? \n", currencyId);
            sql.append("and bill.fitemtype=? \n", itemType);
            sql.append("and bill.fdatasource in \n", dataSourceSet);
            sql.append("and billCompany.FConfirmStatus=? \n", 0);
            if (!companySet.isEmpty()) {
                sql.append(" And (billData.FCreateCompanyId in  \n", companySet);
                sql.append(" OR (bill.FCompanyId in ", companySet);
                sql.append(" And FCreateCompanyId not in ", companySet);
                sql.append("))");
            }
            if ((rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams())) != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    deleteBillIdSet.add(rowSet.getString("billId"));
                    deleteBillHeadIdSet.add(rowSet.getString("headId"));
                    deleteBillCompanyIdSet.add(rowSet.getString("billCompanyId"));
                }
                sql.reset();
                sql.append("select rs.fbillheadid,count(rs.fbillheadid) countNum from \n");
                sql.append("(select fbillheadid,fcompanyId from T_Csl_CheckageBill where fbillheadid in \n", deleteBillHeadIdSet);
                sql.append("group by fbillheadid,fcompanyId) rs group by rs.fbillheadid having count(rs.fbillheadid)>1");
                rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (rowSet != null && rowSet.size() > 0) {
                    HashSet<String> headIdSet = new HashSet<String>();
                    while (rowSet.next()) {
                        headIdSet.add(rowSet.getString("fbillheadid"));
                    }
                    if (headIdSet.size() > 0) {
                        if (!companySet.isEmpty()) {
                            deleteBillHeadIdSet.removeAll(headIdSet);
                        } else {
                            sql.reset();
                            sql.append("select distinct bill.FBillHeadId headId from T_Csl_CheckageBill bill \n");
                            sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.Fid=bill.FBillCompanyId \n");
                            sql.append("where bill.FBillHeadId in \n", headIdSet);
                            sql.append("and billCompany.FConfirmStatus=?", 1);
                            rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                            if (rowSet != null && rowSet.size() > 0) {
                                while (rowSet.next()) {
                                    deleteBillHeadIdSet.remove(rowSet.getString("headId"));
                                }
                            }
                        }
                    }
                }
                if (deleteBillIdSet.size() > 0) {
                    sql.reset();
                    sql.append("delete from T_Csl_CheckageBill where fid in ", deleteBillIdSet);
                    DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                }
                if (deleteBillCompanyIdSet.size() > 0) {
                    sql.reset();
                    sql.append("delete from T_Csl_CheckageBillCompany where fid in ", deleteBillCompanyIdSet);
                    DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                }
                if (deleteBillHeadIdSet.size() > 0) {
                    sql.reset();
                    sql.append("delete from T_Csl_CheckageBillHead where fid in ", deleteBillHeadIdSet);
                    DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"_removeBillData error", (Throwable)e);
            throw new BOSException("_removeBillData error", (Throwable)e);
        }
    }

    @Override
    protected String _checkGlUnClosePeriod(Context ctx, IObjectValue period, String companyId) throws BOSException, EASBizException {
        return GLUnClosePeriodCheck.checkGlUnClosePeriodCheck(ctx, (PeriodInfo)period, companyId);
    }

    @Override
    protected Map _batchRequestMutex(Context ctx, List MutexParameters) throws BOSException, EASBizException {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        if (MutexParameters != null && !MutexParameters.isEmpty()) {
            ArrayList<Uuid> requestIds = new ArrayList<Uuid>();
            for (Object obj : MutexParameters) {
                Uuid requestId = Uuid.create();
                MutexParameter mutexParam = AccountCheckUtil.requestCheckControlLock(ctx, requestId, ((String[])obj)[0], ((String[])obj)[1], ((String[])obj)[2]);
                if (mutexParam != null) {
                    this._batchReleaseMutex(ctx, requestIds);
                    resMap.put("failMsg", mutexParam.getDescription());
                    return resMap;
                }
                requestIds.add(requestId);
            }
            resMap.put("requestIds", requestIds);
        }
        return resMap;
    }

    @Override
    protected Map _batchReleaseMutex(Context ctx, List requestIds) throws BOSException, EASBizException {
        for (Object requestId : requestIds) {
            CslRptUtil.releaseCheckControlLock((Context)ctx, (Uuid)((Uuid)requestId));
        }
        return null;
    }

    @Override
    protected List _getCheckageCompanyList(Context ctx, SubmitFilterInfo submitFilterInfo) throws BOSException, EASBizException {
        ArrayList rowList = new ArrayList();
        boolean submit = submitFilterInfo.isSubmit();
        int year = submitFilterInfo.getYear();
        int period = submitFilterInfo.getPeriod();
        String currencyId = submitFilterInfo.getCurrencyId();
        String searchStr = submitFilterInfo.getSearchStr();
        FullOrgUnitCollection orgCol = this._getAuthorizedOrg(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ctx.getCaller().toString())));
        if (orgCol == null || orgCol.isEmpty()) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("isfree"));
        sic.add(new SelectorItemInfo("freeTime"));
        CheckageCompanyCollection checkageCompanyCollection = CheckageCompanyFactory.getLocalInstance(ctx).getCheckageCompanyCollection(view);
        if (checkageCompanyCollection == null || checkageCompanyCollection.isEmpty()) {
            return null;
        }
        HashSet<String> orgIdSet = new HashSet<String>();
        String yearPeriodStr = RptUtil.getYearPeriod((int)year, (int)period, (int)year, (int)period);
        for (int i = 0; i < checkageCompanyCollection.size(); ++i) {
            CheckageCompanyInfo chInfo = checkageCompanyCollection.get(i);
            CompanyOrgUnitInfo company = chInfo.getCompany();
            if (company == null || company.getId() == null) continue;
            boolean isfree = chInfo.isIsfree();
            int freeTime = chInfo.getFreeTime();
            String companyId = company.getId().toString();
            String freezeStr = freeTime + "";
            if (isfree) {
                if (freezeStr.compareTo(yearPeriodStr) <= 0) continue;
                orgIdSet.add(companyId);
                continue;
            }
            orgIdSet.add(companyId);
        }
        if (orgIdSet.isEmpty()) {
            return null;
        }
        HashMap<String, String> infoMap = null;
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int i = 0; i < orgCol.size(); ++i) {
            FullOrgUnitInfo fullOrgUnitInfo = orgCol.get(i);
            String companyID = fullOrgUnitInfo.getId().toString();
            if (!orgIdSet.contains(companyID)) continue;
            String companyNumber = fullOrgUnitInfo.getNumber();
            String companyName = fullOrgUnitInfo.getName();
            if (!StringUtils.isEmpty((String)searchStr) && !companyNumber.contains(searchStr) && !companyName.contains(searchStr)) continue;
            if (submit) {
                infoMap = new HashMap<String, String>();
                infoMap.put("companyID", companyID);
                infoMap.put("companyNumber", companyNumber);
                infoMap.put("companyName", companyName);
                rowList.add(infoMap);
                continue;
            }
            companyIdSet.add(companyID);
        }
        if (!submit && !companyIdSet.isEmpty()) {
            String companyOrgTempTable;
            PreparedStatement ps;
            Connection conn;
            TempTablePool tmpTablePool;
            block21: {
                tmpTablePool = null;
                conn = null;
                ps = null;
                companyOrgTempTable = null;
                SQLBuilder sql = new SQLBuilder();
                try {
                    IRowSet rowSet;
                    int tempCriticalNum = submitFilterInfo.getTempCriticalNum();
                    if (companyIdSet.size() >= tempCriticalNum) {
                        tmpTablePool = TempTablePool.getInstance((Context)ctx);
                        sql.append("create table t_csl_tempSubCompany(fid varchar(44))");
                        companyOrgTempTable = tmpTablePool.createTempTable(sql.getSQL());
                        tmpTablePool.createIndex(companyOrgTempTable, "fid", false, false);
                        String insetSql = "insert into " + companyOrgTempTable + " values(?)";
                        conn = EJBFactory.getConnection((Context)ctx);
                        ps = conn.prepareStatement(insetSql);
                        for (String orgId : companyIdSet) {
                            ps.setObject(1, orgId);
                            ps.addBatch();
                        }
                        ps.executeBatch();
                        ps.clearBatch();
                    }
                    String la = ctx.getLocale().getLanguage();
                    sql.reset();
                    sql.append("select ckStatus.fid ckStId, ckStatus.FCompanyId companyId, company.Fnumber companyNumber, company.fname_").append(la).append(" companyName,  \n");
                    sql.append("submitor.fname_").append(la).append(" submitor, ckStatus.FLastUpdateTime submitTime, ckStatus.FStatus status \n");
                    sql.append("from T_Csl_CheckageCompanyStatus ckStatus \n");
                    sql.append("inner join T_ORG_Company company on company.fid=ckStatus.FCompanyId \n");
                    sql.append("inner join T_PM_User submitor on submitor.fid=ckStatus.FLastUpdateUserID \n");
                    sql.append("where ckStatus.FYear=? \n", year);
                    sql.append("and ckStatus.FPeriod=? \n", period);
                    sql.append("and ckStatus.FCurrencyId=? \n", currencyId);
                    if (companyOrgTempTable != null) {
                        sql.append("and ckStatus.FCompanyId in(select fid from ").append(companyOrgTempTable).append(") \n");
                    } else {
                        sql.append("and ckStatus.FCompanyId in \n ", companyIdSet);
                    }
                    CompanyStatusEnum status = submitFilterInfo.getStatus();
                    if (status != null) {
                        sql.append("and ckStatus.FStatus=? \n", status.getValue());
                    }
                    if (!StringUtils.isEmpty((String)searchStr)) {
                        sql.append("and (company.fname_").append(la).append(" like '%").append(searchStr).append("%' ");
                        sql.append("or company.Fnumber like '%").append(searchStr).append("%' )");
                    }
                    if ((rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams())) == null || rowSet.size() <= 0) break block21;
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    while (rowSet.next()) {
                        infoMap = new HashMap();
                        infoMap.put("companyID", rowSet.getString("companyId"));
                        infoMap.put("companyNumber", rowSet.getString("companyNumber"));
                        infoMap.put("companyName", rowSet.getString("companyName"));
                        infoMap.put("submitor", rowSet.getString("submitor"));
                        infoMap.put("submitTime", sdf.format(rowSet.getDate("submitTime")));
                        infoMap.put("status", CompanyStatusEnum.getEnum(rowSet.getInt("status")).getAlias());
                        infoMap.put("id", rowSet.getString("ckStId"));
                        rowList.add(infoMap);
                    }
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)"_getCheckageCompanyList error.", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(ps, conn);
                        if (!DebugLogger.isDebug && tmpTablePool != null && companyOrgTempTable != null) {
                            tmpTablePool.releaseTable(companyOrgTempTable);
                        }
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            if (!DebugLogger.isDebug && tmpTablePool != null && companyOrgTempTable != null) {
                tmpTablePool.releaseTable(companyOrgTempTable);
            }
        }
        return rowList;
    }

    @Override
    protected Map _submitCheckageBillData(Context ctx, Map paramMap, boolean isSubmit) throws BOSException, EASBizException {
        if (isSubmit) {
            return this.submitBillData(ctx, paramMap);
        }
        return this.unSubmitBillData(ctx, paramMap);
    }

    private Map submitBillData(Context ctx, Map paramMap) throws BOSException {
        HashMap<String, CharSequence> hashMap;
        HashMap<String, CharSequence> resultMap = new HashMap<String, CharSequence>();
        SubmitFilterInfo filterInfo = (SubmitFilterInfo)paramMap.get("filterInfo");
        Set companyIDSet = (Set)paramMap.get("companyIDSet");
        HashSet<String> ckCompanyStCompanyIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("companyId"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)filterInfo.getYear()));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)filterInfo.getPeriod()));
        filter.getFilterItems().add(new FilterItemInfo("currencyId", (Object)filterInfo.getCurrencyId()));
        view.setFilter(filter);
        CheckageCompanyStatusCollection checkageCompanyStatusCollection = CheckageCompanyStatusFactory.getLocalInstance(ctx).getCheckageCompanyStatusCollection(view);
        if (checkageCompanyStatusCollection != null && !checkageCompanyStatusCollection.isEmpty()) {
            for (int i = 0; i < checkageCompanyStatusCollection.size(); ++i) {
                CheckageCompanyStatusInfo statusInfo = checkageCompanyStatusCollection.get(i);
                ckCompanyStCompanyIdSet.add(statusInfo.getCompanyId());
            }
        }
        companyIDSet.removeAll(ckCompanyStCompanyIdSet);
        if (companyIDSet.isEmpty()) {
            resultMap.put("isEmpty", "true");
            return resultMap;
        }
        TempTablePool tmpTablePool = null;
        Connection conn = null;
        PreparedStatement ps = null;
        String companyOrgTempTable = null;
        SQLBuilder sql = new SQLBuilder();
        try {
            Map<String, String> noPassTolerCompany;
            int tempCriticalNum = (Integer)paramMap.get("tempCriticalNum");
            if (companyIDSet.size() >= tempCriticalNum) {
                tmpTablePool = TempTablePool.getInstance((Context)ctx);
                sql.append("create table t_csl_tempCkCompany(id varchar(44))");
                companyOrgTempTable = tmpTablePool.createTempTable(sql.getSQL());
                tmpTablePool.createIndex(companyOrgTempTable, "id", false, false);
                String insetSql = "insert into " + companyOrgTempTable + " values(?)";
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(insetSql);
                for (String orgId : companyIDSet) {
                    ps.setObject(1, orgId);
                    ps.addBatch();
                }
                ps.executeBatch();
                ps.clearBatch();
            }
            HashSet<String> conNotSubmitCompanyId = new HashSet<String>();
            String la = ctx.getLocale().getLanguage();
            sql.reset();
            sql.append("select company.fname_").append(la).append(" companyName, company.Fnumber comapnyNumber, \n");
            sql.append("bill.FItemType itemType, bill.FCompanyId companyId, billHead.Fnumber headNumber \n");
            sql.append("from T_Csl_CheckageBill bill \n");
            sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.fid=bill.FBillCompanyId \n");
            sql.append("inner join T_Csl_CheckageBillHead billHead on billHead.fid=bill.FBillHeadId \n");
            sql.append("inner join T_ORG_Company company on company.Fid=bill.FCompanyId \n");
            sql.append("where bill.FYear=? \n", filterInfo.getYear());
            sql.append("and bill.FPeriod=? \n", filterInfo.getPeriod());
            sql.append("and bill.FCurrencyId=? \n", filterInfo.getCurrencyId());
            sql.append("and billCompany.FConfirmStatus=? \n", 0);
            if (companyOrgTempTable != null) {
                sql.append("and bill.FCompanyId in(select id from ").append(companyOrgTempTable).append(")");
            } else {
                sql.append("and bill.FCompanyId in ", companyIDSet);
            }
            StringBuilder accountTypeSb = new StringBuilder();
            HashSet<String> accountTypeCompanyId = new HashSet<String>();
            StringBuilder rptTypeSb = new StringBuilder();
            HashSet<String> rptTypeCompanyId = new HashSet<String>();
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    String companyName = rowSet.getString("companyName");
                    String comapnyNumber = rowSet.getString("comapnyNumber");
                    String itemTypeAlias = ItemTypeEnum.getEnum(rowSet.getInt("itemType")).getAlias();
                    String headNumber = rowSet.getString("headNumber");
                    String companyId = rowSet.getString("companyId");
                    if (0 == rowSet.getInt("itemType")) {
                        if (!accountTypeCompanyId.contains(companyId)) {
                            accountTypeSb.append(AccountCheckUtil.getResourceString(ctx, "haveUnConfirmData", new Object[]{companyName, ItemTypeEnum.account.getAlias()})).append("\n");
                        }
                        accountTypeSb.append(headNumber).append("\n");
                        accountTypeCompanyId.add(companyId);
                    } else {
                        if (!rptTypeCompanyId.contains(companyId)) {
                            rptTypeSb.append(AccountCheckUtil.getResourceString(ctx, "haveUnConfirmData", new Object[]{companyName, ItemTypeEnum.rptItem.getAlias()})).append("\n");
                        }
                        rptTypeSb.append(headNumber).append("\n");
                        rptTypeCompanyId.add(companyId);
                    }
                    conNotSubmitCompanyId.add(companyId);
                }
            }
            StringBuilder outAllToleranceSb = new StringBuilder();
            Map<String, String>[] checkResult = ToleranceUtil.batchCheckTolerance(ctx, companyIDSet, companyOrgTempTable, filterInfo.getYear(), filterInfo.getPeriod(), filterInfo.getCurrencyId(), true);
            if (checkResult != null && !(noPassTolerCompany = checkResult[0]).isEmpty()) {
                for (String companyId : noPassTolerCompany.keySet()) {
                    if (conNotSubmitCompanyId.contains(companyId)) continue;
                    if (outAllToleranceSb.length() < 1) {
                        outAllToleranceSb.append(AccountCheckUtil.getResourceString(ctx, "orgOutAllTolerance_submit", null)).append("\n");
                    }
                    outAllToleranceSb.append(noPassTolerCompany.get(companyId)).append("\n");
                    conNotSubmitCompanyId.add(companyId);
                }
            }
            StringBuilder infoSb = new StringBuilder();
            if (accountTypeSb.length() > 0) {
                infoSb.append((CharSequence)accountTypeSb).append("\n");
            }
            if (rptTypeSb.length() > 0) {
                infoSb.append((CharSequence)rptTypeSb).append("\n");
            }
            if (outAllToleranceSb.length() > 0) {
                infoSb.append((CharSequence)outAllToleranceSb).append("\n");
            }
            accountTypeSb.setLength(0);
            accountTypeSb = null;
            rptTypeSb.setLength(0);
            rptTypeSb = null;
            outAllToleranceSb.setLength(0);
            outAllToleranceSb = null;
            accountTypeCompanyId.clear();
            accountTypeCompanyId = null;
            rptTypeCompanyId.clear();
            rptTypeCompanyId = null;
            if (infoSb.length() > 0) {
                resultMap.put("infoSb", infoSb);
            }
            companyIDSet.removeAll(conNotSubmitCompanyId);
            if (!companyIDSet.isEmpty()) {
                CoreBaseCollection colls = new CoreBaseCollection();
                Timestamp time = new Timestamp(new Date().getTime());
                UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
                for (String companyId : companyIDSet) {
                    CheckageCompanyStatusInfo statusInfo = new CheckageCompanyStatusInfo();
                    statusInfo.setCompanyId(companyId);
                    statusInfo.setStatus(CompanyStatusEnum.commited);
                    statusInfo.setYear(filterInfo.getYear());
                    statusInfo.setPeriod(filterInfo.getPeriod());
                    statusInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                    statusInfo.setCurrencyId(filterInfo.getCurrencyId());
                    statusInfo.setCreator(user);
                    statusInfo.setCreateTime(time);
                    statusInfo.setLastUpdateUser(user);
                    statusInfo.setLastUpdateTime(time);
                    statusInfo.setCU(cu);
                    colls.add((CoreBaseInfo)statusInfo);
                }
                CheckageCompanyStatusFactory.getLocalInstance(ctx).addnewBatchData(colls);
            }
            hashMap = resultMap;
        }
        catch (Exception e) {
            try {
                logger.error((Object)"submitBillData_error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                if (!DebugLogger.isDebug && tmpTablePool != null && companyOrgTempTable != null) {
                    tmpTablePool.releaseTable(companyOrgTempTable);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        if (!DebugLogger.isDebug && tmpTablePool != null && companyOrgTempTable != null) {
            tmpTablePool.releaseTable(companyOrgTempTable);
        }
        return hashMap;
    }

    private Map unSubmitBillData(Context ctx, Map paramMap) throws BOSException {
        HashMap<String, StringBuilder> hashMap;
        HashMap<String, StringBuilder> resultMap = new HashMap<String, StringBuilder>();
        Map companyAndIdMap = (Map)paramMap.get("companyAndIdMap");
        Collection CheckageCompanyStatusId = companyAndIdMap.values();
        TempTablePool tmpTablePool = null;
        Connection conn = null;
        PreparedStatement ps = null;
        String companyStTempTable = null;
        SQLBuilder sql = new SQLBuilder();
        try {
            int tempCriticalNum = (Integer)paramMap.get("tempCriticalNum");
            if (CheckageCompanyStatusId.size() >= tempCriticalNum) {
                tmpTablePool = TempTablePool.getInstance((Context)ctx);
                sql.append("create table t_csl_tempCompanySt(id varchar(44))");
                companyStTempTable = tmpTablePool.createTempTable(sql.getSQL());
                tmpTablePool.createIndex(companyStTempTable, "id", false, false);
                String insetSql = "insert into " + companyStTempTable + " values(?)";
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(insetSql);
                for (String companyStId : CheckageCompanyStatusId) {
                    ps.setObject(1, companyStId);
                    ps.addBatch();
                }
                ps.executeBatch();
                ps.clearBatch();
            }
            HashSet<String> canUnSubmitCompanyStId = new HashSet<String>();
            String la = ctx.getLocale().getLanguage();
            sql.reset();
            sql.append("select companySt.FStatus status, companySt.fid companyStId, company.fname_").append(la).append(" companyName, company.Fnumber comapnyNumber \n");
            sql.append("from T_Csl_CheckageCompanyStatus companySt  \n");
            sql.append("inner join T_ORG_Company company on company.Fid=companySt.FCompanyId \n");
            if (companyStTempTable != null) {
                sql.append("where companySt.fid in(select id from ").append(companyStTempTable).append(")");
            } else {
                sql.append("where companySt.fid in ", CheckageCompanyStatusId);
            }
            StringBuilder infoSb = new StringBuilder();
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    int status = rowSet.getInt("status");
                    String companyStId = rowSet.getString("companyStId");
                    if (2 == status) {
                        if (infoSb.length() < 1) {
                            infoSb.append(AccountCheckUtil.getResourceString(ctx, "unSubmitFail_dataIsLocked", null)).append("\n");
                        }
                        infoSb.append(rowSet.getString("comapnyNumber") + "-" + rowSet.getString("companyName")).append("\n");
                        continue;
                    }
                    canUnSubmitCompanyStId.add(companyStId);
                }
            }
            if (!canUnSubmitCompanyStId.isEmpty()) {
                sql.reset();
                sql.append("delete from T_Csl_CheckageCompanyStatus where fid in ", canUnSubmitCompanyStId);
                DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
            }
            if (infoSb.length() > 0) {
                resultMap.put("infoSb", infoSb);
            }
            hashMap = resultMap;
        }
        catch (Exception e) {
            try {
                logger.error((Object)"unSubmitBillData_error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                if (!DebugLogger.isDebug && tmpTablePool != null && companyStTempTable != null) {
                    tmpTablePool.releaseTable(companyStTempTable);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        if (!DebugLogger.isDebug && tmpTablePool != null && companyStTempTable != null) {
            tmpTablePool.releaseTable(companyStTempTable);
        }
        return hashMap;
    }
}

