/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.weaverpt.DispatchCycleEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmTaskCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmTaskFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CompareCharEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.app.AbstractAutoCheckSchmControllerBean;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckException;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckParams;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckSchemeHandle;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckTaskCatchImpl;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.IAutoCheckTaskCatch;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AutoCheckSchmControllerBean
extends AbstractAutoCheckSchmControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.AutoCheckSchmControllerBean");

    @Override
    protected HashSet _getAllAuthorizedOrg(Context ctx, String userId) throws BOSException, EASBizException {
        HashSet<String> orgIdSet = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        PermItemInfo permItemInfos = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, "csl_checkwork_view");
        sql.append("select DISTINCT BaseUnit.FID FID from T_ORG_BaseUnit BaseUnit \n");
        sql.append("INNER JOIN T_Csl_CheckageCompany CheckageCompany ON CheckageCompany.FCompanyId = BaseUnit.FID \n");
        sql.append("INNER JOIN (").append(this.combineHasPermSQL(userId, permItemInfos.getId().toString())).append(") perm \n");
        sql.append(" on BaseUnit.FID = perm.FOrgID \n");
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString());
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    orgIdSet.add(rowSet.getString("FID"));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"_getAllAuthorizedOrg() error", (Throwable)e);
        }
        return orgIdSet;
    }

    private String combineHasPermSQL(String userID, String permItemID) {
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID,UserOrgPerm.FPermItemID as FPermItemID \n").append(" FROM T_PM_UserOrgPerm UserOrgPerm \n").append(" WHERE UserOrgPerm.FOwner = '").append(userID).append("' AND UserOrgPerm.FPermItemID \n").append(" ='").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(10).append(" AND NOT EXISTS ( \n").append(" SELECT 'X' FROM T_PM_UserOrgPerm UserOrgPerm2 \n").append(" WHERE UserOrgPerm2.FOwner = '").append(userID).append("' AND UserOrgPerm2.FPermItemID \n").append(" ='").append(permItemID).append("' AND UserOrgPerm2.FPermType = ").append(20).append("\n").append(" AND UserOrgPerm.FPermItemID = UserOrgPerm2.FPermItemID \n").append(" AND UserOrgPerm.FOrgID = UserOrgPerm2.FOrgID) \n").append(" Union  \n").append(" SELECT UserRoleOrg.FOrgID AS FOrgID,RolePerm.FPermItemID as FPermItemID FROM T_PM_RolePerm RolePerm \n").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID \n").append(" WHERE UserRoleOrg.FUserID = '").append(userID).append("' AND RolePerm.FPermItemID ='").append(permItemID).append("'").append("  AND RolePerm.FPermType = ").append(10).append(" AND NOT EXISTS( \n").append(" SELECT 'X' FROM T_PM_RolePerm RolePerm2 \n").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg2 ON  RolePerm2.FRoleID = UserRoleOrg2.FRoleID \n").append(" WHERE UserRoleOrg2.FUserID = '").append(userID).append("' AND RolePerm2.FPermItemID ='").append(permItemID).append("'").append(" AND RolePerm2.FPermType = ").append(20).append(" \n").append(" AND RolePerm.FPermItemID = RolePerm2.FPermItemID \n").append(" AND UserRoleOrg.FOrgID = UserRoleOrg2.FOrgID) \n");
        return sql.toString();
    }

    @Override
    protected void _executeAutoCheckSchm(Context ctx, String schmId, String userId, Map params) throws BOSException, EASBizException {
        if (this.isRunningAutoCheckSchm(ctx, schmId)) {
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"844_RptAutoWeaveSchmRptControllerBean", (Locale)ctx.getOriginLocale()) + schmId));
            throw new AutoCheckException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.EXECUTE_WARNING_CANNOT_DUP_EXECUTE", (Locale)ctx.getOriginLocale()));
        }
        AutoCheckSchmInfo autoCheckSchmInfo = this.getSchmInfo(ctx, schmId);
        if (autoCheckSchmInfo.isIsFreezed()) {
            return;
        }
        if (userId == null) {
            userId = autoCheckSchmInfo.getLastUpdateUser().getId().toString();
        }
        if (params != null) {
            autoCheckSchmInfo = this.getAutoCheckSchmInfoByHandExecuted(autoCheckSchmInfo, params);
        }
        AutoCheckParams autoCheckParams = this.getAutoCheckParams(userId, autoCheckSchmInfo, params);
        AutoCheckSchemeHandle jobHandler = new AutoCheckSchemeHandle();
        String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"autoCheckSoluJobTitle", (Locale)ctx.getOriginLocale());
        String title = MessageFormat.format(msg, autoCheckSchmInfo.getNumber());
        this.createAutoCheckSoluJob(ctx, title, autoCheckParams, jobHandler);
    }

    private Job createAutoCheckSoluJob(Context ctx, String title, AutoCheckParams autoCheckParams, IJobHandler jobHandler) {
        JobInstanceConfig jobInstance = new JobInstanceConfig(jobHandler, true, false, 1, "AutoCheckSolu", null, JobIsolationLevel.Server);
        Timestamp scheduledTime = new Timestamp(System.currentTimeMillis());
        Job job = new Job(ctx, title, jobInstance, (Object)autoCheckParams, scheduledTime, null, -1, null);
        try {
            JobManager.instance().add(job);
        }
        catch (Exception e) {
            logger.error((Object)"createAutoCheckSoluJob\uff1a ", (Throwable)e);
        }
        return job;
    }

    private AutoCheckParams getAutoCheckParams(String userId, AutoCheckSchmInfo autoCheckSchmInfo, Map params) {
        AutoCheckParams autoCheckParams = new AutoCheckParams();
        autoCheckParams.setSchmInfo(autoCheckSchmInfo);
        autoCheckParams.setUserId(userId);
        RptPeriodTypeEnum periodType = autoCheckSchmInfo.getPeriodType();
        boolean isIncludAdjustPeriod = autoCheckSchmInfo.isIsIncludAdjustPeriod();
        if (params != null) {
            int year = (Integer)params.get("year");
            int period = 0;
            autoCheckParams.setYear(year);
            if (!periodType.equals((Object)RptPeriodTypeEnum.YEARLY)) {
                period = (Integer)params.get("period");
                autoCheckParams.setPeriod(period);
            } else {
                autoCheckParams.setPeriod(1);
            }
            int[] periods = this.getPeiodsByPeriodType(periodType, period, isIncludAdjustPeriod);
            autoCheckParams.setPeriods(periods);
        } else {
            List times = this.getDispatchTimes(autoCheckSchmInfo);
            int year = (Integer)times.get(0);
            autoCheckParams.setYear(year);
            int period = 0;
            if (!periodType.equals((Object)RptPeriodTypeEnum.YEARLY)) {
                period = (Integer)times.get(1);
                autoCheckParams.setPeriod(period);
            }
            int[] periods = this.getPeiodsByPeriodType(periodType, period, isIncludAdjustPeriod);
            autoCheckParams.setPeriods(periods);
        }
        return autoCheckParams;
    }

    private List getDispatchTimes(AutoCheckSchmInfo autoCheckSchmInfo) {
        RptPeriodTypeEnum periodType = autoCheckSchmInfo.getPeriodType();
        DispatchCycleEnum dispatchPeriod = autoCheckSchmInfo.getDispatchPeriod();
        Calendar calendar = Calendar.getInstance();
        List times = RPTDateUtil.getRptPeriod((Date)calendar.getTime(), (RptPeriodTypeEnum)periodType);
        Integer year = (Integer)times.get(0);
        Integer period = (Integer)times.get(1);
        times = dispatchPeriod.getValue() == 0 ? RPTDateUtil.getRptYearAndPeriodAndDate((int)year, (int)period, (int)periodType.getValue(), (int)0, (int)-1) : RPTDateUtil.getRptYearAndPeriodAndDate((int)year, (int)period, (int)periodType.getValue(), (int)0, (int)0);
        return times;
    }

    private int[] getPeiodsByPeriodType(RptPeriodTypeEnum periodType, int period, boolean isIncludAdjustPeriod) {
        int[] periods = null;
        periods = periodType.equals((Object)RptPeriodTypeEnum.QUARTERLY) ? this.getQuarterPeriods(period, isIncludAdjustPeriod) : (periodType.equals((Object)RptPeriodTypeEnum.SEMIYEARLY) ? this.getSemiYearPeriods(period, isIncludAdjustPeriod) : (periodType.equals((Object)RptPeriodTypeEnum.YEARLY) ? this.getFullYearPeriod(isIncludAdjustPeriod) : (period == 12 && isIncludAdjustPeriod ? new int[]{12, 13} : new int[]{period})));
        return periods;
    }

    private int[] getFullYearPeriod(boolean isIncludAdjustPeriod) {
        int[] periods = new int[12];
        if (isIncludAdjustPeriod) {
            periods = new int[13];
        }
        periods[0] = 1;
        periods[1] = 2;
        periods[2] = 3;
        periods[3] = 4;
        periods[4] = 5;
        periods[5] = 6;
        periods[6] = 7;
        periods[7] = 8;
        periods[8] = 9;
        periods[9] = 10;
        periods[10] = 11;
        periods[11] = 12;
        if (isIncludAdjustPeriod) {
            periods[12] = 13;
        }
        return periods;
    }

    private int[] getSemiYearPeriods(int period, boolean isIncludAdjustPeriod) {
        int[] periods = new int[6];
        if (period == 1) {
            periods[0] = 1;
            periods[1] = 2;
            periods[2] = 3;
            periods[3] = 4;
            periods[4] = 5;
            periods[5] = 6;
        } else {
            if (isIncludAdjustPeriod) {
                periods = new int[7];
            }
            periods[0] = 7;
            periods[1] = 8;
            periods[2] = 9;
            periods[3] = 10;
            periods[4] = 11;
            periods[5] = 12;
            if (isIncludAdjustPeriod) {
                periods[6] = 13;
            }
        }
        return periods;
    }

    private int[] getQuarterPeriods(int period, boolean isIncludAdjustPeriod) {
        int[] periods = new int[3];
        if (period == 1) {
            periods[0] = 1;
            periods[1] = 2;
            periods[2] = 3;
        } else if (period == 2) {
            periods[0] = 4;
            periods[1] = 5;
            periods[2] = 6;
        } else if (period == 3) {
            periods[0] = 7;
            periods[1] = 8;
            periods[2] = 9;
        } else {
            if (isIncludAdjustPeriod) {
                periods = new int[4];
            }
            periods[0] = 10;
            periods[1] = 11;
            periods[2] = 12;
            if (isIncludAdjustPeriod) {
                periods[3] = 13;
            }
        }
        return periods;
    }

    private AutoCheckSchmInfo getAutoCheckSchmInfoByHandExecuted(AutoCheckSchmInfo autoCheckSchmInfo, Map params) {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)params.get("periodType");
        autoCheckSchmInfo.setPeriodType(periodType);
        boolean isIncludAdjustPeriod = (Boolean)params.get("isIncludAdjustPeriod");
        autoCheckSchmInfo.setIsIncludAdjustPeriod(isIncludAdjustPeriod);
        CurrencyInfo currency = (CurrencyInfo)params.get("currency");
        autoCheckSchmInfo.setCurrency(currency);
        boolean isGetCheckData = (Boolean)params.get("isGetCheckData");
        boolean isConfirm = (Boolean)params.get("isConfirm");
        boolean isCoverGetChkData = (Boolean)params.get("isCoverGetChkData");
        CompareCharEnum confirmSDiffCmpChar = (CompareCharEnum)((Object)params.get("confirmSDiffCmpChar"));
        BigDecimal confirmSDffCmpValue = (BigDecimal)params.get("confirmSDffCmpValue");
        CompareCharEnum confirmDDiffCmpChar = (CompareCharEnum)((Object)params.get("confirmDDiffCmpChar"));
        BigDecimal confirmDDiffCmpValue = (BigDecimal)params.get("confirmDDiffCmpValue");
        autoCheckSchmInfo.setIsGetCheckData(isGetCheckData);
        autoCheckSchmInfo.setIsConfirm(isConfirm);
        autoCheckSchmInfo.setIsCoverGetChkData(isCoverGetChkData);
        autoCheckSchmInfo.setConfirmSDiffCmpChar(confirmSDiffCmpChar);
        autoCheckSchmInfo.setConfirmSDffCmpValue(confirmSDffCmpValue);
        autoCheckSchmInfo.setConfirmDDiffCmpChar(confirmDDiffCmpChar);
        autoCheckSchmInfo.setConfirmDDiffCmpValue(confirmDDiffCmpValue);
        boolean isDiffHandle = (Boolean)params.get("isDiffHandle");
        boolean isAudit = (Boolean)params.get("isAudit");
        boolean isCreateElim = (Boolean)params.get("isCreateElim");
        DiffModeEnum singleDiffMode = (DiffModeEnum)params.get("singleDiffMode");
        DiffModeEnum doubleDiffMode = (DiffModeEnum)params.get("doubleDiffMode");
        CompareCharEnum auditSDiffCmpChar = (CompareCharEnum)((Object)params.get("auditSDiffCmpChar"));
        BigDecimal auditSDiffCmpValue = (BigDecimal)params.get("auditSDiffCmpValue");
        CompareCharEnum auditDDiffCmpChar = (CompareCharEnum)((Object)params.get("auditDDiffCmpChar"));
        BigDecimal auditDDiffCmpValue = (BigDecimal)params.get("auditDDiffCmpValue");
        boolean isLoanUnevenGenerate = (Boolean)params.get("isLoanUnevenGenerate");
        autoCheckSchmInfo.setIsDiffHandle(isDiffHandle);
        autoCheckSchmInfo.setIsAudit(isAudit);
        autoCheckSchmInfo.setIsCreateElim(isCreateElim);
        autoCheckSchmInfo.setSingleDiffMode(singleDiffMode);
        autoCheckSchmInfo.setDoubleDiffMode(doubleDiffMode);
        autoCheckSchmInfo.setAuditSDiffCmpChar(auditSDiffCmpChar);
        autoCheckSchmInfo.setAuditSDiffCmpValue(auditSDiffCmpValue);
        autoCheckSchmInfo.setAuditDDiffCmpChar(auditDDiffCmpChar);
        autoCheckSchmInfo.setAuditDDiffCmpValue(auditDDiffCmpValue);
        autoCheckSchmInfo.setIsLoanUnevenGenerate(isLoanUnevenGenerate);
        return autoCheckSchmInfo;
    }

    private AutoCheckSchmInfo getSchmInfo(Context ctx, String schmId) throws EASBizException, BOSException {
        AutoCheckSchmInfo autoCheckSchmInfo = AutoCheckSchmFactory.getLocalInstance(ctx).getAutoCheckSchmInfo((IObjectPK)new ObjectUuidPK(schmId), this.getAutoCheckSchmSelector());
        return autoCheckSchmInfo;
    }

    private SelectorItemCollection getAutoCheckSchmSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isFreezed"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("isIncludAdjustPeriod"));
        sic.add(new SelectorItemInfo("jobProcessDef"));
        sic.add(new SelectorItemInfo("isAutoDispatch"));
        sic.add(new SelectorItemInfo("dispatchPeriod"));
        sic.add(new SelectorItemInfo("isGetCheckData"));
        sic.add(new SelectorItemInfo("isCoverGetChkData"));
        sic.add(new SelectorItemInfo("isConfirm"));
        sic.add(new SelectorItemInfo("confirmSDiffCmpChar"));
        sic.add(new SelectorItemInfo("confirmSDffCmpValue"));
        sic.add(new SelectorItemInfo("confirmDDiffCmpChar"));
        sic.add(new SelectorItemInfo("confirmDDiffCmpValue"));
        sic.add(new SelectorItemInfo("companyEntries.id"));
        sic.add(new SelectorItemInfo("companyEntries.company.id"));
        sic.add(new SelectorItemInfo("companyEntries.company.name"));
        sic.add(new SelectorItemInfo("companyEntries.company.number"));
        sic.add(new SelectorItemInfo("isDiffHandle"));
        sic.add(new SelectorItemInfo("isAudit"));
        sic.add(new SelectorItemInfo("isCreateElim"));
        sic.add(new SelectorItemInfo("singleDiffMode"));
        sic.add(new SelectorItemInfo("doubleDiffMode"));
        sic.add(new SelectorItemInfo("auditSDiffCmpChar"));
        sic.add(new SelectorItemInfo("auditSDiffCmpValue"));
        sic.add(new SelectorItemInfo("auditDDiffCmpChar"));
        sic.add(new SelectorItemInfo("auditDDiffCmpValue"));
        sic.add(new SelectorItemInfo("isLoanUnevenGenerate"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("orgTree.name"));
        sic.add(new SelectorItemInfo("orgUnitEntries.id"));
        sic.add(new SelectorItemInfo("orgUnitEntries.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnitEntries.orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnitEntries.orgUnit.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        return sic;
    }

    @Override
    protected Map _abortAutoCheckSchmTask(Context ctx, String schmId) throws BOSException, EASBizException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        AutoCheckSchmTaskCollection tasks = this.getAutoCheckSchmTaskCollection(ctx, schmId);
        if (tasks == null || tasks.isEmpty()) {
            returnMap.put("IsSuccess", "IsNoExceute");
            return returnMap;
        }
        String idString = this.getJobinstidString(tasks);
        String sql = "select fjobinstid,fstate from T_JOB_INST WITH(READPAST) where fjobinstid in" + idString;
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql);
        ArrayList<String> cannotAbortJobList = new ArrayList<String>();
        ArrayList<String> canAbortJobList = new ArrayList<String>();
        ArrayList<String> isNoExceuteList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String fjobinstid = rowSet.getString("fjobinstid");
                String fstate = rowSet.getString("fstate");
                if (JobState.valueOf((String)fstate).equals((Object)JobState.Running)) {
                    cannotAbortJobList.add(fjobinstid);
                    continue;
                }
                if (JobState.valueOf((String)fstate).equals((Object)JobState.Complete) || JobState.valueOf((String)fstate).equals((Object)JobState.Failed)) {
                    isNoExceuteList.add(fjobinstid);
                    continue;
                }
                canAbortJobList.add(fjobinstid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (canAbortJobList.size() > 0) {
            String[] strings = new String[canAbortJobList.size()];
            JobServiceFactory.getLocalInstance((Context)ctx).abort(canAbortJobList.toArray(strings));
            this.removeJobCatch(ctx, strings);
        }
        returnMap.put("cannotAbortJobList", cannotAbortJobList);
        returnMap.put("canAbortJobList", canAbortJobList);
        if (cannotAbortJobList.size() > 0) {
            returnMap.put("IsSuccess", "false");
        } else if (isNoExceuteList.size() > 0) {
            returnMap.put("IsSuccess", "IsNoExceute");
        } else {
            returnMap.put("IsSuccess", "true");
        }
        return returnMap;
    }

    private void removeJobCatch(Context ctx, String[] jobIds) throws BOSException, EASBizException {
        IAutoCheckTaskCatch AutoCheckTaskCatch = AutoCheckTaskCatchImpl.getAutoCheckTaskCatchIntf(ctx);
        Map catchMap = AutoCheckTaskCatch.getCatch();
        if (catchMap != null && !catchMap.isEmpty()) {
            HashMap jobidCatchs = new HashMap();
            for (Object catchKey : catchMap.keySet()) {
                jobidCatchs.put(catchMap.get(catchKey), catchKey);
            }
            for (String jobId : jobIds) {
                Object catchKey = jobidCatchs.get(jobId);
                if (catchKey == null) continue;
                AutoCheckTaskCatch.remove((String)catchKey);
            }
        }
    }

    private String getJobinstidString(AutoCheckSchmTaskCollection tasks) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < tasks.size(); ++i) {
            sb.append("'").append(tasks.get(i).getJobinstid()).append("',");
        }
        if (tasks.size() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        sb.append(")");
        return sb.toString();
    }

    private AutoCheckSchmTaskCollection getAutoCheckSchmTaskCollection(Context ctx, String schmId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("jobinstid"));
        sic.add(new SelectorItemInfo("companyId"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("schmId", (Object)schmId));
        filter.getFilterItems().add(new FilterItemInfo("isUsage", (Object)Boolean.TRUE));
        view.setFilter(filter);
        AutoCheckSchmTaskCollection coll = AutoCheckSchmTaskFactory.getLocalInstance(ctx).getAutoCheckSchmTaskCollection(view);
        return coll;
    }

    @Override
    protected boolean _isRunningAutoCheckSchm(Context ctx, String schmId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 fid from T_CSL_AutoCheckSchmTask task \n");
        sql.append("inner join T_JOB_INST job on task.FJobinstid=job.fjobinstid \n");
        sql.append("where task.FSchmId = ? and task.fisusage=1 and job.fstate in('");
        sql.append(JobState.Created).append("','").append(JobState.ReScheduled);
        sql.append("','").append(JobState.Running).append("')");
        Object[] params = new Object[]{schmId};
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params);
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    @Override
    protected boolean _repairTransationStatus(Context ctx, String schmId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT a.fjobinstid AS fjobinstid \n");
        sql.append(" FROM t_job_inst a \n");
        sql.append(" WHERE a.fjobinstid in ( \n");
        sql.append(" SELECT b.fjobinstid AS fjobinstid \n");
        sql.append(" FROM T_CSL_AutoCheckSchmTask b \n");
        sql.append(" WHERE b.FSchmId = ?) \n");
        sql.append(" AND a.fstate = ? \n");
        Object[] params = new Object[]{schmId, JobState.Running.toString()};
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params);
        StringBuffer jobinstids = new StringBuffer();
        try {
            while (rowSet.next()) {
                String jobinstid = rowSet.getString("fjobinstid");
                jobinstids.append("'").append(jobinstid).append("'").append(",");
            }
            if (jobinstids.length() > 0) {
                jobinstids = jobinstids.deleteCharAt(jobinstids.length() - 1);
                sql = new StringBuffer();
                sql.append(" UPDATE t_job_inst SET fpriorstate = ?,fstate = ? ");
                sql.append(" WHERE fjobinstid IN (" + jobinstids + ") ");
                params = new Object[]{JobState.Running.toString(), JobState.Failed.toString()};
                DbUtil.execute(ctx, sql.toString(), params);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            logger.error((Object)"_transationStatusRepair: ", (Throwable)e);
            return false;
        }
    }

    @Override
    protected void _enable(Context ctx, String id, boolean enable) throws BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append("Update T_Csl_AutoCheckSchm set FIsFreezed= ?", enable ? 0 : 1);
        sql.append(" where FID =? ", id);
        DbUtil.execute(ctx, sql.toString(), sql.getParams());
    }

    @Override
    protected void _dispatchAutoCheckSchm(Context ctx, String schmId) throws BOSException, EASBizException {
        this.executeAutoCheckSchm(ctx, schmId, null, null);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("name"));
        sc.add(new SelectorItemInfo("number"));
        sc.add(new SelectorItemInfo("isAutoDispatch"));
        sc.add(new SelectorItemInfo("isFreezed"));
        AutoCheckSchmInfo info = this.getAutoCheckSchmInfo(ctx, pk, sc);
        StringBuffer retValue = new StringBuffer();
        retValue.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ConsolidatedReconciliation", (Locale)ContextUtils.getLocaleFromEnv())).append("-");
        if (info.getNumber() != null) {
            retValue.append(info.getNumber()).append("-");
        }
        if (info.getName() != null) {
            retValue.append(info.getName());
        }
        if (info.isIsFreezed()) {
            retValue.append("-");
            retValue.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"Free", (Locale)ContextUtils.getLocaleFromEnv()));
        }
        if (info.isIsAutoDispatch()) {
            retValue.append("-");
            retValue.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AutomaticScheduling", (Locale)ContextUtils.getLocaleFromEnv()));
        } else {
            retValue.substring(0, retValue.length() - 1);
        }
        return retValue.toString();
    }
}

