/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountAndMapAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountAndMapAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ArrayKeyObj;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillDataCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillDataFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillDataInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageOrgPackInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.DataSourceEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class CheckDataImport
extends AbstractDataTransmission {
    private HashMap userPermissionOrgsCache = null;
    private static final String res = "com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource";
    private CheckageCompanyCollection checkageCompanyCollection = null;
    private Map<String, Boolean> accPeriodsMap = null;
    private Map<String, Integer> keyMap = null;
    private Map<String, Map<String, String>> checkBillDataMap = null;
    private Map<String, Map<String, String>> confirmCheckDataMap = null;
    private Map<String, String> checkAccountMap = null;
    private Map<String, String> accountMap = null;
    private int index = 5;
    private Map<String, CheckageBillDataCollection> dataMap = null;
    private String accountMapId = null;
    boolean isImportRpt = false;
    public Map<String, DupCheckageBillData> importRptKeyMap = null;

    public CheckDataImport(boolean isImportRpt) {
        this.isImportRpt = isImportRpt;
    }

    public CheckDataImport() {
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CheckageBillDataFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        String compnayId;
        CheckageBillDataInfo checkageBillData = (CheckageBillDataInfo)coreBaseInfo;
        if (this.dataMap == null) {
            this.dataMap = new HashMap<String, CheckageBillDataCollection>();
        }
        if (this.dataMap.containsKey(compnayId = checkageBillData.getCompany().getId().toString())) {
            CheckageBillDataCollection checkageBillDatas = this.dataMap.get(compnayId);
            checkageBillDatas.add(checkageBillData);
        } else {
            CheckageBillDataCollection checkageBillDatas = new CheckageBillDataCollection();
            checkageBillDatas.add(checkageBillData);
            this.dataMap.put(compnayId, checkageBillDatas);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        CheckageBillDataInfo checkageBillData;
        block59: {
            String key;
            String remarks;
            checkageBillData = new CheckageBillDataInfo();
            String year = this.fecthData(hsData, "FYear");
            if (StringUtil.isEmptyString((String)year)) {
                throw new TaskExternalException(ResourceBase.getString((String)res, (String)"218_yearIsNull", (Locale)ctx.getOriginLocale()));
            }
            if (!this.isYear(year)) {
                throw new TaskExternalException(ResourceBase.getString((String)res, (String)"219_yearError", (Locale)ctx.getOriginLocale()));
            }
            String period = this.fecthData(hsData, "FPeriod");
            if (StringUtil.isEmptyString((String)period)) {
                throw new TaskExternalException(ResourceBase.getString((String)res, (String)"220_periodIsNull", (Locale)ctx.getOriginLocale()));
            }
            if (!this.isPeriod(period)) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"221_periodError", (Locale)ctx.getOriginLocale()) : "221_periodError");
            }
            String companyNumber = this.fecthData(hsData, "FCompanyNumber");
            if (StringUtil.isEmptyString((String)companyNumber)) {
                throw new TaskExternalException(ResourceBase.getString((String)res, (String)"222_ownerComNumNull", (Locale)ctx.getOriginLocale()));
            }
            CheckageCompanyInfo checkageCompanyInfo = this.getCheckageCompany(ctx, companyNumber = companyNumber.replaceAll(" ", ""));
            if (checkageCompanyInfo == null) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"223_ownerComIsNotCheckCom", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyNumber}) : "223_ownerComIsNotCheckCom");
            }
            CompanyOrgUnitInfo company = checkageCompanyInfo.getCompany();
            String companyId = company.getId().toString();
            if (!this.checkageCompanyIsFreeze(checkageCompanyInfo, year, period)) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"224_ownerComIsFreeze", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyNumber}) : "224_ownerComIsFreeze");
            }
            String targetCompanyNumber = this.fecthData(hsData, "FTargetCompanyNumber");
            if (StringUtil.isEmptyString((String)targetCompanyNumber)) {
                throw new TaskExternalException(ResourceBase.getString((String)res, (String)"227_tarComNumNull", (Locale)ctx.getOriginLocale()));
            }
            CheckageCompanyInfo checkageTarCompanyInfo = this.getCheckageCompany(ctx, targetCompanyNumber = targetCompanyNumber.replaceAll(" ", ""));
            if (checkageTarCompanyInfo == null) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"228_tarComIsNotCheckCom", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{targetCompanyNumber}) : "228_tarComIsNotCheckCom");
            }
            CompanyOrgUnitInfo tarCompany = checkageTarCompanyInfo.getCompany();
            if (!this.checkageCompanyIsFreeze(checkageTarCompanyInfo, year, period)) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"229_tarComIsFreeze", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{targetCompanyNumber}) : "229_tarComIsFreeze");
            }
            String itemTypeStr = this.fecthData(hsData, "FItemType");
            if (StringUtil.isEmptyString((String)itemTypeStr)) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"231_ItemTypeIsNull", (Locale)ctx.getOriginLocale()) : "231_ItemTypeIsNull");
            }
            ItemTypeEnum itemType = this.getItemType(itemTypeStr = itemTypeStr.replaceAll(" ", ""));
            if (itemType == null) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"232_itemTypeIsNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{itemTypeStr}) : "232_itemTypeIsNotExist_" + itemTypeStr);
            }
            String itemNumber = this.fecthData(hsData, "FItemNumber");
            if (StringUtil.isEmptyString((String)itemNumber)) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"233_itemNumberIsNull", (Locale)ctx.getOriginLocale()) : "233_itemNumberIsNull");
            }
            itemNumber = itemNumber.replaceAll(" ", "");
            String dataElementNumber = this.fecthData(hsData, "FDataElementNumber");
            if (StringUtil.isEmptyString((String)dataElementNumber)) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"235_dataElementIsNull", (Locale)ctx.getOriginLocale()) : "235_dataElementIsNull");
            }
            dataElementNumber = dataElementNumber.replaceAll(" ", "");
            AccountViewInfo account = null;
            BalTypeEnum balType = null;
            int dataElement = 0;
            RPTItemInfo rptItem = null;
            String itemName = null;
            if (itemType.getValue() == 0) {
                String accountTableId = company.getAccountTable().getId().toString();
                try {
                    if (!AccountViewFactory.getLocalInstance((Context)ctx).exists("where accountTableID ='" + accountTableId + "' and companyID = '" + companyId + "' and number ='" + itemNumber + "'")) {
                        throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"263_accountIsNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyNumber, itemNumber}) : "263_accountIsNotExist");
                    }
                    account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo("select id,number,name where accountTableID ='" + accountTableId + "' and companyID = '" + companyId + "' and number ='" + itemNumber + "'");
                    itemName = account.getName();
                    balType = BalTypeEnum.getEnum(dataElementNumber);
                    if (balType == null) {
                        throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"236_dataElementIsNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{dataElementNumber}) : "236_dataElementIsNotExist_" + dataElementNumber);
                    }
                    dataElement = balType.getValue();
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
            try {
                rptItem = RPTItemFactory.getLocalInstance((Context)ctx).getRPTItemInfo("select id,number,name where number ='" + itemNumber + "' and isFreezed = 0");
                if (rptItem == null) {
                    throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"234_itemNumberIsNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{itemNumber}) : "234_itemNumberIsNotExist_" + itemNumber);
                }
                itemName = rptItem.getName();
            }
            catch (Exception e) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"234_itemNumberIsNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{itemNumber}) : "234_itemNumberIsNotExist_" + itemNumber);
            }
            try {
                DataElementInfo dataElementInfo = DataElementProvider.getDataElementInfo((Context)ctx, (String)dataElementNumber);
                if (!this.isImportRpt) {
                    if (dataElementInfo == null || !dataElementInfo.isIsUsedElim()) {
                        throw new TaskExternalException(ResourceBase.getString((String)res, (String)"236_dataElementIsNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{dataElementNumber}));
                    }
                } else {
                    if (dataElementInfo == null) {
                        throw new TaskExternalException("236_dataElementIsNotExist_" + dataElementNumber);
                    }
                    if (!dataElementInfo.isIsUsedElim()) {
                        throw new TaskExternalException("isNotUsedElim");
                    }
                }
                dataElement = dataElementInfo.getInterSeq();
            }
            catch (Exception e) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"236_dataElementIsNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{dataElementNumber}) : "236_dataElementIsNotExist_" + dataElementNumber);
            }
            if (!this.isExistInCheckageAccount(ctx, company, itemType, itemNumber, dataElement)) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"260_existInCheckageAccount", (Locale)ctx.getOriginLocale()) : "260_existInCheckageAccount");
            }
            String currencyNumber = this.fecthData(hsData, "FCurrencyNumber");
            if (StringUtil.isEmptyString((String)currencyNumber)) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"237_currencyNumberIsNull", (Locale)ctx.getOriginLocale()) : "237_currencyNumberIsNull");
            }
            currencyNumber = currencyNumber.replaceAll(" ", "");
            CurrencyInfo currency = null;
            try {
                CurrencyCollection currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select id,number where number = '" + currencyNumber + "'");
                if (currencyColl == null || currencyColl.size() == 0) {
                    throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"238_currencyNumberIsNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{currencyNumber}) : "238_currencyNumberIsNotExist_" + currencyNumber);
                }
                currency = currencyColl.get(0);
            }
            catch (BOSException e) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"238_currencyNumberIsNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{currencyNumber}) : "238_currencyNumberIsNotExist_" + currencyNumber);
            }
            String debit = this.fecthData(hsData, "FDebit");
            String credit = this.fecthData(hsData, "FCredit");
            if (StringUtil.isEmptyString((String)debit) && StringUtil.isEmptyString((String)credit)) {
                throw new TaskExternalException(ResourceBase.getString((String)res, (String)"239_fillOneAtLeast", (Locale)ctx.getOriginLocale()));
            }
            if (!StringUtil.isEmptyString((String)debit) && !StringUtil.isEmptyString((String)credit)) {
                throw new TaskExternalException(ResourceBase.getString((String)res, (String)"240_fillOneOnly", (Locale)ctx.getOriginLocale()));
            }
            if (!StringUtil.isEmptyString((String)debit) && !this.isDigit(debit)) {
                throw new TaskExternalException(ResourceBase.getString((String)res, (String)"241_debitIsNotDigit", (Locale)ctx.getOriginLocale()));
            }
            if (!StringUtil.isEmptyString((String)credit) && !this.isDigit(credit)) {
                throw new TaskExternalException(ResourceBase.getString((String)res, (String)"242_creditIsNotDigit", (Locale)ctx.getOriginLocale()));
            }
            if (!StringUtil.isEmptyString((String)debit)) {
                this.digitOver(ctx, debit, true);
            }
            if (!StringUtil.isEmptyString((String)credit)) {
                this.digitOver(ctx, credit, false);
            }
            BigDecimal debitbd = null;
            if (!StringUtil.isEmptyString((String)debit)) {
                debitbd = new BigDecimal(debit);
            }
            BigDecimal creditbd = null;
            if (!StringUtil.isEmptyString((String)credit)) {
                creditbd = new BigDecimal(credit);
            }
            if (!StringUtil.isEmptyString((String)(remarks = this.fecthData(hsData, "FRemarks"))) && remarks.length() > 2000) {
                throw new TaskExternalException(ResourceBase.getString((String)res, (String)"277_remarkTooLong", (Locale)ctx.getOriginLocale()));
            }
            checkageBillData.setYear(Integer.valueOf(year));
            checkageBillData.setPeriod(Integer.valueOf(period));
            checkageBillData.setCompany(company);
            checkageBillData.setTargetCompany(tarCompany);
            checkageBillData.setCurrency(currency);
            checkageBillData.setAccount(account);
            checkageBillData.setBalType(balType);
            checkageBillData.setItemType(itemType);
            checkageBillData.setItemNumber(itemNumber);
            checkageBillData.setItemName(itemName);
            checkageBillData.setDataElement(dataElement);
            checkageBillData.setDebit(debitbd);
            checkageBillData.setCredit(creditbd);
            checkageBillData.setConfirmDebit(debitbd);
            checkageBillData.setConfirmCredit(creditbd);
            checkageBillData.setAuditDebit(debitbd);
            checkageBillData.setAuditCredit(creditbd);
            checkageBillData.setDataSource(DataSourceEnum.fileImport);
            checkageBillData.setCreateCompany(company);
            if (!StringUtil.isEmptyString((String)remarks)) {
                checkageBillData.setRemarks(remarks);
            }
            if (this.keyMap == null) {
                this.keyMap = new HashMap<String, Integer>();
                if (this.isImportRpt) {
                    this.importRptKeyMap = new HashMap<String, DupCheckageBillData>();
                }
            }
            if (!this.keyMap.containsKey(key = this.getDupKey(checkageBillData))) {
                this.keyMap.put(key, this.index);
                if (this.isImportRpt) {
                    DupCheckageBillData data = new DupCheckageBillData();
                    data.setTemplateName(this.fecthData(hsData, "templateName"));
                    data.setTemplateNumber(this.fecthData(hsData, "templateNumber"));
                    data.setSheetName(this.fecthData(hsData, "sheetName"));
                    data.setRowNum(this.fecthData(hsData, "rowNum"));
                    data.setRptCompanyNumber(this.fecthData(hsData, "rptCompanyNumber"));
                    data.setRptCompanyName(this.fecthData(hsData, "rptCompanyName"));
                    this.importRptKeyMap.put(key, data);
                }
            } else {
                int seq = this.keyMap.get(key);
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"247_dataDup", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{seq}) : "247_dataDup_" + key);
            }
            if (!this.isExistAccountMap(ctx, company, tarCompany, itemType, itemNumber, dataElement)) {
                throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"261_existAccountMap", (Locale)ctx.getOriginLocale()) : "261_existAccountMap");
            }
            if (!this.isAcountMapDispense(ctx, checkageCompanyInfo, checkageTarCompanyInfo)) {
                throw new TaskExternalException(ResourceBase.getString((String)res, (String)"564_acountMapDispense", (Locale)ctx.getOriginLocale()));
            }
            String checkDataId = this.getCheckBillDataId(ctx, checkageBillData);
            if (!this.isSltImportUpdate()) {
                if (checkDataId != null) {
                    throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"248_checkDataExist", (Locale)ctx.getOriginLocale()) : "248_checkDataExist");
                }
                String headNumber = this.isExistConfirmCheckData(ctx, checkageBillData);
                if (headNumber != null) {
                    throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"249_confirmCheckData", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{headNumber}) : "249_confirmCheckData_" + headNumber);
                }
            } else {
                try {
                    String headNumber = this.isExistConfirmCheckData(ctx, checkageBillData);
                    if (headNumber == null) {
                        if (checkDataId != null) {
                            CheckageBillDataFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(checkDataId));
                        }
                        break block59;
                    }
                    throw new TaskExternalException(!this.isImportRpt ? ResourceBase.getString((String)res, (String)"249_confirmCheckData", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{headNumber}) : "249_confirmCheckData_" + headNumber);
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        }
        ++this.index;
        return checkageBillData;
    }

    private boolean isAcountMapDispense(Context ctx, CheckageCompanyInfo checkageCompanyInfo, CheckageCompanyInfo checkageTarCompanyInfo) throws TaskExternalException {
        if (StringUtil.isEmptyString((String)this.accountMapId)) {
            return false;
        }
        try {
            String chkComId = checkageCompanyInfo.getId().toString();
            String chkTarComId = checkageTarCompanyInfo.getId().toString();
            if (AccountMapDispenseFactory.getLocalInstance(ctx).exists("select id where accountMap = '" + this.accountMapId + "' and checkageCompany = '" + chkComId + "'") && AccountMapDispenseFactory.getLocalInstance(ctx).exists("select id where accountMap = '" + this.accountMapId + "' and checkageCompany = '" + chkTarComId + "'")) {
                return true;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private boolean isExistAccountMap(Context ctx, CompanyOrgUnitInfo company, CompanyOrgUnitInfo tarComapny, ItemTypeEnum itemTypeEnum, String itemNumber, int dataElement) throws TaskExternalException {
        this.getAccountMap(ctx);
        String checkageAccountId = this.getCheckageAccountId(company, itemTypeEnum, itemNumber, dataElement);
        String ourAccountTableid = company.getAccountTable().getId().toString();
        String oppositeAccountTableid = tarComapny.getAccountTable().getId().toString();
        int itemType = itemTypeEnum.getValue();
        String key = itemType + checkageAccountId;
        if (itemType == 0) {
            if (this.accountMap.containsKey(key = key + ourAccountTableid)) {
                this.accountMapId = this.accountMap.get(key);
                return true;
            }
            if (this.accountMap.containsKey(key = key + oppositeAccountTableid)) {
                this.accountMapId = this.accountMap.get(key);
                return true;
            }
            if (ourAccountTableid.equals(oppositeAccountTableid)) {
                if (this.accountMap.containsKey(key = key + ourAccountTableid)) {
                    this.accountMapId = this.accountMap.get(key);
                    return true;
                }
            } else if (!ourAccountTableid.equals(oppositeAccountTableid) && this.accountMap.containsKey(key = key + ourAccountTableid + oppositeAccountTableid)) {
                this.accountMapId = this.accountMap.get(key);
                return true;
            }
        } else if (this.accountMap.containsKey(key)) {
            this.accountMapId = this.accountMap.get(key);
            return true;
        }
        return false;
    }

    private void getAccountMap(Context ctx) throws TaskExternalException {
        if (this.accountMap != null) {
            return;
        }
        this.accountMap = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("itemType"));
        sic.add(new SelectorItemInfo("ourAccountTableid"));
        sic.add(new SelectorItemInfo("oppositeAccountTableid"));
        sic.add(new SelectorItemInfo("account.checkAccount"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isfree", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            AccountMapCollection accountMapCollection = AccountMapFactory.getLocalInstance(ctx).getAccountMapCollection(view);
            if (accountMapCollection != null && !accountMapCollection.isEmpty()) {
                Iterator it = accountMapCollection.iterator();
                while (it.hasNext()) {
                    AccountMapInfo accountMapInfo = (AccountMapInfo)it.next();
                    String accountMapId = accountMapInfo.getId().toString();
                    int itemType = accountMapInfo.getItemType().getValue();
                    String ourAccountTableid = accountMapInfo.getOurAccountTableid();
                    String oppositeAccountTableid = accountMapInfo.getOppositeAccountTableid();
                    AccountAndMapAccountCollection col = accountMapInfo.getAccount();
                    Iterator itm = col.iterator();
                    while (itm.hasNext()) {
                        AccountAndMapAccountInfo info = (AccountAndMapAccountInfo)itm.next();
                        String checkageAccountId = info.getCheckAccount().getId().toString();
                        String key = itemType + checkageAccountId;
                        if (itemType == 0) {
                            if (ourAccountTableid != null && oppositeAccountTableid != null && !ourAccountTableid.equals(oppositeAccountTableid)) {
                                key = key + ourAccountTableid + oppositeAccountTableid;
                            } else if (ourAccountTableid != null && oppositeAccountTableid != null && ourAccountTableid.equals(oppositeAccountTableid)) {
                                key = key + ourAccountTableid;
                            } else if (ourAccountTableid != null && oppositeAccountTableid == null) {
                                key = key + ourAccountTableid;
                            } else if (ourAccountTableid == null && oppositeAccountTableid != null) {
                                key = key + oppositeAccountTableid;
                            }
                        }
                        this.accountMap.put(key, accountMapId);
                    }
                }
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean isExistInCheckageAccount(Context ctx, CompanyOrgUnitInfo company, ItemTypeEnum itemType, String itemNumber, int dataElement) throws TaskExternalException {
        this.getCheckageAccount(ctx);
        String key = itemType.getValue() + itemNumber + dataElement;
        if (itemType.getValue() == 0) {
            String accountTableId = company.getAccountTable().getId().toString();
            key = key + accountTableId;
        }
        return this.checkAccountMap.containsKey(key);
    }

    private String getCheckageAccountId(CompanyOrgUnitInfo company, ItemTypeEnum itemType, String itemNumber, int dataElement) {
        String key = itemType.getValue() + itemNumber + dataElement;
        if (itemType.getValue() == 0) {
            String accountTableId = company.getAccountTable().getId().toString();
            key = key + accountTableId;
        }
        if (this.checkAccountMap.containsKey(key)) {
            return this.checkAccountMap.get(key);
        }
        return null;
    }

    private void getCheckageAccount(Context ctx) throws TaskExternalException {
        if (this.checkAccountMap != null) {
            return;
        }
        this.checkAccountMap = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("itemType"));
        sic.add(new SelectorItemInfo("accountTableid"));
        sic.add(new SelectorItemInfo("itemNumber"));
        sic.add(new SelectorItemInfo("dataElement"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isfree", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        try {
            CheckageAccountCollection checkageAccounts = CheckageAccountFactory.getLocalInstance(ctx).getCheckageAccountCollection(view);
            if (checkageAccounts != null && !checkageAccounts.isEmpty()) {
                Iterator it = checkageAccounts.iterator();
                while (it.hasNext()) {
                    CheckageAccountInfo checkageAccount = (CheckageAccountInfo)it.next();
                    String checkageAccountId = checkageAccount.getId().toString();
                    int itemType = checkageAccount.getItemType().getValue();
                    String itemNumber = checkageAccount.getItemNumber();
                    int dataElement = checkageAccount.getDataElement();
                    String key = itemType + itemNumber + dataElement;
                    if (checkageAccount.getAccountTableid() != null) {
                        String accountTableid = checkageAccount.getAccountTableid().toString();
                        key = key + accountTableid;
                    }
                    this.checkAccountMap.put(key, checkageAccountId);
                }
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, String> getCheckBillData(Context ctx, CheckageBillDataInfo checkageBillData) throws TaskExternalException {
        String commonKey = this.getCommonKey(checkageBillData);
        if (this.checkBillDataMap != null && this.checkBillDataMap.containsKey(commonKey)) {
            return this.checkBillDataMap.get(commonKey);
        }
        if (this.checkBillDataMap == null) {
            this.checkBillDataMap = new HashMap<String, Map<String, String>>();
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" Select Fid id,FYear year,FPeriod period,FCompanyId companyId,  \n");
        sql.append(" FTargetCompanyId targetCompanyId, FCurrencyId currencyId, FItemType itemType, \n");
        sql.append(" FItemNumber itemNumber, FDataElement dataElement \n");
        sql.append(" From T_CSL_CheckageBillData \n");
        sql.append(" Where FYear = ? And FPeriod = ? And FCurrencyId = ? \n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(checkageBillData.getYear());
        params.add(checkageBillData.getPeriod());
        params.add(checkageBillData.getCurrency().getId().toString());
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            HashMap<String, String> map = new HashMap<String, String>();
            while (rowSet.next()) {
                String checkDataId = rowSet.getString("id");
                String companyId = rowSet.getString("companyId");
                String targetCompanyId = rowSet.getString("targetCompanyId");
                String year = rowSet.getString("year");
                String period = rowSet.getString("period");
                String currencyId = rowSet.getString("currencyId");
                String itemType = rowSet.getString("itemType");
                String itemNumber = rowSet.getString("itemNumber");
                String dataElement = rowSet.getString("dataElement");
                String key = companyId + targetCompanyId + year + period + currencyId + itemType + itemNumber + dataElement;
                map.put(key, checkDataId);
            }
            this.checkBillDataMap.put(commonKey, map);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return this.checkBillDataMap.get(commonKey);
    }

    private String getCommonKey(CheckageBillDataInfo checkageBillData) {
        int itemType = checkageBillData.getItemType().getValue();
        int year = checkageBillData.getYear();
        int period = checkageBillData.getPeriod();
        String currencyId = checkageBillData.getCurrency().getId().toString();
        String key = itemType + year + period + currencyId;
        return key;
    }

    private String getCheckDataKey(CheckageBillDataInfo checkageBillData) {
        String companyId = checkageBillData.getCompany().getId().toString();
        String tarCompanyId = checkageBillData.getTargetCompany().getId().toString();
        String year = String.valueOf(checkageBillData.getYear());
        String period = String.valueOf(checkageBillData.getPeriod());
        String currencyId = checkageBillData.getCurrency().getId().toString();
        int itemType = checkageBillData.getItemType().getValue();
        String itemNumber = checkageBillData.getItemNumber();
        int dataElement = checkageBillData.getDataElement();
        String key = companyId + tarCompanyId + year + period + currencyId + itemType + itemNumber + dataElement;
        return key;
    }

    private String getCheckBillDataId(Context ctx, CheckageBillDataInfo checkageBillData) throws TaskExternalException {
        String key;
        Map<String, String> currentMap = this.getCheckBillData(ctx, checkageBillData);
        if (currentMap.containsKey(key = this.getCheckDataKey(checkageBillData))) {
            return currentMap.get(key);
        }
        return null;
    }

    private String isExistConfirmCheckData(Context ctx, CheckageBillDataInfo checkageBillData) throws TaskExternalException {
        String headNumber = null;
        Map<String, String> currentMap = this.getConfirmCheckData(ctx, checkageBillData);
        String companyId = checkageBillData.getCompany().getId().toString();
        String tarCompanyId = checkageBillData.getTargetCompany().getId().toString();
        String checkAccountId = this.getCheckageAccountId(checkageBillData);
        String key = companyId + tarCompanyId + checkAccountId;
        if (currentMap.containsKey(key)) {
            headNumber = currentMap.get(key);
        }
        return headNumber;
    }

    private String getCheckageAccountId(CheckageBillDataInfo checkageBillData) {
        int itemType = checkageBillData.getItemType().getValue();
        String itemNumber = checkageBillData.getItemNumber();
        int dataElement = checkageBillData.getDataElement();
        String key = itemType + itemNumber + dataElement;
        if (itemType == 0) {
            String accountTableId = checkageBillData.getCompany().getAccountTable().getId().toString();
            key = key + accountTableId;
        }
        return this.checkAccountMap.get(key);
    }

    private Map<String, String> getConfirmCheckData(Context ctx, CheckageBillDataInfo checkageBillData) throws TaskExternalException {
        String commonKey = this.getCommonKey(checkageBillData);
        if (this.confirmCheckDataMap != null && this.confirmCheckDataMap.containsKey(commonKey)) {
            return this.confirmCheckDataMap.get(commonKey);
        }
        if (this.confirmCheckDataMap == null) {
            this.confirmCheckDataMap = new HashMap<String, Map<String, String>>();
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" Select distinct cb.FCompanyId companyId, cb.FTargetCompanyId tarCompanyId, accma.FCheckAccountId chkAccountId, cbh.FNumber number  \n");
        sql.append(" From T_Csl_CheckageBill cb \n");
        sql.append(" Inner Join T_Csl_CheckageBillCompany cbc On cb.FBillCompanyId = cbc.Fid \n");
        sql.append(" Inner Join T_Csl_CheckageBillHead cbh On cb.FBillHeadId = cbh.Fid \n");
        sql.append(" Inner Join T_Csl_AccountMap accm On cbh.FAccountMapId = accm.FId \n");
        sql.append(" Inner Join T_Csl_AccountAndMapAccount accma On accma.FAccountMapId = accm.FId \n");
        sql.append(" Where cbc.FConfirmStatus = ? And cb.FYear = ? And cb.FPeriod = ? And cb.FCurrencyId = ? and accm.FIsFree = ? \n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(1);
        params.add(checkageBillData.getYear());
        params.add(checkageBillData.getPeriod());
        params.add(checkageBillData.getCurrency().getId().toString());
        params.add(0);
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            HashMap<String, String> map = new HashMap<String, String>();
            while (rowSet.next()) {
                String companyId = rowSet.getString("companyId");
                String tarCompanyId = rowSet.getString("tarCompanyId");
                String chkAcoountId = rowSet.getString("chkAccountId");
                String number = rowSet.getString("number");
                String key = companyId + tarCompanyId + chkAcoountId;
                map.put(key, number);
            }
            this.confirmCheckDataMap.put(commonKey, map);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return this.confirmCheckDataMap.get(commonKey);
    }

    private String getDupKey(CheckageBillDataInfo checkageBillData) {
        String companyNumber = checkageBillData.getCompany().getNumber();
        String tarCompanyNumber = checkageBillData.getTargetCompany().getNumber();
        String year = String.valueOf(checkageBillData.getYear());
        String period = String.valueOf(checkageBillData.getPeriod());
        String currencyNumber = checkageBillData.getCurrency().getNumber();
        String itemType = checkageBillData.getItemType().getName();
        String itemNumber = checkageBillData.getItemNumber();
        int dataElement = checkageBillData.getDataElement();
        String key = companyNumber + tarCompanyNumber + year + period + currencyNumber + itemType + itemNumber + dataElement;
        return key;
    }

    private void digitOver(Context ctx, String digit, boolean isDebit) throws TaskExternalException {
        String msg = null;
        if (digit.contains(".")) {
            String[] digits = digit.split("\\.");
            String first = digits[0];
            String second = digits[1];
            if (first.length() > 12) {
                msg = isDebit ? ResourceBase.getString((String)res, (String)"243_debitIntegerOver", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)res, (String)"244_creditIntegerOver", (Locale)ctx.getOriginLocale());
                throw new TaskExternalException(msg);
            }
            if (second.length() > 6) {
                msg = isDebit ? ResourceBase.getString((String)res, (String)"245_debitBigDecimalOver", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)res, (String)"246_creditBigDecimalOver", (Locale)ctx.getOriginLocale());
                throw new TaskExternalException(msg);
            }
        } else {
            msg = isDebit ? ResourceBase.getString((String)res, (String)"243_debitIntegerOver", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)res, (String)"244_creditIntegerOver", (Locale)ctx.getOriginLocale());
            if (digit.length() > 12) {
                throw new TaskExternalException(msg);
            }
        }
    }

    private boolean isDigit(String digit) {
        Pattern p = Pattern.compile("-?[0-9]+.?[0-9]*");
        return p.matcher(digit).matches();
    }

    private ItemTypeEnum getItemType(String itemType) {
        if ("001".equals(itemType)) {
            return ItemTypeEnum.account;
        }
        if ("002".equals(itemType)) {
            return ItemTypeEnum.rptItem;
        }
        return null;
    }

    private boolean hasAccPeriods(Context ctx, String companyId, String year, String period) throws TaskExternalException {
        if (this.accPeriodsMap != null && this.accPeriodsMap.containsKey(companyId)) {
            return this.accPeriodsMap.get(companyId);
        }
        this.accPeriodsMap = new HashMap<String, Boolean>();
        StringBuffer sql = new StringBuffer();
        sql.append("Select period.Fid id, period.FPeriodYear year, period.FPeriodNumber period, company.Fid companyId \n");
        sql.append("From T_bd_Period period \n");
        sql.append("Inner join t_org_company company On company.FAccountPeriodID = period.FTypeID \n");
        sql.append("Where period.FPeriodYear = ? And period.FPeriodNumber = ? And company.Fid = ? ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Integer.valueOf(year));
        params.add(Integer.valueOf(period));
        params.add(companyId);
        try {
            IRowSet iRowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            if (iRowSet.next()) {
                this.accPeriodsMap.put(companyId, true);
                return true;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        this.accPeriodsMap.put(companyId, false);
        return false;
    }

    private boolean checkageCompanyIsFreeze(CheckageCompanyInfo checkageCompanyInfo, String year, String period) {
        if (checkageCompanyInfo.isIsfree()) {
            String yyyyMM;
            int freeTime = checkageCompanyInfo.getFreeTime();
            return freeTime > Integer.valueOf(yyyyMM = RptUtil.getYearPeriod((int)Integer.valueOf(year), (int)Integer.valueOf(period), (int)Integer.valueOf(year), (int)Integer.valueOf(period)));
        }
        return true;
    }

    private CheckageCompanyInfo getCheckageCompany(Context ctx, String companyNumber) throws TaskExternalException {
        this.getCheckageCompanyCollection(ctx);
        if (this.checkageCompanyCollection != null && !this.checkageCompanyCollection.isEmpty()) {
            Iterator it = this.checkageCompanyCollection.iterator();
            while (it.hasNext()) {
                CheckageCompanyInfo checkageCompanyInfo = (CheckageCompanyInfo)it.next();
                String chkComNumber = checkageCompanyInfo.getCompany().getNumber();
                if (!companyNumber.equals(chkComNumber)) continue;
                return checkageCompanyInfo;
            }
        }
        return null;
    }

    private void getCheckageCompanyCollection(Context ctx) throws TaskExternalException {
        if (this.checkageCompanyCollection != null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("isfree"));
        sic.add(new SelectorItemInfo("freeTime"));
        try {
            this.checkageCompanyCollection = CheckageCompanyFactory.getLocalInstance(ctx).getCheckageCompanyCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean hasCompanyPermission(Context ctx, String companyNumber) throws TaskExternalException {
        this.initCompanyPermision(ctx);
        return this.userPermissionOrgsCache.containsKey(companyNumber);
    }

    private void initCompanyPermision(Context ctx) throws TaskExternalException {
        if (this.userPermissionOrgsCache != null) {
            return;
        }
        this.userPermissionOrgsCache = new HashMap();
        FullOrgUnitCollection fullOrgs = null;
        try {
            fullOrgs = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString()), OrgType.Company, null, "csl_checkwork_view");
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (fullOrgs == null || fullOrgs.size() == 0) {
            return;
        }
        int n = fullOrgs.size();
        for (int i = 0; i < n; ++i) {
            this.userPermissionOrgsCache.put(fullOrgs.get(i).getNumber().toUpperCase(), fullOrgs.get(i).getId());
        }
    }

    private boolean isYear(String year) {
        Pattern p = Pattern.compile("^(19|20)[0-9][0-9]$");
        return p.matcher(year).matches();
    }

    private boolean isPeriod(String period) {
        Pattern p = Pattern.compile("^0[1-9]|[1-9]|1[0-3]");
        return p.matcher(period).matches();
    }

    private String fecthData(Hashtable hsData, String key) {
        DataToken dataToken = (DataToken)hsData.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    public void importOnFinished(Context ctx, Map map) throws TaskExternalException {
        if (this.dataMap != null && !this.dataMap.isEmpty()) {
            for (Map.Entry<String, CheckageBillDataCollection> entry : this.dataMap.entrySet()) {
                CheckageBillDataCollection checkageBillDatas = entry.getValue();
                this.insertCheckageBillData(ctx, checkageBillDatas);
            }
        }
    }

    private void insertCheckageBillData(Context ctx, CheckageBillDataCollection checkageBillDatas) throws TaskExternalException {
        if (checkageBillDatas.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            Iterator it = checkageBillDatas.iterator();
            conn = EJBFactory.getQueryConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" Insert into T_Csl_CheckageBillData (FID, FYear, FPeriod, FCurrencyId, FCompanyId, FTargetCompanyId, FAccountId, FBalType, FisIncludeUnPosted, ");
            sql.append(" FDebit, FCredit, FConfirmDebit, FConfirmCredit, FAuditDebit, FAuditCredit, FCreatorId, FCreateTime, FLastUpdateUserId, FLastUpdateTime, ");
            sql.append(" FControlUnitId, FCreateCompanyId, FItemType, FDataElement,FItemNumber,FItemName, FDataSource, FRemarks, FImportReportId, FImportSheetName)");
            sql.append("Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            ps = conn.prepareStatement(sql.toString());
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            Timestamp createtime = CheckDataImport.getTime();
            boolean isInsert = false;
            HashSet<ArrayKeyObj> logParams = new HashSet<ArrayKeyObj>();
            while (it.hasNext()) {
                CheckageBillDataInfo checkageBillDataInfo = (CheckageBillDataInfo)it.next();
                String id = BOSUuid.create((BOSObjectType)checkageBillDataInfo.getBOSType()).toString();
                int year = checkageBillDataInfo.getYear();
                int period = checkageBillDataInfo.getPeriod();
                String currencyId = checkageBillDataInfo.getCurrency().getId().toString();
                String companyId = checkageBillDataInfo.getCompany().getId().toString();
                String tarCompanyId = checkageBillDataInfo.getTargetCompany().getId().toString();
                boolean isIncludeUnPosted = checkageBillDataInfo.isIsIncludeUnPosted();
                int itemType = checkageBillDataInfo.getItemType().getValue();
                String accountId = null;
                if (checkageBillDataInfo.getAccount() != null) {
                    accountId = checkageBillDataInfo.getAccount().getId().toString();
                }
                String itemNumber = checkageBillDataInfo.getItemNumber();
                String itemName = checkageBillDataInfo.getItemName();
                int dataElement = checkageBillDataInfo.getDataElement();
                BigDecimal debit = checkageBillDataInfo.getDebit();
                String createCompanyId = checkageBillDataInfo.getCreateCompany().getId().toString();
                int dataSource = checkageBillDataInfo.getDataSource().getValue();
                BigDecimal credit = checkageBillDataInfo.getCredit();
                BigDecimal confirmDebit = checkageBillDataInfo.getConfirmDebit();
                BigDecimal confirmCredit = checkageBillDataInfo.getConfirmCredit();
                BigDecimal auditDebit = checkageBillDataInfo.getAuditDebit();
                BigDecimal auditCredit = checkageBillDataInfo.getAuditCredit();
                String remarks = checkageBillDataInfo.getRemarks();
                ps.setObject(1, id);
                ps.setObject(2, year);
                ps.setObject(3, period);
                ps.setObject(4, currencyId);
                ps.setObject(5, companyId);
                ps.setObject(6, tarCompanyId);
                ps.setObject(7, accountId);
                ps.setObject(8, dataElement);
                ps.setObject(9, isIncludeUnPosted);
                ps.setObject(10, debit);
                ps.setObject(11, credit);
                ps.setObject(12, confirmDebit);
                ps.setObject(13, confirmCredit);
                ps.setObject(14, auditDebit);
                ps.setObject(15, auditCredit);
                ps.setObject(16, userId);
                ps.setObject(17, createtime);
                ps.setObject(18, userId);
                ps.setObject(19, createtime);
                ps.setObject(20, cuId);
                ps.setObject(21, createCompanyId);
                ps.setObject(22, itemType);
                ps.setObject(23, dataElement);
                ps.setObject(24, itemNumber);
                ps.setObject(25, itemName);
                ps.setObject(26, dataSource);
                ps.setObject(27, remarks);
                ps.setObject(28, checkageBillDataInfo.getImportReportId());
                ps.setObject(29, checkageBillDataInfo.getImportSheetName());
                ps.addBatch();
                ArrayKeyObj logParam = new ArrayKeyObj(new Object[]{year, period, currencyId, companyId, itemType});
                if (!logParams.contains(logParam)) {
                    logParams.add(logParam);
                }
                isInsert = true;
            }
            if (isInsert) {
                ps.executeBatch();
                ps.clearBatch();
            }
            this.writeOrgPackInfo(ctx, logParams);
        }
        catch (SQLException e) {
            try {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
    }

    public void writeOrgPackInfo(Context ctx, Set<ArrayKeyObj> logParams) throws TaskExternalException {
        String tempTable = null;
        try {
            if (!logParams.isEmpty()) {
                tempTable = TempTablePool.getInstance((Context)ctx).createTempTable("create table t_csl_tmp(fyear int,fperiod int,fcurrencyId varchar(44),fcompanyId varchar(44),fitemType int)");
                SQLBuilder sql = new SQLBuilder();
                sql.append(" insert into ").append(tempTable).append("(fyear,fperiod,fcurrencyId,fcompanyId,fitemType) values(?,?,?,?,?)");
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                for (ArrayKeyObj arrayObj : logParams) {
                    params.add(arrayObj.getArrayObj());
                }
                DbUtil.executeBatch(ctx, sql.getSQL(), params);
                Date curdate = new Date();
                String time = CslRptUtil.formatDatetimeForSql((Date)curdate);
                String bosType = new CheckageOrgPackInfo().getBOSType().toString();
                sql.reset();
                sql.append("update T_Csl_CheckageOrgPack set FLastGetDataTime=").append(time);
                sql.append(" where fid in(select pack.fid from T_Csl_CheckageOrgPack pack ");
                sql.append(" inner join ").append(tempTable).append(" tmp on pack.FYear=tmp.fyear and pack.fperiod=tmp.fperiod ");
                sql.append(" and pack.fcurrencyId=tmp.fcurrencyId and pack.fcompanyId=tmp.fcompanyId and pack.fitemType=tmp.fitemType) ");
                DbUtil.execute(ctx, sql.getSQL());
                sql.reset();
                sql.append(" insert into T_Csl_CheckageOrgPack(fid,fyear,fperiod,fcurrencyId,fcompanyId,fitemType,FLastGetDataTime)");
                sql.append("select newbosid('").append(bosType).append("'),tmp.fyear,tmp.fperiod,tmp.fcurrencyId,tmp.fcompanyId,tmp.fitemType,").append(time);
                sql.append(" from ").append(tempTable).append(" tmp ");
                sql.append(" left join T_Csl_CheckageOrgPack pack on pack.FYear=tmp.fyear and pack.fperiod=tmp.fperiod and pack.fcurrencyId=tmp.fcurrencyId");
                sql.append("  and pack.fcompanyId=tmp.fcompanyId and pack.fitemType=tmp.fitemType ");
                sql.append(" where pack.fid is null ");
                DbUtil.execute(ctx, sql.getSQL());
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (!DebugLogger.isDebug && tempTable != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
        }
    }

    private static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public class DupCheckageBillData {
        private String templateName;
        private String templateNumber;
        private String sheetName;
        private String rowNum;
        private String rptCompanyNumber;
        private String rptCompanyName;

        public String getTemplateName() {
            return this.templateName;
        }

        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public String getTemplateNumber() {
            return this.templateNumber;
        }

        public void setTemplateNumber(String templateNumber) {
            this.templateNumber = templateNumber;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public String getRowNum() {
            return this.rowNum;
        }

        public void setRowNum(String rowNum) {
            this.rowNum = rowNum;
        }

        public String getRptCompanyNumber() {
            return this.rptCompanyNumber;
        }

        public void setRptCompanyNumber(String rptCompanyNumber) {
            this.rptCompanyNumber = rptCompanyNumber;
        }

        public String getRptCompanyName() {
            return this.rptCompanyName;
        }

        public void setRptCompanyName(String rptCompanyName) {
            this.rptCompanyName = rptCompanyName;
        }
    }
}

