/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AsstActTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageAccount;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.investworkpaper.util.InvestElimManuScriptUtil;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CheckageAccountImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.CheckageAccountImport");
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Map<String, String> exsitNumberMap = new HashMap<String, String>();
    private Map<String, Integer> exsitNumberIndexMap = new HashMap<String, Integer>();
    private int index = 4;
    private List<String> formulaNames = null;
    private Map<String, AccountTableInfo> accountTableMap = null;
    private Map<String, RPTItemInfo> rptItemMap = new HashMap<String, RPTItemInfo>();
    private Map<String, Set<String>> accountIdMap = new HashMap<String, Set<String>>();
    ICheckageAccount ICheckageAccount = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CheckageAccountFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        CheckageAccountInfo info = (CheckageAccountInfo)coreBaseInfo;
        try {
            boolean isExist;
            if (coreBaseInfo == null) {
                return;
            }
            boolean isAddNew = false;
            CheckageAccountInfo existInfo = null;
            if (coreBaseInfo.getId() == null) {
                isAddNew = true;
            }
            if (!isAddNew) {
                CoreBaseCollection collection = this.getController(ctx).getCollection("where id='" + coreBaseInfo.getId().toString() + "'");
                if (collection != null && !collection.isEmpty()) {
                    existInfo = (CheckageAccountInfo)collection.get(0);
                } else {
                    isAddNew = true;
                }
            }
            if (isExist = this.existSameItemData(ctx, isAddNew, info)) {
                if (isAddNew) {
                    throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "ItemExist", null));
                }
                String updateId = coreBaseInfo.getId().toString();
                if (!StringUtils.equals((String)updateId, (String)((String)info.get("existId")))) {
                    throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "ItemExist", null));
                }
                info.remove("existId");
            }
            this.verify(ctx, existInfo, info);
            if (isAddNew) {
                IObjectPK addnew = this.getController(ctx).addnew(coreBaseInfo);
                if (this.isSltImportUpdate()) {
                    this.exsitNumberMap.put(info.getNumber() + info.getItemType().getValue(), addnew.toString());
                }
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        if (!this.isSltImportUpdate() && info != null) {
            this.exsitNumberMap.put(info.getNumber() + info.getItemType().getValue(), info.getId().toString());
            this.exsitNumberIndexMap.put(info.getNumber() + info.getItemType().getValue(), this.index);
        }
    }

    private boolean existSameItemData(Context ctx, boolean isAddNew, CheckageAccountInfo info) throws TaskExternalException {
        ItemTypeEnum itemType = info.getItemType();
        SQLBuilder sql = new SQLBuilder();
        if (ItemTypeEnum.account == itemType) {
            sql.append("select Fid from T_Csl_CheckageAccount \n");
            sql.append("where FItemType=? \n", itemType.getValue());
            sql.append("and FAccountTableid=? \n", info.getAccountTableid());
            sql.append("and FItemNumber=? \n", info.getItemNumber());
            sql.append("and FBalType=? \n", info.getBalType().getValue());
            sql.append("and FIsFree=0");
        } else {
            sql.append("select Fid from T_Csl_CheckageAccount \n");
            sql.append("where FItemType=? \n", itemType.getValue());
            sql.append("and FItemNumber=? \n", info.getItemNumber());
            sql.append("and FDataElement=? \n", info.getDataElement());
            sql.append("and FIsFree=0");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
            if (rowSet.next()) {
                info.put("existId", rowSet.getString("Fid"));
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"verify_error:", (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private boolean verify(Context ctx, CheckageAccountInfo existInfo, CheckageAccountInfo info) throws TaskExternalException {
        String formulaString = info.getFormula();
        if (!StringUtils.isEmpty((String)formulaString)) {
            try {
                if (this.formulaNames == null) {
                    this.formulaNames = (List)this.getContextParameter("formulaNames");
                }
                formulaString = AccountCheckUtil.replace(formulaString);
                Expression expression = InvestElimManuScriptUtil.checkFormulaFormat(formulaString, this.formulaNames);
                AccountCheckUtil.checkFormula(formulaString);
                AccountCheckUtil.checkFormulaParams(expression);
            }
            catch (CheckFormulaException e1) {
                String exceptionStr = e1.getMessage();
                if (!StringUtils.isEmpty((String)e1.getMessage())) {
                    exceptionStr = MessageFormat.format(exceptionStr, info.getFormula());
                }
                throw new TaskExternalException(exceptionStr);
            }
        }
        if (existInfo != null) {
            String existInfoKey = "";
            String infoKey = "";
            ItemTypeEnum itemType = existInfo.getItemType();
            boolean isFreezedChange = false;
            if (0 == itemType.getValue()) {
                existInfoKey = existInfo.getAccountTableid() + existInfo.getItemNumber() + existInfo.getBalType().getValue();
                infoKey = info.getAccountTableid() + info.getItemNumber() + info.getBalType().getValue();
                isFreezedChange = existInfo.isIsFree() != info.isIsFree();
            } else {
                existInfoKey = existInfo.getItemNumber() + existInfo.getDataElement();
                infoKey = info.getItemNumber() + info.getDataElement();
                boolean bl = isFreezedChange = existInfo.isIsFree() != info.isIsFree();
            }
            if (!existInfoKey.equals(infoKey) || isFreezedChange && info.isIsFree()) {
                this.isExistQuote(ctx, info);
            } else if (!isFreezedChange || !info.isIsFree()) {
                // empty if block
            }
        }
        return true;
    }

    private boolean isExistQuote(Context ctx, CheckageAccountInfo info) throws TaskExternalException {
        ArrayList resultList = this.getResult(ctx, info);
        if (resultList.size() > 1) {
            if (((Boolean)resultList.get(0)).booleanValue() && ((Boolean)resultList.get(1)).booleanValue()) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_refrenceByALL", new Object[]{info.getNumber()}));
            }
            if (((Boolean)resultList.get(0)).booleanValue()) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_refrenceByAccount", new Object[]{info.getNumber()}));
            }
            if (((Boolean)resultList.get(1)).booleanValue()) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_refrenceByRPTItem", new Object[]{info.getNumber()}));
            }
        }
        return false;
    }

    private ArrayList getResult(Context ctx, CheckageAccountInfo info) throws TaskExternalException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(info.getId().toString());
        ArrayList<Boolean> resultList = new ArrayList<Boolean>();
        try {
            Map resultMap;
            ArrayList NoCanDeleteList;
            if (this.ICheckageAccount == null) {
                this.ICheckageAccount = CheckageAccountFactory.getLocalInstance(ctx);
            }
            if ((NoCanDeleteList = (ArrayList)(resultMap = this.ICheckageAccount.removeOfNoQuote(list)).get("noRemoveIDList")).size() > 0) {
                Map checkageAccountMap = (Map)resultMap.get("checkageAccountMap");
                Map accountMapNumberMap = (Map)resultMap.get("accountMapNumberMap");
                Map rptItemMapNumberMap = (Map)resultMap.get("rptItemMapNumberMap");
                boolean isAccountMapQuote = (Boolean)resultMap.get("isAccountMapQuote");
                boolean isRptItemMapQuote = (Boolean)resultMap.get("isRptItemMapQuote");
                resultList.add(isAccountMapQuote);
                resultList.add(isRptItemMapQuote);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return resultList;
    }

    public void importOnFinished(Context ctx, Map map) throws TaskExternalException {
        super.importOnFinished(ctx, map);
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String itemNumber;
        ++this.index;
        String number = this.fecthData(hsData, "FNumber");
        if (StringUtils.isEmpty((String)number)) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_number", null)}));
        }
        if ((number = number.trim()).length() > 80) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_numberTooLong", null));
        }
        String itemTypeNumber = this.fecthData(hsData, "FItemTypeNumber");
        if (StringUtils.isEmpty((String)itemTypeNumber)) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_itemTypeNumber", null)}));
        }
        if (!"001".equals(itemTypeNumber) && !"002".equals(itemTypeNumber)) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_notExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_itemTypeNumber", null)}));
        }
        boolean isAccount = "001".equals(itemTypeNumber);
        int itemType = isAccount ? 0 : 1;
        String key = number + itemType;
        String updateId = null;
        if (!this.isSltImportUpdate()) {
            if (this.exsitNumberMap.containsKey(key)) {
                Integer existIndex = this.exsitNumberIndexMap.get(key);
                if (existIndex != null) {
                    throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_rowDataDup", new Object[]{existIndex}));
                }
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_existNumber", null));
            }
            if (this.exists(ctx, itemTypeNumber, number)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_existNumber", null));
            }
        } else if (!this.exsitNumberMap.containsKey(key)) {
            if (this.exists(ctx, itemTypeNumber, number)) {
                updateId = this.exsitNumberMap.get(key);
            }
        } else {
            updateId = this.exsitNumberMap.get(key);
        }
        if (StringUtils.isEmpty((String)(itemNumber = this.fecthData(hsData, "FItemNumber")))) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_itemNumber", null)}));
        }
        String dataElementNumber = this.fecthData(hsData, "FDataElementNumber");
        if (StringUtils.isEmpty((String)dataElementNumber)) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_dataElementNumber", null)}));
        }
        String accountTableNumber = this.fecthData(hsData, "FAccountTableNumber");
        String asstActType = this.fecthData(hsData, "FasstActType");
        String formula = this.fecthData(hsData, "FFormula");
        String isFreeStr = this.fecthData(hsData, "FIsFree");
        if (!(StringUtils.isEmpty((String)isFreeStr) || "Y".equalsIgnoreCase(isFreeStr) || "N".equalsIgnoreCase(isFreeStr))) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_freeError", null));
        }
        boolean isFree = "Y".equalsIgnoreCase(isFreeStr);
        CheckageAccountInfo checkageAccountInfo = new CheckageAccountInfo();
        if (updateId != null) {
            checkageAccountInfo.setId(BOSUuid.read((String)updateId));
        }
        checkageAccountInfo.setNumber(number);
        if (isAccount) {
            if (StringUtils.isEmpty((String)accountTableNumber)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_accountTableNumber", null)}));
            }
            if (StringUtils.isEmpty((String)asstActType)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_asstActType", null)}));
            }
            if (!(AsstActTypeEnum.companyOrg.getAlias().equals(asstActType) || AsstActTypeEnum.customer.getAlias().equals(asstActType) || AsstActTypeEnum.provider.getAlias().equals(asstActType))) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_notExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_asstActType", null)}));
            }
            if (this.accountTableMap == null) {
                this.accountTableMap = new HashMap<String, AccountTableInfo>();
                try {
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.getSelector().add(new SelectorItemInfo("accountTable.id"));
                    evi.getSelector().add(new SelectorItemInfo("accountTable.name"));
                    evi.getSelector().add(new SelectorItemInfo("accountTable.number"));
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("accountTable", null, CompareType.NOTEQUALS));
                    evi.setFilter(filter);
                    CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
                    if (coll != null && !coll.isEmpty()) {
                        for (int i = 0; i < coll.size(); ++i) {
                            AccountTableInfo accountTable = coll.get(i).getAccountTable();
                            if (accountTable == null) continue;
                            this.accountTableMap.put(accountTable.getNumber(), accountTable);
                        }
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)"getCompanyOrgUnitCollection_error:", (Throwable)e);
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
            checkageAccountInfo.setItemType(ItemTypeEnum.account);
            AccountTableInfo accountTableInfo = this.accountTableMap.get(accountTableNumber);
            if (accountTableInfo == null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_notExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_accountTableNumber", null)}));
            }
            checkageAccountInfo.setAccountTableid(accountTableInfo.getId().toString());
            checkageAccountInfo.setAccountTableNumber(accountTableInfo.getNumber());
            checkageAccountInfo.setAccountTableName(accountTableInfo.getName());
            String accountTableID = accountTableInfo.getId().toString();
            Set<String> IDSet = this.accountIdMap.get(accountTableID);
            if (IDSet == null) {
                IDSet = new HashSet<String>();
                try {
                    HashMap map = (HashMap)CheckageAccountFactory.getLocalInstance(ctx).getHasCAAID(accountTableID);
                    IDSet.addAll((HashSet)map.get("IDSet"));
                    HashSet accountNumberSet = (HashSet)map.get("accountNumberSet");
                    HashSet set = CheckageAccountFactory.getLocalInstance(ctx).getNoHasCAAID(accountTableID, accountNumberSet);
                    IDSet.addAll(set);
                    this.accountIdMap.put(accountTableID, IDSet);
                }
                catch (BOSException e) {
                    logger.error((Object)"queryAccount_error:", (Throwable)e);
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("dc"));
            FilterInfo filterInfoNew = new FilterInfo();
            filterInfoNew.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableID));
            filterInfoNew.getFilterItems().add(new FilterItemInfo("number", (Object)itemNumber));
            if (IDSet != null && IDSet.size() > 0) {
                filterInfoNew.getFilterItems().add(new FilterItemInfo("id", IDSet, CompareType.INCLUDE));
            }
            view.setSelector(sic);
            view.setFilter(filterInfoNew);
            try {
                AccountViewCollection accountViewCollection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
                if (accountViewCollection == null || accountViewCollection.isEmpty()) {
                    throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_notExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_accountViewNumber", null)}));
                }
                AccountViewInfo accountViewInfo = accountViewCollection.get(0);
                checkageAccountInfo.setItemNumber(accountViewInfo.getNumber());
                checkageAccountInfo.setItemName(accountViewInfo.getName());
                checkageAccountInfo.setItemDC(accountViewInfo.getDC());
            }
            catch (BOSException e) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_notExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_accountViewNumber", null)}));
            }
            BalTypeEnum bal = BalTypeEnum.getEnum(dataElementNumber);
            if (bal == null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_notExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_dataElementNumber", null)}));
            }
            checkageAccountInfo.setBalType(bal);
            checkageAccountInfo.setDataElement(bal.getValue());
            if (AsstActTypeEnum.companyOrg.getAlias().equals(asstActType)) {
                checkageAccountInfo.setAsstActTypes(AsstActTypeEnum.companyOrg);
            } else if (AsstActTypeEnum.customer.getAlias().equals(asstActType)) {
                checkageAccountInfo.setAsstActTypes(AsstActTypeEnum.customer);
            } else if (AsstActTypeEnum.provider.getAlias().equals(asstActType)) {
                checkageAccountInfo.setAsstActTypes(AsstActTypeEnum.provider);
            }
        } else {
            checkageAccountInfo.setItemType(ItemTypeEnum.rptItem);
            RPTItemInfo rptItemInfo = this.rptItemMap.get(itemNumber);
            if (rptItemInfo == null) {
                try {
                    RPTItemCollection rptItemCollection = RPTItemFactory.getLocalInstance((Context)ctx).getRPTItemCollection("select id,number,name,dc where number='" + itemNumber + "'");
                    if (rptItemCollection == null || rptItemCollection.isEmpty()) {
                        throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_notExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_itemNumber", null)}));
                    }
                    rptItemInfo = rptItemCollection.get(0);
                    this.rptItemMap.put(itemNumber, rptItemInfo);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_notExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_itemNumber", null)}));
                }
            }
            checkageAccountInfo.setItemNumber(rptItemInfo.getNumber());
            checkageAccountInfo.setItemName(rptItemInfo.getName());
            if (0 == rptItemInfo.getDc().getValue()) {
                checkageAccountInfo.setItemDC(BalanceDirectionEnum.CREDIT);
            } else if (1 == rptItemInfo.getDc().getValue()) {
                checkageAccountInfo.setItemDC(BalanceDirectionEnum.DEBIT);
            }
            DataElementInfo dataElementInfo = DataElementProvider.getDataElementInfo((Context)ctx, (String)dataElementNumber);
            if (dataElementInfo == null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_notExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "checkageAccount_import_dataElementNumber", null)}));
            }
            checkageAccountInfo.setDataElement(dataElementInfo.getInterSeq());
        }
        checkageAccountInfo.setFormula(formula);
        checkageAccountInfo.setIsFree(isFree);
        return checkageAccountInfo;
    }

    private boolean exists(Context ctx, String itemTypeNumber, String number) throws TaskExternalException {
        int itemType = "001".equals(itemTypeNumber) ? 0 : 1;
        SQLBuilder sql = new SQLBuilder();
        sql.append("select FItemType,Fnumber,Fid from T_Csl_CheckageAccount \n");
        sql.append("where FItemType=? \n", itemType);
        sql.append("and Fnumber=?", number);
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
            if (rowSet.next()) {
                this.exsitNumberMap.put(rowSet.getString("Fnumber") + rowSet.getInt("FItemType"), rowSet.getString("Fid"));
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"exists_error:", (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private String fecthData(Hashtable htData, String key) {
        DataToken dataToken = (DataToken)htData.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            this.setData(result, "FNumber", rs.getObject("number"));
            int itemType = rs.getInt("itemType");
            if (0 == itemType) {
                this.setData(result, "FItemTypeNumber", "001");
                this.setData(result, "FItemTypeName", ItemTypeEnum.account.getAlias());
                BalTypeEnum balType = BalTypeEnum.getEnum(rs.getInt("balType"));
                this.setData(result, "FDataElementNumber", balType.getName());
                this.setData(result, "FDataElementName", balType.getAlias());
                this.setData(result, "FAccountTableNumber", rs.getObject("accountTableNumber"));
                this.setData(result, "FAccountTableName", rs.getObject("accountTableName"));
                this.setData(result, "FasstActType", AsstActTypeEnum.getEnum(rs.getString("asstActTypes")).getAlias());
            } else {
                this.setData(result, "FItemTypeNumber", "002");
                this.setData(result, "FItemTypeName", ItemTypeEnum.rptItem.getAlias());
                DataElementInfo dataElementInfo = DataElementProvider.getDataElementInfo((Context)ctx, (int)rs.getInt("dataElement"));
                this.setData(result, "FDataElementNumber", dataElementInfo.getNumber());
                this.setData(result, "FDataElementName", dataElementInfo.getName());
            }
            this.setData(result, "FItemNumber", rs.getObject("itemNumber"));
            this.setData(result, "FItemName", rs.getObject("itemName"));
            this.setData(result, "FFormula", rs.getObject("formula"));
            if (rs.getBoolean("isFree")) {
                result.put("FIsFree", "Y");
            } else {
                result.put("FIsFree", "N");
            }
            this.setData(result, "FCreator", rs.getObject("creator.number"));
            this.setData(result, "FCreateTime", this.sdf.format(rs.getObject("createTime")));
            this.setData(result, "FLastUpdateUser", rs.getObject("lastUpdateUser.number"));
            this.setData(result, "FLastUpdateTime", this.sdf.format(rs.getObject("lastUpdateTime")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void setData(Hashtable result, String key, Object value) {
        if (value != null) {
            if (value instanceof BigDecimal) {
                result.put(key, CslRptUtil.ReduceBigDecimalZeros((BigDecimal)((BigDecimal)value)));
            } else {
                result.put(key, value.toString());
            }
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountForExportQuery";
    }

    public String getMainField() {
        return "FNumber";
    }

    public int getSubmitType() {
        return 0;
    }

    public void setContextParameter(Hashtable param) {
        param.put("mainQueryPK", MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountForExportQuery"));
        super.setContextParameter((Map)param);
    }
}

