/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.app.AbstractCheckageCompanyControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckageCompanyControllerBean
extends AbstractCheckageCompanyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.CheckageCompanyControllerBean");

    @Override
    protected HashMap _getExistMap(Context ctx, HashSet companyIDSet) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select  Company.fid id,Company.fnumber number,Company.fname_" + ctx.getLocale() + " name from T_Csl_CheckageCompany CheckageCompany  \r\n");
        sql.append("inner join T_ORG_Company Company on Company.fid=CheckageCompany.FCompanyId  \r\n");
        sql.append("where CheckageCompany.FCompanyId in (").append(CslRptUtil.collection2String((Collection)companyIDSet, (String)",", (boolean)true)).append(")");
        IRowSet rowSet = null;
        HashMap map = new HashMap();
        try {
            rowSet = DbUtil.executeQuery(ctx, sql.toString());
            while (rowSet != null && rowSet.next()) {
                ArrayList<String> companyList = new ArrayList<String>();
                companyList.add(rowSet.getString("number"));
                companyList.add(rowSet.getString("name"));
                map.put(rowSet.getString("id"), companyList);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"DbUtil.executeQuery", (Throwable)e);
        }
        return map;
    }

    @Override
    protected void _enable(Context ctx, List selectList) throws BOSException {
        if (selectList == null || selectList.size() < 1) {
            return;
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append("Update T_Csl_CheckageCompany set FIsFree= ?", 0);
        sql.append(",FFreeTime= ?", 0);
        sql.append(" where FID in ", selectList);
        sql.append(" and FIsFree=?", 1);
        DbUtil.execute(ctx, sql.toString(), sql.getParams());
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("company.name"));
        CheckageCompanyInfo info = this.getCheckageCompanyInfo(ctx, pk, sc);
        StringBuffer retValue = new StringBuffer();
        retValue.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CheckCompany", (Locale)ContextUtils.getLocaleFromEnv())).append("-");
        if (info.getCompany() != null && !StringUtils.isEmpty((String)info.getCompany().getName())) {
            retValue.append(info.getCompany().getName()).append("-");
        }
        if (info.getContect() != null) {
            retValue.append(info.getContect()).append("-");
        }
        if (info.getContect2() != null) {
            retValue.append(info.getContect2()).append("-");
        }
        if (info.isIsIncludingUnPosted()) {
            retValue.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"ContainNotPosted", (Locale)ContextUtils.getLocaleFromEnv())).append("-");
        } else {
            retValue.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"NoContainNotPosted", (Locale)ContextUtils.getLocaleFromEnv())).append("-");
        }
        if (info.isIsfree()) {
            retValue.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"dienable", (Locale)ContextUtils.getLocaleFromEnv()));
        } else {
            retValue.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"enable", (Locale)ContextUtils.getLocaleFromEnv()));
        }
        return retValue.toString();
    }

    @Override
    protected Map _removeOfNoQuote(Context ctx, List selectIdList) throws BOSException {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select  DISTINCT CheckageCompany.fid,COMPANY.fname_l2 from T_Csl_CheckageCompany CheckageCompany  \r\n");
        sql.append("INNER JOIN T_ORG_Company AS COMPANY ON CheckageCompany.FCompanyId = COMPANY.FID  \r\n");
        sql.append("INNER JOIN T_Csl_CheckageBill AS CheckageBill ON CheckageBill.FCompanyId = COMPANY.FID or CheckageBill.FTargetCompanyId = COMPANY.FID \r\n");
        sql.append("where CheckageCompany.fid in ", selectIdList);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
        HashMap listMap = new HashMap();
        ArrayList<String> noRemoveIDList = new ArrayList<String>();
        ArrayList<String> noRemoveNameList = new ArrayList<String>();
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    noRemoveIDList.add(rowSet.getString(1));
                    noRemoveNameList.add(rowSet.getString(2));
                }
            }
            catch (SQLException e) {
                logger.error((Object)"removeOfNoSystem()", (Throwable)e);
            }
        }
        listMap.put("noRemoveIDList", noRemoveIDList);
        listMap.put("noRemoveNameList", noRemoveNameList);
        return listMap;
    }

    @Override
    protected void _ContainNotPosted(Context ctx, List selectList, boolean isContainNotPosted) throws BOSException {
        if (selectList == null || selectList.size() < 1) {
            return;
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append("Update T_Csl_CheckageCompany set FIsIncludingUnPosted= ?", isContainNotPosted ? 1 : 0);
        sql.append(" where FID in ", selectList);
        sql.append(" and FIsIncludingUnPosted=?", isContainNotPosted ? 0 : 1);
        DbUtil.execute(ctx, sql.toString(), sql.getParams());
    }

    @Override
    protected ArrayList _getQuoteTime(Context ctx, String id) throws BOSException {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select  DISTINCT CheckageBill.FYear,CheckageBill.FPeriod from T_Csl_CheckageCompany CheckageCompany  \r\n");
        sql.append("INNER JOIN T_ORG_Company AS COMPANY ON CheckageCompany.FCompanyId = COMPANY.FID  \r\n");
        sql.append("INNER JOIN T_Csl_CheckageBill AS CheckageBill ON CheckageBill.FCompanyId = COMPANY.FID or CheckageBill.FTargetCompanyId = COMPANY.FID \r\n");
        sql.append("where CheckageCompany.fid =? ", id);
        sql.append(" order by CheckageBill.FYear DESC,CheckageBill.FPeriod DESC ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (rowSet != null) {
            try {
                if (rowSet.next()) {
                    list.add(rowSet.getInt(1));
                    list.add(rowSet.getInt(2));
                }
            }
            catch (SQLException e) {
                logger.error((Object)"removeOfNoSystem()", (Throwable)e);
            }
        }
        return list;
    }

    @Override
    protected void _updateDate(Context ctx, String id, int year, int period) throws BOSException {
        if (id == null) {
            return;
        }
        int date = Integer.valueOf(RptUtil.getYearPeriod((int)year, (int)period, (int)year, (int)period));
        SQLBuilder sql = new SQLBuilder();
        sql.append("Update T_Csl_CheckageCompany set FIsFree= ?", 1);
        sql.append(",FFreeTime= ?", date);
        sql.append(" where FID =? ", id);
        sql.append(" and FIsFree=?", 0);
        DbUtil.execute(ctx, sql.toString(), sql.getParams());
    }

    @Override
    protected Map _getYearAndPeriod(Context ctx, String accountPeriodTypeid) throws BOSException {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select FPeriodYear,FPeriodNumber from T_BD_Period   \r\n");
        sql.append("where FTypeID =? ", accountPeriodTypeid);
        sql.append(" order by FPeriodYear,FPeriodNumber asc ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
        ArrayList<Integer> list = new ArrayList<Integer>();
        HashMap<Object, Serializable> resultMap = new HashMap<Object, Serializable>();
        int i = 1;
        int count = rowSet.size();
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    if (i == 1) {
                        list.add(rowSet.getInt(1));
                        list.add(rowSet.getInt(2));
                    }
                    if (i == count) {
                        list.add(rowSet.getInt(1));
                        list.add(rowSet.getInt(2));
                    }
                    resultMap.put(rowSet.getInt(1), Integer.valueOf(rowSet.getInt(2)));
                    ++i;
                }
            }
            catch (SQLException e) {
                logger.error((Object)"removeOfNoSystem()", (Throwable)e);
            }
        }
        resultMap.put("YearPeriodList", list);
        return resultMap;
    }
}

