/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyStatusCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyStatusFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyStatusInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.app.AbstractCheckageCompanyStatusControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CheckageCompanyStatusControllerBean
extends AbstractCheckageCompanyStatusControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.CheckageCompanyStatusControllerBean");

    @Override
    protected Map _lockCheckageData(Context ctx, List ids, int lockType) throws BOSException, EASBizException {
        if (ids != null && !ids.isEmpty()) {
            Timestamp timeStamp = new Timestamp(new Date().getTime());
            String userId = ctx.getCaller().toString();
            Collection<String> handleIds = null;
            StringBuffer msg = new StringBuffer();
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (lockType == 0) {
                Map<String, String> passIds = this.checkTolerance(ctx, ids, msg);
                if (passIds != null && !passIds.isEmpty()) {
                    handleIds = new HashSet();
                    handleIds.addAll(passIds.values());
                    this.lockData(ctx, handleIds, userId, timeStamp, lockType);
                }
            } else {
                handleIds = ids;
                this.lockData(ctx, handleIds, userId, timeStamp, lockType);
            }
            if (handleIds != null) {
                result.put("handleIds", handleIds);
                result.put("timeStamp", timeStamp);
            }
            if (msg.length() > 0) {
                result.put("error", msg.toString());
            }
            return result;
        }
        return null;
    }

    protected int lockData(Context ctx, Collection ids, String userId, Timestamp timeStamp, int lockType) throws BOSException, EASBizException {
        if (ids != null && !ids.isEmpty()) {
            ParamTempTblService service = null;
            String tmpTblName = null;
            try {
                if (ids.size() > 30) {
                    service = ParamTempTblService.getDefaultInstance((Context)ctx, (Collection)ids, null);
                    tmpTblName = service.getTmpTableName();
                }
                SQLBuilder sql = new SQLBuilder();
                sql.append(" update T_Csl_CheckageCompanyStatus ");
                sql.append(" set FStatus=? ", lockType == 0 ? 2 : 1);
                sql.append(",flastupdateuserid=? ", ctx.getCaller().toString());
                sql.append(",flastupdateTime=? ", timeStamp);
                if (!StringUtils.isEmpty((CharSequence)tmpTblName)) {
                    sql.append(" where fid in (select id from ").append(tmpTblName).append(") ");
                } else {
                    sql.append(" where fid in ", ids);
                }
                sql.append(" and FStatus=? ", lockType == 0 ? 1 : 2);
                int n = DbUtil.executeUpdate(ctx, sql.getSQL(), sql.getParams());
                return n;
            }
            catch (Exception e) {
                logger.error((Object)"checkTolerance error.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (service != null && !DebugLogger.isDebug) {
                    service.release();
                }
            }
        }
        return 0;
    }

    protected Map<String, String> checkTolerance(Context ctx, List ids, StringBuffer msg) throws BOSException, EASBizException {
        ParamTempTblService service = null;
        String tmpTblName = null;
        try {
            CheckageCompanyStatusCollection coll;
            if (ids.size() > 30) {
                service = ParamTempTblService.getDefaultInstance((Context)ctx, (Collection)ids, null);
                tmpTblName = service.getTmpTableName();
            }
            if ((coll = CheckageCompanyStatusFactory.getLocalInstance(ctx).getCheckageCompanyStatusCollection("select year,period,currencyId where id='" + ids.get(0) + "'")) != null && !coll.isEmpty()) {
                Map<String, String> noPassTolerCompany;
                Map<String, String>[] checkResult;
                CheckageCompanyStatusInfo info = coll.get(0);
                String currencyId = info.getCurrencyId();
                int year = info.getYear();
                int period = info.getPeriod();
                HashMap<String, String> companyIds = new HashMap<String, String>();
                SQLBuilder sql = new SQLBuilder();
                sql.append("select FCompanyId,fid ");
                sql.append("from T_Csl_CheckageCompanyStatus  ");
                if (!StringUtils.isEmpty((CharSequence)tmpTblName)) {
                    sql.append(" where fid in (select id from ").append(tmpTblName).append(") ");
                } else {
                    sql.append(" where fid in ", ids);
                }
                sql.append(" and FStatus=? ", 1);
                IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                while (rowSet.next()) {
                    companyIds.put(rowSet.getString("FCompanyId"), rowSet.getString("fid"));
                }
                if (!companyIds.isEmpty() && (checkResult = ToleranceUtil.batchCheckTolerance(ctx, companyIds.keySet(), null, year, period, currencyId, true)) != null && !(noPassTolerCompany = checkResult[0]).isEmpty()) {
                    msg.append(AccountCheckUtil.getResourceString(ctx, "502_allExceTolerance", null)).append("\n");
                    for (String companyId : noPassTolerCompany.keySet()) {
                        msg.append(noPassTolerCompany.get(companyId)).append("\n");
                        companyIds.remove(companyId);
                    }
                }
                HashMap<String, String> hashMap = companyIds;
                return hashMap;
            }
        }
        catch (Exception e) {
            logger.error((Object)"checkTolerance error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (service != null && !DebugLogger.isDebug) {
                service.release();
            }
        }
        return null;
    }

    @Override
    protected List _getCheckageStatusList(Context ctx, CheckageFilterInfo filter) throws BOSException, EASBizException {
        if (filter != null && filter.treeId != null && filter.currencyId != null && filter.year > 0 && filter.period > 0) {
            String nameField = "fname_" + ctx.getLocale();
            SQLBuilder sqlB = new SQLBuilder();
            sqlB.append(" select status.fid statusId,pUnit.fid orgUnitId,unit.fid companyId,isnull(status.fstatus,0) status,pmuser.").append(nameField).append(" lastUpdateUser ");
            sqlB.append(",status.flastupdatetime lastUpdateTime,unit.").append(nameField).append(" companyName,unit.fnumber companyNumber,pUnit.").append(nameField).append(" orgUnitName ");
            sqlB.append(" from t_org_structure stru \n");
            sqlB.append(" inner join t_org_baseunit unit on unit.fid=stru.funitid  \n");
            sqlB.append(" inner join T_Csl_CheckageCompany chCompany on chCompany.FCompanyId=stru.funitid  \n");
            sqlB.append(" left join T_Csl_CheckageCompanyStatus status on status.fcompanyid=stru.funitid  ");
            sqlB.append(" and status.fyear=?", filter.year).append(" and status.fperiod=?", filter.period).append(" and status.fcurrencyid=?", filter.currencyId).append("\n ");
            sqlB.append(" left join t_pm_user pmuser on pmuser.fid=status.flastupdateuserid  \n");
            sqlB.append(" inner join t_org_structure pStru on pStru.fid=stru.fparentid  \n");
            sqlB.append(" inner join t_org_baseunit pUnit on pUnit.fid=pStru.funitid  \n");
            sqlB.append(" where stru.ftreeid=? ", filter.treeId).append(" and unit.fisgrouping=0 ");
            if (!filter.isIncludeChild) {
                sqlB.append(" and pUnit.fid=? ", filter.orgUnitId);
            } else {
                sqlB.append(" and pUnit.fid in ", filter.hasPermOrgIds);
            }
            if (filter.status == 0) {
                sqlB.append(" and (status.FStatus is null or status.FStatus=0)");
            } else if (filter.status > 0) {
                sqlB.append(" and status.FStatus=? ", filter.status);
            }
            if (!StringUtils.isEmpty((CharSequence)filter.orgNumberOrNameFilter)) {
                String likeStr = "%" + filter.orgNumberOrNameFilter + "%";
                sqlB.append(" and (unit.").append(nameField).append(" like ? ", likeStr);
                sqlB.append(" or unit.fnumber like ? ", likeStr).append(") ");
            }
            if (!StringUtils.isEmpty((CharSequence)filter.sortStr)) {
                sqlB.append(" order by ").append(filter.sortStr);
            } else {
                sqlB.append(" order by pStru.flongnumber,unit.fnumber asc ");
            }
            IRowSet rowSet = DbUtil.executeQuery(ctx, sqlB.getSQL(), sqlB.getParams());
            return this.getRowSet(rowSet);
        }
        return null;
    }

    public List getRowSet(IRowSet rowSet) throws BOSException, EASBizException {
        try {
            ArrayList rows = new ArrayList();
            ResultSetMetaData meta = rowSet.getMetaData();
            HashSet<String> colNames = new HashSet<String>();
            int colCount = meta.getColumnCount();
            for (int col = 1; col <= colCount; ++col) {
                colNames.add(meta.getColumnName(col));
            }
            while (rowSet != null && rowSet.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                rows.add(row);
                for (String colName : colNames) {
                    row.put(colName.toUpperCase(Locale.ENGLISH), rowSet.getObject(colName));
                }
            }
            return rows;
        }
        catch (Exception e) {
            logger.error((Object)"_getCheckageStatusList error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

