/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageAccount;
import com.kingdee.eas.fi.newrpt.accountcheck.IRPTItemMap;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DataSubmitModeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.BlockDataReader;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelXErrorDataWriter;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReader;
import com.kingdee.eas.tools.datatask.task.TaskBlockDataRunner;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptItemMapImport
extends BlockDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.RptItemMapImport");
    private Map<String, RPTItemInfo> rptItemCacheMap = new HashMap<String, RPTItemInfo>();
    private Map<String, Boolean> isAccessCacheMap = new HashMap<String, Boolean>();
    private Map<String, String> exsitNumberMap = new HashMap<String, String>();
    private Map<String, Integer> rowExsitNumberIndexMap = new HashMap<String, Integer>();
    private Map<String, CheckageAccountInfo> CheckageAccountMap = new HashMap<String, CheckageAccountInfo>();
    private Map<String, List<RPTItemMapInfo>> accountDataMap = null;
    private Map<String, List<Integer>> accountDataRowNumMap = null;
    private Map<String, List<RPTItemMapInfo>> rptDataMap = null;
    private Map<String, List<Integer>> rptDataRowNumMap = null;
    ICheckageAccount ICheckageAccount = null;
    private int dataRowNum = -1;
    TaskBlockDataRunner runner = null;
    BlockDataReader reader = null;
    ArrayList errorDetail = null;
    ArrayList errorRowNum = null;
    AbstractExternalDataReader dataReader = null;
    Boolean hasErrorFile = null;
    ExcelXErrorDataWriter errDataWriter = null;
    ArrayList deleteErrorDetail = new ArrayList();
    TaskExternalException lastDataEx = null;
    SimpleRecord lastRecord = null;
    private Map<String, TaskExternalException> failDataMap = new HashMap<String, TaskExternalException>();
    private Set<String> dupRowDataSet = new HashSet<String>();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return RPTItemMapFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        super.submit(coreBaseInfo, ctx);
    }

    public void submitBlock(Context ctx, Object coreBaseInfo) throws TaskExternalException {
        if (coreBaseInfo != null) {
            RPTItemMapInfo rptItemMapInfo = (RPTItemMapInfo)coreBaseInfo;
            String accountNumber = rptItemMapInfo.getRPTItemAccount().get(0).getCheckAccount().getNumber();
            String number = rptItemMapInfo.getNumber();
            ItemTypeEnum itemType = rptItemMapInfo.getItemType();
            String key = number + itemType.getValue() + accountNumber;
            boolean isAccount = 0 == itemType.getValue();
            this.rowExsitNumberIndexMap.put(key, this.dataRowNum);
            if (isAccount) {
                if (this.accountDataMap == null) {
                    this.accountDataMap = new LinkedHashMap<String, List<RPTItemMapInfo>>();
                }
                if (this.accountDataRowNumMap == null) {
                    this.accountDataRowNumMap = new HashMap<String, List<Integer>>();
                }
            }
            if (!isAccount) {
                if (this.rptDataMap == null) {
                    this.rptDataMap = new LinkedHashMap<String, List<RPTItemMapInfo>>();
                }
                if (this.rptDataRowNumMap == null) {
                    this.rptDataRowNumMap = new HashMap<String, List<Integer>>();
                }
            }
            Map<String, List<RPTItemMapInfo>> currentMap = null;
            Map<String, List<Integer>> currentRowNumMap = null;
            if (isAccount) {
                currentMap = this.accountDataMap;
                currentRowNumMap = this.accountDataRowNumMap;
            } else {
                currentMap = this.rptDataMap;
                currentRowNumMap = this.rptDataRowNumMap;
            }
            List<RPTItemMapInfo> rptItemMapList = currentMap.get(number);
            if (rptItemMapList == null) {
                rptItemMapList = new LinkedList<RPTItemMapInfo>();
                currentMap.put(number, rptItemMapList);
            }
            rptItemMapList.add(rptItemMapInfo);
            List<Integer> rowNumList = currentRowNumMap.get(number);
            if (rowNumList == null) {
                rowNumList = new LinkedList<Integer>();
                currentRowNumMap.put(number, rowNumList);
            }
            rowNumList.add(this.dataRowNum);
        }
        try {
            if (!this.reader.hasNextBlock()) {
                this.addAllAccountMap(ctx);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void addAllAccountMap(Context ctx) throws TaskExternalException {
        Iterator<Map.Entry<String, List<RPTItemMapInfo>>> iterator;
        boolean hasData = false;
        if (this.accountDataMap != null && !this.accountDataMap.isEmpty()) {
            hasData = true;
            iterator = this.accountDataMap.entrySet().iterator();
            while (iterator.hasNext()) {
                this.addDataMap(ctx, iterator, this.accountDataRowNumMap);
            }
        }
        if (this.rptDataMap != null && !this.rptDataMap.isEmpty()) {
            hasData = true;
            iterator = this.rptDataMap.entrySet().iterator();
            while (iterator.hasNext()) {
                this.addDataMap(ctx, iterator, this.rptDataRowNumMap);
            }
        }
        if (!hasData) {
            this.addLastDataErrorInfo(ctx);
        }
        this.deleteErrorDetail.addAll(this.errorDetail);
        this.errorDetail.clear();
        this.errorDetail.addAll(this.deleteErrorDetail);
        this.resetErrorRow();
    }

    private void resetErrorRow() {
        if (this.errorRowNum != null) {
            this.errorRowNum.clear();
        }
        if (this.errorDetail != null) {
            for (int i = 0; i < this.errorDetail.size(); ++i) {
                this.errorRowNum.add(5);
            }
        }
    }

    private void addDataMap(Context ctx, Iterator<Map.Entry<String, List<RPTItemMapInfo>>> iterator, Map<String, List<Integer>> dataRowNumMap) throws TaskExternalException {
        this.addLastDataErrorInfo(ctx);
        if (this.errorDetail != null && !this.errorDetail.isEmpty()) {
            for (int i = 0; i < this.errorDetail.size(); ++i) {
                this.deleteErrorDetail.add(this.errorDetail.get(i));
            }
            this.errorDetail.clear();
        }
        this.resetErrorRow();
        Map.Entry<String, List<RPTItemMapInfo>> next = iterator.next();
        try {
            this.verifyAccountMap(ctx, next.getValue());
            this.importDataFromMap(ctx, next.getKey(), next.getValue());
        }
        catch (TaskExternalException e) {
            String failDataKey = next.getKey() + next.getValue().get(0).getItemType().getValue();
            if (failDataKey != null) {
                this.failDataMap.put(failDataKey, e);
            }
            try {
                if (this.dataReader instanceof ExternalExcelXDataReader && this.hasErrorFile.booleanValue()) {
                    List<Integer> rowNumList = dataRowNumMap.get(next.getKey());
                    TaskLog tl = this.runner.getTaskLog();
                    List<RPTItemMapInfo> accountMapInfoList = next.getValue();
                    int x = 0;
                    for (Integer rowNum : rowNumList) {
                        String errFieldDesc;
                        RPTItemMapInfo accountMapInfo = accountMapInfoList.get(x);
                        String errMsg = this.getMsgOnDataErr(ctx, rowNum);
                        tl.addExceptionForBlock(errMsg, (Throwable)e, rowNum, rowNum);
                        tl.setFailRecordCount(tl.getFailRecordCount() + 1);
                        tl.setSuccessRecordCount(tl.getSuccessRecordCount() - 1);
                        TaskLogUtil.putLog((TaskLog)tl);
                        DataToken value = new DataToken();
                        value.name = "ErrorReason";
                        value.desc = errFieldDesc = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorReason", (Locale)ctx.getLocale());
                        try {
                            HashMap<String, DataToken> hsData = new HashMap<String, DataToken>();
                            String cellValue = null;
                            cellValue = (String)this.errorDetail.get(x);
                            value.data = cellValue == null ? "" : cellValue.trim();
                            hsData.putAll(((SimpleRecord)accountMapInfo.get("record")).getMap());
                            hsData.put("ErrorReason", value);
                            this.errDataWriter.writeLine(hsData);
                        }
                        catch (TaskRunnerException ee) {
                            logger.error((Object)ee);
                        }
                        ++x;
                    }
                }
                if (!this.hasErrorFile.booleanValue()) {
                    throw e;
                }
            }
            catch (Exception ee) {
                throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
            }
        }
    }

    private void verifyAccountMap(Context ctx, List<RPTItemMapInfo> accountMapList) throws TaskExternalException {
        RPTItemMapInfo mapInfo = this.getNewRPTItemMapInfo(ctx, accountMapList);
        if (mapInfo == null) {
            return;
        }
        try {
            IRPTItemMap irptItemMap = (IRPTItemMap)this.getController(ctx);
            String existNumber = irptItemMap.getExistNumber(mapInfo);
            if (existNumber != null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_accountMapDup", new Object[]{existNumber}));
            }
            if (mapInfo.getId() != null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)mapInfo.getId().toString()));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("isFree"));
                view.setSelector(sic);
                RPTItemMapCollection rptItemMapCollection = irptItemMap.getRPTItemMapCollection(view);
                RPTItemMapInfo oldRPTItemMapInfo = null;
                if (rptItemMapCollection != null && !rptItemMapCollection.isEmpty()) {
                    oldRPTItemMapInfo = rptItemMapCollection.get(0);
                }
                if (oldRPTItemMapInfo != null && !mapInfo.isIsFree() && mapInfo.isIsFree() != oldRPTItemMapInfo.isIsFree()) {
                    Iterator iterator;
                    ArrayList<String> freeList = new ArrayList<String>();
                    freeList.add(mapInfo.getId().toString());
                    Map map = irptItemMap.getEnableExistNumber(freeList);
                    if (map.size() > 0 && (iterator = map.entrySet().iterator()).hasNext()) {
                        Map.Entry entry = iterator.next();
                        String[] numbers = (String[])entry.getValue();
                        throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_accountMapDup", new Object[]{numbers[1]}));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void addLastDataErrorInfo(Context ctx) throws TaskExternalException {
        if (this.lastDataEx != null) {
            if (this.dataReader instanceof ExternalExcelXDataReader && this.hasErrorFile.booleanValue()) {
                String errFieldDesc;
                TaskLog tl = this.runner.getTaskLog();
                String errMsg = this.getMsgOnDataErr(ctx, this.dataRowNum);
                tl.addExceptionForBlock(errMsg, (Throwable)this.lastDataEx, Integer.valueOf(this.dataRowNum), Integer.valueOf(this.dataRowNum));
                tl.setFailRecordCount(tl.getFailRecordCount() + 1);
                tl.setSuccessRecordCount(tl.getSuccessRecordCount() - 1);
                TaskLogUtil.putLog((TaskLog)tl);
                DataToken value = new DataToken();
                value.name = "ErrorReason";
                value.desc = errFieldDesc = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorReason", (Locale)ctx.getLocale());
                try {
                    HashMap<String, DataToken> hsData = new HashMap<String, DataToken>();
                    String cellValue = this.lastDataEx.getMessage();
                    value.data = cellValue == null ? "" : cellValue.trim();
                    hsData.putAll(this.lastRecord.getMap());
                    hsData.put("ErrorReason", value);
                    this.errDataWriter.writeLine(hsData);
                }
                catch (TaskRunnerException ee) {
                    logger.error((Object)ee);
                }
            } else if (!this.hasErrorFile.booleanValue()) {
                throw this.lastDataEx;
            }
            this.lastDataEx = null;
        }
    }

    private String getMsgOnDataErr(Context ctx, Integer rowNum) {
        Locale locale = ctx.getLocale();
        return EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importNo", (Locale)locale) + rowNum + EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"lineData", (Locale)locale);
    }

    public void beforeSubmitBlockData(Context ctx, Object o) throws TaskExternalException {
    }

    public void verifyBlockData(Context ctx, Object o) throws TaskExternalException {
    }

    protected DataSubmitModeEnum getDataSubmitMode() {
        return super.getDataSubmitMode();
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return super.isSameBlock(firstData, currentData);
    }

    public boolean isSameBlock(Map firstData, Map currentData) {
        return false;
    }

    public void importFile(Context ctx, TaskExternalCode task) throws TaskExternalException {
        super.importFile(ctx, task);
    }

    private void importDataFromMap(Context ctx, String number, List<RPTItemMapInfo> dataList) throws TaskExternalException {
        try {
            if (dataList != null && !dataList.isEmpty()) {
                String failDataKey = number + dataList.get(0).getItemType().getValue();
                if (this.failDataMap.containsKey(failDataKey) && this.dupRowDataSet.contains(failDataKey)) {
                    this.dupRowDataSet.remove(failDataKey);
                } else if (this.failDataMap.containsKey(failDataKey) && !this.dupRowDataSet.contains(failDataKey)) {
                    return;
                }
                this.insertAccountMap(ctx, dataList);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void insertAccountMap(Context ctx, List<RPTItemMapInfo> rptItemMapList) throws BOSException, TaskExternalException, EASBizException {
        RPTItemMapInfo mapInfo = this.getNewRPTItemMapInfo(ctx, rptItemMapList);
        if (mapInfo == null) {
            return;
        }
        IRPTItemMap irptItemMap = (IRPTItemMap)this.getController(ctx);
        irptItemMap.submit((CoreBaseInfo)mapInfo);
    }

    private RPTItemMapInfo getNewRPTItemMapInfo(Context ctx, List<RPTItemMapInfo> rptItemMapList) {
        if (rptItemMapList == null || rptItemMapList.isEmpty()) {
            return null;
        }
        RPTItemMapInfo firstRptItemInfo = rptItemMapList.get(0);
        RPTItemMapInfo mapInfo = new RPTItemMapInfo();
        mapInfo.setId(firstRptItemInfo.getId());
        mapInfo.setNumber(firstRptItemInfo.getNumber());
        mapInfo.setRptItem(firstRptItemInfo.getRptItem());
        mapInfo.setDataElement(firstRptItemInfo.getDataElement());
        mapInfo.setRemark(firstRptItemInfo.getRemark());
        mapInfo.setIsFree(firstRptItemInfo.isIsFree());
        mapInfo.setItemType(firstRptItemInfo.getItemType());
        mapInfo.setIsAccess(firstRptItemInfo.isIsAccess());
        RPTItemAccountCollection rptItemAccount = mapInfo.getRPTItemAccount();
        Iterator<RPTItemMapInfo> iterator = rptItemMapList.iterator();
        while (iterator.hasNext()) {
            RPTItemAccountInfo accountInfo = iterator.next().getRPTItemAccount().get(0);
            accountInfo.setRptItemMap(mapInfo);
            rptItemAccount.add(accountInfo);
        }
        return mapInfo;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return super.transmit(hsData, ctx);
    }

    public Object transform(Context ctx, RecordCollection coll) throws TaskExternalException {
        block41: {
            if (coll == null && coll.isEmpty()) {
                return null;
            }
            if (this.runner == null) {
                try {
                    Field field = BlockDataTransmission.class.getDeclaredField("runner");
                    NewRptUtil.makeAccessible(field);
                    this.runner = (TaskBlockDataRunner)field.get((Object)this);
                    Field field_Reader = TaskBlockDataRunner.class.getDeclaredField("reader");
                    NewRptUtil.makeAccessible(field_Reader);
                    this.reader = (BlockDataReader)field_Reader.get(this.runner);
                    Field field_DataReader = this.runner.getClass().getDeclaredField("dataReader");
                    NewRptUtil.makeAccessible(field_DataReader);
                    this.dataReader = (AbstractExternalDataReader)field_DataReader.get(this.runner);
                    Field field_HasErrorFile = this.runner.getClass().getDeclaredField("hasErrorFile");
                    NewRptUtil.makeAccessible(field_HasErrorFile);
                    this.hasErrorFile = (Boolean)field_HasErrorFile.get(this.runner);
                    Field field_ErrDataWriter = this.runner.getClass().getDeclaredField("errDataWriter");
                    NewRptUtil.makeAccessible(field_ErrDataWriter);
                    this.errDataWriter = (ExcelXErrorDataWriter)field_ErrDataWriter.get(this.runner);
                    TaskLog taskLog = this.runner.getTaskLog();
                    if (taskLog == null) break block41;
                    try {
                        Field fieldErrorDetail = taskLog.getClass().getDeclaredField("errorDetail");
                        NewRptUtil.makeAccessible(fieldErrorDetail);
                        this.errorDetail = (ArrayList)fieldErrorDetail.get(taskLog);
                        Field fieldErrorRowNum = taskLog.getClass().getDeclaredField("errorRowNum");
                        NewRptUtil.makeAccessible(fieldErrorRowNum);
                        this.errorRowNum = (ArrayList)fieldErrorRowNum.get(taskLog);
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        }
        SimpleRecord record = (SimpleRecord)coll.get(0);
        this.dataRowNum = record.getRowNum();
        String failDataKey = null;
        try {
            boolean isAccess;
            String number = this.fecthData(record, "FNumber");
            if (StringUtils.isEmpty((String)number)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_number", null)}));
            }
            if ((number = number.trim()).length() > 80) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_numberTooLong", null));
            }
            String rptItemNumber = this.fecthData(record, "FRptItemNumber");
            if (StringUtils.isEmpty((String)rptItemNumber)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_rptItemNumber", null)}));
            }
            RPTItemInfo rptItemInfo = this.getRptItem(ctx, rptItemNumber);
            if (rptItemInfo == null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_isNotExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_rptItemNumber", null)}));
            }
            if (rptItemInfo.isIsFreezed()) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemIsFree", new Object[]{rptItemInfo.getNumber()}));
            }
            String dataElementNumber = this.fecthData(record, "FDataElementNumber");
            if (StringUtils.isEmpty((String)dataElementNumber)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_dataElement", null)}));
            }
            DataElementInfo dataElementInfo = DataElementProvider.getDataElementInfo((Context)ctx, (String)dataElementNumber);
            if (dataElementInfo == null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_isNotExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_dataElement", null)}));
            }
            String itemTypeNumber = this.fecthData(record, "FItemTypeNumber");
            if (StringUtils.isEmpty((String)itemTypeNumber)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_itemType", null)}));
            }
            if (!"001".equals(itemTypeNumber) && !"002".equals(itemTypeNumber)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_isNotExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_itemType", null)}));
            }
            boolean isAccount = "001".equals(itemTypeNumber);
            int itemType = isAccount ? 0 : 1;
            String key = number + itemType;
            failDataKey = key;
            if (this.failDataMap.containsKey(failDataKey)) {
                throw this.failDataMap.get(failDataKey);
            }
            String updateId = null;
            if (!this.isSltImportUpdate()) {
                if (this.exsitNumberMap.containsKey(key) ? this.exsitNumberMap.get(key) != null : this.exists(ctx, itemTypeNumber, number)) {
                    throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_existSameRecord", null));
                }
            } else if (!this.exsitNumberMap.containsKey(key)) {
                if (this.exists(ctx, itemTypeNumber, number)) {
                    updateId = this.exsitNumberMap.get(key);
                }
            } else {
                updateId = this.exsitNumberMap.get(key);
            }
            String isAccessStr = this.fecthData(record, "FIsAccess");
            boolean bl = isAccess = isAccount && "Y".equalsIgnoreCase(isAccessStr);
            if (isAccess && !this.isItemAccess(ctx, rptItemInfo, dataElementInfo)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_haveNoUseItem", null));
            }
            String checkageAccountNumber = this.fecthData(record, "FCheckageAccountNumber");
            if (StringUtils.isEmpty((String)checkageAccountNumber)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_checkageAccountNumber", null)}));
            }
            CheckageAccountInfo checkageAccountInfo = this.getCheckageAccount(ctx, itemType, checkageAccountNumber);
            if (checkageAccountInfo == null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_checkageAccountNumberNull", null));
            }
            if (checkageAccountInfo.isIsFree()) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_checkageAccountIsFreezed", new Object[]{checkageAccountInfo.getNumber()}));
            }
            String dc = this.fecthData(record, "FDC");
            if (StringUtils.isEmpty((String)dc)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_dc", null)}));
            }
            BalanceDirectionEnum balanceDirectionEnum = null;
            if (BalanceDirectionEnum.CREDIT.getAlias().equals(dc)) {
                balanceDirectionEnum = BalanceDirectionEnum.CREDIT;
            } else if (BalanceDirectionEnum.DEBIT.getAlias().equals(dc)) {
                balanceDirectionEnum = BalanceDirectionEnum.DEBIT;
            }
            if (balanceDirectionEnum == null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_isNotExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_dc", null)}));
            }
            String remark = this.fecthData(record, "FRemark");
            if (!StringUtils.isEmpty((String)remark) && (remark = remark.trim()).length() > 2000) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_remarkTooLong", null));
            }
            String isFreeStr = this.fecthData(record, "FIsFree");
            boolean isFree = "Y".equalsIgnoreCase(isFreeStr);
            RPTItemMapInfo rptItemMapInfo = new RPTItemMapInfo();
            if (updateId != null) {
                rptItemMapInfo.setId(BOSUuid.read((String)updateId));
            }
            rptItemMapInfo.setNumber(number);
            rptItemMapInfo.setRptItem(rptItemInfo);
            rptItemMapInfo.setDataElement(dataElementInfo.getInterSeq());
            rptItemMapInfo.setRemark(remark);
            rptItemMapInfo.setIsFree(isFree);
            rptItemMapInfo.setItemType(ItemTypeEnum.getEnum(itemType));
            rptItemMapInfo.setIsAccess(isAccess);
            RPTItemAccountInfo rptItemAccountInfo = new RPTItemAccountInfo();
            rptItemAccountInfo.setRptItemMap(rptItemMapInfo);
            rptItemAccountInfo.setDC(balanceDirectionEnum);
            rptItemAccountInfo.setCheckAccount(checkageAccountInfo);
            rptItemMapInfo.getRPTItemAccount().add(rptItemAccountInfo);
            rptItemMapInfo.put("record", record);
            String rowExsitKey = number + itemType + rptItemMapInfo.getRPTItemAccount().get(0).getCheckAccount().getNumber();
            Integer rowIndex = this.rowExsitNumberIndexMap.get(rowExsitKey);
            if (rowIndex != null) {
                TaskExternalException exception = new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "rptItemMap_import_rowDup", new Object[]{rowIndex}));
                this.failDataMap.put(failDataKey, exception);
                this.dupRowDataSet.add(failDataKey);
                throw exception;
            }
            this.rowExsitNumberIndexMap.put(rowExsitKey, this.dataRowNum);
            return rptItemMapInfo;
        }
        catch (TaskExternalException ee) {
            if (this.errorDetail != null && !this.errorDetail.isEmpty()) {
                this.deleteErrorDetail.add(this.errorDetail.remove(0));
            }
            this.resetErrorRow();
            TaskExternalException exception = new TaskExternalException(ee.getMessage(), (Throwable)ee);
            try {
                if (!this.reader.hasNextBlock()) {
                    this.lastDataEx = exception;
                    this.lastRecord = record;
                    return null;
                }
                if (failDataKey != null) {
                    this.failDataMap.put(failDataKey, exception);
                }
                this.resetErrorRow();
                throw exception;
            }
            catch (TaskRunnerException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isItemAccess(Context ctx, RPTItemInfo rptItemInfo, DataElementInfo dataElementInfo) throws TaskExternalException {
        String accessKey = rptItemInfo.getNumber() + dataElementInfo.getNumber();
        if (this.isAccessCacheMap.containsKey(accessKey)) {
            return this.isAccessCacheMap.get(accessKey);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("itemNumber", (Object)rptItemInfo.getNumber()));
        filter.getFilterItems().add(new FilterItemInfo("dataElement", (Object)dataElementInfo.getInterSeq()));
        filter.getFilterItems().add(new FilterItemInfo("isFree", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)1));
        view.setFilter(filter);
        try {
            CheckageAccountCollection checkageAccountCollection = CheckageAccountFactory.getLocalInstance(ctx).getCheckageAccountCollection(view);
            boolean isItemAccess = checkageAccountCollection != null && !checkageAccountCollection.isEmpty();
            this.isAccessCacheMap.put(accessKey, isItemAccess);
            return isItemAccess;
        }
        catch (BOSException e) {
            logger.error((Object)"isItemAccess error", (Throwable)e);
            this.isAccessCacheMap.put(accessKey, false);
            return false;
        }
    }

    private RPTItemInfo getRptItem(Context ctx, String rptItemNumber) throws TaskExternalException {
        if (this.rptItemCacheMap.containsKey(rptItemNumber)) {
            return this.rptItemCacheMap.get(rptItemNumber);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isFreezed"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)rptItemNumber));
        view.setFilter(filter);
        try {
            RPTItemInfo rptItemInfo = null;
            RPTItemCollection rptItemCollection = RPTItemFactory.getLocalInstance((Context)ctx).getRPTItemCollection(view);
            if (rptItemCollection != null && !rptItemCollection.isEmpty()) {
                rptItemInfo = rptItemCollection.get(0);
            }
            this.rptItemCacheMap.put(rptItemNumber, rptItemInfo);
            return rptItemInfo;
        }
        catch (BOSException e) {
            this.rptItemCacheMap.put(rptItemNumber, null);
            logger.error((Object)"getRptItem_error", (Throwable)e);
            return null;
        }
    }

    private CheckageAccountInfo getCheckageAccount(Context ctx, int itemType, String checkageAccountNumber) throws TaskExternalException {
        String key = itemType + checkageAccountNumber;
        if (!this.CheckageAccountMap.containsKey(key)) {
            try {
                if (this.ICheckageAccount == null) {
                    this.ICheckageAccount = CheckageAccountFactory.getLocalInstance(ctx);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)itemType));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)checkageAccountNumber));
                CheckageAccountCollection checkageAccountCollection = this.ICheckageAccount.getCheckageAccountCollection(view);
                CheckageAccountInfo accountInfo = null;
                if (checkageAccountCollection != null && !checkageAccountCollection.isEmpty()) {
                    accountInfo = checkageAccountCollection.get(0);
                }
                this.CheckageAccountMap.put(key, accountInfo);
                return accountInfo;
            }
            catch (Exception e) {
                logger.error((Object)"getCheckageAccount_error:", (Throwable)e);
                this.CheckageAccountMap.put(key, null);
                return null;
            }
        }
        return this.CheckageAccountMap.get(key);
    }

    private boolean exists(Context ctx, String itemTypeNumber, String number) throws TaskExternalException {
        int itemType = "001".equals(itemTypeNumber) ? 0 : 1;
        SQLBuilder sql = new SQLBuilder();
        sql.append("select FItemType,FNumber,Fid from T_Csl_RPTItemMap \n");
        sql.append("where FItemType=? \n", itemType);
        sql.append("and FNumber=?", number);
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
            if (rowSet.next()) {
                this.exsitNumberMap.put(rowSet.getString("FNumber") + rowSet.getInt("FItemType"), rowSet.getString("Fid"));
                return true;
            }
            this.exsitNumberMap.put(number + itemType, null);
        }
        catch (Exception e) {
            logger.error((Object)"exists_error:", (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private String fecthData(SimpleRecord record, String key) {
        DataToken dataToken = record.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            this.setData(result, "FNumber", rs.getObject("number"));
            this.setData(result, "FRptItemNumber", rs.getObject("rptItem.number"));
            this.setData(result, "FRptItemName", rs.getObject("rptItem.name"));
            this.setData(result, "FDataElementNumber", rs.getObject("dataElement.number"));
            this.setData(result, "FDataElementName", rs.getObject("dataElement.name"));
            this.setData(result, "FItemTypeNumber", rs.getObject("dataElement.name"));
            int itemType = rs.getInt("itemType");
            if (0 == itemType) {
                this.setData(result, "FItemTypeNumber", "001");
                this.setData(result, "FItemTypeName", ItemTypeEnum.account.getAlias());
            } else {
                this.setData(result, "FItemTypeNumber", "002");
                this.setData(result, "FItemTypeName", ItemTypeEnum.rptItem.getAlias());
            }
            this.setData(result, "FCheckageAccountNumber", rs.getString("checkAccount.number"));
            this.setData(result, "FDC", BalanceDirectionEnum.getEnum((int)rs.getInt("RPTItemAccount.DC")).getAlias());
            result.put("FIsAccess", rs.getBoolean("isAccess") ? "Y" : "N");
            this.setData(result, "FRemark", rs.getString("remark"));
            result.put("FIsFree", rs.getBoolean("isFree") ? "Y" : "N");
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void setData(Hashtable result, String key, Object value) {
        if (value != null) {
            if (value instanceof BigDecimal) {
                result.put(key, CslRptUtil.ReduceBigDecimalZeros((BigDecimal)((BigDecimal)value)));
            } else {
                result.put(key, value.toString());
            }
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapForExportQuery";
    }

    public String getMainField() {
        return "FNumber";
    }

    public int getSubmitType() {
        return super.getSubmitType();
    }

    public void setContextParameter(Hashtable param) {
        param.put("mainQueryPK", MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.newrpt.accountcheck.RPTItemMapForExportQuery"));
        super.setContextParameter((Map)param);
    }
}

