/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.billmapping.BillMappingFactory;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.billmapping.ReportFieldInfo;
import com.kingdee.eas.csinterface.billmapping.util.BillMappingUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.SelectNumOrNameEnum;
import com.kingdee.eas.fi.newrpt.EipRptMidDataParamInfo;
import com.kingdee.eas.fi.newrpt.app.AbstractEipRptMidDataParamControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.batch.iref.IntegrateSchemeHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EipRptMidDataParamControllerBean
extends AbstractEipRptMidDataParamControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.app.EipRptMidDataParamControllerBean");

    @Override
    protected Map _getMidDataByParams(Context ctx, Map params) throws BOSException {
        Map<String, List> sqlParams;
        HashMap errorMap = new HashMap();
        StringBuffer selectItemSql = new StringBuffer("select ");
        StringBuffer joinItemSql = new StringBuffer();
        StringBuffer filterSql = new StringBuffer();
        BillMappingInfo billMappingInfo = (BillMappingInfo)params.get("billMapping");
        try {
            billMappingInfo = BillMappingFactory.getLocalInstance((Context)ctx).getBillMappingInfo((IObjectPK)new ObjectUuidPK(billMappingInfo.getId()));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        ArrayList<String> errorList = new ArrayList<String>();
        String table = billMappingInfo.getMidBillTable();
        if (table == null) {
            errorList.add(billMappingInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"noTable", (Locale)ctx.getLocale()) + "\n");
        }
        if ((sqlParams = this.buildSqlAndParam(ctx, params, errorList, selectItemSql, joinItemSql, filterSql)) == null) {
            errorMap.put("errorStr", errorList);
            return errorMap;
        }
        StringBuffer sql = selectItemSql.deleteCharAt(selectItemSql.length() - 1).append(" from ").append(table).append(" data ").append(joinItemSql).append(" ");
        if (filterSql.length() > 0) {
            sql.append(" where ").append(filterSql);
        }
        List asstActItemList = (List)params.get("asstActItemList");
        return this.getMidTableDatasBySql(ctx, sql.toString(), sqlParams, asstActItemList);
    }

    private Map<String, Object> getMidTableDatasBySql(Context ctx, String sql, Map<String, List> sqlParams, List<EipRptMidDataParamInfo> asstActItemList) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<EipRptMidDataParamInfo> dataList = new ArrayList<EipRptMidDataParamInfo>();
        List queryParams = sqlParams.get("sqlParams");
        List selectNames = sqlParams.get("selectName");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql, queryParams.toArray());
        HashMap<String, Object> dataElementName = new HashMap<String, Object>();
        try {
            boolean infoInFilter = true;
            while (rowSet.next()) {
                EipRptMidDataParamInfo info = new EipRptMidDataParamInfo();
                for (int i = 0; i < selectNames.size(); ++i) {
                    info.put((String)selectNames.get(i), rowSet.getObject((String)selectNames.get(i)));
                }
                dataElementName.put(rowSet.getString("dataElementName"), null);
                String asstActNumGroup = rowSet.getString("fasst_number");
                if (asstActItemList != null && asstActItemList.size() > 0) {
                    for (int i = 0; i < asstActItemList.size(); ++i) {
                        EipRptMidDataParamInfo asstActInfo = asstActItemList.get(i);
                        String startFilter = (String)asstActInfo.get("filterStart");
                        if (startFilter != null && asstActNumGroup == null) {
                            infoInFilter = false;
                            break;
                        }
                        if (asstActNumGroup == null) continue;
                        String[] asstActNumArray = asstActNumGroup.split("\\|");
                        for (int j = 0; j < asstActNumArray.length; ++j) {
                            String asstActNum = asstActNumArray[j];
                            info.put(asstActNum, rowSet.getString("fasst" + ++j + "_number"));
                        }
                        infoInFilter = this.checkAsstActInFilter(asstActInfo, info);
                    }
                }
                if (!infoInFilter) continue;
                dataList.add(info);
            }
            selectNames.remove("dataCFFVALUE");
            selectNames.remove("dc");
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        map.put("dataList", dataList);
        map.put("dataElement", dataElementName);
        map.put("selectNames", selectNames);
        return map;
    }

    private boolean checkAsstActInFilter(EipRptMidDataParamInfo filterInfo, EipRptMidDataParamInfo info) {
        AsstActTypeInfo type = (AsstActTypeInfo)filterInfo.get("asstActType");
        String infoNum = info.getString(type.getNumber());
        String start = (String)filterInfo.get("filterStart");
        String end = (String)filterInfo.get("filterEnd");
        if (start == null) {
            return true;
        }
        if (infoNum == null) {
            return false;
        }
        if (infoNum.compareTo(start) < 0) {
            return false;
        }
        return end == null || infoNum.compareTo(end) <= 0;
    }

    private Map<String, List> buildSqlAndParam(Context ctx, Map<String, Object> params, List errorList, StringBuffer selectItemSql, StringBuffer joinItemSql, StringBuffer filterSql) {
        HashMap<String, List> returnParam = new HashMap<String, List>();
        ArrayList<Object> queryParam = new ArrayList<Object>();
        ArrayList<String> selectName = new ArrayList<String>();
        String selectValueEntryStr = "";
        String midDataStr = "data";
        BillMappingInfo billMappingInfo = (BillMappingInfo)params.get("billMapping");
        Map fieldMapping = null;
        try {
            fieldMapping = BillMappingUtil.getReportFieldForColumn((Context)ctx, (String)billMappingInfo.getNumber());
        }
        catch (Exception e) {
            logger.error((Object)"EipRptMidDataParamControllerBean.buildSelectItemAndFilterSql(Context ctx, Map<String,Object> params) BillMappingUtil.getReportFieldForColumn error", (Throwable)e);
        }
        if (fieldMapping != null) {
            List reportFieldSelectors = (List)params.get("reportFields");
            if (reportFieldSelectors != null) {
                for (int i = 0; i < reportFieldSelectors.size(); ++i) {
                    EipRptMidDataParamInfo info = (EipRptMidDataParamInfo)reportFieldSelectors.get(i);
                    ReportFieldInfo fieldInfo = (ReportFieldInfo)info.get("reportField");
                    Object nameOrNum = info.get("showNameNum");
                    if (fieldInfo == null) continue;
                    String fieldNumber = fieldInfo.getNumber().toLowerCase();
                    String midFieldName = (String)fieldMapping.get(fieldNumber);
                    if (midFieldName == null) {
                        errorList.add(fieldInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"noField", (Locale)ctx.getLocale()) + "\n");
                    }
                    if (IntegrateSchemeHelper.Fields.fcompanynum.name().equals(fieldNumber)) {
                        selectValueEntryStr = "company";
                        this.sqlAppendSelectItem(selectItemSql, selectValueEntryStr, nameOrNum, midFieldName, selectName);
                        joinItemSql.append(" join T_ORG_BASEUNIT ").append(selectValueEntryStr).append(" on ").append(selectValueEntryStr).append(".Fid = ").append(midDataStr).append(".").append(midFieldName);
                        continue;
                    }
                    if (IntegrateSchemeHelper.Fields.fcurrencynum.name().equals(fieldNumber)) {
                        selectValueEntryStr = "currency";
                        this.sqlAppendSelectItem(selectItemSql, selectValueEntryStr, nameOrNum, (String)fieldMapping.get(fieldNumber), selectName);
                        joinItemSql.append(" join T_BD_Currency ").append(selectValueEntryStr).append(" on ").append(selectValueEntryStr).append(".Fid = ").append(midDataStr).append(".").append(midFieldName);
                        continue;
                    }
                    if (IntegrateSchemeHelper.Fields.faccountnum.name().equals(fieldNumber)) {
                        selectValueEntryStr = "account";
                        this.sqlAppendSelectItem(selectItemSql, selectValueEntryStr, nameOrNum, (String)fieldMapping.get(fieldNumber), selectName);
                        selectItemSql.append("account.FDC dc, ");
                        selectName.add("dc");
                        joinItemSql.append(" join T_BD_AccountView ").append(selectValueEntryStr).append(" on ").append(selectValueEntryStr).append(".Fid = ").append(midDataStr).append(".").append(midFieldName);
                        continue;
                    }
                    if (IntegrateSchemeHelper.Fields.fdataelement.name().equals(fieldNumber)) {
                        selectValueEntryStr = "dataElement";
                        this.sqlAppendSelectItem(selectItemSql, selectValueEntryStr, nameOrNum, (String)fieldMapping.get(fieldNumber), selectName);
                        joinItemSql.append(" join T_CSL_DataElement ").append(selectValueEntryStr).append(" on ").append(selectValueEntryStr).append(".FInterSeq = ").append(midDataStr).append(".").append(midFieldName);
                        continue;
                    }
                    this.sqlAppendSelectItem(selectItemSql, midDataStr, nameOrNum, (String)fieldMapping.get(fieldNumber), selectName);
                }
            }
            this.sqlAppendFilterStr(ctx, params, fieldMapping, filterSql, queryParam, errorList);
            this.buidAsstActSelectSql(ctx, selectItemSql, fieldMapping, selectName, errorList);
            if (errorList.size() > 0) {
                return null;
            }
        }
        returnParam.put("selectName", selectName);
        returnParam.put("sqlParams", queryParam);
        return returnParam;
    }

    private void sqlAppendFilterStr(Context ctx, Map<String, Object> params, Map<String, String> fieldMapping, StringBuffer filterSql, List<Object> queryParam, List errorList) {
        int i;
        Object infoParam = params.get("company");
        if (infoParam != null) {
            filterSql.append(" and company.fid").append(" in(");
            OrgUnitInfo[] orgs = (OrgUnitInfo[])infoParam;
            for (i = 0; i < orgs.length; ++i) {
                filterSql.append("?");
                if (i != orgs.length - 1) {
                    filterSql.append(",");
                }
                queryParam.add(orgs[i].getId().toString());
            }
            filterSql.append(") ");
        }
        if ((infoParam = params.get("currency")) != null) {
            filterSql.append(" and currency.fnumber").append(" = ? ");
            queryParam.add(infoParam.toString());
        }
        if ((infoParam = params.get("accountSrtatr")) != null) {
            filterSql.append(" and account.fnumber").append(" >= ? ");
            queryParam.add(infoParam.toString());
        }
        if ((infoParam = params.get("accountEnd")) != null) {
            filterSql.append(" and account.fnumber").append(" <= ? ");
            queryParam.add(infoParam.toString());
        }
        if ((infoParam = params.get("dateStart")) != null) {
            if (fieldMapping.get(IntegrateSchemeHelper.Fields.fbizdate.name()) == null) {
                errorList.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"noBizDate", (Locale)ctx.getLocale()) + "\n");
            }
            filterSql.append(" and data.").append(fieldMapping.get(IntegrateSchemeHelper.Fields.fbizdate.name())).append(" >= ? ");
            queryParam.add(new Timestamp(((Date)infoParam).getTime()));
        }
        if ((infoParam = params.get("dateEnd")) != null) {
            if (fieldMapping.get(IntegrateSchemeHelper.Fields.fbizdate.name()) == null) {
                errorList.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"noBizDate", (Locale)ctx.getLocale()) + "\n");
            }
            filterSql.append(" and data.").append(fieldMapping.get(IntegrateSchemeHelper.Fields.fbizdate.name())).append(" <= ? ");
            queryParam.add(new Timestamp(((Date)infoParam).getTime()));
        }
        if ((infoParam = params.get("dataElement")) != null) {
            filterSql.append(" and dataElement.fid").append(" in(");
            List dataElment = (List)infoParam;
            for (i = 0; i < dataElment.size(); ++i) {
                filterSql.append("?");
                if (i != dataElment.size() - 1) {
                    filterSql.append(",");
                }
                queryParam.add(((DataElementInfo)dataElment.get(i)).getId().toString());
            }
            filterSql.append(") ");
        }
        if (filterSql.length() > 0) {
            filterSql.delete(0, 4);
        }
    }

    private void buidAsstActSelectSql(Context ctx, StringBuffer selectItemSql, Map<String, String> fieldMapping, List<String> selectNames, List errorList) {
        String rptField = "fasst";
        for (int i = 0; i < 9; ++i) {
            if (i != 0) {
                rptField = rptField + i;
            }
            rptField = rptField + "_number";
            selectItemSql.append("data").append(".").append(fieldMapping.get(rptField)).append(" ").append(rptField).append(",");
            if (fieldMapping.get(rptField) == null) {
                errorList.add(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"asstactNoField", (Locale)ctx.getLocale()) + "\n");
                break;
            }
            selectNames.add(rptField);
        }
    }

    private void sqlAppendFilterItem(StringBuffer filterSql, String filterValueEntryStr, String midFieldName, EipRptMidDataParamInfo info, List<Object> sqlParams) {
        String filterFieldName = "";
        filterFieldName = "data".equals(filterValueEntryStr) ? "fnumber " : midFieldName;
        if (info.get("filterStart") != null) {
            filterSql.append(" and ").append(filterValueEntryStr).append(".").append(filterFieldName).append(" >= ?");
            sqlParams.add(info.get("filterStart"));
        }
        if (info.get("filterEnd") != null) {
            filterSql.append(" and ").append(filterValueEntryStr).append(".").append(filterFieldName).append(" <= ?");
            sqlParams.add(info.get("filterEnd"));
        }
    }

    private void sqlAppendSelectItem(StringBuffer selectItemSql, String selectValueEntryStr, Object nameOrNum, String midFieldName, List<String> selectNames) {
        selectItemSql.append(" ").append(selectValueEntryStr);
        SelectNumOrNameEnum nameOrNumEnum = null;
        String selectName = "";
        if ("--".equals(nameOrNum)) {
            selectName = selectValueEntryStr + midFieldName;
            selectItemSql.append(".").append(midFieldName).append(" ").append(selectName).append(",");
        } else if (nameOrNum != null) {
            nameOrNumEnum = (SelectNumOrNameEnum)nameOrNum;
            if (3 == nameOrNumEnum.getValue()) {
                selectName = selectValueEntryStr + "Name";
                selectItemSql.append(".fname_l2 ").append(selectName).append(",");
            } else if (2 == nameOrNumEnum.getValue()) {
                selectName = selectValueEntryStr + "Num";
                selectItemSql.append(".fnumber ").append(selectName).append(",");
            } else {
                selectName = selectValueEntryStr + "Name";
                selectItemSql.append(".fname_l2 ").append(selectName).append(",");
                selectNames.add(selectName);
                selectName = selectValueEntryStr + "Num";
                selectItemSql.append(" ").append(selectValueEntryStr).append(".fnumber ").append(selectName).append(",");
            }
        }
        if (!"dataElement".equals(selectValueEntryStr)) {
            selectNames.add(selectName);
        }
    }
}

