/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.app;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SQLBuilder {
    private List<Object> params = new ArrayList<Object>();
    private StringBuilder sql;
    private final int defaultCapacity = 500;

    public SQLBuilder() {
        this.sql = new StringBuilder(500);
    }

    public SQLBuilder(int capacity) {
        this.sql = new StringBuilder(capacity);
    }

    public SQLBuilder append(String sqlPart) {
        this.sql.append(sqlPart);
        return this;
    }

    public SQLBuilder append(Object sqlPart) {
        this.sql.append(sqlPart);
        return this;
    }

    public SQLBuilder append(String sqlPart, Object param) {
        this.sql.append(sqlPart);
        this.params.add(this.getPrimitiveValue(param));
        return this;
    }

    private Object getPrimitiveValue(Object obj) {
        BOSUuid idObj;
        if (obj instanceof IntEnum) {
            return ((IntEnum)obj).getValue();
        }
        if (obj instanceof LongEnum) {
            return ((LongEnum)obj).getValue();
        }
        if (obj instanceof DoubleEnum) {
            return ((DoubleEnum)obj).getValue();
        }
        if (obj instanceof StringEnum) {
            return ((StringEnum)obj).getValue();
        }
        if (obj instanceof DataBaseInfo && obj != null && (idObj = ((DataBaseInfo)obj).getId()) != null) {
            return idObj.toString();
        }
        return obj;
    }

    public SQLBuilder append(String sqlPart, Collection coll) {
        this.append(sqlPart, coll.toArray());
        return this;
    }

    public SQLBuilder append(String sqlPart, Object[] param) {
        this.sql.append(sqlPart);
        StringBuilder paramSql = new StringBuilder("(");
        boolean hasMoreOne = false;
        for (Object obj : param) {
            this.params.add(this.getPrimitiveValue(obj));
            if (hasMoreOne) {
                paramSql.append(",");
            }
            paramSql.append("?");
            hasMoreOne = true;
        }
        paramSql.append(")");
        this.sql.append((CharSequence)paramSql);
        return this;
    }

    public SQLBuilder append(String sqlPart, int[] param) {
        this.sql.append(sqlPart);
        StringBuilder paramSql = new StringBuilder("(");
        boolean hasMoreOne = false;
        for (int obj : param) {
            this.params.add(obj);
            if (hasMoreOne) {
                paramSql.append(",");
            }
            paramSql.append("?");
            hasMoreOne = true;
        }
        paramSql.append(")");
        this.sql.append((CharSequence)paramSql);
        return this;
    }

    public SQLBuilder append(String sqlPart, String[] param) {
        this.sql.append(sqlPart);
        StringBuilder paramSql = new StringBuilder("(");
        boolean hasMoreOne = false;
        for (String obj : param) {
            this.params.add(obj);
            if (hasMoreOne) {
                paramSql.append(",");
            }
            paramSql.append("?");
            hasMoreOne = true;
        }
        paramSql.append(")");
        this.sql.append((CharSequence)paramSql);
        return this;
    }

    public String getSQL() {
        return this.sql.toString();
    }

    public Object[] getParams() {
        return this.params.toArray();
    }

    public List<Object> getParamList() {
        return this.params;
    }

    public SQLBuilder append(SQLBuilder sqlBuilder) {
        this.sql.append(sqlBuilder.getSQL());
        this.params.addAll(sqlBuilder.getParamList());
        return this;
    }

    public void reset() {
        this.sql.setLength(0);
        this.params.clear();
    }

    public static void main(String[] args) {
        SQLBuilder builder = new SQLBuilder();
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("1");
        lst.add("2");
        lst.add("3");
        builder.append("select * from t_csl_test ").append(" where fid in", new Object[]{1, 2, 3, 9}).append(" and fnumber in", Arrays.asList("2", "3", "5")).append(" and fyy in ", lst).append(" and fname = ?", 60);
        System.out.println(builder.getSQL());
        System.out.println(Arrays.toString(builder.getParams()));
    }

    public String toString() {
        return this.sql.toString();
    }
}

