/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.app.openApi;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.app.openApi.AbstractCslRptOpenApiFacadeControllerBean;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CslRptOpenApiFacadeControllerBean
extends AbstractCslRptOpenApiFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.app.openApi.CslRptOpenApiFacadeControllerBean");

    @Override
    protected List _getBatchFormulaValues(Context ctx, Map commParams, Map sheetVariables, List formulas) throws BOSException, EASBizException {
        try {
            logger.error((Object)("---------commParams:" + (commParams == null || commParams.isEmpty() ? "null" : commParams.toString())));
            logger.error((Object)("---------sheetVariables:" + (sheetVariables == null || sheetVariables.isEmpty() ? "null" : sheetVariables.toString())));
            logger.error((Object)("---------formulas:" + (formulas == null || formulas.isEmpty() ? "null" : formulas.toString())));
            if (formulas != null && !formulas.isEmpty()) {
                Book book = Book.Manager.getNewBook(null, (int)0);
                this.initCommParams(commParams, book);
                CslRptUtil.prepareCalculate((Context)ctx, (IObjectValue)(commParams == null || commParams.isEmpty() ? new ReportInfo() : null), null, (Book)book, null, (Map)commParams, (ReportVariables)this.getRptVars(sheetVariables));
                this.fillFormulas(book, formulas);
                book.calc();
                List result = this.getCalcResult(book, formulas);
                logger.error((Object)("---------getBatchFormulaValues result:" + (result == null ? "null" : result.toString())));
                return result;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"_getBatchFormulaValues error", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return null;
    }

    private void initCommParams(Map commParams, Book book) throws Exception {
        if (commParams != null) {
            this.changeInteger(commParams, "Report.Year");
            this.changeInteger(commParams, "Report.Period");
            this.changeInteger(commParams, "PeriodType");
            this.changeInteger(commParams, "Report.SourceType");
            this.changeInteger(commParams, "SupportAdjustPeriodData");
            this.changeOrgType(commParams, "orgType");
            this.cheangeDate(commParams, "Report_StartDate");
            this.cheangeDate(commParams, "Report_EndDate");
            if (commParams.containsKey("errorReplaceTxt")) {
                String errorTxt = (String)commParams.get("errorReplaceTxt");
                ReportCalculateErrorProvider e = new ReportCalculateErrorProvider();
                e.setDealException(true);
                e.setExceptionReplacer(errorTxt);
                e.setDealDiv0Error(true);
                e.setZeroDivDisplayAs(errorTxt);
                book.setUserObject("ERRORHANDLER", (Object)e);
                commParams.remove("errorReplaceTxt");
            }
        }
    }

    private void changeInteger(Map commParams, String key) throws Exception {
        Object obj;
        if (commParams != null && (obj = commParams.get(key)) != null) {
            commParams.put(key, Integer.parseInt(obj.toString()));
        }
    }

    private void changeOrgType(Map commParams, String key) throws Exception {
        Object obj;
        if (commParams != null && (obj = commParams.get(key)) != null) {
            commParams.put(key, OrgType.getEnum((int)Integer.parseInt(obj.toString())));
        }
    }

    private void cheangeDate(Map commParams, String key) throws Exception {
        Object obj;
        if (commParams != null && (obj = commParams.get(key)) != null && !(obj instanceof Date)) {
            String tmpStr;
            int length = obj.toString().trim().length();
            if (length > (tmpStr = "yyyy-MM-dd HH:mm:ss").length()) {
                length = tmpStr.length();
            }
            SimpleDateFormat sdf = new SimpleDateFormat(tmpStr.substring(0, length));
            commParams.put(key, sdf.parse(obj.toString()));
        }
    }

    private ReportVariables getRptVars(Map sheetVariables) throws Exception {
        if (sheetVariables != null && !sheetVariables.isEmpty()) {
            ReportVariables rptVars = new ReportVariables();
            Object value = null;
            for (Object key : sheetVariables.keySet()) {
                value = sheetVariables.get(key);
                rptVars.add(new VariableEntry(key.toString(), "sheet1", 1, value == null ? null : value.toString(), false));
            }
            return rptVars;
        }
        return null;
    }

    private void fillFormulas(Book book, List formulas) throws Exception {
        int row = 0;
        int col = 0;
        if (book.getSheetCount() <= 0) {
            book.addSheet(new Sheet(book, "sheet1"));
        }
        Sheet sheet = book.getSheet(0);
        Cell cell = null;
        String curFormula = null;
        for (Object formula : formulas) {
            if (formula != null && formula.toString().length() > 0) {
                curFormula = formula.toString();
                if (!curFormula.startsWith("=")) {
                    curFormula = "=" + curFormula;
                }
                cell = sheet.getCell(row, col, true);
                cell.setFormula(curFormula);
            }
            if (++col < 9) continue;
            col = 0;
            ++row;
        }
    }

    private List getCalcResult(Book book, List formulas) throws Exception {
        ArrayList<String> resultList = new ArrayList<String>(formulas.size());
        int row = 0;
        int col = 0;
        Sheet sheet = book.getSheet(0);
        Cell cell = null;
        IErrorResultProvider pvd = null;
        if (book.getUserObject("ERRORHANDLER") != null) {
            pvd = book.getDeps().getFunctionManager().getErrorResultProvider();
        }
        String value = null;
        for (int i = 0; i < formulas.size(); ++i) {
            Object o;
            cell = sheet.getCell(row, col, true);
            value = cell.getValue().toString();
            if (cell.getValue() != null && cell.getValue().isError() && cell.getFormula() != null && !this.isFormula(cell.getFormula())) {
                value = cell.getFormula().trim().startsWith("=") ? cell.getFormula().trim().substring(1) : cell.getFormula();
            } else if (pvd != null && cell.getValue() != null && cell.getValue().isError() && (o = cell.getValue().getValue()) instanceof SyntaxErrorException) {
                value = pvd.getText(((SyntaxErrorException)((Object)o)).getErrorCode());
            }
            resultList.add(value);
            if (++col < 9) continue;
            col = 0;
            ++row;
        }
        return resultList;
    }

    private boolean isFormula(String formulaStr) {
        if (formulaStr != null) {
            try {
                Expression expression = ExcelFormulaPaserHelper.parse((String)formulaStr);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected List _getRptItemData(Context ctx, Map itemfilters, List fields) throws BOSException, EASBizException {
        try {
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), null, "csl_report_item_analysis");
            logger.error((Object)("---------Itemfilters:" + (itemfilters == null || itemfilters.isEmpty() ? "null" : itemfilters.toString())));
            logger.error((Object)("---------fields:" + (fields == null || fields.isEmpty() ? "null" : fields.toString())));
            if (itemfilters != null && !itemfilters.isEmpty() && fields != null && !fields.isEmpty()) {
                String templateTbl = "tmp";
                String itemTbl = "rptItem";
                String tmpItemListTbl = "itemList";
                Map<String, String> fieldMap = this.getFieldMap(ctx, templateTbl, itemTbl, tmpItemListTbl);
                StringBuffer selectStr = new StringBuffer();
                String orderByStr = this.handleSelectPart(fields, fieldMap, selectStr);
                if (selectStr.length() > 0) {
                    boolean isHasSum = orderByStr.length() != selectStr.length();
                    SQLBuilder sql = new SQLBuilder();
                    sql.append(" select ").append(selectStr).append(" \n");
                    sql.append(" from t_csl_rptitemdata ").append(itemTbl).append(" \n");
                    SQLBuilder whereSql = new SQLBuilder();
                    boolean[] isHasTbl = this.getWherePart(ctx, itemfilters, fieldMap, whereSql);
                    boolean hasTmplateTbl = isHasTbl[0];
                    boolean hasItemListTbl = isHasTbl[1];
                    if (hasTmplateTbl || hasItemListTbl) {
                        sql.append(" inner join t_csl_cslreport rpt on rpt.fid=").append(itemTbl).append(".freportid \n");
                        sql.append(" inner join t_rpt_template ").append(templateTbl).append(" on ").append(templateTbl).append(".fid=rpt.ftemplateid \n");
                    }
                    if (hasItemListTbl) {
                        sql.append("  inner join t_csl_dataelement dataelement on dataelement.fnumber=").append(itemTbl).append(".fdataelementnum \n");
                        sql.append(" inner join t_csl_templetitemlist ").append(tmpItemListTbl).append(" on (").append(tmpItemListTbl).append(".ftemplateid=").append(templateTbl).append(".fid ");
                        sql.append(" or ").append(templateTbl).append(".fgrouptemplateid=").append(tmpItemListTbl).append(".ftemplateid)  ");
                        sql.append(" and ").append(tmpItemListTbl).append(".FITEMNUMBER =").append(itemTbl).append(".fitemnumber and ").append(tmpItemListTbl).append(".FDATAELEMENT =dataelement.FINTERSEQ \n");
                    }
                    sql.append(" where ").append(whereSql.getSQL());
                    sql.getParamList().addAll(whereSql.getParamList());
                    if (!StringUtils.isEmpty((String)orderByStr)) {
                        sql.append(isHasSum ? " group by " : " order by ").append(orderByStr);
                    }
                    IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                    ArrayList<String[]> datas = new ArrayList<String[]>();
                    if (rowSet != null) {
                        int columnCount = rowSet.getMetaData().getColumnCount();
                        while (rowSet.next()) {
                            String[] rowData = new String[columnCount];
                            for (int i = 1; i <= columnCount; ++i) {
                                rowData[i - 1] = rowSet.getString(i);
                            }
                            datas.add(rowData);
                        }
                    }
                    return datas;
                }
                throw new BOSException("select fields is null.");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"_getRptItemData error", (Throwable)ex);
            throw new BOSException(ex.getMessage());
        }
        return null;
    }

    private boolean[] getWherePart(Context ctx, Map itemfilters, Map<String, String> fieldMap, SQLBuilder whereSql) throws Exception {
        boolean hasTmpTbl = false;
        boolean hasItemListTbl = false;
        boolean isHasYear = false;
        boolean isHasPeriod = false;
        String companyNumber = null;
        for (Object filter : itemfilters.keySet()) {
            if (StringUtils.isEmpty((String)filter.toString()) || itemfilters.get(filter) == null) continue;
            String paramField = filter.toString().trim().toLowerCase(Locale.ENGLISH);
            if (fieldMap.containsKey(paramField)) {
                String tblField = fieldMap.get(paramField);
                if (whereSql.getSQL().length() > 0) {
                    whereSql.append(" and ");
                }
                String value = itemfilters.get(filter).toString();
                if (paramField.equals("year")) {
                    isHasYear = true;
                }
                if (paramField.equals("period")) {
                    isHasPeriod = true;
                }
                if (paramField.equals("year") || paramField.equals("period") || paramField.equals("periodtype") || paramField.equals("dataSource") || paramField.equals("commitstatus")) {
                    whereSql.append(tblField).append("=? ", Integer.valueOf(value.trim()));
                } else if (paramField.equals("isadjusted")) {
                    int adjust = Integer.valueOf(value.trim());
                    if (adjust == 2) {
                        whereSql.append(tblField).append(" in(0,1) ");
                    } else {
                        whereSql.append(tblField).append("=? ", adjust);
                    }
                } else if (paramField.equals("companynumber")) {
                    companyNumber = value.trim();
                    this.checkCompanyPerm(ctx, companyNumber);
                } else if (!StringUtils.isEmpty((String)value)) {
                    String[] values = value.split(",");
                    if (values.length > 1) {
                        whereSql.append(tblField).append(" in ", values);
                    } else {
                        whereSql.append(tblField).append("=? ", value);
                    }
                }
                if (!hasTmpTbl && (paramField.equals("templatename") || paramField.equals("templatenumber"))) {
                    hasTmpTbl = true;
                }
                if (hasItemListTbl || !paramField.equals("sheetname")) continue;
                hasItemListTbl = true;
                continue;
            }
            throw new Exception(paramField + " is error.");
        }
        if (!isHasYear || !isHasPeriod) {
            throw new Exception(" year or period is must param.");
        }
        return new boolean[]{hasTmpTbl, hasItemListTbl};
    }

    public void checkCompanyPerm(Context ctx, String companyNum) throws Exception {
        if (StringUtils.isEmpty((String)companyNum)) {
            throw new Exception("companyNumber is null.");
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select org.fid ");
        sql.append("from t_org_baseunit org");
        sql.append(" inner join t_pm_orgrange range on range.forgid=org.fid");
        sql.append(" where org.fnumber=? ", companyNum);
        sql.append(" and range.fuserid=?", ctx.getCaller().toString());
        IRowSet rowset = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (rowset == null || !rowset.next()) {
            throw new Exception("companyNumber:" + companyNum + " have not orgRange permission.");
        }
    }

    private String handleSelectPart(List fields, Map<String, String> fieldMap, StringBuffer selectStr) throws Exception {
        StringBuffer orderByStr = new StringBuffer();
        for (Object selectField : fields) {
            if (selectField == null) continue;
            String curField = fieldMap.get(selectField.toString().toLowerCase(Locale.ENGLISH));
            if (!StringUtils.isEmpty((String)curField)) {
                if (selectStr.length() > 0) {
                    selectStr.append(",");
                }
                if (curField.lastIndexOf("FValue") > 0) {
                    selectStr.append("sum(" + curField + ")");
                    continue;
                }
                selectStr.append(curField);
                if (orderByStr.length() > 0) {
                    orderByStr.append(",");
                }
                orderByStr.append(curField);
                continue;
            }
            throw new Exception(selectField + " is error.");
        }
        return orderByStr.toString();
    }

    private Map<String, String> getFieldMap(Context ctx, String templateTbl, String itemTbl, String tmpItemListTbl) throws Exception {
        HashMap<String, String> fields = new HashMap<String, String>();
        String lang = ctx.getLocale().getLanguage();
        fields.put("templateName".toLowerCase(Locale.ENGLISH), templateTbl + ".fname");
        fields.put("templateNumber".toLowerCase(Locale.ENGLISH), templateTbl + ".fnumber");
        fields.put("year".toLowerCase(Locale.ENGLISH), itemTbl + ".fyear");
        fields.put("period".toLowerCase(Locale.ENGLISH), itemTbl + ".fperiod");
        fields.put("periodType".toLowerCase(Locale.ENGLISH), itemTbl + ".fperiodType");
        fields.put("companyNumber".toLowerCase(Locale.ENGLISH), itemTbl + ".fCompanyNumber");
        fields.put("currencyNumber".toLowerCase(Locale.ENGLISH), itemTbl + ".ftargetCurrencyNum");
        fields.put("itemNumber".toLowerCase(Locale.ENGLISH), itemTbl + ".fItemNumber");
        fields.put("dataElementNumber".toLowerCase(Locale.ENGLISH), itemTbl + ".fDataElementNum");
        fields.put("dataSource".toLowerCase(Locale.ENGLISH), itemTbl + ".fdataSource");
        fields.put("isAdjusted".toLowerCase(Locale.ENGLISH), itemTbl + ".fisAdjusted");
        fields.put("commitstatus".toLowerCase(Locale.ENGLISH), itemTbl + ".fcommitstatus");
        fields.put("sheetName".toLowerCase(Locale.ENGLISH), tmpItemListTbl + ".fsheetName");
        fields.put("companyName".toLowerCase(Locale.ENGLISH), itemTbl + ".fcompanyName_" + lang);
        fields.put("currencyName".toLowerCase(Locale.ENGLISH), itemTbl + ".ftargetCurrencyName_" + lang);
        fields.put("itemName".toLowerCase(Locale.ENGLISH), itemTbl + ".fItemName_" + lang);
        fields.put("dataElementName".toLowerCase(Locale.ENGLISH), itemTbl + ".fDataElementName_" + lang);
        fields.put("value".toLowerCase(Locale.ENGLISH), itemTbl + ".FValue");
        return fields;
    }
}

