/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.app.rptDataApi;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.rptDataApi.AbstractRptDataApiFacadeControllerBean;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Point;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptDataApiFacadeControllerBean
extends AbstractRptDataApiFacadeControllerBean {
    private static final long serialVersionUID = 2440172119411762642L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.app.rptDataApi.RptDataApiFacadeControllerBean");

    @Override
    protected Map _getRptData(Context ctx, String comNumber, String tempNumber, String year, String period, String currencyNumber, String rptType, String periodType, String rptCommited, String rptAdjusted, Map paramExt) throws BOSException, EASBizException {
        CslReportInfo cslReportInfo;
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isDebug = CSLParamUtil.getBooleanCslParamValue((Context)ctx, (String)"KEY_CSLPARAM_GETRPTDATAAPIDEBUG");
        this.log(isDebug, comNumber, tempNumber, year, period, currencyNumber, rptType, periodType, rptCommited, rptAdjusted, paramExt);
        TemplateInfo tmplInfo = null;
        try {
            tmplInfo = this.getTemplateInfo(ctx, rptType, tempNumber);
        }
        catch (Exception ex) {
            result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"templateNull", (Locale)ctx.getOriginLocale()) + tempNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"templateNullTail", (Locale)ctx.getOriginLocale()));
            return result;
        }
        CurrencyInfo currencyInfo = this.getCurrencyInfo(ctx, currencyNumber);
        if (currencyInfo == null) {
            result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"currencyNull", (Locale)ctx.getOriginLocale()) + currencyNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"currencyNullTail", (Locale)ctx.getOriginLocale()));
            return result;
        }
        String currencyId = currencyInfo.getId().toString();
        RptSrcTypeEnum rptTypeEnum = RptSrcTypeEnum.getEnum((int)Integer.valueOf(rptType));
        if (rptTypeEnum == null) {
            result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"rptTypeNull", (Locale)ctx.getOriginLocale()) + rptType);
            return result;
        }
        RptPeriodTypeEnum rptPeriodTypeEnum = RptPeriodTypeEnum.getEnum((int)Integer.valueOf(periodType));
        if (rptPeriodTypeEnum == null) {
            result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"periodTypeNull", (Locale)ctx.getOriginLocale()) + periodType);
            return result;
        }
        CompanyOrgUnitInfo companyInfo = null;
        String companyId = null;
        String orgTreeId = null;
        String orgUnitId = null;
        if (paramExt != null && paramExt.containsKey("orgTreeNumber")) {
            String orgTreeNumber = (String)paramExt.get("orgTreeNumber");
            String orgUnitNumber = (String)paramExt.get("orgUnitNumber");
            orgTreeId = this.getOrgTreeId(ctx, orgTreeNumber, Integer.valueOf(year), Integer.valueOf(period), rptPeriodTypeEnum);
            if (orgTreeId == null) {
                result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"orgTreeNull", (Locale)ctx.getOriginLocale()) + orgTreeNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"orgTreeNullTail", (Locale)ctx.getOriginLocale()));
                return result;
            }
            orgUnitId = this.getOrgUnitId(ctx, orgTreeId, orgUnitNumber);
            if (orgUnitId == null) {
                result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"orgUnitNull", (Locale)ctx.getOriginLocale()) + orgUnitNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"orgUnitNullTail", (Locale)ctx.getOriginLocale()));
                return result;
            }
        } else {
            try {
                companyInfo = this.getCompanyOrgUnitInfo(ctx, comNumber);
                companyId = companyInfo.getId().toString();
            }
            catch (Exception ex) {
                result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"companyNull", (Locale)ctx.getOriginLocale()) + comNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"companyNullTail", (Locale)ctx.getOriginLocale()));
                return result;
            }
        }
        if (!"0".equals(rptCommited) && !"1".equals(rptCommited)) {
            result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"commiteStatusNull", (Locale)ctx.getOriginLocale()) + rptCommited);
            return result;
        }
        if (!"0".equals(rptAdjusted) && !"1".equals(rptAdjusted)) {
            result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"adjustStatusNull", (Locale)ctx.getOriginLocale()) + rptAdjusted);
            return result;
        }
        if (1 == Integer.valueOf(rptType) || 3 == Integer.valueOf(rptType) || 10 == Integer.valueOf(rptType)) {
            try {
                if (!PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectStringPK(companyId), "csl_indirpt_view")) {
                    result.put("error", "you have not report view permission.");
                    return result;
                }
            }
            catch (Exception ex) {
                logger.error((Object)"hasFunctionPermission error.", (Throwable)ex);
                result.put("error", ex.getMessage());
                return result;
            }
        }
        if ((cslReportInfo = this.getCslReportInfo(ctx, orgTreeId, orgUnitId, companyId, tempNumber, year, period, currencyId, rptType, periodType, rptCommited, rptAdjusted)) == null) {
            result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"cslrptNull", (Locale)ctx.getOriginLocale()) + rptAdjusted);
            return result;
        }
        if (1 == Integer.valueOf(rptType) || 3 == Integer.valueOf(rptType)) {
            try {
                Map<String, Map<String, Map<String, String>>> dataMap = this.getRptData(ctx, cslReportInfo);
                if (dataMap.size() <= 0) {
                    result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"dataNull", (Locale)ctx.getOriginLocale()));
                    return result;
                }
                result.put("data", dataMap);
                this.log(isDebug, dataMap);
            }
            catch (Exception e) {
                result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"getDataError", (Locale)ctx.getOriginLocale()) + e.getMessage());
                return result;
            }
        } else if (10 == Integer.valueOf(rptType)) {
            try {
                List<Map<String, Map<String, Map<String, Map<String, String>>>>> dataList = this.getDynaRptData(ctx, cslReportInfo);
                if (dataList.size() <= 0) {
                    result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"dataNull", (Locale)ctx.getOriginLocale()));
                    return result;
                }
                result.put("data", dataList);
                this.log(isDebug, dataList);
            }
            catch (Exception e) {
                result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"getDataError", (Locale)ctx.getOriginLocale()) + e.getMessage());
                return result;
            }
        } else {
            result.put("error", ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"rptNotSupport", (Locale)ctx.getOriginLocale()) + rptType);
            return result;
        }
        return result;
    }

    private String getOrgTreeId(Context ctx, String treeNumber, int year, int period, RptPeriodTypeEnum periodType) {
        String orgTreeId = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" Select Fid id \n");
        sql.append(" From T_Org_Tree \n");
        sql.append(" Where FNumber = ? and FType = ? \n");
        sql.append(" and (( FStartDate <=? and FEndDate >= ? ) \n");
        sql.append(" or (FStartDate <= ? and FEndDate is null)) ");
        Timestamp endTime = new Timestamp(RPTDate13Util.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)periodType).getTime());
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(treeNumber);
        params.add(8);
        params.add(endTime);
        params.add(endTime);
        params.add(endTime);
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            if (rowSet.next()) {
                orgTreeId = rowSet.getString("id");
            }
        }
        catch (Exception e) {
            logger.error((Object)"getOrgTreeId : ", (Throwable)e);
        }
        return orgTreeId;
    }

    private String getOrgUnitId(Context ctx, String orgTreeId, String orgUnitNumber) {
        String orgUnitId = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" Select b.fid id \n");
        sql.append(" From T_Org_BaseUnit b \n");
        sql.append(" Inner join T_Org_Structure s On s.FUnitId = b.Fid \n");
        sql.append(" Where s.FTreeId = ? And b.FNumber = ? ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(orgTreeId);
        params.add(orgUnitNumber);
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            if (rowSet.next()) {
                orgUnitId = rowSet.getString("id");
            }
        }
        catch (Exception e) {
            logger.error((Object)"getOrgUnitId : ", (Throwable)e);
        }
        return orgUnitId;
    }

    private void log(boolean isDebug, Object data) {
        if (isDebug) {
            Gson gson = new Gson();
            String json = gson.toJson(data);
            logger.error((Object)("RptDataJson: " + json));
        }
    }

    private void log(boolean isDebug, String comNumber, String tempNumber, String year, String period, String currencyNumber, String rptType, String periodType, String rptCommited, String rptAdjusted, Map paramExt) {
        if (isDebug) {
            String paramsMsg = null;
            if (paramExt != null && paramExt.containsKey("orgTreeNumber")) {
                String orgTreeNumber = (String)paramExt.get("orgTreeNumber");
                String orgUnitNumber = (String)paramExt.get("orgUnitNumber");
                paramsMsg = "orgTreeNumber: " + orgTreeNumber + " ! orgUnitNumber: " + orgUnitNumber + " ! TemplateNumber: " + tempNumber + " ! Year: " + year + " ! Period\uff1a" + period + " ! CurrencyNumber: " + currencyNumber + " ! SourceType: " + rptType + " ! PeriodType: " + periodType + " ! CommittedStatus: " + rptCommited + " ! AdjustStatus: " + rptAdjusted;
            } else {
                paramsMsg = "CompanyNumber: " + comNumber + " ! TemplateNumber: " + tempNumber + " ! Year: " + year + " ! Period\uff1a" + period + " ! CurrencyNumber: " + currencyNumber + " ! SourceType: " + rptType + " ! PeriodType: " + periodType + " ! CommittedStatus: " + rptCommited + " ! AdjustStatus: " + rptAdjusted;
            }
            logger.error((Object)("ParamString: " + paramsMsg));
        }
    }

    private CslReportInfo getCslReportInfo(Context ctx, String orgTreeId, String orgUnitId, String companyId, String tmplNumber, String year, String period, String currencyId, String rptType, String periodType, String rptCommited, String rptAdjusted) throws BOSException {
        FilterInfo filter = new FilterInfo();
        if (orgTreeId != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgTree", (Object)orgTreeId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)companyId, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("template.number", (Object)tmplNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)Integer.valueOf(year), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)Integer.valueOf(period), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)Integer.valueOf(rptType), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)Integer.valueOf(periodType), CompareType.EQUALS));
        if ("1".equals(rptCommited)) {
            filter.getFilterItems().add(new FilterItemInfo("committedStatus", (Object)3, CompareType.EQUALS));
        } else if ("0".equals(rptCommited)) {
            HashSet<Integer> committedStatusSet = new HashSet<Integer>();
            committedStatusSet.add(1);
            committedStatusSet.add(2);
            committedStatusSet.add(3);
            filter.getFilterItems().add(new FilterItemInfo("committedStatus", committedStatusSet, CompareType.INCLUDE));
        }
        if ("1".equals(rptAdjusted)) {
            filter.getFilterItems().add(new FilterItemInfo("adjustStatus", (Object)1, CompareType.EQUALS));
        } else if ("0".equals(rptAdjusted)) {
            filter.getFilterItems().add(new FilterItemInfo("adjustStatus", (Object)0, CompareType.EQUALS));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("data"));
        CslReportCollection coll = CslReportFactory.getLocalInstance((Context)ctx).getCslReportCollection(viewInfo);
        CslReportInfo cslreportInfo = null;
        if (coll.size() > 0) {
            cslreportInfo = coll.get(0);
        }
        return cslreportInfo;
    }

    private Map<String, Map<String, Map<String, String>>> getRptData(Context ctx, CslReportInfo cslReportInfo) throws Exception {
        Book book = cslReportInfo.getBook();
        HashMap<String, Map<String, Map<String, String>>> resultMap = new HashMap<String, Map<String, Map<String, String>>>();
        HashMap itemMap = new HashMap();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sheet = book.getSheet(i);
            Sheet.ICellsIterator cellsIterator = sheet.getCellsIterator(null, false, true);
            while (cellsIterator.hasNext()) {
                Cell cell = cellsIterator.next();
                if (cell == null || cell.getUserObject("ITEM") == null) continue;
                Variant value = cell.getValue();
                if (value.isNull() || value.isError()) {
                    value = new Variant((Object)"0");
                }
                ItemFormula itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue();
                String valueType = ValueTypeEnum.getEnum((int)itemFormula.getValueType()).getName().toLowerCase();
                String itemNumber = itemFormula.getItemNumber();
                String dataElementNumber = itemFormula.getDataElementNumber();
                if (resultMap.containsKey(valueType)) {
                    ((Map)resultMap.get(valueType)).putAll(itemMap);
                } else {
                    resultMap.put(valueType, itemMap);
                }
                if (itemMap.containsKey(itemNumber)) {
                    ((Map)itemMap.get(itemNumber)).put(dataElementNumber, value.toString());
                    continue;
                }
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put(dataElementNumber, value.toString());
                itemMap.put(itemNumber, valueMap);
            }
        }
        return resultMap;
    }

    private List<Map<String, Map<String, Map<String, Map<String, String>>>>> getDynaRptData(Context ctx, CslReportInfo cslReportInfo) throws Exception {
        ArrayList<Map<String, Map<String, Map<String, Map<String, String>>>>> result = new ArrayList<Map<String, Map<String, Map<String, Map<String, String>>>>>();
        Book book = cslReportInfo.getBook();
        int size = book.getSheetCount();
        for (int i = 0; i < size; ++i) {
            Sheet sheet = book.getSheet(i);
            ArrayList basePoints = DynamicTemplateUtility.getBasePointList((Sheet)sheet);
            for (int j = 0; j < basePoints.size(); ++j) {
                Point curPoint = (Point)basePoints.get(j);
                DynaParameters parameters = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)sheet, (int)curPoint.y, (int)curPoint.x);
                int spreadStyle = parameters.getSpreadStyle();
                boolean isHorizon = spreadStyle == 1;
                Map<String, Map<String, Map<String, Map<String, String>>>> dynaRptDataByPoint = null;
                dynaRptDataByPoint = isHorizon ? this.getHorizonDynaRptDataByPoint(sheet, curPoint, parameters) : this.getDynaRptDataByPoint(sheet, curPoint, parameters);
                result.add(dynaRptDataByPoint);
            }
        }
        return result;
    }

    private Map<String, Map<String, Map<String, Map<String, String>>>> getDynaRptDataByPoint(Sheet sheet, Point curPoint, DynaParameters parameters) {
        HashMap<String, Map<String, Map<String, Map<String, String>>>> resultMap = new HashMap<String, Map<String, Map<String, Map<String, String>>>>();
        HashMap itemMap = new HashMap();
        int maxCol = this.getMaxColIndex(sheet, curPoint.y, curPoint.x);
        int sumLine = parameters.isIncludeSum() && parameters.getPosition() == 1 ? 1 : 0;
        int isShowOtherRowSum = parameters.isShowOtherRowSum() ? 1 : 0;
        int isShowSubTotalRatio = parameters.isShowSubTotalRatio() ? 1 : 0;
        int isIncludeTopNSubtotal = parameters.getTopNSubtotal() != -1 ? 1 : 0;
        for (int col = curPoint.x; col <= maxCol; ++col) {
            HashMap deMap = new HashMap();
            for (int i = 0; i < parameters.getDefaultCounter(); ++i) {
                ItemFormula itemFormula;
                int row = curPoint.y + sumLine + i + 1 + isShowOtherRowSum + isShowSubTotalRatio + isIncludeTopNSubtotal;
                Cell cell = sheet.getCell(row, col, false);
                if (cell == null || cell.getUserObject("ITEM") == null) continue;
                Variant value = cell.getValue();
                if (value.isNull() || value.isError()) {
                    value = new Variant((Object)"0");
                }
                if (!(itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue()).isValidity()) continue;
                String valueType = ValueTypeEnum.getEnum((int)itemFormula.getValueType()).getName().toLowerCase();
                String itemNumber = itemFormula.getItemNumber();
                String dataElementNumber = itemFormula.getDataElementNumber();
                String dyNumber = itemFormula.getDItemNumber();
                if (resultMap.containsKey(valueType)) {
                    ((Map)resultMap.get(valueType)).putAll(itemMap);
                } else {
                    resultMap.put(valueType, itemMap);
                }
                if (itemMap.containsKey(itemNumber)) {
                    ((Map)itemMap.get(itemNumber)).putAll(deMap);
                } else {
                    itemMap.put(itemNumber, deMap);
                }
                if (deMap.containsKey(dataElementNumber)) {
                    ((Map)deMap.get(dataElementNumber)).put(dyNumber, value.toString());
                    continue;
                }
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put(dyNumber, value.toString());
                deMap.put(dataElementNumber, valueMap);
            }
        }
        return resultMap;
    }

    private Map<String, Map<String, Map<String, Map<String, String>>>> getHorizonDynaRptDataByPoint(Sheet sheet, Point curPoint, DynaParameters parameters) {
        HashMap<String, Map<String, Map<String, Map<String, String>>>> resultMap = new HashMap<String, Map<String, Map<String, Map<String, String>>>>();
        HashMap itemMap = new HashMap();
        int maxRow = this.getMaxRowIndex(sheet, curPoint.y, curPoint.x);
        int sumLine = parameters.isIncludeSum() && parameters.getPosition() == 1 ? 1 : 0;
        int isShowOtherRowSum = parameters.isShowOtherRowSum() ? 1 : 0;
        int isShowSubTotalRatio = parameters.isShowSubTotalRatio() ? 1 : 0;
        int isIncludeTopNSubtotal = parameters.getTopNSubtotal() != -1 ? 1 : 0;
        for (int row = curPoint.y; row <= maxRow; ++row) {
            HashMap deMap = new HashMap();
            for (int i = 0; i < parameters.getDefaultCounter(); ++i) {
                ItemFormula itemFormula;
                int col = curPoint.x + sumLine + i + 1 + isShowOtherRowSum + isShowSubTotalRatio + isIncludeTopNSubtotal;
                Cell cell = sheet.getCell(row, col, false);
                if (cell == null || cell.getUserObject("ITEM") == null) continue;
                Variant value = cell.getValue();
                if (value.isNull() || value.isError()) {
                    value = new Variant((Object)"0");
                }
                if (!(itemFormula = (ItemFormula)cell.getUserObject("ITEM").getValue()).isValidity()) continue;
                String valueType = ValueTypeEnum.getEnum((int)itemFormula.getValueType()).getName().toLowerCase();
                String itemNumber = itemFormula.getItemNumber();
                String dataElementNumber = itemFormula.getDataElementNumber();
                String dyNumber = itemFormula.getDItemNumber();
                if (resultMap.containsKey(valueType)) {
                    ((Map)resultMap.get(valueType)).putAll(itemMap);
                } else {
                    resultMap.put(valueType, itemMap);
                }
                if (itemMap.containsKey(itemNumber)) {
                    ((Map)itemMap.get(itemNumber)).putAll(deMap);
                } else {
                    itemMap.put(itemNumber, deMap);
                }
                if (deMap.containsKey(dataElementNumber)) {
                    ((Map)deMap.get(dataElementNumber)).put(dyNumber, value.toString());
                    continue;
                }
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put(dyNumber, value.toString());
                deMap.put(dataElementNumber, valueMap);
            }
        }
        return resultMap;
    }

    private int getMaxRowIndex(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxRowIndex(); i > top; --i) {
            Cell cell = curSheet.getCell(i, left, false);
            if (cell == null || !this.hasItemFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private int getMaxColIndex(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !this.hasItemFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private boolean hasItemFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = this.getItemFormula(cell);
        return itemCellObj != null;
    }

    private ItemFormula getItemFormula(Cell cell) {
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj;
    }

    private TemplateInfo getTemplateInfo(Context ctx, String rptType, String tmplNumber) throws EASBizException, BOSException {
        int tmplType = 0;
        if (1 == Integer.valueOf(rptType)) {
            tmplType = 6;
        } else if (10 == Integer.valueOf(rptType)) {
            tmplType = 10;
        } else if (3 == Integer.valueOf(rptType)) {
            tmplType = 5;
        }
        return TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo("select id where number = '" + tmplNumber + "' and versionStatus = " + 1 + " and templateType = " + tmplType + " and isK3Tpl = 0");
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String currencyNumber) throws BOSException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select id where number = '" + currencyNumber + "'").get(0);
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, String comNumber) throws EASBizException, BOSException {
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id where number = '" + comNumber + "'");
    }
}

