/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.check.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ElimTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.check.app.AbstractCheckMatrixFacadeControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckMatrixFacadeControllerBean
extends AbstractCheckMatrixFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.check.app.CheckMatrixFacadeControllerBean");

    @Override
    protected Map _getCheckMatrixColAndRow(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        ArrayList<OrgUnitInfo> row = new ArrayList<OrgUnitInfo>();
        ArrayList<OrgUnitInfo> col = new ArrayList<OrgUnitInfo>();
        result.put("row", row);
        result.put("col", col);
        String treeId = param.get("orgTree") != null ? ((OrgTreeInfo)param.get("orgTree")).getId().toString() : null;
        String unitId = param.get("orgUnit") != null ? ((OrgUnitInfo)param.get("orgUnit")).getId().toString() : null;
        SQLBuilder builder = new SQLBuilder();
        builder.append("SELECT unit.FId, unit.FNumber, unit.FName_" + ctx.getLocale() + " unitName FROM T_ORG_Structure s");
        builder.append("  JOIN T_ORG_BaseUnit unit on s.FUnitId = unit.FId");
        builder.append("  JOIN T_ORG_Structure p on s.FParentId = p.FId  ");
        builder.append(" WHERE p.FTreeId = ?", treeId);
        builder.append("   AND p.FUnitId = ?", unitId);
        builder.append("   AND s.FIsLeaf = 1");
        builder.append(" ORDER BY unit.FNumber ");
        IRowSet rs = DbUtil.executeQuery(ctx, builder.getSQL(), builder.getParams());
        try {
            while (rs.next()) {
                OrgUnitInfo unitInfo = new OrgUnitInfo();
                unitInfo.setId(BOSUuid.read((String)rs.getString("FId")));
                unitInfo.setNumber(rs.getString("FNumber"));
                unitInfo.setName(rs.getString("unitName"));
                row.add(unitInfo);
                col.add(unitInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _getCheckMatrix(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null) {
            return null;
        }
        String treeId = param.get("orgTree") != null ? ((OrgTreeInfo)param.get("orgTree")).getId().toString() : null;
        String unitId = param.get("orgUnit") != null ? ((OrgUnitInfo)param.get("orgUnit")).getId().toString() : null;
        int year = param.containsKey("year") ? (Integer)param.get("year") : -1;
        int period = param.containsKey("period") ? (Integer)param.get("period") : -1;
        int periodType = param.containsKey("periodType") ? (Integer)param.get("periodType") : 3;
        int elimType = param.containsKey("matrixType") ? ((ElimTypeEnum)param.get("matrixType")).getValue() : -1;
        Object[] companys = param.containsKey("companys") ? (Object[])param.get("companys") : null;
        boolean isAdjustBefore = param.containsKey("isAdjustBefore") ? (Boolean)param.get("isAdjustBefore") : false;
        HashSet<String> companyIds = new HashSet<String>();
        if (companys != null) {
            for (int i = 0; i < companys.length; ++i) {
                if (companys[i] == null) continue;
                companyIds.add(((OrgUnitInfo)companys[i]).getId().toString());
            }
        }
        String itemDataTable = null;
        String itemDataHeadTable = null;
        if (elimType == 3) {
            if (isAdjustBefore) {
                itemDataTable = "T_CSL_ExchItemData";
            } else {
                itemDataHeadTable = "t_csl_exchcheckage";
                itemDataTable = "t_csl_exchcheckageentry";
            }
        } else if (elimType == 1) {
            if (isAdjustBefore) {
                itemDataTable = "T_CSL_InterItemdata";
            } else {
                itemDataHeadTable = "T_CSL_InterDataCheckage";
                itemDataTable = "T_CSL_DataCheckageEntry";
            }
        } else {
            return null;
        }
        HashSet<String> templateIds = new HashSet<String>();
        if (param.get("templates") != null) {
            Object[] templates;
            for (Object o : templates = (Object[])param.get("templates")) {
                if (o == null) continue;
                templateIds.add(((ElimTempletInfo)o).getId().toString());
            }
        }
        String tempTable = this.getTemplateTable(ctx);
        SQLBuilder builder = new SQLBuilder();
        builder.append(" insert into ").append(tempTable);
        builder.append("  SELECT DISTINCT tempEntry.fitemid, tempEntry.Fdataelement, rptitem.FNUMBER ,tempEntry.Fdc  ");
        builder.append("  FROM T_CSL_ElimTemplet temp                     ");
        builder.append("  JOIN T_CSL_ElimTempletEntry tempEntry           ");
        builder.append("    ON temp.FId = tempEntry.Ftempletid            ");
        builder.append("  JOIN T_CSL_ElimTempletGroup tempGroup           ");
        builder.append("    ON tempGroup.FId = temp.felimgroupid          ");
        builder.append("  JOIN T_CSL_TempletDispense tempDispense         ");
        builder.append("    ON tempGroup.FId = tempDispense.Fdispensesrcid");
        builder.append("  JOIN T_CSL_RptItem rptitem \t\t\t          ");
        builder.append("    ON rptitem.fid = tempentry.fitemid\t\t\t  ");
        builder.append(" WHERE tempDispense.Forgboundid =?", treeId);
        builder.append("   AND tempDispense.FCompanyId =?", unitId);
        builder.append("   AND tempDispense.FSourceType = 2               ");
        builder.append("   AND temp.FCheckedStatus = 2                    ");
        builder.append("   AND temp.FElimType = ?", elimType);
        if (templateIds.size() > 0) {
            builder.append("   AND temp.FId in ", templateIds);
        }
        DbUtil.execute(ctx, builder.getSQL(), builder.getParams());
        String longNumber = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("select longNumber where tree.id='" + treeId + "' and unit.id='" + unitId + "'").getLongNumber();
        ArrayList<String> subLongNumbers = new ArrayList<String>();
        OrgStructureCollection orgCol = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("select longNumber where tree.id='" + treeId + "' and longNumber like'" + longNumber + "!%' and isLeaf = 0");
        if (orgCol != null) {
            for (int i = 0; i < orgCol.size(); ++i) {
                subLongNumbers.add(orgCol.get(i).getLongNumber());
            }
        }
        String l = ctx.getLocale().toString();
        builder.reset();
        builder.append("SELECT interitemdata.FCompanyId,                                                    \n");
        builder.append("       interitemdata.FTargetCompanyId,f.FLongNumber,f.FTargetLongNumber,            \n");
        builder.append("       u1.FName_" + l + " FCompanyName, u2.FName_" + l + " FTargetCompanyName,              \n");
        builder.append("       u1.FSimpleName, u2.FSimpleName FTSimpleName,                    \t\t\t\t\n");
        if (isAdjustBefore) {
            builder.append(" item.Fdc Fdc,sum(interitemdata.FMoney) sumValue                  \t\t\t\t\n");
        } else {
            builder.append(" sum(interitemdata.FVALIDEBIT) sumDebit,sum(interitemdata.FVALICREDIT) sumCredit   \n");
        }
        builder.append("  FROM " + itemDataTable + " interitemdata                                          \n");
        if (isAdjustBefore) {
            builder.append(" INNER JOIN T_CSL_CslReport CSLREPORT                                           \n");
            builder.append("    ON interitemdata.FReport = CslReport.FID                                    \n");
            builder.append(" INNER JOIN ").append(tempTable);
            builder.append(" item ON (item.FItemnumber = interitemdata.FItemNumber\t\t\t\t\t\t\t    \n");
            builder.append(" AND  item.FDataelement = interitemdata.fdataelement   )  \t\t\t\t\t\t    \n");
            builder.append(" INNER JOIN T_CSL_RptReceived RPTRECEIVED                                           \n");
            builder.append("    ON interitemdata.FReport = rptreceived.FReportID         \t                    \n");
        } else {
            builder.append(" INNER JOIN  " + itemDataHeadTable + " itemDataHeadTable                        \n");
            builder.append("    ON interitemdata.fcheckageid = itemDataHeadTable.FID                        \n");
            builder.append(" INNER JOIN t_csl_rptitem rptItem on rptItem.fid=interitemdata.fitemId          \n");
            builder.append(" INNER JOIN ").append(tempTable).append(" item ON \t \n");
            builder.append(" (item.FItemnumber = rptItem.FNumber AND  item.FDataelement = interitemdata.fdataelement )  \n");
        }
        builder.append(" INNER JOIN T_ORG_BaseUnit u1 on u1.FId = interitemdata.FCompanyId                  \n");
        builder.append(" INNER JOIN T_ORG_BaseUnit u2 on u2.FId = interitemdata.FTargetCompanyId            \n");
        builder.append(" INNER JOIN (SELECT f1.FCompanyId,                                                  \n");
        builder.append("                    f1.FLongNumber      FLONGNUMBER,                                \n");
        builder.append("                    f2.FTargetCompanyId,                                            \n");
        builder.append("                    f2.FlongNumber      FTARGETLONGNUMBER                           \n");
        builder.append("               FROM (SELECT t1.FUnitId FCOMPANYID, t1.FLongNumber                   \n");
        builder.append("                       FROM t_org_structure T1                                      \n");
        builder.append("                      INNER JOIN t_org_baseunit T2                                  \n");
        builder.append("                         ON t1.funitid = t2.fid                                     \n");
        builder.append("                      WHERE t2.fisgrouping = 0                                      \n");
        builder.append("                        AND t1.fisleaf = 1                                          \n");
        builder.append("                        AND t1.flongnumber LIKE '" + longNumber + "!%'              \n");
        builder.append("                        AND t1.ftreeid = ?) F1,        \n", treeId);
        builder.append("                    (SELECT t1.FUnitId FTARGETCOMPANYID, t1.FLongNumber             \n");
        builder.append("                       FROM t_org_structure T1                                      \n");
        builder.append("                      INNER JOIN t_org_baseunit T2                                  \n");
        builder.append("                         ON t1.funitid = t2.fid                                     \n");
        builder.append("                      WHERE t2.fisgrouping = 0                                      \n");
        builder.append("                        AND t1.fisleaf = 1                                          \n");
        builder.append("                        AND t1.flongnumber LIKE '" + longNumber + "!%'              \n");
        builder.append("                        AND t1.ftreeid = ?) F2) F      \n", treeId);
        builder.append("    ON (interitemdata.fcompanyid = f.fcompanyid AND                                 \n");
        builder.append("       interitemdata.ftargetcompanyid = f.ftargetcompanyid)                         \n");
        builder.append(" WHERE 1=1                                                    \t\t\t\t\t\t\n");
        if (isAdjustBefore) {
            builder.append("   AND interitemdata.FMoney <> 0                                                    \n");
            builder.append("   AND CslReport.FCommittedStatus = 3                                               \n");
            builder.append("   AND rptreceived.FOrgTreeID = ?\n", treeId);
            builder.append("   AND interitemdata.FYear = ?\n", year);
            builder.append("   AND interitemdata.FPeriod = ?\n", period);
            builder.append("   AND interitemdata.FPeriodType = ?\n", periodType);
            builder.append("   and (interitemdata.forgboundid  =  ?\n", treeId);
            builder.append("   or interitemdata.forgboundid is null )\t\t\t\t\t\t\t\t\t\t\t\n");
        } else {
            builder.append("   AND (interitemdata.FVALICREDIT <> 0 or interitemdata.FVALIDEBIT <> 0 )           \n");
            builder.append("   AND itemDataHeadTable.FYear = ?\n", year);
            builder.append("   AND itemDataHeadTable.FPeriod = ?\n", period);
            builder.append("   AND itemDataHeadTable.FPeriodType = ?\n", periodType);
            builder.append("   and itemDataHeadTable.forgboundid  =  ?\n", treeId);
            builder.append("   and itemDataHeadTable.forgunitid  =  ?\n", unitId);
        }
        if (companyIds.size() > 0) {
            builder.append("   AND interitemdata.FCompanyId IN \n", companyIds);
            builder.append("   AND interitemdata.FTargetCompanyId IN \n", companyIds);
        }
        this.appendComonParentSQL(builder, longNumber, subLongNumbers);
        builder.append(" GROUP BY interitemdata.FCompanyId, interitemdata.FTargetCompanyId,                 \n");
        builder.append("          f.FLongNumber, f.FTargetLongNumber,u1.FName_" + l + ", u2.Fname_" + l + ",\n");
        builder.append("          u1.FSimpleName, u2.FSimpleName                    \t            \t\t\n");
        if (isAdjustBefore) {
            builder.append(" ,item.Fdc HAVING SUM(interitemdata.FMoney) <> 0                                 \n");
        }
        IRowSet rs = DbUtil.executeQuery(ctx, builder.getSQL(), builder.getParams());
        HashMap<String, BigDecimal> sumData = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> difData = new HashMap<String, BigDecimal>();
        ArrayList<CompareCompany> compareCompanies = new ArrayList<CompareCompany>();
        try {
            HashSet<String> orgIds = new HashSet<String>();
            while (rs.next()) {
                String cid = rs.getString("FCompanyId");
                String tcid = rs.getString("FTargetCompanyId");
                String ln = rs.getString("FLongNumber");
                String tln = rs.getString("FTargetLongNumber");
                String name = rs.getString("FCompanyName");
                String tname = rs.getString("FTargetCompanyName");
                String sname = rs.getString("FSimpleName");
                String tsname = rs.getString("FTSimpleName");
                String sumKey = cid + "_" + tcid;
                if (!orgIds.contains(cid)) {
                    compareCompanies.add(new CompareCompany(cid, ln, sname == null ? name : sname));
                    orgIds.add(cid);
                }
                if (!orgIds.contains(tcid)) {
                    compareCompanies.add(new CompareCompany(tcid, tln, tsname == null ? tname : tsname));
                    orgIds.add(tcid);
                }
                BigDecimal sumValue = null;
                if (isAdjustBefore) {
                    sumValue = rs.getBigDecimal("sumValue");
                    int dc = rs.getInt("Fdc");
                    if (dc == 0) {
                        sumValue = sumValue.negate();
                    }
                } else {
                    BigDecimal sumCredit = rs.getBigDecimal("sumCredit");
                    BigDecimal sumDebit = rs.getBigDecimal("sumDebit");
                    sumCredit = sumCredit == null ? BigDecimal.ZERO : sumCredit;
                    sumDebit = sumDebit == null ? BigDecimal.ZERO : sumDebit;
                    sumValue = sumDebit.subtract(sumCredit);
                }
                if (sumData.containsKey(sumKey) && sumData.get(sumKey) != null) {
                    sumValue = sumValue.add((BigDecimal)sumData.get(sumKey));
                }
                sumData.put(sumKey, sumValue);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Collections.sort(compareCompanies, new Comparator<CompareCompany>(){

            @Override
            public int compare(CompareCompany o1, CompareCompany o2) {
                if (o1 instanceof CompareCompany && o2 instanceof CompareCompany) {
                    return o1.ln.compareTo(o2.ln);
                }
                return 0;
            }
        });
        BigDecimal bd = null;
        BigDecimal tbd = null;
        String cid = null;
        String tcid = null;
        for (int i = 0; i < compareCompanies.size(); ++i) {
            cid = ((CompareCompany)compareCompanies.get((int)i)).id;
            CompareCompany cc = (CompareCompany)compareCompanies.get(i);
            for (int j = 0; j < i; ++j) {
                tcid = ((CompareCompany)compareCompanies.get((int)j)).id;
                bd = (BigDecimal)sumData.get(cid + "_" + tcid);
                tbd = (BigDecimal)sumData.get(tcid + "_" + cid);
                if (bd == null && tbd == null) continue;
                bd = bd == null ? BigDecimal.ZERO : bd;
                tbd = tbd == null ? BigDecimal.ZERO : tbd;
                difData.put(cid + "_" + tcid, bd.add(tbd));
            }
        }
        ArrayList<OrgUnitInfo> companyList = new ArrayList<OrgUnitInfo>();
        for (int i = 0; i < compareCompanies.size(); ++i) {
            OrgUnitInfo ou = new OrgUnitInfo();
            ou.setId(BOSUuid.read((String)((CompareCompany)compareCompanies.get((int)i)).id));
            ou.setName(((CompareCompany)compareCompanies.get((int)i)).name);
            companyList.add(ou);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("companys", companyList.toArray());
        result.put("sumData", sumData);
        result.put("difData", difData);
        if (tempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
        return result;
    }

    private String getTemplateTable(Context ctx) throws BOSException {
        String tempTable;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tempTable = pool.createTempTable("create table tempIndexDispensed(FId VARCHAR(44),FDataelement INT, FItemnumber NVARCHAR(80), Fdc INT)");
            pool.createIndex(tempTable, "FId", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    private void appendComonParentSQL(SQLBuilder builder, String longNumber, List subLongNumbers) {
        builder.append(" AND ((LEFT(REPLACE(f.FLongNumber, '" + longNumber + "!', '@#$'), 3) = '@#$') AND (LEFT(REPLACE(f.FTargetLongNumber, '" + longNumber + "!', '@#$'), 3) = '@#$')) \n");
        for (int i = 0; i < subLongNumbers.size(); ++i) {
            longNumber = subLongNumbers.get(i).toString();
            builder.append(" AND ((LEFT(REPLACE(f.FLongNumber, '" + longNumber + "!', '@#$'), 3) <> '@#$') OR (LEFT(REPLACE(f.FTargetLongNumber, '" + longNumber + "!', '@#$'), 3) <> '@#$')) \n");
        }
    }

    private Object[][] getSumData(Context ctx, List companys) throws BOSException, EASBizException {
        int rowCount;
        int colCount = rowCount = companys.size();
        Object[][] data = new Object[colCount][rowCount];
        SQLBuilder builder = new SQLBuilder();
        builder.append("");
        IRowSet rs = DbUtil.executeQuery(ctx, builder.getSQL(), builder.getParams());
        try {
            while (rs.next()) {
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return data;
    }

    private Object[][] getDifData(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    private class CompareCompany {
        String id;
        String ln;
        String name;

        public CompareCompany(String id, String ln, String name) {
            this.id = id;
            this.ln = ln;
            this.name = name;
        }
    }
}

