/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.IPackageQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.QueryManager;
import com.kingdee.bos.ctrl.excel.model.struct.QueryPackage;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.IReportBatchCalculateFacade;
import com.kingdee.eas.fi.newrpt.ReportBatchCalculateFacadeFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.IRptData;
import com.kingdee.eas.fi.rpt.RptDataFactory;
import com.kingdee.eas.fi.rpt.RptDataInfo;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BatchMethodQueryDispatcher
implements IPackageQuery {
    private static final Logger logger = Logger.getLogger(BatchMethodQueryDispatcher.class);
    private final ICalculateContextProvider context;
    private IReportBatchCalculateFacade calculatetub = null;

    public BatchMethodQueryDispatcher(ICalculateContextProvider context) {
        this.context = context;
    }

    public boolean batchQuery(QueryPackage pkg) {
        ArrayList clintNodes = new ArrayList(10);
        if (!pkg.isEmpty()) {
            byte[] bs = pkg.save();
            String[] statistic = this.getMethodNameAndCount(pkg);
            logger.warn((Object)("Report Calculate [Method Name: " + statistic[0] + ",Method Count:" + statistic[1] + ",Package Repuest Size:" + (bs == null ? 0 : bs.length) + "]"));
            try {
                long begin = System.currentTimeMillis();
                IReportBatchCalculateFacade calculateStub = this.getCalculateStub(this.context);
                boolean isRecord = this.isRecordRptData();
                long calcStartTime = 0L;
                logger.info((Object)("[rptData]for client calc,isRecord:" + isRecord));
                BOSUuid rptDataId = BOSUuid.create((BOSObjectType)new RptDataInfo().getBOSType());
                if (isRecord) {
                    long defaultCalcStartTime = 0L;
                    if (this.context.getReportVariables().getStringValue("RptDataId", null) == null || this.context.getReportVariables().getStringValue("ClientCalcStartTime", null) == null || !this.calculatetub.toString().equals(this.context.getReportVariables().getStringValue("CurrCalculatertub", null)) && this.calculatetub.hashCode() != this.context.getReportVariables().getIntValue("CurrCalculatertubHashCode", null, -123) || !Thread.currentThread().toString().equals(this.context.getReportVariables().getStringValue("CurrCalcThread", null))) {
                        rptDataId = BOSUuid.create((BOSObjectType)new RptDataInfo().getBOSType());
                        defaultCalcStartTime = System.currentTimeMillis();
                    } else {
                        rptDataId = BOSUuid.read((String)this.context.getReportVariables().getStringValue("RptDataId", null));
                        defaultCalcStartTime = System.currentTimeMillis();
                    }
                    calcStartTime = this.recordClientStartCalc(rptDataId, this.context, defaultCalcStartTime);
                }
                byte[] out = this.calculateBook(calculateStub, bs);
                long end = System.currentTimeMillis();
                logger.warn((Object)("Report Calculate [Cost Time:" + (end - begin) + ",Package Response Size:" + (out == null ? 0 : out.length) + "]"));
                pkg.load(out);
                if (isRecord) {
                    this.recordClientEndCalc(rptDataId, calcStartTime);
                }
                this.printFormulaLog(pkg);
            }
            catch (Throwable e) {
                logger.error((Object)"Calculate ERROR", e);
            }
        }
        pkg.load(clintNodes);
        return true;
    }

    private void printFormulaLog(QueryPackage pkg) {
        try {
            String sheetName = (String)this.context.getReportAdapter().getReportProperty("curCalcSheetName");
            String debug = this.context.getReportVariables().getStringValue("debug", sheetName);
            if (debug != null && debug.equalsIgnoreCase("true")) {
                QueryManager queryManager = pkg.getQueryManager();
                Field field = QueryManager.class.getDeclaredField("_values");
                NewRptUtil.makeAccessible(field);
                HashMap formulas = (HashMap)field.get(queryManager);
                int i = 0;
                StringBuffer sb = new StringBuffer();
                for (Object obj : formulas.values()) {
                    Parameter param = (Parameter)obj;
                    sb.append(param.getSheetName()).append(":").append(Arrays.toString(param.getArgs())).append("=").append(param.getValue()).append("  ");
                    if (i > 20) {
                        logger.error((Object)sb.toString());
                        sb.setLength(0);
                        i = 0;
                    }
                    ++i;
                }
                if (sb.length() > 0) {
                    logger.error((Object)sb.toString());
                }
            }
        }
        catch (Throwable ex) {
            logger.error((Object)"printFormulaLog error.", ex);
        }
    }

    private boolean isRecordRptData() {
        try {
            if (this.context.getServerContext() != null) {
                return false;
            }
            return CslRptUtil.getCslParam(null, (String)"IsRecordRptData");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return false;
        }
    }

    private long recordClientStartCalc(BOSUuid rptDataId, ICalculateContextProvider context, long defaultCalcStartTime) {
        try {
            logger.info((Object)"[rptData]start client calc");
            context.getReportVariables().remove("isRecordRptData", null);
            context.getReportVariables().remove("ClientCalcStartTime", null);
            context.getReportVariables().remove("RptDataId", null);
            VariableEntry isRecordRptDataVE = new VariableEntry();
            isRecordRptDataVE.setName("isRecordRptData");
            isRecordRptDataVE.setValue(Boolean.TRUE.toString());
            long calcStartTime = defaultCalcStartTime;
            VariableEntry calcStartTimeVE = new VariableEntry();
            calcStartTimeVE.setName("ClientCalcStartTime");
            calcStartTimeVE.setValue("" + calcStartTime);
            VariableEntry currRptDataIdVE = new VariableEntry();
            currRptDataIdVE.setName("RptDataId");
            currRptDataIdVE.setValue(rptDataId.toString());
            VariableEntry currCurrCalculatertubVE = new VariableEntry();
            currCurrCalculatertubVE.setName("CurrCalculatertub");
            currCurrCalculatertubVE.setValue(this.calculatetub.toString());
            VariableEntry currCurrCalculatertubHashCodeVE = new VariableEntry();
            currCurrCalculatertubHashCodeVE.setName("CurrCalculatertubHashCode");
            currCurrCalculatertubHashCodeVE.setValue(this.calculatetub.hashCode() + "");
            VariableEntry currCurrCalcThreadVE = new VariableEntry();
            currCurrCalcThreadVE.setName("CurrCalcThread");
            currCurrCalcThreadVE.setValue(Thread.currentThread().toString());
            context.getReportVariables().remove("isRecordRptData", null);
            context.getReportVariables().remove("ClientCalcStartTime", null);
            context.getReportVariables().remove("RptDataId", null);
            context.getReportVariables().remove("CurrCalculatertub", null);
            context.getReportVariables().remove("CurrCalculatertubHashCode", null);
            context.getReportVariables().remove("CurrCalcThread", null);
            context.getReportVariables().add(new VariableEntry[]{isRecordRptDataVE, calcStartTimeVE, currRptDataIdVE, currCurrCalculatertubVE, currCurrCalculatertubHashCodeVE, currCurrCalcThreadVE});
            return calcStartTime;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return 0L;
        }
    }

    private void recordClientEndCalc(BOSUuid rptDataId, long calcStartTime) {
        try {
            if (this.context.getServerContext() != null) {
                return;
            }
            RptDataInfo updateRptDataInfo = new RptDataInfo();
            updateRptDataInfo.setId(rptDataId);
            updateRptDataInfo.setCalcFinishTime(System.currentTimeMillis() - calcStartTime);
            SelectorItemCollection updateFields = new SelectorItemCollection();
            updateFields.add("calcFinishTime");
            IRptData rptDataDao = RptDataFactory.getRemoteInstance();
            RptDataInfo oldInfo = (RptDataInfo)rptDataDao.getValue((IObjectPK)new ObjectUuidPK(rptDataId.toString()));
            if (oldInfo != null && oldInfo.getCalcFinishTime() != Long.MAX_VALUE) {
                updateRptDataInfo.setCalcFinishTime(updateRptDataInfo.getCalcFinishTime() + oldInfo.getCalcFinishTime());
            }
            rptDataDao.updatePartial((CoreBaseInfo)updateRptDataInfo, updateFields);
            logger.info((Object)("[rptData]id:" + rptDataId));
            logger.info((Object)("[rptData]CalcFinishTime:" + updateRptDataInfo.getCalcFinishTime()));
            logger.info((Object)"[rptData]end client calc");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private String[] getMethodNameAndCount(QueryPackage pkg) {
        int ret = 0;
        HashSet<String> methodName = new HashSet<String>();
        String[] msg = new String[2];
        for (QueryPackage.Node node : pkg) {
            ++ret;
            methodName.add(node.getMethodName());
        }
        msg[0] = ((Object)methodName).toString();
        msg[1] = "" + ret;
        return msg;
    }

    public byte[] getReConnectCalcResult(IReportPropertyAdapter adapter, IReportBatchCalculateFacade calculateStub, String rptSessionId) throws Exception {
        byte[] out = null;
        out = calculateStub.batchMethodQuery(adapter, null, null, null);
        this.setRptPropertyAdapter(adapter, "isFirstReconnect", false);
        long reGetSubTime = 120000L;
        long totleTime = 0L;
        while (out == null) {
            Thread.sleep(10000L);
            if ((totleTime += 10000L) >= reGetSubTime) {
                calculateStub = this.getCalculateStub(this.context);
                totleTime = 0L;
            }
            out = calculateStub.batchMethodQuery(adapter, null, null, null);
        }
        return out;
    }

    private byte[] calculateBook(IReportBatchCalculateFacade calculateStub, byte[] bs) throws Exception {
        boolean isRpt;
        boolean isUserNewCalculate = false;
        if (this.context.getServerContext() == null) {
            isUserNewCalculate = CSLParamUtil.getBooleanCslParamValue(null, (String)"KEY_CSLPARAM_CalculateUserNew");
        }
        byte[] out = null;
        IReportPropertyAdapter rptPropertyAdapter = this.context.getReportAdapter();
        boolean bl = isRpt = rptPropertyAdapter instanceof RptReportPropertyAdapter || rptPropertyAdapter instanceof CSLPropertyAdapter;
        if (isUserNewCalculate && isRpt) {
            String rptSessionId = InetAddress.getLocalHost().getHostAddress() + System.currentTimeMillis();
            calculateNewThread calcThread = new calculateNewThread(out, rptSessionId, calculateStub, bs);
            calcThread.start();
            long timeOut = 55000L;
            for (long executeTime = 0L; calcThread.getOut() == null && executeTime < timeOut && !calcThread.isRunEnd; executeTime += 200L) {
                Thread.sleep(200L);
            }
            while (calcThread.getOut() == null && calcThread.isReConnect && !calcThread.isRunEnd) {
                Thread.sleep(200L);
            }
            if (calcThread.isRunEnd) {
                out = calcThread.getOut();
            } else if (!(calcThread.isRunEnd || calcThread.isReConnect || calcThread.isException)) {
                try {
                    boolean isSucc = this.setRptPropertyAdapter(rptPropertyAdapter, "isFirstReconnect", true);
                    boolean bl2 = isSucc = isSucc && this.setRptPropertyAdapter(rptPropertyAdapter, "rptSessionId", rptSessionId);
                    if (isSucc) {
                        out = this.getReConnectCalcResult(rptPropertyAdapter, calculateStub, rptSessionId);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"calculateBook reCalculate error.", (Throwable)ex);
                }
            }
            if (calcThread.isRunEnd) {
                out = calcThread.getOut();
            }
        } else {
            out = calculateStub.batchMethodQuery(this.context.getReportAdapter(), this.context.getReportVariables(), this.context.getErrorProvider(), bs);
        }
        if (out != null && out.length == 0) {
            return null;
        }
        return out;
    }

    private boolean setRptPropertyAdapter(IReportPropertyAdapter adapter, String key, Object value) throws Exception {
        if (adapter != null) {
            if (adapter instanceof RptReportPropertyAdapter) {
                ((RptReportPropertyAdapter)adapter).setExtraProperty(key, value);
                return true;
            }
            if (adapter instanceof CSLPropertyAdapter) {
                ((CSLPropertyAdapter)adapter).setExtraProperty(key, value);
                return true;
            }
        }
        return false;
    }

    private IReportBatchCalculateFacade getCalculateStub(ICalculateContextProvider context) throws BOSException {
        if (this.calculatetub == null) {
            this.calculatetub = context.getServerContext() == null ? ReportBatchCalculateFacadeFactory.getRemoteInstance() : ReportBatchCalculateFacadeFactory.getLocalInstance(context.getServerContext());
        }
        return this.calculatetub;
    }

    public class calculateNewThread
    extends Thread {
        byte[] out = null;
        String rptSessionId = null;
        IReportBatchCalculateFacade calculateStub = null;
        byte[] bs = null;
        boolean isException = false;
        boolean isReConnect = false;
        boolean isRunEnd = false;

        public calculateNewThread(byte[] out, String rptSessionId, IReportBatchCalculateFacade calculateStub, byte[] bs) {
            this.out = out;
            this.rptSessionId = rptSessionId;
            this.calculateStub = calculateStub;
            this.bs = bs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: {
                IReportPropertyAdapter rptPropertyAdapter = BatchMethodQueryDispatcher.this.context.getReportAdapter();
                try {
                    BatchMethodQueryDispatcher.this.setRptPropertyAdapter(rptPropertyAdapter, "rptSessionId", this.rptSessionId);
                    BatchMethodQueryDispatcher.this.setRptPropertyAdapter(rptPropertyAdapter, "isFirstReconnect", null);
                    this.out = this.calculateStub.batchMethodQuery(rptPropertyAdapter, BatchMethodQueryDispatcher.this.context.getReportVariables(), BatchMethodQueryDispatcher.this.context.getErrorProvider(), this.bs);
                }
                catch (Exception ex) {
                    logger.error((Object)"batchMethodQuery error.", (Throwable)ex);
                    try {
                        boolean isSucc = BatchMethodQueryDispatcher.this.setRptPropertyAdapter(rptPropertyAdapter, "isFirstReconnect", true);
                        boolean bl = isSucc = isSucc && BatchMethodQueryDispatcher.this.setRptPropertyAdapter(rptPropertyAdapter, "rptSessionId", this.rptSessionId);
                        if (isSucc) {
                            this.isReConnect = true;
                            this.out = BatchMethodQueryDispatcher.this.getReConnectCalcResult(rptPropertyAdapter, this.calculateStub, this.rptSessionId);
                            break block8;
                        }
                        this.isException = true;
                    }
                    catch (Exception ex1) {
                        this.isException = true;
                        logger.error((Object)"reBatchMethodQuery error.", (Throwable)ex1);
                    }
                }
                finally {
                    this.isRunEnd = true;
                }
            }
        }

        public byte[] getOut() {
            return this.out;
        }
    }
}

