/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formula.define;

import com.kingdee.bos.ctrl.excel.impl.FunctionRegister;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.FunctionManager;
import com.kingdee.bos.ctrl.excel.model.struct.IPackageQuery;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.BatchMethodQueryDispatcher;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaImplClassLoader;
import com.kingdee.eas.fi.newrpt.formula.define.RptFormulaInfoFile;
import com.kingdee.eas.fi.newrpt.formula.define.RptFormulaSourceFactory;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;

public class FormulaDefinition {
    private static final Logger logger = Logger.getLogger(FormulaDefinition.class);
    private static FormulaDefinition define = null;
    private static List implClass = new ArrayList();
    private static List batchImplClass = new ArrayList();
    private static final Object lock = new Object();

    private FormulaDefinition() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormulaDefinition getInstance() throws Exception {
        Object object = lock;
        synchronized (object) {
            if (define == null) {
                define = new FormulaDefinition();
                FormulaDefinition.load();
            }
            return define;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() throws Exception {
        List list = RptFormulaSourceFactory.getInstance().getFormulaFileResource();
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("formulas_declaration", FormulaImplClassLoader.class);
        digester.addSetProperties("formulas_declaration");
        digester.addCallMethod("formulas_declaration/defaultImplClass", "addImplClass", 0);
        digester.addCallMethod("formulas_declaration/defaultBatchImplClass", "addBatchImplClass", 0);
        digester.addCallMethod("formulas_declaration/formulas/formula/implClass", "addImplClass", 0);
        digester.addCallMethod("formulas_declaration/formulas/formula/batchImplClass", "addBatchImplClass", 0);
        for (int i = 0; i < list.size(); ++i) {
            RptFormulaInfoFile file = null;
            InputStream in = null;
            try {
                file = (RptFormulaInfoFile)list.get(i);
                if (!file.touch()) continue;
                file.open();
                in = file.getByteStream();
                Object obj = digester.parse(in);
                if (obj != null) {
                    Object cname;
                    int j;
                    FormulaImplClassLoader fd = (FormulaImplClassLoader)obj;
                    List lst = fd.getImplClass();
                    for (j = 0; j < lst.size(); ++j) {
                        cname = lst.get(j);
                        if (implClass.contains(cname)) continue;
                        implClass.add(cname);
                    }
                    lst = fd.getBatchImplClass();
                    for (j = 0; j < lst.size(); ++j) {
                        cname = lst.get(j);
                        if (batchImplClass.contains(cname)) continue;
                        batchImplClass.add(cname);
                    }
                }
                file.close();
                continue;
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"file error.", (Throwable)e);
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"in error.", (Throwable)e);
                    }
                }
            }
        }
    }

    public List getImplClass() {
        return implClass;
    }

    public List getBatchImplClass() {
        return batchImplClass;
    }

    public static void registerFormulaToSpreadContainer(SpreadContext container, ICalculateContextProvider context) throws Exception {
        FunctionRegister functionRegister = container.getFunctionRegister();
        boolean isAddFunctionProvider = false;
        List implClass = FormulaDefinition.getInstance().getImplClass();
        for (int i = 0; i < implClass.size(); ++i) {
            String cname = (String)implClass.get(i);
            Object obj = null;
            try {
                Class<?> clazz = Class.forName(cname);
                obj = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.info((Object)e.getStackTrace(), (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                logger.info((Object)e.getStackTrace(), (Throwable)e);
                continue;
            }
            if (obj instanceof ICalculator) {
                ((ICalculator)obj).initCalculateContext(context);
            }
            FormulaDefinition.addFunctionProvider(functionRegister, obj);
            isAddFunctionProvider = true;
        }
        List batchImplClass = FormulaDefinition.getInstance().getBatchImplClass();
        for (int i = 0; i < batchImplClass.size(); ++i) {
            String cname = (String)batchImplClass.get(i);
            Object obj = null;
            try {
                Class<?> clazz = Class.forName(cname);
                obj = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.info((Object)e.getStackTrace(), (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                logger.info((Object)e.getStackTrace(), (Throwable)e);
                continue;
            }
            if (obj instanceof ICalculator) {
                ((ICalculator)obj).initCalculateContext(context);
            }
            isAddFunctionProvider = true;
            FormulaDefinition.addFunctionProvider(functionRegister, obj);
        }
        if (isAddFunctionProvider && container.getBook() != null) {
            container.getBook().resumeUnknownMethod();
        }
        functionRegister.setErrorResultProvider(context.getErrorResultProvider());
        functionRegister.addFillParameter("acct", 8);
        functionRegister.addFillParameter("csRef", 10);
        functionRegister.addFillParameter("refm", 9);
        ReportCalculateErrorProvider errorProvider = BookProperties.loadFromBook((Book)container.getBook()).getErrorProvider();
        if (errorProvider != null) {
            functionRegister.addFunctionErrorProvider(Exception.class, (IErrorProvider)errorProvider);
        }
        functionRegister.setPackageListener((IPackageQuery)new BatchMethodQueryDispatcher(context));
    }

    public static void addFunctionProvider(FunctionRegister functionRegister, Object provider) throws Exception {
        if (functionRegister != null && provider != null) {
            Field funcProvsField = FunctionRegister.class.getDeclaredField("_funcProvs");
            NewRptUtil.makeAccessible(funcProvsField);
            ArrayList _funcProvs = (ArrayList)funcProvsField.get(functionRegister);
            _funcProvs.add(provider);
            functionRegister.getFunctionManager().addFunctionProvider(provider, false);
        }
    }

    public static void registerFormulaToBook(Book book, ICalculateContextProvider context) throws Exception {
        boolean isLocalCalculate = context.getServerContext() != null;
        FunctionManager fm = book.getDeps().getFunctionManager();
        List implClass = FormulaDefinition.getInstance().getImplClass();
        for (int i = 0; i < implClass.size(); ++i) {
            String cname = (String)implClass.get(i);
            Object obj = null;
            try {
                Class<?> clazz = Class.forName(cname);
                obj = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.info((Object)e.getStackTrace(), (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                logger.info((Object)e.getStackTrace(), (Throwable)e);
                continue;
            }
            if (obj instanceof ICalculator) {
                ((ICalculator)obj).initCalculateContext(context);
            }
            fm.addFunctionProvider(obj, isLocalCalculate);
        }
        List batchImplClass = FormulaDefinition.getInstance().getBatchImplClass();
        for (int i = 0; i < batchImplClass.size(); ++i) {
            String cname = (String)batchImplClass.get(i);
            Object obj = null;
            try {
                Class<?> clazz = Class.forName(cname);
                obj = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.info((Object)e.getStackTrace(), (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                logger.info((Object)e.getStackTrace(), (Throwable)e);
                continue;
            }
            if (obj instanceof ICalculator) {
                ((ICalculator)obj).initCalculateContext(context);
            }
            fm.addFunctionProvider(obj, isLocalCalculate);
        }
        ReportCalculateErrorProvider errorProvider = BookProperties.loadFromBook((Book)book).getErrorProvider();
        book.getDeps().getFunctionManager().setErrorResultProvider(context.getErrorResultProvider());
        if (errorProvider != null) {
            book.getDeps().getFunctionManager().setErrorProvider(Exception.class, (IErrorProvider)errorProvider);
        }
        if (!isLocalCalculate) {
            book.getDeps().getQueryManager().setPackageListener((IPackageQuery)new BatchMethodQueryDispatcher(context));
        } else {
            ReportCalculateErrorProvider.addErrorProvider(EASBizException.class, (IErrorProvider)errorProvider);
        }
    }
}

