/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formulasolu.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluItemListCollection;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluItemListInfo;
import com.kingdee.eas.fi.newrpt.formulasolu.app.AbstractFormulaSoluItemListControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FormulaSoluItemListControllerBean
extends AbstractFormulaSoluItemListControllerBean {
    private static final long serialVersionUID = 2358894968370326113L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.formulasolu.app.FormulaSoluItemListControllerBean");

    @Override
    protected boolean _batchAddFormulaSoluItemList(Context ctx, FormulaSoluItemListCollection formulaSoluItemList, boolean needCheck) throws BOSException, EASBizException {
        if (formulaSoluItemList.size() == 0) {
            return true;
        }
        String formulaSoluid = formulaSoluItemList.get(0).getFormulaSolu().getId().toString();
        StringBuffer tips = new StringBuffer();
        if (needCheck && this.checkItemFormulaInOtherDisSolu(ctx, formulaSoluid, formulaSoluItemList, tips)) {
            throw new EASBizException(new NumericExceptionSubItem("002", tips.toString()));
        }
        this.clearFormulaSoluItemList(ctx, formulaSoluid);
        String SQL = " INSERT INTO T_CSL_FormulaSoluItemList (FID, FformulaSoluID, FItemFormula, Fformula, FSheetID, FPosX, FPosY,FSheetType) values (?,?,?,?,?,?,?,?)";
        Connection cn = null;
        PreparedStatement st = null;
        try {
            cn = super.getConnection(ctx);
            st = cn.prepareStatement(SQL);
            int count = 0;
            int size = formulaSoluItemList.size();
            Iterator it = formulaSoluItemList.iterator();
            while (it.hasNext()) {
                ++count;
                FormulaSoluItemListInfo info = (FormulaSoluItemListInfo)it.next();
                if (info.getFormula() == null || info.getFormula().length() == 0) continue;
                st.setString(1, BOSUuid.create((String)"7BE47B1A").toString());
                st.setString(2, info.getFormulaSolu().getId().toString());
                st.setString(3, info.getItemFormula());
                st.setString(4, info.getFormula());
                st.setString(5, info.getSheetID());
                st.setInt(6, info.getPosX());
                st.setInt(7, info.getPosY());
                st.setInt(8, info.getSheetType());
                st.addBatch();
                if (count % 1000 != 0 && count != size) continue;
                st.executeBatch();
                st.clearBatch();
            }
        }
        catch (SQLException e2) {
            try {
                throw new SQLDataException(e2);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(st, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)st, (Connection)cn);
        return true;
    }

    private boolean checkItemFormulaInOtherDisSolu(Context ctx, String formulaSoluId, FormulaSoluItemListCollection formulaSoluItemList, StringBuffer tips) {
        Object[] param = new Object[formulaSoluItemList.size() + 2];
        param[0] = formulaSoluId;
        int itemCount = formulaSoluItemList.size();
        StringBuffer sql = new StringBuffer("select solu.fname_");
        sql.append(ctx.getLocale()).append(" soluName,targItemList.FItemFormula itemFormula,unit.fname_").append(ctx.getLocale()).append(" unitName \n");
        sql.append("from T_CSL_FormulaSolu solu \n");
        sql.append("join T_CSL_FormulaSoluItemList srcItemList on solu.fid=srcItemList.FformulaSoluID \n");
        sql.append("join T_CSL_FormulaSoluItemList targItemList on srcItemList.FItemFormula=targItemList.FItemFormula \n");
        sql.append(" and srcItemList.Fformulasoluid<>targItemList.Fformulasoluid and srcItemList.fSheetType=targItemList.fSheetType \n");
        sql.append("join T_Csl_FormulaSoluDispense dis on solu.fid=dis.FFormulaSoluId \n");
        sql.append("join t_org_baseunit unit on unit.fid=dis.FCompanyId \n");
        sql.append("where solu.fid <>? and srcItemList.FItemFormula in(");
        for (int i = 0; i < itemCount; ++i) {
            sql.append("?");
            param[i + 1] = formulaSoluItemList.get(i).getItemFormula();
            if (itemCount == i + 1) continue;
            sql.append(",");
        }
        sql.append(") \n");
        sql.append("and dis.FCompanyId in(select FCompanyId from T_Csl_FormulaSoluDispense where FFormulaSoluId =?)");
        param[formulaSoluItemList.size() + 1] = formulaSoluId;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (rs.next()) {
                String soluName = rs.getString("soluName");
                String itemFormula = rs.getString("itemFormula");
                String unitName = rs.getString("unitName");
                tips.append(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"26_itemFormulaDisOrg", (Locale)ctx.getOriginLocale()), soluName, itemFormula, unitName)).append("\n");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"save formulasolu check ItemFormula In Other Dispense error", (Throwable)e);
            tips.append(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"27_saveError", (Locale)ctx.getOriginLocale()));
        }
        return tips.length() > 0;
    }

    private void clearFormulaSoluItemList(Context ctx, String formulaSoluid) throws SQLDataException {
        Connection cn = super.getConnection(ctx);
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Delete From T_CSL_FormulaSoluItemList Where FformulaSoluID =?");
        PreparedStatement stmt = null;
        int index = 1;
        try {
            stmt = cn.prepareStatement(strSQL.toString());
            stmt.setString(index++, formulaSoluid);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        }
    }
}

