/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.investworkpaper.ITriggerConditionInterface;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class TarCompanyCuYearChangeInTree
implements ITriggerConditionInterface {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.investworkpaper.util.TarCompanyCuYearChangeInTree");

    @Override
    public boolean execute(Context ctx, Map params) throws BOSException, EASBizException {
        String orgTreeNumber = (String)params.get("orgTreeNumber");
        String tarCompanyNumreg = (String)params.get("tarCompanyNum");
        int year = (Integer)params.get("year");
        short period = (Short)params.get("period");
        Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
        Timestamp lastTime = new Timestamp(periodLastDate.getTime());
        Object[] param = new Object[]{orgTreeNumber, lastTime, tarCompanyNumreg};
        StringBuilder sql = new StringBuilder();
        sql.append("select struct.Flongnumber structLongNumber,tree.FSTARTDATE treeStartDate,tree.FENDDATE treeEndDate from T_ORG_Structure struct     \t\n");
        sql.append("inner join T_ORG_BaseUnit unit on unit.Fid=struct.FUnitId \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\n");
        sql.append("inner join T_ORG_Tree tree on  tree.FId=struct.FTreeId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\n");
        sql.append("where tree.ftype = 8 and tree.Fnumber = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  \t\t\n");
        sql.append("and tree.FSTARTDATE <= ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  \t\t\t             \t\t\t\t\n");
        sql.append("and unit.Fnumber = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  \t\t\t  \t  \t         \t\t\t\t\n");
        sql.append("order by tree.FSTARTDATE desc\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  \t\t\t  \t  \t         \t\t\t\t\n");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), param);
        try {
            String preStructLongNumber = "";
            String structLongNumber = "";
            int rsStartYear = -1;
            int rsStartPeriod = -1;
            int preStartPeriod = -1;
            while (rs.next()) {
                structLongNumber = rs.getString("structLongNumber");
                Timestamp startTime = rs.getTimestamp("treeStartDate");
                Date date = new Date(startTime.getTime());
                rsStartYear = DateTimeUtils.getYear((Date)date);
                rsStartPeriod = DateTimeUtils.getMonth((Date)date);
                if (rsStartYear == year) {
                    if (preStartPeriod == rsStartPeriod) continue;
                    preStartPeriod = rsStartPeriod;
                    if (!"".equals(preStructLongNumber) && !preStructLongNumber.equals(structLongNumber)) {
                        return true;
                    }
                    preStructLongNumber = structLongNumber;
                    continue;
                }
                return !preStructLongNumber.equals(structLongNumber);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("TarCompanyCuYearChangeInTree_execute_error:" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

