/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqiInterface.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.QualityOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.app.AbstractRptLogControllerBean;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.util.EntityViewHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class RptLogControllerBean
extends AbstractRptLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.app.RptLogControllerBean");

    @Override
    protected OrgUnitInfo[] _getAuthorizedBizOrgUnits(Context ctx, OrgType orgType, String permissionItem) throws BOSException, EASBizException {
        return this.getXTypeBizOrg(ctx, orgType, permissionItem, false);
    }

    private OrgUnitInfo[] getXTypeBizOrg(Context ctx, OrgType orgType, String permissionItem, boolean isBizUnit) throws EASBizException, BOSException {
        OrgUnitCollection collection = null;
        if (permissionItem != null) {
            collection = RptLogControllerBean.getAuthOrgByPermItem(ctx, orgType, permissionItem);
        } else if (isBizUnit) {
            EntityViewInfo ev = new EntityViewInfo();
            ev.getSelector().add("id");
            collection = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitCollection(ev);
        } else {
            collection = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitCollection();
        }
        OrgUnitCollection bizOrgs = RptLogControllerBean.getOrgUnitInfosByType(ctx, collection, orgType, isBizUnit);
        if (bizOrgs == null) {
            return null;
        }
        int size = bizOrgs.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = bizOrgs.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)context);
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(context.getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public static OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType, boolean isBizUnit) throws BOSException, EASBizException {
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewHelper.EntityViewer viewer = EntityViewHelper.from().sort("number").include("id", keys);
        if (!orgType.equals((Object)OrgType.Admin) && !orgType.equals((Object)OrgType.ControlUnit) && isBizUnit) {
            viewer.equal("isBizUnit", new Boolean(true));
        }
        viewer.select("*").select("parent.*");
        EntityViewInfo view = viewer.entityViewInfo();
        try {
            switch (orgType.getValue()) {
                case 0: {
                    return RptLogControllerBean.buildResults((AbstractBaseObjectCollection)AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view));
                }
                case 1: {
                    return RptLogControllerBean.buildResults((AbstractBaseObjectCollection)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view));
                }
                case 2: {
                    return RptLogControllerBean.buildResults((AbstractBaseObjectCollection)SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitCollection(view));
                }
                case 3: {
                    return RptLogControllerBean.buildResults((AbstractBaseObjectCollection)PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitCollection(view));
                }
                case 4: {
                    return RptLogControllerBean.buildResults((AbstractBaseObjectCollection)StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view));
                }
                case 10: {
                    return RptLogControllerBean.buildResults((AbstractBaseObjectCollection)CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(view));
                }
                case 24: {
                    return RptLogControllerBean.buildResults((AbstractBaseObjectCollection)TransportOrgUnitFactory.getLocalInstance((Context)ctx).getTransportOrgUnitCollection(view));
                }
                case 32: {
                    return RptLogControllerBean.buildResults((AbstractBaseObjectCollection)QualityOrgUnitFactory.getLocalInstance((Context)ctx).getQualityOrgUnitCollection(view));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private static OrgUnitCollection buildResults(AbstractBaseObjectCollection collection) {
        OrgUnitCollection results = new OrgUnitCollection();
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                results.add((OrgUnitInfo)collection.getObject(i));
            }
        }
        return results;
    }

    @Override
    protected OrgUnitInfo[] _getOrgUnits(Context ctx, String permissionItem, String userID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select forgId from T_PM_UserRoleOrg \n");
        sql.append(" where fuserid = '" + userID + "' \n");
        sql.append(" and froleid in(select rp.froleid from T_PM_RolePerm rp \n");
        sql.append(" inner join T_PM_PermItem pi on rp.fpermitemid = pi.fid \n");
        sql.append(" where pi.fnumber = '" + permissionItem + "') \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        OrgUnitInfo[] results = new OrgUnitInfo[rs.size()];
        int i = 0;
        try {
            while (rs.next()) {
                String orgId = rs.getString("forgId");
                OrgUnitInfo org = new OrgUnitInfo();
                org.setId(BOSUuid.read((String)orgId));
                results[i] = org;
                ++i;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return results;
    }
}

