/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqiInterface.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.script.miniscript.exec.Logger;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class EntityViewHelper {
    public static EntityViewer from(EntityViewInfo info) {
        if (info == null) {
            return EntityViewHelper.from();
        }
        return new EntityViewer(info);
    }

    public static EntityViewer from() {
        return new EntityViewer();
    }

    public static EntityViewer from(KDBizPromptBox prompt) {
        EntityViewInfo info = prompt.getEntityViewInfo();
        if (info == null) {
            info = new EntityViewInfo();
            prompt.setEntityViewInfo(info);
        }
        return new EntityViewer(info);
    }

    public static EntityViewer from(String oql) {
        return new EntityViewer(oql);
    }

    public static class EntityViewer {
        EntityViewInfo info = null;
        int top = -1;

        EntityViewer() {
            this.checkEntityViewInfo();
        }

        EntityViewer(String oql) {
            try {
                this.info = new EntityViewInfo(oql);
            }
            catch (ParserException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        EntityViewer(EntityViewInfo info) {
            this.info = info;
        }

        public EntityViewer top(int count) {
            this.top = count;
            return this;
        }

        private void checkEntityViewInfo() {
            if (this.info == null) {
                this.info = new EntityViewInfo();
            }
        }

        public EntityViewer clear() {
            this.clearSelector();
            this.clearSorter();
            this.clearFilter();
            return this;
        }

        public EntityViewer clearSelector() {
            this.checkEntityViewInfo();
            this.info.getSelector().clear();
            return this;
        }

        public EntityViewer clearSorter() {
            this.checkEntityViewInfo();
            this.info.getSorter().clear();
            return this;
        }

        public EntityViewer clearFilter() {
            this.checkEntityViewInfo();
            if (this.info.getFilter() != null) {
                FilterInfo filterInfo = this.info.getFilter();
                filterInfo.getFilterItems().clear();
                filterInfo.setMaskString(null);
            }
            return this;
        }

        public EntityViewer filter(String field, Object value) {
            return this.filter(field, value, CompareType.EQUALS);
        }

        public EntityViewer filter(String field, Set set) {
            return this.filter(field, set, CompareType.INCLUDE);
        }

        public EntityViewer filter(String field, Object[] values) {
            return this.filter(field, values, CompareType.INCLUDE);
        }

        public EntityViewer filter(String field, List list) {
            return this.filter(field, list, CompareType.INCLUDE);
        }

        public EntityViewer include(String field, Set set) {
            return this.filter(field, set, CompareType.INCLUDE);
        }

        public EntityViewer include(String field, Object[] values) {
            return this.filter(field, values, CompareType.INCLUDE);
        }

        public EntityViewer include(String field, List list) {
            return this.filter(field, list, CompareType.INCLUDE);
        }

        public EntityViewer notInclude(String field, Set set) {
            return this.filter(field, set, CompareType.NOTINCLUDE);
        }

        public EntityViewer notInclude(String field, Object[] values) {
            return this.filter(field, values, CompareType.NOTINCLUDE);
        }

        public EntityViewer notInclude(String field, List list) {
            return this.filter(field, list, CompareType.NOTINCLUDE);
        }

        private EntityViewer filter(String field, List list, CompareType type) {
            HashSet set = new HashSet();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                set.add(it.next());
            }
            return this.filter(field, set, type);
        }

        private EntityViewer filter(String field, Object[] values, CompareType type) {
            HashSet<Object> set = new HashSet<Object>();
            for (int i = 0; i < values.length; ++i) {
                set.add(values[i]);
            }
            return this.filter(field, set, type);
        }

        public EntityViewer inner(String field, Object value) {
            return this.filter(field, value, CompareType.INNER);
        }

        public EntityViewer notInner(String field, Object value) {
            return this.filter(field, value, CompareType.NOTINNER);
        }

        public EntityViewer empty(String field) {
            return this.filter(field, CompareType.EMPTY);
        }

        public EntityViewer notEmpty(String field) {
            return this.filter(field, CompareType.NOTEMPTY);
        }

        public EntityViewer is(String field, Object value) {
            return this.filter(field, value, CompareType.IS);
        }

        public EntityViewer isNot(String field, Object value) {
            return this.filter(field, value, CompareType.ISNOT);
        }

        private EntityViewer filter(String field, CompareType type) {
            this.checkFitler();
            this.info.getFilter().getFilterItems().add(new FilterItemInfo(field, null, type));
            return this;
        }

        public EntityViewer equal(String field, Object value) {
            return this.filter(field, value, CompareType.EQUALS);
        }

        public EntityViewer notEqual(String field, Object value) {
            return this.filter(field, value, CompareType.NOTEQUALS);
        }

        public EntityViewer greater(String field, Object value) {
            return this.filter(field, value, CompareType.GREATER);
        }

        public EntityViewer greaterEqual(String field, Object value) {
            return this.filter(field, value, CompareType.GREATER_EQUALS);
        }

        public EntityViewer less(String field, Object value) {
            return this.filter(field, value, CompareType.LESS);
        }

        public EntityViewer lessEqual(String field, Object value) {
            return this.filter(field, value, CompareType.LESS_EQUALS);
        }

        public EntityViewer like(String field, Object value) {
            return this.filter(field, value, CompareType.LIKE);
        }

        public EntityViewer notLike(String field, Object value) {
            return this.filter(field, value, CompareType.NOTLIKE);
        }

        public EntityViewer filter(String field, Object value, CompareType type) {
            this.checkFitler();
            this.info.getFilter().getFilterItems().add(new FilterItemInfo(field, value, type));
            return this;
        }

        public EntityViewer maskString(String maskString) {
            this.checkFitler();
            this.info.getFilter().setMaskString(maskString);
            return this;
        }

        public String maskString() {
            this.checkFitler();
            return this.info.getFilter().getMaskString();
        }

        private void checkFitler() {
            this.checkEntityViewInfo();
            if (this.info.getFilter() == null) {
                this.info.setFilter(new FilterInfo());
            }
        }

        public EntityViewer mergeFilter(FilterInfo filter, String logic) throws BOSException {
            String otherMaskString;
            this.checkFitler();
            if (filter == null || logic == null || "".equals(logic)) {
                Logger.warn((Object)"Filter or logic is null when invoke EntityViewer.megerFilter ");
                return this;
            }
            this.info.getFilter().mergeFilter(filter, logic);
            String oldMaskString = this.info.getFilter().getMaskString();
            if (oldMaskString != null && !"".equals(oldMaskString.trim()) && (otherMaskString = filter.getMaskString()) != null && !"".equals(otherMaskString.trim())) {
                String newMaskString = oldMaskString + " " + logic + " " + otherMaskString;
                this.info.getFilter().setMaskString(newMaskString);
            }
            return this;
        }

        public EntityViewer select(String field) {
            return this.select(new String[][]{{field}});
        }

        public EntityViewer select(String field, String alias) {
            return this.select(new String[][]{{field, alias}});
        }

        public EntityViewer select(String[][] selectors) {
            this.checkSelector();
            for (int i = 0; i < selectors.length; ++i) {
                this.info.getSelector().add(new SelectorItemInfo(selectors[i][0], selectors[i][1]));
            }
            return this;
        }

        public EntityViewer select(String[] fields) {
            this.checkSelector();
            for (int i = 0; i < fields.length; ++i) {
                this.info.getSelector().add(new SelectorItemInfo(fields[i]));
            }
            return this;
        }

        private void checkSelector() {
            this.checkEntityViewInfo();
        }

        public EntityViewer sort(String field, SortType type) {
            this.checkSorter();
            SorterItemInfo sortItem = new SorterItemInfo(field);
            sortItem.setSortType(type);
            this.info.getSorter().add(sortItem);
            return this;
        }

        public EntityViewer mergeSorter(SorterItemCollection coll) {
            this.checkSorter();
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                this.info.getSorter().add((SorterItemInfo)it.next());
            }
            return this;
        }

        public EntityViewer sort(String field) {
            return this.sort(field, SortType.ASCEND);
        }

        public EntityViewer sortASC(String field) {
            return this.sort(field, SortType.ASCEND);
        }

        public EntityViewer sortDESC(String field) {
            return this.sort(field, SortType.DESCEND);
        }

        private void checkSorter() {
            this.checkEntityViewInfo();
        }

        public EntityViewInfo entityViewInfo() {
            return this.info;
        }

        public SelectorItemCollection selector() {
            return this.info.getSelector();
        }

        public SorterItemCollection sorter() {
            return this.info.getSorter();
        }

        public FilterInfo filterInfo() {
            return this.info.getFilter();
        }

        public EntityViewInfo cloneEntityViewInfo() {
            return (EntityViewInfo)this.info.clone();
        }

        public SelectorItemCollection cloneSelector() {
            return (SelectorItemCollection)this.info.getSelector().clone();
        }

        public SorterItemCollection cloneSorter() {
            return (SorterItemCollection)this.info.getSorter().clone();
        }

        public FilterInfo cloneFilterInfo() {
            if (this.info.getFilter() == null) {
                return null;
            }
            return (FilterInfo)this.info.clone();
        }

        public String toString() {
            return this.entityViewInfo().toString();
        }
    }
}

