/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqirpa;

import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.excel.json.JSONUtils;
import com.kingdee.eas.fi.newrpt.jiuqirpa.ConnectRPAInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class ExecuteRPAHelp {
    private static final Logger logger = CoreUIObject.getLogger(ExecuteRPAHelp.class);
    private String rpaIp = null;

    public boolean excuteRPA(ConnectRPAInfo connectRPAInfo) {
        boolean flag = false;
        try {
            this.rpaIp = connectRPAInfo.getRpaIp();
            String loginResultJson = this.loginRpa(connectRPAInfo);
            HashMap loginMap = JSONUtils.convertJsonToObject((String)loginResultJson);
            Map data = (Map)loginMap.get("data");
            String token = (String)data.get("access_token");
            String orgJson = this.getRpaOrgs(token, connectRPAInfo.getUserName());
            HashMap orgMap = JSONUtils.convertJsonToObject((String)orgJson);
            Map orgReturnData = (Map)orgMap.get("data");
            List orgs = (List)orgReturnData.get("orgs");
            String orgId = this.getKey("name", "id", connectRPAInfo.getOrgName(), orgs);
            String robotJson = this.getRobotList(token, orgId);
            HashMap robotMap = JSONUtils.convertJsonToObject((String)robotJson);
            List robotReturnData = (List)robotMap.get("data");
            String robotId = this.getKey("name", "id", connectRPAInfo.getRobotName(), robotReturnData);
            String macJson = this.getTerminalListApiService(token, orgId);
            HashMap macJsonMap = JSONUtils.convertJsonToObject((String)macJson);
            List macReturnData = (List)macJsonMap.get("data");
            String macId = this.getKey("description", "mac", connectRPAInfo.getMacIP(), macReturnData);
            if (StringUtils.isEmpty((String)macId)) {
                logger.error((Object)("get mac null" + connectRPAInfo.getMacIP()));
                macId = this.getKey("ip", "mac", "127.0.0.1", macReturnData);
            }
            String tasksJson = this.addTasksApiService(token, orgId, robotId, macId, connectRPAInfo.getJiuqiExeFilePatch(), connectRPAInfo.getJiuqiTaskNumbers());
            logger.error((Object)("excute rpa error:" + tasksJson));
            flag = true;
        }
        catch (Exception e) {
            logger.error((Object)"excute rpa error", (Throwable)e);
        }
        return flag;
    }

    private String getKey(String keyK, String valueK, String equalsV, List data) {
        Map info = null;
        String infoKey = null;
        String infoValue = null;
        for (int i = 0; i < data.size(); ++i) {
            info = (Map)data.get(i);
            infoKey = info.get(keyK) instanceof Map ? (String)((Map)info.get(keyK)).get("zh_CN") : (String)info.get(keyK);
            if (!equalsV.equals(infoKey)) continue;
            if (info.get(valueK) instanceof Double) {
                infoValue = new BigDecimal((Double)info.get(valueK)).toPlainString();
                break;
            }
            infoValue = info.get(valueK).toString();
            break;
        }
        return infoValue;
    }

    public String doHttpPost(String url, String json) {
        if (!url.startsWith("http")) {
            url = "https://" + this.rpaIp + url;
        }
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(url);
        String result = null;
        try {
            StringEntity s = new StringEntity(json, "UTF-8");
            s.setContentType("application/json");
            post.setEntity((HttpEntity)s);
            HttpResponse res = client.execute((HttpUriRequest)post);
            if (res.getStatusLine().getStatusCode() == 200) {
                result = EntityUtils.toString((HttpEntity)res.getEntity());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.error((Object)("RPA info " + url + "\n json:" + json + "\n result:" + result));
        return result;
    }

    public String loginRpa(ConnectRPAInfo connectRPAInfo) {
        StringBuffer jsonStr = new StringBuffer("{\"user\":\"");
        jsonStr.append(connectRPAInfo.getUserName());
        jsonStr.append("\",");
        jsonStr.append("\"password\":\"");
        String pw = KSqlUtil.decodePassword((String)connectRPAInfo.getPassword());
        jsonStr.append(pw);
        jsonStr.append("\",");
        jsonStr.append("\"tenantid\":\"");
        jsonStr.append("next");
        jsonStr.append("\",");
        jsonStr.append("\"logintype\":\"");
        jsonStr.append("2");
        jsonStr.append("\"}");
        String url = "/ierp/api/login.do";
        String result = this.doHttpPost(url, jsonStr.toString());
        return result;
    }

    public String logoutRpa(String token) {
        String json = "{" + token + "}";
        String url = "/ierp/api/logout.do";
        String result = this.doHttpPost(url, json);
        return result;
    }

    public String getRpaOrgs(String token, String userName) {
        String json = "{\"user\":\"" + userName + "\"}";
        String url = "/ierp/kapi/app/rbmg/getUserOrgApiService?access_token=" + token;
        String result = this.doHttpPost(url, json);
        return result;
    }

    public String getRobotList(String token, String orgId) {
        String json = "{\"orgId\":\"" + orgId + "\"}";
        String url = "/ierp/kapi/app/rbmg/getRobotList?access_token=" + token;
        String result = this.doHttpPost(url, json);
        return result;
    }

    public String getTerminalListApiService(String token, String orgId) {
        String json = "{\"orgId\":\"" + orgId + "\"}";
        String url = "/ierp/kapi/app/rbmg/getTerminalListApiService?access_token=" + token;
        String result = this.doHttpPost(url, json);
        return result;
    }

    public String addTasksApiService(String token, String orgId, String robotId, String macId, String jiuqiPatch, String jiuqiTaskNums) {
        String json = "{\"orgId\":\"" + orgId + "\",\"robotId\":\"" + robotId + "\",\"mac\":\"" + macId + "\",\"runMethod\":\"0\",";
        jiuqiPatch = jiuqiPatch.replace("\\", "\\\\");
        String param = "\"startParams\":[{\"name\":\"jiuqiPatch\",\"type\":\"System.String\",\"value\":\"" + jiuqiPatch + "\"}";
        if (!StringUtils.isEmpty((String)jiuqiTaskNums)) {
            param = param + ",{\"name\":\"jiuqiTaskNums\",\"type\":\"System.String\",\"value\":\"" + jiuqiTaskNums + "\"}";
        }
        param = param + "]";
        json = json + param + "}";
        String url = "/ierp/kapi/app/rbmg/addTasksApiService?access_token=" + token;
        String result = this.doHttpPost(url, json);
        return result;
    }
}

