/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.report;

import com.kingdee.eas.base.commonquery.client.CustomerParams;

public class AnalysisBasePointParams {
    private int headRowEndOffSet = 0;
    private int headColEndOffSet = 0;
    private int row_endOffSet = 0;
    private int col_endOffSet = 0;
    private CustomerParams analysisGuideParams = null;
    private CustomerParams analysisFilterParams = null;
    private boolean isDynamicAnalysis = false;
    private boolean isMidTableAnalysis = false;
    private static String split1 = "==";
    private String split2 = "@@";

    public static AnalysisBasePointParams getInstance(String paramsStr) {
        if (paramsStr != null) {
            String[] paramsArr = paramsStr.split(split1);
            AnalysisBasePointParams params = new AnalysisBasePointParams();
            if (paramsArr.length > 0) {
                params.setDynamicAnalysis(Boolean.parseBoolean(paramsArr[0]));
            }
            if (paramsArr.length > 1) {
                params.setHeadRowEndOffSet(Integer.parseInt(paramsArr[1]));
            }
            if (paramsArr.length > 2) {
                params.setHeadColEndOffSet(Integer.parseInt(paramsArr[2]));
            }
            if (paramsArr.length > 3) {
                params.setRow_endOffSet(Integer.parseInt(paramsArr[3]));
            }
            if (paramsArr.length > 4) {
                params.setCol_endOffSet(Integer.parseInt(paramsArr[4]));
            }
            if (paramsArr.length > 5) {
                params.setAnalysisGuideParams(params.initCustomerParams(paramsArr[5]));
            }
            if (paramsArr.length > 6) {
                params.setAnalysisFilterParams(params.initCustomerParams(paramsArr[6]));
            }
            if (paramsArr.length > 7) {
                params.setMidTableAnalysis(Boolean.parseBoolean(paramsArr[7]));
            }
            return params;
        }
        return null;
    }

    public CustomerParams initCustomerParams(String customerParamsStr) {
        CustomerParams params = new CustomerParams();
        String[] paramsStr = customerParamsStr.split(this.split2);
        String[] tmpStr = null;
        for (String param : paramsStr) {
            tmpStr = param.split("::");
            if (tmpStr == null || tmpStr.length != 2) continue;
            params.addCustomerParam(tmpStr[0], tmpStr[1]);
        }
        return params;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.isDynamicAnalysis).append(split1);
        sb.append(this.headRowEndOffSet).append(split1);
        sb.append(this.headColEndOffSet).append(split1);
        sb.append(this.row_endOffSet).append(split1);
        sb.append(this.col_endOffSet);
        if (this.analysisGuideParams != null) {
            sb.append(split1);
            for (Object key : this.analysisGuideParams.getKeys()) {
                sb.append(key).append("::").append(this.analysisGuideParams.getCustomerParam(key.toString())).append(this.split2);
            }
        }
        if (this.analysisFilterParams != null) {
            sb.append(split1);
            for (Object key : this.analysisFilterParams.getKeys()) {
                sb.append(key).append("::").append(this.analysisFilterParams.getCustomerParam(key.toString())).append(this.split2);
            }
        }
        if (this.analysisFilterParams != null) {
            sb.append(split1);
            sb.append(this.analysisFilterParams.getCustomerParam("isMidTableAnalysis"));
        }
        return sb.toString();
    }

    public CustomerParams getAnalysisGuideParams() {
        return this.analysisGuideParams;
    }

    public void setAnalysisGuideParams(CustomerParams analysisGuideParams) {
        this.analysisGuideParams = analysisGuideParams;
    }

    public CustomerParams getAnalysisFilterParams() {
        return this.analysisFilterParams;
    }

    public void setAnalysisFilterParams(CustomerParams analysisFilterParams) {
        this.analysisFilterParams = analysisFilterParams;
    }

    public boolean isDynamicAnalysis() {
        return this.isDynamicAnalysis;
    }

    public void setDynamicAnalysis(boolean isDynamicAnalysis) {
        this.isDynamicAnalysis = isDynamicAnalysis;
    }

    public int getHeadRowEndOffSet() {
        return this.headRowEndOffSet;
    }

    public void setHeadRowEndOffSet(int headRowEndOffSet) {
        this.headRowEndOffSet = headRowEndOffSet;
    }

    public int getHeadColEndOffSet() {
        return this.headColEndOffSet;
    }

    public void setHeadColEndOffSet(int headColEndOffSet) {
        this.headColEndOffSet = headColEndOffSet;
    }

    public int getRow_endOffSet() {
        return this.row_endOffSet;
    }

    public void setRow_endOffSet(int row_endOffSet) {
        this.row_endOffSet = row_endOffSet;
    }

    public int getCol_endOffSet() {
        return this.col_endOffSet;
    }

    public void setCol_endOffSet(int col_endOffSet) {
        this.col_endOffSet = col_endOffSet;
    }

    public boolean isMidTableAnalysis() {
        return this.isMidTableAnalysis;
    }

    public void setMidTableAnalysis(boolean isMidTableAnalysis) {
        this.isMidTableAnalysis = isMidTableAnalysis;
    }
}

