/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptInExcel;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RptSystemFrom;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.newrpt.rptInExcel.IReportInExcelSchm;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelMustInputInfo;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelSchmFactory;
import com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelStatusEnum;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IInitDataFacada;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PublicStatusEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptHandleStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ReportInExcelHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelHelper");
    PeriodCollection periodCollection;
    private Map periodCollectionMap = null;
    IInitDataFacada iInitDataFacada;
    private Map<String, Map<String, String>> permissionInfoMap = new HashMap<String, Map<String, String>>();
    TreeMap<Integer, List<Integer>> yearMap = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList importExcel(Context ctx, ReportInExcelMustInputInfo mustInputInfo, File file) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList(2);
        if (!this.checkYearAndPeriod(mustInputInfo)) {
            this.setResultList(resultList, "FAILURE", mustInputInfo.getErrorMsg());
            return resultList;
        }
        if (!this.checkFunctionPermission(ctx, mustInputInfo)) {
            this.setResultList(resultList, "FAILURE", mustInputInfo.getErrorMsg());
            return resultList;
        }
        int index = file.getName().lastIndexOf(".");
        String fileType = file.getName().substring(index);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.generateReport(ctx, fileType, fileInputStream, mustInputInfo, resultList);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("_FileInputStream:" + e.getMessage()));
            String errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"analysisFile_read_error");
            mustInputInfo.setErrorMsg(errorMsg);
            this.setResultList(resultList, "FAILURE", errorMsg);
            ArrayList arrayList = resultList;
            return arrayList;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception e2) {
                logger.error((Object)"fileInputStream.close()", (Throwable)e2);
            }
        }
        if (StringUtils.isEmpty((String)mustInputInfo.getErrorMsg())) {
            this.setResultList(resultList, "SUCCESS", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_success"));
        } else {
            this.setResultList(resultList, "FAILURE", mustInputInfo.getErrorMsg());
        }
        return resultList;
    }

    private boolean checkYearAndPeriod(ReportInExcelMustInputInfo mustInputInfo) {
        Integer year;
        Map<Object, Object> infoMap = mustInputInfo.getInfoMap();
        boolean isProf = Boolean.TRUE.equals((Boolean)infoMap.get("isProf"));
        FullOrgUnitInfo unit = mustInputInfo.getUnit();
        TemplateInfo temp = mustInputInfo.getTemp();
        RptPeriodTypeEnum tempPeriodType = temp.getPeriodType();
        Integer[] years = new Integer[]{1900, 2999};
        if (!unit.isIsUnion()) {
            if (!this.findFiscalPeriod(isProf, unit.getId().toString(), mustInputInfo)) {
                return false;
            }
            years = this.getYearScope();
        }
        if ((year = mustInputInfo.getYear()) < years[0] || year > years[1]) {
            mustInputInfo.setErrorMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"outRangeOfFiscalPeriod"), year.toString()));
            return false;
        }
        if (tempPeriodType.getValue() != mustInputInfo.getPeriodType().getValue()) {
            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"periodType_unmatch"));
            return false;
        }
        Integer period = mustInputInfo.getPeriod();
        switch (mustInputInfo.getPeriodType().getValue()) {
            case 1: {
                if (period >= 1 && period <= 366) break;
                mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"periodType_error"));
                return false;
            }
            case 3: {
                if (period >= 1 && period <= 13) break;
                mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"periodType_error"));
                return false;
            }
            case 4: {
                if (period >= 1 && period <= 4) break;
                mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"periodType_error"));
                return false;
            }
            case 5: {
                if (period >= 1 && period <= 2) break;
                mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"periodType_error"));
                return false;
            }
            case 2: {
                if (period >= 1 && period <= 52) break;
                mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"periodType_error"));
                return false;
            }
            case 6: {
                if (period >= 1 && period <= 1) break;
                mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"periodType_error"));
                return false;
            }
        }
        return true;
    }

    private boolean checkFunctionPermission(Context ctx, ReportInExcelMustInputInfo mustInputInfo) {
        Map<String, String> permItemTypeMap;
        int i;
        FullOrgUnitCollection parentUnitCol;
        FullOrgUnitInfo unit = mustInputInfo.getUnit();
        BOSUuid orgID = unit.getId();
        String orgIDStr = orgID.toString();
        String name = unit.getName();
        boolean isUnion = unit.isIsUnion();
        Map<Object, Object> infoMap = mustInputInfo.getInfoMap();
        TemplateInfo temp = mustInputInfo.getTemp();
        UserInfo user = (UserInfo)infoMap.get("user");
        String openUI = (String)infoMap.get("openUI");
        ReportInExcelStatusEnum status = mustInputInfo.getStatus();
        Object[] permItemName = null;
        String receiveItemName = null;
        String parentUnitName = null;
        RptTmpTypeEnum templateType = temp.getTemplateType();
        String tempId = (String)temp.get("groupTempId");
        if (tempId == null) {
            tempId = temp.getId().toString();
        }
        HashSet<ObjectUuidPK> parentUnitIds = new HashSet<ObjectUuidPK>();
        if ("CslRptListUI".equals(openUI)) {
            if (0 == status.getValue()) {
                permItemName = new String[]{"csl_cslrpt_addnew", "csl_cslrpt_delete"};
            } else if (1 == status.getValue()) {
                permItemName = new String[]{"csl_cslrpt_addnew", "csl_cslrpt_delete", "csl_cslrpt_audit"};
            } else if (2 == status.getValue()) {
                permItemName = new String[]{"csl_cslrpt_addnew", "csl_cslrpt_delete", "csl_cslrpt_audit", "csl_cslrpt_commit"};
            } else if (3 == status.getValue()) {
                permItemName = new String[]{"csl_cslrpt_addnew", "csl_cslrpt_delete", "csl_cslrpt_audit", "csl_cslrpt_commit", "csl_rpt_receive"};
            }
        } else if ("GroupRptListUI".equals(openUI)) {
            block111: {
                try {
                    parentUnitCol = this.getParentUnitCol(orgIDStr, tempId, mustInputInfo.getYear(), mustInputInfo.getPeriod(), mustInputInfo.getPeriodType());
                    if (!parentUnitCol.isEmpty()) {
                        name = parentUnitCol.get(0).getName();
                        for (i = 0; i < parentUnitCol.size(); ++i) {
                            parentUnitIds.add(new ObjectUuidPK(parentUnitCol.get(i).getId()));
                        }
                        break block111;
                    }
                    String errorMsg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"unit_not_dispenseTemp"), name, temp.getName());
                    mustInputInfo.setErrorMsg(errorMsg);
                    return false;
                }
                catch (Exception e) {
                    logger.error((Object)("TempletDispense_getCollection_error:" + e.getMessage()));
                    mustInputInfo.setErrorMsg(e.getMessage());
                    return false;
                }
            }
            if (0 == status.getValue()) {
                permItemName = new String[]{"csl_indirpt_addnew", "csl_indirpt_delete"};
            } else if (1 == status.getValue()) {
                permItemName = new String[]{"csl_indirpt_addnew", "csl_indirpt_delete", "csl_indirpt_audit"};
            } else if (2 == status.getValue()) {
                permItemName = new String[]{"csl_indirpt_addnew", "csl_indirpt_delete", "csl_indirpt_audit", "csl_indirpt_commit"};
            } else if (3 == status.getValue()) {
                permItemName = new String[]{"csl_indirpt_addnew", "csl_indirpt_delete", "csl_indirpt_audit", "csl_indirpt_commit", "csl_rpt_receive"};
            }
        } else if ("SumRptListUI".equals(openUI)) {
            if (0 == status.getValue()) {
                permItemName = new String[]{"csl_sumrpt_addnew", "csl_sumrpt_delete"};
            } else if (1 == status.getValue()) {
                permItemName = new String[]{"csl_sumrpt_addnew", "csl_sumrpt_delete", "csl_sumrpt_audit"};
            } else if (2 == status.getValue()) {
                permItemName = new String[]{"csl_sumrpt_addnew", "csl_sumrpt_delete", "csl_sumrpt_audit", "csl_sumrpt_commit"};
            } else if (3 == status.getValue()) {
                permItemName = new String[]{"csl_sumrpt_addnew", "csl_sumrpt_delete", "csl_sumrpt_audit", "csl_sumrpt_commit", "csl_rpt_receive"};
            }
        } else if ("ReportMaintainUI".equals(openUI) || "ReportWorktableUI".equals(openUI)) {
            if (0 == status.getValue()) {
                permItemName = new String[]{"rpt_report_addnew", "rpt_report_delete"};
            } else if (1 == status.getValue()) {
                permItemName = new String[]{"rpt_report_addnew", "rpt_report_delete", "rpt_report_audit"};
            } else if (2 == status.getValue()) {
                permItemName = new String[]{"rpt_report_addnew", "rpt_report_delete", "rpt_report_audit", "rpt_report_commit"};
            } else if (3 == status.getValue()) {
                block112: {
                    permItemName = new String[]{"rpt_report_addnew", "rpt_report_delete", "rpt_report_audit", "rpt_report_commit"};
                    try {
                        parentUnitCol = this.getParentUnitCol(orgIDStr, tempId, mustInputInfo.getYear(), mustInputInfo.getPeriod(), mustInputInfo.getPeriodType());
                        if (!parentUnitCol.isEmpty()) {
                            parentUnitName = parentUnitCol.get(0).getName();
                            for (i = 0; i < parentUnitCol.size(); ++i) {
                                parentUnitIds.add(new ObjectUuidPK(parentUnitCol.get(i).getId()));
                            }
                            break block112;
                        }
                        String errorMsg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"unit_not_dispenseTemp"), name, temp.getName());
                        mustInputInfo.setErrorMsg(errorMsg);
                        return false;
                    }
                    catch (Exception e) {
                        logger.error((Object)("TempletDispense_getCollection_error:" + e.getMessage()));
                        mustInputInfo.setErrorMsg(e.getMessage());
                        return false;
                    }
                }
                receiveItemName = "csl_rpt_receive";
            }
        } else if ("ProfReportWorktableUI".equals(openUI)) {
            if (0 == status.getValue()) {
                permItemName = new String[]{"prof_rpt_update"};
            } else if (1 == status.getValue()) {
                permItemName = new String[]{"prof_rpt_update", "prof_rpt_audit"};
            } else if (2 == status.getValue()) {
                permItemName = new String[]{"prof_rpt_update", "prof_rpt_audit", "prof_rpt_commited"};
            } else if (3 == status.getValue()) {
                block113: {
                    permItemName = new String[]{"prof_rpt_update", "prof_rpt_audit", "prof_rpt_commited"};
                    try {
                        parentUnitCol = this.getParentUnitCol(orgIDStr, tempId, mustInputInfo.getYear(), mustInputInfo.getPeriod(), mustInputInfo.getPeriodType());
                        if (!parentUnitCol.isEmpty()) {
                            parentUnitName = parentUnitCol.get(0).getName();
                            for (i = 0; i < parentUnitCol.size(); ++i) {
                                parentUnitIds.add(new ObjectUuidPK(parentUnitCol.get(i).getId()));
                            }
                            break block113;
                        }
                        String errorMsg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"unit_not_dispenseTemp"), name, temp.getName());
                        mustInputInfo.setErrorMsg(errorMsg);
                        return false;
                    }
                    catch (Exception e) {
                        logger.error((Object)("TempletDispense_getCollection_error:" + e.getMessage()));
                        mustInputInfo.setErrorMsg(e.getMessage());
                        return false;
                    }
                }
                receiveItemName = "csl_rpt_receive";
            }
        } else if ("CslWorkTableListUI".equals(openUI) || "ReceiveListUI".equals(openUI)) {
            if (3 == templateType.getValue()) {
                if (0 == status.getValue()) {
                    permItemName = new String[]{"csl_sumrpt_addnew", "csl_sumrpt_delete"};
                } else if (1 == status.getValue()) {
                    permItemName = new String[]{"csl_sumrpt_addnew", "csl_sumrpt_delete", "csl_sumrpt_audit"};
                } else if (2 == status.getValue()) {
                    permItemName = new String[]{"csl_sumrpt_addnew", "csl_sumrpt_delete", "csl_sumrpt_audit", "csl_sumrpt_commit"};
                } else if (3 == status.getValue()) {
                    permItemName = new String[]{"csl_sumrpt_addnew", "csl_sumrpt_delete", "csl_sumrpt_audit", "csl_sumrpt_commit", "csl_rpt_receive"};
                }
            } else if (5 == templateType.getValue()) {
                if (0 == status.getValue()) {
                    permItemName = new String[]{"csl_cslrpt_addnew", "csl_cslrpt_delete"};
                } else if (1 == status.getValue()) {
                    permItemName = new String[]{"csl_cslrpt_addnew", "csl_cslrpt_delete", "csl_cslrpt_audit"};
                } else if (2 == status.getValue()) {
                    permItemName = new String[]{"csl_cslrpt_addnew", "csl_cslrpt_delete", "csl_cslrpt_audit", "csl_cslrpt_commit"};
                } else if (3 == status.getValue()) {
                    permItemName = new String[]{"csl_cslrpt_addnew", "csl_cslrpt_delete", "csl_cslrpt_audit", "csl_cslrpt_commit", "csl_rpt_receive"};
                }
            } else {
                block114: {
                    try {
                        if (isUnion) break block114;
                        parentUnitCol = this.getParentUnitCol(orgIDStr, tempId, mustInputInfo.getYear(), mustInputInfo.getPeriod(), mustInputInfo.getPeriodType());
                        if (!parentUnitCol.isEmpty()) {
                            name = parentUnitCol.get(0).getName();
                            for (i = 0; i < parentUnitCol.size(); ++i) {
                                parentUnitIds.add(new ObjectUuidPK(parentUnitCol.get(i).getId()));
                            }
                            break block114;
                        }
                        String errorMsg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"unit_not_dispenseTemp"), name, temp.getName());
                        mustInputInfo.setErrorMsg(errorMsg);
                        return false;
                    }
                    catch (Exception e) {
                        logger.error((Object)("TempletDispense_getCollection_error:" + e.getMessage()));
                        mustInputInfo.setErrorMsg(e.getMessage());
                        return false;
                    }
                }
                if (0 == status.getValue()) {
                    permItemName = new String[]{"csl_indirpt_addnew", "csl_indirpt_delete"};
                } else if (1 == status.getValue()) {
                    permItemName = new String[]{"csl_indirpt_addnew", "csl_indirpt_delete", "csl_indirpt_audit"};
                } else if (2 == status.getValue()) {
                    permItemName = new String[]{"csl_indirpt_addnew", "csl_indirpt_delete", "csl_indirpt_audit", "csl_indirpt_commit"};
                } else if (3 == status.getValue()) {
                    permItemName = new String[]{"csl_indirpt_addnew", "csl_indirpt_delete", "csl_indirpt_audit", "csl_indirpt_commit", "csl_rpt_receive"};
                }
            }
        }
        String permItemTypeKey = Arrays.toString(permItemName);
        infoMap.put("permItemTypeKey", permItemTypeKey);
        if (this.permissionInfoMap.containsKey(orgIDStr) && (permItemTypeMap = this.permissionInfoMap.get(orgIDStr)) != null && permItemTypeMap.containsKey(permItemTypeKey)) {
            String deleteKey = permItemTypeKey + "|delete";
            if (!StringUtils.isEmpty((String)permItemTypeMap.get(deleteKey))) {
                infoMap.put(permItemTypeKey + "|delete", false);
            }
            if (StringUtils.isEmpty((String)permItemTypeMap.get(permItemTypeKey))) {
                return true;
            }
            mustInputInfo.setErrorMsg(permItemTypeMap.get(permItemTypeKey));
            return false;
        }
        if (permItemName == null) {
            mustInputInfo.setErrorMsg("permItemName is null.");
            return false;
        }
        try {
            StringBuilder sb = new StringBuilder();
            boolean[] permissionResultArry = new boolean[permItemName.length + (receiveItemName == null ? 0 : 1)];
            if (parentUnitIds.size() > 0) {
                if (receiveItemName != null) {
                    boolean[] permissionRsArray = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(orgID), (String[])permItemName);
                    for (int i2 = 0; i2 < permissionRsArray.length; ++i2) {
                        permissionResultArry[i2] = permissionRsArray[i2];
                    }
                    ObjectUuidPK orgPk = null;
                    Iterator iterator = parentUnitIds.iterator();
                    while (iterator.hasNext()) {
                        ObjectUuidPK pk;
                        orgPk = pk = (ObjectUuidPK)iterator.next();
                        boolean hasReceivePermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)orgPk, receiveItemName);
                        if (!hasReceivePermission) continue;
                        permissionResultArry[permissionResultArry.length - 1] = true;
                        break;
                    }
                    String[] newPermItemName = new String[permItemName.length + 1];
                    for (int i3 = 0; i3 < permItemName.length; ++i3) {
                        newPermItemName[i3] = permItemName[i3];
                    }
                    newPermItemName[permissionResultArry.length - 1] = receiveItemName;
                    permItemName = newPermItemName;
                } else {
                    block17: for (int i4 = 0; i4 < permItemName.length; ++i4) {
                        for (ObjectUuidPK pk : parentUnitIds) {
                            boolean hasPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)pk, (String)permItemName[i4]);
                            if (!hasPermission) continue;
                            permissionResultArry[i4] = true;
                            continue block17;
                        }
                    }
                }
            } else {
                permissionResultArry = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(orgID), (String[])permItemName);
            }
            for (int i5 = 0; i5 < permissionResultArry.length; ++i5) {
                if (permissionResultArry[i5]) continue;
                if ("rpt_report_addnew".equals(permItemName[i5]) || "csl_cslrpt_addnew".equals(permItemName[i5]) || "csl_indirpt_addnew".equals(permItemName[i5]) || "csl_sumrpt_addnew".equals(permItemName[i5])) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"report_addnew"));
                    sb.append(",");
                    continue;
                }
                if ("prof_rpt_update".equals(permItemName[i5])) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"profitReport_addnew"));
                    sb.append(",");
                    continue;
                }
                if ("rpt_report_delete".equals(permItemName[i5]) || "csl_cslrpt_delete".equals(permItemName[i5]) || "csl_indirpt_delete".equals(permItemName[i5]) || "csl_sumrpt_delete".equals(permItemName[i5])) {
                    infoMap.put(permItemTypeKey + "|delete", false);
                    continue;
                }
                if ("prof_rpt_audit".equals(permItemName[i5]) || "rpt_report_audit".equals(permItemName[i5]) || "csl_cslrpt_audit".equals(permItemName[i5]) || "csl_indirpt_audit".equals(permItemName[i5]) || "csl_sumrpt_audit".equals(permItemName[i5])) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"report_audite"));
                    sb.append(",");
                    continue;
                }
                if ("prof_rpt_commited".equals(permItemName[i5]) || "rpt_report_commit".equals(permItemName[i5]) || "csl_cslrpt_commit".equals(permItemName[i5]) || "csl_indirpt_commit".equals(permItemName[i5]) || "csl_sumrpt_commit".equals(permItemName[i5])) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"report_commite"));
                    sb.append(",");
                    continue;
                }
                if (!"csl_rpt_receive".equals(permItemName[i5]) || parentUnitName != null) continue;
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"report_receive"));
                sb.append(",");
            }
            HashMap<String, String> permItemTypeMap2 = new HashMap<String, String>();
            this.permissionInfoMap.put(orgIDStr, permItemTypeMap2);
            if (sb.length() > 0) {
                sb = sb.deleteCharAt(sb.length() - 1);
                String errorMsg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"unitHasNoPermission"), name, sb.toString());
                if (parentUnitName != null) {
                    errorMsg = errorMsg + "," + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"unitHasNoPermission"), parentUnitName, EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"report_receive"));
                }
                mustInputInfo.setErrorMsg(errorMsg);
                permItemTypeMap2.put(permItemTypeKey, errorMsg);
                return false;
            }
            permItemTypeMap2.put(permItemTypeKey, "");
        }
        catch (Exception e) {
            logger.error((Object)("checkFunctionPermission_error:" + e.getMessage()));
            String errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"checkFunctionPermission_error");
            mustInputInfo.setErrorMsg(errorMsg);
            return false;
        }
        return true;
    }

    private FullOrgUnitCollection getParentUnitCol(String orgIDStr, String tempId, Integer year, Integer period, RptPeriodTypeEnum periodType) throws EASBizException, BOSException {
        return ReportInExcelSchmFactory.getRemoteInstance().getParentUnitCol(orgIDStr, tempId, year, period, periodType);
    }

    private void generateReport(Context ctx, String fileType, FileInputStream stream, ReportInExcelMustInputInfo mustInputInfo, ArrayList resultList) {
        CslReportInfo rptBaseInfo;
        Map<Object, Object> infoMap = mustInputInfo.getInfoMap();
        Integer isUnionflag = (Integer)infoMap.get("isUnion");
        boolean isProf = Boolean.TRUE.equals((Boolean)infoMap.get("isProf"));
        String rptFromSystem = (String)infoMap.get("fromSystem");
        UserInfo user = (UserInfo)infoMap.get("user");
        CtrlUnitInfo cu = (CtrlUnitInfo)infoMap.get("CU");
        TemplateInfo temp = mustInputInfo.getTemp();
        FullOrgUnitInfo unit = mustInputInfo.getUnit();
        String permissonKey = unit.getId().toString();
        Map<String, String> permItemTypeMap = this.permissionInfoMap.get(permissonKey);
        String permItemTypeKey = (String)infoMap.get("permItemTypeKey");
        String deleteKey = permItemTypeKey + "|delete";
        if (Boolean.FALSE.equals((Boolean)infoMap.get(deleteKey))) {
            permItemTypeMap.put(deleteKey, "noDeletePermisson");
        }
        TemplateInfo template = temp;
        boolean isGroupTemp = true;
        try {
            String oql;
            if (template.get("fromF7") == null) {
                isGroupTemp = !Boolean.TRUE.equals((Boolean)template.get("isNotGroupTem"));
                oql = "select id, periodType, data, dynaRptType, templateType, name, number, description, sheetParam.*  where versionStatus = 1 and isK3Tpl = 0 and id = '" + temp.getId().toString() + "'";
                template = ctx == null ? TemplateFactory.getRemoteInstance().getTemplateInfo(oql) : TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo(oql);
            } else {
                TemplateCollection temCol;
                oql = "select id, periodType, data, dynaRptType, templateType, name, number, description, sheetParam.*  where versionStatus = 1 and isK3Tpl = 0  and groupTemplate = '" + temp.getId().toString() + "' and company = '" + mustInputInfo.getUnit().getId().toString() + "'";
                TemplateCollection templateCollection = temCol = ctx == null ? TemplateFactory.getRemoteInstance().getTemplateCollection(oql) : TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection(oql);
                if (!temCol.isEmpty()) {
                    template = temCol.get(0);
                    isGroupTemp = false;
                } else {
                    oql = "select id, periodType, data, dynaRptType, templateType, name, number, description, sheetParam.*  where versionStatus = 1 and isK3Tpl = 0 and id = '" + temp.getId().toString() + "'";
                    template = ctx == null ? TemplateFactory.getRemoteInstance().getTemplateInfo(oql) : TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo(oql);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("generateReport_getTemplateInfo_error:" + e.getMessage()));
            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_temp_not_exist"));
            return;
        }
        CslReportInfo cslReport = new CslReportInfo();
        cslReport.setOrgUnit(unit);
        TemplateInfo checkTemplate = new TemplateInfo();
        checkTemplate.setId(template.getId());
        cslReport.setTemplate(checkTemplate);
        if (isGroupTemp) {
            try {
                boolean isDispense;
                boolean bl = isDispense = ctx == null ? RPTDataServiceFactory.getRemoteInstance().checkTempDispense(cslReport) : RPTDataServiceFactory.getLocalInstance((Context)ctx).checkTempDispense(cslReport);
                if (!isDispense) {
                    mustInputInfo.setErrorMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_temp_unDispense"), template.getName(), unit.getName()));
                    return;
                }
            }
            catch (Exception e) {
                logger.error((Object)("generateReport_checkTempDispense_error:" + e.getMessage()));
                mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"temp_DispenseFind_error"));
                return;
            }
        }
        KDSBook book = null;
        try {
            if (fileType == null || ".xls".equals(fileType)) {
                book = POIXlsReader.parse((InputStream)stream);
            } else if (".xlsx".equals(fileType)) {
                book = POIXlsxReader.parse((InputStream)stream);
            }
            stream.close();
        }
        catch (Exception e) {
            logger.error((Object)("generateReport_POIXlsxReader.parse_error:" + e.getMessage()));
            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"analysisExcel_error"));
            return;
        }
        if (book == null) {
            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"analysisExcel_error"));
            return;
        }
        String sheetName = null;
        KDSSheet sheetTemp = null;
        Book templateBook = null;
        try {
            templateBook = template.getBook();
            if (templateBook == null) {
                mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"getTempBook_error"));
                return;
            }
        }
        catch (Exception e) {
            logger.error((Object)("generateReport_template.getBook()_error:" + e.getMessage()));
            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"getTempBook_error"));
            return;
        }
        boolean autoCalculate = templateBook.isAutoCalculate();
        templateBook.setCalculate(false);
        int size = templateBook.getSheetCount();
        RptSheetParamCollection paramTemplate = template.getSheetParam();
        int sizeParam = paramTemplate.size();
        if (size != sizeParam) {
            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"tempBookParam_error"));
            return;
        }
        HashSet<String> commonSheetNameSet = new HashSet<String>();
        boolean isCommonPage = true;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sizeParam; ++i) {
            sheetName = paramTemplate.get(i).getSheetName();
            isCommonPage = CSLReportGroupEnum.COMMON.equals((Object)paramTemplate.get(i).getReportClass());
            sheetTemp = book.getSheet((Object)sheetName);
            if (!isCommonPage) continue;
            if (sheetTemp == null) {
                sb.append(sheetName);
                sb.append(",");
                continue;
            }
            commonSheetNameSet.add(sheetName);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            mustInputInfo.setErrorMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"excel_notFind_book"), sb));
            return;
        }
        CurrencyInfo currency = mustInputInfo.getCurrency();
        RptPeriodTypeEnum periodType = mustInputInfo.getPeriodType();
        ReportInExcelStatusEnum status = mustInputInfo.getStatus();
        Integer year = mustInputInfo.getYear();
        Integer period = mustInputInfo.getPeriod();
        int templateType = template.getTemplateType().getValue();
        int reportType = 1;
        switch (templateType) {
            case 3: {
                reportType = 2;
                break;
            }
            case 5: {
                reportType = 3;
                break;
            }
            case 6: {
                reportType = 1;
                break;
            }
            case 2: {
                reportType = 1;
            }
        }
        String rptId = null;
        String cslRptId = null;
        AuditedStatusEnum auditedStatus = null;
        CommittedStatusEnum committedStatus = null;
        Boolean isCommitReport = null;
        boolean isDeleteRpt = false;
        try {
            IReportInExcelSchm iRie = ctx == null ? ReportInExcelSchmFactory.getRemoteInstance() : ReportInExcelSchmFactory.getLocalInstance(ctx);
            CslReportInfo csInfo = iRie.getReportByTmpVersion(null, unit.getId().toString(), currency.getId().toString(), template.getId().toString(), reportType, periodType.getValue(), year, period, null, "ACTUALDATA");
            if (csInfo != null) {
                cslRptId = csInfo.getId().toString();
                auditedStatus = csInfo.getAuditedStatus();
                committedStatus = csInfo.getCommittedStatus();
                isCommitReport = csInfo.isIsCommitReport();
                if (csInfo.get("rptId") != null) {
                    rptId = (String)csInfo.get("rptId");
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)("generateReport_template.getReportByTmpVersion()_error:" + e.getMessage()));
            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"getReport_error"));
            return;
        }
        Object iCsl = null;
        Object iRpt = null;
        if (cslRptId != null) {
            String errorMsg = null;
            if (3 == committedStatus.getValue()) {
                errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"recevied_report");
            } else if (2 == committedStatus.getValue()) {
                errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"submited_report");
            } else if (2 == auditedStatus.getValue()) {
                errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"audited_report");
            } else {
                if (!isProf && Boolean.FALSE.equals((Boolean)infoMap.get(deleteKey))) {
                    String errorMssage = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"unitHasNoPermission"), unit.getName(), EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"report_delete"));
                    mustInputInfo.setErrorMsg(errorMssage);
                    return;
                }
                if ("1".equals(rptFromSystem) && isCommitReport.booleanValue()) {
                    mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"rptSystem_report_exist"));
                    return;
                }
                if ("0".equals(rptFromSystem) && !isCommitReport.booleanValue()) {
                    mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"cslRptSystem_report_exist"));
                    return;
                }
                isDeleteRpt = true;
            }
            if (errorMsg != null) {
                mustInputInfo.setErrorMsg(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"exist_report"), errorMsg));
                return;
            }
        }
        RptSheetParamCollection paramCollection = new RptSheetParamCollection();
        RptSheetParamInfo paramInfo = null;
        int n = paramTemplate.size();
        for (int i = 0; i < n; ++i) {
            paramInfo = paramTemplate.get(i);
            paramCollection.add(paramInfo);
        }
        String append = "-" + year + "-" + period + "-" + currency.getNumber();
        Date nowDate = new Date();
        if ("0".equals(rptFromSystem)) {
            ReportInfo reportInfo = new ReportInfo();
            reportInfo.put("nowDate", (Object)nowDate);
            reportInfo.put("userId", (Object)user.getId().toString());
            reportInfo.setRptFrom(RptSystemFrom.OTHERSYSTEM);
            reportInfo.setPeriodType(periodType);
            reportInfo.setSourceType(RptSrcTypeEnum.COMMITREPORT);
            reportInfo.setOrgType(!isProf ? OrgType.Company : OrgType.ProfitCenter);
            reportInfo.setYear(year.intValue());
            reportInfo.setPeriod(period.shortValue());
            reportInfo.setPublicStatus(PublicStatusEnum.PUBLIC);
            reportInfo.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
            CheckedStatusEnum ceStatusEnum = CheckedStatusEnum.UNCHECKED;
            if (0 != status.getValue()) {
                reportInfo.setAuditedStatus(AuditedStatusEnum.AUDITED);
                reportInfo.setAuditor(user);
                reportInfo.setAuditTime(new Timestamp(nowDate.getTime()));
                if (3 == status.getValue()) {
                    ceStatusEnum = CheckedStatusEnum.CHECKED;
                    reportInfo.setCommittedStatus(CommittedStatusEnum.GROUPCOMMITTED);
                    reportInfo.setCommitTime(nowDate);
                } else if (2 == status.getValue()) {
                    ceStatusEnum = CheckedStatusEnum.CHECKED;
                    reportInfo.setCommittedStatus(CommittedStatusEnum.COMMITTED);
                    reportInfo.setCommitTime(nowDate);
                } else {
                    reportInfo.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
                }
            } else {
                reportInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
                reportInfo.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
            }
            reportInfo.setCheckedStatus(ceStatusEnum);
            reportInfo.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
            reportInfo.setCU(cu);
            reportInfo.setName(template.getName() + append);
            reportInfo.setNumber(template.getNumber() + append);
            reportInfo.setCurrency(currency);
            reportInfo.setTemplate(template);
            reportInfo.setHandleStatus(RptHandleStatusEnum.FINISHED);
            reportInfo.setDataCollect(DataCollectConstant.getActualDC());
            reportInfo.setDataCollectNumber("ACTUALDATA");
            reportInfo.setStartDate(RPTDateUtil.getPeriodFirstDate((int)year, (int)period, (RptPeriodTypeEnum)periodType));
            reportInfo.setEndDate(RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)periodType));
            reportInfo.setCompany(unit);
            try {
                reportInfo.setBook(templateBook);
            }
            catch (Exception e) {
                logger.error((Object)("generateReport_cslReport.setBook()_error:" + e.getMessage()));
                mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"setBook_error"));
                return;
            }
            reportInfo.getSheetParam().addCollection(paramCollection);
            reportInfo.setDescription(template.getDescription());
            rptBaseInfo = reportInfo;
        } else {
            CommittedStatusEnum commitStatus;
            if (unit.isIsUnion()) {
                OrgTreeInfo tree = new OrgTreeInfo();
                tree.setId(BOSUuid.read((String)((String)unit.get("treeId"))));
                cslReport.setOrgTree(tree);
                cslReport.setStartDate(RPTDateUtil.getPeriodFirstDate((int)year, (int)period, (RptPeriodTypeEnum)periodType));
                cslReport.setEndDate(RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)periodType));
                cslReport.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            } else {
                cslReport.setCompany(unit);
            }
            cslReport.put("nowDate", (Object)nowDate);
            cslReport.put("userId", (Object)user.getId().toString());
            cslReport.setRptFrom(RptSystemFrom.OTHERSYSTEM);
            cslReport.setYear(year.intValue());
            cslReport.setPeriod(period.shortValue());
            cslReport.setIsCommitReport(false);
            cslReport.setTemplate(template);
            cslReport.setPeriodType(periodType);
            cslReport.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
            CheckedStatusEnum ceStatusEnum = CheckedStatusEnum.UNCHECKED;
            if (0 != status.getValue()) {
                if (3 == status.getValue()) {
                    ceStatusEnum = CheckedStatusEnum.CHECKED;
                    commitStatus = CommittedStatusEnum.GROUPCOMMITTED;
                    cslReport.setCommitTime(nowDate);
                    cslReport.setCommitor(user);
                    cslReport.setReceiveTime(nowDate);
                    cslReport.setReceiver(user);
                } else if (2 == status.getValue()) {
                    ceStatusEnum = CheckedStatusEnum.CHECKED;
                    commitStatus = CommittedStatusEnum.COMMITTED;
                    cslReport.setCommitTime(nowDate);
                    cslReport.setCommitor(user);
                } else {
                    commitStatus = CommittedStatusEnum.UNCOMMITTED;
                }
            } else {
                commitStatus = CommittedStatusEnum.UNCOMMITTED;
            }
            cslReport.setCheckedStatus(ceStatusEnum);
            cslReport.setCommittedStatus(commitStatus);
            cslReport.setSourceType(RptSrcTypeEnum.getEnum((int)reportType));
            cslReport.setCurrency(currency);
            try {
                cslReport.setBook(templateBook);
            }
            catch (Exception e) {
                logger.error((Object)("generateCslReport_cslReport.setBook()_error:" + e.getMessage()));
                mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"setBook_error"));
                return;
            }
            cslReport.getSheetParam().addCollection(paramCollection);
            cslReport.setName(template.getName() + append);
            cslReport.setNumber(template.getNumber() + append);
            cslReport.setDescription(template.getDescription());
            cslReport.setDataCollect(DataCollectConstant.getActualDC());
            cslReport.setDataCollectNumber("ACTUALDATA");
            cslReport.setCU(cu);
            rptBaseInfo = cslReport;
        }
        if (!this.updateReportData(ctx, commonSheetNameSet, book, (ReportBaseInfo)rptBaseInfo, mustInputInfo)) {
            return;
        }
        try {
            rptBaseInfo.getBook().setCalculate(autoCalculate);
            ReportInExcelSchmFactory.getRemoteInstance().addOtherSystemRpt(isDeleteRpt, rptFromSystem, rptId, cslRptId, status, (CoreBaseInfo)rptBaseInfo);
        }
        catch (Exception e) {
            mustInputInfo.setErrorMsg(e.getMessage());
            return;
        }
        this.setResultList(resultList, "SUCCESS", EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"import_success"));
    }

    private boolean findFiscalPeriod(boolean isProf, String unitId, ReportInExcelMustInputInfo mustInputInfo) {
        try {
            BOSUuid orgPkUuid = RptNewUIUtil.getDelegateCompany(isProf ? OrgType.ProfitCenter : OrgType.Company, unitId).getId();
            String orgPk = orgPkUuid.toString();
            if (this.periodCollectionMap == null) {
                this.periodCollectionMap = new HashMap();
            }
            if (this.periodCollectionMap.containsKey(orgPk)) {
                this.periodCollection = (PeriodCollection)this.periodCollectionMap.get(orgPk);
            } else {
                if (this.iInitDataFacada == null) {
                    this.iInitDataFacada = InitDataFacadaFactory.getRemoteInstance();
                }
                this.periodCollection = this.iInitDataFacada.getFiscal((IObjectPK)new ObjectUuidPK(orgPkUuid));
                this.periodCollectionMap.put(orgPk, this.periodCollection);
            }
        }
        catch (Exception e) {
            logger.error((Object)("error:" + e.getMessage()));
            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"getfiscalPeriod_error"));
            return false;
        }
        this.yearMap.clear();
        if (this.periodCollection != null && this.periodCollection.size() > 0) {
            for (int i = 0; i < this.periodCollection.size(); ++i) {
                Integer year = this.periodCollection.get(i).getPeriodYear();
                Integer period = this.periodCollection.get(i).getPeriodNumber();
                List<Integer> periodVec = this.yearMap.get(year);
                if (periodVec == null) {
                    periodVec = new ArrayList<Integer>(12);
                    this.yearMap.put(year, periodVec);
                }
                periodVec.add(period);
            }
        } else {
            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"FiscalPeriodIsNotExist"));
            return false;
        }
        return true;
    }

    private Integer[] getYearScope() {
        Object[] array = this.yearMap.keySet().toArray();
        if (array == null || array.length == 0) {
            return new Integer[]{1900, 1};
        }
        Arrays.sort(array);
        return new Integer[]{(Integer)array[0], (Integer)array[array.length - 1]};
    }

    private boolean updateReportData(Context ctx, Set<String> commonSheetNameSet, KDSBook excelKDSBook, ReportBaseInfo report, ReportInExcelMustInputInfo mustInputInfo) {
        try {
            Book rptBook = report.getBook();
            Book excelBook = KDSBookToBook.traslate((KDSBook)excelKDSBook);
            excelBook.setCalculate(false);
            Sheet sheetExcel = null;
            Sheet sheetCslRpt = null;
            Cell cellExcel = null;
            Cell cellCslRpt = null;
            Variant cellExcelVar = null;
            for (String tempSheetName : commonSheetNameSet) {
                sheetExcel = excelBook.getSheet(tempSheetName);
                sheetCslRpt = rptBook.getSheet(tempSheetName);
                Sheet.ICellsIterator cellsIterator = sheetCslRpt.getCellsIterator(null, false, true);
                while (cellsIterator.hasNext()) {
                    cellCslRpt = cellsIterator.next();
                    if (cellCslRpt.getUserObject("ITEM") == null) continue;
                    cellExcel = sheetExcel.getCell(cellCslRpt.getRow(), cellCslRpt.getCol(), true);
                    cellExcelVar = cellExcel.getValue();
                    cellCslRpt.setFormula(cellExcel.getFormula());
                    cellCslRpt.setValue(cellExcelVar);
                }
            }
            excelBook = null;
            excelKDSBook = null;
            BookProperties p = BookProperties.loadFromBook((Book)rptBook);
            Object adapter = report instanceof CslReportInfo ? new CSLPropertyAdapter() : new RptReportPropertyAdapter();
            adapter.initReportProperties((IObjectValue)report, ctx);
            ReportCalculateContext calcContext = new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, p.getVariables(), (IErrorProvider)p.getErrorProvider(), null);
            calcContext.setPermission(new ChecFmlParamPermissionUtil(ctx));
            FormulaDefinition.registerFormulaToBook(rptBook, calcContext);
            rptBook.calc();
            report.setBook(rptBook);
        }
        catch (Exception e) {
            logger.error((Object)("updateReportData_error:" + e.getMessage()));
            mustInputInfo.setErrorMsg(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptInExcel.ReportInExcelResource", (String)"updateReportData_error"));
            return false;
        }
        return true;
    }

    private void setResultList(ArrayList resultList, String status, String msg) {
        resultList.add(status);
        resultList.add(msg);
    }
}

