/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.preparedata.handler.budget.BudgetDataSourceWriter;
import com.kingdee.bos.qing.preparedata.handler.budget.BudgetFacade;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.IDataElement;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.newrpt.accountcheck.app.querycheckagedata.QueryBalanceUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeIndexInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.AnalyzeTypeEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.BaseDateEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CalculateProcessInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CurrencyEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CurrencyEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DataElementEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DataElementEntryFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DataElementEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DateRangeEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DateShiftEnum;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DynaItemEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.DynaItemEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.ICalculateProcess;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IRptQingAnalyzeRela;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IndexEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.IndexEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.ItemEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.ItemEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.OrgUnitEntryCollection;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.OrgUnitEntryInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeRelaFactory;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeRelaInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.ICalculateRptQingAnalyze;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class AbstractCalulateRptQingAnalyze
implements ICalculateRptQingAnalyze {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.AbstractCalulateRptQingAnalyze");
    public RptQingAnalyzeInfo theme;
    public Context ctx;

    public AbstractCalulateRptQingAnalyze(Context ctx, RptQingAnalyzeInfo theme) {
        this.theme = theme;
        this.ctx = ctx;
    }

    @Override
    public List<FullOrgUnitInfo> getOrgUnit() throws BOSException {
        ArrayList<FullOrgUnitInfo> orgUnits = new ArrayList<FullOrgUnitInfo>();
        int analyzeType = this.theme.getAnalyzeType().getValue();
        if (this.theme != null && !this.theme.getOrgUnit().isEmpty()) {
            List<FullOrgUnitInfo> realOrgs;
            OrgUnitEntryCollection orgUnitEntrys = this.theme.getOrgUnit();
            Iterator it = orgUnitEntrys.iterator();
            ArrayList<String> orgUnitIds = new ArrayList<String>();
            ArrayList<String> orgUnitNumbers = new ArrayList<String>();
            ArrayList<String> comIds = new ArrayList<String>();
            while (it.hasNext()) {
                OrgUnitEntryInfo orgUnitEntry = (OrgUnitEntryInfo)it.next();
                FullOrgUnitInfo orgUnit = orgUnitEntry.getOrgUnit();
                if (2 == analyzeType) {
                    orgUnits.add(orgUnit);
                    continue;
                }
                if (orgUnit.isIsUnion()) {
                    orgUnitIds.add(orgUnit.getId().toString());
                    orgUnitNumbers.add(orgUnit.getNumber());
                    continue;
                }
                comIds.add(orgUnit.getId().toString());
                orgUnits.add(orgUnit);
            }
            if (2 != analyzeType && !orgUnitIds.isEmpty() && !(realOrgs = this.getRealOrgUnitId(orgUnitIds, orgUnitNumbers)).isEmpty()) {
                orgUnits.addAll(realOrgs);
            }
        } else if (2 == this.theme.getAnalyzeType().getValue()) {
            this.getOrgRange(orgUnits);
        }
        return orgUnits;
    }

    private List<FullOrgUnitInfo> getOrgRange(List<FullOrgUnitInfo> orgUnits) throws BOSException {
        ArrayList<Object> params = new ArrayList<Object>();
        OrgTreeInfo orgTree = this.theme.getOrgTree();
        CSLServerHelper serverHelper = new CSLServerHelper(this.ctx);
        String lan = serverHelper.getFieldNameExtend();
        StringBuffer sql = new StringBuffer();
        sql.append(" Select unit.Fid id, unit.FNumber number, unit.FName" + lan + " name, unit.FIsUnion isUnion \n");
        sql.append(" From T_ORG_BaseUnit unit \n");
        if (orgTree != null) {
            sql.append(" Inner join T_ORG_Structure stru On stru.FUnitId = unit.FID \n");
        } else {
            sql.append(" Inner join T_ORG_Company com On com.fid = unit.fid \n");
        }
        if (orgTree == null) {
            sql.append(" Where unit.FIsUnion = ? And unit.fisCompanyOrgUnit = ? and com.fisBizUnit = ? \n");
            params.add(0);
            params.add(1);
            params.add(1);
        }
        if (orgTree != null) {
            sql.append(" Where stru.FTreeId = ?  \n");
            params.add(orgTree.getId().toString());
        }
        IRowSet rs = DbUtil.executeQuery(this.ctx, sql.toString(), params.toArray());
        try {
            FullOrgUnitInfo fullOrgUnit = null;
            while (rs.next()) {
                String id = rs.getString("id");
                String number = rs.getString("number");
                String name = rs.getString("name");
                boolean isUnion = rs.getBoolean("isUnion");
                fullOrgUnit = new FullOrgUnitInfo();
                fullOrgUnit.setId(BOSUuid.read((String)id));
                fullOrgUnit.setNumber(number);
                fullOrgUnit.setName(name);
                fullOrgUnit.setIsUnion(isUnion);
                orgUnits.add(fullOrgUnit);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return orgUnits;
    }

    private List<FullOrgUnitInfo> getRealOrgUnitId(List<String> orgUnitIds, List<String> orgUnitNumbers) throws BOSException {
        ArrayList<FullOrgUnitInfo> orgUnits = new ArrayList<FullOrgUnitInfo>();
        Set<String> treeIds = this.getTreeIdsByOrgId(orgUnitIds);
        if (!treeIds.isEmpty()) {
            HashSet<String> orgNums = new HashSet<String>(orgUnitNumbers);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("tree", treeIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("unit.number", orgNums, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("unit.isUnion", (Object)1, CompareType.EQUALS));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("unit.id"));
            view.getSelector().add(new SelectorItemInfo("unit.number"));
            view.getSelector().add(new SelectorItemInfo("unit.name"));
            view.getSelector().add(new SelectorItemInfo("unit.isUnion"));
            OrgStructureCollection orgStructures = OrgStructureFactory.getLocalInstance((Context)this.ctx).getOrgStructureCollection(view);
            if (orgStructures != null && !orgStructures.isEmpty()) {
                for (OrgStructureInfo orgStructure : orgStructures) {
                    FullOrgUnitInfo orgUnit = orgStructure.getUnit();
                    orgUnits.add(orgUnit);
                }
            }
        }
        return orgUnits;
    }

    private Set<String> getTreeIdsByOrgId(List<String> orgUnitIds) throws BOSException {
        OrgTreeInfo orgtree = this.theme.getOrgTree();
        HashSet<String> idSet = new HashSet<String>(orgUnitIds);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit", idSet, CompareType.INCLUDE));
        if (orgtree != null && orgtree.getId() != null) {
            String treeId = orgtree.getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("tree", (Object)treeId, CompareType.EQUALS));
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("tree.number"));
        OrgStructureCollection orgStructures = OrgStructureFactory.getLocalInstance((Context)this.ctx).getOrgStructureCollection(view);
        HashSet<String> treeNumbers = new HashSet<String>();
        Set<String> treeIds = new HashSet<String>();
        if (orgStructures != null && !orgStructures.isEmpty()) {
            for (OrgStructureInfo orgStructure : orgStructures) {
                treeNumbers.add(orgStructure.getTree().getNumber());
            }
        }
        if (!treeNumbers.isEmpty()) {
            treeIds = this.getRealTreeId(treeNumbers);
        }
        return treeIds;
    }

    private Set<String> getRealTreeId(Set<String> treeNums) throws BOSException {
        HashSet<String> treeIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", treeNums, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)8, CompareType.EQUALS));
        view.setFilter(filter);
        OrgTreeCollection trees = OrgTreeFactory.getLocalInstance((Context)this.ctx).getOrgTreeCollection(view);
        if (trees != null && !trees.isEmpty()) {
            Iterator it = trees.iterator();
            Date startDate = (Date)this.getStartTimes().get(2);
            Date endDate = (Date)this.getEndTimes().get(2);
            while (it.hasNext()) {
                OrgTreeInfo tree = (OrgTreeInfo)it.next();
                if (tree.isIsHide()) continue;
                Timestamp treeStratDate = tree.getStartDate();
                Timestamp treeEndDate = tree.getEndDate();
                if ((treeStratDate == null || startDate.compareTo(treeStratDate) > 0 || treeEndDate != null && endDate.compareTo(treeEndDate) < 0) && (treeStratDate == null || startDate.compareTo(treeStratDate) < 0 || treeEndDate != null && endDate.compareTo(treeEndDate) > 0)) continue;
                treeIds.add(tree.getId().toString());
            }
        }
        return treeIds;
    }

    @Override
    public List<RPTItemInfo> getRPTItem() {
        ArrayList<RPTItemInfo> rptItems = new ArrayList<RPTItemInfo>();
        if (this.theme != null && !this.theme.getRptItem().isEmpty()) {
            ItemEntryCollection itemEntrys = this.theme.getRptItem();
            Iterator it = itemEntrys.iterator();
            while (it.hasNext()) {
                ItemEntryInfo itemEntry = (ItemEntryInfo)it.next();
                RPTItemInfo rptItem = itemEntry.getRptItem();
                rptItems.add(rptItem);
            }
        }
        return rptItems;
    }

    @Override
    public List<AnalyzeIndexInfo> getAnalyzeIndex() {
        ArrayList<AnalyzeIndexInfo> analyzeIndexes = new ArrayList<AnalyzeIndexInfo>();
        if (this.theme != null && !this.theme.getAnalyzeIndex().isEmpty()) {
            IndexEntryCollection indexEntrys = this.theme.getAnalyzeIndex();
            Iterator it = indexEntrys.iterator();
            while (it.hasNext()) {
                IndexEntryInfo indexEntry = (IndexEntryInfo)it.next();
                AnalyzeIndexInfo index = indexEntry.getAnalyzeIndex();
                analyzeIndexes.add(index);
            }
        }
        return analyzeIndexes;
    }

    @Override
    public List<DataElementInfo> getDataElement() throws Exception {
        ArrayList<DataElementInfo> dataElements = new ArrayList<DataElementInfo>();
        if (this.theme != null && !this.theme.getDataElement().isEmpty()) {
            DataElementEntryCollection dataElementEntrys = this.theme.getDataElement();
            Iterator it = dataElementEntrys.iterator();
            while (it.hasNext()) {
                DataElementEntryInfo dataElementEntry = (DataElementEntryInfo)it.next();
                DataElementInfo dataElement = dataElementEntry.getDataElement();
                if (dataElement.getNumber() == null) {
                    if (!"6QH5/Jz6iRbgUxU3EazNlbnmwM4=".equals(dataElement.getId().toString())) continue;
                    FilterInfo filter = new FilterInfo();
                    FilterItemInfo filterItem = new FilterItemInfo("number", (Object)"TSPLY");
                    filter.getFilterItems().add(filterItem);
                    boolean isExist = DataElementFactory.getLocalInstance((Context)this.ctx).exists(filter);
                    if (!isExist) {
                        String resource = "com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource";
                        IDataElement iDataElement = DataElementFactory.getLocalInstance((Context)this.ctx);
                        DataElementInfo dataElementInfo = new DataElementInfo();
                        dataElementInfo.setNumber("TSPLY");
                        dataElementInfo.setName(EASCommonResource.getString((String)resource, (String)"downtemplate.dataelement.tsply", (Locale)LocaleUtils.locale_l1), LocaleUtils.locale_l1);
                        dataElementInfo.setName(EASCommonResource.getString((String)resource, (String)"downtemplate.dataelement.tsply", (Locale)LocaleUtils.locale_l2), LocaleUtils.locale_l2);
                        dataElementInfo.setName(EASCommonResource.getString((String)resource, (String)"downtemplate.dataelement.tsply", (Locale)LocaleUtils.locale_l3), LocaleUtils.locale_l3);
                        dataElementInfo.setIsUsedElim(true);
                        dataElementInfo.setIsSys(true);
                        dataElementInfo.setInterSeq(6);
                        dataElementInfo.setSeq(6);
                        CompanyOrgUnitInfo info = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("where id='00000000-0000-0000-0000-000000000000CCE7AED4'");
                        dataElementInfo.setTrackRecordCreator(info);
                        iDataElement.addnew((CoreBaseInfo)dataElementInfo);
                    }
                    DataElementInfo deInfo = DataElementFactory.getLocalInstance((Context)this.ctx).getDataElementInfo("select id,number,name,interseq where number = 'TSPLY'");
                    dataElementEntry.setDataElement(deInfo);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("dataElement"));
                    DataElementEntryFactory.getLocalInstance(this.ctx).updatePartial(dataElementEntry, selector);
                    dataElements.add(deInfo);
                    continue;
                }
                dataElements.add(dataElement);
            }
        }
        return dataElements;
    }

    @Override
    public List<CurrencyInfo> getCurrency() {
        ArrayList<CurrencyInfo> currencys = new ArrayList<CurrencyInfo>();
        if (this.theme != null && !this.theme.getCurrency().isEmpty()) {
            CurrencyEntryCollection currencyEntrys = this.theme.getCurrency();
            Iterator it = currencyEntrys.iterator();
            while (it.hasNext()) {
                CurrencyEntryInfo currencyEntry = (CurrencyEntryInfo)it.next();
                CurrencyInfo currency = currencyEntry.getCurrency();
                currencys.add(currency);
            }
        }
        return currencys;
    }

    @Override
    public List<DynaItemInfo> getDynaItem() {
        ArrayList<DynaItemInfo> dynaItems = new ArrayList<DynaItemInfo>();
        if (this.theme != null && !this.theme.getDynaItem().isEmpty()) {
            DynaItemEntryCollection dynaItemEntrys = this.theme.getDynaItem();
            Iterator it = dynaItemEntrys.iterator();
            DynaItemInfo dynaItem = null;
            while (it.hasNext()) {
                DynaItemEntryInfo dynaItemEntry = (DynaItemEntryInfo)it.next();
                String dynaItemNumber = dynaItemEntry.getDynaNumber();
                String dynaItemName = dynaItemEntry.getDynaName();
                dynaItem = new DynaItemInfo(dynaItemName, dynaItemNumber);
                dynaItems.add(dynaItem);
            }
        }
        return dynaItems;
    }

    @Override
    public List<Integer> getDataType() {
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        if (this.theme != null && this.theme.getDataType() != null) {
            String dataTypeStr = this.theme.getDataType();
            String[] dataTypeStrs = dataTypeStr.split(",");
            int size = dataTypeStrs.length;
            for (int i = 0; i < size; ++i) {
                int dataType = Integer.valueOf(dataTypeStrs[i]);
                dataTypes.add(dataType);
            }
        }
        return dataTypes;
    }

    @Override
    public List<Integer> getAdjustStatus() {
        ArrayList<Integer> adjustStatuss = new ArrayList<Integer>();
        if (this.theme != null && this.theme.getAdjustStatus() != null) {
            String adjustStatusStr = this.theme.getAdjustStatus();
            String[] adjustStatusStrs = adjustStatusStr.split(",");
            int size = adjustStatusStrs.length;
            for (int i = 0; i < size; ++i) {
                int adjustStatus = Integer.valueOf(adjustStatusStrs[i]);
                adjustStatuss.add(adjustStatus);
            }
        }
        return adjustStatuss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAnalyzeData() throws BOSException, EASBizException {
        block21: {
            String oldQsId;
            block17: {
                BudgetDataSourceWriter writer;
                String tempQsId;
                block15: {
                    block20: {
                        block16: {
                            oldQsId = null;
                            tempQsId = null;
                            writer = null;
                            boolean isLock = false;
                            isLock = this.currentThemeIsLock(isLock);
                            if (!isLock) break block15;
                            if (writer == null) break block16;
                            writer.close(null);
                            this.updateQsId(oldQsId, tempQsId);
                            break block20;
                        }
                        if (!"000000000000000000000000000=".equals(oldQsId)) {
                            this.deleteFile(this.ctx, oldQsId);
                            logger.info((Object)("delete qing file success ! file name: " + oldQsId));
                        }
                        String themeId = this.theme.getId().toString();
                        RptQingAnalyzeRelaFactory.getLocalInstance(this.ctx).delete("where analyzeId = '" + themeId + "'");
                    }
                    this.updateLastCalculateTime();
                    return;
                }
                try {
                    this.delOldCalProcRecord();
                    this.writeCalculateProcessBegin(CalculateProcessEnum.CALCULATING);
                    oldQsId = this.getOldQsId();
                    List<Object[]> data = this.getData();
                    if (data != null && !data.isEmpty()) {
                        MetaInfo metaInfo = this.getMeta();
                        tempQsId = Uuid.create().toString();
                        logger.debug((Object)"begin write newData!");
                        logger.info((Object)("create tempQsId :" + tempQsId));
                        long time = System.currentTimeMillis();
                        writer = BudgetFacade.createDataSourceWriter((String)tempQsId, (Context)this.ctx);
                        writer.start(metaInfo);
                        for (Object[] _row : data) {
                            writer.writeData(_row);
                        }
                        logger.info((Object)("end write newData! use = " + (System.currentTimeMillis() - time) + "ms."));
                        logger.info((Object)("write newData! size = " + data.size()));
                        data.clear();
                        this.delLogForIndexAnalyze();
                        AnalyzeTypeEnum analyzeType = this.theme.getAnalyzeType();
                        if (analyzeType.getValue() != 2) {
                            this.updateCalculateProcess(CalculateProcessEnum.CALSUCCESS);
                        }
                    } else {
                        this.updateCalculateProcess(CalculateProcessEnum.DATAISNULL);
                    }
                    if (writer == null) break block17;
                }
                catch (Exception e) {
                    block22: {
                        block18: {
                            try {
                                this.updateCalculateProcess(CalculateProcessEnum.CalError);
                                logger.error((Object)"writeAnalyzeData: ", (Throwable)e);
                                if (writer == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (writer != null) {
                                    writer.close(null);
                                    this.updateQsId(oldQsId, tempQsId);
                                } else {
                                    if (!"000000000000000000000000000=".equals(oldQsId)) {
                                        this.deleteFile(this.ctx, oldQsId);
                                        logger.info((Object)("delete qing file success ! file name: " + oldQsId));
                                    }
                                    String themeId = this.theme.getId().toString();
                                    RptQingAnalyzeRelaFactory.getLocalInstance(this.ctx).delete("where analyzeId = '" + themeId + "'");
                                }
                                this.updateLastCalculateTime();
                                throw throwable;
                            }
                            writer.close(null);
                            this.updateQsId(oldQsId, tempQsId);
                            break block22;
                        }
                        if (!"000000000000000000000000000=".equals(oldQsId)) {
                            this.deleteFile(this.ctx, oldQsId);
                            logger.info((Object)("delete qing file success ! file name: " + oldQsId));
                        }
                        String themeId = this.theme.getId().toString();
                        RptQingAnalyzeRelaFactory.getLocalInstance(this.ctx).delete("where analyzeId = '" + themeId + "'");
                    }
                    this.updateLastCalculateTime();
                }
                writer.close(null);
                this.updateQsId(oldQsId, tempQsId);
                break block21;
            }
            if (!"000000000000000000000000000=".equals(oldQsId)) {
                this.deleteFile(this.ctx, oldQsId);
                logger.info((Object)("delete qing file success ! file name: " + oldQsId));
            }
            String themeId = this.theme.getId().toString();
            RptQingAnalyzeRelaFactory.getLocalInstance(this.ctx).delete("where analyzeId = '" + themeId + "'");
        }
        this.updateLastCalculateTime();
    }

    private void delLogForIndexAnalyze() throws EASBizException, BOSException {
        AnalyzeTypeEnum analyzeType = this.theme.getAnalyzeType();
        if (analyzeType.getValue() == 2) {
            String themeId = this.theme.getId().toString();
            CalculateProcessFactory.getLocalInstance(this.ctx).delete("where analyze = '" + themeId + "' and data is null and calculateProcess = " + 0 + "");
        }
    }

    private void updateCalculateProcess(CalculateProcessEnum calculateProcessEnum) throws EASBizException, BOSException {
        ICalculateProcess iCal = CalculateProcessFactory.getLocalInstance(this.ctx);
        String themeId = this.theme.getId().toString();
        CalculateProcessCollection calPros = iCal.getCalculateProcessCollection("where analyze = '" + themeId + "' and calculateProcess <> " + 4 + "");
        Timestamp time = this.getTime();
        if (calPros != null && !calPros.isEmpty()) {
            CoreBaseCollection colls = new CoreBaseCollection();
            Iterator it = calPros.iterator();
            while (it.hasNext()) {
                CalculateProcessInfo calPro = (CalculateProcessInfo)it.next();
                calPro.setCalculateTime(time);
                List<String> errorKeys = this.getErrorKeys();
                if (calculateProcessEnum.getValue() == 1 && !CslRptUtil.isListEmpty(errorKeys)) {
                    int year = calPro.getYear();
                    int period = calPro.getPeriod();
                    String orgId = calPro.getOrgUnitId();
                    String currencyId = calPro.getCurrencyId();
                    String errorKey = themeId + year + period + orgId + currencyId;
                    if (errorKeys != null && errorKeys.contains(errorKey)) {
                        calPro.setCalculateProcess(CalculateProcessEnum.CALFAIL);
                    } else {
                        calPro.setCalculateProcess(calculateProcessEnum);
                    }
                } else if (calPro.getCalculateProcess().getValue() == 2) {
                    calPro.setCalculateProcess(CalculateProcessEnum.CALFAIL);
                } else {
                    calPro.setCalculateProcess(calculateProcessEnum);
                }
                colls.add((CoreBaseInfo)calPro);
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("calculateProcess"));
            selector.add(new SelectorItemInfo("calculateTime"));
            iCal.updatePartialBatchData((IObjectCollection)colls, selector);
        }
    }

    public List<String> getErrorKeys() {
        return null;
    }

    private void delOldCalProcRecord() throws EASBizException, BOSException {
        String id = this.theme.getId().toString();
        CalculateProcessFactory.getLocalInstance(this.ctx).delete("where analyze = '" + id + "'");
    }

    private String writeCalculateProcessBegin(CalculateProcessEnum calProcEnum) throws EASBizException, BOSException {
        CalculateProcessInfo calProcess = new CalculateProcessInfo();
        String number = this.theme.getNumber();
        String name = this.theme.getName();
        String analyzeName = number + "\uff08" + name + "\uff09";
        calProcess.setAnalyzeName(analyzeName);
        calProcess.setAnalyze(this.theme);
        calProcess.setCalculateProcess(calProcEnum);
        UserInfo user = this.getUserInfo();
        calProcess.setCalculator(user);
        Timestamp time = this.getTime();
        calProcess.setCalculateTime(time);
        IObjectPK id = CalculateProcessFactory.getLocalInstance(this.ctx).addnew(calProcess);
        return id.toString();
    }

    public Timestamp getTime() {
        Timestamp time = QueryBalanceUtil.getTime();
        return time;
    }

    public UserInfo getUserInfo() throws EASBizException, BOSException {
        UserInfo user = UserFactory.getLocalInstance((Context)this.ctx).getUserInfo(this.ctx.getCaller());
        return user;
    }

    private void updateLastCalculateTime() throws EASBizException, BOSException {
        long time = System.currentTimeMillis();
        Timestamp calTime = new Timestamp(time);
        this.theme.setLastCalculateTime(calTime);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("lastCalculateTime"));
        RptQingAnalyzeFactory.getLocalInstance(this.ctx).updatePartial(this.theme, selector);
    }

    private void updateQsId(String oldQsId, String tempQsId) throws BOSException, EASBizException {
        String themeId = this.theme.getId().toString();
        logger.info((Object)("begin to execute method updateQsId, qsId : " + oldQsId + " ,tempQsId :" + tempQsId + " ,themeId :" + themeId));
        if (!oldQsId.equals(tempQsId)) {
            RptQingAnalyzeRelaInfo info = RptQingAnalyzeRelaFactory.getLocalInstance(this.ctx).getRptQingAnalyzeRelaInfo("where analyzeId = '" + themeId + "'");
            info.setQingFileId(tempQsId);
            info.setIsLock(false);
            RptQingAnalyzeRelaFactory.getLocalInstance(this.ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), info);
            if (!"000000000000000000000000000=".equals(oldQsId)) {
                this.deleteFile(this.ctx, oldQsId);
                logger.info((Object)("delete qing file success ! file name: " + oldQsId));
            }
        }
    }

    private void deleteFile(Context ctx, String qsId) throws BOSException {
        try {
            BudgetFacade.deleteFile((String)qsId, (Context)ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("delete qing file failed!!!!!!!!!,fileName:" + qsId), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("delete qing file success ! file name: " + qsId));
    }

    private boolean currentThemeIsLock(boolean isLock) throws EASBizException, BOSException {
        String themeId = this.theme.getId().toString();
        boolean isExist = RptQingAnalyzeRelaFactory.getLocalInstance(this.ctx).exists("where IsLock =1 and analyzeId = '" + themeId + "'");
        if (isExist) {
            this.writeCalculateProcessBegin(CalculateProcessEnum.ISLOCK);
            isLock = true;
        }
        return isLock;
    }

    private String getOldQsId() throws EASBizException, BOSException {
        String themeId = this.theme.getId().toString();
        IRptQingAnalyzeRela iRela = RptQingAnalyzeRelaFactory.getLocalInstance(this.ctx);
        boolean isExist = iRela.exists("where analyzeId = '" + themeId + "'");
        String qsfId = null;
        if (isExist) {
            RptQingAnalyzeRelaInfo info = iRela.getRptQingAnalyzeRelaInfo("where analyzeId = '" + themeId + "'");
            info.setIsLock(true);
            iRela.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
            qsfId = info.getQingFileId();
        } else {
            qsfId = "000000000000000000000000000=";
            RptQingAnalyzeRelaInfo newInfo = new RptQingAnalyzeRelaInfo();
            newInfo.setAnalyzeId(this.theme);
            newInfo.setQingFileId(qsfId);
            newInfo.setIsLock(true);
            iRela.addnew(newInfo);
        }
        return qsfId;
    }

    @Override
    public MetaInfo getMeta() {
        return null;
    }

    @Override
    public List<Object[]> getData() throws Exception {
        return null;
    }

    public List getStartTimes() {
        RptPeriodTypeEnum periodType = this.theme.getPeriodType();
        DateRangeEnum dateRange = this.theme.getDateRange();
        DateShiftEnum dateShift = this.theme.getDateShift();
        BaseDateEnum baseDate = this.theme.getBaseDate();
        Timestamp date = new Timestamp(new Date().getTime());
        if (baseDate.getValue() == 1) {
            date = this.theme.getSpecifyDate();
        }
        List startTimes = new ArrayList();
        block0 : switch (dateRange.getValue()) {
            case 0: {
                startTimes = this.getCurrentYearStartTimeList(periodType);
                break;
            }
            case 1: {
                startTimes = this.getLastYearStartTimeList(periodType);
                break;
            }
            case 2: {
                int beforeShiftValue = this.theme.getToBefore();
                beforeShiftValue = -1 * beforeShiftValue;
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.setTime(date);
                switch (dateShift.getValue()) {
                    case 0: {
                        startTimes = this.getYearShiftStartTimeList(periodType, beforeShiftValue, calendar);
                        break block0;
                    }
                    case 1: {
                        startTimes = this.getQuarterlyShiftStartTimeList(periodType, beforeShiftValue, calendar);
                        break block0;
                    }
                    case 2: {
                        startTimes = this.getMonthlyShiftStartTimeList(periodType, beforeShiftValue, calendar);
                        break block0;
                    }
                    case 3: {
                        startTimes = this.getDateShiftStartTimeList(periodType, beforeShiftValue, calendar);
                        break block0;
                    }
                }
                break;
            }
        }
        return startTimes;
    }

    public List getEndTimes() {
        RptPeriodTypeEnum periodType = this.theme.getPeriodType();
        DateRangeEnum dateRange = this.theme.getDateRange();
        DateShiftEnum dateShift = this.theme.getDateShift();
        BaseDateEnum baseDate = this.theme.getBaseDate();
        Timestamp date = new Timestamp(new Date().getTime());
        if (baseDate.getValue() == 1) {
            date = this.theme.getSpecifyDate();
        }
        List endTimes = new ArrayList();
        block0 : switch (dateRange.getValue()) {
            case 0: {
                endTimes = this.getCurrentYearEndTimeList(periodType);
                break;
            }
            case 1: {
                endTimes = this.getLastYearEndTimeList(periodType);
                break;
            }
            case 2: {
                int afterShiftValue = this.theme.getToAfter();
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.setTime(date);
                switch (dateShift.getValue()) {
                    case 0: {
                        endTimes = this.getYearShiftEndTimeList(periodType, afterShiftValue, calendar);
                        break block0;
                    }
                    case 1: {
                        endTimes = this.getQuarterlyShiftEndTimeList(periodType, afterShiftValue, calendar);
                        break block0;
                    }
                    case 2: {
                        endTimes = this.getMonthlyShiftEndTimeList(periodType, afterShiftValue, calendar);
                        break block0;
                    }
                    case 3: {
                        endTimes = this.getDateShiftEndTimeList(periodType, afterShiftValue, calendar);
                        break block0;
                    }
                }
                break;
            }
        }
        return endTimes;
    }

    private List getQuarterlyShiftEndTimeList(RptPeriodTypeEnum periodType, int afterShiftValue, Calendar calendar) {
        calendar.add(2, afterShiftValue *= 3);
        Date endDate = this.getLastMonthForQuarter(calendar);
        List endTimes = RPTDateUtil.getRptPeriod((Date)endDate, (RptPeriodTypeEnum)periodType);
        int endYear = new Integer(endTimes.get(0).toString());
        int endPeriod = new Integer(endTimes.get(1).toString());
        endDate = RPTDateUtil.getPeriodLastDate((int)endYear, (int)endPeriod, (RptPeriodTypeEnum)periodType);
        endTimes.clear();
        endTimes.add(endYear);
        endTimes.add(endPeriod);
        endTimes.add(endDate);
        return endTimes;
    }

    private Date getLastMonthForQuarter(Calendar calendar) {
        int month = calendar.get(2) + 1;
        if (month < 4) {
            month = 2;
        } else if (month < 7) {
            month = 5;
        } else if (month < 10) {
            month = 8;
        } else if (month <= 12) {
            month = 11;
        }
        calendar.set(2, month);
        return calendar.getTime();
    }

    private List getYearShiftEndTimeList(RptPeriodTypeEnum periodType, int afterShiftValue, Calendar calendar) {
        calendar.add(1, afterShiftValue);
        int year = calendar.get(1);
        Date endDate = this.getLastDateOfYear(year);
        List endTimes = RPTDateUtil.getRptPeriod((Date)endDate, (RptPeriodTypeEnum)periodType);
        int endYear = new Integer(endTimes.get(0).toString());
        int endPeriod = new Integer(endTimes.get(1).toString());
        endDate = RPTDateUtil.getPeriodLastDate((int)endYear, (int)endPeriod, (RptPeriodTypeEnum)periodType);
        endTimes.clear();
        endTimes.add(endYear);
        endTimes.add(endPeriod);
        endTimes.add(endDate);
        return endTimes;
    }

    private List getLastYearEndTimeList(RptPeriodTypeEnum periodType) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        int year = calendar.get(1);
        Date endDate = this.getLastDateOfYear(year);
        List endTimes = RPTDateUtil.getRptPeriod((Date)endDate, (RptPeriodTypeEnum)periodType);
        int endYear = new Integer(endTimes.get(0).toString());
        int endPeriod = new Integer(endTimes.get(1).toString());
        endDate = RPTDateUtil.getPeriodLastDate((int)endYear, (int)endPeriod, (RptPeriodTypeEnum)periodType);
        endTimes.clear();
        endTimes.add(endYear);
        endTimes.add(endPeriod);
        endTimes.add(endDate);
        return endTimes;
    }

    private List getCurrentYearEndTimeList(RptPeriodTypeEnum periodType) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        Date endDate = this.getLastDateOfYear(year);
        List endTimes = RPTDateUtil.getRptPeriod((Date)endDate, (RptPeriodTypeEnum)periodType);
        int endYear = new Integer(endTimes.get(0).toString());
        int endPeriod = new Integer(endTimes.get(1).toString());
        endDate = RPTDateUtil.getPeriodLastDate((int)endYear, (int)endPeriod, (RptPeriodTypeEnum)periodType);
        endTimes.clear();
        endTimes.add(endYear);
        endTimes.add(endPeriod);
        endTimes.add(endDate);
        return endTimes;
    }

    private Date getLastDateOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        return calendar.getTime();
    }

    private List getMonthlyShiftStartTimeList(RptPeriodTypeEnum periodType, int beforeShiftValue, Calendar calendar) {
        calendar.add(2, beforeShiftValue);
        Date startDate = calendar.getTime();
        List startTimes = RPTDateUtil.getRptPeriod((Date)startDate, (RptPeriodTypeEnum)periodType);
        int startYear = new Integer(startTimes.get(0).toString());
        int startPeriod = new Integer(startTimes.get(1).toString());
        startDate = RPTDateUtil.getPeriodFirstDate((int)startYear, (int)startPeriod, (RptPeriodTypeEnum)periodType);
        startTimes.clear();
        startTimes.add(startYear);
        startTimes.add(startPeriod);
        startTimes.add(startDate);
        return startTimes;
    }

    private List getDateShiftStartTimeList(RptPeriodTypeEnum periodType, int beforeShiftValue, Calendar calendar) {
        calendar.add(5, beforeShiftValue);
        Date startDate = calendar.getTime();
        List startTimes = RPTDateUtil.getRptPeriod((Date)startDate, (RptPeriodTypeEnum)periodType);
        return startTimes;
    }

    private List getMonthlyShiftEndTimeList(RptPeriodTypeEnum periodType, int afterShiftValue, Calendar calendar) {
        calendar.add(2, afterShiftValue);
        Date endDate = calendar.getTime();
        List endTimes = RPTDateUtil.getRptPeriod((Date)endDate, (RptPeriodTypeEnum)periodType);
        int endYear = new Integer(endTimes.get(0).toString());
        int endPeriod = new Integer(endTimes.get(1).toString());
        endDate = RPTDateUtil.getPeriodLastDate((int)endYear, (int)endPeriod, (RptPeriodTypeEnum)periodType);
        endTimes.clear();
        endTimes.add(endYear);
        endTimes.add(endPeriod);
        endTimes.add(endDate);
        return endTimes;
    }

    private List getDateShiftEndTimeList(RptPeriodTypeEnum periodType, int afterShiftValue, Calendar calendar) {
        calendar.add(5, afterShiftValue);
        Date endDate = calendar.getTime();
        List endTimes = RPTDateUtil.getRptPeriod((Date)endDate, (RptPeriodTypeEnum)periodType);
        return endTimes;
    }

    private List getQuarterlyShiftStartTimeList(RptPeriodTypeEnum periodType, int beforeShiftValue, Calendar calendar) {
        calendar.add(2, beforeShiftValue *= 3);
        Date startDate = this.getFirstMonthForQuarter(calendar);
        List startTimes = RPTDateUtil.getRptPeriod((Date)startDate, (RptPeriodTypeEnum)periodType);
        int startYear = new Integer(startTimes.get(0).toString());
        int startPeriod = new Integer(startTimes.get(1).toString());
        startDate = RPTDateUtil.getPeriodFirstDate((int)startYear, (int)startPeriod, (RptPeriodTypeEnum)periodType);
        startTimes.clear();
        startTimes.add(startYear);
        startTimes.add(startPeriod);
        startTimes.add(startDate);
        return startTimes;
    }

    private Date getFirstMonthForQuarter(Calendar calendar) {
        int month = calendar.get(2) + 1;
        if (month < 4) {
            month = 0;
        } else if (month < 7) {
            month = 3;
        } else if (month < 10) {
            month = 6;
        } else if (month <= 12) {
            month = 9;
        }
        calendar.set(2, month);
        return calendar.getTime();
    }

    private List getYearShiftStartTimeList(RptPeriodTypeEnum periodType, int beforeShiftValue, Calendar calendar) {
        calendar.add(1, beforeShiftValue);
        int year = calendar.get(1);
        Date startDate = this.getFirstDateOfYear(year);
        List startTimes = RPTDateUtil.getRptPeriod((Date)startDate, (RptPeriodTypeEnum)periodType);
        int startYear = new Integer(startTimes.get(0).toString());
        int startPeriod = new Integer(startTimes.get(1).toString());
        startDate = RPTDateUtil.getPeriodFirstDate((int)startYear, (int)startPeriod, (RptPeriodTypeEnum)periodType);
        startTimes.clear();
        startTimes.add(startYear);
        startTimes.add(startPeriod);
        startTimes.add(startDate);
        return startTimes;
    }

    private List getLastYearStartTimeList(RptPeriodTypeEnum periodType) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        int year = calendar.get(1);
        Date startDate = this.getFirstDateOfYear(year);
        List startTimes = RPTDateUtil.getRptPeriod((Date)startDate, (RptPeriodTypeEnum)periodType);
        int startYear = new Integer(startTimes.get(0).toString());
        int startPeriod = new Integer(startTimes.get(1).toString());
        startDate = RPTDateUtil.getPeriodFirstDate((int)startYear, (int)startPeriod, (RptPeriodTypeEnum)periodType);
        startTimes.clear();
        startTimes.add(startYear);
        startTimes.add(startPeriod);
        startTimes.add(startDate);
        return startTimes;
    }

    private List getCurrentYearStartTimeList(RptPeriodTypeEnum periodType) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        Date startDate = this.getFirstDateOfYear(year);
        List startTimes = RPTDateUtil.getRptPeriod((Date)startDate, (RptPeriodTypeEnum)periodType);
        int startYear = new Integer(startTimes.get(0).toString());
        int startPeriod = new Integer(startTimes.get(1).toString());
        startDate = RPTDateUtil.getPeriodFirstDate((int)startYear, (int)startPeriod, (RptPeriodTypeEnum)periodType);
        startTimes.clear();
        startTimes.add(startYear);
        startTimes.add(startPeriod);
        startTimes.add(startDate);
        return startTimes;
    }

    private Date getFirstDateOfYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        return calendar.getTime();
    }

    public String getPeriodString(RptPeriodTypeEnum periodType, String PeriodStr) {
        int period = Integer.valueOf(PeriodStr);
        if (periodType.getValue() == 1) {
            if (period < 10) {
                PeriodStr = "00" + PeriodStr;
            } else if (period < 100) {
                PeriodStr = "0" + PeriodStr;
            }
        } else if (period < 10) {
            PeriodStr = "0" + PeriodStr;
        }
        return PeriodStr;
    }

    public Date getDate(DateFormat dateFormat, RptPeriodTypeEnum periodType, String year, String period) throws ParseException {
        List times = RPTDateUtil.getRptYearAndPeriodAndDate((int)Integer.valueOf(year), (int)Integer.valueOf(period), (RptPeriodTypeEnum)periodType);
        Date date = (Date)times.get(2);
        String dateF = dateFormat.format(date);
        date = dateFormat.parse(dateF);
        return date;
    }
}

