/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CommonRptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.AbstractCalulateRptQingAnalyze;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.util.RptQingAnalyzeUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class CalculateCommonRptQingAnalyze
extends AbstractCalulateRptQingAnalyze {
    public CalculateCommonRptQingAnalyze(Context ctx, RptQingAnalyzeInfo theme) {
        super(ctx, theme);
    }

    @Override
    public MetaInfo getMeta() {
        MetaInfo metaInfo = new MetaInfo();
        List<Integer> adjusts = this.getAdjustStatus();
        metaInfo.addField("FBizDate", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "102_bizDate"), DataType.DATE);
        metaInfo.addField("FYear", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "77_year"), DataType.STRING);
        metaInfo.addField("FPeriod", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "78_period"), DataType.STRING);
        metaInfo.addField("FOrgUnitId", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "88_orgId"), DataType.STRING);
        metaInfo.addField("FOrgUnitNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "46_orgNum"), DataType.STRING);
        metaInfo.addField("FOrgUnitParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "63_orgPNum"), DataType.STRING);
        metaInfo.addField("FOrgUnitName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "47_orgName"), DataType.STRING);
        metaInfo.addField("FRptItemNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "51_rptItemNum"), DataType.STRING);
        metaInfo.addField("FRptItemParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "65_rptItemPNum"), DataType.STRING);
        metaInfo.addField("FRptItemName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "52_rptItemName"), DataType.STRING);
        metaInfo.addField("FDataElementNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "53_deNumber"), DataType.STRING);
        metaInfo.addField("FDataElementParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "66_dePNum"), DataType.STRING);
        metaInfo.addField("FDataElementName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "54_deName"), DataType.STRING);
        metaInfo.addField("FCurrencyNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "48_curNum"), DataType.STRING);
        metaInfo.addField("FCurrencyParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "64_curPNum"), DataType.STRING);
        metaInfo.addField("FCurrencyName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "49_curName"), DataType.STRING);
        metaInfo.addField("FdataType", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "55_dataType"), DataType.STRING);
        if (adjusts.contains(0)) {
            metaInfo.addField("FBeforeAdjustValue", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "56_beforeAdjust"), DataType.NUMBER);
        }
        if (adjusts.contains(2)) {
            metaInfo.addField("FAdjustValue", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "57_adjust"), DataType.NUMBER);
        }
        if (adjusts.contains(1)) {
            metaInfo.addField("FAfterAdjustValue", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "58_afterAdjust"), DataType.NUMBER);
        }
        return metaInfo;
    }

    @Override
    public List<Object[]> getData() throws Exception {
        return this.getCommonData();
    }

    private List<Object[]> getCommonData() throws Exception {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        List<Integer> adjusts = this.getAdjustStatus();
        StringBuffer sql = new StringBuffer();
        CSLServerHelper serverHelper = new CSLServerHelper(this.ctx);
        String lan = serverHelper.getFieldNameExtend();
        ArrayList params = new ArrayList();
        if (adjusts.contains(0) || adjusts.contains(1)) {
            sql = this.getSql(sql, 0, lan, params);
        }
        if (adjusts.contains(2) || adjusts.contains(1)) {
            sql = this.getSql(sql, 2, lan, params);
        }
        IRowSet rs = DbUtil.executeQuery(this.ctx, sql.toString(), params.toArray());
        try {
            CommonRptQingAnalyzeInfo commonInfo = null;
            ArrayList<CommonRptQingAnalyzeInfo> beforeAdjustRecords = new ArrayList<CommonRptQingAnalyzeInfo>();
            ArrayList<CommonRptQingAnalyzeInfo> adjustValueRecords = new ArrayList<CommonRptQingAnalyzeInfo>();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            RptPeriodTypeEnum periodType = this.theme.getPeriodType();
            Date bizDate = null;
            while (rs.next()) {
                commonInfo = new CommonRptQingAnalyzeInfo();
                String year = rs.getString("year");
                String period = rs.getString("period");
                period = this.getPeriodString(periodType, period);
                bizDate = this.getDate(dateFormat, periodType, year, period);
                commonInfo.setBizDate(bizDate);
                commonInfo.setYear(year);
                commonInfo.setPeriod(period);
                commonInfo.setCompanyId(rs.getString("comId"));
                commonInfo.setCompanyNumber(rs.getString("comNum"));
                commonInfo.setCompanyParent(null);
                commonInfo.setCompanyName(rs.getString("comName"));
                commonInfo.setRptItemNumber(rs.getString("itemNum"));
                commonInfo.setRptItemParent(null);
                commonInfo.setRptItemName(rs.getString("itemName"));
                commonInfo.setDataElementNumber(rs.getString("deNum"));
                commonInfo.setDataElementParent(null);
                commonInfo.setDataElementName(rs.getString("deName"));
                commonInfo.setCurrencyNumber(rs.getString("currNum"));
                commonInfo.setCurrencyParent(null);
                commonInfo.setCurrencyName(rs.getString("currName"));
                commonInfo.setDataType(rs.getString("valueType"));
                int adjustStatus = rs.getInt("isAdjust");
                BigDecimal value = rs.getBigDecimal("value");
                if (adjustStatus == 0) {
                    commonInfo.setBeforeAdjustValue(value);
                    beforeAdjustRecords.add(commonInfo);
                    continue;
                }
                if (adjustStatus != 1) continue;
                commonInfo.setAdjustValue(value);
                adjustValueRecords.add(commonInfo);
            }
            if (!beforeAdjustRecords.isEmpty() || !adjustValueRecords.isEmpty()) {
                this.mergeData(data, beforeAdjustRecords, adjustValueRecords);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return data;
    }

    private void mergeData(List<Object[]> mergeDatas, List<CommonRptQingAnalyzeInfo> beforeAdjustRecords, List<CommonRptQingAnalyzeInfo> adjustValueRecords) {
        Object[] data = null;
        List<Integer> adjusts = this.getAdjustStatus();
        if (adjusts.size() == 3) {
            this.mergeBeforeAjustAndAdjustValue(beforeAdjustRecords, adjustValueRecords);
            for (CommonRptQingAnalyzeInfo commonInfo : beforeAdjustRecords) {
                data = new Object[20];
                this.setCommonData(data, commonInfo);
                data[17] = commonInfo.getBeforeAdjustValue();
                data[18] = commonInfo.getAdjustValue();
                data[19] = commonInfo.getAfterAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 2 && adjusts.contains(0) && adjusts.contains(2)) {
            this.mergeBeforeAjustAndAdjustValue(beforeAdjustRecords, adjustValueRecords);
            for (CommonRptQingAnalyzeInfo commonInfo : beforeAdjustRecords) {
                data = new Object[19];
                this.setCommonData(data, commonInfo);
                data[17] = commonInfo.getBeforeAdjustValue();
                data[18] = commonInfo.getAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 2 && adjusts.contains(0) && adjusts.contains(1)) {
            this.mergeBeforeAjustAndAdjustValue(beforeAdjustRecords, adjustValueRecords);
            for (CommonRptQingAnalyzeInfo commonInfo : beforeAdjustRecords) {
                data = new Object[19];
                this.setCommonData(data, commonInfo);
                data[17] = commonInfo.getBeforeAdjustValue();
                data[18] = commonInfo.getAfterAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 2 && adjusts.contains(2) && adjusts.contains(1)) {
            this.mergeBeforeAjustAndAdjustValue(beforeAdjustRecords, adjustValueRecords);
            for (CommonRptQingAnalyzeInfo commonInfo : beforeAdjustRecords) {
                data = new Object[19];
                this.setCommonData(data, commonInfo);
                data[17] = commonInfo.getAdjustValue();
                data[18] = commonInfo.getAfterAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 1 && adjusts.contains(0)) {
            for (CommonRptQingAnalyzeInfo commonInfo : beforeAdjustRecords) {
                data = new Object[18];
                this.setCommonData(data, commonInfo);
                data[17] = commonInfo.getBeforeAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 1 && adjusts.contains(2)) {
            this.getComboAdjustValue(adjustValueRecords);
            for (CommonRptQingAnalyzeInfo commonInfo : adjustValueRecords) {
                data = new Object[18];
                this.setCommonData(data, commonInfo);
                data[17] = commonInfo.getAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 1 && adjusts.contains(1)) {
            this.mergeBeforeAjustAndAdjustValue(beforeAdjustRecords, adjustValueRecords);
            for (CommonRptQingAnalyzeInfo commonInfo : beforeAdjustRecords) {
                data = new Object[18];
                this.setCommonData(data, commonInfo);
                data[17] = commonInfo.getAfterAdjustValue();
                mergeDatas.add(data);
            }
        }
        beforeAdjustRecords.clear();
        adjustValueRecords.clear();
    }

    private void mergeBeforeAjustAndAdjustValue(List<CommonRptQingAnalyzeInfo> beforeAdjustRecords, List<CommonRptQingAnalyzeInfo> adjustValueRecords) {
        ArrayList<CommonRptQingAnalyzeInfo> removedForAdjust = new ArrayList<CommonRptQingAnalyzeInfo>();
        if (beforeAdjustRecords != null && !beforeAdjustRecords.isEmpty()) {
            for (CommonRptQingAnalyzeInfo beforeAdjustCommonInfo : beforeAdjustRecords) {
                String beforeAdjustKey = this.getKey(beforeAdjustCommonInfo);
                BigDecimal beforeAdjust = beforeAdjustCommonInfo.getBeforeAdjustValue();
                if (!adjustValueRecords.isEmpty()) {
                    boolean isAdded = false;
                    this.getComboAdjustValue(adjustValueRecords);
                    for (CommonRptQingAnalyzeInfo adjustCommonInfo : adjustValueRecords) {
                        String adjustKey = this.getKey(adjustCommonInfo);
                        BigDecimal adjustValue = adjustCommonInfo.getAdjustValue();
                        if (!beforeAdjustKey.equals(adjustKey)) continue;
                        beforeAdjustCommonInfo.setAdjustValue(adjustValue);
                        BigDecimal afterAdjustValue = beforeAdjust.add(adjustValue);
                        beforeAdjustCommonInfo.setAfterAdjustValue(afterAdjustValue);
                        removedForAdjust.add(adjustCommonInfo);
                        isAdded = true;
                    }
                    if (isAdded) continue;
                    beforeAdjustCommonInfo.setAfterAdjustValue(beforeAdjust);
                    continue;
                }
                beforeAdjustCommonInfo.setAfterAdjustValue(beforeAdjust);
            }
            if (!removedForAdjust.isEmpty()) {
                adjustValueRecords.removeAll(removedForAdjust);
                if (!adjustValueRecords.isEmpty()) {
                    for (CommonRptQingAnalyzeInfo adjustCommonInfo : adjustValueRecords) {
                        adjustCommonInfo.setAfterAdjustValue(adjustCommonInfo.getAdjustValue());
                        beforeAdjustRecords.add(adjustCommonInfo);
                    }
                }
                removedForAdjust.clear();
            }
        } else if (adjustValueRecords != null && !adjustValueRecords.isEmpty()) {
            this.getComboAdjustValue(adjustValueRecords);
            for (CommonRptQingAnalyzeInfo commonInfo : adjustValueRecords) {
                BigDecimal adjustValue = commonInfo.getAdjustValue();
                commonInfo.setAfterAdjustValue(adjustValue);
            }
        }
    }

    private void getComboAdjustValue(List<CommonRptQingAnalyzeInfo> adjustValueRecords) {
        BigDecimal adjustValue;
        String adjustKey;
        HashMap<String, BigDecimal> adjustMap = new HashMap<String, BigDecimal>();
        ArrayList<CommonRptQingAnalyzeInfo> removedForAdjust = new ArrayList<CommonRptQingAnalyzeInfo>();
        for (CommonRptQingAnalyzeInfo adjustCommonInfo : adjustValueRecords) {
            adjustKey = this.getKey(adjustCommonInfo);
            adjustValue = adjustCommonInfo.getAdjustValue();
            if (adjustMap.containsKey(adjustKey)) {
                BigDecimal oldAdjustValue = (BigDecimal)adjustMap.get(adjustKey);
                adjustValue = adjustValue.add(oldAdjustValue);
                adjustMap.put(adjustKey, adjustValue);
                removedForAdjust.add(adjustCommonInfo);
                continue;
            }
            adjustMap.put(adjustKey, adjustValue);
        }
        if (!removedForAdjust.isEmpty()) {
            adjustValueRecords.removeAll(removedForAdjust);
            removedForAdjust.clear();
        }
        for (CommonRptQingAnalyzeInfo adjustCommonInfo : adjustValueRecords) {
            adjustKey = this.getKey(adjustCommonInfo);
            adjustValue = (BigDecimal)adjustMap.get(adjustKey);
            adjustCommonInfo.setAdjustValue(adjustValue);
        }
    }

    private void setCommonData(Object[] data, CommonRptQingAnalyzeInfo commonInfo) {
        data[0] = commonInfo.getBizDate();
        data[1] = commonInfo.getYear();
        data[2] = commonInfo.getPeriod();
        data[3] = commonInfo.getCompanyId();
        data[4] = commonInfo.getCompanyNumber();
        data[5] = commonInfo.getCompanyParent();
        data[6] = commonInfo.getCompanyName();
        data[7] = commonInfo.getRptItemNumber();
        data[8] = commonInfo.getRptItemParent();
        data[9] = commonInfo.getRptItemName();
        data[10] = commonInfo.getDataElementNumber();
        data[11] = commonInfo.getDataElementParent();
        data[12] = commonInfo.getDataElementName();
        data[13] = commonInfo.getCurrencyNumber();
        data[14] = commonInfo.getCurrencyParent();
        data[15] = commonInfo.getCurrencyName();
        data[16] = commonInfo.getDataType();
    }

    private String getKey(CommonRptQingAnalyzeInfo commonInfo) {
        String comId = commonInfo.getCompanyId();
        String currNum = commonInfo.getCurrencyNumber();
        String year = commonInfo.getYear();
        String period = commonInfo.getPeriod();
        String itemNum = commonInfo.getRptItemNumber();
        String deNum = commonInfo.getDataElementNumber();
        String valueType = commonInfo.getDataType();
        return comId + currNum + year + period + itemNum + deNum + valueType;
    }

    private StringBuffer getSql(StringBuffer sql, int adjustStatus, String lan, List params) throws Exception {
        if (sql.length() > 0) {
            sql.append(" Union All \n");
        }
        sql.append("Select itemData.FCompanyId comId, itemData.FCompanyNumber comNum, itemData.FCompanyName" + lan + " comName, itemData.FTargetCurrencyNum currNum, itemData.FTargetCurrencyName" + lan + " currName, \n");
        sql.append(" itemData.fyear year, itemData.fperiod period, \n");
        sql.append(" itemData.FItemNumber itemNum, itemData.FItemName" + lan + " itemName, itemData.FDataElementNum deNum, itemData.FDataElementName" + lan + " deName, \n");
        sql.append(" case when itemData.FValueType = 1 then '\u91d1\u989d' else '\u6570\u91cf' end valueType, \n");
        sql.append(" itemData.fisadjusted isAdjust, itemData.fvalue value \n");
        sql.append(" From T_Csl_RptItemData itemData \n");
        List<FullOrgUnitInfo> orgs = this.getOrgUnit();
        sql = this.getOrgUnitSql(sql, params, orgs);
        if (this.theme.isIsOnlyCompany() || orgs != null && !orgs.isEmpty()) {
            sql.append(" And itemData.FPeriodType = ? ");
        } else {
            sql.append(" Where itemData.FPeriodType = ? ");
        }
        params.add(this.theme.getPeriodType().getValue());
        sql = this.getYearAndPeriodSql(sql, params);
        sql = this.getCurrencySql(sql, params);
        sql = this.getRptItemSql(sql, params);
        sql = this.getDataElementSql(sql, params);
        if (adjustStatus == 0) {
            sql = this.getRptStatusSql(sql, params);
            sql = this.getDataSourceSql(sql, params);
        }
        sql = this.getDataTypeSql(sql, params);
        sql = this.getAdjustStatusSql(sql, adjustStatus, params);
        return sql;
    }

    private StringBuffer getRptItemSql(StringBuffer sql, List params) {
        List<RPTItemInfo> rptItems = this.getRPTItem();
        if (rptItems != null && !rptItems.isEmpty()) {
            sql.append(" And itemData.FItemNumber in (");
            int index = 0;
            for (RPTItemInfo rptItem : rptItems) {
                String number = rptItem.getNumber();
                if (index > 0) {
                    sql.append(",");
                }
                sql.append("?");
                params.add(number);
                ++index;
            }
            sql.append(") \n");
        }
        return sql;
    }

    private StringBuffer getOrgUnitSql(StringBuffer sql, List params, List<FullOrgUnitInfo> orgs) throws BOSException {
        if (orgs != null && !orgs.isEmpty()) {
            sql.append(" Where itemData.FCompanyId in (");
            int index = 0;
            for (FullOrgUnitInfo org : orgs) {
                String id = org.getId().toString();
                if (index > 0) {
                    sql.append(",");
                }
                sql.append("?");
                params.add(id);
                ++index;
            }
            sql.append(") \n");
        } else if (this.theme.isIsOnlyCompany()) {
            sql.append(" Inner join T_ORG_BaseUnit unit On itemData.FCompanyId = unit.Fid \n");
            sql.append(" Where unit.FIsUnion = 0 \n");
        }
        return sql;
    }

    private StringBuffer getDataElementSql(StringBuffer sql, List params) throws Exception {
        List<DataElementInfo> dataElements = this.getDataElement();
        if (dataElements != null && !dataElements.isEmpty()) {
            sql.append(" And itemData.FDataElementNum in (");
            int index = 0;
            for (DataElementInfo dataElement : dataElements) {
                String dataElementNumber = dataElement.getNumber();
                if (index > 0) {
                    sql.append(",");
                }
                sql.append("?");
                params.add(dataElementNumber);
                ++index;
            }
            sql.append(") \n");
        }
        return sql;
    }

    private StringBuffer getYearAndPeriodSql(StringBuffer sql, List params) {
        List startTime = this.getStartTimes();
        List endTime = this.getEndTimes();
        int startYear = (Integer)startTime.get(0);
        int startPeriod = (Integer)startTime.get(1);
        int endYear = (Integer)endTime.get(0);
        int endPeriod = (Integer)endTime.get(1);
        if (endPeriod == 12) {
            endPeriod = 13;
        }
        if (startYear == endYear && startPeriod == endPeriod) {
            sql.append(" And itemData.FYear = ? \n");
            params.add(startYear);
            sql.append(" And itemData.FPeriod = ? \n");
            params.add(startPeriod);
        } else if (startYear == endYear) {
            sql.append(" And itemData.FYear = ? \n");
            params.add(startYear);
            sql.append(" And itemData.FPeriod >= ? \n");
            params.add(startPeriod);
            sql.append(" And itemData.FPeriod <= ? \n");
            params.add(endPeriod);
        } else {
            sql.append(" AND (itemData.FYear > ?");
            params.add(startYear);
            sql.append(" OR (itemData.FYear = ?");
            params.add(startYear);
            sql.append(" AND itemData.FPeriod >= ?");
            params.add(startPeriod);
            sql.append(")) ");
            sql.append(" AND (itemData.FYear < ?");
            params.add(endYear);
            sql.append(" OR (itemData.FYear = ?");
            params.add(endYear);
            sql.append(" AND itemData.FPeriod <= ?");
            params.add(endPeriod);
            sql.append(")) ");
        }
        return sql;
    }

    private StringBuffer getCurrencySql(StringBuffer sql, List params) {
        List<CurrencyInfo> currencys = this.getCurrency();
        if (currencys != null && !currencys.isEmpty()) {
            sql.append(" And itemData.ftargetcurrencyId in (");
            int index = 0;
            for (CurrencyInfo currency : currencys) {
                String id = currency.getId().toString();
                if (index > 0) {
                    sql.append(",");
                }
                sql.append("?");
                params.add(id);
                ++index;
            }
            sql.append(") \n");
        }
        return sql;
    }

    private StringBuffer getDataTypeSql(StringBuffer sql, List params) {
        List<Integer> dataTypes = this.getDataType();
        if (dataTypes.size() == 1) {
            sql.append(" And itemData.FValuetype = ? \n");
            params.add(dataTypes.get(0));
        } else if (dataTypes.size() == 2) {
            sql.append(" And itemData.FValuetype in (?,?) \n");
            params.add(dataTypes.get(0));
            params.add(dataTypes.get(1));
        }
        return sql;
    }

    private StringBuffer getDataSourceSql(StringBuffer sql, List params) {
        if (this.theme.isIsSingle() && !this.theme.isIsCombine() && !this.theme.isIsSum()) {
            sql.append(" And itemData.FDataSource = ? \n");
            params.add("1");
        } else if (this.theme.isIsSingle() && this.theme.isIsCombine() && !this.theme.isIsSum()) {
            sql.append(" And itemData.FDataSource in (?,?) \n");
            params.add("1");
            params.add("3");
        } else if (this.theme.isIsSingle() && !this.theme.isIsCombine() && this.theme.isIsSum()) {
            sql.append(" And itemData.FDataSource in (?,?) \n");
            params.add("1");
            params.add("2");
        } else if (!this.theme.isIsSingle() && this.theme.isIsCombine() && !this.theme.isIsSum()) {
            sql.append(" And itemData.FDataSource = ? \n");
            params.add("3");
        } else if (!this.theme.isIsSingle() && !this.theme.isIsCombine() && this.theme.isIsSum()) {
            sql.append(" And itemData.FDataSource = ? \n");
            params.add("2");
        }
        return sql;
    }

    private StringBuffer getAdjustStatusSql(StringBuffer sql, int adjustStatus, List params) {
        if (adjustStatus == 0) {
            sql.append(" And itemData.FIsadjusted = ? \n");
            params.add(0);
        } else if (adjustStatus == 2) {
            sql.append(" And itemData.FIsadjusted = ? \n");
            params.add(1);
        } else {
            sql.append(" And itemData.FIsadjusted in (?,?) \n");
            params.add(0);
            params.add(1);
        }
        return sql;
    }

    private StringBuffer getRptStatusSql(StringBuffer sql, List params) {
        if (this.theme.isIsWeave() && !this.theme.isIsAudit() && !this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And itemData.FAuditedStatus = ? And itemData.FCommitStatus = ? \n");
            params.add(1);
            params.add(1);
        } else if (this.theme.isIsWeave() && this.theme.isIsAudit() && !this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And itemData.FAuditedStatus in (?,?) And itemData.FCommitStatus = ? \n");
            params.add(1);
            params.add(2);
            params.add(1);
        } else if (this.theme.isIsWeave() && this.theme.isIsAudit() && this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And itemData.FAuditedStatus in (?,?) And itemData.FCommitStatus in (?,?) \n");
            params.add(1);
            params.add(2);
            params.add(1);
            params.add(2);
        } else if (this.theme.isIsWeave() && this.theme.isIsAudit() && this.theme.isIsCommit() && this.theme.isIsReceive()) {
            sql.append(" And itemData.FAuditedStatus in (?,?) And itemData.FCommitStatus in (?,?,?) \n");
            params.add(1);
            params.add(2);
            params.add(1);
            params.add(2);
            params.add(3);
        } else if (!this.theme.isIsWeave() && this.theme.isIsAudit() && !this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And itemData.FAuditedStatus = ? And itemData.FCommitStatus = ? \n");
            params.add(2);
            params.add(1);
        } else if (!this.theme.isIsWeave() && this.theme.isIsAudit() && this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And itemData.FAuditedStatus = ? And itemData.FCommitStatus in (?,?) \n");
            params.add(2);
            params.add(1);
            params.add(2);
        } else if (!this.theme.isIsWeave() && this.theme.isIsAudit() && this.theme.isIsCommit() && this.theme.isIsReceive()) {
            sql.append(" And itemData.FAuditedStatus = ? And itemData.FCommitStatus in (?,?,?) \n");
            params.add(2);
            params.add(1);
            params.add(2);
            params.add(3);
        } else if (!this.theme.isIsWeave() && !this.theme.isIsAudit() && this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And itemData.FAuditedStatus = ? And itemData.FCommitStatus = ? \n");
            params.add(2);
            params.add(2);
        } else if (!this.theme.isIsWeave() && !this.theme.isIsAudit() && this.theme.isIsCommit() && this.theme.isIsReceive()) {
            sql.append(" And itemData.FAuditedStatus = ? And itemData.FCommitStatus in (?,?) \n");
            params.add(2);
            params.add(2);
            params.add(3);
        } else if (!this.theme.isIsWeave() && !this.theme.isIsAudit() && !this.theme.isIsCommit() && this.theme.isIsReceive()) {
            sql.append(" And itemData.FAuditedStatus = ? And itemData.FCommitStatus = ? \n");
            params.add(2);
            params.add(3);
        }
        return sql;
    }
}

