/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.CommonRptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptQingAnalyzeInfo;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.AbstractCalulateRptQingAnalyze;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.util.RptQingAnalyzeUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class CalculateDynaRptQingAnalyze
extends AbstractCalulateRptQingAnalyze {
    public CalculateDynaRptQingAnalyze(Context ctx, RptQingAnalyzeInfo theme) {
        super(ctx, theme);
    }

    @Override
    public MetaInfo getMeta() {
        MetaInfo metaInfo = new MetaInfo();
        List<Integer> adjusts = this.getAdjustStatus();
        metaInfo.addField("FBizDate", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "102_bizDate"), DataType.DATE);
        metaInfo.addField("FYear", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "77_year"), DataType.STRING);
        metaInfo.addField("FPeriod", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "78_period"), DataType.STRING);
        metaInfo.addField("FOrgUnitId", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "88_orgId"), DataType.STRING);
        metaInfo.addField("FOrgUnitNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "46_orgNum"), DataType.STRING);
        metaInfo.addField("FOrgUnitParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "63_orgPNum"), DataType.STRING);
        metaInfo.addField("FOrgUnitName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "47_orgName"), DataType.STRING);
        metaInfo.addField("FRptItemNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "51_rptItemNum"), DataType.STRING);
        metaInfo.addField("FRptItemParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "65_rptItemPNum"), DataType.STRING);
        metaInfo.addField("FRptItemName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "52_rptItemName"), DataType.STRING);
        metaInfo.addField("FDynaItemNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "67_dynaItemNum"), DataType.STRING);
        metaInfo.addField("FDynaItemParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "68_dynaItemPNum"), DataType.STRING);
        metaInfo.addField("FDynaItemName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "69_dynaItemName"), DataType.STRING);
        metaInfo.addField("FDataElementNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "53_deNumber"), DataType.STRING);
        metaInfo.addField("FDataElementParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "66_dePNum"), DataType.STRING);
        metaInfo.addField("FDataElementName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "54_deName"), DataType.STRING);
        metaInfo.addField("FCurrencyNumber", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "48_curNum"), DataType.STRING);
        metaInfo.addField("FCurrencyParent", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "64_curPNum"), DataType.STRING);
        metaInfo.addField("FCurrencyName", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "49_curName"), DataType.STRING);
        metaInfo.addField("FdataType", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "55_dataType"), DataType.STRING);
        if (adjusts.contains(0)) {
            metaInfo.addField("FBeforeAdjustValue", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "56_beforeAdjust"), DataType.NUMBER);
        }
        if (adjusts.contains(2)) {
            metaInfo.addField("FAdjustValue", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "57_adjust"), DataType.NUMBER);
        }
        if (adjusts.contains(1)) {
            metaInfo.addField("FAfterAdjustValue", RptQingAnalyzeUtil.getResource(this.ctx, "com.kingdee.eas.fi.newrpt.rptIndexAnalyze.RptIndexAnalyzeResource", "58_afterAdjust"), DataType.NUMBER);
        }
        return metaInfo;
    }

    @Override
    public List<Object[]> getData() throws Exception {
        return this.getDynaData();
    }

    private List<Object[]> getDynaData() throws Exception {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        List<Integer> adjusts = this.getAdjustStatus();
        StringBuffer sql = new StringBuffer();
        CSLServerHelper serverHelper = new CSLServerHelper(this.ctx);
        String lan = serverHelper.getFieldNameExtend();
        ArrayList params = new ArrayList();
        if (adjusts.contains(0) || adjusts.contains(1)) {
            sql = this.getSql(sql, 0, lan, params);
        }
        if (adjusts.contains(2) || adjusts.contains(1)) {
            sql = this.getAdjustSql(sql, 2, lan, params);
        }
        IRowSet rs = DbUtil.executeQuery(this.ctx, sql.toString(), params.toArray());
        try {
            CommonRptQingAnalyzeInfo commonInfo = null;
            ArrayList<CommonRptQingAnalyzeInfo> beforeAdjustRecords = new ArrayList<CommonRptQingAnalyzeInfo>();
            ArrayList<CommonRptQingAnalyzeInfo> adjustValueRecords = new ArrayList<CommonRptQingAnalyzeInfo>();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            RptPeriodTypeEnum periodType = this.theme.getPeriodType();
            Date bizDate = null;
            while (rs.next()) {
                commonInfo = new CommonRptQingAnalyzeInfo();
                String year = rs.getString("year");
                String period = rs.getString("period");
                period = this.getPeriodString(periodType, period);
                bizDate = this.getDate(dateFormat, periodType, year, period);
                commonInfo.setBizDate(bizDate);
                commonInfo.setYear(year);
                commonInfo.setPeriod(period);
                commonInfo.setCompanyId(rs.getString("unitId"));
                commonInfo.setCompanyNumber(rs.getString("unitNum"));
                commonInfo.setCompanyParent(null);
                commonInfo.setCompanyName(rs.getString("unitName"));
                commonInfo.setRptItemNumber(rs.getString("itemNum"));
                commonInfo.setRptItemParent(null);
                commonInfo.setRptItemName(rs.getString("itemName"));
                commonInfo.setDynaItemNumber(rs.getString("keyNum"));
                commonInfo.setDynaItemParent(null);
                commonInfo.setDynaItemName(rs.getString("keyName"));
                commonInfo.setDataElementNumber(rs.getString("deNum"));
                commonInfo.setDataElementParent(null);
                commonInfo.setDataElementName(rs.getString("deName"));
                commonInfo.setCurrencyNumber(rs.getString("currNum"));
                commonInfo.setCurrencyParent(null);
                commonInfo.setCurrencyName(rs.getString("currName"));
                commonInfo.setDataType(rs.getString("valueType"));
                int dataType = rs.getInt("dataType");
                BigDecimal value = rs.getBigDecimal("value");
                if (dataType == 0) {
                    commonInfo.setBeforeAdjustValue(value);
                    beforeAdjustRecords.add(commonInfo);
                    continue;
                }
                commonInfo.setAdjustValue(value);
                adjustValueRecords.add(commonInfo);
            }
            if (!beforeAdjustRecords.isEmpty() || !adjustValueRecords.isEmpty()) {
                this.mergeData(datas, beforeAdjustRecords, adjustValueRecords);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return datas;
    }

    private void mergeData(List<Object[]> mergeDatas, List<CommonRptQingAnalyzeInfo> beforeAdjustRecords, List<CommonRptQingAnalyzeInfo> adjustValueRecords) {
        Object[] data = null;
        List<Integer> adjusts = this.getAdjustStatus();
        if (adjusts.size() == 3) {
            this.mergeBeforeAjustAndAdjustValue(beforeAdjustRecords, adjustValueRecords);
            for (CommonRptQingAnalyzeInfo beforeAdjustCommonInfo : beforeAdjustRecords) {
                data = new Object[23];
                this.setCommonData(data, beforeAdjustCommonInfo);
                data[20] = beforeAdjustCommonInfo.getBeforeAdjustValue();
                data[21] = beforeAdjustCommonInfo.getAdjustValue();
                data[22] = beforeAdjustCommonInfo.getAfterAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 2 && adjusts.contains(0) && adjusts.contains(2)) {
            this.mergeBeforeAjustAndAdjustValue(beforeAdjustRecords, adjustValueRecords);
            for (CommonRptQingAnalyzeInfo beforeAdjustCommonInfo : beforeAdjustRecords) {
                data = new Object[22];
                this.setCommonData(data, beforeAdjustCommonInfo);
                data[20] = beforeAdjustCommonInfo.getBeforeAdjustValue();
                data[21] = beforeAdjustCommonInfo.getAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 2 && adjusts.contains(0) && adjusts.contains(1)) {
            this.mergeBeforeAjustAndAdjustValue(beforeAdjustRecords, adjustValueRecords);
            for (CommonRptQingAnalyzeInfo beforeAdjustCommonInfo : beforeAdjustRecords) {
                data = new Object[22];
                this.setCommonData(data, beforeAdjustCommonInfo);
                data[20] = beforeAdjustCommonInfo.getBeforeAdjustValue();
                data[21] = beforeAdjustCommonInfo.getAfterAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 2 && adjusts.contains(2) && adjusts.contains(1)) {
            this.mergeBeforeAjustAndAdjustValue(beforeAdjustRecords, adjustValueRecords);
            for (CommonRptQingAnalyzeInfo beforeAdjustCommonInfo : beforeAdjustRecords) {
                data = new Object[22];
                this.setCommonData(data, beforeAdjustCommonInfo);
                data[20] = beforeAdjustCommonInfo.getAdjustValue();
                data[21] = beforeAdjustCommonInfo.getAfterAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 1 && adjusts.contains(0)) {
            for (CommonRptQingAnalyzeInfo beforeAdjustCommonInfo : beforeAdjustRecords) {
                data = new Object[21];
                this.setCommonData(data, beforeAdjustCommonInfo);
                data[20] = beforeAdjustCommonInfo.getBeforeAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 1 && adjusts.contains(2)) {
            this.getComboAdjustValue(adjustValueRecords);
            for (CommonRptQingAnalyzeInfo adjustCommonInfo : adjustValueRecords) {
                data = new Object[21];
                this.setCommonData(data, adjustCommonInfo);
                data[20] = adjustCommonInfo.getAdjustValue();
                mergeDatas.add(data);
            }
        } else if (adjusts.size() == 1 && adjusts.contains(1)) {
            this.mergeBeforeAjustAndAdjustValue(beforeAdjustRecords, adjustValueRecords);
            for (CommonRptQingAnalyzeInfo beforeAdjustCommonInfo : beforeAdjustRecords) {
                data = new Object[21];
                this.setCommonData(data, beforeAdjustCommonInfo);
                data[20] = beforeAdjustCommonInfo.getAfterAdjustValue();
                mergeDatas.add(data);
            }
        }
        beforeAdjustRecords.clear();
        adjustValueRecords.clear();
    }

    private void mergeBeforeAjustAndAdjustValue(List<CommonRptQingAnalyzeInfo> beforeAdjustRecords, List<CommonRptQingAnalyzeInfo> adjustValueRecords) {
        ArrayList<CommonRptQingAnalyzeInfo> removedForAdjust = new ArrayList<CommonRptQingAnalyzeInfo>();
        if (beforeAdjustRecords != null && !beforeAdjustRecords.isEmpty()) {
            for (CommonRptQingAnalyzeInfo beforeAdjustCommonInfo : beforeAdjustRecords) {
                String beforeAdjustKey = this.getKey(beforeAdjustCommonInfo);
                BigDecimal beforeAdjust = beforeAdjustCommonInfo.getBeforeAdjustValue();
                if (!adjustValueRecords.isEmpty()) {
                    boolean isAdded = false;
                    this.getComboAdjustValue(adjustValueRecords);
                    for (CommonRptQingAnalyzeInfo adjustCommonInfo : adjustValueRecords) {
                        String adjustKey = this.getKey(adjustCommonInfo);
                        BigDecimal adjustValue = adjustCommonInfo.getAdjustValue();
                        if (!beforeAdjustKey.equals(adjustKey)) continue;
                        beforeAdjustCommonInfo.setAdjustValue(adjustValue);
                        BigDecimal afterAdjustValue = beforeAdjust.add(adjustValue);
                        beforeAdjustCommonInfo.setAfterAdjustValue(afterAdjustValue);
                        removedForAdjust.add(adjustCommonInfo);
                        isAdded = true;
                    }
                    if (isAdded) continue;
                    beforeAdjustCommonInfo.setAfterAdjustValue(beforeAdjust);
                    continue;
                }
                beforeAdjustCommonInfo.setAfterAdjustValue(beforeAdjust);
            }
            if (!removedForAdjust.isEmpty()) {
                adjustValueRecords.removeAll(removedForAdjust);
                if (!adjustValueRecords.isEmpty()) {
                    for (CommonRptQingAnalyzeInfo adjustCommonInfo : adjustValueRecords) {
                        adjustCommonInfo.setAfterAdjustValue(adjustCommonInfo.getAdjustValue());
                        beforeAdjustRecords.add(adjustCommonInfo);
                    }
                }
                removedForAdjust.clear();
            }
        } else if (adjustValueRecords != null && !adjustValueRecords.isEmpty()) {
            this.getComboAdjustValue(adjustValueRecords);
            for (CommonRptQingAnalyzeInfo commonInfo : adjustValueRecords) {
                BigDecimal adjustValue = commonInfo.getAdjustValue();
                commonInfo.setAfterAdjustValue(adjustValue);
            }
        }
    }

    private void getComboAdjustValue(List<CommonRptQingAnalyzeInfo> adjustValueRecords) {
        BigDecimal adjustValue;
        String adjustKey;
        HashMap<String, BigDecimal> adjustMap = new HashMap<String, BigDecimal>();
        ArrayList<CommonRptQingAnalyzeInfo> removedForAdjust = new ArrayList<CommonRptQingAnalyzeInfo>();
        for (CommonRptQingAnalyzeInfo adjustCommonInfo : adjustValueRecords) {
            adjustKey = this.getKey(adjustCommonInfo);
            adjustValue = adjustCommonInfo.getAdjustValue();
            if (adjustMap.containsKey(adjustKey)) {
                BigDecimal oldAdjustValue = (BigDecimal)adjustMap.get(adjustKey);
                adjustValue = adjustValue.add(oldAdjustValue);
                adjustMap.put(adjustKey, adjustValue);
                removedForAdjust.add(adjustCommonInfo);
                continue;
            }
            adjustMap.put(adjustKey, adjustValue);
        }
        if (!removedForAdjust.isEmpty()) {
            adjustValueRecords.removeAll(removedForAdjust);
            removedForAdjust.clear();
        }
        for (CommonRptQingAnalyzeInfo adjustCommonInfo : adjustValueRecords) {
            adjustKey = this.getKey(adjustCommonInfo);
            adjustValue = (BigDecimal)adjustMap.get(adjustKey);
            adjustCommonInfo.setAdjustValue(adjustValue);
        }
    }

    private void setCommonData(Object[] data, CommonRptQingAnalyzeInfo commonInfo) {
        data[0] = commonInfo.getBizDate();
        data[1] = commonInfo.getYear();
        data[2] = commonInfo.getPeriod();
        data[3] = commonInfo.getCompanyId();
        data[4] = commonInfo.getCompanyNumber();
        data[5] = commonInfo.getCompanyParent();
        data[6] = commonInfo.getCompanyName();
        data[7] = commonInfo.getRptItemNumber();
        data[8] = commonInfo.getRptItemParent();
        data[9] = commonInfo.getRptItemName();
        data[10] = commonInfo.getDynaItemNumber();
        data[11] = commonInfo.getDynaItemParent();
        data[12] = commonInfo.getDynaItemName();
        data[13] = commonInfo.getDataElementNumber();
        data[14] = commonInfo.getDataElementParent();
        data[15] = commonInfo.getDataElementName();
        data[16] = commonInfo.getCurrencyNumber();
        data[17] = commonInfo.getCurrencyParent();
        data[18] = commonInfo.getCurrencyName();
        data[19] = commonInfo.getDataType();
    }

    private String getKey(CommonRptQingAnalyzeInfo commonInfo) {
        String comId = commonInfo.getCompanyId();
        String currNum = commonInfo.getCurrencyNumber();
        String year = commonInfo.getYear();
        String period = commonInfo.getPeriod();
        String itemNum = commonInfo.getRptItemNumber();
        String deNum = commonInfo.getDataElementNumber();
        String valueType = commonInfo.getDataType();
        String dynaItemNumber = commonInfo.getDynaItemNumber();
        return comId + currNum + year + period + itemNum + deNum + valueType + dynaItemNumber;
    }

    private StringBuffer getSql(StringBuffer sql, int adjustStatus, String lan, List params) throws Exception {
        if (sql.length() > 0) {
            sql.append(" Union All \n");
        }
        sql.append(" Select distinct unit.Fid unitId, unit.FNumber unitNum,unit.FName" + lan + " unitName,curr.FNumber currNum,curr.FName" + lan + " currName, \n");
        sql.append(" entry.fyear year, entry.fperiod period, \n");
        sql.append(" rptItem.FNumber itemNum,rptItem.FName" + lan + " itemName,de.FNumber deNum,de.FName" + lan + " deName, \n");
        sql.append(" case when entry.FValueType = 1 then '\u91d1\u989d' else '\u6570\u91cf' end valueType, \n");
        sql.append(" entry.FKeyNumber keyNum, entry.FKeyName keyName, data.FDataType dataType,FValue value \n");
        sql.append(" From T_CSL_DynaItemDataEntry entry \n");
        sql.append(" Inner Join T_CSL_DynaItemData data On data.fid = entry.FItemDataId \n");
        if (adjustStatus == 0) {
            sql.append(" Inner join T_CSL_CslReport cslrpt On cslrpt.FId = data.FReportId \n");
        }
        sql.append(" Inner Join T_ORG_BaseUnit unit On unit.fid = data.FOrgUnitId \n");
        sql.append(" Inner Join T_BD_Currency curr On curr.FId = data.FCurrencyId \n");
        sql.append(" Inner Join T_CSL_RptItem rptItem On rptItem.FNumber = entry.FItemId \n");
        sql.append(" Inner Join T_CSL_DataElement de On de.FInterSeq = entry.FDataElement \n");
        List<DynaItemInfo> dynaItems = this.getDynaItem();
        sql = this.getDynaItemSql(sql, params, adjustStatus, "entry.FKEYNUMBER", dynaItems);
        if (this.theme.getAsstActType() != null && adjustStatus == 0 || dynaItems != null && !dynaItems.isEmpty()) {
            sql.append(" And ");
        } else {
            sql.append(" Where ");
        }
        sql.append(" data.FPeriodtype = ? And data.FDynaType = ? and entry.FGRADEISLEAF = ? \n");
        params.add(this.theme.getPeriodType().getValue());
        params.add(1);
        params.add(1);
        sql = this.getDataTypeValue(sql, adjustStatus, params);
        sql = this.getYearAndPeriodSql(sql, params, "entry");
        sql = this.getOrgUnitSql(sql, params, "data.FOrgUnitId");
        sql = this.getCurrencySql(sql, params, "data.FCurrencyId");
        sql = this.getRptItemSql(sql, params, "entry.FItemId");
        sql = this.getDataElementSql(sql, params, "entry.FDataElement");
        if (adjustStatus == 0) {
            sql = this.getDataSourceSql(sql, params);
            sql = this.getRptStatusSql(sql, params);
        }
        sql = this.getValueTypeSql(sql, params, "entry");
        return sql;
    }

    private StringBuffer getAdjustSql(StringBuffer sql, int adjustStatus, String lan, List params) throws Exception {
        if (sql.length() > 0) {
            sql.append(" Union All \n");
        }
        sql.append(" Select distinct unit.Fid unitId, unit.FNumber unitNum,unit.FName" + lan + " unitName,curr.FNumber currNum,curr.FName" + lan + " currName, \n");
        sql.append(" adjust.fyear year, adjust.fperiod period, \n");
        sql.append(" rptItem.FNumber itemNum,rptItem.FName" + lan + " itemName,de.FNumber deNum,de.FName" + lan + " deName, \n");
        sql.append(" case when adjust.FValueType = 1 then '\u91d1\u989d' else '\u6570\u91cf' end valueType, \n");
        sql.append(" dyitem.FKeyLongNumber keyNum, dyitem.FKeyName keyName, 1 as dataType, dyitem.FValue value \n");
        sql.append(" From T_CSL_Adjust adjust \n");
        sql.append(" Inner Join T_CSL_AdjustEntry adjustEntry ON adjust.FID = adjustEntry.fadjustid \n");
        sql.append(" Inner Join T_Csl_Adjustdynamicitem dyitem ON adjustEntry.FID = dyitem.FAdjustEntryID \n");
        sql.append(" Inner Join T_CSL_RptItem rptItem ON dyitem.FRptItemID = rptItem.FID \n");
        sql.append(" Inner Join T_ORG_BaseUnit unit On unit.fid = adjust.FOrgUnit \n");
        sql.append(" Inner Join T_BD_Currency curr On curr.FId = Adjust.FCurrencyId \n");
        sql.append(" Inner Join T_CSL_DataElement de On de.FInterSeq = adjustEntry.FDataElement \n");
        List<DynaItemInfo> dynaItems = this.getDynaItem();
        sql = this.getDynaItemSql(sql, params, adjustStatus, "dyitem.FKeyLongNumber", dynaItems);
        if (this.theme.getAsstActType() != null && adjustStatus == 0 || dynaItems != null && !dynaItems.isEmpty()) {
            sql.append(" And ");
        } else {
            sql.append(" Where ");
        }
        sql.append(" adjust.FCheckedStatus = ? And adjust.FPeriodType = ? And adjust.FDataCollectNumber = ? \n");
        params.add(2);
        params.add(this.theme.getPeriodType().getValue());
        params.add("ACTUALDATA");
        sql = this.getYearAndPeriodSql(sql, params, "adjust");
        sql = this.getOrgUnitSql(sql, params, "adjust.FOrgUnit");
        sql = this.getCurrencySql(sql, params, "adjust.FCurrencyID");
        sql = this.getRptItemSql(sql, params, "rptItem.FNumber");
        sql = this.getDataElementSql(sql, params, "adjustEntry.FDataElement");
        sql = this.getAdjustDataSourceSql(sql, params);
        sql = this.getValueTypeSql(sql, params, "adjust");
        return sql;
    }

    private StringBuffer getAdjustDataSourceSql(StringBuffer sql, List params) {
        if (this.theme.isIsSingle() && !this.theme.isIsCombine() && !this.theme.isIsSum()) {
            sql.append(" And adjust.FDataSource = ? \n");
            params.add("1");
        } else if (this.theme.isIsSingle() && this.theme.isIsCombine() && !this.theme.isIsSum()) {
            sql.append(" And adjust.FDataSource in (?,?) \n");
            params.add("1");
            params.add("3");
        } else if (this.theme.isIsSingle() && !this.theme.isIsCombine() && this.theme.isIsSum()) {
            sql.append(" And adjust.FDataSource in (?,?) \n");
            params.add("1");
            params.add("2");
        } else if (!this.theme.isIsSingle() && this.theme.isIsCombine() && !this.theme.isIsSum()) {
            sql.append(" And adjust.FDataSource = ? \n");
            params.add("3");
        } else if (!this.theme.isIsSingle() && !this.theme.isIsCombine() && this.theme.isIsSum()) {
            sql.append(" And adjust.FDataSource = ? \n");
            params.add("2");
        }
        return sql;
    }

    private StringBuffer getDataTypeValue(StringBuffer sql, int adjustStatus, List params) {
        if (adjustStatus == 0) {
            sql.append(" And data.FDataType = ? \n");
            params.add(0);
        } else if (adjustStatus == 2) {
            sql.append(" And data.FDataType = ? \n");
            params.add(1);
        }
        return sql;
    }

    private StringBuffer getDynaItemSql(StringBuffer sql, List params, int adjustStatus, String columnName, List<DynaItemInfo> dynaItems) {
        if (dynaItems != null && !dynaItems.isEmpty()) {
            sql.append(" Where " + columnName + " in (");
            int index = 0;
            for (DynaItemInfo dynaItem : dynaItems) {
                String dynaItemNum = dynaItem.getDitemNumber();
                if (index > 0) {
                    sql.append(",");
                }
                sql.append("?");
                params.add(dynaItemNum);
                ++index;
            }
            sql.append(") \n");
        } else if (this.theme.getAsstActType() != null && adjustStatus == 0) {
            String asstActTypeNumber = this.theme.getAsstActType().getNumber();
            sql.append(" Inner Join T_RPT_Template tmpl On tmpl.FId = cslrpt.FTemplateId \n");
            sql.append(" Inner Join T_CSL_TempletItemList itemList On tmpl.FId = itemList.FTemplateID \n");
            sql.append(" Where itemList.FAsstActTypeNumber = ? \n");
            params.add(asstActTypeNumber);
        }
        return sql;
    }

    private StringBuffer getDataElementSql(StringBuffer sql, List params, String columnName) throws Exception {
        List<DataElementInfo> dataElements = this.getDataElement();
        if (dataElements != null && !dataElements.isEmpty()) {
            sql.append(" And " + columnName + " in (");
            int index = 0;
            for (DataElementInfo dataElement : dataElements) {
                int dataElementNumber = dataElement.getInterSeq();
                if (index > 0) {
                    sql.append(",");
                }
                sql.append("?");
                params.add(dataElementNumber);
                ++index;
            }
            sql.append(") \n");
        }
        return sql;
    }

    private StringBuffer getRptItemSql(StringBuffer sql, List params, String columnName) {
        List<RPTItemInfo> rptItems = this.getRPTItem();
        if (rptItems != null && !rptItems.isEmpty()) {
            sql.append(" And " + columnName + " in (");
            int index = 0;
            for (RPTItemInfo rptItem : rptItems) {
                String number = rptItem.getNumber();
                if (index > 0) {
                    sql.append(",");
                }
                sql.append("?");
                params.add(number);
                ++index;
            }
            sql.append(") \n");
        }
        return sql;
    }

    private StringBuffer getOrgUnitSql(StringBuffer sql, List params, String columnName) throws BOSException {
        List<FullOrgUnitInfo> orgs = this.getOrgUnit();
        if (orgs != null && !orgs.isEmpty()) {
            sql.append(" And " + columnName + " in (");
            int index = 0;
            for (FullOrgUnitInfo org : orgs) {
                String id = org.getId().toString();
                if (index > 0) {
                    sql.append(",");
                }
                sql.append("?");
                params.add(id);
                ++index;
            }
            sql.append(") \n");
        } else if (this.theme.isIsOnlyCompany()) {
            sql.append(" And unit.FIsUnion = 0 \n");
        }
        return sql;
    }

    private StringBuffer getCurrencySql(StringBuffer sql, List params, String columnName) {
        List<CurrencyInfo> currencys = this.getCurrency();
        if (currencys != null && !currencys.isEmpty()) {
            sql.append(" And " + columnName + " in (");
            int index = 0;
            for (CurrencyInfo currency : currencys) {
                String id = currency.getId().toString();
                if (index > 0) {
                    sql.append(",");
                }
                sql.append("?");
                params.add(id);
                ++index;
            }
            sql.append(") \n");
        }
        return sql;
    }

    private StringBuffer getValueTypeSql(StringBuffer sql, List params, String columnName) {
        List<Integer> dataTypes = this.getDataType();
        if (dataTypes.size() == 1) {
            sql.append(" And " + columnName + ".FValuetype = ? \n");
            params.add(dataTypes.get(0));
        } else if (dataTypes.size() == 2) {
            sql.append(" And " + columnName + ".FValuetype in (?,?) \n");
            params.add(dataTypes.get(0));
            params.add(dataTypes.get(1));
        }
        return sql;
    }

    private StringBuffer getYearAndPeriodSql(StringBuffer sql, List params, String columnName) {
        List startTime = this.getStartTimes();
        List endTime = this.getEndTimes();
        int startYear = (Integer)startTime.get(0);
        int startPeriod = (Integer)startTime.get(1);
        int endYear = (Integer)endTime.get(0);
        int endPeriod = (Integer)endTime.get(1);
        if (endPeriod == 12) {
            endPeriod = 13;
        }
        if (startYear == endYear && startPeriod == endPeriod) {
            sql.append(" And " + columnName + ".FYear = ? \n");
            params.add(startYear);
            sql.append(" And " + columnName + ".FPeriod = ? \n");
            params.add(startPeriod);
        } else if (startYear == endYear) {
            sql.append(" And " + columnName + ".FYear = ? \n");
            params.add(startYear);
            sql.append(" And " + columnName + ".FPeriod >= ? \n");
            params.add(startPeriod);
            sql.append(" And " + columnName + ".FPeriod <= ? \n");
            params.add(endPeriod);
        } else {
            sql.append(" AND (" + columnName + ".FYear > ?");
            params.add(startYear);
            sql.append(" OR (" + columnName + ".FYear = ?");
            params.add(startYear);
            sql.append(" AND " + columnName + ".FPeriod >= ?");
            params.add(startPeriod);
            sql.append(")) ");
            sql.append(" AND (" + columnName + ".FYear < ?");
            params.add(endYear);
            sql.append(" OR (" + columnName + ".FYear = ?");
            params.add(endYear);
            sql.append(" AND " + columnName + ".FPeriod <= ?");
            params.add(endPeriod);
            sql.append(")) ");
        }
        return sql;
    }

    private StringBuffer getDataSourceSql(StringBuffer sql, List params) {
        if (this.theme.isIsSingle() && !this.theme.isIsCombine() && !this.theme.isIsSum()) {
            sql.append(" And data.FDataSource = ? \n");
            params.add("10");
        } else if (this.theme.isIsSingle() && this.theme.isIsCombine() && !this.theme.isIsSum()) {
            sql.append(" And data.FDataSource in (?,?) \n");
            params.add("10");
            params.add("12");
        } else if (this.theme.isIsSingle() && !this.theme.isIsCombine() && this.theme.isIsSum()) {
            sql.append(" And data.FDataSource in (?,?) \n");
            params.add("10");
            params.add("11");
        } else if (!this.theme.isIsSingle() && this.theme.isIsCombine() && !this.theme.isIsSum()) {
            sql.append(" And data.FDataSource = ? \n");
            params.add("12");
        } else if (!this.theme.isIsSingle() && !this.theme.isIsCombine() && this.theme.isIsSum()) {
            sql.append(" And data.FDataSource = ? \n");
            params.add("11");
        }
        return sql;
    }

    private StringBuffer getRptStatusSql(StringBuffer sql, List params) {
        if (this.theme.isIsWeave() && !this.theme.isIsAudit() && !this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And cslrpt.FAuditedStatus = ? And cslrpt.FCommittedStatus = ? \n");
            params.add(1);
            params.add(1);
        } else if (this.theme.isIsWeave() && this.theme.isIsAudit() && !this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And cslrpt.FAuditedStatus in (?,?) And cslrpt.FCommittedStatus = ? \n");
            params.add(1);
            params.add(2);
            params.add(1);
        } else if (this.theme.isIsWeave() && this.theme.isIsAudit() && this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And cslrpt.FAuditedStatus in (?,?) And cslrpt.FCommittedStatus in (?,?) \n");
            params.add(1);
            params.add(2);
            params.add(1);
            params.add(2);
        } else if (this.theme.isIsWeave() && this.theme.isIsAudit() && this.theme.isIsCommit() && this.theme.isIsReceive()) {
            sql.append(" And cslrpt.FAuditedStatus in (?,?) And cslrpt.FCommittedStatus in (?,?,?) \n");
            params.add(1);
            params.add(2);
            params.add(1);
            params.add(2);
            params.add(3);
        } else if (!this.theme.isIsWeave() && this.theme.isIsAudit() && !this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And cslrpt.FAuditedStatus = ? And cslrpt.FCommittedStatus = ? \n");
            params.add(2);
            params.add(1);
        } else if (!this.theme.isIsWeave() && this.theme.isIsAudit() && this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And cslrpt.FAuditedStatus = ? And cslrpt.FCommittedStatus in (?,?) \n");
            params.add(2);
            params.add(1);
            params.add(2);
        } else if (!this.theme.isIsWeave() && this.theme.isIsAudit() && this.theme.isIsCommit() && this.theme.isIsReceive()) {
            sql.append(" And cslrpt.FAuditedStatus = ? And cslrpt.FCommittedStatus in (?,?,?) \n");
            params.add(2);
            params.add(1);
            params.add(2);
            params.add(3);
        } else if (!this.theme.isIsWeave() && !this.theme.isIsAudit() && this.theme.isIsCommit() && !this.theme.isIsReceive()) {
            sql.append(" And cslrpt.FAuditedStatus = ? And cslrpt.FCommittedStatus = ? \n");
            params.add(2);
            params.add(2);
        } else if (!this.theme.isIsWeave() && !this.theme.isIsAudit() && this.theme.isIsCommit() && this.theme.isIsReceive()) {
            sql.append(" And cslrpt.FAuditedStatus = ? And cslrpt.FCommittedStatus in (?,?) \n");
            params.add(2);
            params.add(2);
            params.add(3);
        } else if (!this.theme.isIsWeave() && !this.theme.isIsAudit() && !this.theme.isIsCommit() && this.theme.isIsReceive()) {
            sql.append(" And cslrpt.FAuditedStatus = ? And cslrpt.FCommittedStatus = ? \n");
            params.add(2);
            params.add(3);
        }
        return sql;
    }
}

