/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.AbstractCalculateProcessControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalculateProcessControllerBean
extends AbstractCalculateProcessControllerBean {
    private static final long serialVersionUID = 8799016850339323695L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.rptIndexAnalyze.app.CalculateProcessControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getCalProcessRecords(Context ctx, Map params) throws BOSException, EASBizException {
        Set themeIds = (Set)params.get("themeIds");
        int from = (Integer)params.get("from");
        int length = (Integer)params.get("length");
        String tempTable = null;
        if (params.containsKey("tempTable")) {
            tempTable = (String)params.get("tempTable");
            if (from == 0) {
                this.releaseTempTable(tempTable, ctx);
                tempTable = null;
            }
        }
        if (tempTable == null) {
            ParamTempTblService service = null;
            try {
                Set orgIds = (Set)params.get("permOrgIds");
                service = this.getCompanyIDParamSrv(ctx, orgIds);
                tempTable = this.insertIntoTempTable(ctx, themeIds, service);
            }
            catch (BOSException e) {
                logger.error((Object)"insertIntoTempTable: ", (Throwable)e);
            }
            finally {
                if (service != null) {
                    service.release();
                }
            }
        }
        IRowSet rs = this.getRowSetFromTempTable(ctx, tempTable, from, length);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("rowSet", rs);
        result.put("tempTable", tempTable);
        return result;
    }

    private IRowSet getRowSetFromTempTable(Context ctx, String tempTable, int from, int length) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select FId, FAnalyzeId, FAnalyzeName, FOrgUnitId, \n");
        sql.append(" FOrgUnitNumber, FOrgUnitName, FYear, FPeriod, \n");
        sql.append(" FYearPeriod, FCurrencyId, FCurrencyNumber, \n");
        sql.append(" FCurrencyName, FData, FCalculateProcess, FCalculatorId, FCalculateTime \n");
        sql.append(" From ").append(tempTable).append(" \n");
        sql.append(" Order By FOrgUnitNumber,FYear,FPeriod,FCurrencyNumber \n");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), from, length);
        return rs;
    }

    private String insertIntoTempTable(Context ctx, Set<String> themeIds, ParamTempTblService service) throws BOSException {
        String tempTable = this.createTempTable(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(tempTable).append(" \r\n");
        sql.append(" Select FId, FAnalyzeId, FAnalyzeName, FOrgUnitId, \n");
        sql.append(" FOrgUnitNumber, FOrgUnitName, FYear, FPeriod, \n");
        sql.append(" FYearPeriod, FCurrencyId, FCurrencyNumber, \n");
        sql.append(" FCurrencyName, FData, FCalculateProcess, FCalculatorId, FCalculateTime \n");
        sql.append(" From T_CSL_CalculateProcess \n");
        sql.append(" Where FAnalyzeId in (").append(CslRptUtil.collection2String(themeIds, (String)",", (boolean)true)).append(") \n");
        sql.append(" And (FOrgUnitId in (").append(service.getParamsSql()).append(") \n");
        sql.append(" Or FOrgUnitId is null) \n");
        DbUtil.execute(ctx, sql.toString());
        sql.delete(0, sql.length());
        return tempTable;
    }

    private String createTempTable(Context ctx) throws BOSException {
        String tableName;
        StringBuffer sql = new StringBuffer();
        sql.append("create table Tmp_calProcess_Table");
        sql.append(" (FId varchar(44), FAnalyzeId varchar(44),");
        sql.append(" FAnalyzeName varchar(500), FOrgUnitId varchar(44),");
        sql.append(" FOrgUnitNumber nvarchar(80), FOrgUnitName nvarchar(255),");
        sql.append(" FYear int, FPeriod int, FYearPeriod varchar(80),");
        sql.append(" FCurrencyId varchar(44), FCurrencyNumber nvarchar(80),");
        sql.append(" FCurrencyName nvarchar(255), FData blob(1024),");
        sql.append(" FCalculateProcess int, FCalculatorId VARCHAR(44),FCalculateTime DateTime)");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(sql.toString());
            pool.createIndex(tableName, "FAnalyzeId", false, false);
            sql.delete(0, sql.length());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private void releaseTempTable(String tableName, Context ctx) {
        if (!StringUtils.isEmpty((String)tableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
        }
    }

    private ParamTempTblService getCompanyIDParamSrv(Context ctx, Collection params) {
        TableInfo table = new TableInfo("Tmp_TempCompanyIDTable");
        table.addColumn("FCompanyId");
        return ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)params, null);
    }
}

