/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.samecontrol.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.FormulaUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.AbstractMnsRptCalcColumn;
import com.kingdee.eas.fi.gr.cslrpt.app.reportcalc.MnsRptCalcParam;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsCalcKey;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnCollection;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CslConstant;
import com.kingdee.eas.fi.newrpt.app.openApi.CslRptOpenApiFacadeFactory;
import com.kingdee.eas.fi.newrpt.samecontrol.SameControlUtil;
import com.kingdee.eas.fi.newrpt.samecontrol.mnsCalc.MnsDisposalColumnCollection;
import com.kingdee.eas.fi.newrpt.samecontrol.mnsCalc.MnsDisposalColumnInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MnsRptCalcDisposalData
extends AbstractMnsRptCalcColumn {
    private static Logger logger = Logger.getLogger(MnsRptCalcDisposalData.class);
    MnsDisposalColumnCollection disposalMnsColumnColl = null;
    MnsColumnCollection sumMnsColumnColl = null;
    MnsColumnCollection cslMnsColumnColl = null;
    Map<Integer, Map<Integer, MnsColumnCollection>> dataType_AdjustTypeColl = null;

    public MnsRptCalcDisposalData(MnsRptCalcParam mnsRptCalcParam, Map<Integer, Map<Integer, MnsColumnCollection>> dataType_AdjustTypeColl) {
        super(mnsRptCalcParam);
        this.dataType_AdjustTypeColl = dataType_AdjustTypeColl;
        if (this.dataType_AdjustTypeColl == null) {
            dataType_AdjustTypeColl = new HashMap<Integer, Map<Integer, MnsColumnCollection>>();
        }
    }

    public void initParams(HashMap itemNumbers, Map itemRows, Map sheetData, Map items) {
        super.initParams(itemNumbers, itemRows, sheetData, items);
    }

    public void setMnsColumnCollection(MnsColumnCollection disposalMnsColumnColl) {
        this.disposalMnsColumnColl = (MnsDisposalColumnCollection)disposalMnsColumnColl;
    }

    public void setSumMnsColumnCollection(MnsColumnCollection sumMnsColumnColl) {
        this.sumMnsColumnColl = sumMnsColumnColl;
    }

    public void setCslMnsColumnCollection(MnsColumnCollection cslMnsColumnColl) {
        this.cslMnsColumnColl = cslMnsColumnColl;
    }

    public void calcData() throws BOSException, EASBizException, CloneNotSupportedException {
        try {
            Map<String, String> varFormulas = this.getVarFormulas();
            Map<String, String> calFormulas = this.getCalcFormulas(varFormulas);
            this.calcFormulas(calFormulas);
        }
        catch (Exception ex) {
            logger.error((Object)"calcData error.", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    public void calcFormulas(Map<String, String> calFormulas) throws Exception {
        int index = 0;
        ArrayList<String> formulas = new ArrayList<String>();
        HashMap<Integer, String> indexMap = new HashMap<Integer, String>();
        for (String formulaKey : calFormulas.keySet()) {
            formulas.add(calFormulas.get(formulaKey));
            indexMap.put(index, formulaKey);
            ++index;
        }
        if (!formulas.isEmpty()) {
            HashMap<String, Object> commParams = new HashMap<String, Object>();
            CslReportInfo report = this.mnsRptCalcParam.getReport();
            commParams.put("Company.Number", report.getOrgUnit().getNumber());
            commParams.put("Company.Name", report.getOrgUnit().getName());
            commParams.put("Company.ID", report.getOrgUnit().getId().toString());
            commParams.put("OrgUnit.Name", report.getOrgUnit().getName());
            commParams.put("OrgUnit.Number", report.getOrgUnit().getNumber());
            commParams.put("OrgUnit.Id", report.getOrgUnit().getId().toString());
            commParams.put("CSLReport_OrgTree_Number", report.getOrgTree().getNumber());
            commParams.put("CSLReport_OrgUnit_Group", report.getOrgUnit().getNumber());
            commParams.put("PeriodType", report.getPeriodType().getValue());
            commParams.put("Report.Year", report.getYear());
            commParams.put("Report.Period", report.getPeriod());
            commParams.put("Currency.Number", report.getCurrency().getNumber());
            commParams.put("Report.Name", report.getName());
            commParams.put("Report.ID", report.getId().toString());
            commParams.put("Report.Number", report.getNumber());
            commParams.put("Report_StartDate", RPTDateUtil.getPeriodFirstDate((int)report.getYear(), (int)report.getPeriod(), (RptPeriodTypeEnum)report.getPeriodType()));
            commParams.put("Report_EndDate", RPTDate13Util.getPeriodLastDate((int)report.getYear(), (int)report.getPeriod(), (RptPeriodTypeEnum)report.getPeriodType()));
            HashMap<String, Boolean> sheetVariables = new HashMap<String, Boolean>();
            sheetVariables.put("IncludePosted", true);
            List values = CslRptOpenApiFacadeFactory.getLocalInstance(this.ctx).getBatchFormulaValues(commParams, sheetVariables, formulas);
            BigDecimal value = null;
            boolean isDebug = this.mnsRptCalcParam.getMnsRptCalcParam().getSheetName() != null && this.mnsRptCalcParam.getMnsRptCalcParam().getSheetName().equalsIgnoreCase("debug");
            for (Integer curIndex : indexMap.keySet()) {
                String position = (String)indexMap.get(curIndex);
                String[] positions = position.split(",");
                MnsDisposalColumnInfo colInfo = (MnsDisposalColumnInfo)this.disposalMnsColumnColl.get(Integer.valueOf(positions[0]));
                int itemRowIndex = Integer.valueOf(positions[1]);
                if (isDebug && colInfo.col >= 0) {
                    this.sheetData.put(new Point(colInfo.col, itemRowIndex), "=" + (String)formulas.get(curIndex));
                    continue;
                }
                try {
                    value = new BigDecimal((String)values.get(curIndex));
                }
                catch (Throwable e) {
                    String result = "calc formula:" + (String)formulas.get(curIndex) + " error,resule:" + (String)values.get(curIndex);
                    logger.error((Object)result, e);
                    if (colInfo.col < 0) continue;
                    this.sheetData.put(new Point(colInfo.col, itemRowIndex), (String)values.get(curIndex) + "formula:" + (String)formulas.get(curIndex));
                    continue;
                }
                if (value == null) continue;
                if (colInfo.col >= 0) {
                    this.putMnsData(value, colInfo.col, itemRowIndex);
                    this.putMnsSumOrCslData(colInfo.calcKey, value, itemRowIndex, this.sumMnsColumnColl, this.dataType_AdjustTypeColl.get(2));
                    if (colInfo.calcKey.dataElementNumber.equals("BEGINBALANCE") && !this.mnsRptCalcParam.isSupportCrossMerger() && !this.mnsRptCalcParam.getMnsRptCalcParam().isCalcCslBeginByCurPeriodBegin() || colInfo.calcKey.dataElementNumber.equals("YTBEGIN")) continue;
                    if (!(colInfo.calcKey.dataElementNumber.equals("YTDAMOUNT") && this.mnsRptCalcParam.getMnsRptCalcParam().getDataElementRelating() == 2 || colInfo.calcKey.dataElementNumber.equals("AMOUNT") && this.mnsRptCalcParam.getMnsRptCalcParam().getDataElementRelating() == 1)) {
                        this.putMnsSumOrCslData(colInfo.calcKey, value, itemRowIndex, this.cslMnsColumnColl, this.dataType_AdjustTypeColl.get(3));
                    }
                }
                if (StringUtils.isEmpty((String)colInfo.getDataElementRelating())) continue;
                MnsCalcKey calcKey = new MnsCalcKey();
                calcKey.dataElementNumber = colInfo.getDataElementRelating();
                calcKey.valueType = colInfo.calcKey.valueType;
                this.putMnsSumOrCslData(calcKey, value, itemRowIndex, this.cslMnsColumnColl, this.dataType_AdjustTypeColl.get(3));
            }
        }
    }

    public void putMnsSumOrCslData(MnsCalcKey calcKey, BigDecimal disposalValue, int itemRowIndex, MnsColumnCollection sumOrCslMnsColumnColl, Map<Integer, MnsColumnCollection> adjustMap) {
        if (this.sheetData != null && itemRowIndex >= 0) {
            if (adjustMap != null) {
                MnsColumnCollection adjustBeforeColl = adjustMap.get(11);
                MnsColumnCollection adjustAfterColl = adjustMap.get(12);
                if (adjustBeforeColl != null) {
                    this.putMnsSumOrCslData(calcKey, disposalValue, itemRowIndex, adjustBeforeColl);
                }
                if (adjustAfterColl != null) {
                    this.putMnsSumOrCslData(calcKey, disposalValue, itemRowIndex, adjustAfterColl);
                }
            } else {
                this.putMnsSumOrCslData(calcKey, disposalValue, itemRowIndex, sumOrCslMnsColumnColl);
            }
        }
    }

    public void putMnsSumOrCslData(MnsCalcKey calcKey, BigDecimal disposalValue, int itemRowIndex, MnsColumnCollection sumOrCslMnsColumnColl) {
        MnsColumnInfo sumOrCslColumnInfo;
        if (this.sheetData != null && itemRowIndex >= 0 && (sumOrCslColumnInfo = this.getSumOrCslColumnInfo(sumOrCslMnsColumnColl, calcKey)) != null && sumOrCslColumnInfo.col >= 0 && disposalValue != null && disposalValue.compareTo(CslConstant.BGZERO) != 0) {
            Point position = new Point(sumOrCslColumnInfo.col, itemRowIndex);
            Object sumOrCslValue = this.sheetData.get(position);
            if (sumOrCslValue == null) {
                sumOrCslValue = BigDecimal.ZERO;
            }
            if (sumOrCslValue instanceof BigDecimal) {
                this.sheetData.put(position, disposalValue.add((BigDecimal)sumOrCslValue));
            }
        }
    }

    private MnsColumnInfo getSumOrCslColumnInfo(MnsColumnCollection sumOrCslColColl, MnsCalcKey calcKey) {
        int count = sumOrCslColColl.size();
        MnsColumnInfo columnInfo = null;
        for (int i = 0; i < count; ++i) {
            columnInfo = sumOrCslColColl.get(i);
            if (!calcKey.equals((Object)columnInfo.calcKey)) continue;
            return columnInfo;
        }
        return null;
    }

    public Map<String, String> getCalcFormulas(Map<String, String> varFormulas) {
        HashMap<String, String> formulaMap = new HashMap<String, String>();
        for (int i = 0; i < this.disposalMnsColumnColl.size(); ++i) {
            MnsDisposalColumnInfo colInfo = (MnsDisposalColumnInfo)this.disposalMnsColumnColl.get(i);
            String formula = varFormulas.get(colInfo.calcKey.dataElementNumber);
            if (StringUtils.isEmpty((String)formula)) continue;
            formula = StringUtil.replaceAll((String)formula, (String)"@disposeComNum", (String)colInfo.getCompanyNumber());
            formula = StringUtil.replaceAll((String)formula, (String)"@sourceType", (String)(colInfo.isUnion() ? "CONSOLIDATION" : "COMMITREPORT"));
            for (Object itemNumber : this.itemRows.keySet()) {
                String curFormula = StringUtil.replaceAll((String)formula, (String)"@itemNumber", (String)((String)itemNumber));
                formulaMap.put(i + "," + this.itemRows.get(itemNumber), curFormula);
            }
        }
        return formulaMap;
    }

    public Map<String, String> getVarFormulas() throws Exception {
        HashMap<String, String> varFormulaMap = new HashMap<String, String>();
        HashSet<String> dateElementNumbers = new HashSet<String>();
        for (int i = 0; i < this.disposalMnsColumnColl.size(); ++i) {
            dateElementNumbers.add(this.disposalMnsColumnColl.get((int)i).calcKey.dataElementNumber);
        }
        if (!dateElementNumbers.isEmpty()) {
            Map<String, String> commonVars = this.initFormualCommonVarMap();
            Map<String, String> formulaMap = SameControlUtil.getDisposalFormulas(this.ctx, dateElementNumbers);
            for (String dateElementNumber : formulaMap.keySet()) {
                String formula = formulaMap.get(dateElementNumber);
                for (String var : commonVars.keySet()) {
                    formula = StringUtil.replaceAll((String)formula, (String)var, (String)commonVars.get(var));
                }
                try {
                    Expression stmt = ExcelFormulaPaserHelper.parse((String)formula);
                    formula = this.fillVarFormulas(stmt).toString();
                }
                catch (Throwable ex) {
                    logger.error((Object)"formula error.", ex);
                    formula = ex.getMessage();
                }
                for (String var : commonVars.keySet()) {
                    if (StringUtils.isEmpty((String)formula)) continue;
                    formula = StringUtil.replaceAll((String)formula, (String)var, (String)commonVars.get(var));
                }
                varFormulaMap.put(dateElementNumber, formula);
            }
            formulaMap.clear();
        }
        return varFormulaMap;
    }

    public Expression fillVarFormulas(Expression stmt) throws Exception {
        if (stmt instanceof FunctionExpr) {
            String funName = ((FunctionExpr)stmt).funcionName;
            List parameters = ((FunctionExpr)stmt).parameters;
            for (Object parameter : parameters) {
                if (parameter == null || !(parameter instanceof Expression)) continue;
                this.fillVarFormulas((Expression)parameter);
            }
            if (funName.equalsIgnoreCase("AcctItem")) {
                stmt = MnsRptCalcDisposalData.fillAcctItem((FunctionExpr)stmt);
            } else if (funName.equalsIgnoreCase("DisposeDate")) {
                stmt = MnsRptCalcDisposalData.fillDisposalDate((FunctionExpr)stmt);
            }
        } else if (stmt instanceof BinaryOperationExpr) {
            Expression expr = this.fillVarFormulas(((BinaryOperationExpr)stmt).left);
            if (expr == null) {
                return null;
            }
            ((BinaryOperationExpr)stmt).left = expr;
            expr = this.fillVarFormulas(((BinaryOperationExpr)stmt).right);
            if (expr == null) {
                return null;
            }
            ((BinaryOperationExpr)stmt).right = expr;
        } else if (stmt instanceof UnaryOperationExpr) {
            Expression expr = this.fillVarFormulas(((UnaryOperationExpr)stmt).operand);
            if (expr == null) {
                return null;
            }
            ((UnaryOperationExpr)stmt).operand = expr;
        }
        return stmt;
    }

    public static FunctionExpr fillAcctItem(FunctionExpr expr) throws BOSException {
        StringExpr se;
        ArrayList para = new ArrayList();
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(0))) {
            para.add(expr.parameters.get(0));
        } else {
            se = new StringExpr("@orgTreeNumber");
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            se = new StringExpr("@disposeComNum");
            para.add(se);
        }
        para.add(expr.parameters.get(2));
        para.add(expr.parameters.get(3));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(4))) {
            para.add(expr.parameters.get(4));
        } else {
            se = new StringExpr("@itemNumber");
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(5))) {
            para.add(expr.parameters.get(5));
        } else {
            se = new StringExpr("@itemNumber");
            para.add(se);
        }
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(6))) {
            para.add(expr.parameters.get(6));
        } else {
            se = new StringExpr("@periodType");
            para.add(se);
        }
        para.add(expr.parameters.get(7));
        para.add(expr.parameters.get(8));
        para.add(expr.parameters.get(9));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(10))) {
            para.add(expr.parameters.get(10));
        } else {
            se = new StringExpr("@sourceType");
            para.add(se);
        }
        para.add(expr.parameters.get(11));
        para.add(expr.parameters.get(12));
        para.add(expr.parameters.get(13));
        if (expr.parameters.size() > 14) {
            para.add(expr.parameters.get(14));
        }
        if (expr.parameters.size() > 15) {
            para.add(expr.parameters.get(15));
        }
        if (expr.parameters.size() > 16) {
            para.add(expr.parameters.get(16));
        }
        expr.parameters = para;
        return expr;
    }

    public static FunctionExpr fillDisposalDate(FunctionExpr expr) throws BOSException {
        ArrayList para = new ArrayList();
        para.add(expr.parameters.get(0));
        if (FormulaUtil.hasDispenseParameter(expr.parameters.get(1))) {
            para.add(expr.parameters.get(1));
        } else {
            StringExpr se = new StringExpr("@disposeComNum");
            para.add(se);
        }
        para.add(expr.parameters.get(2));
        para.add(expr.parameters.get(3));
        para.add(expr.parameters.get(4));
        para.add(expr.parameters.get(5));
        expr.parameters = para;
        return expr;
    }

    public Map<String, String> initFormualCommonVarMap() {
        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
        vars.put("@year", String.valueOf(this.mnsRptCalcParam.getReport().getYear()));
        vars.put("@periodType", this.mnsRptCalcParam.getReport().getPeriodType().getName());
        vars.put("@period", String.valueOf(this.mnsRptCalcParam.getReport().getPeriod()));
        vars.put("@orgTreeNumber", this.mnsRptCalcParam.getReport().getOrgTree().getNumber());
        vars.put("@orgUnitNumber", this.mnsRptCalcParam.getReport().getOrgUnit().getNumber());
        return vars;
    }
}

