/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.samecontrol.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.samecontrol.app.formula.DisposalDateInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.batch.AbstractCalculator;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DisposalDateBatchCalculator
extends AbstractCalculator {
    public static final Logger logger = Logger.getLogger(DisposalDateBatchCalculator.class);
    private Map<String, Map<String, List<DisposalDateInfo>>> formulas = new HashMap<String, Map<String, List<DisposalDateInfo>>>();
    private Map<String, SimpleDateFormat> dateFormats = new HashMap<String, SimpleDateFormat>();

    public DisposalDateBatchCalculator(ICalculateContextProvider context, Context serverCtx) {
        super(context, serverCtx);
    }

    protected void clear() {
    }

    protected void calculate() throws BOSException, EASBizException {
        for (String stateKey : this.formulas.keySet()) {
            Map<String, List<DisposalDateInfo>> disposalDateMap = this.formulas.get(stateKey);
            if (disposalDateMap == null || disposalDateMap.isEmpty()) continue;
            if (disposalDateMap.size() > 2) {
                this.calculateByTmpTable(disposalDateMap);
            } else {
                this.calculateNotByTmpTable(disposalDateMap);
            }
            for (List<DisposalDateInfo> infos : disposalDateMap.values()) {
                for (DisposalDateInfo info : infos) {
                    if (info.getParameter().getValue() != null) continue;
                    info.getParameter().setValue((Object)"");
                }
            }
        }
    }

    private void calculateNotByTmpTable(Map<String, List<DisposalDateInfo>> disposalDateMap) throws BOSException, EASBizException {
        try {
            SQLBuilder sql = this.builderSql(null, disposalDateMap);
            this.calculate(sql, disposalDateMap);
        }
        catch (Exception ex) {
            logger.error((Object)"calculateByTmpTable", (Throwable)ex);
            this.setException(disposalDateMap, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateByTmpTable(Map<String, List<DisposalDateInfo>> disposalDateMap) throws BOSException, EASBizException {
        String tmpTable;
        TempTablePool tempTablePool;
        block7: {
            tempTablePool = null;
            tmpTable = null;
            try {
                tempTablePool = TempTablePool.getInstance((Context)this.serverContext);
                SQLBuilder sql = new SQLBuilder();
                sql.append("create table t_csl_disposaltmp(fCompanyNumber NVARCHAR(80),forgUnitNumber NVARCHAR(80))");
                tmpTable = tempTablePool.createTempTable(sql.toString());
                if (tmpTable == null) break block7;
                this.insertTmpTable(tmpTable, disposalDateMap);
                sql = this.builderSql(tmpTable, disposalDateMap);
                this.calculate(sql, disposalDateMap);
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"calculateByTmpTable", (Throwable)ex);
                    this.setException(disposalDateMap, ex);
                }
                catch (Throwable throwable) {
                    if (!StringUtils.isEmpty(tmpTable) && tempTablePool != null && !DebugLogger.isDebug) {
                        tempTablePool.releaseTable(tmpTable);
                    }
                    throw throwable;
                }
                if (!StringUtils.isEmpty(tmpTable) && tempTablePool != null && !DebugLogger.isDebug) {
                    tempTablePool.releaseTable(tmpTable);
                }
            }
        }
        if (!StringUtils.isEmpty((String)tmpTable) && tempTablePool != null && !DebugLogger.isDebug) {
            tempTablePool.releaseTable(tmpTable);
        }
    }

    private void setException(Map<String, List<DisposalDateInfo>> disposalDateMap, Exception ex) {
        for (List<DisposalDateInfo> disposalDates : disposalDateMap.values()) {
            for (DisposalDateInfo disposalDate : disposalDates) {
                FormulaValueBackfill.setException((Parameter)disposalDate.getParameter(), (Throwable)ex);
            }
        }
    }

    private void calculate(SQLBuilder sql, Map<String, List<DisposalDateInfo>> disposalDateMap) throws BOSException, EASBizException {
        try {
            if (sql != null) {
                IRowSet rowSet = DbUtil.executeQuery(this.serverContext, sql.getSQL(), sql.getParams());
                String formulaKey = null;
                while (rowSet.next()) {
                    formulaKey = rowSet.getString("forgUnitNumber") + rowSet.getString("fcompanyNumber");
                    List<DisposalDateInfo> infos = disposalDateMap.get(formulaKey);
                    if (infos == null || infos.isEmpty()) continue;
                    Date date = rowSet.getDate("fdate");
                    for (DisposalDateInfo info : infos) {
                        try {
                            Object value = null;
                            if (info.dateFormat.equalsIgnoreCase("PERIOD")) {
                                int periodType = this.batchHelper.getReport_PeriodType();
                                if (periodType >= 0) {
                                    int[] period = RPTDateUtil.getPeriod((java.util.Date)date, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType));
                                    value = period[1];
                                }
                            } else {
                                SimpleDateFormat formate = this.dateFormats.get(info.dateFormat);
                                if (formate == null) {
                                    formate = new SimpleDateFormat(info.dateFormat);
                                    this.dateFormats.put(info.dateFormat, formate);
                                }
                                value = formate.format(date);
                            }
                            if (value == null) continue;
                            info.getParameter().setValue(value);
                        }
                        catch (Exception ex) {
                            FormulaValueBackfill.setException((Parameter)info.getParameter(), (Throwable)ex);
                            logger.error((Object)"calculate error.", (Throwable)ex);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"calculate error.", (Throwable)e);
            throw new BOSException("calculate error.", (Throwable)e);
        }
    }

    private void insertTmpTable(String tmpTable, Map<String, List<DisposalDateInfo>> disposalDateMap) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tmpTable).append("(fCompanyNumber,forgUnitNumber) values(?,?)");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (List<DisposalDateInfo> infos : disposalDateMap.values()) {
            params.add(new Object[]{infos.get((int)0).companyNumber, infos.get((int)0).orgUnitNumber});
        }
        DbUtil.executeBatch(this.serverContext, sql.toString(), params);
    }

    private SQLBuilder builderSql(String tmpTable, Map<String, List<DisposalDateInfo>> disposalDateMap) {
        if (disposalDateMap != null && !disposalDateMap.isEmpty()) {
            SQLBuilder sql = new SQLBuilder();
            DisposalDateInfo info = disposalDateMap.values().iterator().next().get(0);
            boolean isByTmpTable = !StringUtils.isEmpty((String)tmpTable);
            sql.reset();
            sql.append("select max(cslOrg.fdate) fdate,company.fnumber fcompanyNumber,orgunit.fnumber forgUnitNumber from T_Csl_CslOrgUnit cslOrg ");
            sql.append(" inner join t_org_tree tree on tree.fid=cslOrg.FOrgTreeId ");
            sql.append(" inner join t_org_baseunit company on company.fid=cslOrg.fcompanyid ");
            sql.append(" inner join t_org_baseunit orgunit on orgunit.fid=cslOrg.fdisposalOrgUnitId ");
            if (isByTmpTable) {
                sql.append(" inner join ").append(tmpTable).append(" tmp on tmp.fCompanyNumber=company.fnumber and tmp.forgUnitNumber=orgunit.fnumber ");
            }
            sql.append(" where tree.fnumber=?", info.orgTreeNumber);
            sql.append(" and cslOrg.fyear=?", info.year);
            sql.append(" and cslOrg.fperiod<=?", info.period);
            if (!isByTmpTable) {
                sql.append(" and (");
                boolean isFirst = true;
                for (List<DisposalDateInfo> infos : disposalDateMap.values()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sql.append(" or ");
                    }
                    sql.append(" company.fnumber=? ", infos.get((int)0).companyNumber);
                    sql.append(" and orgunit.fnumber=? ", infos.get((int)0).orgUnitNumber);
                }
                sql.append(") ");
            }
            sql.append(" group by company.fnumber,orgunit.fnumber");
            return sql;
        }
        return null;
    }

    protected void init(SortedParameterArray params) throws BOSException, EASBizException {
        HashMap orgTreeMap = new HashMap();
        int count = params.size();
        for (int i = 0; i < count; ++i) {
            List<DisposalDateInfo> infos;
            DisposalDateInfo disposalDate = new DisposalDateInfo(params.getParameter(i), this.batchHelper, orgTreeMap);
            if (disposalDate.isException()) {
                this.addToErrorList(disposalDate);
                continue;
            }
            if (disposalDate.isValueNull) {
                disposalDate.getParameter().setValue((Object)"");
                continue;
            }
            String stateKey = disposalDate.getStateKey();
            Map<String, List<DisposalDateInfo>> infoMap = this.formulas.get(stateKey);
            if (infoMap == null) {
                infoMap = new HashMap<String, List<DisposalDateInfo>>();
                this.formulas.put(stateKey, infoMap);
            }
            if ((infos = infoMap.get(disposalDate.getFormulaKey())) == null) {
                infos = new ArrayList<DisposalDateInfo>();
                infoMap.put(disposalDate.getFormulaKey(), infos);
            }
            infos.add(disposalDate);
        }
    }
}

